// Scilab ( https://www.scilab.org/ ) - This file is part of Scilab
// Copyright (C) 2011 - DIGITEO
//
// Copyright (C) 2012 - 2016 - Scilab Enterprises
//
// This file is hereby licensed under the terms of the GNU GPL v2.0,
// pursuant to article 5.3.4 of the CeCILL v.2.1.
// This file was originally licensed under the terms of the CeCILL v2.1,
// and continues to be available under such terms.
// For more information, see the COPYING file which you should have received
// along with this program.

test_path = SCI + "/modules/signal_processing/tests/unit_tests/";

[fact,b2,b1,b0,c1,c0,zzeros,zpoles]=syredi(1,4,[2*%pi/10,4*%pi/10,0,0],0.02,0.001);
ref_fact = 0.005976;
assert_checkfalse(norm(fact-ref_fact) > 0.0000037);
assert_checkequal(b2, [1 1 1]);
assert_checkequal(size(b1), [1 3]);
assert_checkequal(b1(3), 1);
assert_checkequal(b0, [1 1 0]);
assert_checkequal(size(c1), [1 3]);
assert_checkequal(size(c0), [1 3]);
assert_checkequal(c0(3),  0);
assert_checkequal(size(zzeros), [1 5]);
assert_checkequal(size(zpoles), [1 5]);

load(test_path+"syredi.h5");
[fact1, b21, b11, b01, c11, c01, zzeros1, zpoles1] = syredi(1, 4, [1, 2, 0, 0], 0.02, 0.001);
assert_checkalmostequal(fact1, fact1_ref, 3e-16);
assert_checkequal(b21, b21_ref);
assert_checkalmostequal(b11, b11_ref);
assert_checkequal(b01, b01_ref);
assert_checkalmostequal(c11, c11_ref);
assert_checkalmostequal(c01, c01_ref, [], %eps);
assert_checkalmostequal(zzeros1, zzeros1_ref);
assert_checkalmostequal(zpoles1, zpoles1_ref);

[fact2, b22, b12, b02, c12, c02, zzeros2, zpoles2] = syredi(3, 4, [1, 2, 3, 3.01], 0.1, 0.001);
assert_checkalmostequal(fact2, fact2_ref);
assert_checkequal(b22, b22_ref);
assert_checkalmostequal(b12, b12_ref);
assert_checkequal(b02, b02_ref);
assert_checkalmostequal(c12, c12_ref);
assert_checkalmostequal(c02, c02_ref);
assert_checkalmostequal(zzeros2, zzeros2_ref);
assert_checkalmostequal(zpoles2, zpoles2_ref);

