/*
 * Decompiled with CFR 0.152.
 */
package vtk;

import java.io.File;
import vtk.vtkFileOutputWindow;

public enum vtkNativeLibrary {
    vtkViewsInfovis("vtkViewsInfovisJava"),
    vtkCommonColor("vtkCommonColorJava"),
    vtkViewsContext2D("vtkViewsContext2DJava"),
    vtkViewsCore("vtkViewsCoreJava"),
    vtkTestingRendering("vtkTestingRenderingJava"),
    vtkPythonContext2D("vtkPythonContext2DJava"),
    vtkRenderingLabel("vtkRenderingLabelJava"),
    vtkRenderingLOD("vtkRenderingLODJava"),
    vtkRenderingLICOpenGL2("vtkRenderingLICOpenGL2Java"),
    vtkRenderingImage("vtkRenderingImageJava"),
    vtkRenderingGridAxes("vtkRenderingGridAxesJava"),
    vtkRenderingContextOpenGL2("vtkRenderingContextOpenGL2Java"),
    vtkRenderingCellGrid("vtkRenderingCellGridJava"),
    vtkRenderingVolumeOpenGL2("vtkRenderingVolumeOpenGL2Java"),
    vtkIOVeraOut("vtkIOVeraOutJava"),
    vtkIOTecplotTable("vtkIOTecplotTableJava"),
    vtkIOSegY("vtkIOSegYJava"),
    vtkIOParallelXML("vtkIOParallelXMLJava"),
    vtkIOPLY("vtkIOPLYJava"),
    vtkIOOggTheora("vtkIOOggTheoraJava"),
    vtkIONetCDF("vtkIONetCDFJava"),
    vtkIOMotionFX("vtkIOMotionFXJava"),
    vtkIOParallel("vtkIOParallelJava"),
    vtkIOMINC("vtkIOMINCJava"),
    vtkIOLSDyna("vtkIOLSDynaJava"),
    vtkIOLANLX3D("vtkIOLANLX3DJava"),
    vtkIOImport("vtkIOImportJava"),
    vtkIOIOSS("vtkIOIOSSJava"),
    vtkIOHDF("vtkIOHDFJava"),
    vtkIOFLUENTCFF("vtkIOFLUENTCFFJava"),
    vtkIOVideo("vtkIOVideoJava"),
    vtkIOMovie("vtkIOMovieJava"),
    vtkIOFDS("vtkIOFDSJava"),
    vtkIOInfovis("vtkIOInfovisJava"),
    vtkIOExportPDF("vtkIOExportPDFJava"),
    vtkIOExportGL2PS("vtkIOExportGL2PSJava"),
    vtkRenderingGL2PSOpenGL2("vtkRenderingGL2PSOpenGL2Java"),
    vtkIOExodus("vtkIOExodusJava"),
    vtkIOEngys("vtkIOEngysJava"),
    vtkIOEnSight("vtkIOEnSightJava"),
    vtkIOERF("vtkIOERFJava"),
    vtkIOCityGML("vtkIOCityGMLJava"),
    vtkIOChemistry("vtkIOChemistryJava"),
    vtkIOCesium3DTiles("vtkIOCesium3DTilesJava"),
    vtkIOCONVERGECFD("vtkIOCONVERGECFDJava"),
    vtkIOCGNSReader("vtkIOCGNSReaderJava"),
    vtkIOAsynchronous("vtkIOAsynchronousJava"),
    vtkIOExport("vtkIOExportJava"),
    vtkRenderingVtkJS("vtkRenderingVtkJSJava"),
    vtkIOGeometry("vtkIOGeometryJava"),
    vtkRenderingSceneGraph("vtkRenderingSceneGraphJava"),
    vtkIOAMR("vtkIOAMRJava"),
    vtkInteractionImage("vtkInteractionImageJava"),
    vtkInfovisLayout("vtkInfovisLayoutJava"),
    vtkImagingStencil("vtkImagingStencilJava"),
    vtkImagingStatistics("vtkImagingStatisticsJava"),
    vtkImagingMorphological("vtkImagingMorphologicalJava"),
    vtkImagingMath("vtkImagingMathJava"),
    vtkImagingFourier("vtkImagingFourierJava"),
    vtkIOSQL("vtkIOSQLJava"),
    vtkInteractionWidgets("vtkInteractionWidgetsJava"),
    vtkRenderingVolume("vtkRenderingVolumeJava"),
    vtkRenderingAnnotation("vtkRenderingAnnotationJava"),
    vtkInteractionStyle("vtkInteractionStyleJava"),
    vtkImagingHybrid("vtkImagingHybridJava"),
    vtkImagingColor("vtkImagingColorJava"),
    vtkGeovisCore("vtkGeovisCoreJava"),
    vtkFiltersTopology("vtkFiltersTopologyJava"),
    vtkFiltersTensor("vtkFiltersTensorJava"),
    vtkFiltersSelection("vtkFiltersSelectionJava"),
    vtkFiltersSMP("vtkFiltersSMPJava"),
    vtkFiltersPython("vtkFiltersPythonJava"),
    vtkFiltersProgrammable("vtkFiltersProgrammableJava"),
    vtkFiltersPoints("vtkFiltersPointsJava"),
    vtkFiltersParallelImaging("vtkFiltersParallelImagingJava"),
    vtkFiltersTemporal("vtkFiltersTemporalJava"),
    vtkFiltersImaging("vtkFiltersImagingJava"),
    vtkImagingGeneral("vtkImagingGeneralJava"),
    vtkFiltersGeometryPreview("vtkFiltersGeometryPreviewJava"),
    vtkFiltersGeneric("vtkFiltersGenericJava"),
    vtkFiltersFlowPaths("vtkFiltersFlowPathsJava"),
    vtkFiltersAMR("vtkFiltersAMRJava"),
    vtkFiltersParallel("vtkFiltersParallelJava"),
    vtkFiltersTexture("vtkFiltersTextureJava"),
    vtkFiltersModeling("vtkFiltersModelingJava"),
    vtkDomainsChemistryOpenGL2("vtkDomainsChemistryOpenGL2Java"),
    vtkRenderingOpenGL2("vtkRenderingOpenGL2Java"),
    vtkRenderingHyperTreeGrid("vtkRenderingHyperTreeGridJava"),
    vtkRenderingUI("vtkRenderingUIJava"),
    vtkFiltersHybrid("vtkFiltersHybridJava"),
    vtkDomainsChemistry("vtkDomainsChemistryJava"),
    vtkCommonPython("vtkCommonPythonJava"),
    vtkChartsCore("vtkChartsCoreJava"),
    vtkInfovisCore("vtkInfovisCoreJava"),
    vtkFiltersExtraction("vtkFiltersExtractionJava"),
    vtkIOXML("vtkIOXMLJava"),
    vtkIOXMLParser("vtkIOXMLParserJava"),
    vtkParallelCore("vtkParallelCoreJava"),
    vtkIOLegacy("vtkIOLegacyJava"),
    vtkIOCellGrid("vtkIOCellGridJava"),
    vtkFiltersCellGrid("vtkFiltersCellGridJava"),
    vtkIOCore("vtkIOCoreJava"),
    vtkFiltersStatistics("vtkFiltersStatisticsJava"),
    vtkFiltersHyperTree("vtkFiltersHyperTreeJava"),
    vtkImagingSources("vtkImagingSourcesJava"),
    vtkIOImage("vtkIOImageJava"),
    vtkRenderingContext2D("vtkRenderingContext2DJava"),
    vtkRenderingFreeType("vtkRenderingFreeTypeJava"),
    vtkRenderingCore("vtkRenderingCoreJava"),
    vtkFiltersSources("vtkFiltersSourcesJava"),
    vtkImagingCore("vtkImagingCoreJava"),
    vtkFiltersGeneral("vtkFiltersGeneralJava"),
    vtkFiltersVerdict("vtkFiltersVerdictJava"),
    vtkFiltersGeometry("vtkFiltersGeometryJava"),
    vtkCommonComputationalGeometry("vtkCommonComputationalGeometryJava"),
    vtkFiltersCore("vtkFiltersCoreJava"),
    vtkFiltersReduction("vtkFiltersReductionJava"),
    vtkCommonExecutionModel("vtkCommonExecutionModelJava"),
    vtkCommonDataModel("vtkCommonDataModelJava"),
    vtkCommonSystem("vtkCommonSystemJava"),
    vtkCommonMisc("vtkCommonMiscJava"),
    vtkCommonTransforms("vtkCommonTransformsJava"),
    vtkCommonMath("vtkCommonMathJava"),
    vtkCommonCore("vtkCommonCoreJava");

    private String nativeLibraryName;
    private boolean loaded;

    public static boolean LoadAllNativeLibraries() {
        boolean bl = true;
        for (vtkNativeLibrary vtkNativeLibrary2 : vtkNativeLibrary.values()) {
            try {
                vtkNativeLibrary2.LoadLibrary();
            }
            catch (UnsatisfiedLinkError unsatisfiedLinkError) {
                bl = false;
                unsatisfiedLinkError.printStackTrace();
            }
        }
        return bl;
    }

    public static void LoadNativeLibraries(vtkNativeLibrary ... vtkNativeLibraryArray) {
        for (vtkNativeLibrary vtkNativeLibrary2 : vtkNativeLibraryArray) {
            vtkNativeLibrary2.LoadLibrary();
        }
    }

    public static void DisableOutputWindow(File file) {
        if (file == null) {
            file = new File("vtkError.txt");
        }
        vtkFileOutputWindow vtkFileOutputWindow2 = new vtkFileOutputWindow();
        vtkFileOutputWindow2.SetFileName(file.getAbsolutePath());
        vtkFileOutputWindow2.SetInstance(vtkFileOutputWindow2);
    }

    private vtkNativeLibrary(String string2) {
        this.nativeLibraryName = string2;
        this.loaded = false;
    }

    public void LoadLibrary() throws UnsatisfiedLinkError {
        if (!this.loaded) {
            if (System.getProperty("vtk.lib.dir") != null) {
                File file = new File(System.getProperty("vtk.lib.dir"));
                vtkNativeLibrary.patchJavaLibraryPath(file.getAbsolutePath());
                File file2 = new File(file, System.mapLibraryName(this.nativeLibraryName));
                if (file2.exists()) {
                    try {
                        Runtime.getRuntime().load(file2.getAbsolutePath());
                        this.loaded = true;
                        return;
                    }
                    catch (UnsatisfiedLinkError unsatisfiedLinkError) {
                        unsatisfiedLinkError.printStackTrace();
                    }
                }
            }
            System.loadLibrary(this.nativeLibraryName);
        }
        this.loaded = true;
    }

    public boolean IsLoaded() {
        return this.loaded;
    }

    public String GetLibraryName() {
        return this.nativeLibraryName;
    }

    private static void patchJavaLibraryPath(String string) {
        if (string != null) {
            String string2 = System.getProperty("path.separator");
            String string3 = System.getProperty("java.library.path");
            if (!string3.contains(string)) {
                string3 = string3 + string2 + string;
                System.setProperty("java.library.path", string3);
            }
        }
    }
}

