/****************************************************************************
 *   Copyright (C) 2009 by Björn Ruberg <bjoern@ruberg-wegener.de>         *
 *                                                                         *
 *   This program is free software); you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation); either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY); without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program); if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA .        *
 ***************************************************************************/

#ifndef HELPERS_H
#define HELPERS_H

#include <QChar>
#include <QString>
#include <QVarLengthArray>
#include <qx11info_x11.h>
#include <X11/Xlib.h>
#include <X11/extensions/XTest.h>

class Helpers {
public:

    static void changeKeycodeMapping(unsigned int code, QString &sym){
        KeySym keysym = XStringToKeysym(sym.toAscii());
        QVarLengthArray<KeySym> keysyms(keysymsPerKeycode);
        for(int i = 0; i < keysymsPerKeycode; i++){
            keysyms[i] = keysym;
        }
        XChangeKeyboardMapping(QX11Info::display(), code, keysymsPerKeycode, keysyms.data(), 1);
        XSync(QX11Info::display(), False);
    }

    static void changeKeycodeMapping(unsigned int code, QString &sym, QString &shiftedSym){
        KeySym keysym = XStringToKeysym(sym.toAscii());
        QVarLengthArray<KeySym> keysyms(keysymsPerKeycode);
        for(int i = 0; i < keysymsPerKeycode; i++){
            keysyms[i] = keysym;
        }
        keysyms[1] = XStringToKeysym(shiftedSym.toAscii());
        XChangeKeyboardMapping(QX11Info::display(), code, keysymsPerKeycode, keysyms.data(), 1);
        XSync(QX11Info::display(), False);
    }

    static void changeKeycodeMapping(unsigned int code, KeySym* keysyms){
        XChangeKeyboardMapping(QX11Info::display(), code, keysymsPerKeycode, keysyms, 1);
        XSync(QX11Info::display(), False);
    }

    static KeySym *getKeycodeMapping(unsigned int code){
        return XGetKeyboardMapping(QX11Info::display(), code, 1, &keysymsPerKeycode);
    }



    static unsigned int keycodeToKeysym(const unsigned int &code, int level){
#ifdef Q_WS_X11
        return (unsigned int)XKeycodeToKeysym(QX11Info::display(), code, level);
#else
        return 0;
#endif
    }

    static unsigned int keysymToKeycode(const unsigned int &code){
#ifdef Q_WS_X11
        return ((unsigned int) XKeysymToKeycode(QX11Info::display(), code));
#else
        return 0;
#endif
    }

    static void fakeKeyPress(const unsigned int &code){
#ifdef Q_WS_X11
        XTestFakeKeyEvent(QX11Info::display(), code, true, 0);
        XSync(QX11Info::display(), False);
#endif
    }
    static void fakeKeyRelease(const unsigned int &code){
#ifdef Q_WS_X11
        XTestFakeKeyEvent(QX11Info::display(), code, false, 0);
        XSync(QX11Info::display(), False);
#endif
    }

    static QChar mapXtoUTF8[0xffff+1];
    static int keysymsPerKeycode;
    // what follows is a long and ugly list of mappings

    static QChar mapToUnicode(const unsigned int &keysym){

        /*if(keysym >= 0xffff){
			return 0;
		}*/

        return mapXtoUTF8[keysym % 0xffff];
    }


    static void buildUp(){

        mapXtoUTF8[0x0020]=QChar(0x0020);
        mapXtoUTF8[0x0021]=QChar(0x0021);
        mapXtoUTF8[0x0022]=QChar(0x0022);
        mapXtoUTF8[0x0023]=QChar(0x0023);
        mapXtoUTF8[0x0024]=QChar(0x0024);
        mapXtoUTF8[0x0025]=QChar(0x0025);
        mapXtoUTF8[0x0026]=QChar(0x0026);
        mapXtoUTF8[0x0027]=QChar(0x0027);
        mapXtoUTF8[0x0027]=QChar(0x0027);
        mapXtoUTF8[0x0028]=QChar(0x0028);
        mapXtoUTF8[0x0029]=QChar(0x0029);
        mapXtoUTF8[0x002a]=QChar(0x002a);
        mapXtoUTF8[0x002b]=QChar(0x002b);
        mapXtoUTF8[0x002c]=QChar(0x002c);
        mapXtoUTF8[0x002d]=QChar(0x002d);
        mapXtoUTF8[0x002e]=QChar(0x002e);
        mapXtoUTF8[0x002f]=QChar(0x002f);
        mapXtoUTF8[0x0030]=QChar(0x0030);
        mapXtoUTF8[0x0031]=QChar(0x0031);
        mapXtoUTF8[0x0032]=QChar(0x0032);
        mapXtoUTF8[0x0033]=QChar(0x0033);
        mapXtoUTF8[0x0034]=QChar(0x0034);
        mapXtoUTF8[0x0035]=QChar(0x0035);
        mapXtoUTF8[0x0036]=QChar(0x0036);
        mapXtoUTF8[0x0037]=QChar(0x0037);
        mapXtoUTF8[0x0038]=QChar(0x0038);
        mapXtoUTF8[0x0039]=QChar(0x0039);
        mapXtoUTF8[0x003a]=QChar(0x003a);
        mapXtoUTF8[0x003b]=QChar(0x003b);
        mapXtoUTF8[0x003c]=QChar(0x003c);
        mapXtoUTF8[0x003d]=QChar(0x003d);
        mapXtoUTF8[0x003e]=QChar(0x003e);
        mapXtoUTF8[0x003f]=QChar(0x003f);
        mapXtoUTF8[0x0040]=QChar(0x0040);
        mapXtoUTF8[0x0041]=QChar(0x0041);
        mapXtoUTF8[0x0042]=QChar(0x0042);
        mapXtoUTF8[0x0043]=QChar(0x0043);
        mapXtoUTF8[0x0044]=QChar(0x0044);
        mapXtoUTF8[0x0045]=QChar(0x0045);
        mapXtoUTF8[0x0046]=QChar(0x0046);
        mapXtoUTF8[0x0047]=QChar(0x0047);
        mapXtoUTF8[0x0048]=QChar(0x0048);
        mapXtoUTF8[0x0049]=QChar(0x0049);
        mapXtoUTF8[0x004a]=QChar(0x004a);
        mapXtoUTF8[0x004b]=QChar(0x004b);
        mapXtoUTF8[0x004c]=QChar(0x004c);
        mapXtoUTF8[0x004d]=QChar(0x004d);
        mapXtoUTF8[0x004e]=QChar(0x004e);
        mapXtoUTF8[0x004f]=QChar(0x004f);
        mapXtoUTF8[0x0050]=QChar(0x0050);
        mapXtoUTF8[0x0051]=QChar(0x0051);
        mapXtoUTF8[0x0052]=QChar(0x0052);
        mapXtoUTF8[0x0053]=QChar(0x0053);
        mapXtoUTF8[0x0054]=QChar(0x0054);
        mapXtoUTF8[0x0055]=QChar(0x0055);
        mapXtoUTF8[0x0056]=QChar(0x0056);
        mapXtoUTF8[0x0057]=QChar(0x0057);
        mapXtoUTF8[0x0058]=QChar(0x0058);
        mapXtoUTF8[0x0059]=QChar(0x0059);
        mapXtoUTF8[0x005a]=QChar(0x005a);
        mapXtoUTF8[0x005b]=QChar(0x005b);
        mapXtoUTF8[0x005c]=QChar(0x005c);
        mapXtoUTF8[0x005d]=QChar(0x005d);
        mapXtoUTF8[0x005e]=QChar(0x005e);
        mapXtoUTF8[0x005f]=QChar(0x005f);
        mapXtoUTF8[0x0060]=QChar(0x0060);
        mapXtoUTF8[0x0060]=QChar(0x0060);
        mapXtoUTF8[0x0061]=QChar(0x0061);
        mapXtoUTF8[0x0062]=QChar(0x0062);
        mapXtoUTF8[0x0063]=QChar(0x0063);
        mapXtoUTF8[0x0064]=QChar(0x0064);
        mapXtoUTF8[0x0065]=QChar(0x0065);
        mapXtoUTF8[0x0066]=QChar(0x0066);
        mapXtoUTF8[0x0067]=QChar(0x0067);
        mapXtoUTF8[0x0068]=QChar(0x0068);
        mapXtoUTF8[0x0069]=QChar(0x0069);
        mapXtoUTF8[0x006a]=QChar(0x006a);
        mapXtoUTF8[0x006b]=QChar(0x006b);
        mapXtoUTF8[0x006c]=QChar(0x006c);
        mapXtoUTF8[0x006d]=QChar(0x006d);
        mapXtoUTF8[0x006e]=QChar(0x006e);
        mapXtoUTF8[0x006f]=QChar(0x006f);
        mapXtoUTF8[0x0070]=QChar(0x0070);
        mapXtoUTF8[0x0071]=QChar(0x0071);
        mapXtoUTF8[0x0072]=QChar(0x0072);
        mapXtoUTF8[0x0073]=QChar(0x0073);
        mapXtoUTF8[0x0074]=QChar(0x0074);
        mapXtoUTF8[0x0075]=QChar(0x0075);
        mapXtoUTF8[0x0076]=QChar(0x0076);
        mapXtoUTF8[0x0077]=QChar(0x0077);
        mapXtoUTF8[0x0078]=QChar(0x0078);
        mapXtoUTF8[0x0079]=QChar(0x0079);
        mapXtoUTF8[0x007a]=QChar(0x007a);
        mapXtoUTF8[0x007b]=QChar(0x007b);
        mapXtoUTF8[0x007c]=QChar(0x007c);
        mapXtoUTF8[0x007d]=QChar(0x007d);
        mapXtoUTF8[0x007e]=QChar(0x007e);
        mapXtoUTF8[0x00a0]=QChar(0x00a0);
        mapXtoUTF8[0x00a1]=QChar(0x00a1);
        mapXtoUTF8[0x00a2]=QChar(0x00a2);
        mapXtoUTF8[0x00a3]=QChar(0x00a3);
        mapXtoUTF8[0x00a4]=QChar(0x00a4);
        mapXtoUTF8[0x00a5]=QChar(0x00a5);
        mapXtoUTF8[0x00a6]=QChar(0x00a6);
        mapXtoUTF8[0x00a7]=QChar(0x00a7);
        mapXtoUTF8[0x00a8]=QChar(0x00a8);
        mapXtoUTF8[0x00a9]=QChar(0x00a9);
        mapXtoUTF8[0x00aa]=QChar(0x00aa);
        mapXtoUTF8[0x00ab]=QChar(0x00ab);
        mapXtoUTF8[0x00ac]=QChar(0x00ac);
        mapXtoUTF8[0x00ad]=QChar(0x00ad);
        mapXtoUTF8[0x00ae]=QChar(0x00ae);
        mapXtoUTF8[0x00af]=QChar(0x00af);
        mapXtoUTF8[0x00b0]=QChar(0x00b0);
        mapXtoUTF8[0x00b1]=QChar(0x00b1);
        mapXtoUTF8[0x00b2]=QChar(0x00b2);
        mapXtoUTF8[0x00b3]=QChar(0x00b3);
        mapXtoUTF8[0x00b4]=QChar(0x00b4);
        mapXtoUTF8[0x00b5]=QChar(0x00b5);
        mapXtoUTF8[0x00b6]=QChar(0x00b6);
        mapXtoUTF8[0x00b7]=QChar(0x00b7);
        mapXtoUTF8[0x00b8]=QChar(0x00b8);
        mapXtoUTF8[0x00b9]=QChar(0x00b9);
        mapXtoUTF8[0x00ba]=QChar(0x00ba);
        mapXtoUTF8[0x00bb]=QChar(0x00bb);
        mapXtoUTF8[0x00bc]=QChar(0x00bc);
        mapXtoUTF8[0x00bd]=QChar(0x00bd);
        mapXtoUTF8[0x00be]=QChar(0x00be);
        mapXtoUTF8[0x00bf]=QChar(0x00bf);
        mapXtoUTF8[0x00c0]=QChar(0x00c0);
        mapXtoUTF8[0x00c1]=QChar(0x00c1);
        mapXtoUTF8[0x00c2]=QChar(0x00c2);
        mapXtoUTF8[0x00c3]=QChar(0x00c3);
        mapXtoUTF8[0x00c4]=QChar(0x00c4);
        mapXtoUTF8[0x00c5]=QChar(0x00c5);
        mapXtoUTF8[0x00c6]=QChar(0x00c6);
        mapXtoUTF8[0x00c7]=QChar(0x00c7);
        mapXtoUTF8[0x00c8]=QChar(0x00c8);
        mapXtoUTF8[0x00c9]=QChar(0x00c9);
        mapXtoUTF8[0x00ca]=QChar(0x00ca);
        mapXtoUTF8[0x00cb]=QChar(0x00cb);
        mapXtoUTF8[0x00cc]=QChar(0x00cc);
        mapXtoUTF8[0x00cd]=QChar(0x00cd);
        mapXtoUTF8[0x00ce]=QChar(0x00ce);
        mapXtoUTF8[0x00cf]=QChar(0x00cf);
        mapXtoUTF8[0x00d0]=QChar(0x00d0);
        mapXtoUTF8[0x00d0]=QChar(0x00d0);
        mapXtoUTF8[0x00d1]=QChar(0x00d1);
        mapXtoUTF8[0x00d2]=QChar(0x00d2);
        mapXtoUTF8[0x00d3]=QChar(0x00d3);
        mapXtoUTF8[0x00d4]=QChar(0x00d4);
        mapXtoUTF8[0x00d5]=QChar(0x00d5);
        mapXtoUTF8[0x00d6]=QChar(0x00d6);
        mapXtoUTF8[0x00d7]=QChar(0x00d7);
        mapXtoUTF8[0x00d8]=QChar(0x00d8);
        mapXtoUTF8[0x00d9]=QChar(0x00d9);
        mapXtoUTF8[0x00da]=QChar(0x00da);
        mapXtoUTF8[0x00db]=QChar(0x00db);
        mapXtoUTF8[0x00dc]=QChar(0x00dc);
        mapXtoUTF8[0x00dd]=QChar(0x00dd);
        mapXtoUTF8[0x00de]=QChar(0x00de);
        mapXtoUTF8[0x00de]=QChar(0x00de);
        mapXtoUTF8[0x00df]=QChar(0x00df);
        mapXtoUTF8[0x00e0]=QChar(0x00e0);
        mapXtoUTF8[0x00e1]=QChar(0x00e1);
        mapXtoUTF8[0x00e2]=QChar(0x00e2);
        mapXtoUTF8[0x00e3]=QChar(0x00e3);
        mapXtoUTF8[0x00e4]=QChar(0x00e4);
        mapXtoUTF8[0x00e5]=QChar(0x00e5);
        mapXtoUTF8[0x00e6]=QChar(0x00e6);
        mapXtoUTF8[0x00e7]=QChar(0x00e7);
        mapXtoUTF8[0x00e8]=QChar(0x00e8);
        mapXtoUTF8[0x00e9]=QChar(0x00e9);
        mapXtoUTF8[0x00ea]=QChar(0x00ea);
        mapXtoUTF8[0x00eb]=QChar(0x00eb);
        mapXtoUTF8[0x00ec]=QChar(0x00ec);
        mapXtoUTF8[0x00ed]=QChar(0x00ed);
        mapXtoUTF8[0x00ee]=QChar(0x00ee);
        mapXtoUTF8[0x00ef]=QChar(0x00ef);
        mapXtoUTF8[0x00f0]=QChar(0x00f0);
        mapXtoUTF8[0x00f1]=QChar(0x00f1);
        mapXtoUTF8[0x00f2]=QChar(0x00f2);
        mapXtoUTF8[0x00f3]=QChar(0x00f3);
        mapXtoUTF8[0x00f4]=QChar(0x00f4);
        mapXtoUTF8[0x00f5]=QChar(0x00f5);
        mapXtoUTF8[0x00f6]=QChar(0x00f6);
        mapXtoUTF8[0x00f7]=QChar(0x00f7);
        mapXtoUTF8[0x00f8]=QChar(0x00f8);
        mapXtoUTF8[0x00f9]=QChar(0x00f9);
        mapXtoUTF8[0x00fa]=QChar(0x00fa);
        mapXtoUTF8[0x00fb]=QChar(0x00fb);
        mapXtoUTF8[0x00fc]=QChar(0x00fc);
        mapXtoUTF8[0x00fd]=QChar(0x00fd);
        mapXtoUTF8[0x00fe]=QChar(0x00fe);
        mapXtoUTF8[0x00ff]=QChar(0x00ff);
        mapXtoUTF8[0x01a1]=QChar(0x0104);
        mapXtoUTF8[0x01a2]=QChar(0x02d8);
        mapXtoUTF8[0x01a3]=QChar(0x0141);
        mapXtoUTF8[0x01a5]=QChar(0x013d);
        mapXtoUTF8[0x01a6]=QChar(0x015a);
        mapXtoUTF8[0x01a9]=QChar(0x0160);
        mapXtoUTF8[0x01aa]=QChar(0x015e);
        mapXtoUTF8[0x01ab]=QChar(0x0164);
        mapXtoUTF8[0x01ac]=QChar(0x0179);
        mapXtoUTF8[0x01ae]=QChar(0x017d);
        mapXtoUTF8[0x01af]=QChar(0x017b);
        mapXtoUTF8[0x01b1]=QChar(0x0105);
        mapXtoUTF8[0x01b2]=QChar(0x02db);
        mapXtoUTF8[0x01b3]=QChar(0x0142);
        mapXtoUTF8[0x01b5]=QChar(0x013e);
        mapXtoUTF8[0x01b6]=QChar(0x015b);
        mapXtoUTF8[0x01b7]=QChar(0x02c7);
        mapXtoUTF8[0x01b9]=QChar(0x0161);
        mapXtoUTF8[0x01ba]=QChar(0x015f);
        mapXtoUTF8[0x01bb]=QChar(0x0165);
        mapXtoUTF8[0x01bc]=QChar(0x017a);
        mapXtoUTF8[0x01bd]=QChar(0x02dd);
        mapXtoUTF8[0x01be]=QChar(0x017e);
        mapXtoUTF8[0x01bf]=QChar(0x017c);
        mapXtoUTF8[0x01c0]=QChar(0x0154);
        mapXtoUTF8[0x01c3]=QChar(0x0102);
        mapXtoUTF8[0x01c5]=QChar(0x0139);
        mapXtoUTF8[0x01c6]=QChar(0x0106);
        mapXtoUTF8[0x01c8]=QChar(0x010c);
        mapXtoUTF8[0x01ca]=QChar(0x0118);
        mapXtoUTF8[0x01cc]=QChar(0x011a);
        mapXtoUTF8[0x01cf]=QChar(0x010e);
        mapXtoUTF8[0x01d0]=QChar(0x0110);
        mapXtoUTF8[0x01d1]=QChar(0x0143);
        mapXtoUTF8[0x01d2]=QChar(0x0147);
        mapXtoUTF8[0x01d5]=QChar(0x0150);
        mapXtoUTF8[0x01d8]=QChar(0x0158);
        mapXtoUTF8[0x01d9]=QChar(0x016e);
        mapXtoUTF8[0x01db]=QChar(0x0170);
        mapXtoUTF8[0x01de]=QChar(0x0162);
        mapXtoUTF8[0x01e0]=QChar(0x0155);
        mapXtoUTF8[0x01e3]=QChar(0x0103);
        mapXtoUTF8[0x01e5]=QChar(0x013a);
        mapXtoUTF8[0x01e6]=QChar(0x0107);
        mapXtoUTF8[0x01e8]=QChar(0x010d);
        mapXtoUTF8[0x01ea]=QChar(0x0119);
        mapXtoUTF8[0x01ec]=QChar(0x011b);
        mapXtoUTF8[0x01ef]=QChar(0x010f);
        mapXtoUTF8[0x01f0]=QChar(0x0111);
        mapXtoUTF8[0x01f1]=QChar(0x0144);
        mapXtoUTF8[0x01f2]=QChar(0x0148);
        mapXtoUTF8[0x01f5]=QChar(0x0151);
        mapXtoUTF8[0x01f8]=QChar(0x0159);
        mapXtoUTF8[0x01f9]=QChar(0x016f);
        mapXtoUTF8[0x01fb]=QChar(0x0171);
        mapXtoUTF8[0x01fe]=QChar(0x0163);
        mapXtoUTF8[0x01ff]=QChar(0x02d9);
        mapXtoUTF8[0x02a1]=QChar(0x0126);
        mapXtoUTF8[0x02a6]=QChar(0x0124);
        mapXtoUTF8[0x02a9]=QChar(0x0130);
        mapXtoUTF8[0x02ab]=QChar(0x011e);
        mapXtoUTF8[0x02ac]=QChar(0x0134);
        mapXtoUTF8[0x02b1]=QChar(0x0127);
        mapXtoUTF8[0x02b6]=QChar(0x0125);
        mapXtoUTF8[0x02b9]=QChar(0x0131);
        mapXtoUTF8[0x02bb]=QChar(0x011f);
        mapXtoUTF8[0x02bc]=QChar(0x0135);
        mapXtoUTF8[0x02c5]=QChar(0x010a);
        mapXtoUTF8[0x02c6]=QChar(0x0108);
        mapXtoUTF8[0x02d5]=QChar(0x0120);
        mapXtoUTF8[0x02d8]=QChar(0x011c);
        mapXtoUTF8[0x02dd]=QChar(0x016c);
        mapXtoUTF8[0x02de]=QChar(0x015c);
        mapXtoUTF8[0x02e5]=QChar(0x010b);
        mapXtoUTF8[0x02e6]=QChar(0x0109);
        mapXtoUTF8[0x02f5]=QChar(0x0121);
        mapXtoUTF8[0x02f8]=QChar(0x011d);
        mapXtoUTF8[0x02fd]=QChar(0x016d);
        mapXtoUTF8[0x02fe]=QChar(0x015d);
        mapXtoUTF8[0x03a2]=QChar(0x0138);
        mapXtoUTF8[0x03a3]=QChar(0x0156);
        mapXtoUTF8[0x03a5]=QChar(0x0128);
        mapXtoUTF8[0x03a6]=QChar(0x013b);
        mapXtoUTF8[0x03aa]=QChar(0x0112);
        mapXtoUTF8[0x03ab]=QChar(0x0122);
        mapXtoUTF8[0x03ac]=QChar(0x0166);
        mapXtoUTF8[0x03b3]=QChar(0x0157);
        mapXtoUTF8[0x03b5]=QChar(0x0129);
        mapXtoUTF8[0x03b6]=QChar(0x013c);
        mapXtoUTF8[0x03ba]=QChar(0x0113);
        mapXtoUTF8[0x03bb]=QChar(0x0123);
        mapXtoUTF8[0x03bc]=QChar(0x0167);
        mapXtoUTF8[0x03bd]=QChar(0x014a);
        mapXtoUTF8[0x03bf]=QChar(0x014b);
        mapXtoUTF8[0x03c0]=QChar(0x0100);
        mapXtoUTF8[0x03c7]=QChar(0x012e);
        mapXtoUTF8[0x03cc]=QChar(0x0116);
        mapXtoUTF8[0x03cf]=QChar(0x012a);
        mapXtoUTF8[0x03d1]=QChar(0x0145);
        mapXtoUTF8[0x03d2]=QChar(0x014c);
        mapXtoUTF8[0x03d3]=QChar(0x0136);
        mapXtoUTF8[0x03d9]=QChar(0x0172);
        mapXtoUTF8[0x03dd]=QChar(0x0168);
        mapXtoUTF8[0x03de]=QChar(0x016a);
        mapXtoUTF8[0x03e0]=QChar(0x0101);
        mapXtoUTF8[0x03e7]=QChar(0x012f);
        mapXtoUTF8[0x03ec]=QChar(0x0117);
        mapXtoUTF8[0x03ef]=QChar(0x012b);
        mapXtoUTF8[0x03f1]=QChar(0x0146);
        mapXtoUTF8[0x03f2]=QChar(0x014d);
        mapXtoUTF8[0x03f3]=QChar(0x0137);
        mapXtoUTF8[0x03f9]=QChar(0x0173);
        mapXtoUTF8[0x03fd]=QChar(0x0169);
        mapXtoUTF8[0x03fe]=QChar(0x016b);
        mapXtoUTF8[0x047e]=QChar(0x203e);
        mapXtoUTF8[0x04a1]=QChar(0x3002);
        mapXtoUTF8[0x04a2]=QChar(0x300c);
        mapXtoUTF8[0x04a3]=QChar(0x300d);
        mapXtoUTF8[0x04a4]=QChar(0x3001);
        mapXtoUTF8[0x04a5]=QChar(0x30fb);
        mapXtoUTF8[0x04a6]=QChar(0x30f2);
        mapXtoUTF8[0x04a7]=QChar(0x30a1);
        mapXtoUTF8[0x04a8]=QChar(0x30a3);
        mapXtoUTF8[0x04a9]=QChar(0x30a5);
        mapXtoUTF8[0x04aa]=QChar(0x30a7);
        mapXtoUTF8[0x04ab]=QChar(0x30a9);
        mapXtoUTF8[0x04ac]=QChar(0x30e3);
        mapXtoUTF8[0x04ad]=QChar(0x30e5);
        mapXtoUTF8[0x04ae]=QChar(0x30e7);
        mapXtoUTF8[0x04af]=QChar(0x30c3);
        mapXtoUTF8[0x04b0]=QChar(0x30fc);
        mapXtoUTF8[0x04b1]=QChar(0x30a2);
        mapXtoUTF8[0x04b2]=QChar(0x30a4);
        mapXtoUTF8[0x04b3]=QChar(0x30a6);
        mapXtoUTF8[0x04b4]=QChar(0x30a8);
        mapXtoUTF8[0x04b5]=QChar(0x30aa);
        mapXtoUTF8[0x04b6]=QChar(0x30ab);
        mapXtoUTF8[0x04b7]=QChar(0x30ad);
        mapXtoUTF8[0x04b8]=QChar(0x30af);
        mapXtoUTF8[0x04b9]=QChar(0x30b1);
        mapXtoUTF8[0x04ba]=QChar(0x30b3);
        mapXtoUTF8[0x04bb]=QChar(0x30b5);
        mapXtoUTF8[0x04bc]=QChar(0x30b7);
        mapXtoUTF8[0x04bd]=QChar(0x30b9);
        mapXtoUTF8[0x04be]=QChar(0x30bb);
        mapXtoUTF8[0x04bf]=QChar(0x30bd);
        mapXtoUTF8[0x04c0]=QChar(0x30bf);
        mapXtoUTF8[0x04c1]=QChar(0x30c1);
        mapXtoUTF8[0x04c2]=QChar(0x30c4);
        mapXtoUTF8[0x04c3]=QChar(0x30c6);
        mapXtoUTF8[0x04c4]=QChar(0x30c8);
        mapXtoUTF8[0x04c5]=QChar(0x30ca);
        mapXtoUTF8[0x04c6]=QChar(0x30cb);
        mapXtoUTF8[0x04c7]=QChar(0x30cc);
        mapXtoUTF8[0x04c8]=QChar(0x30cd);
        mapXtoUTF8[0x04c9]=QChar(0x30ce);
        mapXtoUTF8[0x04ca]=QChar(0x30cf);
        mapXtoUTF8[0x04cb]=QChar(0x30d2);
        mapXtoUTF8[0x04cc]=QChar(0x30d5);
        mapXtoUTF8[0x04cd]=QChar(0x30d8);
        mapXtoUTF8[0x04ce]=QChar(0x30db);
        mapXtoUTF8[0x04cf]=QChar(0x30de);
        mapXtoUTF8[0x04d0]=QChar(0x30df);
        mapXtoUTF8[0x04d1]=QChar(0x30e0);
        mapXtoUTF8[0x04d2]=QChar(0x30e1);
        mapXtoUTF8[0x04d3]=QChar(0x30e2);
        mapXtoUTF8[0x04d4]=QChar(0x30e4);
        mapXtoUTF8[0x04d5]=QChar(0x30e6);
        mapXtoUTF8[0x04d6]=QChar(0x30e8);
        mapXtoUTF8[0x04d7]=QChar(0x30e9);
        mapXtoUTF8[0x04d8]=QChar(0x30ea);
        mapXtoUTF8[0x04d9]=QChar(0x30eb);
        mapXtoUTF8[0x04da]=QChar(0x30ec);
        mapXtoUTF8[0x04db]=QChar(0x30ed);
        mapXtoUTF8[0x04dc]=QChar(0x30ef);
        mapXtoUTF8[0x04dd]=QChar(0x30f3);
        mapXtoUTF8[0x04de]=QChar(0x309b);
        mapXtoUTF8[0x04df]=QChar(0x309c);
        mapXtoUTF8[0x05ac]=QChar(0x060c);
        mapXtoUTF8[0x05bb]=QChar(0x061b);
        mapXtoUTF8[0x05bf]=QChar(0x061f);
        mapXtoUTF8[0x05c1]=QChar(0x0621);
        mapXtoUTF8[0x05c2]=QChar(0x0622);
        mapXtoUTF8[0x05c3]=QChar(0x0623);
        mapXtoUTF8[0x05c4]=QChar(0x0624);
        mapXtoUTF8[0x05c5]=QChar(0x0625);
        mapXtoUTF8[0x05c6]=QChar(0x0626);
        mapXtoUTF8[0x05c7]=QChar(0x0627);
        mapXtoUTF8[0x05c8]=QChar(0x0628);
        mapXtoUTF8[0x05c9]=QChar(0x0629);
        mapXtoUTF8[0x05ca]=QChar(0x062a);
        mapXtoUTF8[0x05cb]=QChar(0x062b);
        mapXtoUTF8[0x05cc]=QChar(0x062c);
        mapXtoUTF8[0x05cd]=QChar(0x062d);
        mapXtoUTF8[0x05ce]=QChar(0x062e);
        mapXtoUTF8[0x05cf]=QChar(0x062f);
        mapXtoUTF8[0x05d0]=QChar(0x0630);
        mapXtoUTF8[0x05d1]=QChar(0x0631);
        mapXtoUTF8[0x05d2]=QChar(0x0632);
        mapXtoUTF8[0x05d3]=QChar(0x0633);
        mapXtoUTF8[0x05d4]=QChar(0x0634);
        mapXtoUTF8[0x05d5]=QChar(0x0635);
        mapXtoUTF8[0x05d6]=QChar(0x0636);
        mapXtoUTF8[0x05d7]=QChar(0x0637);
        mapXtoUTF8[0x05d8]=QChar(0x0638);
        mapXtoUTF8[0x05d9]=QChar(0x0639);
        mapXtoUTF8[0x05da]=QChar(0x063a);
        mapXtoUTF8[0x05e0]=QChar(0x0640);
        mapXtoUTF8[0x05e1]=QChar(0x0641);
        mapXtoUTF8[0x05e2]=QChar(0x0642);
        mapXtoUTF8[0x05e3]=QChar(0x0643);
        mapXtoUTF8[0x05e4]=QChar(0x0644);
        mapXtoUTF8[0x05e5]=QChar(0x0645);
        mapXtoUTF8[0x05e6]=QChar(0x0646);
        mapXtoUTF8[0x05e7]=QChar(0x0647);
        mapXtoUTF8[0x05e8]=QChar(0x0648);
        mapXtoUTF8[0x05e9]=QChar(0x0649);
        mapXtoUTF8[0x05ea]=QChar(0x064a);
        mapXtoUTF8[0x05eb]=QChar(0x064b);
        mapXtoUTF8[0x05ec]=QChar(0x064c);
        mapXtoUTF8[0x05ed]=QChar(0x064d);
        mapXtoUTF8[0x05ee]=QChar(0x064e);
        mapXtoUTF8[0x05ef]=QChar(0x064f);
        mapXtoUTF8[0x05f0]=QChar(0x0650);
        mapXtoUTF8[0x05f1]=QChar(0x0651);
        mapXtoUTF8[0x05f2]=QChar(0x0652);
        mapXtoUTF8[0x06a1]=QChar(0x0452);
        mapXtoUTF8[0x06a2]=QChar(0x0453);
        mapXtoUTF8[0x06a3]=QChar(0x0451);
        mapXtoUTF8[0x06a4]=QChar(0x0454);
        mapXtoUTF8[0x06a5]=QChar(0x0455);
        mapXtoUTF8[0x06a6]=QChar(0x0456);
        mapXtoUTF8[0x06a7]=QChar(0x0457);
        mapXtoUTF8[0x06a8]=QChar(0x0458);
        mapXtoUTF8[0x06a9]=QChar(0x0459);
        mapXtoUTF8[0x06aa]=QChar(0x045a);
        mapXtoUTF8[0x06ab]=QChar(0x045b);
        mapXtoUTF8[0x06ac]=QChar(0x045c);
        mapXtoUTF8[0x06ae]=QChar(0x045e);
        mapXtoUTF8[0x06af]=QChar(0x045f);
        mapXtoUTF8[0x06b0]=QChar(0x2116);
        mapXtoUTF8[0x06b1]=QChar(0x0402);
        mapXtoUTF8[0x06b2]=QChar(0x0403);
        mapXtoUTF8[0x06b3]=QChar(0x0401);
        mapXtoUTF8[0x06b4]=QChar(0x0404);
        mapXtoUTF8[0x06b5]=QChar(0x0405);
        mapXtoUTF8[0x06b6]=QChar(0x0406);
        mapXtoUTF8[0x06b7]=QChar(0x0407);
        mapXtoUTF8[0x06b8]=QChar(0x0408);
        mapXtoUTF8[0x06b9]=QChar(0x0409);
        mapXtoUTF8[0x06ba]=QChar(0x040a);
        mapXtoUTF8[0x06bb]=QChar(0x040b);
        mapXtoUTF8[0x06bc]=QChar(0x040c);
        mapXtoUTF8[0x06be]=QChar(0x040e);
        mapXtoUTF8[0x06bf]=QChar(0x040f);
        mapXtoUTF8[0x06c0]=QChar(0x044e);
        mapXtoUTF8[0x06c1]=QChar(0x0430);
        mapXtoUTF8[0x06c2]=QChar(0x0431);
        mapXtoUTF8[0x06c3]=QChar(0x0446);
        mapXtoUTF8[0x06c4]=QChar(0x0434);
        mapXtoUTF8[0x06c5]=QChar(0x0435);
        mapXtoUTF8[0x06c6]=QChar(0x0444);
        mapXtoUTF8[0x06c7]=QChar(0x0433);
        mapXtoUTF8[0x06c8]=QChar(0x0445);
        mapXtoUTF8[0x06c9]=QChar(0x0438);
        mapXtoUTF8[0x06ca]=QChar(0x0439);
        mapXtoUTF8[0x06cb]=QChar(0x043a);
        mapXtoUTF8[0x06cc]=QChar(0x043b);
        mapXtoUTF8[0x06cd]=QChar(0x043c);
        mapXtoUTF8[0x06ce]=QChar(0x043d);
        mapXtoUTF8[0x06cf]=QChar(0x043e);
        mapXtoUTF8[0x06d0]=QChar(0x043f);
        mapXtoUTF8[0x06d1]=QChar(0x044f);
        mapXtoUTF8[0x06d2]=QChar(0x0440);
        mapXtoUTF8[0x06d3]=QChar(0x0441);
        mapXtoUTF8[0x06d4]=QChar(0x0442);
        mapXtoUTF8[0x06d5]=QChar(0x0443);
        mapXtoUTF8[0x06d6]=QChar(0x0436);
        mapXtoUTF8[0x06d7]=QChar(0x0432);
        mapXtoUTF8[0x06d8]=QChar(0x044c);
        mapXtoUTF8[0x06d9]=QChar(0x044b);
        mapXtoUTF8[0x06da]=QChar(0x0437);
        mapXtoUTF8[0x06db]=QChar(0x0448);
        mapXtoUTF8[0x06dc]=QChar(0x044d);
        mapXtoUTF8[0x06dd]=QChar(0x0449);
        mapXtoUTF8[0x06de]=QChar(0x0447);
        mapXtoUTF8[0x06df]=QChar(0x044a);
        mapXtoUTF8[0x06e0]=QChar(0x042e);
        mapXtoUTF8[0x06e1]=QChar(0x0410);
        mapXtoUTF8[0x06e2]=QChar(0x0411);
        mapXtoUTF8[0x06e3]=QChar(0x0426);
        mapXtoUTF8[0x06e4]=QChar(0x0414);
        mapXtoUTF8[0x06e5]=QChar(0x0415);
        mapXtoUTF8[0x06e6]=QChar(0x0424);
        mapXtoUTF8[0x06e7]=QChar(0x0413);
        mapXtoUTF8[0x06e8]=QChar(0x0425);
        mapXtoUTF8[0x06e9]=QChar(0x0418);
        mapXtoUTF8[0x06ea]=QChar(0x0419);
        mapXtoUTF8[0x06eb]=QChar(0x041a);
        mapXtoUTF8[0x06ec]=QChar(0x041b);
        mapXtoUTF8[0x06ed]=QChar(0x041c);
        mapXtoUTF8[0x06ee]=QChar(0x041d);
        mapXtoUTF8[0x06ef]=QChar(0x041e);
        mapXtoUTF8[0x06f0]=QChar(0x041f);
        mapXtoUTF8[0x06f1]=QChar(0x042f);
        mapXtoUTF8[0x06f2]=QChar(0x0420);
        mapXtoUTF8[0x06f3]=QChar(0x0421);
        mapXtoUTF8[0x06f4]=QChar(0x0422);
        mapXtoUTF8[0x06f5]=QChar(0x0423);
        mapXtoUTF8[0x06f6]=QChar(0x0416);
        mapXtoUTF8[0x06f7]=QChar(0x0412);
        mapXtoUTF8[0x06f8]=QChar(0x042c);
        mapXtoUTF8[0x06f9]=QChar(0x042b);
        mapXtoUTF8[0x06fa]=QChar(0x0417);
        mapXtoUTF8[0x06fb]=QChar(0x0428);
        mapXtoUTF8[0x06fc]=QChar(0x042d);
        mapXtoUTF8[0x06fd]=QChar(0x0429);
        mapXtoUTF8[0x06fe]=QChar(0x0427);
        mapXtoUTF8[0x06ff]=QChar(0x042a);
        mapXtoUTF8[0x07a1]=QChar(0x0386);
        mapXtoUTF8[0x07a2]=QChar(0x0388);
        mapXtoUTF8[0x07a3]=QChar(0x0389);
        mapXtoUTF8[0x07a4]=QChar(0x038a);
        mapXtoUTF8[0x07a5]=QChar(0x03aa);
        mapXtoUTF8[0x07a7]=QChar(0x038c);
        mapXtoUTF8[0x07a8]=QChar(0x038e);
        mapXtoUTF8[0x07a9]=QChar(0x03ab);
        mapXtoUTF8[0x07ab]=QChar(0x038f);
        mapXtoUTF8[0x07ae]=QChar(0x0385);
        mapXtoUTF8[0x07af]=QChar(0x2015);
        mapXtoUTF8[0x07b1]=QChar(0x03ac);
        mapXtoUTF8[0x07b2]=QChar(0x03ad);
        mapXtoUTF8[0x07b3]=QChar(0x03ae);
        mapXtoUTF8[0x07b4]=QChar(0x03af);
        mapXtoUTF8[0x07b5]=QChar(0x03ca);
        mapXtoUTF8[0x07b6]=QChar(0x0390);
        mapXtoUTF8[0x07b7]=QChar(0x03cc);
        mapXtoUTF8[0x07b8]=QChar(0x03cd);
        mapXtoUTF8[0x07b9]=QChar(0x03cb);
        mapXtoUTF8[0x07ba]=QChar(0x03b0);
        mapXtoUTF8[0x07bb]=QChar(0x03ce);
        mapXtoUTF8[0x07c1]=QChar(0x0391);
        mapXtoUTF8[0x07c2]=QChar(0x0392);
        mapXtoUTF8[0x07c3]=QChar(0x0393);
        mapXtoUTF8[0x07c4]=QChar(0x0394);
        mapXtoUTF8[0x07c5]=QChar(0x0395);
        mapXtoUTF8[0x07c6]=QChar(0x0396);
        mapXtoUTF8[0x07c7]=QChar(0x0397);
        mapXtoUTF8[0x07c8]=QChar(0x0398);
        mapXtoUTF8[0x07c9]=QChar(0x0399);
        mapXtoUTF8[0x07ca]=QChar(0x039a);
        mapXtoUTF8[0x07cb]=QChar(0x039b);
        mapXtoUTF8[0x07cb]=QChar(0x039b);
        mapXtoUTF8[0x07cc]=QChar(0x039c);
        mapXtoUTF8[0x07cd]=QChar(0x039d);
        mapXtoUTF8[0x07ce]=QChar(0x039e);
        mapXtoUTF8[0x07cf]=QChar(0x039f);
        mapXtoUTF8[0x07d0]=QChar(0x03a0);
        mapXtoUTF8[0x07d1]=QChar(0x03a1);
        mapXtoUTF8[0x07d2]=QChar(0x03a3);
        mapXtoUTF8[0x07d4]=QChar(0x03a4);
        mapXtoUTF8[0x07d5]=QChar(0x03a5);
        mapXtoUTF8[0x07d6]=QChar(0x03a6);
        mapXtoUTF8[0x07d7]=QChar(0x03a7);
        mapXtoUTF8[0x07d8]=QChar(0x03a8);
        mapXtoUTF8[0x07d9]=QChar(0x03a9);
        mapXtoUTF8[0x07e1]=QChar(0x03b1);
        mapXtoUTF8[0x07e2]=QChar(0x03b2);
        mapXtoUTF8[0x07e3]=QChar(0x03b3);
        mapXtoUTF8[0x07e4]=QChar(0x03b4);
        mapXtoUTF8[0x07e5]=QChar(0x03b5);
        mapXtoUTF8[0x07e6]=QChar(0x03b6);
        mapXtoUTF8[0x07e7]=QChar(0x03b7);
        mapXtoUTF8[0x07e8]=QChar(0x03b8);
        mapXtoUTF8[0x07e9]=QChar(0x03b9);
        mapXtoUTF8[0x07ea]=QChar(0x03ba);
        mapXtoUTF8[0x07eb]=QChar(0x03bb);
        mapXtoUTF8[0x07ec]=QChar(0x03bc);
        mapXtoUTF8[0x07ed]=QChar(0x03bd);
        mapXtoUTF8[0x07ee]=QChar(0x03be);
        mapXtoUTF8[0x07ef]=QChar(0x03bf);
        mapXtoUTF8[0x07f0]=QChar(0x03c0);
        mapXtoUTF8[0x07f1]=QChar(0x03c1);
        mapXtoUTF8[0x07f2]=QChar(0x03c3);
        mapXtoUTF8[0x07f3]=QChar(0x03c2);
        mapXtoUTF8[0x07f4]=QChar(0x03c4);
        mapXtoUTF8[0x07f5]=QChar(0x03c5);
        mapXtoUTF8[0x07f6]=QChar(0x03c6);
        mapXtoUTF8[0x07f7]=QChar(0x03c7);
        mapXtoUTF8[0x07f8]=QChar(0x03c8);
        mapXtoUTF8[0x07f9]=QChar(0x03c9);
        mapXtoUTF8[0x08a1]=QChar(0x23b7);
        mapXtoUTF8[0x08a2]=QChar(0x250c);
        mapXtoUTF8[0x08a3]=QChar(0x2500);
        mapXtoUTF8[0x08a4]=QChar(0x2320);
        mapXtoUTF8[0x08a5]=QChar(0x2321);
        mapXtoUTF8[0x08a6]=QChar(0x2502);
        mapXtoUTF8[0x08a7]=QChar(0x23a1);
        mapXtoUTF8[0x08a8]=QChar(0x23a3);
        mapXtoUTF8[0x08a9]=QChar(0x23a4);
        mapXtoUTF8[0x08aa]=QChar(0x23a6);
        mapXtoUTF8[0x08ab]=QChar(0x239b);
        mapXtoUTF8[0x08ac]=QChar(0x239d);
        mapXtoUTF8[0x08ad]=QChar(0x239e);
        mapXtoUTF8[0x08ae]=QChar(0x23a0);
        mapXtoUTF8[0x08af]=QChar(0x23a8);
        mapXtoUTF8[0x08b0]=QChar(0x23ac);
        mapXtoUTF8[0x08b1]=QChar(0x0000);
        mapXtoUTF8[0x08b2]=QChar(0x0000);
        mapXtoUTF8[0x08b3]=QChar(0x0000);
        mapXtoUTF8[0x08b4]=QChar(0x0000);
        mapXtoUTF8[0x08b5]=QChar(0x0000);
        mapXtoUTF8[0x08b6]=QChar(0x0000);
        mapXtoUTF8[0x08b7]=QChar(0x0000);
        mapXtoUTF8[0x08bc]=QChar(0x2264);
        mapXtoUTF8[0x08bd]=QChar(0x2260);
        mapXtoUTF8[0x08be]=QChar(0x2265);
        mapXtoUTF8[0x08bf]=QChar(0x222b);
        mapXtoUTF8[0x08c0]=QChar(0x2234);
        mapXtoUTF8[0x08c1]=QChar(0x221d);
        mapXtoUTF8[0x08c2]=QChar(0x221e);
        mapXtoUTF8[0x08c5]=QChar(0x2207);
        mapXtoUTF8[0x08c8]=QChar(0x223c);
        mapXtoUTF8[0x08c9]=QChar(0x2243);
        mapXtoUTF8[0x08cd]=QChar(0x21d4);
        mapXtoUTF8[0x08ce]=QChar(0x21d2);
        mapXtoUTF8[0x08cf]=QChar(0x2261);
        mapXtoUTF8[0x08d6]=QChar(0x221a);
        mapXtoUTF8[0x08da]=QChar(0x2282);
        mapXtoUTF8[0x08db]=QChar(0x2283);
        mapXtoUTF8[0x08dc]=QChar(0x2229);
        mapXtoUTF8[0x08dd]=QChar(0x222a);
        mapXtoUTF8[0x08de]=QChar(0x2227);
        mapXtoUTF8[0x08df]=QChar(0x2228);
        mapXtoUTF8[0x08ef]=QChar(0x2202);
        mapXtoUTF8[0x08f6]=QChar(0x0192);
        mapXtoUTF8[0x08fb]=QChar(0x2190);
        mapXtoUTF8[0x08fc]=QChar(0x2191);
        mapXtoUTF8[0x08fd]=QChar(0x2192);
        mapXtoUTF8[0x08fe]=QChar(0x2193);
        mapXtoUTF8[0x09df]=QChar(0x0000);
        mapXtoUTF8[0x09e0]=QChar(0x25c6);
        mapXtoUTF8[0x09e1]=QChar(0x2592);
        mapXtoUTF8[0x09e2]=QChar(0x2409);
        mapXtoUTF8[0x09e3]=QChar(0x240c);
        mapXtoUTF8[0x09e4]=QChar(0x240d);
        mapXtoUTF8[0x09e5]=QChar(0x240a);
        mapXtoUTF8[0x09e8]=QChar(0x2424);
        mapXtoUTF8[0x09e9]=QChar(0x240b);
        mapXtoUTF8[0x09ea]=QChar(0x2518);
        mapXtoUTF8[0x09eb]=QChar(0x2510);
        mapXtoUTF8[0x09ec]=QChar(0x250c);
        mapXtoUTF8[0x09ed]=QChar(0x2514);
        mapXtoUTF8[0x09ee]=QChar(0x253c);
        mapXtoUTF8[0x09ef]=QChar(0x23ba);
        mapXtoUTF8[0x09f0]=QChar(0x23bb);
        mapXtoUTF8[0x09f1]=QChar(0x2500);
        mapXtoUTF8[0x09f2]=QChar(0x23bc);
        mapXtoUTF8[0x09f3]=QChar(0x23bd);
        mapXtoUTF8[0x09f4]=QChar(0x251c);
        mapXtoUTF8[0x09f5]=QChar(0x2524);
        mapXtoUTF8[0x09f6]=QChar(0x2534);
        mapXtoUTF8[0x09f7]=QChar(0x252c);
        mapXtoUTF8[0x09f8]=QChar(0x2502);
        mapXtoUTF8[0x0aa1]=QChar(0x2003);
        mapXtoUTF8[0x0aa2]=QChar(0x2002);
        mapXtoUTF8[0x0aa3]=QChar(0x2004);
        mapXtoUTF8[0x0aa4]=QChar(0x2005);
        mapXtoUTF8[0x0aa5]=QChar(0x2007);
        mapXtoUTF8[0x0aa6]=QChar(0x2008);
        mapXtoUTF8[0x0aa7]=QChar(0x2009);
        mapXtoUTF8[0x0aa8]=QChar(0x200a);
        mapXtoUTF8[0x0aa9]=QChar(0x2014);
        mapXtoUTF8[0x0aaa]=QChar(0x2013);
        mapXtoUTF8[0x0aac]=QChar(0x2423);
        mapXtoUTF8[0x0aae]=QChar(0x2026);
        mapXtoUTF8[0x0aaf]=QChar(0x2025);
        mapXtoUTF8[0x0ab0]=QChar(0x2153);
        mapXtoUTF8[0x0ab1]=QChar(0x2154);
        mapXtoUTF8[0x0ab2]=QChar(0x2155);
        mapXtoUTF8[0x0ab3]=QChar(0x2156);
        mapXtoUTF8[0x0ab4]=QChar(0x2157);
        mapXtoUTF8[0x0ab5]=QChar(0x2158);
        mapXtoUTF8[0x0ab6]=QChar(0x2159);
        mapXtoUTF8[0x0ab7]=QChar(0x215a);
        mapXtoUTF8[0x0ab8]=QChar(0x2105);
        mapXtoUTF8[0x0abb]=QChar(0x2012);
        mapXtoUTF8[0x0abc]=QChar(0x27e8);
        mapXtoUTF8[0x0abd]=QChar(0x002e);
        mapXtoUTF8[0x0abe]=QChar(0x27e9);
        mapXtoUTF8[0x0abf]=QChar(0x0000);
        mapXtoUTF8[0x0ac3]=QChar(0x215b);
        mapXtoUTF8[0x0ac4]=QChar(0x215c);
        mapXtoUTF8[0x0ac5]=QChar(0x215d);
        mapXtoUTF8[0x0ac6]=QChar(0x215e);
        mapXtoUTF8[0x0ac9]=QChar(0x2122);
        mapXtoUTF8[0x0aca]=QChar(0x2613);
        mapXtoUTF8[0x0acb]=QChar(0x0000);
        mapXtoUTF8[0x0acc]=QChar(0x25c1);
        mapXtoUTF8[0x0acd]=QChar(0x25b7);
        mapXtoUTF8[0x0ace]=QChar(0x25cb);
        mapXtoUTF8[0x0acf]=QChar(0x25af);
        mapXtoUTF8[0x0ad0]=QChar(0x2018);
        mapXtoUTF8[0x0ad1]=QChar(0x2019);
        mapXtoUTF8[0x0ad2]=QChar(0x201c);
        mapXtoUTF8[0x0ad3]=QChar(0x201d);
        mapXtoUTF8[0x0ad4]=QChar(0x211e);
        mapXtoUTF8[0x0ad6]=QChar(0x2032);
        mapXtoUTF8[0x0ad7]=QChar(0x2033);
        mapXtoUTF8[0x0ad9]=QChar(0x271d);
        mapXtoUTF8[0x0ada]=QChar(0x0000);
        mapXtoUTF8[0x0adb]=QChar(0x25ac);
        mapXtoUTF8[0x0adc]=QChar(0x25c0);
        mapXtoUTF8[0x0add]=QChar(0x25b6);
        mapXtoUTF8[0x0ade]=QChar(0x25cf);
        mapXtoUTF8[0x0adf]=QChar(0x25ae);
        mapXtoUTF8[0x0ae0]=QChar(0x25e6);
        mapXtoUTF8[0x0ae1]=QChar(0x25ab);
        mapXtoUTF8[0x0ae2]=QChar(0x25ad);
        mapXtoUTF8[0x0ae3]=QChar(0x25b3);
        mapXtoUTF8[0x0ae4]=QChar(0x25bd);
        mapXtoUTF8[0x0ae5]=QChar(0x2606);
        mapXtoUTF8[0x0ae6]=QChar(0x2022);
        mapXtoUTF8[0x0ae7]=QChar(0x25aa);
        mapXtoUTF8[0x0ae8]=QChar(0x25b2);
        mapXtoUTF8[0x0ae9]=QChar(0x25bc);
        mapXtoUTF8[0x0aea]=QChar(0x261c);
        mapXtoUTF8[0x0aeb]=QChar(0x261e);
        mapXtoUTF8[0x0aec]=QChar(0x2663);
        mapXtoUTF8[0x0aed]=QChar(0x2666);
        mapXtoUTF8[0x0aee]=QChar(0x2665);
        mapXtoUTF8[0x0af0]=QChar(0x2720);
        mapXtoUTF8[0x0af1]=QChar(0x2020);
        mapXtoUTF8[0x0af2]=QChar(0x2021);
        mapXtoUTF8[0x0af3]=QChar(0x2713);
        mapXtoUTF8[0x0af4]=QChar(0x2717);
        mapXtoUTF8[0x0af5]=QChar(0x266f);
        mapXtoUTF8[0x0af6]=QChar(0x266d);
        mapXtoUTF8[0x0af7]=QChar(0x2642);
        mapXtoUTF8[0x0af8]=QChar(0x2640);
        mapXtoUTF8[0x0af9]=QChar(0x260e);
        mapXtoUTF8[0x0afa]=QChar(0x2315);
        mapXtoUTF8[0x0afb]=QChar(0x2117);
        mapXtoUTF8[0x0afc]=QChar(0x2038);
        mapXtoUTF8[0x0afd]=QChar(0x201a);
        mapXtoUTF8[0x0afe]=QChar(0x201e);
        mapXtoUTF8[0x0aff]=QChar(0x0000);
        mapXtoUTF8[0x0ba3]=QChar(0x003c);
        mapXtoUTF8[0x0ba6]=QChar(0x003e);
        mapXtoUTF8[0x0ba8]=QChar(0x2228);
        mapXtoUTF8[0x0ba9]=QChar(0x2227);
        mapXtoUTF8[0x0bc0]=QChar(0x00af);
        mapXtoUTF8[0x0bc2]=QChar(0x22a5);
        mapXtoUTF8[0x0bc3]=QChar(0x2229);
        mapXtoUTF8[0x0bc4]=QChar(0x230a);
        mapXtoUTF8[0x0bc6]=QChar(0x005f);
        mapXtoUTF8[0x0bca]=QChar(0x2218);
        mapXtoUTF8[0x0bcc]=QChar(0x2395);
        mapXtoUTF8[0x0bce]=QChar(0x22a4);
        mapXtoUTF8[0x0bcf]=QChar(0x25cb);
        mapXtoUTF8[0x0bd3]=QChar(0x2308);
        mapXtoUTF8[0x0bd6]=QChar(0x222a);
        mapXtoUTF8[0x0bd8]=QChar(0x2283);
        mapXtoUTF8[0x0bda]=QChar(0x2282);
        mapXtoUTF8[0x0bdc]=QChar(0x22a2);
        mapXtoUTF8[0x0bfc]=QChar(0x22a3);
        mapXtoUTF8[0x0cdf]=QChar(0x2017);
        mapXtoUTF8[0x0ce0]=QChar(0x05d0);
        mapXtoUTF8[0x0ce1]=QChar(0x05d1);
        mapXtoUTF8[0x0ce1]=QChar(0x05d1);
        mapXtoUTF8[0x0ce2]=QChar(0x05d2);
        mapXtoUTF8[0x0ce2]=QChar(0x05d2);
        mapXtoUTF8[0x0ce3]=QChar(0x05d3);
        mapXtoUTF8[0x0ce3]=QChar(0x05d3);
        mapXtoUTF8[0x0ce4]=QChar(0x05d4);
        mapXtoUTF8[0x0ce5]=QChar(0x05d5);
        mapXtoUTF8[0x0ce6]=QChar(0x05d6);
        mapXtoUTF8[0x0ce6]=QChar(0x05d6);
        mapXtoUTF8[0x0ce7]=QChar(0x05d7);
        mapXtoUTF8[0x0ce7]=QChar(0x05d7);
        mapXtoUTF8[0x0ce8]=QChar(0x05d8);
        mapXtoUTF8[0x0ce8]=QChar(0x05d8);
        mapXtoUTF8[0x0ce9]=QChar(0x05d9);
        mapXtoUTF8[0x0cea]=QChar(0x05da);
        mapXtoUTF8[0x0ceb]=QChar(0x05db);
        mapXtoUTF8[0x0cec]=QChar(0x05dc);
        mapXtoUTF8[0x0ced]=QChar(0x05dd);
        mapXtoUTF8[0x0cee]=QChar(0x05de);
        mapXtoUTF8[0x0cef]=QChar(0x05df);
        mapXtoUTF8[0x0cf0]=QChar(0x05e0);
        mapXtoUTF8[0x0cf1]=QChar(0x05e1);
        mapXtoUTF8[0x0cf1]=QChar(0x05e1);
        mapXtoUTF8[0x0cf2]=QChar(0x05e2);
        mapXtoUTF8[0x0cf3]=QChar(0x05e3);
        mapXtoUTF8[0x0cf4]=QChar(0x05e4);
        mapXtoUTF8[0x0cf5]=QChar(0x05e5);
        mapXtoUTF8[0x0cf5]=QChar(0x05e5);
        mapXtoUTF8[0x0cf6]=QChar(0x05e6);
        mapXtoUTF8[0x0cf6]=QChar(0x05e6);
        mapXtoUTF8[0x0cf7]=QChar(0x05e7);
        mapXtoUTF8[0x0cf7]=QChar(0x05e7);
        mapXtoUTF8[0x0cf8]=QChar(0x05e8);
        mapXtoUTF8[0x0cf9]=QChar(0x05e9);
        mapXtoUTF8[0x0cfa]=QChar(0x05ea);
        mapXtoUTF8[0x0cfa]=QChar(0x05ea);
        mapXtoUTF8[0x0da1]=QChar(0x0e01);
        mapXtoUTF8[0x0da2]=QChar(0x0e02);
        mapXtoUTF8[0x0da3]=QChar(0x0e03);
        mapXtoUTF8[0x0da4]=QChar(0x0e04);
        mapXtoUTF8[0x0da5]=QChar(0x0e05);
        mapXtoUTF8[0x0da6]=QChar(0x0e06);
        mapXtoUTF8[0x0da7]=QChar(0x0e07);
        mapXtoUTF8[0x0da8]=QChar(0x0e08);
        mapXtoUTF8[0x0da9]=QChar(0x0e09);
        mapXtoUTF8[0x0daa]=QChar(0x0e0a);
        mapXtoUTF8[0x0dab]=QChar(0x0e0b);
        mapXtoUTF8[0x0dac]=QChar(0x0e0c);
        mapXtoUTF8[0x0dad]=QChar(0x0e0d);
        mapXtoUTF8[0x0dae]=QChar(0x0e0e);
        mapXtoUTF8[0x0daf]=QChar(0x0e0f);
        mapXtoUTF8[0x0db0]=QChar(0x0e10);
        mapXtoUTF8[0x0db1]=QChar(0x0e11);
        mapXtoUTF8[0x0db2]=QChar(0x0e12);
        mapXtoUTF8[0x0db3]=QChar(0x0e13);
        mapXtoUTF8[0x0db4]=QChar(0x0e14);
        mapXtoUTF8[0x0db5]=QChar(0x0e15);
        mapXtoUTF8[0x0db6]=QChar(0x0e16);
        mapXtoUTF8[0x0db7]=QChar(0x0e17);
        mapXtoUTF8[0x0db8]=QChar(0x0e18);
        mapXtoUTF8[0x0db9]=QChar(0x0e19);
        mapXtoUTF8[0x0dba]=QChar(0x0e1a);
        mapXtoUTF8[0x0dbb]=QChar(0x0e1b);
        mapXtoUTF8[0x0dbc]=QChar(0x0e1c);
        mapXtoUTF8[0x0dbd]=QChar(0x0e1d);
        mapXtoUTF8[0x0dbe]=QChar(0x0e1e);
        mapXtoUTF8[0x0dbf]=QChar(0x0e1f);
        mapXtoUTF8[0x0dc0]=QChar(0x0e20);
        mapXtoUTF8[0x0dc1]=QChar(0x0e21);
        mapXtoUTF8[0x0dc2]=QChar(0x0e22);
        mapXtoUTF8[0x0dc3]=QChar(0x0e23);
        mapXtoUTF8[0x0dc4]=QChar(0x0e24);
        mapXtoUTF8[0x0dc5]=QChar(0x0e25);
        mapXtoUTF8[0x0dc6]=QChar(0x0e26);
        mapXtoUTF8[0x0dc7]=QChar(0x0e27);
        mapXtoUTF8[0x0dc8]=QChar(0x0e28);
        mapXtoUTF8[0x0dc9]=QChar(0x0e29);
        mapXtoUTF8[0x0dca]=QChar(0x0e2a);
        mapXtoUTF8[0x0dcb]=QChar(0x0e2b);
        mapXtoUTF8[0x0dcc]=QChar(0x0e2c);
        mapXtoUTF8[0x0dcd]=QChar(0x0e2d);
        mapXtoUTF8[0x0dce]=QChar(0x0e2e);
        mapXtoUTF8[0x0dcf]=QChar(0x0e2f);
        mapXtoUTF8[0x0dd0]=QChar(0x0e30);
        mapXtoUTF8[0x0dd1]=QChar(0x0e31);
        mapXtoUTF8[0x0dd2]=QChar(0x0e32);
        mapXtoUTF8[0x0dd3]=QChar(0x0e33);
        mapXtoUTF8[0x0dd4]=QChar(0x0e34);
        mapXtoUTF8[0x0dd5]=QChar(0x0e35);
        mapXtoUTF8[0x0dd6]=QChar(0x0e36);
        mapXtoUTF8[0x0dd7]=QChar(0x0e37);
        mapXtoUTF8[0x0dd8]=QChar(0x0e38);
        mapXtoUTF8[0x0dd9]=QChar(0x0e39);
        mapXtoUTF8[0x0dda]=QChar(0x0e3a);
        mapXtoUTF8[0x0dde]=QChar(0x0000);
        mapXtoUTF8[0x0ddf]=QChar(0x0e3f);
        mapXtoUTF8[0x0de0]=QChar(0x0e40);
        mapXtoUTF8[0x0de1]=QChar(0x0e41);
        mapXtoUTF8[0x0de2]=QChar(0x0e42);
        mapXtoUTF8[0x0de3]=QChar(0x0e43);
        mapXtoUTF8[0x0de4]=QChar(0x0e44);
        mapXtoUTF8[0x0de5]=QChar(0x0e45);
        mapXtoUTF8[0x0de6]=QChar(0x0e46);
        mapXtoUTF8[0x0de7]=QChar(0x0e47);
        mapXtoUTF8[0x0de8]=QChar(0x0e48);
        mapXtoUTF8[0x0de9]=QChar(0x0e49);
        mapXtoUTF8[0x0dea]=QChar(0x0e4a);
        mapXtoUTF8[0x0deb]=QChar(0x0e4b);
        mapXtoUTF8[0x0dec]=QChar(0x0e4c);
        mapXtoUTF8[0x0ded]=QChar(0x0e4d);
        mapXtoUTF8[0x0df0]=QChar(0x0e50);
        mapXtoUTF8[0x0df1]=QChar(0x0e51);
        mapXtoUTF8[0x0df2]=QChar(0x0e52);
        mapXtoUTF8[0x0df3]=QChar(0x0e53);
        mapXtoUTF8[0x0df4]=QChar(0x0e54);
        mapXtoUTF8[0x0df5]=QChar(0x0e55);
        mapXtoUTF8[0x0df6]=QChar(0x0e56);
        mapXtoUTF8[0x0df7]=QChar(0x0e57);
        mapXtoUTF8[0x0df8]=QChar(0x0e58);
        mapXtoUTF8[0x0df9]=QChar(0x0e59);
        mapXtoUTF8[0x0ea1]=QChar(0x3131);
        mapXtoUTF8[0x0ea2]=QChar(0x3132);
        mapXtoUTF8[0x0ea3]=QChar(0x3133);
        mapXtoUTF8[0x0ea4]=QChar(0x3134);
        mapXtoUTF8[0x0ea5]=QChar(0x3135);
        mapXtoUTF8[0x0ea6]=QChar(0x3136);
        mapXtoUTF8[0x0ea7]=QChar(0x3137);
        mapXtoUTF8[0x0ea8]=QChar(0x3138);
        mapXtoUTF8[0x0ea9]=QChar(0x3139);
        mapXtoUTF8[0x0eaa]=QChar(0x313a);
        mapXtoUTF8[0x0eab]=QChar(0x313b);
        mapXtoUTF8[0x0eac]=QChar(0x313c);
        mapXtoUTF8[0x0ead]=QChar(0x313d);
        mapXtoUTF8[0x0eae]=QChar(0x313e);
        mapXtoUTF8[0x0eaf]=QChar(0x313f);
        mapXtoUTF8[0x0eb0]=QChar(0x3140);
        mapXtoUTF8[0x0eb1]=QChar(0x3141);
        mapXtoUTF8[0x0eb2]=QChar(0x3142);
        mapXtoUTF8[0x0eb3]=QChar(0x3143);
        mapXtoUTF8[0x0eb4]=QChar(0x3144);
        mapXtoUTF8[0x0eb5]=QChar(0x3145);
        mapXtoUTF8[0x0eb6]=QChar(0x3146);
        mapXtoUTF8[0x0eb7]=QChar(0x3147);
        mapXtoUTF8[0x0eb8]=QChar(0x3148);
        mapXtoUTF8[0x0eb9]=QChar(0x3149);
        mapXtoUTF8[0x0eba]=QChar(0x314a);
        mapXtoUTF8[0x0ebb]=QChar(0x314b);
        mapXtoUTF8[0x0ebc]=QChar(0x314c);
        mapXtoUTF8[0x0ebd]=QChar(0x314d);
        mapXtoUTF8[0x0ebe]=QChar(0x314e);
        mapXtoUTF8[0x0ebf]=QChar(0x314f);
        mapXtoUTF8[0x0ec0]=QChar(0x3150);
        mapXtoUTF8[0x0ec1]=QChar(0x3151);
        mapXtoUTF8[0x0ec2]=QChar(0x3152);
        mapXtoUTF8[0x0ec3]=QChar(0x3153);
        mapXtoUTF8[0x0ec4]=QChar(0x3154);
        mapXtoUTF8[0x0ec5]=QChar(0x3155);
        mapXtoUTF8[0x0ec6]=QChar(0x3156);
        mapXtoUTF8[0x0ec7]=QChar(0x3157);
        mapXtoUTF8[0x0ec8]=QChar(0x3158);
        mapXtoUTF8[0x0ec9]=QChar(0x3159);
        mapXtoUTF8[0x0eca]=QChar(0x315a);
        mapXtoUTF8[0x0ecb]=QChar(0x315b);
        mapXtoUTF8[0x0ecc]=QChar(0x315c);
        mapXtoUTF8[0x0ecd]=QChar(0x315d);
        mapXtoUTF8[0x0ece]=QChar(0x315e);
        mapXtoUTF8[0x0ecf]=QChar(0x315f);
        mapXtoUTF8[0x0ed0]=QChar(0x3160);
        mapXtoUTF8[0x0ed1]=QChar(0x3161);
        mapXtoUTF8[0x0ed2]=QChar(0x3162);
        mapXtoUTF8[0x0ed3]=QChar(0x3163);
        mapXtoUTF8[0x0ed4]=QChar(0x11a8);
        mapXtoUTF8[0x0ed5]=QChar(0x11a9);
        mapXtoUTF8[0x0ed6]=QChar(0x11aa);
        mapXtoUTF8[0x0ed7]=QChar(0x11ab);
        mapXtoUTF8[0x0ed8]=QChar(0x11ac);
        mapXtoUTF8[0x0ed9]=QChar(0x11ad);
        mapXtoUTF8[0x0eda]=QChar(0x11ae);
        mapXtoUTF8[0x0edb]=QChar(0x11af);
        mapXtoUTF8[0x0edc]=QChar(0x11b0);
        mapXtoUTF8[0x0edd]=QChar(0x11b1);
        mapXtoUTF8[0x0ede]=QChar(0x11b2);
        mapXtoUTF8[0x0edf]=QChar(0x11b3);
        mapXtoUTF8[0x0ee0]=QChar(0x11b4);
        mapXtoUTF8[0x0ee1]=QChar(0x11b5);
        mapXtoUTF8[0x0ee2]=QChar(0x11b6);
        mapXtoUTF8[0x0ee3]=QChar(0x11b7);
        mapXtoUTF8[0x0ee4]=QChar(0x11b8);
        mapXtoUTF8[0x0ee5]=QChar(0x11b9);
        mapXtoUTF8[0x0ee6]=QChar(0x11ba);
        mapXtoUTF8[0x0ee7]=QChar(0x11bb);
        mapXtoUTF8[0x0ee8]=QChar(0x11bc);
        mapXtoUTF8[0x0ee9]=QChar(0x11bd);
        mapXtoUTF8[0x0eea]=QChar(0x11be);
        mapXtoUTF8[0x0eeb]=QChar(0x11bf);
        mapXtoUTF8[0x0eec]=QChar(0x11c0);
        mapXtoUTF8[0x0eed]=QChar(0x11c1);
        mapXtoUTF8[0x0eee]=QChar(0x11c2);
        mapXtoUTF8[0x0eef]=QChar(0x316d);
        mapXtoUTF8[0x0ef0]=QChar(0x3171);
        mapXtoUTF8[0x0ef1]=QChar(0x3178);
        mapXtoUTF8[0x0ef2]=QChar(0x317f);
        mapXtoUTF8[0x0ef3]=QChar(0x3181);
        mapXtoUTF8[0x0ef4]=QChar(0x3184);
        mapXtoUTF8[0x0ef5]=QChar(0x3186);
        mapXtoUTF8[0x0ef6]=QChar(0x318d);
        mapXtoUTF8[0x0ef7]=QChar(0x318e);
        mapXtoUTF8[0x0ef8]=QChar(0x11eb);
        mapXtoUTF8[0x0ef9]=QChar(0x11f0);
        mapXtoUTF8[0x0efa]=QChar(0x11f9);
        mapXtoUTF8[0x0eff]=QChar(0x20a9);
        mapXtoUTF8[0x13bc]=QChar(0x0152);
        mapXtoUTF8[0x13bd]=QChar(0x0153);
        mapXtoUTF8[0x13be]=QChar(0x0178);
        mapXtoUTF8[0x20a0]=QChar(0x20a0);
        mapXtoUTF8[0x20a1]=QChar(0x20a1);
        mapXtoUTF8[0x20a2]=QChar(0x20a2);
        mapXtoUTF8[0x20a3]=QChar(0x20a3);
        mapXtoUTF8[0x20a4]=QChar(0x20a4);
        mapXtoUTF8[0x20a5]=QChar(0x20a5);
        mapXtoUTF8[0x20a6]=QChar(0x20a6);
        mapXtoUTF8[0x20a7]=QChar(0x20a7);
        mapXtoUTF8[0x20a8]=QChar(0x20a8);
        mapXtoUTF8[0x20a9]=QChar(0x20a9);
        mapXtoUTF8[0x20aa]=QChar(0x20aa);
        mapXtoUTF8[0x20ab]=QChar(0x20ab);
        mapXtoUTF8[0x20ac]=QChar(0x20ac);
        mapXtoUTF8[0xfd01]=QChar(0x0000);
        mapXtoUTF8[0xfd02]=QChar(0x0000);
        mapXtoUTF8[0xfd03]=QChar(0x0000);
        mapXtoUTF8[0xfd04]=QChar(0x0000);
        mapXtoUTF8[0xfd05]=QChar(0x0000);
        mapXtoUTF8[0xfd06]=QChar(0x0000);
        mapXtoUTF8[0xfd07]=QChar(0x0000);
        mapXtoUTF8[0xfd08]=QChar(0x0000);
        mapXtoUTF8[0xfd09]=QChar(0x0000);
        mapXtoUTF8[0xfd0a]=QChar(0x0000);
        mapXtoUTF8[0xfd0b]=QChar(0x0000);
        mapXtoUTF8[0xfd0c]=QChar(0x0000);
        mapXtoUTF8[0xfd0d]=QChar(0x0000);
        mapXtoUTF8[0xfd0e]=QChar(0x0000);
        mapXtoUTF8[0xfd0f]=QChar(0x0000);
        mapXtoUTF8[0xfd10]=QChar(0x0000);
        mapXtoUTF8[0xfd11]=QChar(0x0000);
        mapXtoUTF8[0xfd12]=QChar(0x0000);
        mapXtoUTF8[0xfd13]=QChar(0x0000);
        mapXtoUTF8[0xfd14]=QChar(0x0000);
        mapXtoUTF8[0xfd15]=QChar(0x0000);
        mapXtoUTF8[0xfd16]=QChar(0x0000);
        mapXtoUTF8[0xfd17]=QChar(0x0000);
        mapXtoUTF8[0xfd18]=QChar(0x0000);
        mapXtoUTF8[0xfd19]=QChar(0x0000);
        mapXtoUTF8[0xfd1a]=QChar(0x0000);
        mapXtoUTF8[0xfd1b]=QChar(0x0000);
        mapXtoUTF8[0xfd1c]=QChar(0x0000);
        mapXtoUTF8[0xfd1d]=QChar(0x0000);
        mapXtoUTF8[0xfd1e]=QChar(0x0000);
        mapXtoUTF8[0xfe01]=QChar(0x0000);
        mapXtoUTF8[0xfe02]=QChar(0x0000);
        mapXtoUTF8[0xfe03]=QChar(0x0000);
        mapXtoUTF8[0xfe04]=QChar(0x0000);
        mapXtoUTF8[0xfe05]=QChar(0x0000);
        mapXtoUTF8[0xfe06]=QChar(0x0000);
        mapXtoUTF8[0xfe07]=QChar(0x0000);
        mapXtoUTF8[0xfe08]=QChar(0x0000);
        mapXtoUTF8[0xfe09]=QChar(0x0000);
        mapXtoUTF8[0xfe0a]=QChar(0x0000);
        mapXtoUTF8[0xfe0b]=QChar(0x0000);
        mapXtoUTF8[0xfe0c]=QChar(0x0000);
        mapXtoUTF8[0xfe0d]=QChar(0x0000);
        mapXtoUTF8[0xfe0e]=QChar(0x0000);
        mapXtoUTF8[0xfe0f]=QChar(0x0000);
        mapXtoUTF8[0xfe20]=QChar(0x0000);
        mapXtoUTF8[0xfe21]=QChar(0x0000);
        mapXtoUTF8[0xfe22]=QChar(0x0000);
        mapXtoUTF8[0xfe23]=QChar(0x0000);
        mapXtoUTF8[0xfe24]=QChar(0x0000);
        mapXtoUTF8[0xfe25]=QChar(0x0000);
        mapXtoUTF8[0xfe26]=QChar(0x0000);
        mapXtoUTF8[0xfe27]=QChar(0x0000);
        mapXtoUTF8[0xfe28]=QChar(0x0000);
        mapXtoUTF8[0xfe29]=QChar(0x0000);
        mapXtoUTF8[0xfe2a]=QChar(0x0000);
        mapXtoUTF8[0xfe2b]=QChar(0x0000);
        mapXtoUTF8[0xfe2c]=QChar(0x0000);
        mapXtoUTF8[0xfe2d]=QChar(0x0000);
        mapXtoUTF8[0xfe2e]=QChar(0x0000);
        mapXtoUTF8[0xfe2f]=QChar(0x0000);
        mapXtoUTF8[0xfe30]=QChar(0x0000);
        mapXtoUTF8[0xfe31]=QChar(0x0000);
        mapXtoUTF8[0xfe32]=QChar(0x0000);
        mapXtoUTF8[0xfe33]=QChar(0x0000);
        mapXtoUTF8[0xfe34]=QChar(0x0000);
        mapXtoUTF8[0xfe50]=QChar(0x0300);
        mapXtoUTF8[0xfe51]=QChar(0x0301);
        mapXtoUTF8[0xfe52]=QChar(0x0302);
        mapXtoUTF8[0xfe53]=QChar(0x0303);
        mapXtoUTF8[0xfe54]=QChar(0x0304);
        mapXtoUTF8[0xfe55]=QChar(0x0306);
        mapXtoUTF8[0xfe56]=QChar(0x0307);
        mapXtoUTF8[0xfe57]=QChar(0x0308);
        mapXtoUTF8[0xfe58]=QChar(0x030a);
        mapXtoUTF8[0xfe59]=QChar(0x030b);
        mapXtoUTF8[0xfe5a]=QChar(0x030c);
        mapXtoUTF8[0xfe5b]=QChar(0x0327);
        mapXtoUTF8[0xfe5c]=QChar(0x0328);
        mapXtoUTF8[0xfe5d]=QChar(0x0345);
        mapXtoUTF8[0xfe5e]=QChar(0x3099);
        mapXtoUTF8[0xfe5f]=QChar(0x309a);
        mapXtoUTF8[0xfe70]=QChar(0x0000);
        mapXtoUTF8[0xfe71]=QChar(0x0000);
        mapXtoUTF8[0xfe72]=QChar(0x0000);
        mapXtoUTF8[0xfe73]=QChar(0x0000);
        mapXtoUTF8[0xfe74]=QChar(0x0000);
        mapXtoUTF8[0xfe75]=QChar(0x0000);
        mapXtoUTF8[0xfe76]=QChar(0x0000);
        mapXtoUTF8[0xfe77]=QChar(0x0000);
        mapXtoUTF8[0xfe78]=QChar(0x0000);
        mapXtoUTF8[0xfe79]=QChar(0x0000);
        mapXtoUTF8[0xfe7a]=QChar(0x0000);
        mapXtoUTF8[0xfed0]=QChar(0x0000);
        mapXtoUTF8[0xfed1]=QChar(0x0000);
        mapXtoUTF8[0xfed2]=QChar(0x0000);
        mapXtoUTF8[0xfed4]=QChar(0x0000);
        mapXtoUTF8[0xfed5]=QChar(0x0000);
        mapXtoUTF8[0xfee0]=QChar(0x0000);
        mapXtoUTF8[0xfee1]=QChar(0x0000);
        mapXtoUTF8[0xfee2]=QChar(0x0000);
        mapXtoUTF8[0xfee3]=QChar(0x0000);
        mapXtoUTF8[0xfee4]=QChar(0x0000);
        mapXtoUTF8[0xfee5]=QChar(0x0000);
        mapXtoUTF8[0xfee6]=QChar(0x0000);
        mapXtoUTF8[0xfee7]=QChar(0x0000);
        mapXtoUTF8[0xfee8]=QChar(0x0000);
        mapXtoUTF8[0xfee9]=QChar(0x0000);
        mapXtoUTF8[0xfeea]=QChar(0x0000);
        mapXtoUTF8[0xfeeb]=QChar(0x0000);
        mapXtoUTF8[0xfeec]=QChar(0x0000);
        mapXtoUTF8[0xfeed]=QChar(0x0000);
        mapXtoUTF8[0xfeee]=QChar(0x0000);
        mapXtoUTF8[0xfeef]=QChar(0x0000);
        mapXtoUTF8[0xfef0]=QChar(0x0000);
        mapXtoUTF8[0xfef1]=QChar(0x0000);
        mapXtoUTF8[0xfef2]=QChar(0x0000);
        mapXtoUTF8[0xfef3]=QChar(0x0000);
        mapXtoUTF8[0xfef4]=QChar(0x0000);
        mapXtoUTF8[0xfef5]=QChar(0x0000);
        mapXtoUTF8[0xfef6]=QChar(0x0000);
        mapXtoUTF8[0xfef7]=QChar(0x0000);
        mapXtoUTF8[0xfef8]=QChar(0x0000);
        mapXtoUTF8[0xfef9]=QChar(0x0000);
        mapXtoUTF8[0xfefa]=QChar(0x0000);
        mapXtoUTF8[0xfefb]=QChar(0x0000);
        mapXtoUTF8[0xfefc]=QChar(0x0000);
        mapXtoUTF8[0xfefd]=QChar(0x0000);
        mapXtoUTF8[0xff08]=QChar(0x0008);
        mapXtoUTF8[0xff09]=QChar(0x0009);
        mapXtoUTF8[0xff0a]=QChar(0x000a);
        mapXtoUTF8[0xff0b]=QChar(0x000b);
        mapXtoUTF8[0xff0d]=QChar(0x000d);
        mapXtoUTF8[0xff13]=QChar(0x0013);
        mapXtoUTF8[0xff14]=QChar(0x0014);
        mapXtoUTF8[0xff15]=QChar(0x0015);
        mapXtoUTF8[0xff1b]=QChar(0x001b);
        mapXtoUTF8[0xff20]=QChar(0x0000);
        mapXtoUTF8[0xff21]=QChar(0x0000);
        mapXtoUTF8[0xff22]=QChar(0x0000);
        mapXtoUTF8[0xff23]=QChar(0x0000);
        mapXtoUTF8[0xff24]=QChar(0x0000);
        mapXtoUTF8[0xff25]=QChar(0x0000);
        mapXtoUTF8[0xff26]=QChar(0x0000);
        mapXtoUTF8[0xff27]=QChar(0x0000);
        mapXtoUTF8[0xff28]=QChar(0x0000);
        mapXtoUTF8[0xff29]=QChar(0x0000);
        mapXtoUTF8[0xff2a]=QChar(0x0000);
        mapXtoUTF8[0xff2b]=QChar(0x0000);
        mapXtoUTF8[0xff2c]=QChar(0x0000);
        mapXtoUTF8[0xff2d]=QChar(0x0000);
        mapXtoUTF8[0xff2e]=QChar(0x0000);
        mapXtoUTF8[0xff2f]=QChar(0x0000);
        mapXtoUTF8[0xff30]=QChar(0x0000);
        mapXtoUTF8[0xff31]=QChar(0x0000);
        mapXtoUTF8[0xff32]=QChar(0x0000);
        mapXtoUTF8[0xff33]=QChar(0x0000);
        mapXtoUTF8[0xff34]=QChar(0x0000);
        mapXtoUTF8[0xff35]=QChar(0x0000);
        mapXtoUTF8[0xff36]=QChar(0x0000);
        mapXtoUTF8[0xff37]=QChar(0x0000);
        mapXtoUTF8[0xff38]=QChar(0x0000);
        mapXtoUTF8[0xff39]=QChar(0x0000);
        mapXtoUTF8[0xff3a]=QChar(0x0000);
        mapXtoUTF8[0xff3b]=QChar(0x0000);
        mapXtoUTF8[0xff3c]=QChar(0x0000);
        mapXtoUTF8[0xff3d]=QChar(0x0000);
        mapXtoUTF8[0xff3e]=QChar(0x0000);
        mapXtoUTF8[0xff3f]=QChar(0x0000);
        mapXtoUTF8[0xff50]=QChar(0x0000);
        mapXtoUTF8[0xff51]=QChar(0x0000);
        mapXtoUTF8[0xff52]=QChar(0x0000);
        mapXtoUTF8[0xff53]=QChar(0x0000);
        mapXtoUTF8[0xff54]=QChar(0x0000);
        mapXtoUTF8[0xff55]=QChar(0x0000);
        mapXtoUTF8[0xff56]=QChar(0x0000);
        mapXtoUTF8[0xff57]=QChar(0x0000);
        mapXtoUTF8[0xff58]=QChar(0x0000);
        mapXtoUTF8[0xff60]=QChar(0x0000);
        mapXtoUTF8[0xff61]=QChar(0x0000);
        mapXtoUTF8[0xff62]=QChar(0x0000);
        mapXtoUTF8[0xff63]=QChar(0x0000);
        mapXtoUTF8[0xff65]=QChar(0x0000);
        mapXtoUTF8[0xff66]=QChar(0x0000);
        mapXtoUTF8[0xff67]=QChar(0x0000);
        mapXtoUTF8[0xff68]=QChar(0x0000);
        mapXtoUTF8[0xff69]=QChar(0x0000);
        mapXtoUTF8[0xff6a]=QChar(0x0000);
        mapXtoUTF8[0xff6b]=QChar(0x0000);
        mapXtoUTF8[0xff7e]=QChar(0x0000);
        mapXtoUTF8[0xff7f]=QChar(0x0000);
        mapXtoUTF8[0xff80]=QChar(0x0020);
        mapXtoUTF8[0xff89]=QChar(0x0009);
        mapXtoUTF8[0xff8d]=QChar(0x000d);
        mapXtoUTF8[0xff91]=QChar(0x0000);
        mapXtoUTF8[0xff92]=QChar(0x0000);
        mapXtoUTF8[0xff93]=QChar(0x0000);
        mapXtoUTF8[0xff94]=QChar(0x0000);
        mapXtoUTF8[0xff95]=QChar(0x0000);
        mapXtoUTF8[0xff96]=QChar(0x0000);
        mapXtoUTF8[0xff97]=QChar(0x0000);
        mapXtoUTF8[0xff98]=QChar(0x0000);
        mapXtoUTF8[0xff99]=QChar(0x0000);
        mapXtoUTF8[0xff9a]=QChar(0x0000);
        mapXtoUTF8[0xff9b]=QChar(0x0000);
        mapXtoUTF8[0xff9c]=QChar(0x0000);
        mapXtoUTF8[0xff9d]=QChar(0x0000);
        mapXtoUTF8[0xff9e]=QChar(0x0000);
        mapXtoUTF8[0xff9f]=QChar(0x0000);
        mapXtoUTF8[0xffaa]=QChar(0x002a);
        mapXtoUTF8[0xffab]=QChar(0x002b);
        mapXtoUTF8[0xffac]=QChar(0x002c);
        mapXtoUTF8[0xffad]=QChar(0x002d);
        mapXtoUTF8[0xffae]=QChar(0x002e);
        mapXtoUTF8[0xffaf]=QChar(0x002f);
        mapXtoUTF8[0xffb0]=QChar(0x0030);
        mapXtoUTF8[0xffb1]=QChar(0x0031);
        mapXtoUTF8[0xffb2]=QChar(0x0032);
        mapXtoUTF8[0xffb3]=QChar(0x0033);
        mapXtoUTF8[0xffb4]=QChar(0x0034);
        mapXtoUTF8[0xffb5]=QChar(0x0035);
        mapXtoUTF8[0xffb6]=QChar(0x0036);
        mapXtoUTF8[0xffb7]=QChar(0x0037);
        mapXtoUTF8[0xffb8]=QChar(0x0038);
        mapXtoUTF8[0xffb9]=QChar(0x0039);
        mapXtoUTF8[0xffbd]=QChar(0x003d);
        mapXtoUTF8[0xffbe]=QChar(0x0000);
        mapXtoUTF8[0xffbf]=QChar(0x0000);
        mapXtoUTF8[0xffc0]=QChar(0x0000);
        mapXtoUTF8[0xffc1]=QChar(0x0000);
        mapXtoUTF8[0xffc2]=QChar(0x0000);
        mapXtoUTF8[0xffc3]=QChar(0x0000);
        mapXtoUTF8[0xffc4]=QChar(0x0000);
        mapXtoUTF8[0xffc5]=QChar(0x0000);
        mapXtoUTF8[0xffc6]=QChar(0x0000);
        mapXtoUTF8[0xffc7]=QChar(0x0000);
        mapXtoUTF8[0xffc8]=QChar(0x0000);
        mapXtoUTF8[0xffc9]=QChar(0x0000);
        mapXtoUTF8[0xffca]=QChar(0x0000);
        mapXtoUTF8[0xffcb]=QChar(0x0000);
        mapXtoUTF8[0xffcc]=QChar(0x0000);
        mapXtoUTF8[0xffcd]=QChar(0x0000);
        mapXtoUTF8[0xffce]=QChar(0x0000);
        mapXtoUTF8[0xffcf]=QChar(0x0000);
        mapXtoUTF8[0xffd0]=QChar(0x0000);
        mapXtoUTF8[0xffd1]=QChar(0x0000);
        mapXtoUTF8[0xffd2]=QChar(0x0000);
        mapXtoUTF8[0xffd3]=QChar(0x0000);
        mapXtoUTF8[0xffd4]=QChar(0x0000);
        mapXtoUTF8[0xffd5]=QChar(0x0000);
        mapXtoUTF8[0xffd6]=QChar(0x0000);
        mapXtoUTF8[0xffd7]=QChar(0x0000);
        mapXtoUTF8[0xffd8]=QChar(0x0000);
        mapXtoUTF8[0xffd9]=QChar(0x0000);
        mapXtoUTF8[0xffda]=QChar(0x0000);
        mapXtoUTF8[0xffdb]=QChar(0x0000);
        mapXtoUTF8[0xffdc]=QChar(0x0000);
        mapXtoUTF8[0xffdd]=QChar(0x0000);
        mapXtoUTF8[0xffde]=QChar(0x0000);
        mapXtoUTF8[0xffdf]=QChar(0x0000);
        mapXtoUTF8[0xffe0]=QChar(0x0000);
        mapXtoUTF8[0xffe1]=QChar(0x0000);
        mapXtoUTF8[0xffe2]=QChar(0x0000);
        mapXtoUTF8[0xffe3]=QChar(0x0000);
        mapXtoUTF8[0xffe4]=QChar(0x0000);
        mapXtoUTF8[0xffe5]=QChar(0x0000);
        mapXtoUTF8[0xffe6]=QChar(0x0000);
        mapXtoUTF8[0xffe7]=QChar(0x0000);
        mapXtoUTF8[0xffe8]=QChar(0x0000);
        mapXtoUTF8[0xffe9]=QChar(0x0000);
        mapXtoUTF8[0xffea]=QChar(0x0000);
        mapXtoUTF8[0xffeb]=QChar(0x0000);
        mapXtoUTF8[0xffec]=QChar(0x0000);
        mapXtoUTF8[0xffed]=QChar(0x0000);
        mapXtoUTF8[0xffee]=QChar(0x0000);
        mapXtoUTF8[0xffff]=QChar(0x0000);
        mapXtoUTF8[0x06ad]=QChar(0x0491);
        mapXtoUTF8[0x06bd]=QChar(0x0490);
        mapXtoUTF8[0x14a1]=QChar(0x0000);
        mapXtoUTF8[0x14a2]=QChar(0x0587);
        mapXtoUTF8[0x14a3]=QChar(0x0589);
        mapXtoUTF8[0x14a4]=QChar(0x0029);
        mapXtoUTF8[0x14a5]=QChar(0x0028);
        mapXtoUTF8[0x14a6]=QChar(0x00bb);
        mapXtoUTF8[0x14a7]=QChar(0x00ab);
        mapXtoUTF8[0x14a8]=QChar(0x2014);
        mapXtoUTF8[0x14a9]=QChar(0x002e);
        mapXtoUTF8[0x14aa]=QChar(0x055d);
        mapXtoUTF8[0x14ab]=QChar(0x002c);
        mapXtoUTF8[0x14ac]=QChar(0x2013);
        mapXtoUTF8[0x14ad]=QChar(0x058a);
        mapXtoUTF8[0x14ae]=QChar(0x2026);
        mapXtoUTF8[0x14af]=QChar(0x055c);
        mapXtoUTF8[0x14b0]=QChar(0x055b);
        mapXtoUTF8[0x14b1]=QChar(0x055e);
        mapXtoUTF8[0x14b2]=QChar(0x0531);
        mapXtoUTF8[0x14b3]=QChar(0x0561);
        mapXtoUTF8[0x14b4]=QChar(0x0532);
        mapXtoUTF8[0x14b5]=QChar(0x0562);
        mapXtoUTF8[0x14b6]=QChar(0x0533);
        mapXtoUTF8[0x14b7]=QChar(0x0563);
        mapXtoUTF8[0x14b8]=QChar(0x0534);
        mapXtoUTF8[0x14b9]=QChar(0x0564);
        mapXtoUTF8[0x14ba]=QChar(0x0535);
        mapXtoUTF8[0x14bb]=QChar(0x0565);
        mapXtoUTF8[0x14bc]=QChar(0x0536);
        mapXtoUTF8[0x14bd]=QChar(0x0566);
        mapXtoUTF8[0x14be]=QChar(0x0537);
        mapXtoUTF8[0x14bf]=QChar(0x0567);
        mapXtoUTF8[0x14c0]=QChar(0x0538);
        mapXtoUTF8[0x14c1]=QChar(0x0568);
        mapXtoUTF8[0x14c2]=QChar(0x0539);
        mapXtoUTF8[0x14c3]=QChar(0x0569);
        mapXtoUTF8[0x14c4]=QChar(0x053a);
        mapXtoUTF8[0x14c5]=QChar(0x056a);
        mapXtoUTF8[0x14c6]=QChar(0x053b);
        mapXtoUTF8[0x14c7]=QChar(0x056b);
        mapXtoUTF8[0x14c8]=QChar(0x053c);
        mapXtoUTF8[0x14c9]=QChar(0x056c);
        mapXtoUTF8[0x14ca]=QChar(0x053d);
        mapXtoUTF8[0x14cb]=QChar(0x056d);
        mapXtoUTF8[0x14cc]=QChar(0x053e);
        mapXtoUTF8[0x14cd]=QChar(0x056e);
        mapXtoUTF8[0x14ce]=QChar(0x053f);
        mapXtoUTF8[0x14cf]=QChar(0x056f);
        mapXtoUTF8[0x14d0]=QChar(0x0540);
        mapXtoUTF8[0x14d1]=QChar(0x0570);
        mapXtoUTF8[0x14d2]=QChar(0x0541);
        mapXtoUTF8[0x14d3]=QChar(0x0571);
        mapXtoUTF8[0x14d4]=QChar(0x0542);
        mapXtoUTF8[0x14d5]=QChar(0x0572);
        mapXtoUTF8[0x14d6]=QChar(0x0543);
        mapXtoUTF8[0x14d7]=QChar(0x0573);
        mapXtoUTF8[0x14d8]=QChar(0x0544);
        mapXtoUTF8[0x14d9]=QChar(0x0574);
        mapXtoUTF8[0x14da]=QChar(0x0545);
        mapXtoUTF8[0x14db]=QChar(0x0575);
        mapXtoUTF8[0x14dc]=QChar(0x0546);
        mapXtoUTF8[0x14dd]=QChar(0x0576);
        mapXtoUTF8[0x14de]=QChar(0x0547);
        mapXtoUTF8[0x14df]=QChar(0x0577);
        mapXtoUTF8[0x14e0]=QChar(0x0548);
        mapXtoUTF8[0x14e1]=QChar(0x0578);
        mapXtoUTF8[0x14e2]=QChar(0x0549);
        mapXtoUTF8[0x14e3]=QChar(0x0579);
        mapXtoUTF8[0x14e4]=QChar(0x054a);
        mapXtoUTF8[0x14e5]=QChar(0x057a);
        mapXtoUTF8[0x14e6]=QChar(0x054b);
        mapXtoUTF8[0x14e7]=QChar(0x057b);
        mapXtoUTF8[0x14e8]=QChar(0x054c);
        mapXtoUTF8[0x14e9]=QChar(0x057c);
        mapXtoUTF8[0x14ea]=QChar(0x054d);
        mapXtoUTF8[0x14eb]=QChar(0x057d);
        mapXtoUTF8[0x14ec]=QChar(0x054e);
        mapXtoUTF8[0x14ed]=QChar(0x057e);
        mapXtoUTF8[0x14ee]=QChar(0x054f);
        mapXtoUTF8[0x14ef]=QChar(0x057f);
        mapXtoUTF8[0x14f0]=QChar(0x0550);
        mapXtoUTF8[0x14f1]=QChar(0x0580);
        mapXtoUTF8[0x14f2]=QChar(0x0551);
        mapXtoUTF8[0x14f3]=QChar(0x0581);
        mapXtoUTF8[0x14f4]=QChar(0x0552);
        mapXtoUTF8[0x14f5]=QChar(0x0582);
        mapXtoUTF8[0x14f6]=QChar(0x0553);
        mapXtoUTF8[0x14f7]=QChar(0x0583);
        mapXtoUTF8[0x14f8]=QChar(0x0554);
        mapXtoUTF8[0x14f9]=QChar(0x0584);
        mapXtoUTF8[0x14fa]=QChar(0x0555);
        mapXtoUTF8[0x14fb]=QChar(0x0585);
        mapXtoUTF8[0x14fc]=QChar(0x0556);
        mapXtoUTF8[0x14fd]=QChar(0x0586);
        mapXtoUTF8[0x14fe]=QChar(0x055a);
        mapXtoUTF8[0x14ff]=QChar(0x00a7);
        mapXtoUTF8[0x15d0]=QChar(0x10d0);
        mapXtoUTF8[0x15d1]=QChar(0x10d1);
        mapXtoUTF8[0x15d2]=QChar(0x10d2);
        mapXtoUTF8[0x15d3]=QChar(0x10d3);
        mapXtoUTF8[0x15d4]=QChar(0x10d4);
        mapXtoUTF8[0x15d5]=QChar(0x10d5);
        mapXtoUTF8[0x15d6]=QChar(0x10d6);
        mapXtoUTF8[0x15d7]=QChar(0x10d7);
        mapXtoUTF8[0x15d8]=QChar(0x10d8);
        mapXtoUTF8[0x15d9]=QChar(0x10d9);
        mapXtoUTF8[0x15da]=QChar(0x10da);
        mapXtoUTF8[0x15db]=QChar(0x10db);
        mapXtoUTF8[0x15dc]=QChar(0x10dc);
        mapXtoUTF8[0x15dd]=QChar(0x10dd);
        mapXtoUTF8[0x15de]=QChar(0x10de);
        mapXtoUTF8[0x15df]=QChar(0x10df);
        mapXtoUTF8[0x15e0]=QChar(0x10e0);
        mapXtoUTF8[0x15e1]=QChar(0x10e1);
        mapXtoUTF8[0x15e2]=QChar(0x10e2);
        mapXtoUTF8[0x15e3]=QChar(0x10e3);
        mapXtoUTF8[0x15e4]=QChar(0x10e4);
        mapXtoUTF8[0x15e5]=QChar(0x10e5);
        mapXtoUTF8[0x15e6]=QChar(0x10e6);
        mapXtoUTF8[0x15e7]=QChar(0x10e7);
        mapXtoUTF8[0x15e8]=QChar(0x10e8);
        mapXtoUTF8[0x15e9]=QChar(0x10e9);
        mapXtoUTF8[0x15ea]=QChar(0x10ea);
        mapXtoUTF8[0x15eb]=QChar(0x10eb);
        mapXtoUTF8[0x15ec]=QChar(0x10ec);
        mapXtoUTF8[0x15ed]=QChar(0x10ed);
        mapXtoUTF8[0x15ee]=QChar(0x10ee);
        mapXtoUTF8[0x15ef]=QChar(0x10ef);
        mapXtoUTF8[0x15f0]=QChar(0x10f0);
        mapXtoUTF8[0x15f1]=QChar(0x10f1);
        mapXtoUTF8[0x15f2]=QChar(0x10f2);
        mapXtoUTF8[0x15f3]=QChar(0x10f3);
        mapXtoUTF8[0x15f4]=QChar(0x10f4);
        mapXtoUTF8[0x15f5]=QChar(0x10f5);
        mapXtoUTF8[0x15f6]=QChar(0x10f6);
        mapXtoUTF8[0x12a1]=QChar(0x1e02);
        mapXtoUTF8[0x12a2]=QChar(0x1e03);
        mapXtoUTF8[0x12a6]=QChar(0x1e0a);
        mapXtoUTF8[0x12a8]=QChar(0x1e80);
        mapXtoUTF8[0x12aa]=QChar(0x1e82);
        mapXtoUTF8[0x12ab]=QChar(0x1e0b);
        mapXtoUTF8[0x12ac]=QChar(0x1ef2);
        mapXtoUTF8[0x12b0]=QChar(0x1e1e);
        mapXtoUTF8[0x12b1]=QChar(0x1e1f);
        mapXtoUTF8[0x12b4]=QChar(0x1e40);
        mapXtoUTF8[0x12b5]=QChar(0x1e41);
        mapXtoUTF8[0x12b7]=QChar(0x1e56);
        mapXtoUTF8[0x12b8]=QChar(0x1e81);
        mapXtoUTF8[0x12b9]=QChar(0x1e57);
        mapXtoUTF8[0x12ba]=QChar(0x1e83);
        mapXtoUTF8[0x12bb]=QChar(0x1e60);
        mapXtoUTF8[0x12bc]=QChar(0x1ef3);
        mapXtoUTF8[0x12bd]=QChar(0x1e84);
        mapXtoUTF8[0x12be]=QChar(0x1e85);
        mapXtoUTF8[0x12bf]=QChar(0x1e61);
        mapXtoUTF8[0x12d0]=QChar(0x0174);
        mapXtoUTF8[0x12d7]=QChar(0x1e6a);
        mapXtoUTF8[0x12de]=QChar(0x0176);
        mapXtoUTF8[0x12f0]=QChar(0x0175);
        mapXtoUTF8[0x12f7]=QChar(0x1e6b);
        mapXtoUTF8[0x12fe]=QChar(0x0177);
        mapXtoUTF8[0x0590]=QChar(0x06f0);
        mapXtoUTF8[0x0591]=QChar(0x06f1);
        mapXtoUTF8[0x0592]=QChar(0x06f2);
        mapXtoUTF8[0x0593]=QChar(0x06f3);
        mapXtoUTF8[0x0594]=QChar(0x06f4);
        mapXtoUTF8[0x0595]=QChar(0x06f5);
        mapXtoUTF8[0x0596]=QChar(0x06f6);
        mapXtoUTF8[0x0597]=QChar(0x06f7);
        mapXtoUTF8[0x0598]=QChar(0x06f8);
        mapXtoUTF8[0x0599]=QChar(0x06f9);
        mapXtoUTF8[0x05a5]=QChar(0x066a);
        mapXtoUTF8[0x05a6]=QChar(0x0670);
        mapXtoUTF8[0x05a7]=QChar(0x0679);
        mapXtoUTF8[0x05a8]=QChar(0x067e);
        mapXtoUTF8[0x05a9]=QChar(0x0686);
        mapXtoUTF8[0x05aa]=QChar(0x0688);
        mapXtoUTF8[0x05ab]=QChar(0x0691);
        mapXtoUTF8[0x05ae]=QChar(0x06d4);
        mapXtoUTF8[0x05b0]=QChar(0x0660);
        mapXtoUTF8[0x05b1]=QChar(0x0661);
        mapXtoUTF8[0x05b2]=QChar(0x0662);
        mapXtoUTF8[0x05b3]=QChar(0x0663);
        mapXtoUTF8[0x05b4]=QChar(0x0664);
        mapXtoUTF8[0x05b5]=QChar(0x0665);
        mapXtoUTF8[0x05b6]=QChar(0x0666);
        mapXtoUTF8[0x05b7]=QChar(0x0667);
        mapXtoUTF8[0x05b8]=QChar(0x0668);
        mapXtoUTF8[0x05b9]=QChar(0x0669);
        mapXtoUTF8[0x05f3]=QChar(0x0653);
        mapXtoUTF8[0x05f4]=QChar(0x0654);
        mapXtoUTF8[0x05f5]=QChar(0x0655);
        mapXtoUTF8[0x05f6]=QChar(0x0698);
        mapXtoUTF8[0x05f7]=QChar(0x06a4);
        mapXtoUTF8[0x05f8]=QChar(0x06a9);
        mapXtoUTF8[0x05f9]=QChar(0x06af);
        mapXtoUTF8[0x05fa]=QChar(0x06ba);
        mapXtoUTF8[0x05fb]=QChar(0x06be);
        mapXtoUTF8[0x05fc]=QChar(0x06cc);
        mapXtoUTF8[0x05fd]=QChar(0x06d2);
        mapXtoUTF8[0x05fe]=QChar(0x06c1);
        mapXtoUTF8[0x0680]=QChar(0x0492);
        mapXtoUTF8[0x0681]=QChar(0x0496);
        mapXtoUTF8[0x0682]=QChar(0x049a);
        mapXtoUTF8[0x0683]=QChar(0x049c);
        mapXtoUTF8[0x0684]=QChar(0x04a2);
        mapXtoUTF8[0x0685]=QChar(0x04ae);
        mapXtoUTF8[0x0686]=QChar(0x04b0);
        mapXtoUTF8[0x0687]=QChar(0x04b2);
        mapXtoUTF8[0x0688]=QChar(0x04b6);
        mapXtoUTF8[0x0689]=QChar(0x04b8);
        mapXtoUTF8[0x068a]=QChar(0x04ba);
        mapXtoUTF8[0x068c]=QChar(0x04d8);
        mapXtoUTF8[0x068d]=QChar(0x04e2);
        mapXtoUTF8[0x068e]=QChar(0x04e8);
        mapXtoUTF8[0x068f]=QChar(0x04ee);
        mapXtoUTF8[0x0690]=QChar(0x0493);
        mapXtoUTF8[0x0691]=QChar(0x0497);
        mapXtoUTF8[0x0692]=QChar(0x049b);
        mapXtoUTF8[0x0693]=QChar(0x049d);
        mapXtoUTF8[0x0694]=QChar(0x04a3);
        mapXtoUTF8[0x0695]=QChar(0x04af);
        mapXtoUTF8[0x0696]=QChar(0x04b1);
        mapXtoUTF8[0x0697]=QChar(0x04b3);
        mapXtoUTF8[0x0698]=QChar(0x04b7);
        mapXtoUTF8[0x0699]=QChar(0x04b9);
        mapXtoUTF8[0x069a]=QChar(0x04bb);
        mapXtoUTF8[0x069c]=QChar(0x04d9);
        mapXtoUTF8[0x069d]=QChar(0x04e3);
        mapXtoUTF8[0x069e]=QChar(0x04e9);
        mapXtoUTF8[0x069f]=QChar(0x04ef);
        mapXtoUTF8[0x16a2]=QChar(0x0000);
        mapXtoUTF8[0x16a3]=QChar(0x1e8a);
        mapXtoUTF8[0x16a5]=QChar(0x0000);
        mapXtoUTF8[0x16a6]=QChar(0x012c);
        mapXtoUTF8[0x16a7]=QChar(0x0000);
        mapXtoUTF8[0x16a8]=QChar(0x0000);
        mapXtoUTF8[0x16a9]=QChar(0x01b5);
        mapXtoUTF8[0x16aa]=QChar(0x01e6);
        mapXtoUTF8[0x16af]=QChar(0x019f);
        mapXtoUTF8[0x16b2]=QChar(0x0000);
        mapXtoUTF8[0x16b3]=QChar(0x1e8b);
        mapXtoUTF8[0x16b4]=QChar(0x0000);
        mapXtoUTF8[0x16b5]=QChar(0x0000);
        mapXtoUTF8[0x16b6]=QChar(0x012d);
        mapXtoUTF8[0x16b7]=QChar(0x0000);
        mapXtoUTF8[0x16b8]=QChar(0x0000);
        mapXtoUTF8[0x16b9]=QChar(0x01b6);
        mapXtoUTF8[0x16ba]=QChar(0x01e7);
        mapXtoUTF8[0x16bd]=QChar(0x01d2);
        mapXtoUTF8[0x16bf]=QChar(0x0275);
        mapXtoUTF8[0x16c6]=QChar(0x018f);
        mapXtoUTF8[0x16f6]=QChar(0x0259);
        mapXtoUTF8[0x16d1]=QChar(0x1e36);
        mapXtoUTF8[0x16d2]=QChar(0x0000);
        mapXtoUTF8[0x16d3]=QChar(0x0000);
        mapXtoUTF8[0x16e1]=QChar(0x1e37);
        mapXtoUTF8[0x16e2]=QChar(0x0000);
        mapXtoUTF8[0x16e3]=QChar(0x0000);
        mapXtoUTF8[0x1ea0]=QChar(0x1ea0);
        mapXtoUTF8[0x1ea1]=QChar(0x1ea1);
        mapXtoUTF8[0x1ea2]=QChar(0x1ea2);
        mapXtoUTF8[0x1ea3]=QChar(0x1ea3);
        mapXtoUTF8[0x1ea4]=QChar(0x1ea4);
        mapXtoUTF8[0x1ea5]=QChar(0x1ea5);
        mapXtoUTF8[0x1ea6]=QChar(0x1ea6);
        mapXtoUTF8[0x1ea7]=QChar(0x1ea7);
        mapXtoUTF8[0x1ea8]=QChar(0x1ea8);
        mapXtoUTF8[0x1ea9]=QChar(0x1ea9);
        mapXtoUTF8[0x1eaa]=QChar(0x1eaa);
        mapXtoUTF8[0x1eab]=QChar(0x1eab);
        mapXtoUTF8[0x1eac]=QChar(0x1eac);
        mapXtoUTF8[0x1ead]=QChar(0x1ead);
        mapXtoUTF8[0x1eae]=QChar(0x1eae);
        mapXtoUTF8[0x1eaf]=QChar(0x1eaf);
        mapXtoUTF8[0x1eb0]=QChar(0x1eb0);
        mapXtoUTF8[0x1eb1]=QChar(0x1eb1);
        mapXtoUTF8[0x1eb2]=QChar(0x1eb2);
        mapXtoUTF8[0x1eb3]=QChar(0x1eb3);
        mapXtoUTF8[0x1eb4]=QChar(0x1eb4);
        mapXtoUTF8[0x1eb5]=QChar(0x1eb5);
        mapXtoUTF8[0x1eb6]=QChar(0x1eb6);
        mapXtoUTF8[0x1eb7]=QChar(0x1eb7);
        mapXtoUTF8[0x1eb8]=QChar(0x1eb8);
        mapXtoUTF8[0x1eb9]=QChar(0x1eb9);
        mapXtoUTF8[0x1eba]=QChar(0x1eba);
        mapXtoUTF8[0x1ebb]=QChar(0x1ebb);
        mapXtoUTF8[0x1ebc]=QChar(0x1ebc);
        mapXtoUTF8[0x1ebd]=QChar(0x1ebd);
        mapXtoUTF8[0x1ebe]=QChar(0x1ebe);
        mapXtoUTF8[0x1ebf]=QChar(0x1ebf);
        mapXtoUTF8[0x1ec0]=QChar(0x1ec0);
        mapXtoUTF8[0x1ec1]=QChar(0x1ec1);
        mapXtoUTF8[0x1ec2]=QChar(0x1ec2);
        mapXtoUTF8[0x1ec3]=QChar(0x1ec3);
        mapXtoUTF8[0x1ec4]=QChar(0x1ec4);
        mapXtoUTF8[0x1ec5]=QChar(0x1ec5);
        mapXtoUTF8[0x1ec6]=QChar(0x1ec6);
        mapXtoUTF8[0x1ec7]=QChar(0x1ec7);
        mapXtoUTF8[0x1ec8]=QChar(0x1ec8);
        mapXtoUTF8[0x1ec9]=QChar(0x1ec9);
        mapXtoUTF8[0x1eca]=QChar(0x1eca);
        mapXtoUTF8[0x1ecb]=QChar(0x1ecb);
        mapXtoUTF8[0x1ecc]=QChar(0x1ecc);
        mapXtoUTF8[0x1ecd]=QChar(0x1ecd);
        mapXtoUTF8[0x1ece]=QChar(0x1ece);
        mapXtoUTF8[0x1ecf]=QChar(0x1ecf);
        mapXtoUTF8[0x1ed0]=QChar(0x1ed0);
        mapXtoUTF8[0x1ed1]=QChar(0x1ed1);
        mapXtoUTF8[0x1ed2]=QChar(0x1ed2);
        mapXtoUTF8[0x1ed3]=QChar(0x1ed3);
        mapXtoUTF8[0x1ed4]=QChar(0x1ed4);
        mapXtoUTF8[0x1ed5]=QChar(0x1ed5);
        mapXtoUTF8[0x1ed6]=QChar(0x1ed6);
        mapXtoUTF8[0x1ed7]=QChar(0x1ed7);
        mapXtoUTF8[0x1ed8]=QChar(0x1ed8);
        mapXtoUTF8[0x1ed9]=QChar(0x1ed9);
        mapXtoUTF8[0x1eda]=QChar(0x1eda);
        mapXtoUTF8[0x1edb]=QChar(0x1edb);
        mapXtoUTF8[0x1edc]=QChar(0x1edc);
        mapXtoUTF8[0x1edd]=QChar(0x1edd);
        mapXtoUTF8[0x1ede]=QChar(0x1ede);
        mapXtoUTF8[0x1edf]=QChar(0x1edf);
        mapXtoUTF8[0x1ee0]=QChar(0x1ee0);
        mapXtoUTF8[0x1ee1]=QChar(0x1ee1);
        mapXtoUTF8[0x1ee2]=QChar(0x1ee2);
        mapXtoUTF8[0x1ee3]=QChar(0x1ee3);
        mapXtoUTF8[0x1ee4]=QChar(0x1ee4);
        mapXtoUTF8[0x1ee5]=QChar(0x1ee5);
        mapXtoUTF8[0x1ee6]=QChar(0x1ee6);
        mapXtoUTF8[0x1ee7]=QChar(0x1ee7);
        mapXtoUTF8[0x1ee8]=QChar(0x1ee8);
        mapXtoUTF8[0x1ee9]=QChar(0x1ee9);
        mapXtoUTF8[0x1eea]=QChar(0x1eea);
        mapXtoUTF8[0x1eeb]=QChar(0x1eeb);
        mapXtoUTF8[0x1eec]=QChar(0x1eec);
        mapXtoUTF8[0x1eed]=QChar(0x1eed);
        mapXtoUTF8[0x1eee]=QChar(0x1eee);
        mapXtoUTF8[0x1eef]=QChar(0x1eef);
        mapXtoUTF8[0x1ef0]=QChar(0x1ef0);
        mapXtoUTF8[0x1ef1]=QChar(0x1ef1);
        mapXtoUTF8[0x1ef4]=QChar(0x1ef4);
        mapXtoUTF8[0x1ef5]=QChar(0x1ef5);
        mapXtoUTF8[0x1ef6]=QChar(0x1ef6);
        mapXtoUTF8[0x1ef7]=QChar(0x1ef7);
        mapXtoUTF8[0x1ef8]=QChar(0x1ef8);
        mapXtoUTF8[0x1ef9]=QChar(0x1ef9);
        mapXtoUTF8[0x1efa]=QChar(0x01a0);
        mapXtoUTF8[0x1efb]=QChar(0x01a1);
        mapXtoUTF8[0x1efc]=QChar(0x01af);
        mapXtoUTF8[0x1efd]=QChar(0x01b0);
        mapXtoUTF8[0x1e9f]=QChar(0x0303);
        mapXtoUTF8[0x1ef2]=QChar(0x0300);
        mapXtoUTF8[0x1ef3]=QChar(0x0301);
        mapXtoUTF8[0x1efe]=QChar(0x0309);
        mapXtoUTF8[0x1eff]=QChar(0x0323);
        mapXtoUTF8[0xfe60]=QChar(0x0323);
        mapXtoUTF8[0xfe61]=QChar(0x0309);
        mapXtoUTF8[0xfe62]=QChar(0x031b);

    }
};


#endif /* HELPERS_H */
