/*
    This file is part of the Okteta Gui library, made within the KDE community.

    Copyright 2004,2008 Friedrich W. H. Kossebau <kossebau@kde.org>

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Lesser General Public
    License as published by the Free Software Foundation; either
    version 2.1 of the License, or (at your option) version 3, or any
    later version accepted by the membership of KDE e.V. (or its
    successor approved by the membership of KDE e.V.), which shall
    act as a proxy defined in Section 6 of version 3 of the license.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Lesser General Public License for more details.

    You should have received a copy of the GNU Lesser General Public
    License along with this library. If not, see <http://www.gnu.org/licenses/>.
*/

#include "ktabcontroller.h"

// lib
#include <abstractbytearrayview.h>
// Qt
#include <QKeyEvent>

namespace Okteta {

KTabController::KTabController(AbstractByteArrayView* view, KController* parent)
    : KController(parent)
    , mView(view)
    , mTabChangesFocus(true)
{
}

bool KTabController::handleKeyPress(QKeyEvent* keyEvent)
{
    bool keyUsed = false;

    const bool tabPressed = (keyEvent->key() == Qt::Key_Tab);
    const bool backTabPressed = (keyEvent->key() == Qt::Key_Backtab);

    if (tabPressed || backTabPressed) {
        const int visibleCodings = mView->visibleCodings();
        // are we in the char column?
        if (mView->activeCoding() == AbstractByteArrayView::CharCodingId) {
            // in last column we care about tab changes focus
            if ((visibleCodings & AbstractByteArrayView::ValueCodingId) && (!mTabChangesFocus || backTabPressed)) {
                mView->setActiveCoding(AbstractByteArrayView::ValueCodingId);
                keyUsed = true;
            }
        }
        // value column then
        else {
            // in last column we care about tab changes focus
            if ((visibleCodings & AbstractByteArrayView::CharCodingId) && (!mTabChangesFocus || tabPressed)) {
                mView->setActiveCoding(AbstractByteArrayView::CharCodingId);
                keyUsed = true;
            }
        }
    }

    return keyUsed ? true : KController::handleKeyPress(keyEvent);
}

}
