#ifndef BUTTON
#define BUTTON

#include "Application.h"
#include "Widget.h"
#include <qbutton.h>

// ABSTRACT CLASS!!!!! ----- cannot create anything!

class Button : public Widget
{
  Q_OBJECT;
public:
  Button(Widget *parent=0, const char *name=0);
  ~Button();

  const char *text();
  void setText(const char *text);
  const QPixmap* pixmap() const;
  void setPixmap(const QPixmap& pixmap);
  bool isToggleButton();
  bool isDown();
  bool isOn();
  bool autoResize();
  void setAutoResize(bool ar);
  void setAutoRepeat(bool ar);
  bool autoRepeat();

public slots:
  // These act as Signals
  void pressed();
  void released();
  void clicked();
  void toggled(bool toggled);

public:
  QButton *button;

protected:
  virtual void setWidget(QButton *_button);
};
#endif
