#include <Python.h>
#include "ScrollBar.h"


ScrollBar::ScrollBar( Widget *parent=0, const char *name=0 )
  : Widget("")
{
  if(parent)
    scrollbar = new QScrollBar(parent->widget,name);
  else
    scrollbar = new QScrollBar(NULL,name);

  setWidget(scrollbar);
}

ScrollBar::ScrollBar( Orientation o,
	   Widget *parent=0, 
	   const char *name=0 )
  : Widget("")
{
  if(parent)
    scrollbar = new QScrollBar((QScrollBar::Orientation)o,parent->widget,name);
  else
    scrollbar = new QScrollBar((QScrollBar::Orientation)o,NULL,name);

  setWidget(scrollbar);
}

ScrollBar::ScrollBar( int minValue, int maxValue, 
	   int LineStep, int PageStep,
	   int value, Orientation o,
	   Widget *parent=0, const char *name=0 )
  : Widget("")
{
  if(parent)
    scrollbar = new QScrollBar(minValue, maxValue, LineStep, PageStep,
			       value, (QScrollBar::Orientation)o, 
			       parent->widget,name);
  else
    scrollbar = new QScrollBar(minValue, maxValue, LineStep, PageStep,
			       value, (QScrollBar::Orientation)o, NULL,name);

  setWidget(scrollbar);
}

void ScrollBar::setWidget(QScrollBar *_scrollbar)
{
  scrollbar = _scrollbar;

  QObject::connect(scrollbar,SIGNAL(valueChanged(int)),
		   this,SLOT(valueChanged(int)));
  QObject::connect(scrollbar,SIGNAL(sliderPressed()),
		   this,SLOT(sliderPressed()));
  QObject::connect(scrollbar,SIGNAL(sliderMoved(int)),
		   this,SLOT(sliderMoved(int)));
  QObject::connect(scrollbar,SIGNAL(sliderReleased()),
		   this,SLOT(sliderReleased()));
  QObject::connect(scrollbar,SIGNAL(nextLine()),this,SLOT(nextLine()));
  QObject::connect(scrollbar,SIGNAL(prevLine()),this,SLOT(prevLine()));
  QObject::connect(scrollbar,SIGNAL(nextPage()),this,SLOT(nextPage()));
  QObject::connect(scrollbar,SIGNAL(prevPage()),this,SLOT(prevPage()));
  
  Widget::setWidget((QWidget*)scrollbar);
}

void ScrollBar::setOrientation( Orientation o)
{
  scrollbar->setOrientation((QScrollBar::Orientation)o);
}

ScrollBar::Orientation ScrollBar::orientation() const
{
  return (ScrollBar::Orientation)scrollbar->orientation();
}

void ScrollBar::setTracking( int enable )
{
  scrollbar->setTracking(enable);
}

bool ScrollBar::tracking() const
{
  return scrollbar->tracking();
}

bool ScrollBar::draggingSlider() const
{
  return scrollbar->draggingSlider();
}

void ScrollBar::setPalette( const QPalette & p)
{
  scrollbar->setPalette(p);
}

QSize ScrollBar::sizeHint() const
{
  return scrollbar->sizeHint();
}


// Stuff that should be inherited from QRangeControl
int ScrollBar::value() const
{
  return scrollbar->value();
}

void ScrollBar::setValue(int value)
{
  scrollbar->setValue(value);
}

void ScrollBar::addPage()
{
  scrollbar->addPage();
}

void ScrollBar::subtractPage()
{
  scrollbar->subtractPage();
}

void ScrollBar::addLine()
{
  scrollbar->addLine();
}

void ScrollBar::subtractLine()
{
  scrollbar->subtractLine();
}

int ScrollBar::minValue() const
{
  return scrollbar->minValue();
}

int ScrollBar::maxValue() const
{
  return scrollbar->maxValue();
}

void ScrollBar::setRange(int minValue, int maxValue)
{
  scrollbar->setRange(minValue,maxValue);
}

int ScrollBar::lineStep() const
{
  return scrollbar->lineStep();
}

int ScrollBar::pageStep() const
{
  return scrollbar->pageStep();
}

void ScrollBar::setSteps(int line, int page)
{
  scrollbar->setSteps(line,page);
}



//signals:

void ScrollBar::valueChanged( int value )
{
  PyObject *args;
  args = Py_BuildValue("(i)",value);
  emit("valueChanged",args);
  Py_XDECREF(args);

}

void ScrollBar::sliderPressed()
{
  emit("sliderPressed",NULL);
}

void ScrollBar::sliderMoved( int value )
{
  PyObject *args;
  args = Py_BuildValue("(i)",value);
  emit("sliderMoved",args);
  Py_XDECREF(args);
}

void ScrollBar::sliderReleased()
{
  emit("sliderReleased",NULL);
}

void ScrollBar::nextLine()
{
  emit("nextLine",NULL);
}

void ScrollBar::prevLine()
{
  emit("prevLine",NULL);
}

void ScrollBar::nextPage()
{
  emit("nextPage",NULL);
}

void ScrollBar::prevPage()
{
  emit("prevPage",NULL);
}










