#include <qmultilineedit.h>

#include <kapp.h>
#include <kiconloader.h>
#include <kmenubar.h>
#include <kstdaction.h>
#include <kaction.h>

#include "keditor.moc"

//Status Bar id
const int SBLineNumber = 2;

KEditor::KEditor (const char *name) : KTMainWindow (name)
{
  qmle = new QMultiLineEdit (this);

  KStdAction::openNew (qmle, SLOT (clear()), actionCollection());
  KStdAction::quit (kapp, SLOT (closeAllWindows()), actionCollection());
  
  createGUI();

  statusBar()->insertItem ("Line", 1);
  statusBar()->insertItem ("0000", SBLineNumber);
  slotUpdateStatusBar();

  connect ( qmle, SIGNAL (textChanged()),
	    this, SLOT (slotUpdateStatusBar()) );


  setView (qmle);
}

void
KEditor::slotUpdateStatusBar ()
{
  QString linenumber;
  int line, col;

  qmle->getCursorPosition (&line, &col);
  linenumber.sprintf ("%4d", line);

  statusBar()->changeItem (linenumber, SBLineNumber);
}
    
