#include "balance.h"
#include <stdsynthmodule.h>

using namespace Arts;

class StereoBalanceControl_impl : public
    StereoBalanceControl_skel, StdSynthModule
{
private:
    StereoBalanceState _balance;
public:
    StereoBalanceControl_impl() : _balance(sbThrough) {}
    StereoBalanceState balance()    { return _balance; }
    void balance(StereoBalanceState b) { _balance = b; }

    void calculateBlock(unsigned long samples)
    {
        unsigned long i;
        switch (_balance) {
            case sbThrough:
                for(i=0;i<samples;i++)
                {
                    outleft[i] = inleft[i];
                    outright[i] = inright[i];
                }
                break;
            case sbDownMix:
                for(i=0;i<samples;i++)
                {
                    float mix = (inleft[i]+inright[i])/2;
                    outleft[i] = mix;
                    outright[i] = mix;
                }
                break;
            /* exercise : implement the other cases */
        };
    }
};

REGISTER_IMPLEMENTATION(StereoBalanceControl_impl);
