/* This file is part of the KDE project
 * SPDX-FileCopyrightText: 2006 Thomas Zander <zander@kde.org>
 *
 * SPDX-License-Identifier: LGPL-2.0-or-later
 */

#ifndef WORDS_H
#define WORDS_H

#define TextShape_SHAPEID "TextShapeID"

#include <KoCanvasResourceManager.h>

class KWFrameSet;
class KWTextFrameSet;

/// The words-global namespace for all Words related things.
namespace Words
{
enum FrameSetType { BackgroundFrameSet, TextFrameSet, OtherFrameSet };

/// Each text frame set can be categorized in one of these items
enum TextFrameSetType {
    OddPagesHeaderTextFrameSet, ///< The frameSet that holds the headers for the odd pages
    EvenPagesHeaderTextFrameSet, ///< The frameSet that holds the headers for the even pages
    OddPagesFooterTextFrameSet, ///< The frameSet that holds the footers for the odd pages
    EvenPagesFooterTextFrameSet, ///< The frameSet that holds the footers for the even pages
    MainTextFrameSet, ///< The frameset that holds all the frames for the main text area
    OtherTextFrameSet ///< Any other text frameset not managed by the auto-frame layout
};

/// used in KWPageSettings to determine if, and what kind of header/footer to use
enum HeaderFooterType {
    HFTypeNone, ///< Don't show the frames
    HFTypeEvenOdd, ///< Show different content for even and odd pages
    HFTypeUniform ///< Show the same content for each page
};

/// Specifies the horizontal position of the line that separates main text and foot note
enum FootNoteSeparatorLinePos {
    FootNoteSeparatorLeft, ///< Left of page
    FootNoteSeparatorCenter, ///< Centered on page
    FootNoteSeparatorRight ///< Right of page
};

/// Specifies the Words specific resources that you can put and get from the KoCanvasResourceManager
enum WordsCanvasResources {
    // lets try to put Current in front of everything for ease of reading.
    CurrentPictureCount = KoCanvasResourceManager::WordsStart,
    CurrentTableCount,
    CurrentPageCount,
    FrameOutlineColor
};

/**
 * Returns true if the passed frameset is a known type that the frameLayout auto-creates.
 * @param fs the frameset to check. 0 is allowed.
 */
bool isAutoGenerated(KWFrameSet *fs);
/**
 * Returns true if the passed frameset is a header or a footer frameset.
 * @param fs the frameset to check. 0 is allowed.
 */
bool isHeaderFooter(KWTextFrameSet *fs);
/**
 * Returns a localized name for the TextFrameSetType.
 * @param type the frameset-type for which a localized name should be returned.
 */
QString frameSetTypeName(TextFrameSetType type);
QString frameSetTypeName(KWFrameSet *frameset);
}

#endif
