#include <device/device.h>
#include <device/pci.h>
#include "drivers/ics/954309/chip.h"
#include "ec/lenovo/h8/chip.h"
#include "ec/lenovo/pmh7/chip.h"
#include "southbridge/intel/i82801gx/chip.h"
#include "southbridge/ricoh/rl5c476/chip.h"

#ifndef __PRE_RAM__
__attribute__((weak)) struct chip_operations mainboard_ops = {};
__attribute__((weak)) struct chip_operations cpu_intel_socket_mFCPGA478_ops = {};
__attribute__((weak)) struct chip_operations drivers_ics_954309_ops = {};
__attribute__((weak)) struct chip_operations ec_lenovo_h8_ops = {};
__attribute__((weak)) struct chip_operations ec_lenovo_pmh7_ops = {};
__attribute__((weak)) struct chip_operations northbridge_intel_i945_ops = {};
__attribute__((weak)) struct chip_operations southbridge_intel_i82801gx_ops = {};
__attribute__((weak)) struct chip_operations southbridge_ricoh_rl5c476_ops = {};
__attribute__((weak)) struct chip_operations superio_nsc_pc87382_ops = {};
__attribute__((weak)) struct chip_operations superio_nsc_pc87392_ops = {};
#endif

/* pass 0 */
ROMSTAGE_CONST struct bus dev_root_links[];
ROMSTAGE_CONST static struct device _dev2;
ROMSTAGE_CONST struct bus _dev2_links[];
ROMSTAGE_CONST static struct device _dev5;
ROMSTAGE_CONST struct bus _dev5_links[];
ROMSTAGE_CONST static struct device _dev4;
ROMSTAGE_CONST static struct device _dev6;
ROMSTAGE_CONST static struct device _dev7;
ROMSTAGE_CONST static struct device _dev8;
ROMSTAGE_CONST static struct device _dev10;
ROMSTAGE_CONST static struct device _dev11;
ROMSTAGE_CONST static struct device _dev12;
ROMSTAGE_CONST static struct device _dev13;
ROMSTAGE_CONST static struct device _dev14;
ROMSTAGE_CONST static struct device _dev15;
ROMSTAGE_CONST static struct device _dev16;
ROMSTAGE_CONST static struct device _dev17;
ROMSTAGE_CONST static struct device _dev18;
ROMSTAGE_CONST struct bus _dev18_links[];
ROMSTAGE_CONST static struct device _dev35;
ROMSTAGE_CONST static struct device _dev36;
ROMSTAGE_CONST static struct device _dev37;
ROMSTAGE_CONST struct bus _dev37_links[];
ROMSTAGE_CONST static struct device _dev20;
ROMSTAGE_CONST static struct device _dev22;
ROMSTAGE_CONST struct resource _dev22_res[];
ROMSTAGE_CONST static struct device _dev24;
ROMSTAGE_CONST struct resource _dev24_res[];
ROMSTAGE_CONST static struct device _dev25;
ROMSTAGE_CONST struct resource _dev25_res[];
ROMSTAGE_CONST static struct device _dev26;
ROMSTAGE_CONST struct resource _dev26_res[];
ROMSTAGE_CONST static struct device _dev27;
ROMSTAGE_CONST struct resource _dev27_res[];
ROMSTAGE_CONST static struct device _dev29;
ROMSTAGE_CONST static struct device _dev30;
ROMSTAGE_CONST struct resource _dev30_res[];
ROMSTAGE_CONST static struct device _dev31;
ROMSTAGE_CONST struct resource _dev31_res[];
ROMSTAGE_CONST static struct device _dev32;
ROMSTAGE_CONST struct resource _dev32_res[];
ROMSTAGE_CONST static struct device _dev33;
ROMSTAGE_CONST struct resource _dev33_res[];
ROMSTAGE_CONST static struct device _dev34;
ROMSTAGE_CONST static struct device _dev39;

/* pass 1 */
ROMSTAGE_CONST struct device * ROMSTAGE_CONST last_dev = &_dev39;
ROMSTAGE_CONST struct device dev_root = {
#ifndef __PRE_RAM__
	.ops = &default_dev_ops_root,
#endif
	.bus = &dev_root_links[0],
	.path = { .type = DEVICE_PATH_ROOT },
	.enabled = 1,
	.on_mainboard = 1,
	.link_list = &dev_root_links[0],
#ifndef __PRE_RAM__
	.chip_ops = &mainboard_ops,
	.name = mainboard_name,
#endif
	.next=&_dev2
};
ROMSTAGE_CONST struct bus dev_root_links[] = {
		[0] = {
			.link_num = 0,
			.dev = &dev_root,
			.children = &_dev2,
			.next = NULL,
		},
	};
static ROMSTAGE_CONST struct device _dev2 = {
#ifndef __PRE_RAM__
	.ops = 0,
#endif
	.bus = &dev_root_links[0],
	.path = {.type=DEVICE_PATH_CPU_CLUSTER,{.cpu_cluster={ .cluster = 0x0 }}},
	.enabled = 1,
	.on_mainboard = 1,
	.link_list = &_dev2_links[0],
	.sibling = &_dev5,
#ifndef __PRE_RAM__
	.chip_ops = &northbridge_intel_i945_ops,
#endif
	.next=&_dev4
};
ROMSTAGE_CONST struct bus _dev2_links[] = {
		[0] = {
			.link_num = 0,
			.dev = &_dev2,
			.children = &_dev4,
			.next = NULL,
		},
	};
static ROMSTAGE_CONST struct device _dev5 = {
#ifndef __PRE_RAM__
	.ops = 0,
#endif
	.bus = &dev_root_links[0],
	.path = {.type=DEVICE_PATH_DOMAIN,{.domain={ .domain = 0x0 }}},
	.enabled = 1,
	.on_mainboard = 1,
	.link_list = &_dev5_links[0],
#ifndef __PRE_RAM__
	.chip_ops = &northbridge_intel_i945_ops,
#endif
	.next=&_dev6
};
ROMSTAGE_CONST struct bus _dev5_links[] = {
		[0] = {
			.link_num = 0,
			.dev = &_dev5,
			.children = &_dev6,
			.next = NULL,
		},
	};
static ROMSTAGE_CONST struct device _dev4 = {
#ifndef __PRE_RAM__
	.ops = 0,
#endif
	.bus = &_dev2_links[0],
	.path = {.type=DEVICE_PATH_APIC,{.apic={ .apic_id = 0x0 }}},
	.enabled = 1,
	.on_mainboard = 1,
	.link_list = NULL,
#ifndef __PRE_RAM__
	.chip_ops = &cpu_intel_socket_mFCPGA478_ops,
#endif
	.next=&_dev5
};
static ROMSTAGE_CONST struct device _dev6 = {
#ifndef __PRE_RAM__
	.ops = 0,
#endif
	.bus = &_dev5_links[0],
	.path = {.type=DEVICE_PATH_PCI,{.pci={ .devfn = PCI_DEVFN(0x0,0)}}},
	.enabled = 1,
	.on_mainboard = 1,
	.subsystem_vendor = 0x17aa,
	.subsystem_device = 0x2017,
	.link_list = NULL,
	.sibling = &_dev7,
#ifndef __PRE_RAM__
	.chip_ops = &northbridge_intel_i945_ops,
#endif
	.next=&_dev7
};
static ROMSTAGE_CONST struct device _dev7 = {
#ifndef __PRE_RAM__
	.ops = 0,
#endif
	.bus = &_dev5_links[0],
	.path = {.type=DEVICE_PATH_PCI,{.pci={ .devfn = PCI_DEVFN(0x2,0)}}},
	.enabled = 1,
	.on_mainboard = 1,
	.subsystem_vendor = 0x17aa,
	.subsystem_device = 0x201a,
	.link_list = NULL,
	.sibling = &_dev8,
#ifndef __PRE_RAM__
	.chip_ops = &northbridge_intel_i945_ops,
#endif
	.next=&_dev8
};
static ROMSTAGE_CONST struct device _dev8 = {
#ifndef __PRE_RAM__
	.ops = 0,
#endif
	.bus = &_dev5_links[0],
	.path = {.type=DEVICE_PATH_PCI,{.pci={ .devfn = PCI_DEVFN(0x2,1)}}},
	.enabled = 1,
	.on_mainboard = 1,
	.subsystem_vendor = 0x17aa,
	.subsystem_device = 0x201a,
	.link_list = NULL,
	.sibling = &_dev10,
#ifndef __PRE_RAM__
	.chip_ops = &northbridge_intel_i945_ops,
#endif
	.next=&_dev10
};
ROMSTAGE_CONST struct southbridge_intel_i82801gx_config ROMSTAGE_CONST southbridge_intel_i82801gx_info_9 = {
	.alt_gp_smi_en = 0x1000,
	.c4onc3_enable = 1,
	.gpe0_en = 0x11000006,
	.gpi12_routing = 1,
	.gpi13_routing = 2,
	.gpi8_routing = 2,
	.pirqa_routing = 0x0b,
	.pirqb_routing = 0x0b,
	.pirqc_routing = 0x0b,
	.pirqd_routing = 0x0b,
	.pirqe_routing = 0x0b,
	.pirqf_routing = 0x0b,
	.pirqg_routing = 0x0b,
	.pirqh_routing = 0x0b,
	.sata_ahci = 0x1,
	.sata_ports_implemented = 0x01,
};

ROMSTAGE_CONST struct southbridge_ricoh_rl5c476_config ROMSTAGE_CONST southbridge_ricoh_rl5c476_info_40 = { };
static ROMSTAGE_CONST struct device _dev10 = {
#ifndef __PRE_RAM__
	.ops = 0,
#endif
	.bus = &_dev5_links[0],
	.path = {.type=DEVICE_PATH_PCI,{.pci={ .devfn = PCI_DEVFN(0x1b,0)}}},
	.enabled = 1,
	.on_mainboard = 1,
	.subsystem_vendor = 0x17aa,
	.subsystem_device = 0x2010,
	.link_list = NULL,
	.sibling = &_dev11,
#ifndef __PRE_RAM__
	.chip_ops = &southbridge_intel_i82801gx_ops,
#endif
	.chip_info = &southbridge_intel_i82801gx_info_9,
	.next=&_dev11
};
static ROMSTAGE_CONST struct device _dev11 = {
#ifndef __PRE_RAM__
	.ops = 0,
#endif
	.bus = &_dev5_links[0],
	.path = {.type=DEVICE_PATH_PCI,{.pci={ .devfn = PCI_DEVFN(0x1c,0)}}},
	.enabled = 1,
	.on_mainboard = 1,
	.link_list = NULL,
	.sibling = &_dev12,
#ifndef __PRE_RAM__
	.chip_ops = &southbridge_intel_i82801gx_ops,
#endif
	.chip_info = &southbridge_intel_i82801gx_info_9,
	.next=&_dev12
};
static ROMSTAGE_CONST struct device _dev12 = {
#ifndef __PRE_RAM__
	.ops = 0,
#endif
	.bus = &_dev5_links[0],
	.path = {.type=DEVICE_PATH_PCI,{.pci={ .devfn = PCI_DEVFN(0x1c,1)}}},
	.enabled = 1,
	.on_mainboard = 1,
	.link_list = NULL,
	.sibling = &_dev13,
#ifndef __PRE_RAM__
	.chip_ops = &southbridge_intel_i82801gx_ops,
#endif
	.chip_info = &southbridge_intel_i82801gx_info_9,
	.next=&_dev13
};
static ROMSTAGE_CONST struct device _dev13 = {
#ifndef __PRE_RAM__
	.ops = 0,
#endif
	.bus = &_dev5_links[0],
	.path = {.type=DEVICE_PATH_PCI,{.pci={ .devfn = PCI_DEVFN(0x1d,0)}}},
	.enabled = 1,
	.on_mainboard = 1,
	.subsystem_vendor = 0x17aa,
	.subsystem_device = 0x200a,
	.link_list = NULL,
	.sibling = &_dev14,
#ifndef __PRE_RAM__
	.chip_ops = &southbridge_intel_i82801gx_ops,
#endif
	.chip_info = &southbridge_intel_i82801gx_info_9,
	.next=&_dev14
};
static ROMSTAGE_CONST struct device _dev14 = {
#ifndef __PRE_RAM__
	.ops = 0,
#endif
	.bus = &_dev5_links[0],
	.path = {.type=DEVICE_PATH_PCI,{.pci={ .devfn = PCI_DEVFN(0x1d,1)}}},
	.enabled = 1,
	.on_mainboard = 1,
	.subsystem_vendor = 0x17aa,
	.subsystem_device = 0x200a,
	.link_list = NULL,
	.sibling = &_dev15,
#ifndef __PRE_RAM__
	.chip_ops = &southbridge_intel_i82801gx_ops,
#endif
	.chip_info = &southbridge_intel_i82801gx_info_9,
	.next=&_dev15
};
static ROMSTAGE_CONST struct device _dev15 = {
#ifndef __PRE_RAM__
	.ops = 0,
#endif
	.bus = &_dev5_links[0],
	.path = {.type=DEVICE_PATH_PCI,{.pci={ .devfn = PCI_DEVFN(0x1d,2)}}},
	.enabled = 1,
	.on_mainboard = 1,
	.subsystem_vendor = 0x17aa,
	.subsystem_device = 0x200a,
	.link_list = NULL,
	.sibling = &_dev16,
#ifndef __PRE_RAM__
	.chip_ops = &southbridge_intel_i82801gx_ops,
#endif
	.chip_info = &southbridge_intel_i82801gx_info_9,
	.next=&_dev16
};
static ROMSTAGE_CONST struct device _dev16 = {
#ifndef __PRE_RAM__
	.ops = 0,
#endif
	.bus = &_dev5_links[0],
	.path = {.type=DEVICE_PATH_PCI,{.pci={ .devfn = PCI_DEVFN(0x1d,3)}}},
	.enabled = 1,
	.on_mainboard = 1,
	.subsystem_vendor = 0x17aa,
	.subsystem_device = 0x200a,
	.link_list = NULL,
	.sibling = &_dev17,
#ifndef __PRE_RAM__
	.chip_ops = &southbridge_intel_i82801gx_ops,
#endif
	.chip_info = &southbridge_intel_i82801gx_info_9,
	.next=&_dev17
};
static ROMSTAGE_CONST struct device _dev17 = {
#ifndef __PRE_RAM__
	.ops = 0,
#endif
	.bus = &_dev5_links[0],
	.path = {.type=DEVICE_PATH_PCI,{.pci={ .devfn = PCI_DEVFN(0x1d,7)}}},
	.enabled = 1,
	.on_mainboard = 1,
	.subsystem_vendor = 0x17aa,
	.subsystem_device = 0x200b,
	.link_list = NULL,
	.sibling = &_dev18,
#ifndef __PRE_RAM__
	.chip_ops = &southbridge_intel_i82801gx_ops,
#endif
	.chip_info = &southbridge_intel_i82801gx_info_9,
	.next=&_dev18
};
static ROMSTAGE_CONST struct device _dev18 = {
#ifndef __PRE_RAM__
	.ops = 0,
#endif
	.bus = &_dev5_links[0],
	.path = {.type=DEVICE_PATH_PCI,{.pci={ .devfn = PCI_DEVFN(0x1f,0)}}},
	.enabled = 1,
	.on_mainboard = 1,
	.subsystem_vendor = 0x17aa,
	.subsystem_device = 0x2009,
	.link_list = &_dev18_links[0],
	.sibling = &_dev35,
#ifndef __PRE_RAM__
	.chip_ops = &southbridge_intel_i82801gx_ops,
#endif
	.chip_info = &southbridge_intel_i82801gx_info_9,
	.next=&_dev20
};
ROMSTAGE_CONST struct bus _dev18_links[] = {
		[0] = {
			.link_num = 0,
			.dev = &_dev18,
			.children = &_dev20,
			.next = NULL,
		},
	};
static ROMSTAGE_CONST struct device _dev35 = {
#ifndef __PRE_RAM__
	.ops = 0,
#endif
	.bus = &_dev5_links[0],
	.path = {.type=DEVICE_PATH_PCI,{.pci={ .devfn = PCI_DEVFN(0x1f,1)}}},
	.enabled = 1,
	.on_mainboard = 1,
	.subsystem_vendor = 0x17aa,
	.subsystem_device = 0x200c,
	.link_list = NULL,
	.sibling = &_dev36,
#ifndef __PRE_RAM__
	.chip_ops = &southbridge_intel_i82801gx_ops,
#endif
	.chip_info = &southbridge_intel_i82801gx_info_9,
	.next=&_dev36
};
static ROMSTAGE_CONST struct device _dev36 = {
#ifndef __PRE_RAM__
	.ops = 0,
#endif
	.bus = &_dev5_links[0],
	.path = {.type=DEVICE_PATH_PCI,{.pci={ .devfn = PCI_DEVFN(0x1f,2)}}},
	.enabled = 1,
	.on_mainboard = 1,
	.subsystem_vendor = 0x17aa,
	.subsystem_device = 0x200d,
	.link_list = NULL,
	.sibling = &_dev37,
#ifndef __PRE_RAM__
	.chip_ops = &southbridge_intel_i82801gx_ops,
#endif
	.chip_info = &southbridge_intel_i82801gx_info_9,
	.next=&_dev37
};
static ROMSTAGE_CONST struct device _dev37 = {
#ifndef __PRE_RAM__
	.ops = 0,
#endif
	.bus = &_dev5_links[0],
	.path = {.type=DEVICE_PATH_PCI,{.pci={ .devfn = PCI_DEVFN(0x1f,3)}}},
	.enabled = 1,
	.on_mainboard = 1,
	.subsystem_vendor = 0x17aa,
	.subsystem_device = 0x200f,
	.link_list = &_dev37_links[0],
#ifndef __PRE_RAM__
	.chip_ops = &southbridge_intel_i82801gx_ops,
#endif
	.chip_info = &southbridge_intel_i82801gx_info_9,
	.next=&_dev39
};
ROMSTAGE_CONST struct bus _dev37_links[] = {
		[0] = {
			.link_num = 0,
			.dev = &_dev37,
			.children = &_dev39,
			.next = NULL,
		},
	};
ROMSTAGE_CONST struct ec_lenovo_pmh7_config ROMSTAGE_CONST ec_lenovo_pmh7_info_19 = {
	.backlight_enable = 0x01,
	.dock_event_enable = 0x01,
};

ROMSTAGE_CONST struct ec_lenovo_h8_config ROMSTAGE_CONST ec_lenovo_h8_info_21 = {
	.beepmask0 = 0xfe,
	.beepmask1 = 0x96,
	.config0 = 0xa6,
	.config1 = 0x05,
	.config2 = 0xa0,
	.config3 = 0x01,
	.event2_enable = 0xff,
	.event3_enable = 0xff,
	.event4_enable = 0xf4,
	.event5_enable = 0x3c,
	.event6_enable = 0x80,
	.event7_enable = 0x01,
	.event8_enable = 0x01,
	.event9_enable = 0xff,
	.eventa_enable = 0xff,
	.eventb_enable = 0xff,
	.eventc_enable = 0xff,
	.eventc_enable = 0x3c,
	.eventd_enable = 0xff,
	.trackpoint_enable = 0x03,
	.wlan_enable = 0x01,
};

static ROMSTAGE_CONST struct device _dev20 = {
#ifndef __PRE_RAM__
	.ops = 0,
#endif
	.bus = &_dev18_links[0],
	.path = {.type=DEVICE_PATH_PNP,{.pnp={ .port = 0xff, .device = 0x1 }}},
	.enabled = 1,
	.on_mainboard = 1,
	.link_list = NULL,
	.sibling = &_dev22,
#ifndef __PRE_RAM__
	.chip_ops = &ec_lenovo_pmh7_ops,
#endif
	.chip_info = &ec_lenovo_pmh7_info_19,
	.next=&_dev22
};
static ROMSTAGE_CONST struct device _dev22 = {
#ifndef __PRE_RAM__
	.ops = 0,
#endif
	.bus = &_dev18_links[0],
	.path = {.type=DEVICE_PATH_PNP,{.pnp={ .port = 0xff, .device = 0x2 }}},
	.enabled = 1,
	.on_mainboard = 1,
	.resource_list = &_dev22_res[0],
	.link_list = NULL,
	.sibling = &_dev24,
#ifndef __PRE_RAM__
	.chip_ops = &ec_lenovo_h8_ops,
#endif
	.chip_info = &ec_lenovo_h8_info_21,
	.next=&_dev24
};
ROMSTAGE_CONST struct resource _dev22_res[] = {
		{ .flags=IORESOURCE_FIXED | IORESOURCE_ASSIGNED | IORESOURCE_IO, .index=0x60, .base=0x62,.next=&_dev22_res[1]},
		{ .flags=IORESOURCE_FIXED | IORESOURCE_ASSIGNED | IORESOURCE_IO, .index=0x62, .base=0x66,.next=&_dev22_res[2]},
		{ .flags=IORESOURCE_FIXED | IORESOURCE_ASSIGNED | IORESOURCE_IO, .index=0x64, .base=0x1600,.next=&_dev22_res[3]},
		{ .flags=IORESOURCE_FIXED | IORESOURCE_ASSIGNED | IORESOURCE_IO, .index=0x66, .base=0x1604,.next=NULL },
	 };
static ROMSTAGE_CONST struct device _dev24 = {
#ifndef __PRE_RAM__
	.ops = 0,
#endif
	.bus = &_dev18_links[0],
	.path = {.type=DEVICE_PATH_PNP,{.pnp={ .port = 0x164e, .device = 0x2 }}},
	.enabled = 1,
	.on_mainboard = 1,
	.resource_list = &_dev24_res[0],
	.link_list = NULL,
	.sibling = &_dev25,
#ifndef __PRE_RAM__
	.chip_ops = &superio_nsc_pc87382_ops,
#endif
	.next=&_dev25
};
ROMSTAGE_CONST struct resource _dev24_res[] = {
		{ .flags=IORESOURCE_FIXED | IORESOURCE_ASSIGNED | IORESOURCE_IO, .index=0x60, .base=0x2f8,.next=NULL },
	 };
static ROMSTAGE_CONST struct device _dev25 = {
#ifndef __PRE_RAM__
	.ops = 0,
#endif
	.bus = &_dev18_links[0],
	.path = {.type=DEVICE_PATH_PNP,{.pnp={ .port = 0x164e, .device = 0x3 }}},
	.enabled = 0,
	.on_mainboard = 1,
	.resource_list = &_dev25_res[0],
	.link_list = NULL,
	.sibling = &_dev26,
#ifndef __PRE_RAM__
	.chip_ops = &superio_nsc_pc87382_ops,
#endif
	.next=&_dev26
};
ROMSTAGE_CONST struct resource _dev25_res[] = {
		{ .flags=IORESOURCE_FIXED | IORESOURCE_ASSIGNED | IORESOURCE_IO, .index=0x60, .base=0x3f8,.next=NULL },
	 };
static ROMSTAGE_CONST struct device _dev26 = {
#ifndef __PRE_RAM__
	.ops = 0,
#endif
	.bus = &_dev18_links[0],
	.path = {.type=DEVICE_PATH_PNP,{.pnp={ .port = 0x164e, .device = 0x7 }}},
	.enabled = 1,
	.on_mainboard = 1,
	.resource_list = &_dev26_res[0],
	.link_list = NULL,
	.sibling = &_dev27,
#ifndef __PRE_RAM__
	.chip_ops = &superio_nsc_pc87382_ops,
#endif
	.next=&_dev27
};
ROMSTAGE_CONST struct resource _dev26_res[] = {
		{ .flags=IORESOURCE_FIXED | IORESOURCE_ASSIGNED | IORESOURCE_IO, .index=0x60, .base=0x1680,.next=NULL },
	 };
static ROMSTAGE_CONST struct device _dev27 = {
#ifndef __PRE_RAM__
	.ops = 0,
#endif
	.bus = &_dev18_links[0],
	.path = {.type=DEVICE_PATH_PNP,{.pnp={ .port = 0x164e, .device = 0x19 }}},
	.enabled = 1,
	.on_mainboard = 1,
	.resource_list = &_dev27_res[0],
	.link_list = NULL,
	.sibling = &_dev29,
#ifndef __PRE_RAM__
	.chip_ops = &superio_nsc_pc87382_ops,
#endif
	.next=&_dev29
};
ROMSTAGE_CONST struct resource _dev27_res[] = {
		{ .flags=IORESOURCE_FIXED | IORESOURCE_ASSIGNED | IORESOURCE_IO, .index=0x60, .base=0x164c,.next=NULL },
	 };
static ROMSTAGE_CONST struct device _dev29 = {
#ifndef __PRE_RAM__
	.ops = 0,
#endif
	.bus = &_dev18_links[0],
	.path = {.type=DEVICE_PATH_PNP,{.pnp={ .port = 0x2e, .device = 0x0 }}},
	.enabled = 0,
	.on_mainboard = 1,
	.link_list = NULL,
	.sibling = &_dev30,
#ifndef __PRE_RAM__
	.chip_ops = &superio_nsc_pc87392_ops,
#endif
	.next=&_dev30
};
static ROMSTAGE_CONST struct device _dev30 = {
#ifndef __PRE_RAM__
	.ops = 0,
#endif
	.bus = &_dev18_links[0],
	.path = {.type=DEVICE_PATH_PNP,{.pnp={ .port = 0x2e, .device = 0x1 }}},
	.enabled = 1,
	.on_mainboard = 1,
	.resource_list = &_dev30_res[0],
	.link_list = NULL,
	.sibling = &_dev31,
#ifndef __PRE_RAM__
	.chip_ops = &superio_nsc_pc87392_ops,
#endif
	.next=&_dev31
};
ROMSTAGE_CONST struct resource _dev30_res[] = {
		{ .flags=IORESOURCE_FIXED | IORESOURCE_ASSIGNED | IORESOURCE_IO, .index=0x60, .base=0x3bc,.next=&_dev30_res[1]},
		{ .flags=IORESOURCE_FIXED | IORESOURCE_ASSIGNED | IORESOURCE_IRQ, .index=0x70, .base=0x7,.next=NULL },
	 };
static ROMSTAGE_CONST struct device _dev31 = {
#ifndef __PRE_RAM__
	.ops = 0,
#endif
	.bus = &_dev18_links[0],
	.path = {.type=DEVICE_PATH_PNP,{.pnp={ .port = 0x2e, .device = 0x2 }}},
	.enabled = 0,
	.on_mainboard = 1,
	.resource_list = &_dev31_res[0],
	.link_list = NULL,
	.sibling = &_dev32,
#ifndef __PRE_RAM__
	.chip_ops = &superio_nsc_pc87392_ops,
#endif
	.next=&_dev32
};
ROMSTAGE_CONST struct resource _dev31_res[] = {
		{ .flags=IORESOURCE_FIXED | IORESOURCE_ASSIGNED | IORESOURCE_IO, .index=0x60, .base=0x2f8,.next=&_dev31_res[1]},
		{ .flags=IORESOURCE_FIXED | IORESOURCE_ASSIGNED | IORESOURCE_IRQ, .index=0x70, .base=0x4,.next=NULL },
	 };
static ROMSTAGE_CONST struct device _dev32 = {
#ifndef __PRE_RAM__
	.ops = 0,
#endif
	.bus = &_dev18_links[0],
	.path = {.type=DEVICE_PATH_PNP,{.pnp={ .port = 0x2e, .device = 0x3 }}},
	.enabled = 1,
	.on_mainboard = 1,
	.resource_list = &_dev32_res[0],
	.link_list = NULL,
	.sibling = &_dev33,
#ifndef __PRE_RAM__
	.chip_ops = &superio_nsc_pc87392_ops,
#endif
	.next=&_dev33
};
ROMSTAGE_CONST struct resource _dev32_res[] = {
		{ .flags=IORESOURCE_FIXED | IORESOURCE_ASSIGNED | IORESOURCE_IO, .index=0x60, .base=0x3f8,.next=&_dev32_res[1]},
		{ .flags=IORESOURCE_FIXED | IORESOURCE_ASSIGNED | IORESOURCE_IRQ, .index=0x70, .base=0x4,.next=NULL },
	 };
static ROMSTAGE_CONST struct device _dev33 = {
#ifndef __PRE_RAM__
	.ops = 0,
#endif
	.bus = &_dev18_links[0],
	.path = {.type=DEVICE_PATH_PNP,{.pnp={ .port = 0x2e, .device = 0x7 }}},
	.enabled = 1,
	.on_mainboard = 1,
	.resource_list = &_dev33_res[0],
	.link_list = NULL,
	.sibling = &_dev34,
#ifndef __PRE_RAM__
	.chip_ops = &superio_nsc_pc87392_ops,
#endif
	.next=&_dev34
};
ROMSTAGE_CONST struct resource _dev33_res[] = {
		{ .flags=IORESOURCE_FIXED | IORESOURCE_ASSIGNED | IORESOURCE_IO, .index=0x60, .base=0x1620,.next=NULL },
	 };
static ROMSTAGE_CONST struct device _dev34 = {
#ifndef __PRE_RAM__
	.ops = 0,
#endif
	.bus = &_dev18_links[0],
	.path = {.type=DEVICE_PATH_PNP,{.pnp={ .port = 0x2e, .device = 0xa }}},
	.enabled = 0,
	.on_mainboard = 1,
	.link_list = NULL,
#ifndef __PRE_RAM__
	.chip_ops = &superio_nsc_pc87392_ops,
#endif
	.next=&_dev35
};
ROMSTAGE_CONST struct drivers_ics_954309_config ROMSTAGE_CONST drivers_ics_954309_info_38 = {
	.reg0 = 0x2e,
	.reg1 = 0xf7,
	.reg10 = 0xff,
	.reg11 = 0x07,
	.reg2 = 0x3c,
	.reg3 = 0x20,
	.reg4 = 0x01,
	.reg5 = 0x00,
	.reg6 = 0x1b,
	.reg7 = 0x01,
	.reg8 = 0x54,
	.reg9 = 0xff,
};

static ROMSTAGE_CONST struct device _dev39 = {
#ifndef __PRE_RAM__
	.ops = 0,
#endif
	.bus = &_dev37_links[0],
	.path = {.type=DEVICE_PATH_I2C,{.i2c={ .device = 0x69 }}},
	.enabled = 1,
	.on_mainboard = 1,
	.link_list = NULL,
#ifndef __PRE_RAM__
	.chip_ops = &drivers_ics_954309_ops,
#endif
	.chip_info = &drivers_ics_954309_info_38,
};
