/* $NoKeywords:$ */
/**
 * @file
 *
 *  Register definitions
 *
 *
 *
 * @xrefitem bom "File Content Label" "Release Content"
 * @e project:     AGESA
 * @e sub-project: GNB
 * @e \$Revision:$   @e \$Date:$
 *
 */
/*
*****************************************************************************
*
* Copyright (c) 2011, Advanced Micro Devices, Inc.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *     * Redistributions of source code must retain the above copyright
 *       notice, this list of conditions and the following disclaimer.
 *     * Redistributions in binary form must reproduce the above copyright
 *       notice, this list of conditions and the following disclaimer in the
 *       documentation and/or other materials provided with the distribution.
 *     * Neither the name of Advanced Micro Devices, Inc. nor the names of
 *       its contributors may be used to endorse or promote products derived
 *       from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL ADVANCED MICRO DEVICES, INC. BE LIABLE FOR ANY
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
* ***************************************************************************
*
*/

#ifndef _GNBREGISTERSLN_H_
#define _GNBREGISTERSLN_H_
#define  TYPE_D0F0                  0x1
#define  TYPE_D0F0x64               0x2
#define  TYPE_D0F0x98               0x3
#define  TYPE_D0F0xE4               0x5
#define  TYPE_DxF0                  0x6
#define  TYPE_DxF0xE4               0x7
#define  TYPE_D18F1                 0xb
#define  TYPE_D18F2                 0xc
#define  TYPE_D18F3                 0xd
#define  TYPE_MSR                   0x10
#define  TYPE_D1F0                  0x11
#define  TYPE_GMM                   0x12
#define  D18F2x9C  0xe
#define  GMM       0x11
#ifndef WRAP_SPACE
  #define  WRAP_SPACE(w, x)   (0x01300000 | (w << 16) | (x))
#endif
#ifndef CORE_SPACE
  #define  CORE_SPACE(c, x)   (0x00010000 | (c << 24) | (x))
#endif
#ifndef PHY_SPACE
  #define  PHY_SPACE(w, p, x) (0x00200000 | ((p + 1) << 24) | (w << 16) | (x))
#endif
#ifndef  PIF_SPACE
  #define  PIF_SPACE(w, p, x) (0x00100000 | ((p + 1) << 24) | (w << 16) | (x))
#endif
// **** D0F0x00 Register Definition ****
// Address
#define D0F0x00_ADDRESS                                         0x0

// Type
#define D0F0x00_TYPE                                            TYPE_D0F0
// Field Data
#define D0F0x00_VendorID_OFFSET                                 0
#define D0F0x00_VendorID_WIDTH                                  16
#define D0F0x00_VendorID_MASK                                   0xffff
#define D0F0x00_DeviceID_OFFSET                                 16
#define D0F0x00_DeviceID_WIDTH                                  16
#define D0F0x00_DeviceID_MASK                                   0xffff0000

/// D0F0x00
typedef union {
  struct {                                                              ///<
    UINT32                                                 VendorID:16; ///<
    UINT32                                                 DeviceID:16; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} D0F0x00_STRUCT;

// **** D0F0x04 Register Definition ****
// Address
#define D0F0x04_ADDRESS                                         0x4

// Type
#define D0F0x04_TYPE                                            TYPE_D0F0
// Field Data
#define D0F0x04_IoAccessEn_OFFSET                               0
#define D0F0x04_IoAccessEn_WIDTH                                1
#define D0F0x04_IoAccessEn_MASK                                 0x1
#define D0F0x04_MemAccessEn_OFFSET                              1
#define D0F0x04_MemAccessEn_WIDTH                               1
#define D0F0x04_MemAccessEn_MASK                                0x2
#define D0F0x04_BusMasterEn_OFFSET                              2
#define D0F0x04_BusMasterEn_WIDTH                               1
#define D0F0x04_BusMasterEn_MASK                                0x4
#define D0F0x04_SpecialCycleEn_OFFSET                           3
#define D0F0x04_SpecialCycleEn_WIDTH                            1
#define D0F0x04_SpecialCycleEn_MASK                             0x8
#define D0F0x04_MemWriteInvalidateEn_OFFSET                     4
#define D0F0x04_MemWriteInvalidateEn_WIDTH                      1
#define D0F0x04_MemWriteInvalidateEn_MASK                       0x10
#define D0F0x04_PalSnoopEn_OFFSET                               5
#define D0F0x04_PalSnoopEn_WIDTH                                1
#define D0F0x04_PalSnoopEn_MASK                                 0x20
#define D0F0x04_ParityErrorEn_OFFSET                            6
#define D0F0x04_ParityErrorEn_WIDTH                             1
#define D0F0x04_ParityErrorEn_MASK                              0x40
#define D0F0x04_Reserved_7_7_OFFSET                             7
#define D0F0x04_Reserved_7_7_WIDTH                              1
#define D0F0x04_Reserved_7_7_MASK                               0x80
#define D0F0x04_SerrEn_OFFSET                                   8
#define D0F0x04_SerrEn_WIDTH                                    1
#define D0F0x04_SerrEn_MASK                                     0x100
#define D0F0x04_FastB2BEn_OFFSET                                9
#define D0F0x04_FastB2BEn_WIDTH                                 1
#define D0F0x04_FastB2BEn_MASK                                  0x200
#define D0F0x04_Reserved_19_10_OFFSET                           10
#define D0F0x04_Reserved_19_10_WIDTH                            10
#define D0F0x04_Reserved_19_10_MASK                             0xffc00
#define D0F0x04_CapList_OFFSET                                  20
#define D0F0x04_CapList_WIDTH                                   1
#define D0F0x04_CapList_MASK                                    0x100000
#define D0F0x04_PCI66En_OFFSET                                  21
#define D0F0x04_PCI66En_WIDTH                                   1
#define D0F0x04_PCI66En_MASK                                    0x200000
#define D0F0x04_Reserved_22_22_OFFSET                           22
#define D0F0x04_Reserved_22_22_WIDTH                            1
#define D0F0x04_Reserved_22_22_MASK                             0x400000
#define D0F0x04_FastBackCapable_OFFSET                          23
#define D0F0x04_FastBackCapable_WIDTH                           1
#define D0F0x04_FastBackCapable_MASK                            0x800000
#define D0F0x04_Reserved_24_24_OFFSET                           24
#define D0F0x04_Reserved_24_24_WIDTH                            1
#define D0F0x04_Reserved_24_24_MASK                             0x1000000
#define D0F0x04_DevselTiming_OFFSET                             25
#define D0F0x04_DevselTiming_WIDTH                              2
#define D0F0x04_DevselTiming_MASK                               0x6000000
#define D0F0x04_SignalTargetAbort_OFFSET                        27
#define D0F0x04_SignalTargetAbort_WIDTH                         1
#define D0F0x04_SignalTargetAbort_MASK                          0x8000000
#define D0F0x04_ReceivedTargetAbort_OFFSET                      28
#define D0F0x04_ReceivedTargetAbort_WIDTH                       1
#define D0F0x04_ReceivedTargetAbort_MASK                        0x10000000
#define D0F0x04_ReceivedMasterAbort_OFFSET                      29
#define D0F0x04_ReceivedMasterAbort_WIDTH                       1
#define D0F0x04_ReceivedMasterAbort_MASK                        0x20000000
#define D0F0x04_SignaledSystemError_OFFSET                      30
#define D0F0x04_SignaledSystemError_WIDTH                       1
#define D0F0x04_SignaledSystemError_MASK                        0x40000000
#define D0F0x04_ParityErrorDetected_OFFSET                      31
#define D0F0x04_ParityErrorDetected_WIDTH                       1
#define D0F0x04_ParityErrorDetected_MASK                        0x80000000

/// D0F0x04
typedef union {
  struct {                                                              ///<
    UINT32                                               IoAccessEn:1 ; ///<
    UINT32                                              MemAccessEn:1 ; ///<
    UINT32                                              BusMasterEn:1 ; ///<
    UINT32                                           SpecialCycleEn:1 ; ///<
    UINT32                                     MemWriteInvalidateEn:1 ; ///<
    UINT32                                               PalSnoopEn:1 ; ///<
    UINT32                                            ParityErrorEn:1 ; ///<
    UINT32                                             Reserved_7_7:1 ; ///<
    UINT32                                                   SerrEn:1 ; ///<
    UINT32                                                FastB2BEn:1 ; ///<
    UINT32                                           Reserved_19_10:10; ///<
    UINT32                                                  CapList:1 ; ///<
    UINT32                                                  PCI66En:1 ; ///<
    UINT32                                           Reserved_22_22:1 ; ///<
    UINT32                                          FastBackCapable:1 ; ///<
    UINT32                                           Reserved_24_24:1 ; ///<
    UINT32                                             DevselTiming:2 ; ///<
    UINT32                                        SignalTargetAbort:1 ; ///<
    UINT32                                      ReceivedTargetAbort:1 ; ///<
    UINT32                                      ReceivedMasterAbort:1 ; ///<
    UINT32                                      SignaledSystemError:1 ; ///<
    UINT32                                      ParityErrorDetected:1 ; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} D0F0x04_STRUCT;

// **** D0F0x08 Register Definition ****
// Address
#define D0F0x08_ADDRESS                                         0x8

// Type
#define D0F0x08_TYPE                                            TYPE_D0F0
// Field Data
#define D0F0x08_RevID_OFFSET                                    0
#define D0F0x08_RevID_WIDTH                                     8
#define D0F0x08_RevID_MASK                                      0xff
#define D0F0x08_ClassCode_OFFSET                                8
#define D0F0x08_ClassCode_WIDTH                                 24
#define D0F0x08_ClassCode_MASK                                  0xffffff00

/// D0F0x08
typedef union {
  struct {                                                              ///<
    UINT32                                                    RevID:8 ; ///<
    UINT32                                                ClassCode:24; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} D0F0x08_STRUCT;

// **** D0F0x0C Register Definition ****
// Address
#define D0F0x0C_ADDRESS                                         0xc

// Type
#define D0F0x0C_TYPE                                            TYPE_D0F0
// Field Data
#define D0F0x0C_CacheLineSize_OFFSET                            0
#define D0F0x0C_CacheLineSize_WIDTH                             8
#define D0F0x0C_CacheLineSize_MASK                              0xff
#define D0F0x0C_LatencyTimer_OFFSET                             8
#define D0F0x0C_LatencyTimer_WIDTH                              8
#define D0F0x0C_LatencyTimer_MASK                               0xff00
#define D0F0x0C_HeaderTypeReg_OFFSET                            16
#define D0F0x0C_HeaderTypeReg_WIDTH                             8
#define D0F0x0C_HeaderTypeReg_MASK                              0xff0000
#define D0F0x0C_BIST_OFFSET                                     24
#define D0F0x0C_BIST_WIDTH                                      8
#define D0F0x0C_BIST_MASK                                       0xff000000

/// D0F0x0C
typedef union {
  struct {                                                              ///<
    UINT32                                            CacheLineSize:8 ; ///<
    UINT32                                             LatencyTimer:8 ; ///<
    UINT32                                            HeaderTypeReg:8 ; ///<
    UINT32                                                     BIST:8 ; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} D0F0x0C_STRUCT;

// **** D0F0x2C Register Definition ****
// Address
#define D0F0x2C_ADDRESS                                         0x2c

// Type
#define D0F0x2C_TYPE                                            TYPE_D0F0
// Field Data
#define D0F0x2C_SubsystemVendorID_OFFSET                        0
#define D0F0x2C_SubsystemVendorID_WIDTH                         16
#define D0F0x2C_SubsystemVendorID_MASK                          0xffff
#define D0F0x2C_SubsystemID_OFFSET                              16
#define D0F0x2C_SubsystemID_WIDTH                               16
#define D0F0x2C_SubsystemID_MASK                                0xffff0000

/// D0F0x2C
typedef union {
  struct {                                                              ///<
    UINT32                                        SubsystemVendorID:16; ///<
    UINT32                                              SubsystemID:16; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} D0F0x2C_STRUCT;

// **** D0F0x34 Register Definition ****
// Address
#define D0F0x34_ADDRESS                                         0x34

// Type
#define D0F0x34_TYPE                                            TYPE_D0F0
// Field Data
#define D0F0x34_CapPtr_OFFSET                                   0
#define D0F0x34_CapPtr_WIDTH                                    8
#define D0F0x34_CapPtr_MASK                                     0xff
#define D0F0x34_Reserved_31_8_OFFSET                            8
#define D0F0x34_Reserved_31_8_WIDTH                             24
#define D0F0x34_Reserved_31_8_MASK                              0xffffff00

/// D0F0x34
typedef union {
  struct {                                                              ///<
    UINT32                                                   CapPtr:8 ; ///<
    UINT32                                            Reserved_31_8:24; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} D0F0x34_STRUCT;

// **** D0F0x4C Register Definition ****
// Address
#define D0F0x4C_ADDRESS                                         0x4c

// Type
#define D0F0x4C_TYPE                                            TYPE_D0F0
// Field Data
#define D0F0x4C_Function1Enable_OFFSET                          0
#define D0F0x4C_Function1Enable_WIDTH                           1
#define D0F0x4C_Function1Enable_MASK                            0x1
#define D0F0x4C_ApicEnable_OFFSET                               1
#define D0F0x4C_ApicEnable_WIDTH                                1
#define D0F0x4C_ApicEnable_MASK                                 0x2
#define D0F0x4C_Reserved_2_2_OFFSET                             2
#define D0F0x4C_Reserved_2_2_WIDTH                              1
#define D0F0x4C_Reserved_2_2_MASK                               0x4
#define D0F0x4C_Cf8Dis_OFFSET                                   3
#define D0F0x4C_Cf8Dis_WIDTH                                    1
#define D0F0x4C_Cf8Dis_MASK                                     0x8
#define D0F0x4C_PMEDis_OFFSET                                   4
#define D0F0x4C_PMEDis_WIDTH                                    1
#define D0F0x4C_PMEDis_MASK                                     0x10
#define D0F0x4C_SerrDis_OFFSET                                  5
#define D0F0x4C_SerrDis_WIDTH                                   1
#define D0F0x4C_SerrDis_MASK                                    0x20
#define D0F0x4C_Reserved_10_6_OFFSET                            6
#define D0F0x4C_Reserved_10_6_WIDTH                             5
#define D0F0x4C_Reserved_10_6_MASK                              0x7c0
#define D0F0x4C_CRS_OFFSET                                      11
#define D0F0x4C_CRS_WIDTH                                       1
#define D0F0x4C_CRS_MASK                                        0x800
#define D0F0x4C_CfgRdTime_OFFSET                                12
#define D0F0x4C_CfgRdTime_WIDTH                                 3
#define D0F0x4C_CfgRdTime_MASK                                  0x7000
#define D0F0x4C_Reserved_22_15_OFFSET                           15
#define D0F0x4C_Reserved_22_15_WIDTH                            8
#define D0F0x4C_Reserved_22_15_MASK                             0x7f8000
#define D0F0x4C_MMIOEnable_OFFSET                               23
#define D0F0x4C_MMIOEnable_WIDTH                                1
#define D0F0x4C_MMIOEnable_MASK                                 0x800000
#define D0F0x4C_Reserved_25_24_OFFSET                           24
#define D0F0x4C_Reserved_25_24_WIDTH                            2
#define D0F0x4C_Reserved_25_24_MASK                             0x3000000
#define D0F0x4C_HPDis_OFFSET                                    26
#define D0F0x4C_HPDis_WIDTH                                     1
#define D0F0x4C_HPDis_MASK                                      0x4000000
#define D0F0x4C_Reserved_31_27_OFFSET                           27
#define D0F0x4C_Reserved_31_27_WIDTH                            5
#define D0F0x4C_Reserved_31_27_MASK                             0xf8000000

/// D0F0x4C
typedef union {
  struct {                                                              ///<
    UINT32                                          Function1Enable:1 ; ///<
    UINT32                                               ApicEnable:1 ; ///<
    UINT32                                             Reserved_2_2:1 ; ///<
    UINT32                                                   Cf8Dis:1 ; ///<
    UINT32                                                   PMEDis:1 ; ///<
    UINT32                                                  SerrDis:1 ; ///<
    UINT32                                            Reserved_10_6:5 ; ///<
    UINT32                                                      CRS:1 ; ///<
    UINT32                                                CfgRdTime:3 ; ///<
    UINT32                                           Reserved_22_15:8 ; ///<
    UINT32                                               MMIOEnable:1 ; ///<
    UINT32                                           Reserved_25_24:2 ; ///<
    UINT32                                                    HPDis:1 ; ///<
    UINT32                                           Reserved_31_27:5 ; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} D0F0x4C_STRUCT;

// **** D0F0x60 Register Definition ****
// Address
#define D0F0x60_ADDRESS                                         0x60

// Type
#define D0F0x60_TYPE                                            TYPE_D0F0
// Field Data
#define D0F0x60_MiscIndAddr_OFFSET                              0
#define D0F0x60_MiscIndAddr_WIDTH                               7
#define D0F0x60_MiscIndAddr_MASK                                0x7f
#define D0F0x60_MiscIndWrEn_OFFSET                              7
#define D0F0x60_MiscIndWrEn_WIDTH                               1
#define D0F0x60_MiscIndWrEn_MASK                                0x80
#define D0F0x60_Reserved_31_8_OFFSET                            8
#define D0F0x60_Reserved_31_8_WIDTH                             24
#define D0F0x60_Reserved_31_8_MASK                              0xffffff00

/// D0F0x60
typedef union {
  struct {                                                              ///<
    UINT32                                              MiscIndAddr:7 ; ///<
    UINT32                                              MiscIndWrEn:1 ; ///<
    UINT32                                            Reserved_31_8:24; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} D0F0x60_STRUCT;

// **** D0F0x64 Register Definition ****
// Address
#define D0F0x64_ADDRESS                                         0x64

// Type
#define D0F0x64_TYPE                                            TYPE_D0F0
// Field Data
#define D0F0x64_MiscIndData_OFFSET                              0
#define D0F0x64_MiscIndData_WIDTH                               32
#define D0F0x64_MiscIndData_MASK                                0xffffffff

/// D0F0x64
typedef union {
  struct {                                                              ///<
    UINT32                                              MiscIndData:32; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} D0F0x64_STRUCT;

// **** D0F0x78 Register Definition ****
// Address
#define D0F0x78_ADDRESS                                         0x78

// Type
#define D0F0x78_TYPE                                            TYPE_D0F0
// Field Data
#define D0F0x78_Scratch_OFFSET                                  0
#define D0F0x78_Scratch_WIDTH                                   32
#define D0F0x78_Scratch_MASK                                    0xffffffff

/// D0F0x78
typedef union {
  struct {                                                              ///<
    UINT32                                                  Scratch:32; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} D0F0x78_STRUCT;

// **** D0F0x7C Register Definition ****
// Address
#define D0F0x7C_ADDRESS                                         0x7c

// Type
#define D0F0x7C_TYPE                                            TYPE_D0F0
// Field Data
#define D0F0x7C_ForceIntGFXDisable_OFFSET                       0
#define D0F0x7C_ForceIntGFXDisable_WIDTH                        1
#define D0F0x7C_ForceIntGFXDisable_MASK                         0x1
#define D0F0x7C_Reserved_31_1_OFFSET                            1
#define D0F0x7C_Reserved_31_1_WIDTH                             31
#define D0F0x7C_Reserved_31_1_MASK                              0xfffffffe

/// D0F0x7C
typedef union {
  struct {                                                              ///<
    UINT32                                       ForceIntGFXDisable:1 ; ///<
    UINT32                                            Reserved_31_1:31; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} D0F0x7C_STRUCT;

// **** D0F0x84 Register Definition ****
// Address
#define D0F0x84_ADDRESS                                         0x84

// Type
#define D0F0x84_TYPE                                            TYPE_D0F0
// Field Data
#define D0F0x84_Reserved_3_0_OFFSET                             0
#define D0F0x84_Reserved_3_0_WIDTH                              4
#define D0F0x84_Reserved_3_0_MASK                               0xf
#define D0F0x84_Ev6Mode_OFFSET                                  4
#define D0F0x84_Ev6Mode_WIDTH                                   1
#define D0F0x84_Ev6Mode_MASK                                    0x10
#define D0F0x84_Reserved_7_5_OFFSET                             5
#define D0F0x84_Reserved_7_5_WIDTH                              3
#define D0F0x84_Reserved_7_5_MASK                               0xe0
#define D0F0x84_PmeMode_OFFSET                                  8
#define D0F0x84_PmeMode_WIDTH                                   1
#define D0F0x84_PmeMode_MASK                                    0x100
#define D0F0x84_PmeTurnOff_OFFSET                               9
#define D0F0x84_PmeTurnOff_WIDTH                                1
#define D0F0x84_PmeTurnOff_MASK                                 0x200
#define D0F0x84_Reserved_31_10_OFFSET                           10
#define D0F0x84_Reserved_31_10_WIDTH                            22
#define D0F0x84_Reserved_31_10_MASK                             0xfffffc00

/// D0F0x84
typedef union {
  struct {                                                              ///<
    UINT32                                             Reserved_3_0:4 ; ///<
    UINT32                                                  Ev6Mode:1 ; ///<
    UINT32                                             Reserved_7_5:3 ; ///<
    UINT32                                                  PmeMode:1 ; ///<
    UINT32                                               PmeTurnOff:1 ; ///<
    UINT32                                           Reserved_31_10:22; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} D0F0x84_STRUCT;

// **** D0F0x90 Register Definition ****
// Address
#define D0F0x90_ADDRESS                                         0x90

// Type
#define D0F0x90_TYPE                                            TYPE_D0F0
// Field Data
#define D0F0x90_Reserved_22_0_OFFSET                            0
#define D0F0x90_Reserved_22_0_WIDTH                             23
#define D0F0x90_Reserved_22_0_MASK                              0x7fffff
#define D0F0x90_TopOfDram_OFFSET                                23
#define D0F0x90_TopOfDram_WIDTH                                 9
#define D0F0x90_TopOfDram_MASK                                  0xff800000

/// D0F0x90
typedef union {
  struct {                                                              ///<
    UINT32                                            Reserved_22_0:23; ///<
    UINT32                                                TopOfDram:9 ; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} D0F0x90_STRUCT;

// **** D0F0x94 Register Definition ****
// Address
#define D0F0x94_ADDRESS                                         0x94

// Type
#define D0F0x94_TYPE                                            TYPE_D0F0
// Field Data
#define D0F0x94_OrbIndAddr_OFFSET                               0
#define D0F0x94_OrbIndAddr_WIDTH                                7
#define D0F0x94_OrbIndAddr_MASK                                 0x7f
#define D0F0x94_Reserved_7_7_OFFSET                             7
#define D0F0x94_Reserved_7_7_WIDTH                              1
#define D0F0x94_Reserved_7_7_MASK                               0x80
#define D0F0x94_OrbIndWrEn_OFFSET                               8
#define D0F0x94_OrbIndWrEn_WIDTH                                1
#define D0F0x94_OrbIndWrEn_MASK                                 0x100
#define D0F0x94_Reserved_31_9_OFFSET                            9
#define D0F0x94_Reserved_31_9_WIDTH                             23
#define D0F0x94_Reserved_31_9_MASK                              0xfffffe00

/// D0F0x94
typedef union {
  struct {                                                              ///<
    UINT32                                               OrbIndAddr:7 ; ///<
    UINT32                                             Reserved_7_7:1 ; ///<
    UINT32                                               OrbIndWrEn:1 ; ///<
    UINT32                                            Reserved_31_9:23; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} D0F0x94_STRUCT;

// **** D0F0x98 Register Definition ****
// Address
#define D0F0x98_ADDRESS                                         0x98

// Type
#define D0F0x98_TYPE                                            TYPE_D0F0
// Field Data
#define D0F0x98_OrbIndData_OFFSET                               0
#define D0F0x98_OrbIndData_WIDTH                                32
#define D0F0x98_OrbIndData_MASK                                 0xffffffff

/// D0F0x98
typedef union {
  struct {                                                              ///<
    UINT32                                               OrbIndData:32; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} D0F0x98_STRUCT;

// **** D0F0xE0 Register Definition ****
// Address
#define D0F0xE0_ADDRESS                                         0xe0

// Type
#define D0F0xE0_TYPE                                            TYPE_D0F0
// Field Data
#define D0F0xE0_PcieIndxAddr_OFFSET                             0
#define D0F0xE0_PcieIndxAddr_WIDTH                              16
#define D0F0xE0_PcieIndxAddr_MASK                               0xffff
#define D0F0xE0_FrameType_OFFSET                                16
#define D0F0xE0_FrameType_WIDTH                                 8
#define D0F0xE0_FrameType_MASK                                  0xff0000
#define D0F0xE0_BlockSelect_OFFSET                              24
#define D0F0xE0_BlockSelect_WIDTH                               8
#define D0F0xE0_BlockSelect_MASK                                0xff000000

/// D0F0xE0
typedef union {
  struct {                                                              ///<
    UINT32                                             PcieIndxAddr:16; ///<
    UINT32                                                FrameType:8 ; ///<
    UINT32                                              BlockSelect:8 ; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} D0F0xE0_STRUCT;

// **** D0F0xE4 Register Definition ****
// Address
#define D0F0xE4_ADDRESS                                         0xe4

// Type
#define D0F0xE4_TYPE                                            TYPE_D0F0
// Field Data
#define D0F0xE4_PcieIndxData_OFFSET                             0
#define D0F0xE4_PcieIndxData_WIDTH                              32
#define D0F0xE4_PcieIndxData_MASK                               0xffffffff

/// D0F0xE4
typedef union {
  struct {                                                              ///<
    UINT32                                             PcieIndxData:32; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} D0F0xE4_STRUCT;

// **** D18F1xF0 Register Definition ****
// Address
#define D18F1xF0_ADDRESS                                        0xf0

// Type
#define D18F1xF0_TYPE                                           TYPE_D18F1
// Field Data
#define D18F1xF0_DramHoleValid_OFFSET                           0
#define D18F1xF0_DramHoleValid_WIDTH                            1
#define D18F1xF0_DramHoleValid_MASK                             0x1
#define D18F1xF0_Reserved_6_1_OFFSET                            1
#define D18F1xF0_Reserved_6_1_WIDTH                             6
#define D18F1xF0_Reserved_6_1_MASK                              0x7e
#define D18F1xF0_DramHoleOffset_31_23__OFFSET                   7
#define D18F1xF0_DramHoleOffset_31_23__WIDTH                    9
#define D18F1xF0_DramHoleOffset_31_23__MASK                     0xff80
#define D18F1xF0_Reserved_23_16_OFFSET                          16
#define D18F1xF0_Reserved_23_16_WIDTH                           8
#define D18F1xF0_Reserved_23_16_MASK                            0xff0000
#define D18F1xF0_DramHoleBase_31_24__OFFSET                     24
#define D18F1xF0_DramHoleBase_31_24__WIDTH                      8
#define D18F1xF0_DramHoleBase_31_24__MASK                       0xff000000

/// D18F1xF0
typedef union {
  struct {                                                              ///<
    UINT32                                            DramHoleValid:1 ; ///<
    UINT32                                             Reserved_6_1:6 ; ///<
    UINT32                                    DramHoleOffset_31_23_:9 ; ///<
    UINT32                                           Reserved_23_16:8 ; ///<
    UINT32                                      DramHoleBase_31_24_:8 ; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} D18F1xF0_STRUCT;

// **** D18F2x00 Register Definition ****
// Address
#define D18F2x00_ADDRESS                                        0x0

// Type
#define D18F2x00_TYPE                                           TYPE_D18F2
// Field Data
#define D18F2x00_VendorID_OFFSET                                0
#define D18F2x00_VendorID_WIDTH                                 16
#define D18F2x00_VendorID_MASK                                  0xffff
#define D18F2x00_DeviceID_OFFSET                                16
#define D18F2x00_DeviceID_WIDTH                                 16
#define D18F2x00_DeviceID_MASK                                  0xffff0000

/// D18F2x00
typedef union {
  struct {                                                              ///<
    UINT32                                                 VendorID:16; ///<
    UINT32                                                 DeviceID:16; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} D18F2x00_STRUCT;

// **** D18F2x04 Register Definition ****
// Address
#define D18F2x04_ADDRESS                                        0x4

// Type
#define D18F2x04_TYPE                                           TYPE_D18F2
// Field Data
#define D18F2x04_Command_OFFSET                                 0
#define D18F2x04_Command_WIDTH                                  16
#define D18F2x04_Command_MASK                                   0xffff
#define D18F2x04_Status_OFFSET                                  16
#define D18F2x04_Status_WIDTH                                   16
#define D18F2x04_Status_MASK                                    0xffff0000

/// D18F2x04
typedef union {
  struct {                                                              ///<
    UINT32                                                  Command:16; ///<
    UINT32                                                   Status:16; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} D18F2x04_STRUCT;

// **** D18F2x08 Register Definition ****
// Address
#define D18F2x08_ADDRESS                                        0x8

// Type
#define D18F2x08_TYPE                                           TYPE_D18F2
// Field Data
#define D18F2x08_RevID_OFFSET                                   0
#define D18F2x08_RevID_WIDTH                                    8
#define D18F2x08_RevID_MASK                                     0xff
#define D18F2x08_ClassCode_OFFSET                               8
#define D18F2x08_ClassCode_WIDTH                                24
#define D18F2x08_ClassCode_MASK                                 0xffffff00

/// D18F2x08
typedef union {
  struct {                                                              ///<
    UINT32                                                    RevID:8 ; ///<
    UINT32                                                ClassCode:24; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} D18F2x08_STRUCT;

// **** D18F2x0C Register Definition ****
// Address
#define D18F2x0C_ADDRESS                                        0xc

// Type
#define D18F2x0C_TYPE                                           TYPE_D18F2
// Field Data
#define D18F2x0C_HeaderTypeReg_OFFSET                           0
#define D18F2x0C_HeaderTypeReg_WIDTH                            32
#define D18F2x0C_HeaderTypeReg_MASK                             0xffffffff

/// D18F2x0C
typedef union {
  struct {                                                              ///<
    UINT32                                            HeaderTypeReg:32; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} D18F2x0C_STRUCT;

// **** D18F2x34 Register Definition ****
// Address
#define D18F2x34_ADDRESS                                        0x34

// Type
#define D18F2x34_TYPE                                           TYPE_D18F2
// Field Data
#define D18F2x34_CapPtr_OFFSET                                  0
#define D18F2x34_CapPtr_WIDTH                                   8
#define D18F2x34_CapPtr_MASK                                    0xff
#define D18F2x34_Reserved_31_8_OFFSET                           8
#define D18F2x34_Reserved_31_8_WIDTH                            24
#define D18F2x34_Reserved_31_8_MASK                             0xffffff00

/// D18F2x34
typedef union {
  struct {                                                              ///<
    UINT32                                                   CapPtr:8 ; ///<
    UINT32                                            Reserved_31_8:24; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} D18F2x34_STRUCT;

// **** D18F2x040 Register Definition ****
// Address
#define D18F2x040_ADDRESS                                       0x40

// Type
#define D18F2x040_TYPE                                          TYPE_D18F2
// Field Data
#define D18F2x040_CSEnable_OFFSET                               0
#define D18F2x040_CSEnable_WIDTH                                1
#define D18F2x040_CSEnable_MASK                                 0x1
#define D18F2x040_Reserved_1_1_OFFSET                           1
#define D18F2x040_Reserved_1_1_WIDTH                            1
#define D18F2x040_Reserved_1_1_MASK                             0x2
#define D18F2x040_TestFail_OFFSET                               2
#define D18F2x040_TestFail_WIDTH                                1
#define D18F2x040_TestFail_MASK                                 0x4
#define D18F2x040_OnDimmMirror_OFFSET                           3
#define D18F2x040_OnDimmMirror_WIDTH                            1
#define D18F2x040_OnDimmMirror_MASK                             0x8
#define D18F2x040_Reserved_4_4_OFFSET                           4
#define D18F2x040_Reserved_4_4_WIDTH                            1
#define D18F2x040_Reserved_4_4_MASK                             0x10
#define D18F2x040_BaseAddr_21_13__OFFSET                        5
#define D18F2x040_BaseAddr_21_13__WIDTH                         9
#define D18F2x040_BaseAddr_21_13__MASK                          0x3fe0
#define D18F2x040_Reserved_18_14_OFFSET                         14
#define D18F2x040_Reserved_18_14_WIDTH                          5
#define D18F2x040_Reserved_18_14_MASK                           0x7c000
#define D18F2x040_BaseAddr_36_27__OFFSET                        19
#define D18F2x040_BaseAddr_36_27__WIDTH                         10
#define D18F2x040_BaseAddr_36_27__MASK                          0x1ff80000
#define D18F2x040_Reserved_31_29_OFFSET                         29
#define D18F2x040_Reserved_31_29_WIDTH                          3
#define D18F2x040_Reserved_31_29_MASK                           0xe0000000

/// D18F2x040
typedef union {
  struct {                                                              ///<
    UINT32                                                 CSEnable:1 ; ///<
    UINT32                                             Reserved_1_1:1 ; ///<
    UINT32                                                 TestFail:1 ; ///<
    UINT32                                             OnDimmMirror:1 ; ///<
    UINT32                                             Reserved_4_4:1 ; ///<
    UINT32                                          BaseAddr_21_13_:9 ; ///<
    UINT32                                           Reserved_18_14:5 ; ///<
    UINT32                                          BaseAddr_36_27_:10; ///<
    UINT32                                           Reserved_31_29:3 ; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} D18F2x040_STRUCT;

// **** D18F2x044 Register Definition ****
// Address
#define D18F2x044_ADDRESS                                       0x44

// Type
#define D18F2x044_TYPE                                          TYPE_D18F2
// Field Data
#define D18F2x044_CSEnable_OFFSET                               0
#define D18F2x044_CSEnable_WIDTH                                1
#define D18F2x044_CSEnable_MASK                                 0x1
#define D18F2x044_Reserved_1_1_OFFSET                           1
#define D18F2x044_Reserved_1_1_WIDTH                            1
#define D18F2x044_Reserved_1_1_MASK                             0x2
#define D18F2x044_TestFail_OFFSET                               2
#define D18F2x044_TestFail_WIDTH                                1
#define D18F2x044_TestFail_MASK                                 0x4
#define D18F2x044_OnDimmMirror_OFFSET                           3
#define D18F2x044_OnDimmMirror_WIDTH                            1
#define D18F2x044_OnDimmMirror_MASK                             0x8
#define D18F2x044_Reserved_4_4_OFFSET                           4
#define D18F2x044_Reserved_4_4_WIDTH                            1
#define D18F2x044_Reserved_4_4_MASK                             0x10
#define D18F2x044_BaseAddr_21_13__OFFSET                        5
#define D18F2x044_BaseAddr_21_13__WIDTH                         9
#define D18F2x044_BaseAddr_21_13__MASK                          0x3fe0
#define D18F2x044_Reserved_18_14_OFFSET                         14
#define D18F2x044_Reserved_18_14_WIDTH                          5
#define D18F2x044_Reserved_18_14_MASK                           0x7c000
#define D18F2x044_BaseAddr_36_27__OFFSET                        19
#define D18F2x044_BaseAddr_36_27__WIDTH                         10
#define D18F2x044_BaseAddr_36_27__MASK                          0x1ff80000
#define D18F2x044_Reserved_31_29_OFFSET                         29
#define D18F2x044_Reserved_31_29_WIDTH                          3
#define D18F2x044_Reserved_31_29_MASK                           0xe0000000

/// D18F2x044
typedef union {
  struct {                                                              ///<
    UINT32                                                 CSEnable:1 ; ///<
    UINT32                                             Reserved_1_1:1 ; ///<
    UINT32                                                 TestFail:1 ; ///<
    UINT32                                             OnDimmMirror:1 ; ///<
    UINT32                                             Reserved_4_4:1 ; ///<
    UINT32                                          BaseAddr_21_13_:9 ; ///<
    UINT32                                           Reserved_18_14:5 ; ///<
    UINT32                                          BaseAddr_36_27_:10; ///<
    UINT32                                           Reserved_31_29:3 ; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} D18F2x044_STRUCT;

// **** D18F2x048 Register Definition ****
// Address
#define D18F2x048_ADDRESS                                       0x48

// Type
#define D18F2x048_TYPE                                          TYPE_D18F2
// Field Data
#define D18F2x048_CSEnable_OFFSET                               0
#define D18F2x048_CSEnable_WIDTH                                1
#define D18F2x048_CSEnable_MASK                                 0x1
#define D18F2x048_Reserved_1_1_OFFSET                           1
#define D18F2x048_Reserved_1_1_WIDTH                            1
#define D18F2x048_Reserved_1_1_MASK                             0x2
#define D18F2x048_TestFail_OFFSET                               2
#define D18F2x048_TestFail_WIDTH                                1
#define D18F2x048_TestFail_MASK                                 0x4
#define D18F2x048_OnDimmMirror_OFFSET                           3
#define D18F2x048_OnDimmMirror_WIDTH                            1
#define D18F2x048_OnDimmMirror_MASK                             0x8
#define D18F2x048_Reserved_4_4_OFFSET                           4
#define D18F2x048_Reserved_4_4_WIDTH                            1
#define D18F2x048_Reserved_4_4_MASK                             0x10
#define D18F2x048_BaseAddr_21_13__OFFSET                        5
#define D18F2x048_BaseAddr_21_13__WIDTH                         9
#define D18F2x048_BaseAddr_21_13__MASK                          0x3fe0
#define D18F2x048_Reserved_18_14_OFFSET                         14
#define D18F2x048_Reserved_18_14_WIDTH                          5
#define D18F2x048_Reserved_18_14_MASK                           0x7c000
#define D18F2x048_BaseAddr_36_27__OFFSET                        19
#define D18F2x048_BaseAddr_36_27__WIDTH                         10
#define D18F2x048_BaseAddr_36_27__MASK                          0x1ff80000
#define D18F2x048_Reserved_31_29_OFFSET                         29
#define D18F2x048_Reserved_31_29_WIDTH                          3
#define D18F2x048_Reserved_31_29_MASK                           0xe0000000

/// D18F2x048
typedef union {
  struct {                                                              ///<
    UINT32                                                 CSEnable:1 ; ///<
    UINT32                                             Reserved_1_1:1 ; ///<
    UINT32                                                 TestFail:1 ; ///<
    UINT32                                             OnDimmMirror:1 ; ///<
    UINT32                                             Reserved_4_4:1 ; ///<
    UINT32                                          BaseAddr_21_13_:9 ; ///<
    UINT32                                           Reserved_18_14:5 ; ///<
    UINT32                                          BaseAddr_36_27_:10; ///<
    UINT32                                           Reserved_31_29:3 ; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} D18F2x048_STRUCT;

// **** D18F2x04C Register Definition ****
// Address
#define D18F2x04C_ADDRESS                                       0x4c

// Type
#define D18F2x04C_TYPE                                          TYPE_D18F2
// Field Data
#define D18F2x04C_CSEnable_OFFSET                               0
#define D18F2x04C_CSEnable_WIDTH                                1
#define D18F2x04C_CSEnable_MASK                                 0x1
#define D18F2x04C_Reserved_1_1_OFFSET                           1
#define D18F2x04C_Reserved_1_1_WIDTH                            1
#define D18F2x04C_Reserved_1_1_MASK                             0x2
#define D18F2x04C_TestFail_OFFSET                               2
#define D18F2x04C_TestFail_WIDTH                                1
#define D18F2x04C_TestFail_MASK                                 0x4
#define D18F2x04C_OnDimmMirror_OFFSET                           3
#define D18F2x04C_OnDimmMirror_WIDTH                            1
#define D18F2x04C_OnDimmMirror_MASK                             0x8
#define D18F2x04C_Reserved_4_4_OFFSET                           4
#define D18F2x04C_Reserved_4_4_WIDTH                            1
#define D18F2x04C_Reserved_4_4_MASK                             0x10
#define D18F2x04C_BaseAddr_21_13__OFFSET                        5
#define D18F2x04C_BaseAddr_21_13__WIDTH                         9
#define D18F2x04C_BaseAddr_21_13__MASK                          0x3fe0
#define D18F2x04C_Reserved_18_14_OFFSET                         14
#define D18F2x04C_Reserved_18_14_WIDTH                          5
#define D18F2x04C_Reserved_18_14_MASK                           0x7c000
#define D18F2x04C_BaseAddr_36_27__OFFSET                        19
#define D18F2x04C_BaseAddr_36_27__WIDTH                         10
#define D18F2x04C_BaseAddr_36_27__MASK                          0x1ff80000
#define D18F2x04C_Reserved_31_29_OFFSET                         29
#define D18F2x04C_Reserved_31_29_WIDTH                          3
#define D18F2x04C_Reserved_31_29_MASK                           0xe0000000

/// D18F2x04C
typedef union {
  struct {                                                              ///<
    UINT32                                                 CSEnable:1 ; ///<
    UINT32                                             Reserved_1_1:1 ; ///<
    UINT32                                                 TestFail:1 ; ///<
    UINT32                                             OnDimmMirror:1 ; ///<
    UINT32                                             Reserved_4_4:1 ; ///<
    UINT32                                          BaseAddr_21_13_:9 ; ///<
    UINT32                                           Reserved_18_14:5 ; ///<
    UINT32                                          BaseAddr_36_27_:10; ///<
    UINT32                                           Reserved_31_29:3 ; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} D18F2x04C_STRUCT;

// **** D18F2x060 Register Definition ****
// Address
#define D18F2x060_ADDRESS                                       0x60

// Type
#define D18F2x060_TYPE                                          TYPE_D18F2
// Field Data
#define D18F2x060_Reserved_4_0_OFFSET                           0
#define D18F2x060_Reserved_4_0_WIDTH                            5
#define D18F2x060_Reserved_4_0_MASK                             0x1f
#define D18F2x060_AddrMask_21_13__OFFSET                        5
#define D18F2x060_AddrMask_21_13__WIDTH                         9
#define D18F2x060_AddrMask_21_13__MASK                          0x3fe0
#define D18F2x060_Reserved_18_14_OFFSET                         14
#define D18F2x060_Reserved_18_14_WIDTH                          5
#define D18F2x060_Reserved_18_14_MASK                           0x7c000
#define D18F2x060_AddrMask_36_27__OFFSET                        19
#define D18F2x060_AddrMask_36_27__WIDTH                         10
#define D18F2x060_AddrMask_36_27__MASK                          0x1ff80000
#define D18F2x060_Reserved_31_29_OFFSET                         29
#define D18F2x060_Reserved_31_29_WIDTH                          3
#define D18F2x060_Reserved_31_29_MASK                           0xe0000000

/// D18F2x060
typedef union {
  struct {                                                              ///<
    UINT32                                             Reserved_4_0:5 ; ///<
    UINT32                                          AddrMask_21_13_:9 ; ///<
    UINT32                                           Reserved_18_14:5 ; ///<
    UINT32                                          AddrMask_36_27_:10; ///<
    UINT32                                           Reserved_31_29:3 ; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} D18F2x060_STRUCT;

// **** D18F2x064 Register Definition ****
// Address
#define D18F2x064_ADDRESS                                       0x64

// Type
#define D18F2x064_TYPE                                          TYPE_D18F2
// Field Data
#define D18F2x064_Reserved_4_0_OFFSET                           0
#define D18F2x064_Reserved_4_0_WIDTH                            5
#define D18F2x064_Reserved_4_0_MASK                             0x1f
#define D18F2x064_AddrMask_21_13__OFFSET                        5
#define D18F2x064_AddrMask_21_13__WIDTH                         9
#define D18F2x064_AddrMask_21_13__MASK                          0x3fe0
#define D18F2x064_Reserved_18_14_OFFSET                         14
#define D18F2x064_Reserved_18_14_WIDTH                          5
#define D18F2x064_Reserved_18_14_MASK                           0x7c000
#define D18F2x064_AddrMask_36_27__OFFSET                        19
#define D18F2x064_AddrMask_36_27__WIDTH                         10
#define D18F2x064_AddrMask_36_27__MASK                          0x1ff80000
#define D18F2x064_Reserved_31_29_OFFSET                         29
#define D18F2x064_Reserved_31_29_WIDTH                          3
#define D18F2x064_Reserved_31_29_MASK                           0xe0000000

/// D18F2x064
typedef union {
  struct {                                                              ///<
    UINT32                                             Reserved_4_0:5 ; ///<
    UINT32                                          AddrMask_21_13_:9 ; ///<
    UINT32                                           Reserved_18_14:5 ; ///<
    UINT32                                          AddrMask_36_27_:10; ///<
    UINT32                                           Reserved_31_29:3 ; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} D18F2x064_STRUCT;

// **** D18F2x078 Register Definition ****
// Address
#define D18F2x078_ADDRESS                                       0x78

// Type
#define D18F2x078_TYPE                                          TYPE_D18F2
// Field Data
#define D18F2x078_RdPtrInit_OFFSET                              0
#define D18F2x078_RdPtrInit_WIDTH                               4
#define D18F2x078_RdPtrInit_MASK                                0xf
#define D18F2x078_Reserved_5_4_OFFSET                           4
#define D18F2x078_Reserved_5_4_WIDTH                            2
#define D18F2x078_Reserved_5_4_MASK                             0x30
#define D18F2x078_RxPtrInitReq_OFFSET                           6
#define D18F2x078_RxPtrInitReq_WIDTH                            1
#define D18F2x078_RxPtrInitReq_MASK                             0x40
#define D18F2x078_Reserved_7_7_OFFSET                           7
#define D18F2x078_Reserved_7_7_WIDTH                            1
#define D18F2x078_Reserved_7_7_MASK                             0x80
#define D18F2x078_Twrrd_3_2__OFFSET                             8
#define D18F2x078_Twrrd_3_2__WIDTH                              2
#define D18F2x078_Twrrd_3_2__MASK                               0x300
#define D18F2x078_Twrwr_3_2__OFFSET                             10
#define D18F2x078_Twrwr_3_2__WIDTH                              2
#define D18F2x078_Twrwr_3_2__MASK                               0xc00
#define D18F2x078_Trdrd_3_2__OFFSET                             12
#define D18F2x078_Trdrd_3_2__WIDTH                              2
#define D18F2x078_Trdrd_3_2__MASK                               0x3000
#define D18F2x078_Reserved_14_14_OFFSET                         14
#define D18F2x078_Reserved_14_14_WIDTH                          1
#define D18F2x078_Reserved_14_14_MASK                           0x4000
#define D18F2x078_Reserved_15_15_OFFSET                         15
#define D18F2x078_Reserved_15_15_WIDTH                          1
#define D18F2x078_Reserved_15_15_MASK                           0x8000
#define D18F2x078_Reserved_16_16_OFFSET                         16
#define D18F2x078_Reserved_16_16_WIDTH                          1
#define D18F2x078_Reserved_16_16_MASK                           0x10000
#define D18F2x078_AddrCmdTriEn_OFFSET                           17
#define D18F2x078_AddrCmdTriEn_WIDTH                            1
#define D18F2x078_AddrCmdTriEn_MASK                             0x20000
#define D18F2x078_Reserved_18_18_OFFSET                         18
#define D18F2x078_Reserved_18_18_WIDTH                          1
#define D18F2x078_Reserved_18_18_MASK                           0x40000
#define D18F2x078_Reserved_19_19_OFFSET                         19
#define D18F2x078_Reserved_19_19_WIDTH                          1
#define D18F2x078_Reserved_19_19_MASK                           0x80000
#define D18F2x078_ForceCasToSlot_OFFSET                         20
#define D18F2x078_ForceCasToSlot_WIDTH                          1
#define D18F2x078_ForceCasToSlot_MASK                           0x100000
#define D18F2x078_DisCutThroughMode_OFFSET                      21
#define D18F2x078_DisCutThroughMode_WIDTH                       1
#define D18F2x078_DisCutThroughMode_MASK                        0x200000
#define D18F2x078_MaxRdLatency_OFFSET                           22
#define D18F2x078_MaxRdLatency_WIDTH                            10
#define D18F2x078_MaxRdLatency_MASK                             0xffc00000

/// D18F2x078
typedef union {
  struct {                                                              ///<
    UINT32                                                RdPtrInit:4 ; ///<
    UINT32                                             Reserved_5_4:2 ; ///<
    UINT32                                             RxPtrInitReq:1 ; ///<
    UINT32                                             Reserved_7_7:1 ; ///<
    UINT32                                               Twrrd_3_2_:2 ; ///<
    UINT32                                               Twrwr_3_2_:2 ; ///<
    UINT32                                               Trdrd_3_2_:2 ; ///<
    UINT32                                           Reserved_14_14:1 ; ///<
    UINT32                                           Reserved_15_15:1 ; ///<
    UINT32                                           Reserved_16_16:1 ; ///<
    UINT32                                             AddrCmdTriEn:1 ; ///<
    UINT32                                           Reserved_18_18:1 ; ///<
    UINT32                                           Reserved_19_19:1 ; ///<
    UINT32                                           ForceCasToSlot:1 ; ///<
    UINT32                                        DisCutThroughMode:1 ; ///<
    UINT32                                             MaxRdLatency:10; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} D18F2x078_STRUCT;

// **** D18F2x07C Register Definition ****
// Address
#define D18F2x07C_ADDRESS                                       0x7c

// Type
#define D18F2x07C_TYPE                                          TYPE_D18F2
// Field Data
#define D18F2x07C_MrsAddress_OFFSET                             0
#define D18F2x07C_MrsAddress_WIDTH                              16
#define D18F2x07C_MrsAddress_MASK                               0xffff
#define D18F2x07C_MrsBank_OFFSET                                16
#define D18F2x07C_MrsBank_WIDTH                                 3
#define D18F2x07C_MrsBank_MASK                                  0x70000
#define D18F2x07C_Reserved_19_19_OFFSET                         19
#define D18F2x07C_Reserved_19_19_WIDTH                          1
#define D18F2x07C_Reserved_19_19_MASK                           0x80000
#define D18F2x07C_MrsChipSel_OFFSET                             20
#define D18F2x07C_MrsChipSel_WIDTH                              3
#define D18F2x07C_MrsChipSel_MASK                               0x700000
#define D18F2x07C_Reserved_23_23_OFFSET                         23
#define D18F2x07C_Reserved_23_23_WIDTH                          1
#define D18F2x07C_Reserved_23_23_MASK                           0x800000
#define D18F2x07C_SendPchgAll_OFFSET                            24
#define D18F2x07C_SendPchgAll_WIDTH                             1
#define D18F2x07C_SendPchgAll_MASK                              0x1000000
#define D18F2x07C_SendAutoRefresh_OFFSET                        25
#define D18F2x07C_SendAutoRefresh_WIDTH                         1
#define D18F2x07C_SendAutoRefresh_MASK                          0x2000000
#define D18F2x07C_SendMrsCmd_OFFSET                             26
#define D18F2x07C_SendMrsCmd_WIDTH                              1
#define D18F2x07C_SendMrsCmd_MASK                               0x4000000
#define D18F2x07C_DeassertMemRstX_OFFSET                        27
#define D18F2x07C_DeassertMemRstX_WIDTH                         1
#define D18F2x07C_DeassertMemRstX_MASK                          0x8000000
#define D18F2x07C_AssertCke_OFFSET                              28
#define D18F2x07C_AssertCke_WIDTH                               1
#define D18F2x07C_AssertCke_MASK                                0x10000000
#define D18F2x07C_SendZQCmd_OFFSET                              29
#define D18F2x07C_SendZQCmd_WIDTH                               1
#define D18F2x07C_SendZQCmd_MASK                                0x20000000
#define D18F2x07C_Reserved_30_30_OFFSET                         30
#define D18F2x07C_Reserved_30_30_WIDTH                          1
#define D18F2x07C_Reserved_30_30_MASK                           0x40000000
#define D18F2x07C_EnDramInit_OFFSET                             31
#define D18F2x07C_EnDramInit_WIDTH                              1
#define D18F2x07C_EnDramInit_MASK                               0x80000000

/// D18F2x07C
typedef union {
  struct {                                                              ///<
    UINT32                                               MrsAddress:16; ///<
    UINT32                                                  MrsBank:3 ; ///<
    UINT32                                           Reserved_19_19:1 ; ///<
    UINT32                                               MrsChipSel:3 ; ///<
    UINT32                                           Reserved_23_23:1 ; ///<
    UINT32                                              SendPchgAll:1 ; ///<
    UINT32                                          SendAutoRefresh:1 ; ///<
    UINT32                                               SendMrsCmd:1 ; ///<
    UINT32                                          DeassertMemRstX:1 ; ///<
    UINT32                                                AssertCke:1 ; ///<
    UINT32                                                SendZQCmd:1 ; ///<
    UINT32                                           Reserved_30_30:1 ; ///<
    UINT32                                               EnDramInit:1 ; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} D18F2x07C_STRUCT;

// **** D18F2x080 Register Definition ****
// Address
#define D18F2x080_ADDRESS                                       0x80

// Type
#define D18F2x080_TYPE                                          TYPE_D18F2
// Field Data
#define D18F2x080_Dimm0AddrMap_OFFSET                           0
#define D18F2x080_Dimm0AddrMap_WIDTH                            4
#define D18F2x080_Dimm0AddrMap_MASK                             0xf
#define D18F2x080_Dimm1AddrMap_OFFSET                           4
#define D18F2x080_Dimm1AddrMap_WIDTH                            4
#define D18F2x080_Dimm1AddrMap_MASK                             0xf0
#define D18F2x080_Reserved_31_8_OFFSET                          8
#define D18F2x080_Reserved_31_8_WIDTH                           24
#define D18F2x080_Reserved_31_8_MASK                            0xffffff00

/// D18F2x080
typedef union {
  struct {                                                              ///<
    UINT32                                             Dimm0AddrMap:4 ; ///<
    UINT32                                             Dimm1AddrMap:4 ; ///<
    UINT32                                            Reserved_31_8:24; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} D18F2x080_STRUCT;

// **** D18F2x084 Register Definition ****
// Address
#define D18F2x084_ADDRESS                                       0x84

// Type
#define D18F2x084_TYPE                                          TYPE_D18F2
// Field Data
#define D18F2x084_BurstCtrl_OFFSET                              0
#define D18F2x084_BurstCtrl_WIDTH                               2
#define D18F2x084_BurstCtrl_MASK                                0x3
#define D18F2x084_Reserved_3_2_OFFSET                           2
#define D18F2x084_Reserved_3_2_WIDTH                            2
#define D18F2x084_Reserved_3_2_MASK                             0xc
#define D18F2x084_Twr_OFFSET                                    4
#define D18F2x084_Twr_WIDTH                                     3
#define D18F2x084_Twr_MASK                                      0x70
#define D18F2x084_Reserved_19_7_OFFSET                          7
#define D18F2x084_Reserved_19_7_WIDTH                           13
#define D18F2x084_Reserved_19_7_MASK                            0xfff80
#define D18F2x084_Tcwl_OFFSET                                   20
#define D18F2x084_Tcwl_WIDTH                                    3
#define D18F2x084_Tcwl_MASK                                     0x700000
#define D18F2x084_PchgPDModeSel_OFFSET                          23
#define D18F2x084_PchgPDModeSel_WIDTH                           1
#define D18F2x084_PchgPDModeSel_MASK                            0x800000
#define D18F2x084_Reserved_31_24_OFFSET                         24
#define D18F2x084_Reserved_31_24_WIDTH                          8
#define D18F2x084_Reserved_31_24_MASK                           0xff000000

/// D18F2x084
typedef union {
  struct {                                                              ///<
    UINT32                                                BurstCtrl:2 ; ///<
    UINT32                                             Reserved_3_2:2 ; ///<
    UINT32                                                      Twr:3 ; ///<
    UINT32                                            Reserved_19_7:13; ///<
    UINT32                                                     Tcwl:3 ; ///<
    UINT32                                            PchgPDModeSel:1 ; ///<
    UINT32                                           Reserved_31_24:8 ; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} D18F2x084_STRUCT;

// **** D18F2x088 Register Definition ****
// Address
#define D18F2x088_ADDRESS                                       0x88

// Type
#define D18F2x088_TYPE                                          TYPE_D18F2
// Field Data
#define D18F2x088_Tcl_OFFSET                                    0
#define D18F2x088_Tcl_WIDTH                                     4
#define D18F2x088_Tcl_MASK                                      0xf
#define D18F2x088_Reserved_23_4_OFFSET                          4
#define D18F2x088_Reserved_23_4_WIDTH                           20
#define D18F2x088_Reserved_23_4_MASK                            0xfffff0
#define D18F2x088_MemClkDis_OFFSET                              24
#define D18F2x088_MemClkDis_WIDTH                               8
#define D18F2x088_MemClkDis_MASK                                0xff000000

/// D18F2x088
typedef union {
  struct {                                                              ///<
    UINT32                                                      Tcl:4 ; ///<
    UINT32                                            Reserved_23_4:20; ///<
    UINT32                                                MemClkDis:8 ; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} D18F2x088_STRUCT;

// **** D18F2x08C Register Definition ****
// Address
#define D18F2x08C_ADDRESS                                       0x8c

// Type
#define D18F2x08C_TYPE                                          TYPE_D18F2
// Field Data
#define D18F2x08C_TrwtWB_OFFSET                                 0
#define D18F2x08C_TrwtWB_WIDTH                                  4
#define D18F2x08C_TrwtWB_MASK                                   0xf
#define D18F2x08C_TrwtTO_OFFSET                                 4
#define D18F2x08C_TrwtTO_WIDTH                                  4
#define D18F2x08C_TrwtTO_MASK                                   0xf0
#define D18F2x08C_Reserved_9_8_OFFSET                           8
#define D18F2x08C_Reserved_9_8_WIDTH                            2
#define D18F2x08C_Reserved_9_8_MASK                             0x300
#define D18F2x08C_Twrrd_1_0__OFFSET                             10
#define D18F2x08C_Twrrd_1_0__WIDTH                              2
#define D18F2x08C_Twrrd_1_0__MASK                               0xc00
#define D18F2x08C_Twrwr_1_0__OFFSET                             12
#define D18F2x08C_Twrwr_1_0__WIDTH                              2
#define D18F2x08C_Twrwr_1_0__MASK                               0x3000
#define D18F2x08C_Trdrd_1_0__OFFSET                             14
#define D18F2x08C_Trdrd_1_0__WIDTH                              2
#define D18F2x08C_Trdrd_1_0__MASK                               0xc000
#define D18F2x08C_Tref_OFFSET                                   16
#define D18F2x08C_Tref_WIDTH                                    2
#define D18F2x08C_Tref_MASK                                     0x30000
#define D18F2x08C_DisAutoRefresh_OFFSET                         18
#define D18F2x08C_DisAutoRefresh_WIDTH                          1
#define D18F2x08C_DisAutoRefresh_MASK                           0x40000
#define D18F2x08C_Reserved_19_19_OFFSET                         19
#define D18F2x08C_Reserved_19_19_WIDTH                          1
#define D18F2x08C_Reserved_19_19_MASK                           0x80000
#define D18F2x08C_Trfc0_OFFSET                                  20
#define D18F2x08C_Trfc0_WIDTH                                   3
#define D18F2x08C_Trfc0_MASK                                    0x700000
#define D18F2x08C_Trfc1_OFFSET                                  23
#define D18F2x08C_Trfc1_WIDTH                                   3
#define D18F2x08C_Trfc1_MASK                                    0x3800000
#define D18F2x08C_Reserved_31_26_OFFSET                         26
#define D18F2x08C_Reserved_31_26_WIDTH                          6
#define D18F2x08C_Reserved_31_26_MASK                           0xfc000000

/// D18F2x08C
typedef union {
  struct {                                                              ///<
    UINT32                                                   TrwtWB:4 ; ///<
    UINT32                                                   TrwtTO:4 ; ///<
    UINT32                                             Reserved_9_8:2 ; ///<
    UINT32                                               Twrrd_1_0_:2 ; ///<
    UINT32                                               Twrwr_1_0_:2 ; ///<
    UINT32                                               Trdrd_1_0_:2 ; ///<
    UINT32                                                     Tref:2 ; ///<
    UINT32                                           DisAutoRefresh:1 ; ///<
    UINT32                                           Reserved_19_19:1 ; ///<
    UINT32                                                    Trfc0:3 ; ///<
    UINT32                                                    Trfc1:3 ; ///<
    UINT32                                           Reserved_31_26:6 ; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} D18F2x08C_STRUCT;

// **** D18F2x090 Register Definition ****
// Address
#define D18F2x090_ADDRESS                                       0x90

// Type
#define D18F2x090_TYPE                                          TYPE_D18F2
// Field Data
#define D18F2x090_Reserved_0_0_OFFSET                           0
#define D18F2x090_Reserved_0_0_WIDTH                            1
#define D18F2x090_Reserved_0_0_MASK                             0x1
#define D18F2x090_ExitSelfRef_OFFSET                            1
#define D18F2x090_ExitSelfRef_WIDTH                             1
#define D18F2x090_ExitSelfRef_MASK                              0x2
#define D18F2x090_Reserved_16_2_OFFSET                          2
#define D18F2x090_Reserved_16_2_WIDTH                           15
#define D18F2x090_Reserved_16_2_MASK                            0x1fffc
#define D18F2x090_EnterSelfRef_OFFSET                           17
#define D18F2x090_EnterSelfRef_WIDTH                            1
#define D18F2x090_EnterSelfRef_MASK                             0x20000
#define D18F2x090_Reserved_19_18_OFFSET                         18
#define D18F2x090_Reserved_19_18_WIDTH                          2
#define D18F2x090_Reserved_19_18_MASK                           0xc0000
#define D18F2x090_DynPageCloseEn_OFFSET                         20
#define D18F2x090_DynPageCloseEn_WIDTH                          1
#define D18F2x090_DynPageCloseEn_MASK                           0x100000
#define D18F2x090_IdleCycInit_OFFSET                            21
#define D18F2x090_IdleCycInit_WIDTH                             2
#define D18F2x090_IdleCycInit_MASK                              0x600000
#define D18F2x090_ForceAutoPchg_OFFSET                          23
#define D18F2x090_ForceAutoPchg_WIDTH                           1
#define D18F2x090_ForceAutoPchg_MASK                            0x800000
#define D18F2x090_Reserved_24_24_OFFSET                         24
#define D18F2x090_Reserved_24_24_WIDTH                          1
#define D18F2x090_Reserved_24_24_MASK                           0x1000000
#define D18F2x090_EnDispAutoPrecharge_OFFSET                    25
#define D18F2x090_EnDispAutoPrecharge_WIDTH                     1
#define D18F2x090_EnDispAutoPrecharge_MASK                      0x2000000
#define D18F2x090_DbeSkidBufDis_OFFSET                          26
#define D18F2x090_DbeSkidBufDis_WIDTH                           1
#define D18F2x090_DbeSkidBufDis_MASK                            0x4000000
#define D18F2x090_DisDllShutdownSR_OFFSET                       27
#define D18F2x090_DisDllShutdownSR_WIDTH                        1
#define D18F2x090_DisDllShutdownSR_MASK                         0x8000000
#define D18F2x090_Reserved_28_28_OFFSET                         28
#define D18F2x090_Reserved_28_28_WIDTH                          1
#define D18F2x090_Reserved_28_28_MASK                           0x10000000
#define D18F2x090_Reserved_29_29_OFFSET                         29
#define D18F2x090_Reserved_29_29_WIDTH                          1
#define D18F2x090_Reserved_29_29_MASK                           0x20000000
#define D18F2x090_Reserved_31_30_OFFSET                         30
#define D18F2x090_Reserved_31_30_WIDTH                          2
#define D18F2x090_Reserved_31_30_MASK                           0xc0000000

/// D18F2x090
typedef union {
  struct {                                                              ///<
    UINT32                                             Reserved_0_0:1 ; ///<
    UINT32                                              ExitSelfRef:1 ; ///<
    UINT32                                            Reserved_16_2:15; ///<
    UINT32                                             EnterSelfRef:1 ; ///<
    UINT32                                           Reserved_19_18:2 ; ///<
    UINT32                                           DynPageCloseEn:1 ; ///<
    UINT32                                              IdleCycInit:2 ; ///<
    UINT32                                            ForceAutoPchg:1 ; ///<
    UINT32                                           Reserved_24_24:1 ; ///<
    UINT32                                      EnDispAutoPrecharge:1 ; ///<
    UINT32                                            DbeSkidBufDis:1 ; ///<
    UINT32                                         DisDllShutdownSR:1 ; ///<
    UINT32                                           Reserved_28_28:1 ; ///<
    UINT32                                           Reserved_29_29:1 ; ///<
    UINT32                                           Reserved_31_30:2 ; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} D18F2x090_STRUCT;

// **** D18F2x094 Register Definition ****
// Address
#define D18F2x094_ADDRESS                                       0x94

// Type
#define D18F2x094_TYPE                                          TYPE_D18F2
// Field Data
#define D18F2x094_MemClkFreq_OFFSET                             0
#define D18F2x094_MemClkFreq_WIDTH                              5
#define D18F2x094_MemClkFreq_MASK                               0x1f
#define D18F2x094_Reserved_6_5_OFFSET                           5
#define D18F2x094_Reserved_6_5_WIDTH                            2
#define D18F2x094_Reserved_6_5_MASK                             0x60
#define D18F2x094_MemClkFreqVal_OFFSET                          7
#define D18F2x094_MemClkFreqVal_WIDTH                           1
#define D18F2x094_MemClkFreqVal_MASK                            0x80
#define D18F2x094_Reserved_9_8_OFFSET                           8
#define D18F2x094_Reserved_9_8_WIDTH                            2
#define D18F2x094_Reserved_9_8_MASK                             0x300
#define D18F2x094_ZqcsInterval_OFFSET                           10
#define D18F2x094_ZqcsInterval_WIDTH                            2
#define D18F2x094_ZqcsInterval_MASK                             0xc00
#define D18F2x094_Reserved_13_12_OFFSET                         12
#define D18F2x094_Reserved_13_12_WIDTH                          2
#define D18F2x094_Reserved_13_12_MASK                           0x3000
#define D18F2x094_DisDramInterface_OFFSET                       14
#define D18F2x094_DisDramInterface_WIDTH                        1
#define D18F2x094_DisDramInterface_MASK                         0x4000
#define D18F2x094_PowerDownEn_OFFSET                            15
#define D18F2x094_PowerDownEn_WIDTH                             1
#define D18F2x094_PowerDownEn_MASK                              0x8000
#define D18F2x094_PowerDownMode_OFFSET                          16
#define D18F2x094_PowerDownMode_WIDTH                           1
#define D18F2x094_PowerDownMode_MASK                            0x10000
#define D18F2x094_Reserved_19_17_OFFSET                         17
#define D18F2x094_Reserved_19_17_WIDTH                          3
#define D18F2x094_Reserved_19_17_MASK                           0xe0000
#define D18F2x094_SlowAccessMode_OFFSET                         20
#define D18F2x094_SlowAccessMode_WIDTH                          1
#define D18F2x094_SlowAccessMode_MASK                           0x100000
#define D18F2x094_Reserved_21_21_OFFSET                         21
#define D18F2x094_Reserved_21_21_WIDTH                          1
#define D18F2x094_Reserved_21_21_MASK                           0x200000
#define D18F2x094_BankSwizzleMode_OFFSET                        22
#define D18F2x094_BankSwizzleMode_WIDTH                         1
#define D18F2x094_BankSwizzleMode_MASK                          0x400000
#define D18F2x094_ProcOdtDis_OFFSET                             23
#define D18F2x094_ProcOdtDis_WIDTH                              1
#define D18F2x094_ProcOdtDis_MASK                               0x800000
#define D18F2x094_DcqBypassMax_OFFSET                           24
#define D18F2x094_DcqBypassMax_WIDTH                            4
#define D18F2x094_DcqBypassMax_MASK                             0xf000000
#define D18F2x094_FourActWindow_OFFSET                          28
#define D18F2x094_FourActWindow_WIDTH                           4
#define D18F2x094_FourActWindow_MASK                            0xf0000000

/// D18F2x094
typedef union {
  struct {                                                              ///<
    UINT32                                               MemClkFreq:5 ; ///<
    UINT32                                             Reserved_6_5:2 ; ///<
    UINT32                                            MemClkFreqVal:1 ; ///<
    UINT32                                             Reserved_9_8:2 ; ///<
    UINT32                                             ZqcsInterval:2 ; ///<
    UINT32                                           Reserved_13_12:2 ; ///<
    UINT32                                         DisDramInterface:1 ; ///<
    UINT32                                              PowerDownEn:1 ; ///<
    UINT32                                            PowerDownMode:1 ; ///<
    UINT32                                           Reserved_19_17:3 ; ///<
    UINT32                                           SlowAccessMode:1 ; ///<
    UINT32                                           Reserved_21_21:1 ; ///<
    UINT32                                          BankSwizzleMode:1 ; ///<
    UINT32                                               ProcOdtDis:1 ; ///<
    UINT32                                             DcqBypassMax:4 ; ///<
    UINT32                                            FourActWindow:4 ; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} D18F2x094_STRUCT;

// **** D18F2x098 Register Definition ****
// Address
#define D18F2x098_ADDRESS                                       0x98

// Type
#define D18F2x098_TYPE                                          TYPE_D18F2
// Field Data
#define D18F2x098_DctOffset_OFFSET                              0
#define D18F2x098_DctOffset_WIDTH                               30
#define D18F2x098_DctOffset_MASK                                0x3fffffff
#define D18F2x098_DctAccessWrite_OFFSET                         30
#define D18F2x098_DctAccessWrite_WIDTH                          1
#define D18F2x098_DctAccessWrite_MASK                           0x40000000
#define D18F2x098_Reserved_31_31_OFFSET                         31
#define D18F2x098_Reserved_31_31_WIDTH                          1
#define D18F2x098_Reserved_31_31_MASK                           0x80000000

/// D18F2x098
typedef union {
  struct {                                                              ///<
    UINT32                                                DctOffset:30; ///<
    UINT32                                           DctAccessWrite:1 ; ///<
    UINT32                                           Reserved_31_31:1 ; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} D18F2x098_STRUCT;

// **** D18F2x09C Register Definition ****
// Address
#define D18F2x09C_ADDRESS                                       0x9c

// Type
#define D18F2x09C_TYPE                                          TYPE_D18F2
// Field Data
#define D18F2x09C_DctDataPort_OFFSET                            0
#define D18F2x09C_DctDataPort_WIDTH                             32
#define D18F2x09C_DctDataPort_MASK                              0xffffffff

/// D18F2x09C
typedef union {
  struct {                                                              ///<
    UINT32                                              DctDataPort:32; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} D18F2x09C_STRUCT;

// **** D18F2x0A0 Register Definition ****
// Address
#define D18F2x0A0_ADDRESS                                       0xa0

// Type
#define D18F2x0A0_TYPE                                          TYPE_D18F2
// Field Data
#define D18F2x0A0_Reserved_31_0_OFFSET                          0
#define D18F2x0A0_Reserved_31_0_WIDTH                           32
#define D18F2x0A0_Reserved_31_0_MASK                            0xffffffff

/// D18F2x0A0
typedef union {
  struct {                                                              ///<
    UINT32                                            Reserved_31_0:32; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} D18F2x0A0_STRUCT;

// **** D18F2xA4 Register Definition ****
// Address
#define D18F2xA4_ADDRESS                                        0xa4

// Type
#define D18F2xA4_TYPE                                           TYPE_D18F2
// Field Data
#define D18F2xA4_DoubleTrefRateEn_OFFSET                        0
#define D18F2xA4_DoubleTrefRateEn_WIDTH                         1
#define D18F2xA4_DoubleTrefRateEn_MASK                          0x1
#define D18F2xA4_ThrottleEn_OFFSET                              1
#define D18F2xA4_ThrottleEn_WIDTH                               2
#define D18F2xA4_ThrottleEn_MASK                                0x6
#define D18F2xA4_Reserved_31_3_OFFSET                           3
#define D18F2xA4_Reserved_31_3_WIDTH                            29
#define D18F2xA4_Reserved_31_3_MASK                             0xfffffff8

/// D18F2xA4
typedef union {
  struct {                                                              ///<
    UINT32                                         DoubleTrefRateEn:1 ; ///<
    UINT32                                               ThrottleEn:2 ; ///<
    UINT32                                            Reserved_31_3:29; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} D18F2xA4_STRUCT;

// **** D18F2x0A8 Register Definition ****
// Address
#define D18F2x0A8_ADDRESS                                       0xa8

// Type
#define D18F2x0A8_TYPE                                          TYPE_D18F2
// Field Data
#define D18F2x0A8_Reserved_19_0_OFFSET                          0
#define D18F2x0A8_Reserved_19_0_WIDTH                           20
#define D18F2x0A8_Reserved_19_0_MASK                            0xfffff
#define D18F2x0A8_BankSwap_OFFSET                               20
#define D18F2x0A8_BankSwap_WIDTH                                1
#define D18F2x0A8_BankSwap_MASK                                 0x100000
#define D18F2x0A8_DbeGskMemClkAlignMode_OFFSET                  21
#define D18F2x0A8_DbeGskMemClkAlignMode_WIDTH                   2
#define D18F2x0A8_DbeGskMemClkAlignMode_MASK                    0x600000
#define D18F2x0A8_Reserved_31_23_OFFSET                         23
#define D18F2x0A8_Reserved_31_23_WIDTH                          9
#define D18F2x0A8_Reserved_31_23_MASK                           0xff800000

/// D18F2x0A8
typedef union {
  struct {                                                              ///<
    UINT32                                            Reserved_19_0:20; ///<
    UINT32                                                 BankSwap:1 ; ///<
    UINT32                                    DbeGskMemClkAlignMode:2 ; ///<
    UINT32                                           Reserved_31_23:9 ; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} D18F2x0A8_STRUCT;

// **** D18F2xAC Register Definition ****
// Address
#define D18F2xAC_ADDRESS                                        0xac

// Type
#define D18F2xAC_TYPE                                           TYPE_D18F2
// Field Data
#define D18F2xAC_MemTempHot_OFFSET                              0
#define D18F2xAC_MemTempHot_WIDTH                               1
#define D18F2xAC_MemTempHot_MASK                                0x1
#define D18F2xAC_Reserved_31_1_OFFSET                           1
#define D18F2xAC_Reserved_31_1_WIDTH                            31
#define D18F2xAC_Reserved_31_1_MASK                             0xfffffffe

/// D18F2xAC
typedef union {
  struct {                                                              ///<
    UINT32                                               MemTempHot:1 ; ///<
    UINT32                                            Reserved_31_1:31; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} D18F2xAC_STRUCT;

// **** D18F2x0F0 Register Definition ****
// Address
#define D18F2x0F0_ADDRESS                                       0xf0

// Type
#define D18F2x0F0_TYPE                                          TYPE_D18F2
// Field Data
#define D18F2x0F0_DctOffset_OFFSET                              0
#define D18F2x0F0_DctOffset_WIDTH                               28
#define D18F2x0F0_DctOffset_MASK                                0xfffffff
#define D18F2x0F0_Reserved_29_28_OFFSET                         28
#define D18F2x0F0_Reserved_29_28_WIDTH                          2
#define D18F2x0F0_Reserved_29_28_MASK                           0x30000000
#define D18F2x0F0_DctAccessWrite_OFFSET                         30
#define D18F2x0F0_DctAccessWrite_WIDTH                          1
#define D18F2x0F0_DctAccessWrite_MASK                           0x40000000
#define D18F2x0F0_DctAccessDone_OFFSET                          31
#define D18F2x0F0_DctAccessDone_WIDTH                           1
#define D18F2x0F0_DctAccessDone_MASK                            0x80000000

/// D18F2x0F0
typedef union {
  struct {                                                              ///<
    UINT32                                                DctOffset:28; ///<
    UINT32                                           Reserved_29_28:2 ; ///<
    UINT32                                           DctAccessWrite:1 ; ///<
    UINT32                                            DctAccessDone:1 ; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} D18F2x0F0_STRUCT;

// **** D18F2x0F4 Register Definition ****
// Address
#define D18F2x0F4_ADDRESS                                       0xf4

// Type
#define D18F2x0F4_TYPE                                          TYPE_D18F2
// Field Data
#define D18F2x0F4_DctExtDataPort_OFFSET                         0
#define D18F2x0F4_DctExtDataPort_WIDTH                          32
#define D18F2x0F4_DctExtDataPort_MASK                           0xffffffff

/// D18F2x0F4
typedef union {
  struct {                                                              ///<
    UINT32                                           DctExtDataPort:32; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} D18F2x0F4_STRUCT;

// **** D18F2x10C Register Definition ****
// Address
#define D18F2x10C_ADDRESS                                       0x10c

// Type
#define D18F2x10C_TYPE                                          TYPE_D18F2
// Field Data
#define D18F2x10C_IntLvRegionEn_OFFSET                          0
#define D18F2x10C_IntLvRegionEn_WIDTH                           1
#define D18F2x10C_IntLvRegionEn_MASK                            0x1
#define D18F2x10C_Reserved_2_1_OFFSET                           1
#define D18F2x10C_Reserved_2_1_WIDTH                            2
#define D18F2x10C_Reserved_2_1_MASK                             0x6
#define D18F2x10C_IntLvRegionBase_OFFSET                        3
#define D18F2x10C_IntLvRegionBase_WIDTH                         5
#define D18F2x10C_IntLvRegionBase_MASK                          0xf8
#define D18F2x10C_Reserved_10_8_OFFSET                          8
#define D18F2x10C_Reserved_10_8_WIDTH                           3
#define D18F2x10C_Reserved_10_8_MASK                            0x700
#define D18F2x10C_IntLvRegionLimit_OFFSET                       11
#define D18F2x10C_IntLvRegionLimit_WIDTH                        5
#define D18F2x10C_IntLvRegionLimit_MASK                         0xf800
#define D18F2x10C_Reserved_31_16_OFFSET                         16
#define D18F2x10C_Reserved_31_16_WIDTH                          16
#define D18F2x10C_Reserved_31_16_MASK                           0xffff0000

/// D18F2x10C
typedef union {
  struct {                                                              ///<
    UINT32                                            IntLvRegionEn:1 ; ///<
    UINT32                                             Reserved_2_1:2 ; ///<
    UINT32                                          IntLvRegionBase:5 ; ///<
    UINT32                                            Reserved_10_8:3 ; ///<
    UINT32                                         IntLvRegionLimit:5 ; ///<
    UINT32                                           Reserved_31_16:16; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} D18F2x10C_STRUCT;

// **** D18F2x110 Register Definition ****
// Address
#define D18F2x110_ADDRESS                                       0x110

// Type
#define D18F2x110_TYPE                                          TYPE_D18F2
// Field Data
#define D18F2x110_DctSelHiRngEn_OFFSET                          0
#define D18F2x110_DctSelHiRngEn_WIDTH                           1
#define D18F2x110_DctSelHiRngEn_MASK                            0x1
#define D18F2x110_DctSelHi_OFFSET                               1
#define D18F2x110_DctSelHi_WIDTH                                1
#define D18F2x110_DctSelHi_MASK                                 0x2
#define D18F2x110_DctSelIntLvEn_OFFSET                          2
#define D18F2x110_DctSelIntLvEn_WIDTH                           1
#define D18F2x110_DctSelIntLvEn_MASK                            0x4
#define D18F2x110_MemClrInit_OFFSET                             3
#define D18F2x110_MemClrInit_WIDTH                              1
#define D18F2x110_MemClrInit_MASK                               0x8
#define D18F2x110_Reserved_5_4_OFFSET                           4
#define D18F2x110_Reserved_5_4_WIDTH                            2
#define D18F2x110_Reserved_5_4_MASK                             0x30
#define D18F2x110_DctSelIntLvAddr_1_0__OFFSET                   6
#define D18F2x110_DctSelIntLvAddr_1_0__WIDTH                    2
#define D18F2x110_DctSelIntLvAddr_1_0__MASK                     0xc0
#define D18F2x110_DramEnable_OFFSET                             8
#define D18F2x110_DramEnable_WIDTH                              1
#define D18F2x110_DramEnable_MASK                               0x100
#define D18F2x110_MemClrBusy_OFFSET                             9
#define D18F2x110_MemClrBusy_WIDTH                              1
#define D18F2x110_MemClrBusy_MASK                               0x200
#define D18F2x110_MemCleared_OFFSET                             10
#define D18F2x110_MemCleared_WIDTH                              1
#define D18F2x110_MemCleared_MASK                               0x400
#define D18F2x110_DctSelBaseAddr_39_27__OFFSET                  11
#define D18F2x110_DctSelBaseAddr_39_27__WIDTH                   13
#define D18F2x110_DctSelBaseAddr_39_27__MASK                    0xfff800
#define D18F2x110_Reserved_31_24_OFFSET                         24
#define D18F2x110_Reserved_31_24_WIDTH                          8
#define D18F2x110_Reserved_31_24_MASK                           0xff000000

/// D18F2x110
typedef union {
  struct {                                                              ///<
    UINT32                                            DctSelHiRngEn:1 ; ///<
    UINT32                                                 DctSelHi:1 ; ///<
    UINT32                                            DctSelIntLvEn:1 ; ///<
    UINT32                                               MemClrInit:1 ; ///<
    UINT32                                             Reserved_5_4:2 ; ///<
    UINT32                                     DctSelIntLvAddr_1_0_:2 ; ///<
    UINT32                                               DramEnable:1 ; ///<
    UINT32                                               MemClrBusy:1 ; ///<
    UINT32                                               MemCleared:1 ; ///<
    UINT32                                    DctSelBaseAddr_39_27_:13; ///<
    UINT32                                           Reserved_31_24:8 ; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} D18F2x110_STRUCT;

// **** D18F2x114 Register Definition ****
// Address
#define D18F2x114_ADDRESS                                       0x114

// Type
#define D18F2x114_TYPE                                          TYPE_D18F2
// Field Data
#define D18F2x114_Reserved_8_0_OFFSET                           0
#define D18F2x114_Reserved_8_0_WIDTH                            9
#define D18F2x114_Reserved_8_0_MASK                             0x1ff
#define D18F2x114_DctSelIntLvAddr_2__OFFSET                     9
#define D18F2x114_DctSelIntLvAddr_2__WIDTH                      1
#define D18F2x114_DctSelIntLvAddr_2__MASK                       0x200
#define D18F2x114_DctSelBaseOffset_39_26__OFFSET                10
#define D18F2x114_DctSelBaseOffset_39_26__WIDTH                 14
#define D18F2x114_DctSelBaseOffset_39_26__MASK                  0xfffc00
#define D18F2x114_Reserved_31_24_OFFSET                         24
#define D18F2x114_Reserved_31_24_WIDTH                          8
#define D18F2x114_Reserved_31_24_MASK                           0xff000000

/// D18F2x114
typedef union {
  struct {                                                              ///<
    UINT32                                             Reserved_8_0:9 ; ///<
    UINT32                                       DctSelIntLvAddr_2_:1 ; ///<
    UINT32                                  DctSelBaseOffset_39_26_:14; ///<
    UINT32                                           Reserved_31_24:8 ; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} D18F2x114_STRUCT;

// **** D18F2x118 Register Definition ****
// Address
#define D18F2x118_ADDRESS                                       0x118

// Type
#define D18F2x118_TYPE                                          TYPE_D18F2
// Field Data
#define D18F2x118_MctPriCpuRd_OFFSET                            0
#define D18F2x118_MctPriCpuRd_WIDTH                             2
#define D18F2x118_MctPriCpuRd_MASK                              0x3
#define D18F2x118_MctPriCpuWr_OFFSET                            2
#define D18F2x118_MctPriCpuWr_WIDTH                             2
#define D18F2x118_MctPriCpuWr_MASK                              0xc
#define D18F2x118_MctPriHiRd_OFFSET                             4
#define D18F2x118_MctPriHiRd_WIDTH                              2
#define D18F2x118_MctPriHiRd_MASK                               0x30
#define D18F2x118_MctPriHiWr_OFFSET                             6
#define D18F2x118_MctPriHiWr_WIDTH                              2
#define D18F2x118_MctPriHiWr_MASK                               0xc0
#define D18F2x118_MctPriDefault_OFFSET                          8
#define D18F2x118_MctPriDefault_WIDTH                           2
#define D18F2x118_MctPriDefault_MASK                            0x300
#define D18F2x118_MctPriWr_OFFSET                               10
#define D18F2x118_MctPriWr_WIDTH                                2
#define D18F2x118_MctPriWr_MASK                                 0xc00
#define D18F2x118_Reserved_18_12_OFFSET                         12
#define D18F2x118_Reserved_18_12_WIDTH                          7
#define D18F2x118_Reserved_18_12_MASK                           0x7f000
#define D18F2x118_C6DramLock_OFFSET                             19
#define D18F2x118_C6DramLock_WIDTH                              1
#define D18F2x118_C6DramLock_MASK                               0x80000
#define D18F2x118_Reserved_27_20_OFFSET                         20
#define D18F2x118_Reserved_27_20_WIDTH                          8
#define D18F2x118_Reserved_27_20_MASK                           0xff00000
#define D18F2x118_MctVarPriCntLmt_OFFSET                        28
#define D18F2x118_MctVarPriCntLmt_WIDTH                         4
#define D18F2x118_MctVarPriCntLmt_MASK                          0xf0000000

/// D18F2x118
typedef union {
  struct {                                                              ///<
    UINT32                                              MctPriCpuRd:2 ; ///<
    UINT32                                              MctPriCpuWr:2 ; ///<
    UINT32                                               MctPriHiRd:2 ; ///<
    UINT32                                               MctPriHiWr:2 ; ///<
    UINT32                                            MctPriDefault:2 ; ///<
    UINT32                                                 MctPriWr:2 ; ///<
    UINT32                                           Reserved_18_12:7 ; ///<
    UINT32                                               C6DramLock:1 ; ///<
    UINT32                                           Reserved_27_20:8 ; ///<
    UINT32                                          MctVarPriCntLmt:4 ; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} D18F2x118_STRUCT;

// **** D18F2x11C Register Definition ****
// Address
#define D18F2x11C_ADDRESS                                       0x11c

// Type
#define D18F2x11C_TYPE                                          TYPE_D18F2
// Field Data
#define D18F2x11C_Reserved_1_0_OFFSET                           0
#define D18F2x11C_Reserved_1_0_WIDTH                            2
#define D18F2x11C_Reserved_1_0_MASK                             0x3
#define D18F2x11C_DctWrLimit_OFFSET                             2
#define D18F2x11C_DctWrLimit_WIDTH                              5
#define D18F2x11C_DctWrLimit_MASK                               0x7c
#define D18F2x11C_Reserved_11_7_OFFSET                          7
#define D18F2x11C_Reserved_11_7_WIDTH                           5
#define D18F2x11C_Reserved_11_7_MASK                            0xf80
#define D18F2x11C_PrefCpuDis_OFFSET                             12
#define D18F2x11C_PrefCpuDis_WIDTH                              1
#define D18F2x11C_PrefCpuDis_MASK                               0x1000
#define D18F2x11C_Reserved_13_13_OFFSET                         13
#define D18F2x11C_Reserved_13_13_WIDTH                          1
#define D18F2x11C_Reserved_13_13_MASK                           0x2000
#define D18F2x11C_PrefCpuRdSzDis_OFFSET                         14
#define D18F2x11C_PrefCpuRdSzDis_WIDTH                          1
#define D18F2x11C_PrefCpuRdSzDis_MASK                           0x4000
#define D18F2x11C_Reserved_17_15_OFFSET                         15
#define D18F2x11C_Reserved_17_15_WIDTH                          3
#define D18F2x11C_Reserved_17_15_MASK                           0x38000
#define D18F2x11C_PrefConfSat_OFFSET                            18
#define D18F2x11C_PrefConfSat_WIDTH                             2
#define D18F2x11C_PrefConfSat_MASK                              0xc0000
#define D18F2x11C_Reserved_21_20_OFFSET                         20
#define D18F2x11C_Reserved_21_20_WIDTH                          2
#define D18F2x11C_Reserved_21_20_MASK                           0x300000
#define D18F2x11C_PrefConf_OFFSET                               22
#define D18F2x11C_PrefConf_WIDTH                                3
#define D18F2x11C_PrefConf_MASK                                 0x1c00000
#define D18F2x11C_Reserved_28_25_OFFSET                         25
#define D18F2x11C_Reserved_28_25_WIDTH                          4
#define D18F2x11C_Reserved_28_25_MASK                           0x1e000000
#define D18F2x11C_FlushWrOnStpGnt_OFFSET                        29
#define D18F2x11C_FlushWrOnStpGnt_WIDTH                         1
#define D18F2x11C_FlushWrOnStpGnt_MASK                          0x20000000
#define D18F2x11C_FlushWr_OFFSET                                30
#define D18F2x11C_FlushWr_WIDTH                                 1
#define D18F2x11C_FlushWr_MASK                                  0x40000000
#define D18F2x11C_Reserved_31_31_OFFSET                         31
#define D18F2x11C_Reserved_31_31_WIDTH                          1
#define D18F2x11C_Reserved_31_31_MASK                           0x80000000

/// D18F2x11C
typedef union {
  struct {                                                              ///<
    UINT32                                             Reserved_1_0:2 ; ///<
    UINT32                                               DctWrLimit:5 ; ///<
    UINT32                                            Reserved_11_7:5 ; ///<
    UINT32                                               PrefCpuDis:1 ; ///<
    UINT32                                           Reserved_13_13:1 ; ///<
    UINT32                                           PrefCpuRdSzDis:1 ; ///<
    UINT32                                           Reserved_17_15:3 ; ///<
    UINT32                                              PrefConfSat:2 ; ///<
    UINT32                                           Reserved_21_20:2 ; ///<
    UINT32                                                 PrefConf:3 ; ///<
    UINT32                                           Reserved_28_25:4 ; ///<
    UINT32                                          FlushWrOnStpGnt:1 ; ///<
    UINT32                                                  FlushWr:1 ; ///<
    UINT32                                           Reserved_31_31:1 ; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} D18F2x11C_STRUCT;

// **** D18F2x140 Register Definition ****
// Address
#define D18F2x140_ADDRESS                                       0x140

// Type
#define D18F2x140_TYPE                                          TYPE_D18F2
// Field Data
#define D18F2x140_CSEnable_OFFSET                               0
#define D18F2x140_CSEnable_WIDTH                                1
#define D18F2x140_CSEnable_MASK                                 0x1
#define D18F2x140_Reserved_1_1_OFFSET                           1
#define D18F2x140_Reserved_1_1_WIDTH                            1
#define D18F2x140_Reserved_1_1_MASK                             0x2
#define D18F2x140_TestFail_OFFSET                               2
#define D18F2x140_TestFail_WIDTH                                1
#define D18F2x140_TestFail_MASK                                 0x4
#define D18F2x140_OnDimmMirror_OFFSET                           3
#define D18F2x140_OnDimmMirror_WIDTH                            1
#define D18F2x140_OnDimmMirror_MASK                             0x8
#define D18F2x140_Reserved_4_4_OFFSET                           4
#define D18F2x140_Reserved_4_4_WIDTH                            1
#define D18F2x140_Reserved_4_4_MASK                             0x10
#define D18F2x140_BaseAddr_21_13__OFFSET                        5
#define D18F2x140_BaseAddr_21_13__WIDTH                         9
#define D18F2x140_BaseAddr_21_13__MASK                          0x3fe0
#define D18F2x140_Reserved_18_14_OFFSET                         14
#define D18F2x140_Reserved_18_14_WIDTH                          5
#define D18F2x140_Reserved_18_14_MASK                           0x7c000
#define D18F2x140_BaseAddr_36_27__OFFSET                        19
#define D18F2x140_BaseAddr_36_27__WIDTH                         10
#define D18F2x140_BaseAddr_36_27__MASK                          0x1ff80000
#define D18F2x140_Reserved_31_29_OFFSET                         29
#define D18F2x140_Reserved_31_29_WIDTH                          3
#define D18F2x140_Reserved_31_29_MASK                           0xe0000000

/// D18F2x140
typedef union {
  struct {                                                              ///<
    UINT32                                                 CSEnable:1 ; ///<
    UINT32                                             Reserved_1_1:1 ; ///<
    UINT32                                                 TestFail:1 ; ///<
    UINT32                                             OnDimmMirror:1 ; ///<
    UINT32                                             Reserved_4_4:1 ; ///<
    UINT32                                          BaseAddr_21_13_:9 ; ///<
    UINT32                                           Reserved_18_14:5 ; ///<
    UINT32                                          BaseAddr_36_27_:10; ///<
    UINT32                                           Reserved_31_29:3 ; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} D18F2x140_STRUCT;

// **** D18F2x144 Register Definition ****
// Address
#define D18F2x144_ADDRESS                                       0x144

// Type
#define D18F2x144_TYPE                                          TYPE_D18F2
// Field Data
#define D18F2x144_CSEnable_OFFSET                               0
#define D18F2x144_CSEnable_WIDTH                                1
#define D18F2x144_CSEnable_MASK                                 0x1
#define D18F2x144_Reserved_1_1_OFFSET                           1
#define D18F2x144_Reserved_1_1_WIDTH                            1
#define D18F2x144_Reserved_1_1_MASK                             0x2
#define D18F2x144_TestFail_OFFSET                               2
#define D18F2x144_TestFail_WIDTH                                1
#define D18F2x144_TestFail_MASK                                 0x4
#define D18F2x144_OnDimmMirror_OFFSET                           3
#define D18F2x144_OnDimmMirror_WIDTH                            1
#define D18F2x144_OnDimmMirror_MASK                             0x8
#define D18F2x144_Reserved_4_4_OFFSET                           4
#define D18F2x144_Reserved_4_4_WIDTH                            1
#define D18F2x144_Reserved_4_4_MASK                             0x10
#define D18F2x144_BaseAddr_21_13__OFFSET                        5
#define D18F2x144_BaseAddr_21_13__WIDTH                         9
#define D18F2x144_BaseAddr_21_13__MASK                          0x3fe0
#define D18F2x144_Reserved_18_14_OFFSET                         14
#define D18F2x144_Reserved_18_14_WIDTH                          5
#define D18F2x144_Reserved_18_14_MASK                           0x7c000
#define D18F2x144_BaseAddr_36_27__OFFSET                        19
#define D18F2x144_BaseAddr_36_27__WIDTH                         10
#define D18F2x144_BaseAddr_36_27__MASK                          0x1ff80000
#define D18F2x144_Reserved_31_29_OFFSET                         29
#define D18F2x144_Reserved_31_29_WIDTH                          3
#define D18F2x144_Reserved_31_29_MASK                           0xe0000000

/// D18F2x144
typedef union {
  struct {                                                              ///<
    UINT32                                                 CSEnable:1 ; ///<
    UINT32                                             Reserved_1_1:1 ; ///<
    UINT32                                                 TestFail:1 ; ///<
    UINT32                                             OnDimmMirror:1 ; ///<
    UINT32                                             Reserved_4_4:1 ; ///<
    UINT32                                          BaseAddr_21_13_:9 ; ///<
    UINT32                                           Reserved_18_14:5 ; ///<
    UINT32                                          BaseAddr_36_27_:10; ///<
    UINT32                                           Reserved_31_29:3 ; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} D18F2x144_STRUCT;

// **** D18F2x148 Register Definition ****
// Address
#define D18F2x148_ADDRESS                                       0x148

// Type
#define D18F2x148_TYPE                                          TYPE_D18F2
// Field Data
#define D18F2x148_CSEnable_OFFSET                               0
#define D18F2x148_CSEnable_WIDTH                                1
#define D18F2x148_CSEnable_MASK                                 0x1
#define D18F2x148_Reserved_1_1_OFFSET                           1
#define D18F2x148_Reserved_1_1_WIDTH                            1
#define D18F2x148_Reserved_1_1_MASK                             0x2
#define D18F2x148_TestFail_OFFSET                               2
#define D18F2x148_TestFail_WIDTH                                1
#define D18F2x148_TestFail_MASK                                 0x4
#define D18F2x148_OnDimmMirror_OFFSET                           3
#define D18F2x148_OnDimmMirror_WIDTH                            1
#define D18F2x148_OnDimmMirror_MASK                             0x8
#define D18F2x148_Reserved_4_4_OFFSET                           4
#define D18F2x148_Reserved_4_4_WIDTH                            1
#define D18F2x148_Reserved_4_4_MASK                             0x10
#define D18F2x148_BaseAddr_21_13__OFFSET                        5
#define D18F2x148_BaseAddr_21_13__WIDTH                         9
#define D18F2x148_BaseAddr_21_13__MASK                          0x3fe0
#define D18F2x148_Reserved_18_14_OFFSET                         14
#define D18F2x148_Reserved_18_14_WIDTH                          5
#define D18F2x148_Reserved_18_14_MASK                           0x7c000
#define D18F2x148_BaseAddr_36_27__OFFSET                        19
#define D18F2x148_BaseAddr_36_27__WIDTH                         10
#define D18F2x148_BaseAddr_36_27__MASK                          0x1ff80000
#define D18F2x148_Reserved_31_29_OFFSET                         29
#define D18F2x148_Reserved_31_29_WIDTH                          3
#define D18F2x148_Reserved_31_29_MASK                           0xe0000000

/// D18F2x148
typedef union {
  struct {                                                              ///<
    UINT32                                                 CSEnable:1 ; ///<
    UINT32                                             Reserved_1_1:1 ; ///<
    UINT32                                                 TestFail:1 ; ///<
    UINT32                                             OnDimmMirror:1 ; ///<
    UINT32                                             Reserved_4_4:1 ; ///<
    UINT32                                          BaseAddr_21_13_:9 ; ///<
    UINT32                                           Reserved_18_14:5 ; ///<
    UINT32                                          BaseAddr_36_27_:10; ///<
    UINT32                                           Reserved_31_29:3 ; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} D18F2x148_STRUCT;

// **** D18F2x14C Register Definition ****
// Address
#define D18F2x14C_ADDRESS                                       0x14c

// Type
#define D18F2x14C_TYPE                                          TYPE_D18F2
// Field Data
#define D18F2x14C_CSEnable_OFFSET                               0
#define D18F2x14C_CSEnable_WIDTH                                1
#define D18F2x14C_CSEnable_MASK                                 0x1
#define D18F2x14C_Reserved_1_1_OFFSET                           1
#define D18F2x14C_Reserved_1_1_WIDTH                            1
#define D18F2x14C_Reserved_1_1_MASK                             0x2
#define D18F2x14C_TestFail_OFFSET                               2
#define D18F2x14C_TestFail_WIDTH                                1
#define D18F2x14C_TestFail_MASK                                 0x4
#define D18F2x14C_OnDimmMirror_OFFSET                           3
#define D18F2x14C_OnDimmMirror_WIDTH                            1
#define D18F2x14C_OnDimmMirror_MASK                             0x8
#define D18F2x14C_Reserved_4_4_OFFSET                           4
#define D18F2x14C_Reserved_4_4_WIDTH                            1
#define D18F2x14C_Reserved_4_4_MASK                             0x10
#define D18F2x14C_BaseAddr_21_13__OFFSET                        5
#define D18F2x14C_BaseAddr_21_13__WIDTH                         9
#define D18F2x14C_BaseAddr_21_13__MASK                          0x3fe0
#define D18F2x14C_Reserved_18_14_OFFSET                         14
#define D18F2x14C_Reserved_18_14_WIDTH                          5
#define D18F2x14C_Reserved_18_14_MASK                           0x7c000
#define D18F2x14C_BaseAddr_36_27__OFFSET                        19
#define D18F2x14C_BaseAddr_36_27__WIDTH                         10
#define D18F2x14C_BaseAddr_36_27__MASK                          0x1ff80000
#define D18F2x14C_Reserved_31_29_OFFSET                         29
#define D18F2x14C_Reserved_31_29_WIDTH                          3
#define D18F2x14C_Reserved_31_29_MASK                           0xe0000000

/// D18F2x14C
typedef union {
  struct {                                                              ///<
    UINT32                                                 CSEnable:1 ; ///<
    UINT32                                             Reserved_1_1:1 ; ///<
    UINT32                                                 TestFail:1 ; ///<
    UINT32                                             OnDimmMirror:1 ; ///<
    UINT32                                             Reserved_4_4:1 ; ///<
    UINT32                                          BaseAddr_21_13_:9 ; ///<
    UINT32                                           Reserved_18_14:5 ; ///<
    UINT32                                          BaseAddr_36_27_:10; ///<
    UINT32                                           Reserved_31_29:3 ; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} D18F2x14C_STRUCT;

// **** D18F2x160 Register Definition ****
// Address
#define D18F2x160_ADDRESS                                       0x160

// Type
#define D18F2x160_TYPE                                          TYPE_D18F2
// Field Data
#define D18F2x160_Reserved_4_0_OFFSET                           0
#define D18F2x160_Reserved_4_0_WIDTH                            5
#define D18F2x160_Reserved_4_0_MASK                             0x1f
#define D18F2x160_AddrMask_21_13__OFFSET                        5
#define D18F2x160_AddrMask_21_13__WIDTH                         9
#define D18F2x160_AddrMask_21_13__MASK                          0x3fe0
#define D18F2x160_Reserved_18_14_OFFSET                         14
#define D18F2x160_Reserved_18_14_WIDTH                          5
#define D18F2x160_Reserved_18_14_MASK                           0x7c000
#define D18F2x160_AddrMask_36_27__OFFSET                        19
#define D18F2x160_AddrMask_36_27__WIDTH                         10
#define D18F2x160_AddrMask_36_27__MASK                          0x1ff80000
#define D18F2x160_Reserved_31_29_OFFSET                         29
#define D18F2x160_Reserved_31_29_WIDTH                          3
#define D18F2x160_Reserved_31_29_MASK                           0xe0000000

/// D18F2x160
typedef union {
  struct {                                                              ///<
    UINT32                                             Reserved_4_0:5 ; ///<
    UINT32                                          AddrMask_21_13_:9 ; ///<
    UINT32                                           Reserved_18_14:5 ; ///<
    UINT32                                          AddrMask_36_27_:10; ///<
    UINT32                                           Reserved_31_29:3 ; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} D18F2x160_STRUCT;

// **** D18F2x164 Register Definition ****
// Address
#define D18F2x164_ADDRESS                                       0x164

// Type
#define D18F2x164_TYPE                                          TYPE_D18F2
// Field Data
#define D18F2x164_Reserved_4_0_OFFSET                           0
#define D18F2x164_Reserved_4_0_WIDTH                            5
#define D18F2x164_Reserved_4_0_MASK                             0x1f
#define D18F2x164_AddrMask_21_13__OFFSET                        5
#define D18F2x164_AddrMask_21_13__WIDTH                         9
#define D18F2x164_AddrMask_21_13__MASK                          0x3fe0
#define D18F2x164_Reserved_18_14_OFFSET                         14
#define D18F2x164_Reserved_18_14_WIDTH                          5
#define D18F2x164_Reserved_18_14_MASK                           0x7c000
#define D18F2x164_AddrMask_36_27__OFFSET                        19
#define D18F2x164_AddrMask_36_27__WIDTH                         10
#define D18F2x164_AddrMask_36_27__MASK                          0x1ff80000
#define D18F2x164_Reserved_31_29_OFFSET                         29
#define D18F2x164_Reserved_31_29_WIDTH                          3
#define D18F2x164_Reserved_31_29_MASK                           0xe0000000

/// D18F2x164
typedef union {
  struct {                                                              ///<
    UINT32                                             Reserved_4_0:5 ; ///<
    UINT32                                          AddrMask_21_13_:9 ; ///<
    UINT32                                           Reserved_18_14:5 ; ///<
    UINT32                                          AddrMask_36_27_:10; ///<
    UINT32                                           Reserved_31_29:3 ; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} D18F2x164_STRUCT;

// **** D18F2x178 Register Definition ****
// Address
#define D18F2x178_ADDRESS                                       0x178

// Type
#define D18F2x178_TYPE                                          TYPE_D18F2
// Field Data
#define D18F2x178_RdPtrInit_OFFSET                              0
#define D18F2x178_RdPtrInit_WIDTH                               4
#define D18F2x178_RdPtrInit_MASK                                0xf
#define D18F2x178_Reserved_5_4_OFFSET                           4
#define D18F2x178_Reserved_5_4_WIDTH                            2
#define D18F2x178_Reserved_5_4_MASK                             0x30
#define D18F2x178_RxPtrInitReq_OFFSET                           6
#define D18F2x178_RxPtrInitReq_WIDTH                            1
#define D18F2x178_RxPtrInitReq_MASK                             0x40
#define D18F2x178_Reserved_7_7_OFFSET                           7
#define D18F2x178_Reserved_7_7_WIDTH                            1
#define D18F2x178_Reserved_7_7_MASK                             0x80
#define D18F2x178_Twrrd_3_2__OFFSET                             8
#define D18F2x178_Twrrd_3_2__WIDTH                              2
#define D18F2x178_Twrrd_3_2__MASK                               0x300
#define D18F2x178_Twrwr_3_2__OFFSET                             10
#define D18F2x178_Twrwr_3_2__WIDTH                              2
#define D18F2x178_Twrwr_3_2__MASK                               0xc00
#define D18F2x178_Trdrd_3_2__OFFSET                             12
#define D18F2x178_Trdrd_3_2__WIDTH                              2
#define D18F2x178_Trdrd_3_2__MASK                               0x3000
#define D18F2x178_Reserved_14_14_OFFSET                         14
#define D18F2x178_Reserved_14_14_WIDTH                          1
#define D18F2x178_Reserved_14_14_MASK                           0x4000
#define D18F2x178_Reserved_15_15_OFFSET                         15
#define D18F2x178_Reserved_15_15_WIDTH                          1
#define D18F2x178_Reserved_15_15_MASK                           0x8000
#define D18F2x178_Reserved_16_16_OFFSET                         16
#define D18F2x178_Reserved_16_16_WIDTH                          1
#define D18F2x178_Reserved_16_16_MASK                           0x10000
#define D18F2x178_AddrCmdTriEn_OFFSET                           17
#define D18F2x178_AddrCmdTriEn_WIDTH                            1
#define D18F2x178_AddrCmdTriEn_MASK                             0x20000
#define D18F2x178_Reserved_18_18_OFFSET                         18
#define D18F2x178_Reserved_18_18_WIDTH                          1
#define D18F2x178_Reserved_18_18_MASK                           0x40000
#define D18F2x178_Reserved_19_19_OFFSET                         19
#define D18F2x178_Reserved_19_19_WIDTH                          1
#define D18F2x178_Reserved_19_19_MASK                           0x80000
#define D18F2x178_ForceCasToSlot_OFFSET                         20
#define D18F2x178_ForceCasToSlot_WIDTH                          1
#define D18F2x178_ForceCasToSlot_MASK                           0x100000
#define D18F2x178_DisCutThroughMode_OFFSET                      21
#define D18F2x178_DisCutThroughMode_WIDTH                       1
#define D18F2x178_DisCutThroughMode_MASK                        0x200000
#define D18F2x178_MaxRdLatency_OFFSET                           22
#define D18F2x178_MaxRdLatency_WIDTH                            10
#define D18F2x178_MaxRdLatency_MASK                             0xffc00000

/// D18F2x178
typedef union {
  struct {                                                              ///<
    UINT32                                                RdPtrInit:4 ; ///<
    UINT32                                             Reserved_5_4:2 ; ///<
    UINT32                                             RxPtrInitReq:1 ; ///<
    UINT32                                             Reserved_7_7:1 ; ///<
    UINT32                                               Twrrd_3_2_:2 ; ///<
    UINT32                                               Twrwr_3_2_:2 ; ///<
    UINT32                                               Trdrd_3_2_:2 ; ///<
    UINT32                                           Reserved_14_14:1 ; ///<
    UINT32                                           Reserved_15_15:1 ; ///<
    UINT32                                           Reserved_16_16:1 ; ///<
    UINT32                                             AddrCmdTriEn:1 ; ///<
    UINT32                                           Reserved_18_18:1 ; ///<
    UINT32                                           Reserved_19_19:1 ; ///<
    UINT32                                           ForceCasToSlot:1 ; ///<
    UINT32                                        DisCutThroughMode:1 ; ///<
    UINT32                                             MaxRdLatency:10; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} D18F2x178_STRUCT;

// **** D18F2x17C Register Definition ****
// Address
#define D18F2x17C_ADDRESS                                       0x17c

// Type
#define D18F2x17C_TYPE                                          TYPE_D18F2
// Field Data
#define D18F2x17C_MrsAddress_OFFSET                             0
#define D18F2x17C_MrsAddress_WIDTH                              16
#define D18F2x17C_MrsAddress_MASK                               0xffff
#define D18F2x17C_MrsBank_OFFSET                                16
#define D18F2x17C_MrsBank_WIDTH                                 3
#define D18F2x17C_MrsBank_MASK                                  0x70000
#define D18F2x17C_Reserved_19_19_OFFSET                         19
#define D18F2x17C_Reserved_19_19_WIDTH                          1
#define D18F2x17C_Reserved_19_19_MASK                           0x80000
#define D18F2x17C_MrsChipSel_OFFSET                             20
#define D18F2x17C_MrsChipSel_WIDTH                              3
#define D18F2x17C_MrsChipSel_MASK                               0x700000
#define D18F2x17C_Reserved_23_23_OFFSET                         23
#define D18F2x17C_Reserved_23_23_WIDTH                          1
#define D18F2x17C_Reserved_23_23_MASK                           0x800000
#define D18F2x17C_SendPchgAll_OFFSET                            24
#define D18F2x17C_SendPchgAll_WIDTH                             1
#define D18F2x17C_SendPchgAll_MASK                              0x1000000
#define D18F2x17C_SendAutoRefresh_OFFSET                        25
#define D18F2x17C_SendAutoRefresh_WIDTH                         1
#define D18F2x17C_SendAutoRefresh_MASK                          0x2000000
#define D18F2x17C_SendMrsCmd_OFFSET                             26
#define D18F2x17C_SendMrsCmd_WIDTH                              1
#define D18F2x17C_SendMrsCmd_MASK                               0x4000000
#define D18F2x17C_DeassertMemRstX_OFFSET                        27
#define D18F2x17C_DeassertMemRstX_WIDTH                         1
#define D18F2x17C_DeassertMemRstX_MASK                          0x8000000
#define D18F2x17C_AssertCke_OFFSET                              28
#define D18F2x17C_AssertCke_WIDTH                               1
#define D18F2x17C_AssertCke_MASK                                0x10000000
#define D18F2x17C_SendZQCmd_OFFSET                              29
#define D18F2x17C_SendZQCmd_WIDTH                               1
#define D18F2x17C_SendZQCmd_MASK                                0x20000000
#define D18F2x17C_Reserved_30_30_OFFSET                         30
#define D18F2x17C_Reserved_30_30_WIDTH                          1
#define D18F2x17C_Reserved_30_30_MASK                           0x40000000
#define D18F2x17C_EnDramInit_OFFSET                             31
#define D18F2x17C_EnDramInit_WIDTH                              1
#define D18F2x17C_EnDramInit_MASK                               0x80000000

/// D18F2x17C
typedef union {
  struct {                                                              ///<
    UINT32                                               MrsAddress:16; ///<
    UINT32                                                  MrsBank:3 ; ///<
    UINT32                                           Reserved_19_19:1 ; ///<
    UINT32                                               MrsChipSel:3 ; ///<
    UINT32                                           Reserved_23_23:1 ; ///<
    UINT32                                              SendPchgAll:1 ; ///<
    UINT32                                          SendAutoRefresh:1 ; ///<
    UINT32                                               SendMrsCmd:1 ; ///<
    UINT32                                          DeassertMemRstX:1 ; ///<
    UINT32                                                AssertCke:1 ; ///<
    UINT32                                                SendZQCmd:1 ; ///<
    UINT32                                           Reserved_30_30:1 ; ///<
    UINT32                                               EnDramInit:1 ; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} D18F2x17C_STRUCT;

// **** D18F2x180 Register Definition ****
// Address
#define D18F2x180_ADDRESS                                       0x180

// Type
#define D18F2x180_TYPE                                          TYPE_D18F2
// Field Data
#define D18F2x180_Dimm0AddrMap_OFFSET                           0
#define D18F2x180_Dimm0AddrMap_WIDTH                            4
#define D18F2x180_Dimm0AddrMap_MASK                             0xf
#define D18F2x180_Dimm1AddrMap_OFFSET                           4
#define D18F2x180_Dimm1AddrMap_WIDTH                            4
#define D18F2x180_Dimm1AddrMap_MASK                             0xf0
#define D18F2x180_Reserved_31_8_OFFSET                          8
#define D18F2x180_Reserved_31_8_WIDTH                           24
#define D18F2x180_Reserved_31_8_MASK                            0xffffff00

/// D18F2x180
typedef union {
  struct {                                                              ///<
    UINT32                                             Dimm0AddrMap:4 ; ///<
    UINT32                                             Dimm1AddrMap:4 ; ///<
    UINT32                                            Reserved_31_8:24; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} D18F2x180_STRUCT;

// **** D18F2x184 Register Definition ****
// Address
#define D18F2x184_ADDRESS                                       0x184

// Type
#define D18F2x184_TYPE                                          TYPE_D18F2
// Field Data
#define D18F2x184_BurstCtrl_OFFSET                              0
#define D18F2x184_BurstCtrl_WIDTH                               2
#define D18F2x184_BurstCtrl_MASK                                0x3
#define D18F2x184_Reserved_3_2_OFFSET                           2
#define D18F2x184_Reserved_3_2_WIDTH                            2
#define D18F2x184_Reserved_3_2_MASK                             0xc
#define D18F2x184_Twr_OFFSET                                    4
#define D18F2x184_Twr_WIDTH                                     3
#define D18F2x184_Twr_MASK                                      0x70
#define D18F2x184_Reserved_19_7_OFFSET                          7
#define D18F2x184_Reserved_19_7_WIDTH                           13
#define D18F2x184_Reserved_19_7_MASK                            0xfff80
#define D18F2x184_Tcwl_OFFSET                                   20
#define D18F2x184_Tcwl_WIDTH                                    3
#define D18F2x184_Tcwl_MASK                                     0x700000
#define D18F2x184_PchgPDModeSel_OFFSET                          23
#define D18F2x184_PchgPDModeSel_WIDTH                           1
#define D18F2x184_PchgPDModeSel_MASK                            0x800000
#define D18F2x184_Reserved_31_24_OFFSET                         24
#define D18F2x184_Reserved_31_24_WIDTH                          8
#define D18F2x184_Reserved_31_24_MASK                           0xff000000

/// D18F2x184
typedef union {
  struct {                                                              ///<
    UINT32                                                BurstCtrl:2 ; ///<
    UINT32                                             Reserved_3_2:2 ; ///<
    UINT32                                                      Twr:3 ; ///<
    UINT32                                            Reserved_19_7:13; ///<
    UINT32                                                     Tcwl:3 ; ///<
    UINT32                                            PchgPDModeSel:1 ; ///<
    UINT32                                           Reserved_31_24:8 ; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} D18F2x184_STRUCT;

// **** D18F2x188 Register Definition ****
// Address
#define D18F2x188_ADDRESS                                       0x188

// Type
#define D18F2x188_TYPE                                          TYPE_D18F2
// Field Data
#define D18F2x188_Tcl_OFFSET                                    0
#define D18F2x188_Tcl_WIDTH                                     4
#define D18F2x188_Tcl_MASK                                      0xf
#define D18F2x188_Reserved_23_4_OFFSET                          4
#define D18F2x188_Reserved_23_4_WIDTH                           20
#define D18F2x188_Reserved_23_4_MASK                            0xfffff0
#define D18F2x188_MemClkDis_OFFSET                              24
#define D18F2x188_MemClkDis_WIDTH                               8
#define D18F2x188_MemClkDis_MASK                                0xff000000

/// D18F2x188
typedef union {
  struct {                                                              ///<
    UINT32                                                      Tcl:4 ; ///<
    UINT32                                            Reserved_23_4:20; ///<
    UINT32                                                MemClkDis:8 ; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} D18F2x188_STRUCT;

// **** D18F2x18C Register Definition ****
// Address
#define D18F2x18C_ADDRESS                                       0x18c

// Type
#define D18F2x18C_TYPE                                          TYPE_D18F2
// Field Data
#define D18F2x18C_TrwtWB_OFFSET                                 0
#define D18F2x18C_TrwtWB_WIDTH                                  4
#define D18F2x18C_TrwtWB_MASK                                   0xf
#define D18F2x18C_TrwtTO_OFFSET                                 4
#define D18F2x18C_TrwtTO_WIDTH                                  4
#define D18F2x18C_TrwtTO_MASK                                   0xf0
#define D18F2x18C_Reserved_9_8_OFFSET                           8
#define D18F2x18C_Reserved_9_8_WIDTH                            2
#define D18F2x18C_Reserved_9_8_MASK                             0x300
#define D18F2x18C_Twrrd_1_0__OFFSET                             10
#define D18F2x18C_Twrrd_1_0__WIDTH                              2
#define D18F2x18C_Twrrd_1_0__MASK                               0xc00
#define D18F2x18C_Twrwr_1_0__OFFSET                             12
#define D18F2x18C_Twrwr_1_0__WIDTH                              2
#define D18F2x18C_Twrwr_1_0__MASK                               0x3000
#define D18F2x18C_Trdrd_1_0__OFFSET                             14
#define D18F2x18C_Trdrd_1_0__WIDTH                              2
#define D18F2x18C_Trdrd_1_0__MASK                               0xc000
#define D18F2x18C_Tref_OFFSET                                   16
#define D18F2x18C_Tref_WIDTH                                    2
#define D18F2x18C_Tref_MASK                                     0x30000
#define D18F2x18C_DisAutoRefresh_OFFSET                         18
#define D18F2x18C_DisAutoRefresh_WIDTH                          1
#define D18F2x18C_DisAutoRefresh_MASK                           0x40000
#define D18F2x18C_Reserved_19_19_OFFSET                         19
#define D18F2x18C_Reserved_19_19_WIDTH                          1
#define D18F2x18C_Reserved_19_19_MASK                           0x80000
#define D18F2x18C_Trfc0_OFFSET                                  20
#define D18F2x18C_Trfc0_WIDTH                                   3
#define D18F2x18C_Trfc0_MASK                                    0x700000
#define D18F2x18C_Trfc1_OFFSET                                  23
#define D18F2x18C_Trfc1_WIDTH                                   3
#define D18F2x18C_Trfc1_MASK                                    0x3800000
#define D18F2x18C_Reserved_31_26_OFFSET                         26
#define D18F2x18C_Reserved_31_26_WIDTH                          6
#define D18F2x18C_Reserved_31_26_MASK                           0xfc000000

/// D18F2x18C
typedef union {
  struct {                                                              ///<
    UINT32                                                   TrwtWB:4 ; ///<
    UINT32                                                   TrwtTO:4 ; ///<
    UINT32                                             Reserved_9_8:2 ; ///<
    UINT32                                               Twrrd_1_0_:2 ; ///<
    UINT32                                               Twrwr_1_0_:2 ; ///<
    UINT32                                               Trdrd_1_0_:2 ; ///<
    UINT32                                                     Tref:2 ; ///<
    UINT32                                           DisAutoRefresh:1 ; ///<
    UINT32                                           Reserved_19_19:1 ; ///<
    UINT32                                                    Trfc0:3 ; ///<
    UINT32                                                    Trfc1:3 ; ///<
    UINT32                                           Reserved_31_26:6 ; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} D18F2x18C_STRUCT;

// **** D18F2x190 Register Definition ****
// Address
#define D18F2x190_ADDRESS                                       0x190

// Type
#define D18F2x190_TYPE                                          TYPE_D18F2
// Field Data
#define D18F2x190_Reserved_0_0_OFFSET                           0
#define D18F2x190_Reserved_0_0_WIDTH                            1
#define D18F2x190_Reserved_0_0_MASK                             0x1
#define D18F2x190_ExitSelfRef_OFFSET                            1
#define D18F2x190_ExitSelfRef_WIDTH                             1
#define D18F2x190_ExitSelfRef_MASK                              0x2
#define D18F2x190_Reserved_16_2_OFFSET                          2
#define D18F2x190_Reserved_16_2_WIDTH                           15
#define D18F2x190_Reserved_16_2_MASK                            0x1fffc
#define D18F2x190_EnterSelfRef_OFFSET                           17
#define D18F2x190_EnterSelfRef_WIDTH                            1
#define D18F2x190_EnterSelfRef_MASK                             0x20000
#define D18F2x190_Reserved_19_18_OFFSET                         18
#define D18F2x190_Reserved_19_18_WIDTH                          2
#define D18F2x190_Reserved_19_18_MASK                           0xc0000
#define D18F2x190_DynPageCloseEn_OFFSET                         20
#define D18F2x190_DynPageCloseEn_WIDTH                          1
#define D18F2x190_DynPageCloseEn_MASK                           0x100000
#define D18F2x190_IdleCycInit_OFFSET                            21
#define D18F2x190_IdleCycInit_WIDTH                             2
#define D18F2x190_IdleCycInit_MASK                              0x600000
#define D18F2x190_ForceAutoPchg_OFFSET                          23
#define D18F2x190_ForceAutoPchg_WIDTH                           1
#define D18F2x190_ForceAutoPchg_MASK                            0x800000
#define D18F2x190_Reserved_24_24_OFFSET                         24
#define D18F2x190_Reserved_24_24_WIDTH                          1
#define D18F2x190_Reserved_24_24_MASK                           0x1000000
#define D18F2x190_EnDispAutoPrecharge_OFFSET                    25
#define D18F2x190_EnDispAutoPrecharge_WIDTH                     1
#define D18F2x190_EnDispAutoPrecharge_MASK                      0x2000000
#define D18F2x190_DbeSkidBufDis_OFFSET                          26
#define D18F2x190_DbeSkidBufDis_WIDTH                           1
#define D18F2x190_DbeSkidBufDis_MASK                            0x4000000
#define D18F2x190_DisDllShutdownSR_OFFSET                       27
#define D18F2x190_DisDllShutdownSR_WIDTH                        1
#define D18F2x190_DisDllShutdownSR_MASK                         0x8000000
#define D18F2x190_Reserved_28_28_OFFSET                         28
#define D18F2x190_Reserved_28_28_WIDTH                          1
#define D18F2x190_Reserved_28_28_MASK                           0x10000000
#define D18F2x190_Reserved_29_29_OFFSET                         29
#define D18F2x190_Reserved_29_29_WIDTH                          1
#define D18F2x190_Reserved_29_29_MASK                           0x20000000
#define D18F2x190_Reserved_31_30_OFFSET                         30
#define D18F2x190_Reserved_31_30_WIDTH                          2
#define D18F2x190_Reserved_31_30_MASK                           0xc0000000

/// D18F2x190
typedef union {
  struct {                                                              ///<
    UINT32                                             Reserved_0_0:1 ; ///<
    UINT32                                              ExitSelfRef:1 ; ///<
    UINT32                                            Reserved_16_2:15; ///<
    UINT32                                             EnterSelfRef:1 ; ///<
    UINT32                                           Reserved_19_18:2 ; ///<
    UINT32                                           DynPageCloseEn:1 ; ///<
    UINT32                                              IdleCycInit:2 ; ///<
    UINT32                                            ForceAutoPchg:1 ; ///<
    UINT32                                           Reserved_24_24:1 ; ///<
    UINT32                                      EnDispAutoPrecharge:1 ; ///<
    UINT32                                            DbeSkidBufDis:1 ; ///<
    UINT32                                         DisDllShutdownSR:1 ; ///<
    UINT32                                           Reserved_28_28:1 ; ///<
    UINT32                                           Reserved_29_29:1 ; ///<
    UINT32                                           Reserved_31_30:2 ; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} D18F2x190_STRUCT;

// **** D18F2x194 Register Definition ****
// Address
#define D18F2x194_ADDRESS                                       0x194

// Type
#define D18F2x194_TYPE                                          TYPE_D18F2
// Field Data
#define D18F2x194_MemClkFreq_OFFSET                             0
#define D18F2x194_MemClkFreq_WIDTH                              5
#define D18F2x194_MemClkFreq_MASK                               0x1f
#define D18F2x194_Reserved_6_5_OFFSET                           5
#define D18F2x194_Reserved_6_5_WIDTH                            2
#define D18F2x194_Reserved_6_5_MASK                             0x60
#define D18F2x194_MemClkFreqVal_OFFSET                          7
#define D18F2x194_MemClkFreqVal_WIDTH                           1
#define D18F2x194_MemClkFreqVal_MASK                            0x80
#define D18F2x194_Reserved_9_8_OFFSET                           8
#define D18F2x194_Reserved_9_8_WIDTH                            2
#define D18F2x194_Reserved_9_8_MASK                             0x300
#define D18F2x194_ZqcsInterval_OFFSET                           10
#define D18F2x194_ZqcsInterval_WIDTH                            2
#define D18F2x194_ZqcsInterval_MASK                             0xc00
#define D18F2x194_Reserved_13_12_OFFSET                         12
#define D18F2x194_Reserved_13_12_WIDTH                          2
#define D18F2x194_Reserved_13_12_MASK                           0x3000
#define D18F2x194_DisDramInterface_OFFSET                       14
#define D18F2x194_DisDramInterface_WIDTH                        1
#define D18F2x194_DisDramInterface_MASK                         0x4000
#define D18F2x194_PowerDownEn_OFFSET                            15
#define D18F2x194_PowerDownEn_WIDTH                             1
#define D18F2x194_PowerDownEn_MASK                              0x8000
#define D18F2x194_PowerDownMode_OFFSET                          16
#define D18F2x194_PowerDownMode_WIDTH                           1
#define D18F2x194_PowerDownMode_MASK                            0x10000
#define D18F2x194_Reserved_19_17_OFFSET                         17
#define D18F2x194_Reserved_19_17_WIDTH                          3
#define D18F2x194_Reserved_19_17_MASK                           0xe0000
#define D18F2x194_SlowAccessMode_OFFSET                         20
#define D18F2x194_SlowAccessMode_WIDTH                          1
#define D18F2x194_SlowAccessMode_MASK                           0x100000
#define D18F2x194_Reserved_21_21_OFFSET                         21
#define D18F2x194_Reserved_21_21_WIDTH                          1
#define D18F2x194_Reserved_21_21_MASK                           0x200000
#define D18F2x194_BankSwizzleMode_OFFSET                        22
#define D18F2x194_BankSwizzleMode_WIDTH                         1
#define D18F2x194_BankSwizzleMode_MASK                          0x400000
#define D18F2x194_ProcOdtDis_OFFSET                             23
#define D18F2x194_ProcOdtDis_WIDTH                              1
#define D18F2x194_ProcOdtDis_MASK                               0x800000
#define D18F2x194_DcqBypassMax_OFFSET                           24
#define D18F2x194_DcqBypassMax_WIDTH                            4
#define D18F2x194_DcqBypassMax_MASK                             0xf000000
#define D18F2x194_FourActWindow_OFFSET                          28
#define D18F2x194_FourActWindow_WIDTH                           4
#define D18F2x194_FourActWindow_MASK                            0xf0000000

/// D18F2x194
typedef union {
  struct {                                                              ///<
    UINT32                                               MemClkFreq:5 ; ///<
    UINT32                                             Reserved_6_5:2 ; ///<
    UINT32                                            MemClkFreqVal:1 ; ///<
    UINT32                                             Reserved_9_8:2 ; ///<
    UINT32                                             ZqcsInterval:2 ; ///<
    UINT32                                           Reserved_13_12:2 ; ///<
    UINT32                                         DisDramInterface:1 ; ///<
    UINT32                                              PowerDownEn:1 ; ///<
    UINT32                                            PowerDownMode:1 ; ///<
    UINT32                                           Reserved_19_17:3 ; ///<
    UINT32                                           SlowAccessMode:1 ; ///<
    UINT32                                           Reserved_21_21:1 ; ///<
    UINT32                                          BankSwizzleMode:1 ; ///<
    UINT32                                               ProcOdtDis:1 ; ///<
    UINT32                                             DcqBypassMax:4 ; ///<
    UINT32                                            FourActWindow:4 ; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} D18F2x194_STRUCT;

// **** D18F2x198 Register Definition ****
// Address
#define D18F2x198_ADDRESS                                       0x198

// Type
#define D18F2x198_TYPE                                          TYPE_D18F2
// Field Data
#define D18F2x198_DctOffset_OFFSET                              0
#define D18F2x198_DctOffset_WIDTH                               30
#define D18F2x198_DctOffset_MASK                                0x3fffffff
#define D18F2x198_DctAccessWrite_OFFSET                         30
#define D18F2x198_DctAccessWrite_WIDTH                          1
#define D18F2x198_DctAccessWrite_MASK                           0x40000000
#define D18F2x198_Reserved_31_31_OFFSET                         31
#define D18F2x198_Reserved_31_31_WIDTH                          1
#define D18F2x198_Reserved_31_31_MASK                           0x80000000

/// D18F2x198
typedef union {
  struct {                                                              ///<
    UINT32                                                DctOffset:30; ///<
    UINT32                                           DctAccessWrite:1 ; ///<
    UINT32                                           Reserved_31_31:1 ; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} D18F2x198_STRUCT;

// **** D18F2x19C Register Definition ****
// Address
#define D18F2x19C_ADDRESS                                       0x19c

// Type
#define D18F2x19C_TYPE                                          TYPE_D18F2
// Field Data
#define D18F2x19C_DctDataPort_OFFSET                            0
#define D18F2x19C_DctDataPort_WIDTH                             32
#define D18F2x19C_DctDataPort_MASK                              0xffffffff

/// D18F2x19C
typedef union {
  struct {                                                              ///<
    UINT32                                              DctDataPort:32; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} D18F2x19C_STRUCT;

// **** D18F2x1A0 Register Definition ****
// Address
#define D18F2x1A0_ADDRESS                                       0x1a0

// Type
#define D18F2x1A0_TYPE                                          TYPE_D18F2
// Field Data
#define D18F2x1A0_Reserved_31_0_OFFSET                          0
#define D18F2x1A0_Reserved_31_0_WIDTH                           32
#define D18F2x1A0_Reserved_31_0_MASK                            0xffffffff

/// D18F2x1A0
typedef union {
  struct {                                                              ///<
    UINT32                                            Reserved_31_0:32; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} D18F2x1A0_STRUCT;

// **** D18F2x1A8 Register Definition ****
// Address
#define D18F2x1A8_ADDRESS                                       0x1a8

// Type
#define D18F2x1A8_TYPE                                          TYPE_D18F2
// Field Data
#define D18F2x1A8_Reserved_19_0_OFFSET                          0
#define D18F2x1A8_Reserved_19_0_WIDTH                           20
#define D18F2x1A8_Reserved_19_0_MASK                            0xfffff
#define D18F2x1A8_BankSwap_OFFSET                               20
#define D18F2x1A8_BankSwap_WIDTH                                1
#define D18F2x1A8_BankSwap_MASK                                 0x100000
#define D18F2x1A8_DbeGskMemClkAlignMode_OFFSET                  21
#define D18F2x1A8_DbeGskMemClkAlignMode_WIDTH                   2
#define D18F2x1A8_DbeGskMemClkAlignMode_MASK                    0x600000
#define D18F2x1A8_Reserved_31_23_OFFSET                         23
#define D18F2x1A8_Reserved_31_23_WIDTH                          9
#define D18F2x1A8_Reserved_31_23_MASK                           0xff800000

/// D18F2x1A8
typedef union {
  struct {                                                              ///<
    UINT32                                            Reserved_19_0:20; ///<
    UINT32                                                 BankSwap:1 ; ///<
    UINT32                                    DbeGskMemClkAlignMode:2 ; ///<
    UINT32                                           Reserved_31_23:9 ; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} D18F2x1A8_STRUCT;

// **** D18F2x1C0 Register Definition ****
// Address
#define D18F2x1C0_ADDRESS                                       0x1c0

// Type
#define D18F2x1C0_TYPE                                          TYPE_D18F2
// Field Data
#define D18F2x1C0_WrDramTrainMode_OFFSET                        0
#define D18F2x1C0_WrDramTrainMode_WIDTH                         1
#define D18F2x1C0_WrDramTrainMode_MASK                          0x1
#define D18F2x1C0_WrTrainGo_OFFSET                              1
#define D18F2x1C0_WrTrainGo_WIDTH                               1
#define D18F2x1C0_WrTrainGo_MASK                                0x2
#define D18F2x1C0_TrainLength_OFFSET                            2
#define D18F2x1C0_TrainLength_WIDTH                             16
#define D18F2x1C0_TrainLength_MASK                              0x3fffc
#define D18F2x1C0_Reserved_19_18_OFFSET                         18
#define D18F2x1C0_Reserved_19_18_WIDTH                          2
#define D18F2x1C0_Reserved_19_18_MASK                           0xc0000
#define D18F2x1C0_DramTrainPdbDis_OFFSET                        20
#define D18F2x1C0_DramTrainPdbDis_WIDTH                         1
#define D18F2x1C0_DramTrainPdbDis_MASK                          0x100000
#define D18F2x1C0_AltAddrEn_OFFSET                              21
#define D18F2x1C0_AltAddrEn_WIDTH                               1
#define D18F2x1C0_AltAddrEn_MASK                                0x200000
#define D18F2x1C0_RdDramTrainMode_OFFSET                        22
#define D18F2x1C0_RdDramTrainMode_WIDTH                         1
#define D18F2x1C0_RdDramTrainMode_MASK                          0x400000
#define D18F2x1C0_RdTrainGo_OFFSET                              23
#define D18F2x1C0_RdTrainGo_WIDTH                               1
#define D18F2x1C0_RdTrainGo_MASK                                0x800000
#define D18F2x1C0_Reserved_31_24_OFFSET                         24
#define D18F2x1C0_Reserved_31_24_WIDTH                          8
#define D18F2x1C0_Reserved_31_24_MASK                           0xff000000

/// D18F2x1C0
typedef union {
  struct {                                                              ///<
    UINT32                                          WrDramTrainMode:1 ; ///<
    UINT32                                                WrTrainGo:1 ; ///<
    UINT32                                              TrainLength:16; ///<
    UINT32                                           Reserved_19_18:2 ; ///<
    UINT32                                          DramTrainPdbDis:1 ; ///<
    UINT32                                                AltAddrEn:1 ; ///<
    UINT32                                          RdDramTrainMode:1 ; ///<
    UINT32                                                RdTrainGo:1 ; ///<
    UINT32                                           Reserved_31_24:8 ; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} D18F2x1C0_STRUCT;

// **** D18F2x1C8 Register Definition ****
// Address
#define D18F2x1C8_ADDRESS                                       0x1c8

// Type
#define D18F2x1C8_TYPE                                          TYPE_D18F2
// Field Data
#define D18F2x1C8_TrainAddrPtr_37_6__OFFSET                     0
#define D18F2x1C8_TrainAddrPtr_37_6__WIDTH                      32
#define D18F2x1C8_TrainAddrPtr_37_6__MASK                       0xffffffff

/// D18F2x1C8
typedef union {
  struct {                                                              ///<
    UINT32                                       TrainAddrPtr_37_6_:32; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} D18F2x1C8_STRUCT;

// **** D18F2x1CC Register Definition ****
// Address
#define D18F2x1CC_ADDRESS                                       0x1cc

// Type
#define D18F2x1CC_TYPE                                          TYPE_D18F2
// Field Data
#define D18F2x1CC_AltAddr1Ptr_39_38__OFFSET                     0
#define D18F2x1CC_AltAddr1Ptr_39_38__WIDTH                      2
#define D18F2x1CC_AltAddr1Ptr_39_38__MASK                       0x3
#define D18F2x1CC_AltAddr1PtrIt_OFFSET                          2
#define D18F2x1CC_AltAddr1PtrIt_WIDTH                           6
#define D18F2x1CC_AltAddr1PtrIt_MASK                            0xfc
#define D18F2x1CC_AltAddr2Ptr_39_38__OFFSET                     8
#define D18F2x1CC_AltAddr2Ptr_39_38__WIDTH                      2
#define D18F2x1CC_AltAddr2Ptr_39_38__MASK                       0x300
#define D18F2x1CC_AltAddr2PtrIt_OFFSET                          10
#define D18F2x1CC_AltAddr2PtrIt_WIDTH                           6
#define D18F2x1CC_AltAddr2PtrIt_MASK                            0xfc00
#define D18F2x1CC_TrainAddrPtr_39_38__OFFSET                    16
#define D18F2x1CC_TrainAddrPtr_39_38__WIDTH                     2
#define D18F2x1CC_TrainAddrPtr_39_38__MASK                      0x30000
#define D18F2x1CC_TrainAddrPtrIt_OFFSET                         18
#define D18F2x1CC_TrainAddrPtrIt_WIDTH                          6
#define D18F2x1CC_TrainAddrPtrIt_MASK                           0xfc0000
#define D18F2x1CC_AltAddr3Ptr_39_38__OFFSET                     24
#define D18F2x1CC_AltAddr3Ptr_39_38__WIDTH                      2
#define D18F2x1CC_AltAddr3Ptr_39_38__MASK                       0x3000000
#define D18F2x1CC_AltAddr3PtrIt_OFFSET                          26
#define D18F2x1CC_AltAddr3PtrIt_WIDTH                           6
#define D18F2x1CC_AltAddr3PtrIt_MASK                            0xfc000000

/// D18F2x1CC
typedef union {
  struct {                                                              ///<
    UINT32                                       AltAddr1Ptr_39_38_:2 ; ///<
    UINT32                                            AltAddr1PtrIt:6 ; ///<
    UINT32                                       AltAddr2Ptr_39_38_:2 ; ///<
    UINT32                                            AltAddr2PtrIt:6 ; ///<
    UINT32                                      TrainAddrPtr_39_38_:2 ; ///<
    UINT32                                           TrainAddrPtrIt:6 ; ///<
    UINT32                                       AltAddr3Ptr_39_38_:2 ; ///<
    UINT32                                            AltAddr3PtrIt:6 ; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} D18F2x1CC_STRUCT;

// **** D18F2x1D0 Register Definition ****
// Address
#define D18F2x1D0_ADDRESS                                       0x1d0

// Type
#define D18F2x1D0_TYPE                                          TYPE_D18F2
// Field Data
#define D18F2x1D0_WrTrainBufAddr_OFFSET                         0
#define D18F2x1D0_WrTrainBufAddr_WIDTH                          10
#define D18F2x1D0_WrTrainBufAddr_MASK                           0x3ff
#define D18F2x1D0_Reserved_31_10_OFFSET                         10
#define D18F2x1D0_Reserved_31_10_WIDTH                          22
#define D18F2x1D0_Reserved_31_10_MASK                           0xfffffc00

/// D18F2x1D0
typedef union {
  struct {                                                              ///<
    UINT32                                           WrTrainBufAddr:10; ///<
    UINT32                                           Reserved_31_10:22; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} D18F2x1D0_STRUCT;

// **** D18F2x1D4 Register Definition ****
// Address
#define D18F2x1D4_ADDRESS                                       0x1d4

// Type
#define D18F2x1D4_TYPE                                          TYPE_D18F2
// Field Data
#define D18F2x1D4_WrTrainBufDat_OFFSET                          0
#define D18F2x1D4_WrTrainBufDat_WIDTH                           32
#define D18F2x1D4_WrTrainBufDat_MASK                            0xffffffff

/// D18F2x1D4
typedef union {
  struct {                                                              ///<
    UINT32                                            WrTrainBufDat:32; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} D18F2x1D4_STRUCT;

// **** D18F2x1D8 Register Definition ****
// Address
#define D18F2x1D8_ADDRESS                                       0x1d8

// Type
#define D18F2x1D8_TYPE                                          TYPE_D18F2
// Field Data
#define D18F2x1D8_AltAddrPtr_37_6__OFFSET                       0
#define D18F2x1D8_AltAddrPtr_37_6__WIDTH                        32
#define D18F2x1D8_AltAddrPtr_37_6__MASK                         0xffffffff

/// D18F2x1D8
typedef union {
  struct {                                                              ///<
    UINT32                                         AltAddrPtr_37_6_:32; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} D18F2x1D8_STRUCT;

// **** D18F2x1DC Register Definition ****
// Address
#define D18F2x1DC_ADDRESS                                       0x1dc

// Type
#define D18F2x1DC_TYPE                                          TYPE_D18F2
// Field Data
#define D18F2x1DC_AltAddrPtr_37_6__OFFSET                       0
#define D18F2x1DC_AltAddrPtr_37_6__WIDTH                        32
#define D18F2x1DC_AltAddrPtr_37_6__MASK                         0xffffffff

/// D18F2x1DC
typedef union {
  struct {                                                              ///<
    UINT32                                         AltAddrPtr_37_6_:32; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} D18F2x1DC_STRUCT;

// **** D18F2x1E0 Register Definition ****
// Address
#define D18F2x1E0_ADDRESS                                       0x1e0

// Type
#define D18F2x1E0_TYPE                                          TYPE_D18F2
// Field Data
#define D18F2x1E0_AltAddrPtr_37_6__OFFSET                       0
#define D18F2x1E0_AltAddrPtr_37_6__WIDTH                        32
#define D18F2x1E0_AltAddrPtr_37_6__MASK                         0xffffffff

/// D18F2x1E0
typedef union {
  struct {                                                              ///<
    UINT32                                         AltAddrPtr_37_6_:32; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} D18F2x1E0_STRUCT;

// **** D18F2x1E8 Register Definition ****
// Address
#define D18F2x1E8_ADDRESS                                       0x1e8

// Type
#define D18F2x1E8_TYPE                                          TYPE_D18F2
// Field Data
#define D18F2x1E8_TrainCmpSts_OFFSET                            0
#define D18F2x1E8_TrainCmpSts_WIDTH                             8
#define D18F2x1E8_TrainCmpSts_MASK                              0xff
#define D18F2x1E8_TrainCmpSts2_OFFSET                           8
#define D18F2x1E8_TrainCmpSts2_WIDTH                            8
#define D18F2x1E8_TrainCmpSts2_MASK                             0xff00
#define D18F2x1E8_Reserved_31_16_OFFSET                         16
#define D18F2x1E8_Reserved_31_16_WIDTH                          16
#define D18F2x1E8_Reserved_31_16_MASK                           0xffff0000

/// D18F2x1E8
typedef union {
  struct {                                                              ///<
    UINT32                                              TrainCmpSts:8 ; ///<
    UINT32                                             TrainCmpSts2:8 ; ///<
    UINT32                                           Reserved_31_16:16; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} D18F2x1E8_STRUCT;

// **** D18F2x1F0 Register Definition ****
// Address
#define D18F2x1F0_ADDRESS                                       0x1f0

// Type
#define D18F2x1F0_TYPE                                          TYPE_D18F2
// Field Data
#define D18F2x1F0_DctOffset_OFFSET                              0
#define D18F2x1F0_DctOffset_WIDTH                               28
#define D18F2x1F0_DctOffset_MASK                                0xfffffff
#define D18F2x1F0_Reserved_29_28_OFFSET                         28
#define D18F2x1F0_Reserved_29_28_WIDTH                          2
#define D18F2x1F0_Reserved_29_28_MASK                           0x30000000
#define D18F2x1F0_DctAccessWrite_OFFSET                         30
#define D18F2x1F0_DctAccessWrite_WIDTH                          1
#define D18F2x1F0_DctAccessWrite_MASK                           0x40000000
#define D18F2x1F0_DctAccessDone_OFFSET                          31
#define D18F2x1F0_DctAccessDone_WIDTH                           1
#define D18F2x1F0_DctAccessDone_MASK                            0x80000000

/// D18F2x1F0
typedef union {
  struct {                                                              ///<
    UINT32                                                DctOffset:28; ///<
    UINT32                                           Reserved_29_28:2 ; ///<
    UINT32                                           DctAccessWrite:1 ; ///<
    UINT32                                            DctAccessDone:1 ; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} D18F2x1F0_STRUCT;

// **** D18F2x1F4 Register Definition ****
// Address
#define D18F2x1F4_ADDRESS                                       0x1f4

// Type
#define D18F2x1F4_TYPE                                          TYPE_D18F2
// Field Data
#define D18F2x1F4_DctExtDataPort_OFFSET                         0
#define D18F2x1F4_DctExtDataPort_WIDTH                          32
#define D18F2x1F4_DctExtDataPort_MASK                           0xffffffff

/// D18F2x1F4
typedef union {
  struct {                                                              ///<
    UINT32                                           DctExtDataPort:32; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} D18F2x1F4_STRUCT;

// **** D18F3x00 Register Definition ****
// Address
#define D18F3x00_ADDRESS                                        0x0

// Type
#define D18F3x00_TYPE                                           TYPE_D18F3
// Field Data
#define D18F3x00_VendorID_OFFSET                                0
#define D18F3x00_VendorID_WIDTH                                 16
#define D18F3x00_VendorID_MASK                                  0xffff
#define D18F3x00_DeviceID_OFFSET                                16
#define D18F3x00_DeviceID_WIDTH                                 16
#define D18F3x00_DeviceID_MASK                                  0xffff0000

/// D18F3x00
typedef union {
  struct {                                                              ///<
    UINT32                                                 VendorID:16; ///<
    UINT32                                                 DeviceID:16; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} D18F3x00_STRUCT;

// **** D18F3x04 Register Definition ****
// Address
#define D18F3x04_ADDRESS                                        0x4

// Type
#define D18F3x04_TYPE                                           TYPE_D18F3
// Field Data
#define D18F3x04_Command_OFFSET                                 0
#define D18F3x04_Command_WIDTH                                  16
#define D18F3x04_Command_MASK                                   0xffff
#define D18F3x04_Status_OFFSET                                  16
#define D18F3x04_Status_WIDTH                                   16
#define D18F3x04_Status_MASK                                    0xffff0000

/// D18F3x04
typedef union {
  struct {                                                              ///<
    UINT32                                                  Command:16; ///<
    UINT32                                                   Status:16; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} D18F3x04_STRUCT;

// **** D18F3x08 Register Definition ****
// Address
#define D18F3x08_ADDRESS                                        0x8

// Type
#define D18F3x08_TYPE                                           TYPE_D18F3
// Field Data
#define D18F3x08_RevID_OFFSET                                   0
#define D18F3x08_RevID_WIDTH                                    8
#define D18F3x08_RevID_MASK                                     0xff
#define D18F3x08_ClassCode_OFFSET                               8
#define D18F3x08_ClassCode_WIDTH                                24
#define D18F3x08_ClassCode_MASK                                 0xffffff00

/// D18F3x08
typedef union {
  struct {                                                              ///<
    UINT32                                                    RevID:8 ; ///<
    UINT32                                                ClassCode:24; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} D18F3x08_STRUCT;

// **** D18F3x0C Register Definition ****
// Address
#define D18F3x0C_ADDRESS                                        0xc

// Type
#define D18F3x0C_TYPE                                           TYPE_D18F3
// Field Data
#define D18F3x0C_HeaderTypeReg_OFFSET                           0
#define D18F3x0C_HeaderTypeReg_WIDTH                            32
#define D18F3x0C_HeaderTypeReg_MASK                             0xffffffff

/// D18F3x0C
typedef union {
  struct {                                                              ///<
    UINT32                                            HeaderTypeReg:32; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} D18F3x0C_STRUCT;

// **** D18F3x34 Register Definition ****
// Address
#define D18F3x34_ADDRESS                                        0x34

// Type
#define D18F3x34_TYPE                                           TYPE_D18F3
// Field Data
#define D18F3x34_CapPtr_OFFSET                                  0
#define D18F3x34_CapPtr_WIDTH                                   8
#define D18F3x34_CapPtr_MASK                                    0xff
#define D18F3x34_Reserved_31_8_OFFSET                           8
#define D18F3x34_Reserved_31_8_WIDTH                            24
#define D18F3x34_Reserved_31_8_MASK                             0xffffff00

/// D18F3x34
typedef union {
  struct {                                                              ///<
    UINT32                                                   CapPtr:8 ; ///<
    UINT32                                            Reserved_31_8:24; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} D18F3x34_STRUCT;

// **** D18F3x40 Register Definition ****
// Address
#define D18F3x40_ADDRESS                                        0x40

// Type
#define D18F3x40_TYPE                                           TYPE_D18F3
// Field Data
#define D18F3x40_Reserved_4_0_OFFSET                            0
#define D18F3x40_Reserved_4_0_WIDTH                             5
#define D18F3x40_Reserved_4_0_MASK                              0x1f
#define D18F3x40_SyncFloodEn_OFFSET                             5
#define D18F3x40_SyncFloodEn_WIDTH                              1
#define D18F3x40_SyncFloodEn_MASK                               0x20
#define D18F3x40_Reserved_7_6_OFFSET                            6
#define D18F3x40_Reserved_7_6_WIDTH                             2
#define D18F3x40_Reserved_7_6_MASK                              0xc0
#define D18F3x40_MstrAbortEn_OFFSET                             8
#define D18F3x40_MstrAbortEn_WIDTH                              1
#define D18F3x40_MstrAbortEn_MASK                               0x100
#define D18F3x40_TgtAbortEn_OFFSET                              9
#define D18F3x40_TgtAbortEn_WIDTH                               1
#define D18F3x40_TgtAbortEn_MASK                                0x200
#define D18F3x40_Reserved_10_10_OFFSET                          10
#define D18F3x40_Reserved_10_10_WIDTH                           1
#define D18F3x40_Reserved_10_10_MASK                            0x400
#define D18F3x40_AtomicRMWEn_OFFSET                             11
#define D18F3x40_AtomicRMWEn_WIDTH                              1
#define D18F3x40_AtomicRMWEn_MASK                               0x800
#define D18F3x40_WDTRptEn_OFFSET                                12
#define D18F3x40_WDTRptEn_WIDTH                                 1
#define D18F3x40_WDTRptEn_MASK                                  0x1000
#define D18F3x40_DevErrEn_OFFSET                                13
#define D18F3x40_DevErrEn_WIDTH                                 1
#define D18F3x40_DevErrEn_MASK                                  0x2000
#define D18F3x40_Reserved_15_14_OFFSET                          14
#define D18F3x40_Reserved_15_14_WIDTH                           2
#define D18F3x40_Reserved_15_14_MASK                            0xc000
#define D18F3x40_ProtEn_OFFSET                                  16
#define D18F3x40_ProtEn_WIDTH                                   1
#define D18F3x40_ProtEn_MASK                                    0x10000
#define D18F3x40_DataEn_OFFSET                                  17
#define D18F3x40_DataEn_WIDTH                                   1
#define D18F3x40_DataEn_MASK                                    0x20000
#define D18F3x40_Reserved_24_18_OFFSET                          18
#define D18F3x40_Reserved_24_18_WIDTH                           7
#define D18F3x40_Reserved_24_18_MASK                            0x1fc0000
#define D18F3x40_McaUsPwDatErrEn_OFFSET                         25
#define D18F3x40_McaUsPwDatErrEn_WIDTH                          1
#define D18F3x40_McaUsPwDatErrEn_MASK                           0x2000000
#define D18F3x40_Reserved_31_26_OFFSET                          26
#define D18F3x40_Reserved_31_26_WIDTH                           6
#define D18F3x40_Reserved_31_26_MASK                            0xfc000000

/// D18F3x40
typedef union {
  struct {                                                              ///<
    UINT32                                             Reserved_4_0:5 ; ///<
    UINT32                                              SyncFloodEn:1 ; ///<
    UINT32                                             Reserved_7_6:2 ; ///<
    UINT32                                              MstrAbortEn:1 ; ///<
    UINT32                                               TgtAbortEn:1 ; ///<
    UINT32                                           Reserved_10_10:1 ; ///<
    UINT32                                              AtomicRMWEn:1 ; ///<
    UINT32                                                 WDTRptEn:1 ; ///<
    UINT32                                                 DevErrEn:1 ; ///<
    UINT32                                           Reserved_15_14:2 ; ///<
    UINT32                                                   ProtEn:1 ; ///<
    UINT32                                                   DataEn:1 ; ///<
    UINT32                                           Reserved_24_18:7 ; ///<
    UINT32                                          McaUsPwDatErrEn:1 ; ///<
    UINT32                                           Reserved_31_26:6 ; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} D18F3x40_STRUCT;

// **** D18F3x44 Register Definition ****
// Address
#define D18F3x44_ADDRESS                                        0x44

// Type
#define D18F3x44_TYPE                                           TYPE_D18F3
// Field Data
#define D18F3x44_Reserved_0_0_OFFSET                            0
#define D18F3x44_Reserved_0_0_WIDTH                             1
#define D18F3x44_Reserved_0_0_MASK                              0x1
#define D18F3x44_CpuRdDatErrEn_OFFSET                           1
#define D18F3x44_CpuRdDatErrEn_WIDTH                            1
#define D18F3x44_CpuRdDatErrEn_MASK                             0x2
#define D18F3x44_Reserved_2_2_OFFSET                            2
#define D18F3x44_Reserved_2_2_WIDTH                             1
#define D18F3x44_Reserved_2_2_MASK                              0x4
#define D18F3x44_Reserved_4_3_OFFSET                            3
#define D18F3x44_Reserved_4_3_WIDTH                             2
#define D18F3x44_Reserved_4_3_MASK                              0x18
#define D18F3x44_IoMstAbortDis_OFFSET                           5
#define D18F3x44_IoMstAbortDis_WIDTH                            1
#define D18F3x44_IoMstAbortDis_MASK                             0x20
#define D18F3x44_CpuErrDis_OFFSET                               6
#define D18F3x44_CpuErrDis_WIDTH                                1
#define D18F3x44_CpuErrDis_MASK                                 0x40
#define D18F3x44_IoErrDis_OFFSET                                7
#define D18F3x44_IoErrDis_WIDTH                                 1
#define D18F3x44_IoErrDis_MASK                                  0x80
#define D18F3x44_WDTDis_OFFSET                                  8
#define D18F3x44_WDTDis_WIDTH                                   1
#define D18F3x44_WDTDis_MASK                                    0x100
#define D18F3x44_WDTCntSel_2_0__OFFSET                          9
#define D18F3x44_WDTCntSel_2_0__WIDTH                           3
#define D18F3x44_WDTCntSel_2_0__MASK                            0xe00
#define D18F3x44_WDTBaseSel_OFFSET                              12
#define D18F3x44_WDTBaseSel_WIDTH                               2
#define D18F3x44_WDTBaseSel_MASK                                0x3000
#define D18F3x44_Reserved_19_14_OFFSET                          14
#define D18F3x44_Reserved_19_14_WIDTH                           6
#define D18F3x44_Reserved_19_14_MASK                            0xfc000
#define D18F3x44_SyncOnWDTEn_OFFSET                             20
#define D18F3x44_SyncOnWDTEn_WIDTH                              1
#define D18F3x44_SyncOnWDTEn_MASK                               0x100000
#define D18F3x44_SyncOnAnyErrEn_OFFSET                          21
#define D18F3x44_SyncOnAnyErrEn_WIDTH                           1
#define D18F3x44_SyncOnAnyErrEn_MASK                            0x200000
#define D18F3x44_Reserved_23_22_OFFSET                          22
#define D18F3x44_Reserved_23_22_WIDTH                           2
#define D18F3x44_Reserved_23_22_MASK                            0xc00000
#define D18F3x44_IoRdDatErrEn_OFFSET                            24
#define D18F3x44_IoRdDatErrEn_WIDTH                             1
#define D18F3x44_IoRdDatErrEn_MASK                              0x1000000
#define D18F3x44_DisPciCfgCpuErrRsp_OFFSET                      25
#define D18F3x44_DisPciCfgCpuErrRsp_WIDTH                       1
#define D18F3x44_DisPciCfgCpuErrRsp_MASK                        0x2000000
#define D18F3x44_CorrMcaExcEn_OFFSET                            26
#define D18F3x44_CorrMcaExcEn_WIDTH                             1
#define D18F3x44_CorrMcaExcEn_MASK                              0x4000000
#define D18F3x44_NbMcaToMstCpuEn_OFFSET                         27
#define D18F3x44_NbMcaToMstCpuEn_WIDTH                          1
#define D18F3x44_NbMcaToMstCpuEn_MASK                           0x8000000
#define D18F3x44_DisTgtAbtCpuErrRsp_OFFSET                      28
#define D18F3x44_DisTgtAbtCpuErrRsp_WIDTH                       1
#define D18F3x44_DisTgtAbtCpuErrRsp_MASK                        0x10000000
#define D18F3x44_DisMstAbtCpuErrRsp_OFFSET                      29
#define D18F3x44_DisMstAbtCpuErrRsp_WIDTH                       1
#define D18F3x44_DisMstAbtCpuErrRsp_MASK                        0x20000000
#define D18F3x44_Reserved_30_30_OFFSET                          30
#define D18F3x44_Reserved_30_30_WIDTH                           1
#define D18F3x44_Reserved_30_30_MASK                            0x40000000
#define D18F3x44_NbMcaLogEn_OFFSET                              31
#define D18F3x44_NbMcaLogEn_WIDTH                               1
#define D18F3x44_NbMcaLogEn_MASK                                0x80000000

/// D18F3x44
typedef union {
  struct {                                                              ///<
    UINT32                                             Reserved_0_0:1 ; ///<
    UINT32                                            CpuRdDatErrEn:1 ; ///<
    UINT32                                             Reserved_2_2:1 ; ///<
    UINT32                                             Reserved_4_3:2 ; ///<
    UINT32                                            IoMstAbortDis:1 ; ///<
    UINT32                                                CpuErrDis:1 ; ///<
    UINT32                                                 IoErrDis:1 ; ///<
    UINT32                                                   WDTDis:1 ; ///<
    UINT32                                           WDTCntSel_2_0_:3 ; ///<
    UINT32                                               WDTBaseSel:2 ; ///<
    UINT32                                           Reserved_19_14:6 ; ///<
    UINT32                                              SyncOnWDTEn:1 ; ///<
    UINT32                                           SyncOnAnyErrEn:1 ; ///<
    UINT32                                           Reserved_23_22:2 ; ///<
    UINT32                                             IoRdDatErrEn:1 ; ///<
    UINT32                                       DisPciCfgCpuErrRsp:1 ; ///<
    UINT32                                             CorrMcaExcEn:1 ; ///<
    UINT32                                          NbMcaToMstCpuEn:1 ; ///<
    UINT32                                       DisTgtAbtCpuErrRsp:1 ; ///<
    UINT32                                       DisMstAbtCpuErrRsp:1 ; ///<
    UINT32                                           Reserved_30_30:1 ; ///<
    UINT32                                               NbMcaLogEn:1 ; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} D18F3x44_STRUCT;

// **** D18F3x48 Register Definition ****
// Address
#define D18F3x48_ADDRESS                                        0x48

// Type
#define D18F3x48_TYPE                                           TYPE_D18F3
// Field Data
#define D18F3x48_ErrorCode_OFFSET                               0
#define D18F3x48_ErrorCode_WIDTH                                16
#define D18F3x48_ErrorCode_MASK                                 0xffff
#define D18F3x48_ErrorCodeExt_OFFSET                            16
#define D18F3x48_ErrorCodeExt_WIDTH                             5
#define D18F3x48_ErrorCodeExt_MASK                              0x1f0000
#define D18F3x48_Reserved_31_21_OFFSET                          21
#define D18F3x48_Reserved_31_21_WIDTH                           11
#define D18F3x48_Reserved_31_21_MASK                            0xffe00000

/// D18F3x48
typedef union {
  struct {                                                              ///<
    UINT32                                                ErrorCode:16; ///<
    UINT32                                             ErrorCodeExt:5 ; ///<
    UINT32                                           Reserved_31_21:11; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} D18F3x48_STRUCT;

// **** D18F3x4C Register Definition ****
// Address
#define D18F3x4C_ADDRESS                                        0x4c

// Type
#define D18F3x4C_TYPE                                           TYPE_D18F3
// Field Data
#define D18F3x4C_ErrCPU_OFFSET                                  0
#define D18F3x4C_ErrCPU_WIDTH                                   4
#define D18F3x4C_ErrCPU_MASK                                    0xf
#define D18F3x4C_BusErr_OFFSET                                  4
#define D18F3x4C_BusErr_WIDTH                                   1
#define D18F3x4C_BusErr_MASK                                    0x10
#define D18F3x4C_Reserved_24_5_OFFSET                           5
#define D18F3x4C_Reserved_24_5_WIDTH                            20
#define D18F3x4C_Reserved_24_5_MASK                             0x1ffffe0
#define D18F3x4C_PCC_OFFSET                                     25
#define D18F3x4C_PCC_WIDTH                                      1
#define D18F3x4C_PCC_MASK                                       0x2000000
#define D18F3x4C_AddrV_OFFSET                                   26
#define D18F3x4C_AddrV_WIDTH                                    1
#define D18F3x4C_AddrV_MASK                                     0x4000000
#define D18F3x4C_Reserved_27_27_OFFSET                          27
#define D18F3x4C_Reserved_27_27_WIDTH                           1
#define D18F3x4C_Reserved_27_27_MASK                            0x8000000
#define D18F3x4C_En_OFFSET                                      28
#define D18F3x4C_En_WIDTH                                       1
#define D18F3x4C_En_MASK                                        0x10000000
#define D18F3x4C_UC_OFFSET                                      29
#define D18F3x4C_UC_WIDTH                                       1
#define D18F3x4C_UC_MASK                                        0x20000000
#define D18F3x4C_Over_OFFSET                                    30
#define D18F3x4C_Over_WIDTH                                     1
#define D18F3x4C_Over_MASK                                      0x40000000
#define D18F3x4C_Val_OFFSET                                     31
#define D18F3x4C_Val_WIDTH                                      1
#define D18F3x4C_Val_MASK                                       0x80000000

/// D18F3x4C
typedef union {
  struct {                                                              ///<
    UINT32                                                   ErrCPU:4 ; ///<
    UINT32                                                   BusErr:1 ; ///<
    UINT32                                            Reserved_24_5:20; ///<
    UINT32                                                      PCC:1 ; ///<
    UINT32                                                    AddrV:1 ; ///<
    UINT32                                           Reserved_27_27:1 ; ///<
    UINT32                                                       En:1 ; ///<
    UINT32                                                       UC:1 ; ///<
    UINT32                                                     Over:1 ; ///<
    UINT32                                                      Val:1 ; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} D18F3x4C_STRUCT;

// **** D18F3x50 Register Definition ****
// Address
#define D18F3x50_ADDRESS                                        0x50

// Type
#define D18F3x50_TYPE                                           TYPE_D18F3
// Field Data
#define D18F3x50_ErrorAddr_31_0__OFFSET                         0
#define D18F3x50_ErrorAddr_31_0__WIDTH                          32
#define D18F3x50_ErrorAddr_31_0__MASK                           0xffffffff

/// D18F3x50
typedef union {
  struct {                                                              ///<
    UINT32                                          ErrorAddr_31_0_:32; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} D18F3x50_STRUCT;

// **** D18F3x54 Register Definition ****
// Address
#define D18F3x54_ADDRESS                                        0x54

// Type
#define D18F3x54_TYPE                                           TYPE_D18F3
// Field Data
#define D18F3x54_ErrorAddr_39_32__OFFSET                        0
#define D18F3x54_ErrorAddr_39_32__WIDTH                         8
#define D18F3x54_ErrorAddr_39_32__MASK                          0xff
#define D18F3x54_Reserved_31_8_OFFSET                           8
#define D18F3x54_Reserved_31_8_WIDTH                            24
#define D18F3x54_Reserved_31_8_MASK                             0xffffff00

/// D18F3x54
typedef union {
  struct {                                                              ///<
    UINT32                                         ErrorAddr_39_32_:8 ; ///<
    UINT32                                            Reserved_31_8:24; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} D18F3x54_STRUCT;

// **** D18F3x64 Register Definition ****
// Address
#define D18F3x64_ADDRESS                                        0x64

// Type
#define D18F3x64_TYPE                                           TYPE_D18F3
// Field Data
#define D18F3x64_HtcEn_OFFSET                                   0
#define D18F3x64_HtcEn_WIDTH                                    1
#define D18F3x64_HtcEn_MASK                                     0x1
#define D18F3x64_Reserved_3_1_OFFSET                            1
#define D18F3x64_Reserved_3_1_WIDTH                             3
#define D18F3x64_Reserved_3_1_MASK                              0xe
#define D18F3x64_HtcAct_OFFSET                                  4
#define D18F3x64_HtcAct_WIDTH                                   1
#define D18F3x64_HtcAct_MASK                                    0x10
#define D18F3x64_HtcActSts_OFFSET                               5
#define D18F3x64_HtcActSts_WIDTH                                1
#define D18F3x64_HtcActSts_MASK                                 0x20
#define D18F3x64_PslApicHiEn_OFFSET                             6
#define D18F3x64_PslApicHiEn_WIDTH                              1
#define D18F3x64_PslApicHiEn_MASK                               0x40
#define D18F3x64_PslApicLoEn_OFFSET                             7
#define D18F3x64_PslApicLoEn_WIDTH                              1
#define D18F3x64_PslApicLoEn_MASK                               0x80
#define D18F3x64_Reserved_15_8_OFFSET                           8
#define D18F3x64_Reserved_15_8_WIDTH                            8
#define D18F3x64_Reserved_15_8_MASK                             0xff00
#define D18F3x64_HtcTmpLmt_OFFSET                               16
#define D18F3x64_HtcTmpLmt_WIDTH                                7
#define D18F3x64_HtcTmpLmt_MASK                                 0x7f0000
#define D18F3x64_HtcSlewSel_OFFSET                              23
#define D18F3x64_HtcSlewSel_WIDTH                               1
#define D18F3x64_HtcSlewSel_MASK                                0x800000
#define D18F3x64_HtcHystLmt_OFFSET                              24
#define D18F3x64_HtcHystLmt_WIDTH                               4
#define D18F3x64_HtcHystLmt_MASK                                0xf000000
#define D18F3x64_HtcPstateLimit_OFFSET                          28
#define D18F3x64_HtcPstateLimit_WIDTH                           3
#define D18F3x64_HtcPstateLimit_MASK                            0x70000000
#define D18F3x64_HtcLock_OFFSET                                 31
#define D18F3x64_HtcLock_WIDTH                                  1
#define D18F3x64_HtcLock_MASK                                   0x80000000

/// D18F3x64
typedef union {
  struct {                                                              ///<
    UINT32                                                    HtcEn:1 ; ///<
    UINT32                                             Reserved_3_1:3 ; ///<
    UINT32                                                   HtcAct:1 ; ///<
    UINT32                                                HtcActSts:1 ; ///<
    UINT32                                              PslApicHiEn:1 ; ///<
    UINT32                                              PslApicLoEn:1 ; ///<
    UINT32                                            Reserved_15_8:8 ; ///<
    UINT32                                                HtcTmpLmt:7 ; ///<
    UINT32                                               HtcSlewSel:1 ; ///<
    UINT32                                               HtcHystLmt:4 ; ///<
    UINT32                                           HtcPstateLimit:3 ; ///<
    UINT32                                                  HtcLock:1 ; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} D18F3x64_STRUCT;

// **** D18F3x6C Register Definition ****
// Address
#define D18F3x6C_ADDRESS                                        0x6c

// Type
#define D18F3x6C_TYPE                                           TYPE_D18F3
// Field Data
#define D18F3x6C_UpLoPreqDBC_OFFSET                             0
#define D18F3x6C_UpLoPreqDBC_WIDTH                              4
#define D18F3x6C_UpLoPreqDBC_MASK                               0xf
#define D18F3x6C_UpLoNpreqDBC_OFFSET                            4
#define D18F3x6C_UpLoNpreqDBC_WIDTH                             4
#define D18F3x6C_UpLoNpreqDBC_MASK                              0xf0
#define D18F3x6C_UpLoRespDBC_OFFSET                             8
#define D18F3x6C_UpLoRespDBC_WIDTH                              4
#define D18F3x6C_UpLoRespDBC_MASK                               0xf00
#define D18F3x6C_Reserved_15_12_OFFSET                          12
#define D18F3x6C_Reserved_15_12_WIDTH                           4
#define D18F3x6C_Reserved_15_12_MASK                            0xf000
#define D18F3x6C_UpHiPreqDBC_OFFSET                             16
#define D18F3x6C_UpHiPreqDBC_WIDTH                              4
#define D18F3x6C_UpHiPreqDBC_MASK                               0xf0000
#define D18F3x6C_UpHiNpreqDBC_OFFSET                            20
#define D18F3x6C_UpHiNpreqDBC_WIDTH                             4
#define D18F3x6C_UpHiNpreqDBC_MASK                              0xf00000
#define D18F3x6C_UpHiRespDBC_OFFSET                             24
#define D18F3x6C_UpHiRespDBC_WIDTH                              4
#define D18F3x6C_UpHiRespDBC_MASK                               0xf000000
#define D18F3x6C_Reserved_31_28_OFFSET                          28
#define D18F3x6C_Reserved_31_28_WIDTH                           4
#define D18F3x6C_Reserved_31_28_MASK                            0xf0000000

/// D18F3x6C
typedef union {
  struct {                                                              ///<
    UINT32                                              UpLoPreqDBC:4 ; ///<
    UINT32                                             UpLoNpreqDBC:4 ; ///<
    UINT32                                              UpLoRespDBC:4 ; ///<
    UINT32                                           Reserved_15_12:4 ; ///<
    UINT32                                              UpHiPreqDBC:4 ; ///<
    UINT32                                             UpHiNpreqDBC:4 ; ///<
    UINT32                                              UpHiRespDBC:4 ; ///<
    UINT32                                           Reserved_31_28:4 ; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} D18F3x6C_STRUCT;

// **** D18F3x74 Register Definition ****
// Address
#define D18F3x74_ADDRESS                                        0x74

// Type
#define D18F3x74_TYPE                                           TYPE_D18F3
// Field Data
#define D18F3x74_UpLoPreqCBC_OFFSET                             0
#define D18F3x74_UpLoPreqCBC_WIDTH                              4
#define D18F3x74_UpLoPreqCBC_MASK                               0xf
#define D18F3x74_UpLoNpreqCBC_OFFSET                            4
#define D18F3x74_UpLoNpreqCBC_WIDTH                             4
#define D18F3x74_UpLoNpreqCBC_MASK                              0xf0
#define D18F3x74_UpLoRespCBC_OFFSET                             8
#define D18F3x74_UpLoRespCBC_WIDTH                              4
#define D18F3x74_UpLoRespCBC_MASK                               0xf00
#define D18F3x74_Reserved_15_12_OFFSET                          12
#define D18F3x74_Reserved_15_12_WIDTH                           4
#define D18F3x74_Reserved_15_12_MASK                            0xf000
#define D18F3x74_UpHiPreqCBC_OFFSET                             16
#define D18F3x74_UpHiPreqCBC_WIDTH                              4
#define D18F3x74_UpHiPreqCBC_MASK                               0xf0000
#define D18F3x74_UpHiNpreqCBC_OFFSET                            20
#define D18F3x74_UpHiNpreqCBC_WIDTH                             4
#define D18F3x74_UpHiNpreqCBC_MASK                              0xf00000
#define D18F3x74_UpHiRespCBC_OFFSET                             24
#define D18F3x74_UpHiRespCBC_WIDTH                              4
#define D18F3x74_UpHiRespCBC_MASK                               0xf000000
#define D18F3x74_Reserved_31_28_OFFSET                          28
#define D18F3x74_Reserved_31_28_WIDTH                           4
#define D18F3x74_Reserved_31_28_MASK                            0xf0000000

/// D18F3x74
typedef union {
  struct {                                                              ///<
    UINT32                                              UpLoPreqCBC:4 ; ///<
    UINT32                                             UpLoNpreqCBC:4 ; ///<
    UINT32                                              UpLoRespCBC:4 ; ///<
    UINT32                                           Reserved_15_12:4 ; ///<
    UINT32                                              UpHiPreqCBC:4 ; ///<
    UINT32                                             UpHiNpreqCBC:4 ; ///<
    UINT32                                              UpHiRespCBC:4 ; ///<
    UINT32                                           Reserved_31_28:4 ; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} D18F3x74_STRUCT;

// **** D18F3x7C Register Definition ****
// Address
#define D18F3x7C_ADDRESS                                        0x7c

// Type
#define D18F3x7C_TYPE                                           TYPE_D18F3
// Field Data
#define D18F3x7C_CpuBC_OFFSET                                   0
#define D18F3x7C_CpuBC_WIDTH                                    6
#define D18F3x7C_CpuBC_MASK                                     0x3f
#define D18F3x7C_Reserved_7_6_OFFSET                            6
#define D18F3x7C_Reserved_7_6_WIDTH                             2
#define D18F3x7C_Reserved_7_6_MASK                              0xc0
#define D18F3x7C_LoPriPBC_OFFSET                                8
#define D18F3x7C_LoPriPBC_WIDTH                                 6
#define D18F3x7C_LoPriPBC_MASK                                  0x3f00
#define D18F3x7C_Reserved_15_14_OFFSET                          14
#define D18F3x7C_Reserved_15_14_WIDTH                           2
#define D18F3x7C_Reserved_15_14_MASK                            0xc000
#define D18F3x7C_LoPriNpBC_OFFSET                               16
#define D18F3x7C_LoPriNpBC_WIDTH                                6
#define D18F3x7C_LoPriNpBC_MASK                                 0x3f0000
#define D18F3x7C_Reserved_23_22_OFFSET                          22
#define D18F3x7C_Reserved_23_22_WIDTH                           2
#define D18F3x7C_Reserved_23_22_MASK                            0xc00000
#define D18F3x7C_FreePoolBC_OFFSET                              24
#define D18F3x7C_FreePoolBC_WIDTH                               6
#define D18F3x7C_FreePoolBC_MASK                                0x3f000000
#define D18F3x7C_Reserved_31_30_OFFSET                          30
#define D18F3x7C_Reserved_31_30_WIDTH                           2
#define D18F3x7C_Reserved_31_30_MASK                            0xc0000000

/// D18F3x7C
typedef union {
  struct {                                                              ///<
    UINT32                                                    CpuBC:6 ; ///<
    UINT32                                             Reserved_7_6:2 ; ///<
    UINT32                                                 LoPriPBC:6 ; ///<
    UINT32                                           Reserved_15_14:2 ; ///<
    UINT32                                                LoPriNpBC:6 ; ///<
    UINT32                                           Reserved_23_22:2 ; ///<
    UINT32                                               FreePoolBC:6 ; ///<
    UINT32                                           Reserved_31_30:2 ; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} D18F3x7C_STRUCT;

// **** D18F3x80 Register Definition ****
// Address
#define D18F3x80_ADDRESS                                        0x80

// Type
#define D18F3x80_TYPE                                           TYPE_D18F3
// Field Data
#define D18F3x80_Reserved_31_0_OFFSET                           0
#define D18F3x80_Reserved_31_0_WIDTH                            32
#define D18F3x80_Reserved_31_0_MASK                             0xffffffff

/// D18F3x80
typedef union {
  struct {                                                              ///<
    UINT32                                            Reserved_31_0:32; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} D18F3x80_STRUCT;

// **** D18F3x84 Register Definition ****
// Address
#define D18F3x84_ADDRESS                                        0x84

// Type
#define D18F3x84_TYPE                                           TYPE_D18F3
// Field Data
#define D18F3x84_Reserved_0_0_OFFSET                            0
#define D18F3x84_Reserved_0_0_WIDTH                             1
#define D18F3x84_Reserved_0_0_MASK                              0x1
#define D18F3x84_Smaf4DramSr_OFFSET                             1
#define D18F3x84_Smaf4DramSr_WIDTH                              1
#define D18F3x84_Smaf4DramSr_MASK                               0x2
#define D18F3x84_Smaf4DramMemClkTri_OFFSET                      2
#define D18F3x84_Smaf4DramMemClkTri_WIDTH                       1
#define D18F3x84_Smaf4DramMemClkTri_MASK                        0x4
#define D18F3x84_Reserved_16_3_OFFSET                           3
#define D18F3x84_Reserved_16_3_WIDTH                            14
#define D18F3x84_Reserved_16_3_MASK                             0x1fff8
#define D18F3x84_Smaf6DramSr_OFFSET                             17
#define D18F3x84_Smaf6DramSr_WIDTH                              1
#define D18F3x84_Smaf6DramSr_MASK                               0x20000
#define D18F3x84_Smaf6DramMemClkTri_OFFSET                      18
#define D18F3x84_Smaf6DramMemClkTri_WIDTH                       1
#define D18F3x84_Smaf6DramMemClkTri_MASK                        0x40000
#define D18F3x84_Reserved_31_19_OFFSET                          19
#define D18F3x84_Reserved_31_19_WIDTH                           13
#define D18F3x84_Reserved_31_19_MASK                            0xfff80000

/// D18F3x84
typedef union {
  struct {                                                              ///<
    UINT32                                             Reserved_0_0:1 ; ///<
    UINT32                                              Smaf4DramSr:1 ; ///<
    UINT32                                       Smaf4DramMemClkTri:1 ; ///<
    UINT32                                            Reserved_16_3:14; ///<
    UINT32                                              Smaf6DramSr:1 ; ///<
    UINT32                                       Smaf6DramMemClkTri:1 ; ///<
    UINT32                                           Reserved_31_19:13; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} D18F3x84_STRUCT;

// **** D18F3x88 Register Definition ****
// Address
#define D18F3x88_ADDRESS                                        0x88

// Type
#define D18F3x88_TYPE                                           TYPE_D18F3
// Field Data
#define D18F3x88_Reserved_31_0_OFFSET                           0
#define D18F3x88_Reserved_31_0_WIDTH                            32
#define D18F3x88_Reserved_31_0_MASK                             0xffffffff

/// D18F3x88
typedef union {
  struct {                                                              ///<
    UINT32                                            Reserved_31_0:32; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} D18F3x88_STRUCT;

// **** D18F3x8C Register Definition ****
// Address
#define D18F3x8C_ADDRESS                                        0x8c

// Type
#define D18F3x8C_TYPE                                           TYPE_D18F3
// Field Data
#define D18F3x8C_Reserved_12_0_OFFSET                           0
#define D18F3x8C_Reserved_12_0_WIDTH                            13
#define D18F3x8C_Reserved_12_0_MASK                             0x1fff
#define D18F3x8C_DisUsSysMgtReqToNcHt_OFFSET                    13
#define D18F3x8C_DisUsSysMgtReqToNcHt_WIDTH                     1
#define D18F3x8C_DisUsSysMgtReqToNcHt_MASK                      0x2000
#define D18F3x8C_EnableCf8ExtCfg_OFFSET                         14
#define D18F3x8C_EnableCf8ExtCfg_WIDTH                          1
#define D18F3x8C_EnableCf8ExtCfg_MASK                           0x4000
#define D18F3x8C_Reserved_25_15_OFFSET                          15
#define D18F3x8C_Reserved_25_15_WIDTH                           11
#define D18F3x8C_Reserved_25_15_MASK                            0x3ff8000
#define D18F3x8C_EnConvertToNonIsoc_OFFSET                      26
#define D18F3x8C_EnConvertToNonIsoc_WIDTH                       1
#define D18F3x8C_EnConvertToNonIsoc_MASK                        0x4000000
#define D18F3x8C_Reserved_31_27_OFFSET                          27
#define D18F3x8C_Reserved_31_27_WIDTH                           5
#define D18F3x8C_Reserved_31_27_MASK                            0xf8000000

/// D18F3x8C
typedef union {
  struct {                                                              ///<
    UINT32                                            Reserved_12_0:13; ///<
    UINT32                                     DisUsSysMgtReqToNcHt:1 ; ///<
    UINT32                                          EnableCf8ExtCfg:1 ; ///<
    UINT32                                           Reserved_25_15:11; ///<
    UINT32                                       EnConvertToNonIsoc:1 ; ///<
    UINT32                                           Reserved_31_27:5 ; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} D18F3x8C_STRUCT;


// **** D18F3xA4 Register Definition ****
// Address
#define D18F3xA4_ADDRESS                                        0xa4

// Type
#define D18F3xA4_TYPE                                           TYPE_D18F3
// Field Data
#define D18F3xA4_PerStepTimeUp_OFFSET                           0
#define D18F3xA4_PerStepTimeUp_WIDTH                            5
#define D18F3xA4_PerStepTimeUp_MASK                             0x1f
#define D18F3xA4_TmpMaxDiffUp_OFFSET                            5
#define D18F3xA4_TmpMaxDiffUp_WIDTH                             2
#define D18F3xA4_TmpMaxDiffUp_MASK                              0x60
#define D18F3xA4_TmpSlewDnEn_OFFSET                             7
#define D18F3xA4_TmpSlewDnEn_WIDTH                              1
#define D18F3xA4_TmpSlewDnEn_MASK                               0x80
#define D18F3xA4_PerStepTimeDn_OFFSET                           8
#define D18F3xA4_PerStepTimeDn_WIDTH                            5
#define D18F3xA4_PerStepTimeDn_MASK                             0x1f00
#define D18F3xA4_Reserved_20_13_OFFSET                          13
#define D18F3xA4_Reserved_20_13_WIDTH                           8
#define D18F3xA4_Reserved_20_13_MASK                            0x1fe000
#define D18F3xA4_CurTmp_OFFSET                                  21
#define D18F3xA4_CurTmp_WIDTH                                   11
#define D18F3xA4_CurTmp_MASK                                    0xffe00000

/// D18F3xA4
typedef union {
  struct {                                                              ///<
    UINT32                                            PerStepTimeUp:5 ; ///<
    UINT32                                             TmpMaxDiffUp:2 ; ///<
    UINT32                                              TmpSlewDnEn:1 ; ///<
    UINT32                                            PerStepTimeDn:5 ; ///<
    UINT32                                           Reserved_20_13:8 ; ///<
    UINT32                                                   CurTmp:11; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} D18F3xA4_STRUCT;


// **** D18F3xD8 Register Definition ****
// Address
#define D18F3xD8_ADDRESS                                        0xd8

// Type
#define D18F3xD8_TYPE                                           TYPE_D18F3
// Field Data
#define D18F3xD8_Reserved_3_0_OFFSET                            0
#define D18F3xD8_Reserved_3_0_WIDTH                             4
#define D18F3xD8_Reserved_3_0_MASK                              0xf
#define D18F3xD8_VSRampSlamTime_OFFSET                          4
#define D18F3xD8_VSRampSlamTime_WIDTH                           3
#define D18F3xD8_VSRampSlamTime_MASK                            0x70
#define D18F3xD8_ExtndTriDly_OFFSET                             7
#define D18F3xD8_ExtndTriDly_WIDTH                              5
#define D18F3xD8_ExtndTriDly_MASK                               0xf80
#define D18F3xD8_Reserved_28_12_OFFSET                          12
#define D18F3xD8_Reserved_28_12_WIDTH                           17
#define D18F3xD8_Reserved_28_12_MASK                            0x1ffff000
#define D18F3xD8_Reserved_31_29_OFFSET                          29
#define D18F3xD8_Reserved_31_29_WIDTH                           3
#define D18F3xD8_Reserved_31_29_MASK                            0xe0000000

/// D18F3xD8
typedef union {
  struct {                                                              ///<
    UINT32                                             Reserved_3_0:4 ; ///<
    UINT32                                           VSRampSlamTime:3 ; ///<
    UINT32                                              ExtndTriDly:5 ; ///<
    UINT32                                           Reserved_28_12:17; ///<
    UINT32                                           Reserved_31_29:3 ; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} D18F3xD8_STRUCT;

// **** D18F3xDC Register Definition ****
// Address
#define D18F3xDC_ADDRESS                                        0xdc

// Type
#define D18F3xDC_TYPE                                           TYPE_D18F3
// Field Data
#define D18F3xDC_Reserved_7_0_OFFSET                            0
#define D18F3xDC_Reserved_7_0_WIDTH                             8
#define D18F3xDC_Reserved_7_0_MASK                              0xff
#define D18F3xDC_PstateMaxVal_OFFSET                            8
#define D18F3xDC_PstateMaxVal_WIDTH                             3
#define D18F3xDC_PstateMaxVal_MASK                              0x700
#define D18F3xDC_Reserved_11_11_OFFSET                          11
#define D18F3xDC_Reserved_11_11_WIDTH                           1
#define D18F3xDC_Reserved_11_11_MASK                            0x800
#define D18F3xDC_NbPs0Vid_OFFSET                                12
#define D18F3xDC_NbPs0Vid_WIDTH                                 7
#define D18F3xDC_NbPs0Vid_MASK                                  0x7f000
#define D18F3xDC_NclkFreqDone_OFFSET                            19
#define D18F3xDC_NclkFreqDone_WIDTH                             1
#define D18F3xDC_NclkFreqDone_MASK                              0x80000
#define D18F3xDC_NbPs0NclkDiv_OFFSET                            20
#define D18F3xDC_NbPs0NclkDiv_WIDTH                             7
#define D18F3xDC_NbPs0NclkDiv_MASK                              0x7f00000
#define D18F3xDC_NbClockGateHyst_OFFSET                         27
#define D18F3xDC_NbClockGateHyst_WIDTH                          3
#define D18F3xDC_NbClockGateHyst_MASK                           0x38000000
#define D18F3xDC_NbClockGateEn_OFFSET                           30
#define D18F3xDC_NbClockGateEn_WIDTH                            1
#define D18F3xDC_NbClockGateEn_MASK                             0x40000000
#define D18F3xDC_CnbCifClockGateEn_OFFSET                       31
#define D18F3xDC_CnbCifClockGateEn_WIDTH                        1
#define D18F3xDC_CnbCifClockGateEn_MASK                         0x80000000

/// D18F3xDC
typedef union {
  struct {                                                              ///<
    UINT32                                             Reserved_7_0:8 ; ///<
    UINT32                                             PstateMaxVal:3 ; ///<
    UINT32                                           Reserved_11_11:1 ; ///<
    UINT32                                                 NbPs0Vid:7 ; ///<
    UINT32                                             NclkFreqDone:1 ; ///<
    UINT32                                             NbPs0NclkDiv:7 ; ///<
    UINT32                                          NbClockGateHyst:3 ; ///<
    UINT32                                            NbClockGateEn:1 ; ///<
    UINT32                                        CnbCifClockGateEn:1 ; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} D18F3xDC_STRUCT;

// **** D18F3xE4 Register Definition ****
// Address
#define D18F3xE4_ADDRESS                                        0xe4

// Type
#define D18F3xE4_TYPE                                           TYPE_D18F3
// Field Data
#define D18F3xE4_Reserved_0_0_OFFSET                            0
#define D18F3xE4_Reserved_0_0_WIDTH                             1
#define D18F3xE4_Reserved_0_0_MASK                              0x1
#define D18F3xE4_Thermtp_OFFSET                                 1
#define D18F3xE4_Thermtp_WIDTH                                  1
#define D18F3xE4_Thermtp_MASK                                   0x2
#define D18F3xE4_Reserved_2_2_OFFSET                            2
#define D18F3xE4_Reserved_2_2_WIDTH                             1
#define D18F3xE4_Reserved_2_2_MASK                              0x4
#define D18F3xE4_ThermtpSense_OFFSET                            3
#define D18F3xE4_ThermtpSense_WIDTH                             1
#define D18F3xE4_ThermtpSense_MASK                              0x8
#define D18F3xE4_Reserved_4_4_OFFSET                            4
#define D18F3xE4_Reserved_4_4_WIDTH                             1
#define D18F3xE4_Reserved_4_4_MASK                              0x10
#define D18F3xE4_ThermtpEn_OFFSET                               5
#define D18F3xE4_ThermtpEn_WIDTH                                1
#define D18F3xE4_ThermtpEn_MASK                                 0x20
#define D18F3xE4_Reserved_7_6_OFFSET                            6
#define D18F3xE4_Reserved_7_6_WIDTH                             2
#define D18F3xE4_Reserved_7_6_MASK                              0xc0
#define D18F3xE4_Reserved_30_8_OFFSET                           8
#define D18F3xE4_Reserved_30_8_WIDTH                            23
#define D18F3xE4_Reserved_30_8_MASK                             0x7fffff00
#define D18F3xE4_SwThermtp_OFFSET                               31
#define D18F3xE4_SwThermtp_WIDTH                                1
#define D18F3xE4_SwThermtp_MASK                                 0x80000000

/// D18F3xE4
typedef union {
  struct {                                                              ///<
    UINT32                                             Reserved_0_0:1 ; ///<
    UINT32                                                  Thermtp:1 ; ///<
    UINT32                                             Reserved_2_2:1 ; ///<
    UINT32                                             ThermtpSense:1 ; ///<
    UINT32                                             Reserved_4_4:1 ; ///<
    UINT32                                                ThermtpEn:1 ; ///<
    UINT32                                             Reserved_7_6:2 ; ///<
    UINT32                                            Reserved_30_8:23; ///<
    UINT32                                                SwThermtp:1 ; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} D18F3xE4_STRUCT;

// **** D18F3xE8 Register Definition ****
// Address
#define D18F3xE8_ADDRESS                                        0xe8

// Type
#define D18F3xE8_TYPE                                           TYPE_D18F3
// Field Data
#define D18F3xE8_DctDualCap_OFFSET                              0
#define D18F3xE8_DctDualCap_WIDTH                               1
#define D18F3xE8_DctDualCap_MASK                                0x1
#define D18F3xE8_Reserved_4_1_OFFSET                            1
#define D18F3xE8_Reserved_4_1_WIDTH                             4
#define D18F3xE8_Reserved_4_1_MASK                              0x1e
#define D18F3xE8_DdrMaxRate_OFFSET                              5
#define D18F3xE8_DdrMaxRate_WIDTH                               3
#define D18F3xE8_DdrMaxRate_MASK                                0xe0
#define D18F3xE8_MctCap_OFFSET                                  8
#define D18F3xE8_MctCap_WIDTH                                   1
#define D18F3xE8_MctCap_MASK                                    0x100
#define D18F3xE8_SvmCapable_OFFSET                              9
#define D18F3xE8_SvmCapable_WIDTH                               1
#define D18F3xE8_SvmCapable_MASK                                0x200
#define D18F3xE8_HtcCapable_OFFSET                              10
#define D18F3xE8_HtcCapable_WIDTH                               1
#define D18F3xE8_HtcCapable_MASK                                0x400
#define D18F3xE8_Reserved_11_11_OFFSET                          11
#define D18F3xE8_Reserved_11_11_WIDTH                           1
#define D18F3xE8_Reserved_11_11_MASK                            0x800
#define D18F3xE8_CmpCap_OFFSET                                  12
#define D18F3xE8_CmpCap_WIDTH                                   2
#define D18F3xE8_CmpCap_MASK                                    0x3000
#define D18F3xE8_Reserved_27_14_OFFSET                          14
#define D18F3xE8_Reserved_27_14_WIDTH                           14
#define D18F3xE8_Reserved_27_14_MASK                            0xfffc000
#define D18F3xE8_LHtcCapable_OFFSET                             28
#define D18F3xE8_LHtcCapable_WIDTH                              1
#define D18F3xE8_LHtcCapable_MASK                               0x10000000
#define D18F3xE8_Reserved_31_29_OFFSET                          29
#define D18F3xE8_Reserved_31_29_WIDTH                           3
#define D18F3xE8_Reserved_31_29_MASK                            0xe0000000

/// D18F3xE8
typedef union {
  struct {                                                              ///<
    UINT32                                               DctDualCap:1 ; ///<
    UINT32                                             Reserved_4_1:4 ; ///<
    UINT32                                               DdrMaxRate:3 ; ///<
    UINT32                                                   MctCap:1 ; ///<
    UINT32                                               SvmCapable:1 ; ///<
    UINT32                                               HtcCapable:1 ; ///<
    UINT32                                           Reserved_11_11:1 ; ///<
    UINT32                                                   CmpCap:2 ; ///<
    UINT32                                           Reserved_27_14:14; ///<
    UINT32                                              LHtcCapable:1 ; ///<
    UINT32                                           Reserved_31_29:3 ; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} D18F3xE8_STRUCT;

// **** D18F3xF0 Register Definition ****
// Address
#define D18F3xF0_ADDRESS                                        0xf0

// Type
#define D18F3xF0_TYPE                                           TYPE_D18F3
// Field Data
#define D18F3xF0_Reserved_31_0_OFFSET                           0
#define D18F3xF0_Reserved_31_0_WIDTH                            32
#define D18F3xF0_Reserved_31_0_MASK                             0xffffffff

/// D18F3xF0
typedef union {
  struct {                                                              ///<
    UINT32                                            Reserved_31_0:32; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} D18F3xF0_STRUCT;

// **** D18F3xF4 Register Definition ****
// Address
#define D18F3xF4_ADDRESS                                        0xf4

// Type
#define D18F3xF4_TYPE                                           TYPE_D18F3
// Field Data
#define D18F3xF4_Reserved_31_0_OFFSET                           0
#define D18F3xF4_Reserved_31_0_WIDTH                            32
#define D18F3xF4_Reserved_31_0_MASK                             0xffffffff

/// D18F3xF4
typedef union {
  struct {                                                              ///<
    UINT32                                            Reserved_31_0:32; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} D18F3xF4_STRUCT;

// **** D18F3xF8 Register Definition ****
// Address
#define D18F3xF8_ADDRESS                                        0xf8

// Type
#define D18F3xF8_TYPE                                           TYPE_D18F3
// Field Data
#define D18F3xF8_Reserved_31_0_OFFSET                           0
#define D18F3xF8_Reserved_31_0_WIDTH                            32
#define D18F3xF8_Reserved_31_0_MASK                             0xffffffff

/// D18F3xF8
typedef union {
  struct {                                                              ///<
    UINT32                                            Reserved_31_0:32; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} D18F3xF8_STRUCT;

// **** D18F3xFC Register Definition ****
// Address
#define D18F3xFC_ADDRESS                                        0xfc

// Type
#define D18F3xFC_TYPE                                           TYPE_D18F3
// Field Data
#define D18F3xFC_Stepping_OFFSET                                0
#define D18F3xFC_Stepping_WIDTH                                 4
#define D18F3xFC_Stepping_MASK                                  0xf
#define D18F3xFC_BaseModel_OFFSET                               4
#define D18F3xFC_BaseModel_WIDTH                                4
#define D18F3xFC_BaseModel_MASK                                 0xf0
#define D18F3xFC_BaseFamily_OFFSET                              8
#define D18F3xFC_BaseFamily_WIDTH                               4
#define D18F3xFC_BaseFamily_MASK                                0xf00
#define D18F3xFC_Reserved_15_12_OFFSET                          12
#define D18F3xFC_Reserved_15_12_WIDTH                           4
#define D18F3xFC_Reserved_15_12_MASK                            0xf000
#define D18F3xFC_ExtModel_OFFSET                                16
#define D18F3xFC_ExtModel_WIDTH                                 4
#define D18F3xFC_ExtModel_MASK                                  0xf0000
#define D18F3xFC_ExtFamily_OFFSET                               20
#define D18F3xFC_ExtFamily_WIDTH                                8
#define D18F3xFC_ExtFamily_MASK                                 0xff00000
#define D18F3xFC_Reserved_31_28_OFFSET                          28
#define D18F3xFC_Reserved_31_28_WIDTH                           4
#define D18F3xFC_Reserved_31_28_MASK                            0xf0000000

/// D18F3xFC
typedef union {
  struct {                                                              ///<
    UINT32                                                 Stepping:4 ; ///<
    UINT32                                                BaseModel:4 ; ///<
    UINT32                                               BaseFamily:4 ; ///<
    UINT32                                           Reserved_15_12:4 ; ///<
    UINT32                                                 ExtModel:4 ; ///<
    UINT32                                                ExtFamily:8 ; ///<
    UINT32                                           Reserved_31_28:4 ; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} D18F3xFC_STRUCT;

// **** D18F3x128 Register Definition ****
// Address
#define D18F3x128_ADDRESS                                       0x128

// Type
#define D18F3x128_TYPE                                          TYPE_D18F3
// Field Data
#define D18F3x128_C6Vid_OFFSET                                  0
#define D18F3x128_C6Vid_WIDTH                                   7
#define D18F3x128_C6Vid_MASK                                    0x7f
#define D18F3x128_Reserved_7_7_OFFSET                           7
#define D18F3x128_Reserved_7_7_WIDTH                            1
#define D18F3x128_Reserved_7_7_MASK                             0x80
#define D18F3x128_NbPsiVid_OFFSET                               8
#define D18F3x128_NbPsiVid_WIDTH                                7
#define D18F3x128_NbPsiVid_MASK                                 0x7f00
#define D18F3x128_NbPsiVidEn_OFFSET                             15
#define D18F3x128_NbPsiVidEn_WIDTH                              1
#define D18F3x128_NbPsiVidEn_MASK                               0x8000
#define D18F3x128_Reserved_31_16_OFFSET                         16
#define D18F3x128_Reserved_31_16_WIDTH                          16
#define D18F3x128_Reserved_31_16_MASK                           0xffff0000

/// D18F3x128
typedef union {
  struct {                                                              ///<
    UINT32                                                    C6Vid:7 ; ///<
    UINT32                                             Reserved_7_7:1 ; ///<
    UINT32                                                 NbPsiVid:7 ; ///<
    UINT32                                               NbPsiVidEn:1 ; ///<
    UINT32                                           Reserved_31_16:16; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} D18F3x128_STRUCT;

// **** D18F3x138 Register Definition ****
// Address
#define D18F3x138_ADDRESS                                       0x138

// Type
#define D18F3x138_TYPE                                          TYPE_D18F3
// Field Data
#define D18F3x138_LHtcEn_OFFSET                                 0
#define D18F3x138_LHtcEn_WIDTH                                  1
#define D18F3x138_LHtcEn_MASK                                   0x1
#define D18F3x138_Reserved_7_1_OFFSET                           1
#define D18F3x138_Reserved_7_1_WIDTH                            7
#define D18F3x138_Reserved_7_1_MASK                             0xfe
#define D18F3x138_LHtcAct_OFFSET                                8
#define D18F3x138_LHtcAct_WIDTH                                 1
#define D18F3x138_LHtcAct_MASK                                  0x100
#define D18F3x138_Reserved_11_9_OFFSET                          9
#define D18F3x138_Reserved_11_9_WIDTH                           3
#define D18F3x138_Reserved_11_9_MASK                            0xe00
#define D18F3x138_LHtcActSts_OFFSET                             12
#define D18F3x138_LHtcActSts_WIDTH                              1
#define D18F3x138_LHtcActSts_MASK                               0x1000
#define D18F3x138_Reserved_15_13_OFFSET                         13
#define D18F3x138_Reserved_15_13_WIDTH                          3
#define D18F3x138_Reserved_15_13_MASK                           0xe000
#define D18F3x138_LHtcTmpLmt_OFFSET                             16
#define D18F3x138_LHtcTmpLmt_WIDTH                              7
#define D18F3x138_LHtcTmpLmt_MASK                               0x7f0000
#define D18F3x138_LHtcSlewSel_OFFSET                            23
#define D18F3x138_LHtcSlewSel_WIDTH                             1
#define D18F3x138_LHtcSlewSel_MASK                              0x800000
#define D18F3x138_LHtcHystLmt_OFFSET                            24
#define D18F3x138_LHtcHystLmt_WIDTH                             4
#define D18F3x138_LHtcHystLmt_MASK                              0xf000000
#define D18F3x138_LHtcPstateLimit_OFFSET                        28
#define D18F3x138_LHtcPstateLimit_WIDTH                         3
#define D18F3x138_LHtcPstateLimit_MASK                          0x70000000
#define D18F3x138_LHtcLock_OFFSET                               31
#define D18F3x138_LHtcLock_WIDTH                                1
#define D18F3x138_LHtcLock_MASK                                 0x80000000

/// D18F3x138
typedef union {
  struct {                                                              ///<
    UINT32                                                   LHtcEn:1 ; ///<
    UINT32                                             Reserved_7_1:7 ; ///<
    UINT32                                                  LHtcAct:1 ; ///<
    UINT32                                            Reserved_11_9:3 ; ///<
    UINT32                                               LHtcActSts:1 ; ///<
    UINT32                                           Reserved_15_13:3 ; ///<
    UINT32                                               LHtcTmpLmt:7 ; ///<
    UINT32                                              LHtcSlewSel:1 ; ///<
    UINT32                                              LHtcHystLmt:4 ; ///<
    UINT32                                          LHtcPstateLimit:3 ; ///<
    UINT32                                                 LHtcLock:1 ; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} D18F3x138_STRUCT;

// **** D18F3x15C Register Definition ****
// Address
#define D18F3x15C_ADDRESS                                       0x15c

// Type
#define D18F3x15C_TYPE                                          TYPE_D18F3
// Field Data
#define D18F3x15C_SclkVidLevel0_OFFSET                          0
#define D18F3x15C_SclkVidLevel0_WIDTH                           7
#define D18F3x15C_SclkVidLevel0_MASK                            0x7f
#define D18F3x15C_Reserved_7_7_OFFSET                           7
#define D18F3x15C_Reserved_7_7_WIDTH                            1
#define D18F3x15C_Reserved_7_7_MASK                             0x80
#define D18F3x15C_SclkVidLevel1_OFFSET                          8
#define D18F3x15C_SclkVidLevel1_WIDTH                           7
#define D18F3x15C_SclkVidLevel1_MASK                            0x7f00
#define D18F3x15C_Reserved_15_15_OFFSET                         15
#define D18F3x15C_Reserved_15_15_WIDTH                          1
#define D18F3x15C_Reserved_15_15_MASK                           0x8000
#define D18F3x15C_SclkVidLevel2_OFFSET                          16
#define D18F3x15C_SclkVidLevel2_WIDTH                           7
#define D18F3x15C_SclkVidLevel2_MASK                            0x7f0000
#define D18F3x15C_Reserved_23_23_OFFSET                         23
#define D18F3x15C_Reserved_23_23_WIDTH                          1
#define D18F3x15C_Reserved_23_23_MASK                           0x800000
#define D18F3x15C_SclkVidLevel3_OFFSET                          24
#define D18F3x15C_SclkVidLevel3_WIDTH                           7
#define D18F3x15C_SclkVidLevel3_MASK                            0x7f000000
#define D18F3x15C_Reserved_31_31_OFFSET                         31
#define D18F3x15C_Reserved_31_31_WIDTH                          1
#define D18F3x15C_Reserved_31_31_MASK                           0x80000000

/// D18F3x15C
typedef union {
  struct {                                                              ///<
    UINT32                                            SclkVidLevel0:7 ; ///<
    UINT32                                             Reserved_7_7:1 ; ///<
    UINT32                                            SclkVidLevel1:7 ; ///<
    UINT32                                           Reserved_15_15:1 ; ///<
    UINT32                                            SclkVidLevel2:7 ; ///<
    UINT32                                           Reserved_23_23:1 ; ///<
    UINT32                                            SclkVidLevel3:7 ; ///<
    UINT32                                           Reserved_31_31:1 ; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} D18F3x15C_STRUCT;

// **** D18F3x17C Register Definition ****
// Address
#define D18F3x17C_ADDRESS                                       0x17c

// Type
#define D18F3x17C_TYPE                                          TYPE_D18F3
// Field Data
#define D18F3x17C_HiPriPBC_OFFSET                               0
#define D18F3x17C_HiPriPBC_WIDTH                                6
#define D18F3x17C_HiPriPBC_MASK                                 0x3f
#define D18F3x17C_Reserved_7_6_OFFSET                           6
#define D18F3x17C_Reserved_7_6_WIDTH                            2
#define D18F3x17C_Reserved_7_6_MASK                             0xc0
#define D18F3x17C_HiPriNPBC_OFFSET                              8
#define D18F3x17C_HiPriNPBC_WIDTH                               6
#define D18F3x17C_HiPriNPBC_MASK                                0x3f00
#define D18F3x17C_Reserved_31_14_OFFSET                         14
#define D18F3x17C_Reserved_31_14_WIDTH                          18
#define D18F3x17C_Reserved_31_14_MASK                           0xffffc000

/// D18F3x17C
typedef union {
  struct {                                                              ///<
    UINT32                                                 HiPriPBC:6 ; ///<
    UINT32                                             Reserved_7_6:2 ; ///<
    UINT32                                                HiPriNPBC:6 ; ///<
    UINT32                                           Reserved_31_14:18; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} D18F3x17C_STRUCT;

// **** D18F3x180 Register Definition ****
// Address
#define D18F3x180_ADDRESS                                       0x180

// Type
#define D18F3x180_TYPE                                          TYPE_D18F3
// Field Data
#define D18F3x180_Reserved_1_0_OFFSET                           0
#define D18F3x180_Reserved_1_0_WIDTH                            2
#define D18F3x180_Reserved_1_0_MASK                             0x3
#define D18F3x180_WDTCntSel_3__OFFSET                           2
#define D18F3x180_WDTCntSel_3__WIDTH                            1
#define D18F3x180_WDTCntSel_3__MASK                             0x4
#define D18F3x180_DatErrChgToTgtAbt_OFFSET                      3
#define D18F3x180_DatErrChgToTgtAbt_WIDTH                       1
#define D18F3x180_DatErrChgToTgtAbt_MASK                        0x8
#define D18F3x180_MstAbtChgToNoErrs_OFFSET                      4
#define D18F3x180_MstAbtChgToNoErrs_WIDTH                       1
#define D18F3x180_MstAbtChgToNoErrs_MASK                        0x10
#define D18F3x180_DisPciCfgCpuMstAbtRsp_OFFSET                  5
#define D18F3x180_DisPciCfgCpuMstAbtRsp_WIDTH                   1
#define D18F3x180_DisPciCfgCpuMstAbtRsp_MASK                    0x20
#define D18F3x180_Reserved_6_6_OFFSET                           6
#define D18F3x180_Reserved_6_6_WIDTH                            1
#define D18F3x180_Reserved_6_6_MASK                             0x40
#define D18F3x180_SyncFloodOnTgtAbtErr_OFFSET                   7
#define D18F3x180_SyncFloodOnTgtAbtErr_WIDTH                    1
#define D18F3x180_SyncFloodOnTgtAbtErr_MASK                     0x80
#define D18F3x180_Reserved_20_8_OFFSET                          8
#define D18F3x180_Reserved_20_8_WIDTH                           13
#define D18F3x180_Reserved_20_8_MASK                            0x1fff00
#define D18F3x180_SyncFloodOnCpuLeakErr_OFFSET                  21
#define D18F3x180_SyncFloodOnCpuLeakErr_WIDTH                   1
#define D18F3x180_SyncFloodOnCpuLeakErr_MASK                    0x200000
#define D18F3x180_Reserved_31_22_OFFSET                         22
#define D18F3x180_Reserved_31_22_WIDTH                          10
#define D18F3x180_Reserved_31_22_MASK                           0xffc00000

/// D18F3x180
typedef union {
  struct {                                                              ///<
    UINT32                                             Reserved_1_0:2 ; ///<
    UINT32                                             WDTCntSel_3_:1 ; ///<
    UINT32                                        DatErrChgToTgtAbt:1 ; ///<
    UINT32                                        MstAbtChgToNoErrs:1 ; ///<
    UINT32                                    DisPciCfgCpuMstAbtRsp:1 ; ///<
    UINT32                                             Reserved_6_6:1 ; ///<
    UINT32                                     SyncFloodOnTgtAbtErr:1 ; ///<
    UINT32                                            Reserved_20_8:13; ///<
    UINT32                                    SyncFloodOnCpuLeakErr:1 ; ///<
    UINT32                                           Reserved_31_22:10; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} D18F3x180_STRUCT;

// **** D18F3x188 Register Definition ****
// Address
#define D18F3x188_ADDRESS                                       0x188

// Type
#define D18F3x188_TYPE                                          TYPE_D18F3
// Field Data
#define D18F3x188_Reserved_20_0_OFFSET                          0
#define D18F3x188_Reserved_20_0_WIDTH                           21
#define D18F3x188_Reserved_20_0_MASK                            0x1fffff
#define D18F3x188_EnCpuSerWrBehindIoRd_OFFSET                   21
#define D18F3x188_EnCpuSerWrBehindIoRd_WIDTH                    1
#define D18F3x188_EnCpuSerWrBehindIoRd_MASK                     0x200000
#define D18F3x188_EnCpuSerRdBehindNpIoWr_OFFSET                 22
#define D18F3x188_EnCpuSerRdBehindNpIoWr_WIDTH                  1
#define D18F3x188_EnCpuSerRdBehindNpIoWr_MASK                   0x400000
#define D18F3x188_EnCpuSerRdBehindIoRd_OFFSET                   23
#define D18F3x188_EnCpuSerRdBehindIoRd_WIDTH                    1
#define D18F3x188_EnCpuSerRdBehindIoRd_MASK                     0x800000
#define D18F3x188_FeArbCpuWeightOverLoPrio_OFFSET               24
#define D18F3x188_FeArbCpuWeightOverLoPrio_WIDTH                4
#define D18F3x188_FeArbCpuWeightOverLoPrio_MASK                 0xf000000
#define D18F3x188_FeArbCpuWeightOverHiPrio_OFFSET               28
#define D18F3x188_FeArbCpuWeightOverHiPrio_WIDTH                4
#define D18F3x188_FeArbCpuWeightOverHiPrio_MASK                 0xf0000000

/// D18F3x188
typedef union {
  struct {                                                              ///<
    UINT32                                            Reserved_20_0:21; ///<
    UINT32                                     EnCpuSerWrBehindIoRd:1 ; ///<
    UINT32                                   EnCpuSerRdBehindNpIoWr:1 ; ///<
    UINT32                                     EnCpuSerRdBehindIoRd:1 ; ///<
    UINT32                                 FeArbCpuWeightOverLoPrio:4 ; ///<
    UINT32                                 FeArbCpuWeightOverHiPrio:4 ; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} D18F3x188_STRUCT;

// **** D18F3x1CC Register Definition ****
// Address
#define D18F3x1CC_ADDRESS                                       0x1cc

// Type
#define D18F3x1CC_TYPE                                          TYPE_D18F3
// Field Data
#define D18F3x1CC_LvtOffset_OFFSET                              0
#define D18F3x1CC_LvtOffset_WIDTH                               4
#define D18F3x1CC_LvtOffset_MASK                                0xf
#define D18F3x1CC_Reserved_7_4_OFFSET                           4
#define D18F3x1CC_Reserved_7_4_WIDTH                            4
#define D18F3x1CC_Reserved_7_4_MASK                             0xf0
#define D18F3x1CC_LvtOffsetVal_OFFSET                           8
#define D18F3x1CC_LvtOffsetVal_WIDTH                            1
#define D18F3x1CC_LvtOffsetVal_MASK                             0x100
#define D18F3x1CC_Reserved_31_9_OFFSET                          9
#define D18F3x1CC_Reserved_31_9_WIDTH                           23
#define D18F3x1CC_Reserved_31_9_MASK                            0xfffffe00

/// D18F3x1CC
typedef union {
  struct {                                                              ///<
    UINT32                                                LvtOffset:4 ; ///<
    UINT32                                             Reserved_7_4:4 ; ///<
    UINT32                                             LvtOffsetVal:1 ; ///<
    UINT32                                            Reserved_31_9:23; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} D18F3x1CC_STRUCT;

// **** D18F3x1E4 Register Definition ****
// Address
#define D18F3x1E4_ADDRESS                                       0x1e4

// Type
#define D18F3x1E4_TYPE                                          TYPE_D18F3
// Field Data
#define D18F3x1E4_Reserved_0_0_OFFSET                           0
#define D18F3x1E4_Reserved_0_0_WIDTH                            1
#define D18F3x1E4_Reserved_0_0_MASK                             0x1
#define D18F3x1E4_SbTsiDis_OFFSET                               1
#define D18F3x1E4_SbTsiDis_WIDTH                                1
#define D18F3x1E4_SbTsiDis_MASK                                 0x2
#define D18F3x1E4_Reserved_3_2_OFFSET                           2
#define D18F3x1E4_Reserved_3_2_WIDTH                            2
#define D18F3x1E4_Reserved_3_2_MASK                             0xc
#define D18F3x1E4_SbiAddr_OFFSET                                4
#define D18F3x1E4_SbiAddr_WIDTH                                 3
#define D18F3x1E4_SbiAddr_MASK                                  0x70
#define D18F3x1E4_Reserved_30_7_OFFSET                          7
#define D18F3x1E4_Reserved_30_7_WIDTH                           24
#define D18F3x1E4_Reserved_30_7_MASK                            0x7fffff80
#define D18F3x1E4_SbiRegWrDn_OFFSET                             31
#define D18F3x1E4_SbiRegWrDn_WIDTH                              1
#define D18F3x1E4_SbiRegWrDn_MASK                               0x80000000

/// D18F3x1E4
typedef union {
  struct {                                                              ///<
    UINT32                                             Reserved_0_0:1 ; ///<
    UINT32                                                 SbTsiDis:1 ; ///<
    UINT32                                             Reserved_3_2:2 ; ///<
    UINT32                                                  SbiAddr:3 ; ///<
    UINT32                                            Reserved_30_7:24; ///<
    UINT32                                               SbiRegWrDn:1 ; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} D18F3x1E4_STRUCT;

// **** D18F3x1E8 Register Definition ****
// Address
#define D18F3x1E8_ADDRESS                                       0x1e8

// Type
#define D18F3x1E8_TYPE                                          TYPE_D18F3
// Field Data
#define D18F3x1E8_SbiRegAddr_OFFSET                             0
#define D18F3x1E8_SbiRegAddr_WIDTH                              8
#define D18F3x1E8_SbiRegAddr_MASK                               0xff
#define D18F3x1E8_Reserved_31_8_OFFSET                          8
#define D18F3x1E8_Reserved_31_8_WIDTH                           24
#define D18F3x1E8_Reserved_31_8_MASK                            0xffffff00

/// D18F3x1E8
typedef union {
  struct {                                                              ///<
    UINT32                                               SbiRegAddr:8 ; ///<
    UINT32                                            Reserved_31_8:24; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} D18F3x1E8_STRUCT;

// **** D18F3x1EC Register Definition ****
// Address
#define D18F3x1EC_ADDRESS                                       0x1ec

// Type
#define D18F3x1EC_TYPE                                          TYPE_D18F3
// Field Data
#define D18F3x1EC_SbiRegDat0_OFFSET                             0
#define D18F3x1EC_SbiRegDat0_WIDTH                              8
#define D18F3x1EC_SbiRegDat0_MASK                               0xff
#define D18F3x1EC_Reserved_31_8_OFFSET                          8
#define D18F3x1EC_Reserved_31_8_WIDTH                           24
#define D18F3x1EC_Reserved_31_8_MASK                            0xffffff00

/// D18F3x1EC
typedef union {
  struct {                                                              ///<
    UINT32                                               SbiRegDat0:8 ; ///<
    UINT32                                            Reserved_31_8:24; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} D18F3x1EC_STRUCT;

// **** D18F3x1F0 Register Definition ****
// Address
#define D18F3x1F0_ADDRESS                                       0x1f0

// Type
#define D18F3x1F0_TYPE                                          TYPE_D18F3
// Field Data
#define D18F3x1F0_BrandId_OFFSET                                0
#define D18F3x1F0_BrandId_WIDTH                                 16
#define D18F3x1F0_BrandId_MASK                                  0xffff
#define D18F3x1F0_Reserved_31_16_OFFSET                         16
#define D18F3x1F0_Reserved_31_16_WIDTH                          16
#define D18F3x1F0_Reserved_31_16_MASK                           0xffff0000

/// D18F3x1F0
typedef union {
  struct {                                                              ///<
    UINT32                                                  BrandId:16; ///<
    UINT32                                           Reserved_31_16:16; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} D18F3x1F0_STRUCT;

// **** D18F4x12C Register Definition ****
// Address
#define D18F4x12C_ADDRESS                                       0x12c

// Type
#define D18F4x12C_TYPE                                          TYPE_D18F4
// Field Data
#define D18F4x12C_C6Base_39_24__OFFSET                          0
#define D18F4x12C_C6Base_39_24__WIDTH                           16
#define D18F4x12C_C6Base_39_24__MASK                            0xffff
#define D18F4x12C_Reserved_31_16_OFFSET                         16
#define D18F4x12C_Reserved_31_16_WIDTH                          16
#define D18F4x12C_Reserved_31_16_MASK                           0xffff0000

/// D18F4x12C
typedef union {
  struct {                                                              ///<
    UINT32                                            C6Base_39_24_:16; ///<
    UINT32                                           Reserved_31_16:16; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} D18F4x12C_STRUCT;

// **** D18F4x15C Register Definition ****
// Address
#define D18F4x15C_ADDRESS                                       0x15c

// Type
#define D18F4x15C_TYPE                                          TYPE_D18F4
// Field Data
#define D18F4x15C_BoostSrc_OFFSET                               0
#define D18F4x15C_BoostSrc_WIDTH                                2
#define D18F4x15C_BoostSrc_MASK                                 0x3
#define D18F4x15C_NumBoostStates_OFFSET                         2
#define D18F4x15C_NumBoostStates_WIDTH                          3
#define D18F4x15C_NumBoostStates_MASK                           0x1c
#define D18F4x15C_Reserved_27_5_OFFSET                          5
#define D18F4x15C_Reserved_27_5_WIDTH                           23
#define D18F4x15C_Reserved_27_5_MASK                            0xfffffe0
#define D18F4x15C_IgnoreBoostThresh_OFFSET                      28
#define D18F4x15C_IgnoreBoostThresh_WIDTH                       1
#define D18F4x15C_IgnoreBoostThresh_MASK                        0x10000000
#define D18F4x15C_BoostEnAllCores_OFFSET                        29
#define D18F4x15C_BoostEnAllCores_WIDTH                         1
#define D18F4x15C_BoostEnAllCores_MASK                          0x20000000
#define D18F4x15C_Reserved_31_30_OFFSET                         30
#define D18F4x15C_Reserved_31_30_WIDTH                          2
#define D18F4x15C_Reserved_31_30_MASK                           0xc0000000

/// D18F4x15C
typedef union {
  struct {                                                              ///<
    UINT32                                                 BoostSrc:2 ; ///<
    UINT32                                           NumBoostStates:3 ; ///<
    UINT32                                            Reserved_27_5:23; ///<
    UINT32                                        IgnoreBoostThresh:1 ; ///<
    UINT32                                          BoostEnAllCores:1 ; ///<
    UINT32                                           Reserved_31_30:2 ; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} D18F4x15C_STRUCT;

// **** D18F6x90 Register Definition ****
// Address
#define D18F6x90_ADDRESS                                        0x90

// Type
#define D18F6x90_TYPE                                           TYPE_D18F6
// Field Data
#define D18F6x90_NbPs1NclkDiv_OFFSET                            0
#define D18F6x90_NbPs1NclkDiv_WIDTH                             7
#define D18F6x90_NbPs1NclkDiv_MASK                              0x7f
#define D18F6x90_Reserved_7_7_OFFSET                            7
#define D18F6x90_Reserved_7_7_WIDTH                             1
#define D18F6x90_Reserved_7_7_MASK                              0x80
#define D18F6x90_NbPs1Vid_OFFSET                                8
#define D18F6x90_NbPs1Vid_WIDTH                                 7
#define D18F6x90_NbPs1Vid_MASK                                  0x7f00
#define D18F6x90_Reserved_15_15_OFFSET                          15
#define D18F6x90_Reserved_15_15_WIDTH                           1
#define D18F6x90_Reserved_15_15_MASK                            0x8000
#define D18F6x90_NbPs1GnbSlowIgn_OFFSET                         16
#define D18F6x90_NbPs1GnbSlowIgn_WIDTH                          1
#define D18F6x90_NbPs1GnbSlowIgn_MASK                           0x10000
#define D18F6x90_Reserved_19_17_OFFSET                          17
#define D18F6x90_Reserved_19_17_WIDTH                           3
#define D18F6x90_Reserved_19_17_MASK                            0xe0000
#define D18F6x90_NbPsLock_OFFSET                                20
#define D18F6x90_NbPsLock_WIDTH                                 1
#define D18F6x90_NbPsLock_MASK                                  0x100000
#define D18F6x90_Reserved_27_21_OFFSET                          21
#define D18F6x90_Reserved_27_21_WIDTH                           7
#define D18F6x90_Reserved_27_21_MASK                            0xfe00000
#define D18F6x90_NbPsForceReq_OFFSET                            28
#define D18F6x90_NbPsForceReq_WIDTH                             1
#define D18F6x90_NbPsForceReq_MASK                              0x10000000
#define D18F6x90_NbPsForceSel_OFFSET                            29
#define D18F6x90_NbPsForceSel_WIDTH                             1
#define D18F6x90_NbPsForceSel_MASK                              0x20000000
#define D18F6x90_NbPsCtrlDis_OFFSET                             30
#define D18F6x90_NbPsCtrlDis_WIDTH                              1
#define D18F6x90_NbPsCtrlDis_MASK                               0x40000000
#define D18F6x90_NbPsCap_OFFSET                                 31
#define D18F6x90_NbPsCap_WIDTH                                  1
#define D18F6x90_NbPsCap_MASK                                   0x80000000

/// D18F6x90
typedef union {
  struct {                                                              ///<
    UINT32                                             NbPs1NclkDiv:7 ; ///<
    UINT32                                             Reserved_7_7:1 ; ///<
    UINT32                                                 NbPs1Vid:7 ; ///<
    UINT32                                           Reserved_15_15:1 ; ///<
    UINT32                                          NbPs1GnbSlowIgn:1 ; ///<
    UINT32                                           Reserved_19_17:3 ; ///<
    UINT32                                                 NbPsLock:1 ; ///<
    UINT32                                           Reserved_27_21:7 ; ///<
    UINT32                                             NbPsForceReq:1 ; ///<
    UINT32                                             NbPsForceSel:1 ; ///<
    UINT32                                              NbPsCtrlDis:1 ; ///<
    UINT32                                                  NbPsCap:1 ; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} D18F6x90_STRUCT;

// **** D18F6x94 Register Definition ****
// Address
#define D18F6x94_ADDRESS                                        0x94

// Type
#define D18F6x94_TYPE                                           TYPE_D18F6
// Field Data
#define D18F6x94_CpuPstateThr_OFFSET                            0
#define D18F6x94_CpuPstateThr_WIDTH                             3
#define D18F6x94_CpuPstateThr_MASK                              0x7
#define D18F6x94_CpuPstateThrEn_OFFSET                          3
#define D18F6x94_CpuPstateThrEn_WIDTH                           1
#define D18F6x94_CpuPstateThrEn_MASK                            0x8
#define D18F6x94_NbPs1NoTransOnDma_OFFSET                       4
#define D18F6x94_NbPs1NoTransOnDma_WIDTH                        1
#define D18F6x94_NbPs1NoTransOnDma_MASK                         0x10
#define D18F6x94_Reserved_19_5_OFFSET                           5
#define D18F6x94_Reserved_19_5_WIDTH                            15
#define D18F6x94_Reserved_19_5_MASK                             0xfffe0
#define D18F6x94_NbPsNonC0Timer_OFFSET                          20
#define D18F6x94_NbPsNonC0Timer_WIDTH                           3
#define D18F6x94_NbPsNonC0Timer_MASK                            0x700000
#define D18F6x94_NbPsC0Timer_OFFSET                             23
#define D18F6x94_NbPsC0Timer_WIDTH                              3
#define D18F6x94_NbPsC0Timer_MASK                               0x3800000
#define D18F6x94_NbPs1ResTmrMin_OFFSET                          26
#define D18F6x94_NbPs1ResTmrMin_WIDTH                           3
#define D18F6x94_NbPs1ResTmrMin_MASK                            0x1c000000
#define D18F6x94_NbPs0ResTmrMin_OFFSET                          29
#define D18F6x94_NbPs0ResTmrMin_WIDTH                           3
#define D18F6x94_NbPs0ResTmrMin_MASK                            0xe0000000

/// D18F6x94
typedef union {
  struct {                                                              ///<
    UINT32                                             CpuPstateThr:3 ; ///<
    UINT32                                           CpuPstateThrEn:1 ; ///<
    UINT32                                        NbPs1NoTransOnDma:1 ; ///<
    UINT32                                            Reserved_19_5:15; ///<
    UINT32                                           NbPsNonC0Timer:3 ; ///<
    UINT32                                              NbPsC0Timer:3 ; ///<
    UINT32                                           NbPs1ResTmrMin:3 ; ///<
    UINT32                                           NbPs0ResTmrMin:3 ; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} D18F6x94_STRUCT;

// **** D18F6x98 Register Definition ****
// Address
#define D18F6x98_ADDRESS                                        0x98

// Type
#define D18F6x98_TYPE                                           TYPE_D18F6
// Field Data
#define D18F6x98_NbPsTransInFlight_OFFSET                       0
#define D18F6x98_NbPsTransInFlight_WIDTH                        1
#define D18F6x98_NbPsTransInFlight_MASK                         0x1
#define D18F6x98_NbPs1ActSts_OFFSET                             1
#define D18F6x98_NbPs1ActSts_WIDTH                              1
#define D18F6x98_NbPs1ActSts_MASK                               0x2
#define D18F6x98_NbPs1Act_OFFSET                                2
#define D18F6x98_NbPs1Act_WIDTH                                 1
#define D18F6x98_NbPs1Act_MASK                                  0x4
#define D18F6x98_Reserved_29_3_OFFSET                           3
#define D18F6x98_Reserved_29_3_WIDTH                            27
#define D18F6x98_Reserved_29_3_MASK                             0x3ffffff8
#define D18F6x98_NbPsCsrAccSel_OFFSET                           30
#define D18F6x98_NbPsCsrAccSel_WIDTH                            1
#define D18F6x98_NbPsCsrAccSel_MASK                             0x40000000
#define D18F6x98_NbPsDbgEn_OFFSET                               31
#define D18F6x98_NbPsDbgEn_WIDTH                                1
#define D18F6x98_NbPsDbgEn_MASK                                 0x80000000

/// D18F6x98
typedef union {
  struct {                                                              ///<
    UINT32                                        NbPsTransInFlight:1 ; ///<
    UINT32                                              NbPs1ActSts:1 ; ///<
    UINT32                                                 NbPs1Act:1 ; ///<
    UINT32                                            Reserved_29_3:27; ///<
    UINT32                                            NbPsCsrAccSel:1 ; ///<
    UINT32                                                NbPsDbgEn:1 ; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} D18F6x98_STRUCT;

// **** D18F6x9C Register Definition ****
// Address
#define D18F6x9C_ADDRESS                                        0x9c

// Type
#define D18F6x9C_TYPE                                           TYPE_D18F6
// Field Data
#define D18F6x9C_NclkRedDiv_OFFSET                              0
#define D18F6x9C_NclkRedDiv_WIDTH                               7
#define D18F6x9C_NclkRedDiv_MASK                                0x7f
#define D18F6x9C_NclkRedSelfRefrAlways_OFFSET                   7
#define D18F6x9C_NclkRedSelfRefrAlways_WIDTH                    1
#define D18F6x9C_NclkRedSelfRefrAlways_MASK                     0x80
#define D18F6x9C_NclkRampWithDllRelock_OFFSET                   8
#define D18F6x9C_NclkRampWithDllRelock_WIDTH                    1
#define D18F6x9C_NclkRampWithDllRelock_MASK                     0x100
#define D18F6x9C_Reserved_31_9_OFFSET                           9
#define D18F6x9C_Reserved_31_9_WIDTH                            23
#define D18F6x9C_Reserved_31_9_MASK                             0xfffffe00

/// D18F6x9C
typedef union {
  struct {                                                              ///<
    UINT32                                               NclkRedDiv:7 ; ///<
    UINT32                                    NclkRedSelfRefrAlways:1 ; ///<
    UINT32                                    NclkRampWithDllRelock:1 ; ///<
    UINT32                                            Reserved_31_9:23; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} D18F6x9C_STRUCT;

// **** DxF0x00 Register Definition ****
// Address
#define DxF0x00_ADDRESS                                         0x0

// Type
#define DxF0x00_TYPE                                            TYPE_D4F0
// Field Data
#define DxF0x00_VendorID_OFFSET                                 0
#define DxF0x00_VendorID_WIDTH                                  16
#define DxF0x00_VendorID_MASK                                   0xffff
#define DxF0x00_DeviceID_OFFSET                                 16
#define DxF0x00_DeviceID_WIDTH                                  16
#define DxF0x00_DeviceID_MASK                                   0xffff0000

/// DxF0x00
typedef union {
  struct {                                                              ///<
    UINT32                                                 VendorID:16; ///<
    UINT32                                                 DeviceID:16; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} DxF0x00_STRUCT;

// **** DxF0x04 Register Definition ****
// Address
#define DxF0x04_ADDRESS                                         0x4

// Type
#define DxF0x04_TYPE                                            TYPE_D4F0
// Field Data
#define DxF0x04_IoAccessEn_OFFSET                               0
#define DxF0x04_IoAccessEn_WIDTH                                1
#define DxF0x04_IoAccessEn_MASK                                 0x1
#define DxF0x04_MemAccessEn_OFFSET                              1
#define DxF0x04_MemAccessEn_WIDTH                               1
#define DxF0x04_MemAccessEn_MASK                                0x2
#define DxF0x04_BusMasterEn_OFFSET                              2
#define DxF0x04_BusMasterEn_WIDTH                               1
#define DxF0x04_BusMasterEn_MASK                                0x4
#define DxF0x04_SpecialCycleEn_OFFSET                           3
#define DxF0x04_SpecialCycleEn_WIDTH                            1
#define DxF0x04_SpecialCycleEn_MASK                             0x8
#define DxF0x04_MemWriteInvalidateEn_OFFSET                     4
#define DxF0x04_MemWriteInvalidateEn_WIDTH                      1
#define DxF0x04_MemWriteInvalidateEn_MASK                       0x10
#define DxF0x04_PalSnoopEn_OFFSET                               5
#define DxF0x04_PalSnoopEn_WIDTH                                1
#define DxF0x04_PalSnoopEn_MASK                                 0x20
#define DxF0x04_ParityErrorEn_OFFSET                            6
#define DxF0x04_ParityErrorEn_WIDTH                             1
#define DxF0x04_ParityErrorEn_MASK                              0x40
#define DxF0x04_IdselStepping_OFFSET                            7
#define DxF0x04_IdselStepping_WIDTH                             1
#define DxF0x04_IdselStepping_MASK                              0x80
#define DxF0x04_SerrEn_OFFSET                                   8
#define DxF0x04_SerrEn_WIDTH                                    1
#define DxF0x04_SerrEn_MASK                                     0x100
#define DxF0x04_FastB2BEn_OFFSET                                9
#define DxF0x04_FastB2BEn_WIDTH                                 1
#define DxF0x04_FastB2BEn_MASK                                  0x200
#define DxF0x04_IntDis_OFFSET                                   10
#define DxF0x04_IntDis_WIDTH                                    1
#define DxF0x04_IntDis_MASK                                     0x400
#define DxF0x04_Reserved_18_11_OFFSET                           11
#define DxF0x04_Reserved_18_11_WIDTH                            8
#define DxF0x04_Reserved_18_11_MASK                             0x7f800
#define DxF0x04_IntStatus_OFFSET                                19
#define DxF0x04_IntStatus_WIDTH                                 1
#define DxF0x04_IntStatus_MASK                                  0x80000
#define DxF0x04_CapList_OFFSET                                  20
#define DxF0x04_CapList_WIDTH                                   1
#define DxF0x04_CapList_MASK                                    0x100000
#define DxF0x04_PCI66En_OFFSET                                  21
#define DxF0x04_PCI66En_WIDTH                                   1
#define DxF0x04_PCI66En_MASK                                    0x200000
#define DxF0x04_Reserved_22_22_OFFSET                           22
#define DxF0x04_Reserved_22_22_WIDTH                            1
#define DxF0x04_Reserved_22_22_MASK                             0x400000
#define DxF0x04_FastBackCapable_OFFSET                          23
#define DxF0x04_FastBackCapable_WIDTH                           1
#define DxF0x04_FastBackCapable_MASK                            0x800000
#define DxF0x04_MasterDataPerr_OFFSET                           24
#define DxF0x04_MasterDataPerr_WIDTH                            1
#define DxF0x04_MasterDataPerr_MASK                             0x1000000
#define DxF0x04_DevselTiming_OFFSET                             25
#define DxF0x04_DevselTiming_WIDTH                              2
#define DxF0x04_DevselTiming_MASK                               0x6000000
#define DxF0x04_SignaledTargetAbort_OFFSET                      27
#define DxF0x04_SignaledTargetAbort_WIDTH                       1
#define DxF0x04_SignaledTargetAbort_MASK                        0x8000000
#define DxF0x04_ReceivedTargetAbort_OFFSET                      28
#define DxF0x04_ReceivedTargetAbort_WIDTH                       1
#define DxF0x04_ReceivedTargetAbort_MASK                        0x10000000
#define DxF0x04_ReceivedMasterAbort_OFFSET                      29
#define DxF0x04_ReceivedMasterAbort_WIDTH                       1
#define DxF0x04_ReceivedMasterAbort_MASK                        0x20000000
#define DxF0x04_SignaledSystemError_OFFSET                      30
#define DxF0x04_SignaledSystemError_WIDTH                       1
#define DxF0x04_SignaledSystemError_MASK                        0x40000000
#define DxF0x04_ParityErrorDetected_OFFSET                      31
#define DxF0x04_ParityErrorDetected_WIDTH                       1
#define DxF0x04_ParityErrorDetected_MASK                        0x80000000

/// DxF0x04
typedef union {
  struct {                                                              ///<
    UINT32                                               IoAccessEn:1 ; ///<
    UINT32                                              MemAccessEn:1 ; ///<
    UINT32                                              BusMasterEn:1 ; ///<
    UINT32                                           SpecialCycleEn:1 ; ///<
    UINT32                                     MemWriteInvalidateEn:1 ; ///<
    UINT32                                               PalSnoopEn:1 ; ///<
    UINT32                                            ParityErrorEn:1 ; ///<
    UINT32                                            IdselStepping:1 ; ///<
    UINT32                                                   SerrEn:1 ; ///<
    UINT32                                                FastB2BEn:1 ; ///<
    UINT32                                                   IntDis:1 ; ///<
    UINT32                                           Reserved_18_11:8 ; ///<
    UINT32                                                IntStatus:1 ; ///<
    UINT32                                                  CapList:1 ; ///<
    UINT32                                                  PCI66En:1 ; ///<
    UINT32                                           Reserved_22_22:1 ; ///<
    UINT32                                          FastBackCapable:1 ; ///<
    UINT32                                           MasterDataPerr:1 ; ///<
    UINT32                                             DevselTiming:2 ; ///<
    UINT32                                      SignaledTargetAbort:1 ; ///<
    UINT32                                      ReceivedTargetAbort:1 ; ///<
    UINT32                                      ReceivedMasterAbort:1 ; ///<
    UINT32                                      SignaledSystemError:1 ; ///<
    UINT32                                      ParityErrorDetected:1 ; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} DxF0x04_STRUCT;

// **** DxF0x08 Register Definition ****
// Address
#define DxF0x08_ADDRESS                                         0x8

// Type
#define DxF0x08_TYPE                                            TYPE_D4F0
// Field Data
#define DxF0x08_RevID_OFFSET                                    0
#define DxF0x08_RevID_WIDTH                                     8
#define DxF0x08_RevID_MASK                                      0xff
#define DxF0x08_ClassCode_OFFSET                                8
#define DxF0x08_ClassCode_WIDTH                                 24
#define DxF0x08_ClassCode_MASK                                  0xffffff00

/// DxF0x08
typedef union {
  struct {                                                              ///<
    UINT32                                                    RevID:8 ; ///<
    UINT32                                                ClassCode:24; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} DxF0x08_STRUCT;

// **** DxF0x0C Register Definition ****
// Address
#define DxF0x0C_ADDRESS                                         0xc

// Type
#define DxF0x0C_TYPE                                            TYPE_D4F0
// Field Data
#define DxF0x0C_CacheLineSize_OFFSET                            0
#define DxF0x0C_CacheLineSize_WIDTH                             8
#define DxF0x0C_CacheLineSize_MASK                              0xff
#define DxF0x0C_LatencyTimer_OFFSET                             8
#define DxF0x0C_LatencyTimer_WIDTH                              8
#define DxF0x0C_LatencyTimer_MASK                               0xff00
#define DxF0x0C_HeaderTypeReg_OFFSET                            16
#define DxF0x0C_HeaderTypeReg_WIDTH                             8
#define DxF0x0C_HeaderTypeReg_MASK                              0xff0000
#define DxF0x0C_BIST_OFFSET                                     24
#define DxF0x0C_BIST_WIDTH                                      8
#define DxF0x0C_BIST_MASK                                       0xff000000

/// DxF0x0C
typedef union {
  struct {                                                              ///<
    UINT32                                            CacheLineSize:8 ; ///<
    UINT32                                             LatencyTimer:8 ; ///<
    UINT32                                            HeaderTypeReg:8 ; ///<
    UINT32                                                     BIST:8 ; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} DxF0x0C_STRUCT;

// **** DxF0x18 Register Definition ****
// Address
#define DxF0x18_ADDRESS                                         0x18

// Type
#define DxF0x18_TYPE                                            TYPE_D4F0
// Field Data
#define DxF0x18_PrimaryBus_OFFSET                               0
#define DxF0x18_PrimaryBus_WIDTH                                8
#define DxF0x18_PrimaryBus_MASK                                 0xff
#define DxF0x18_SecondaryBus_OFFSET                             8
#define DxF0x18_SecondaryBus_WIDTH                              8
#define DxF0x18_SecondaryBus_MASK                               0xff00
#define DxF0x18_SubBusNumber_OFFSET                             16
#define DxF0x18_SubBusNumber_WIDTH                              8
#define DxF0x18_SubBusNumber_MASK                               0xff0000
#define DxF0x18_SecondaryLatencyTimer_OFFSET                    24
#define DxF0x18_SecondaryLatencyTimer_WIDTH                     8
#define DxF0x18_SecondaryLatencyTimer_MASK                      0xff000000

/// DxF0x18
typedef union {
  struct {                                                              ///<
    UINT32                                               PrimaryBus:8 ; ///<
    UINT32                                             SecondaryBus:8 ; ///<
    UINT32                                             SubBusNumber:8 ; ///<
    UINT32                                    SecondaryLatencyTimer:8 ; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} DxF0x18_STRUCT;

// **** DxF0x1C Register Definition ****
// Address
#define DxF0x1C_ADDRESS                                         0x1c

// Type
#define DxF0x1C_TYPE                                            TYPE_D4F0
// Field Data
#define DxF0x1C_Reserved_3_0_OFFSET                             0
#define DxF0x1C_Reserved_3_0_WIDTH                              4
#define DxF0x1C_Reserved_3_0_MASK                               0xf
#define DxF0x1C_IOBase_15_12__OFFSET                            4
#define DxF0x1C_IOBase_15_12__WIDTH                             4
#define DxF0x1C_IOBase_15_12__MASK                              0xf0
#define DxF0x1C_Reserved_11_8_OFFSET                            8
#define DxF0x1C_Reserved_11_8_WIDTH                             4
#define DxF0x1C_Reserved_11_8_MASK                              0xf00
#define DxF0x1C_IOLimit_15_12__OFFSET                           12
#define DxF0x1C_IOLimit_15_12__WIDTH                            4
#define DxF0x1C_IOLimit_15_12__MASK                             0xf000
#define DxF0x1C_Reserved_20_16_OFFSET                           16
#define DxF0x1C_Reserved_20_16_WIDTH                            5
#define DxF0x1C_Reserved_20_16_MASK                             0x1f0000
#define DxF0x1C_PCI66En_OFFSET                                  21
#define DxF0x1C_PCI66En_WIDTH                                   1
#define DxF0x1C_PCI66En_MASK                                    0x200000
#define DxF0x1C_Reserved_22_22_OFFSET                           22
#define DxF0x1C_Reserved_22_22_WIDTH                            1
#define DxF0x1C_Reserved_22_22_MASK                             0x400000
#define DxF0x1C_FastBackCapable_OFFSET                          23
#define DxF0x1C_FastBackCapable_WIDTH                           1
#define DxF0x1C_FastBackCapable_MASK                            0x800000
#define DxF0x1C_MasterDataPerr_OFFSET                           24
#define DxF0x1C_MasterDataPerr_WIDTH                            1
#define DxF0x1C_MasterDataPerr_MASK                             0x1000000
#define DxF0x1C_DevselTiming_OFFSET                             25
#define DxF0x1C_DevselTiming_WIDTH                              2
#define DxF0x1C_DevselTiming_MASK                               0x6000000
#define DxF0x1C_SignalTargetAbort_OFFSET                        27
#define DxF0x1C_SignalTargetAbort_WIDTH                         1
#define DxF0x1C_SignalTargetAbort_MASK                          0x8000000
#define DxF0x1C_ReceivedTargetAbort_OFFSET                      28
#define DxF0x1C_ReceivedTargetAbort_WIDTH                       1
#define DxF0x1C_ReceivedTargetAbort_MASK                        0x10000000
#define DxF0x1C_ReceivedMasterAbort_OFFSET                      29
#define DxF0x1C_ReceivedMasterAbort_WIDTH                       1
#define DxF0x1C_ReceivedMasterAbort_MASK                        0x20000000
#define DxF0x1C_ReceivedSystemError_OFFSET                      30
#define DxF0x1C_ReceivedSystemError_WIDTH                       1
#define DxF0x1C_ReceivedSystemError_MASK                        0x40000000
#define DxF0x1C_ParityErrorDetected_OFFSET                      31
#define DxF0x1C_ParityErrorDetected_WIDTH                       1
#define DxF0x1C_ParityErrorDetected_MASK                        0x80000000

/// DxF0x1C
typedef union {
  struct {                                                              ///<
    UINT32                                             Reserved_3_0:4 ; ///<
    UINT32                                            IOBase_15_12_:4 ; ///<
    UINT32                                            Reserved_11_8:4 ; ///<
    UINT32                                           IOLimit_15_12_:4 ; ///<
    UINT32                                           Reserved_20_16:5 ; ///<
    UINT32                                                  PCI66En:1 ; ///<
    UINT32                                           Reserved_22_22:1 ; ///<
    UINT32                                          FastBackCapable:1 ; ///<
    UINT32                                           MasterDataPerr:1 ; ///<
    UINT32                                             DevselTiming:2 ; ///<
    UINT32                                        SignalTargetAbort:1 ; ///<
    UINT32                                      ReceivedTargetAbort:1 ; ///<
    UINT32                                      ReceivedMasterAbort:1 ; ///<
    UINT32                                      ReceivedSystemError:1 ; ///<
    UINT32                                      ParityErrorDetected:1 ; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} DxF0x1C_STRUCT;

// **** DxF0x20 Register Definition ****
// Address
#define DxF0x20_ADDRESS                                         0x20

// Type
#define DxF0x20_TYPE                                            TYPE_D4F0
// Field Data
#define DxF0x20_Reserved_3_0_OFFSET                             0
#define DxF0x20_Reserved_3_0_WIDTH                              4
#define DxF0x20_Reserved_3_0_MASK                               0xf
#define DxF0x20_MemBase_OFFSET                                  4
#define DxF0x20_MemBase_WIDTH                                   12
#define DxF0x20_MemBase_MASK                                    0xfff0
#define DxF0x20_Reserved_19_16_OFFSET                           16
#define DxF0x20_Reserved_19_16_WIDTH                            4
#define DxF0x20_Reserved_19_16_MASK                             0xf0000
#define DxF0x20_MemLimit_OFFSET                                 20
#define DxF0x20_MemLimit_WIDTH                                  12
#define DxF0x20_MemLimit_MASK                                   0xfff00000

/// DxF0x20
typedef union {
  struct {                                                              ///<
    UINT32                                             Reserved_3_0:4 ; ///<
    UINT32                                                  MemBase:12; ///<
    UINT32                                           Reserved_19_16:4 ; ///<
    UINT32                                                 MemLimit:12; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} DxF0x20_STRUCT;

// **** DxF0x24 Register Definition ****
// Address
#define DxF0x24_ADDRESS                                         0x24

// Type
#define DxF0x24_TYPE                                            TYPE_D4F0
// Field Data
#define DxF0x24_PrefMemBaseR_OFFSET                             0
#define DxF0x24_PrefMemBaseR_WIDTH                              4
#define DxF0x24_PrefMemBaseR_MASK                               0xf
#define DxF0x24_PrefMemBase_31_20__OFFSET                       4
#define DxF0x24_PrefMemBase_31_20__WIDTH                        12
#define DxF0x24_PrefMemBase_31_20__MASK                         0xfff0
#define DxF0x24_PrefMemLimitR_OFFSET                            16
#define DxF0x24_PrefMemLimitR_WIDTH                             4
#define DxF0x24_PrefMemLimitR_MASK                              0xf0000
#define DxF0x24_PrefMemLimit_OFFSET                             20
#define DxF0x24_PrefMemLimit_WIDTH                              12
#define DxF0x24_PrefMemLimit_MASK                               0xfff00000

/// DxF0x24
typedef union {
  struct {                                                              ///<
    UINT32                                             PrefMemBaseR:4 ; ///<
    UINT32                                       PrefMemBase_31_20_:12; ///<
    UINT32                                            PrefMemLimitR:4 ; ///<
    UINT32                                             PrefMemLimit:12; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} DxF0x24_STRUCT;

// **** DxF0x28 Register Definition ****
// Address
#define DxF0x28_ADDRESS                                         0x28

// Type
#define DxF0x28_TYPE                                            TYPE_D4F0
// Field Data
#define DxF0x28_PrefMemBase_63_32__OFFSET                       0
#define DxF0x28_PrefMemBase_63_32__WIDTH                        32
#define DxF0x28_PrefMemBase_63_32__MASK                         0xffffffff

/// DxF0x28
typedef union {
  struct {                                                              ///<
    UINT32                                       PrefMemBase_63_32_:32; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} DxF0x28_STRUCT;

// **** DxF0x2C Register Definition ****
// Address
#define DxF0x2C_ADDRESS                                         0x2c

// Type
#define DxF0x2C_TYPE                                            TYPE_D4F0
// Field Data
#define DxF0x2C_PrefMemLimit_63_32__OFFSET                      0
#define DxF0x2C_PrefMemLimit_63_32__WIDTH                       32
#define DxF0x2C_PrefMemLimit_63_32__MASK                        0xffffffff

/// DxF0x2C
typedef union {
  struct {                                                              ///<
    UINT32                                      PrefMemLimit_63_32_:32; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} DxF0x2C_STRUCT;

// **** DxF0x30 Register Definition ****
// Address
#define DxF0x30_ADDRESS                                         0x30

// Type
#define DxF0x30_TYPE                                            TYPE_D4F0
// Field Data
#define DxF0x30_IOBase_31_16__OFFSET                            0
#define DxF0x30_IOBase_31_16__WIDTH                             16
#define DxF0x30_IOBase_31_16__MASK                              0xffff
#define DxF0x30_IOLimit_31_16__OFFSET                           16
#define DxF0x30_IOLimit_31_16__WIDTH                            16
#define DxF0x30_IOLimit_31_16__MASK                             0xffff0000

/// DxF0x30
typedef union {
  struct {                                                              ///<
    UINT32                                            IOBase_31_16_:16; ///<
    UINT32                                           IOLimit_31_16_:16; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} DxF0x30_STRUCT;

// **** DxF0x34 Register Definition ****
// Address
#define DxF0x34_ADDRESS                                         0x34

// Type
#define DxF0x34_TYPE                                            TYPE_D4F0
// Field Data
#define DxF0x34_CapPtr_OFFSET                                   0
#define DxF0x34_CapPtr_WIDTH                                    8
#define DxF0x34_CapPtr_MASK                                     0xff
#define DxF0x34_Reserved_31_8_OFFSET                            8
#define DxF0x34_Reserved_31_8_WIDTH                             24
#define DxF0x34_Reserved_31_8_MASK                              0xffffff00

/// DxF0x34
typedef union {
  struct {                                                              ///<
    UINT32                                                   CapPtr:8 ; ///<
    UINT32                                            Reserved_31_8:24; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} DxF0x34_STRUCT;

// **** DxF0x3C Register Definition ****
// Address
#define DxF0x3C_ADDRESS                                         0x3c

// Type
#define DxF0x3C_TYPE                                            TYPE_D4F0
// Field Data
#define DxF0x3C_IntLine_OFFSET                                  0
#define DxF0x3C_IntLine_WIDTH                                   8
#define DxF0x3C_IntLine_MASK                                    0xff
#define DxF0x3C_IntPin_OFFSET                                   8
#define DxF0x3C_IntPin_WIDTH                                    3
#define DxF0x3C_IntPin_MASK                                     0x700
#define DxF0x3C_IntPinR_OFFSET                                  11
#define DxF0x3C_IntPinR_WIDTH                                   5
#define DxF0x3C_IntPinR_MASK                                    0xf800
#define DxF0x3C_ParityResponseEn_OFFSET                         16
#define DxF0x3C_ParityResponseEn_WIDTH                          1
#define DxF0x3C_ParityResponseEn_MASK                           0x10000
#define DxF0x3C_SerrEn_OFFSET                                   17
#define DxF0x3C_SerrEn_WIDTH                                    1
#define DxF0x3C_SerrEn_MASK                                     0x20000
#define DxF0x3C_IsaEn_OFFSET                                    18
#define DxF0x3C_IsaEn_WIDTH                                     1
#define DxF0x3C_IsaEn_MASK                                      0x40000
#define DxF0x3C_VgaEn_OFFSET                                    19
#define DxF0x3C_VgaEn_WIDTH                                     1
#define DxF0x3C_VgaEn_MASK                                      0x80000
#define DxF0x3C_Vga16En_OFFSET                                  20
#define DxF0x3C_Vga16En_WIDTH                                   1
#define DxF0x3C_Vga16En_MASK                                    0x100000
#define DxF0x3C_MasterAbortMode_OFFSET                          21
#define DxF0x3C_MasterAbortMode_WIDTH                           1
#define DxF0x3C_MasterAbortMode_MASK                            0x200000
#define DxF0x3C_SecondaryBusReset_OFFSET                        22
#define DxF0x3C_SecondaryBusReset_WIDTH                         1
#define DxF0x3C_SecondaryBusReset_MASK                          0x400000
#define DxF0x3C_FastB2BCap_OFFSET                               23
#define DxF0x3C_FastB2BCap_WIDTH                                1
#define DxF0x3C_FastB2BCap_MASK                                 0x800000
#define DxF0x3C_Reserved_31_24_OFFSET                           24
#define DxF0x3C_Reserved_31_24_WIDTH                            8
#define DxF0x3C_Reserved_31_24_MASK                             0xff000000

/// DxF0x3C
typedef union {
  struct {                                                              ///<
    UINT32                                                  IntLine:8 ; ///<
    UINT32                                                   IntPin:3 ; ///<
    UINT32                                                  IntPinR:5 ; ///<
    UINT32                                         ParityResponseEn:1 ; ///<
    UINT32                                                   SerrEn:1 ; ///<
    UINT32                                                    IsaEn:1 ; ///<
    UINT32                                                    VgaEn:1 ; ///<
    UINT32                                                  Vga16En:1 ; ///<
    UINT32                                          MasterAbortMode:1 ; ///<
    UINT32                                        SecondaryBusReset:1 ; ///<
    UINT32                                               FastB2BCap:1 ; ///<
    UINT32                                           Reserved_31_24:8 ; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} DxF0x3C_STRUCT;

// **** DxF0x50 Register Definition ****
// Address
#define DxF0x50_ADDRESS                                         0x50

// Type
#define DxF0x50_TYPE                                            TYPE_D4F0
// Field Data
#define DxF0x50_CapID_OFFSET                                    0
#define DxF0x50_CapID_WIDTH                                     8
#define DxF0x50_CapID_MASK                                      0xff
#define DxF0x50_NextPtr_OFFSET                                  8
#define DxF0x50_NextPtr_WIDTH                                   8
#define DxF0x50_NextPtr_MASK                                    0xff00
#define DxF0x50_Version_OFFSET                                  16
#define DxF0x50_Version_WIDTH                                   3
#define DxF0x50_Version_MASK                                    0x70000
#define DxF0x50_PmeClock_OFFSET                                 19
#define DxF0x50_PmeClock_WIDTH                                  1
#define DxF0x50_PmeClock_MASK                                   0x80000
#define DxF0x50_Reserved_20_20_OFFSET                           20
#define DxF0x50_Reserved_20_20_WIDTH                            1
#define DxF0x50_Reserved_20_20_MASK                             0x100000
#define DxF0x50_DevSpecificInit_OFFSET                          21
#define DxF0x50_DevSpecificInit_WIDTH                           1
#define DxF0x50_DevSpecificInit_MASK                            0x200000
#define DxF0x50_AuxCurrent_OFFSET                               22
#define DxF0x50_AuxCurrent_WIDTH                                3
#define DxF0x50_AuxCurrent_MASK                                 0x1c00000
#define DxF0x50_D1Support_OFFSET                                25
#define DxF0x50_D1Support_WIDTH                                 1
#define DxF0x50_D1Support_MASK                                  0x2000000
#define DxF0x50_D2Support_OFFSET                                26
#define DxF0x50_D2Support_WIDTH                                 1
#define DxF0x50_D2Support_MASK                                  0x4000000
#define DxF0x50_PmeSupport_OFFSET                               27
#define DxF0x50_PmeSupport_WIDTH                                5
#define DxF0x50_PmeSupport_MASK                                 0xf8000000

/// DxF0x50
typedef union {
  struct {                                                              ///<
    UINT32                                                    CapID:8 ; ///<
    UINT32                                                  NextPtr:8 ; ///<
    UINT32                                                  Version:3 ; ///<
    UINT32                                                 PmeClock:1 ; ///<
    UINT32                                           Reserved_20_20:1 ; ///<
    UINT32                                          DevSpecificInit:1 ; ///<
    UINT32                                               AuxCurrent:3 ; ///<
    UINT32                                                D1Support:1 ; ///<
    UINT32                                                D2Support:1 ; ///<
    UINT32                                               PmeSupport:5 ; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} DxF0x50_STRUCT;

// **** DxF0x54 Register Definition ****
// Address
#define DxF0x54_ADDRESS                                         0x54

// Type
#define DxF0x54_TYPE                                            TYPE_D4F0
// Field Data
#define DxF0x54_PowerState_OFFSET                               0
#define DxF0x54_PowerState_WIDTH                                2
#define DxF0x54_PowerState_MASK                                 0x3
#define DxF0x54_Reserved_2_2_OFFSET                             2
#define DxF0x54_Reserved_2_2_WIDTH                              1
#define DxF0x54_Reserved_2_2_MASK                               0x4
#define DxF0x54_NoSoftReset_OFFSET                              3
#define DxF0x54_NoSoftReset_WIDTH                               1
#define DxF0x54_NoSoftReset_MASK                                0x8
#define DxF0x54_Reserved_7_4_OFFSET                             4
#define DxF0x54_Reserved_7_4_WIDTH                              4
#define DxF0x54_Reserved_7_4_MASK                               0xf0
#define DxF0x54_PmeEn_OFFSET                                    8
#define DxF0x54_PmeEn_WIDTH                                     1
#define DxF0x54_PmeEn_MASK                                      0x100
#define DxF0x54_DataSelect_OFFSET                               9
#define DxF0x54_DataSelect_WIDTH                                4
#define DxF0x54_DataSelect_MASK                                 0x1e00
#define DxF0x54_DataScale_OFFSET                                13
#define DxF0x54_DataScale_WIDTH                                 2
#define DxF0x54_DataScale_MASK                                  0x6000
#define DxF0x54_PmeStatus_OFFSET                                15
#define DxF0x54_PmeStatus_WIDTH                                 1
#define DxF0x54_PmeStatus_MASK                                  0x8000
#define DxF0x54_Reserved_21_16_OFFSET                           16
#define DxF0x54_Reserved_21_16_WIDTH                            6
#define DxF0x54_Reserved_21_16_MASK                             0x3f0000
#define DxF0x54_B2B3Support_OFFSET                              22
#define DxF0x54_B2B3Support_WIDTH                               1
#define DxF0x54_B2B3Support_MASK                                0x400000
#define DxF0x54_BusPwrEn_OFFSET                                 23
#define DxF0x54_BusPwrEn_WIDTH                                  1
#define DxF0x54_BusPwrEn_MASK                                   0x800000
#define DxF0x54_PmeData_OFFSET                                  24
#define DxF0x54_PmeData_WIDTH                                   8
#define DxF0x54_PmeData_MASK                                    0xff000000

/// DxF0x54
typedef union {
  struct {                                                              ///<
    UINT32                                               PowerState:2 ; ///<
    UINT32                                             Reserved_2_2:1 ; ///<
    UINT32                                              NoSoftReset:1 ; ///<
    UINT32                                             Reserved_7_4:4 ; ///<
    UINT32                                                    PmeEn:1 ; ///<
    UINT32                                               DataSelect:4 ; ///<
    UINT32                                                DataScale:2 ; ///<
    UINT32                                                PmeStatus:1 ; ///<
    UINT32                                           Reserved_21_16:6 ; ///<
    UINT32                                              B2B3Support:1 ; ///<
    UINT32                                                 BusPwrEn:1 ; ///<
    UINT32                                                  PmeData:8 ; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} DxF0x54_STRUCT;

// **** DxF0x58 Register Definition ****
// Address
#define DxF0x58_ADDRESS                                         0x58

// Type
#define DxF0x58_TYPE                                            TYPE_D4F0
// Field Data
#define DxF0x58_CapID_OFFSET                                    0
#define DxF0x58_CapID_WIDTH                                     8
#define DxF0x58_CapID_MASK                                      0xff
#define DxF0x58_NextPtr_OFFSET                                  8
#define DxF0x58_NextPtr_WIDTH                                   8
#define DxF0x58_NextPtr_MASK                                    0xff00
#define DxF0x58_Version_OFFSET                                  16
#define DxF0x58_Version_WIDTH                                   4
#define DxF0x58_Version_MASK                                    0xf0000
#define DxF0x58_DeviceType_OFFSET                               20
#define DxF0x58_DeviceType_WIDTH                                4
#define DxF0x58_DeviceType_MASK                                 0xf00000
#define DxF0x58_SlotImplemented_OFFSET                          24
#define DxF0x58_SlotImplemented_WIDTH                           1
#define DxF0x58_SlotImplemented_MASK                            0x1000000
#define DxF0x58_IntMessageNum_OFFSET                            25
#define DxF0x58_IntMessageNum_WIDTH                             5
#define DxF0x58_IntMessageNum_MASK                              0x3e000000
#define DxF0x58_Reserved_31_30_OFFSET                           30
#define DxF0x58_Reserved_31_30_WIDTH                            2
#define DxF0x58_Reserved_31_30_MASK                             0xc0000000

/// DxF0x58
typedef union {
  struct {                                                              ///<
    UINT32                                                    CapID:8 ; ///<
    UINT32                                                  NextPtr:8 ; ///<
    UINT32                                                  Version:4 ; ///<
    UINT32                                               DeviceType:4 ; ///<
    UINT32                                          SlotImplemented:1 ; ///<
    UINT32                                            IntMessageNum:5 ; ///<
    UINT32                                           Reserved_31_30:2 ; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} DxF0x58_STRUCT;

// **** DxF0x5C Register Definition ****
// Address
#define DxF0x5C_ADDRESS                                         0x5c

// Type
#define DxF0x5C_TYPE                                            TYPE_D4F0
// Field Data
#define DxF0x5C_MaxPayloadSupport_OFFSET                        0
#define DxF0x5C_MaxPayloadSupport_WIDTH                         3
#define DxF0x5C_MaxPayloadSupport_MASK                          0x7
#define DxF0x5C_PhantomFunc_OFFSET                              3
#define DxF0x5C_PhantomFunc_WIDTH                               2
#define DxF0x5C_PhantomFunc_MASK                                0x18
#define DxF0x5C_ExtendedTag_OFFSET                              5
#define DxF0x5C_ExtendedTag_WIDTH                               1
#define DxF0x5C_ExtendedTag_MASK                                0x20
#define DxF0x5C_L0SAcceptableLatency_OFFSET                     6
#define DxF0x5C_L0SAcceptableLatency_WIDTH                      3
#define DxF0x5C_L0SAcceptableLatency_MASK                       0x1c0
#define DxF0x5C_L1AcceptableLatency_OFFSET                      9
#define DxF0x5C_L1AcceptableLatency_WIDTH                       3
#define DxF0x5C_L1AcceptableLatency_MASK                        0xe00
#define DxF0x5C_Reserved_14_12_OFFSET                           12
#define DxF0x5C_Reserved_14_12_WIDTH                            3
#define DxF0x5C_Reserved_14_12_MASK                             0x7000
#define DxF0x5C_RoleBasedErrReporting_OFFSET                    15
#define DxF0x5C_RoleBasedErrReporting_WIDTH                     1
#define DxF0x5C_RoleBasedErrReporting_MASK                      0x8000
#define DxF0x5C_Reserved_17_16_OFFSET                           16
#define DxF0x5C_Reserved_17_16_WIDTH                            2
#define DxF0x5C_Reserved_17_16_MASK                             0x30000
#define DxF0x5C_CapturedSlotPowerLimit_OFFSET                   18
#define DxF0x5C_CapturedSlotPowerLimit_WIDTH                    8
#define DxF0x5C_CapturedSlotPowerLimit_MASK                     0x3fc0000
#define DxF0x5C_CapturedSlotPowerScale_OFFSET                   26
#define DxF0x5C_CapturedSlotPowerScale_WIDTH                    2
#define DxF0x5C_CapturedSlotPowerScale_MASK                     0xc000000
#define DxF0x5C_FlrCapable_OFFSET                               28
#define DxF0x5C_FlrCapable_WIDTH                                1
#define DxF0x5C_FlrCapable_MASK                                 0x10000000
#define DxF0x5C_Reserved_31_29_OFFSET                           29
#define DxF0x5C_Reserved_31_29_WIDTH                            3
#define DxF0x5C_Reserved_31_29_MASK                             0xe0000000

/// DxF0x5C
typedef union {
  struct {                                                              ///<
    UINT32                                        MaxPayloadSupport:3 ; ///<
    UINT32                                              PhantomFunc:2 ; ///<
    UINT32                                              ExtendedTag:1 ; ///<
    UINT32                                     L0SAcceptableLatency:3 ; ///<
    UINT32                                      L1AcceptableLatency:3 ; ///<
    UINT32                                           Reserved_14_12:3 ; ///<
    UINT32                                    RoleBasedErrReporting:1 ; ///<
    UINT32                                           Reserved_17_16:2 ; ///<
    UINT32                                   CapturedSlotPowerLimit:8 ; ///<
    UINT32                                   CapturedSlotPowerScale:2 ; ///<
    UINT32                                               FlrCapable:1 ; ///<
    UINT32                                           Reserved_31_29:3 ; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} DxF0x5C_STRUCT;

// **** DxF0x60 Register Definition ****
// Address
#define DxF0x60_ADDRESS                                         0x60

// Type
#define DxF0x60_TYPE                                            TYPE_D4F0
// Field Data
#define DxF0x60_CorrErrEn_OFFSET                                0
#define DxF0x60_CorrErrEn_WIDTH                                 1
#define DxF0x60_CorrErrEn_MASK                                  0x1
#define DxF0x60_NonFatalErrEn_OFFSET                            1
#define DxF0x60_NonFatalErrEn_WIDTH                             1
#define DxF0x60_NonFatalErrEn_MASK                              0x2
#define DxF0x60_FatalErrEn_OFFSET                               2
#define DxF0x60_FatalErrEn_WIDTH                                1
#define DxF0x60_FatalErrEn_MASK                                 0x4
#define DxF0x60_UsrReportEn_OFFSET                              3
#define DxF0x60_UsrReportEn_WIDTH                               1
#define DxF0x60_UsrReportEn_MASK                                0x8
#define DxF0x60_RelaxedOrdEn_OFFSET                             4
#define DxF0x60_RelaxedOrdEn_WIDTH                              1
#define DxF0x60_RelaxedOrdEn_MASK                               0x10
#define DxF0x60_MaxPayloadSize_OFFSET                           5
#define DxF0x60_MaxPayloadSize_WIDTH                            3
#define DxF0x60_MaxPayloadSize_MASK                             0xe0
#define DxF0x60_ExtendedTagEn_OFFSET                            8
#define DxF0x60_ExtendedTagEn_WIDTH                             1
#define DxF0x60_ExtendedTagEn_MASK                              0x100
#define DxF0x60_PhantomFuncEn_OFFSET                            9
#define DxF0x60_PhantomFuncEn_WIDTH                             1
#define DxF0x60_PhantomFuncEn_MASK                              0x200
#define DxF0x60_AuxPowerPmEn_OFFSET                             10
#define DxF0x60_AuxPowerPmEn_WIDTH                              1
#define DxF0x60_AuxPowerPmEn_MASK                               0x400
#define DxF0x60_NoSnoopEnable_OFFSET                            11
#define DxF0x60_NoSnoopEnable_WIDTH                             1
#define DxF0x60_NoSnoopEnable_MASK                              0x800
#define DxF0x60_MaxRequestSize_OFFSET                           12
#define DxF0x60_MaxRequestSize_WIDTH                            3
#define DxF0x60_MaxRequestSize_MASK                             0x7000
#define DxF0x60_BridgeCfgRetryEn_OFFSET                         15
#define DxF0x60_BridgeCfgRetryEn_WIDTH                          1
#define DxF0x60_BridgeCfgRetryEn_MASK                           0x8000
#define DxF0x60_CorrErr_OFFSET                                  16
#define DxF0x60_CorrErr_WIDTH                                   1
#define DxF0x60_CorrErr_MASK                                    0x10000
#define DxF0x60_NonFatalErr_OFFSET                              17
#define DxF0x60_NonFatalErr_WIDTH                               1
#define DxF0x60_NonFatalErr_MASK                                0x20000
#define DxF0x60_FatalErr_OFFSET                                 18
#define DxF0x60_FatalErr_WIDTH                                  1
#define DxF0x60_FatalErr_MASK                                   0x40000
#define DxF0x60_UsrDetected_OFFSET                              19
#define DxF0x60_UsrDetected_WIDTH                               1
#define DxF0x60_UsrDetected_MASK                                0x80000
#define DxF0x60_AuxPwr_OFFSET                                   20
#define DxF0x60_AuxPwr_WIDTH                                    1
#define DxF0x60_AuxPwr_MASK                                     0x100000
#define DxF0x60_TransactionsPending_OFFSET                      21
#define DxF0x60_TransactionsPending_WIDTH                       1
#define DxF0x60_TransactionsPending_MASK                        0x200000
#define DxF0x60_Reserved_31_22_OFFSET                           22
#define DxF0x60_Reserved_31_22_WIDTH                            10
#define DxF0x60_Reserved_31_22_MASK                             0xffc00000

/// DxF0x60
typedef union {
  struct {                                                              ///<
    UINT32                                                CorrErrEn:1 ; ///<
    UINT32                                            NonFatalErrEn:1 ; ///<
    UINT32                                               FatalErrEn:1 ; ///<
    UINT32                                              UsrReportEn:1 ; ///<
    UINT32                                             RelaxedOrdEn:1 ; ///<
    UINT32                                           MaxPayloadSize:3 ; ///<
    UINT32                                            ExtendedTagEn:1 ; ///<
    UINT32                                            PhantomFuncEn:1 ; ///<
    UINT32                                             AuxPowerPmEn:1 ; ///<
    UINT32                                            NoSnoopEnable:1 ; ///<
    UINT32                                           MaxRequestSize:3 ; ///<
    UINT32                                         BridgeCfgRetryEn:1 ; ///<
    UINT32                                                  CorrErr:1 ; ///<
    UINT32                                              NonFatalErr:1 ; ///<
    UINT32                                                 FatalErr:1 ; ///<
    UINT32                                              UsrDetected:1 ; ///<
    UINT32                                                   AuxPwr:1 ; ///<
    UINT32                                      TransactionsPending:1 ; ///<
    UINT32                                           Reserved_31_22:10; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} DxF0x60_STRUCT;

// **** DxF0x64 Register Definition ****
// Address
#define DxF0x64_ADDRESS                                         0x64

// Type
#define DxF0x64_TYPE                                            TYPE_D4F0
// Field Data
#define DxF0x64_LinkSpeed_OFFSET                                0
#define DxF0x64_LinkSpeed_WIDTH                                 4
#define DxF0x64_LinkSpeed_MASK                                  0xf
#define DxF0x64_LinkWidth_OFFSET                                4
#define DxF0x64_LinkWidth_WIDTH                                 6
#define DxF0x64_LinkWidth_MASK                                  0x3f0
#define DxF0x64_PMSupport_OFFSET                                10
#define DxF0x64_PMSupport_WIDTH                                 2
#define DxF0x64_PMSupport_MASK                                  0xc00
#define DxF0x64_L0sExitLatency_OFFSET                           12
#define DxF0x64_L0sExitLatency_WIDTH                            3
#define DxF0x64_L0sExitLatency_MASK                             0x7000
#define DxF0x64_L1ExitLatency_OFFSET                            15
#define DxF0x64_L1ExitLatency_WIDTH                             3
#define DxF0x64_L1ExitLatency_MASK                              0x38000
#define DxF0x64_ClockPowerManagement_OFFSET                     18
#define DxF0x64_ClockPowerManagement_WIDTH                      1
#define DxF0x64_ClockPowerManagement_MASK                       0x40000
#define DxF0x64_Reserved_19_19_OFFSET                           19
#define DxF0x64_Reserved_19_19_WIDTH                            1
#define DxF0x64_Reserved_19_19_MASK                             0x80000
#define DxF0x64_DlActiveReportingCapable_OFFSET                 20
#define DxF0x64_DlActiveReportingCapable_WIDTH                  1
#define DxF0x64_DlActiveReportingCapable_MASK                   0x100000
#define DxF0x64_LinkBWNotificationCap_OFFSET                    21
#define DxF0x64_LinkBWNotificationCap_WIDTH                     1
#define DxF0x64_LinkBWNotificationCap_MASK                      0x200000
#define DxF0x64_Reserved_23_22_OFFSET                           22
#define DxF0x64_Reserved_23_22_WIDTH                            2
#define DxF0x64_Reserved_23_22_MASK                             0xc00000
#define DxF0x64_PortNumber_OFFSET                               24
#define DxF0x64_PortNumber_WIDTH                                8
#define DxF0x64_PortNumber_MASK                                 0xff000000

/// DxF0x64
typedef union {
  struct {                                                              ///<
    UINT32                                                LinkSpeed:4 ; ///<
    UINT32                                                LinkWidth:6 ; ///<
    UINT32                                                PMSupport:2 ; ///<
    UINT32                                           L0sExitLatency:3 ; ///<
    UINT32                                            L1ExitLatency:3 ; ///<
    UINT32                                     ClockPowerManagement:1 ; ///<
    UINT32                                           Reserved_19_19:1 ; ///<
    UINT32                                 DlActiveReportingCapable:1 ; ///<
    UINT32                                    LinkBWNotificationCap:1 ; ///<
    UINT32                                           Reserved_23_22:2 ; ///<
    UINT32                                               PortNumber:8 ; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} DxF0x64_STRUCT;

// **** DxF0x68 Register Definition ****
// Address
#define DxF0x68_ADDRESS                                         0x68

// Type
#define DxF0x68_TYPE                                            TYPE_D4F0
// Field Data
#define DxF0x68_PmControl_OFFSET                                0
#define DxF0x68_PmControl_WIDTH                                 2
#define DxF0x68_PmControl_MASK                                  0x3
#define DxF0x68_Reserved_2_2_OFFSET                             2
#define DxF0x68_Reserved_2_2_WIDTH                              1
#define DxF0x68_Reserved_2_2_MASK                               0x4
#define DxF0x68_ReadCplBoundary_OFFSET                          3
#define DxF0x68_ReadCplBoundary_WIDTH                           1
#define DxF0x68_ReadCplBoundary_MASK                            0x8
#define DxF0x68_LinkDis_OFFSET                                  4
#define DxF0x68_LinkDis_WIDTH                                   1
#define DxF0x68_LinkDis_MASK                                    0x10
#define DxF0x68_RetrainLink_OFFSET                              5
#define DxF0x68_RetrainLink_WIDTH                               1
#define DxF0x68_RetrainLink_MASK                                0x20
#define DxF0x68_CommonClockCfg_OFFSET                           6
#define DxF0x68_CommonClockCfg_WIDTH                            1
#define DxF0x68_CommonClockCfg_MASK                             0x40
#define DxF0x68_ExtendedSync_OFFSET                             7
#define DxF0x68_ExtendedSync_WIDTH                              1
#define DxF0x68_ExtendedSync_MASK                               0x80
#define DxF0x68_ClockPowerManagementEn_OFFSET                   8
#define DxF0x68_ClockPowerManagementEn_WIDTH                    1
#define DxF0x68_ClockPowerManagementEn_MASK                     0x100
#define DxF0x68_HWAutonomousWidthDisable_OFFSET                 9
#define DxF0x68_HWAutonomousWidthDisable_WIDTH                  1
#define DxF0x68_HWAutonomousWidthDisable_MASK                   0x200
#define DxF0x68_LinkBWManagementEn_OFFSET                       10
#define DxF0x68_LinkBWManagementEn_WIDTH                        1
#define DxF0x68_LinkBWManagementEn_MASK                         0x400
#define DxF0x68_LinkAutonomousBWIntEn_OFFSET                    11
#define DxF0x68_LinkAutonomousBWIntEn_WIDTH                     1
#define DxF0x68_LinkAutonomousBWIntEn_MASK                      0x800
#define DxF0x68_Reserved_15_12_OFFSET                           12
#define DxF0x68_Reserved_15_12_WIDTH                            4
#define DxF0x68_Reserved_15_12_MASK                             0xf000
#define DxF0x68_LinkSpeed_OFFSET                                16
#define DxF0x68_LinkSpeed_WIDTH                                 4
#define DxF0x68_LinkSpeed_MASK                                  0xf0000
#define DxF0x68_NegotiatedLinkWidth_OFFSET                      20
#define DxF0x68_NegotiatedLinkWidth_WIDTH                       6
#define DxF0x68_NegotiatedLinkWidth_MASK                        0x3f00000
#define DxF0x68_Reserved_26_26_OFFSET                           26
#define DxF0x68_Reserved_26_26_WIDTH                            1
#define DxF0x68_Reserved_26_26_MASK                             0x4000000
#define DxF0x68_LinkTraining_OFFSET                             27
#define DxF0x68_LinkTraining_WIDTH                              1
#define DxF0x68_LinkTraining_MASK                               0x8000000
#define DxF0x68_SlotClockCfg_OFFSET                             28
#define DxF0x68_SlotClockCfg_WIDTH                              1
#define DxF0x68_SlotClockCfg_MASK                               0x10000000
#define DxF0x68_DlActive_OFFSET                                 29
#define DxF0x68_DlActive_WIDTH                                  1
#define DxF0x68_DlActive_MASK                                   0x20000000
#define DxF0x68_LinkBWManagementStatus_OFFSET                   30
#define DxF0x68_LinkBWManagementStatus_WIDTH                    1
#define DxF0x68_LinkBWManagementStatus_MASK                     0x40000000
#define DxF0x68_LinkAutonomousBWStatus_OFFSET                   31
#define DxF0x68_LinkAutonomousBWStatus_WIDTH                    1
#define DxF0x68_LinkAutonomousBWStatus_MASK                     0x80000000

/// DxF0x68
typedef union {
  struct {                                                              ///<
    UINT32                                                PmControl:2 ; ///<
    UINT32                                             Reserved_2_2:1 ; ///<
    UINT32                                          ReadCplBoundary:1 ; ///<
    UINT32                                                  LinkDis:1 ; ///<
    UINT32                                              RetrainLink:1 ; ///<
    UINT32                                           CommonClockCfg:1 ; ///<
    UINT32                                             ExtendedSync:1 ; ///<
    UINT32                                   ClockPowerManagementEn:1 ; ///<
    UINT32                                 HWAutonomousWidthDisable:1 ; ///<
    UINT32                                       LinkBWManagementEn:1 ; ///<
    UINT32                                    LinkAutonomousBWIntEn:1 ; ///<
    UINT32                                           Reserved_15_12:4 ; ///<
    UINT32                                                LinkSpeed:4 ; ///<
    UINT32                                      NegotiatedLinkWidth:6 ; ///<
    UINT32                                           Reserved_26_26:1 ; ///<
    UINT32                                             LinkTraining:1 ; ///<
    UINT32                                             SlotClockCfg:1 ; ///<
    UINT32                                                 DlActive:1 ; ///<
    UINT32                                   LinkBWManagementStatus:1 ; ///<
    UINT32                                   LinkAutonomousBWStatus:1 ; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} DxF0x68_STRUCT;

// **** DxF0x6C Register Definition ****
// Address
#define DxF0x6C_ADDRESS                                         0x6c

// Type
#define DxF0x6C_TYPE                                            TYPE_D4F0
// Field Data
#define DxF0x6C_AttnButtonPresent_OFFSET                        0
#define DxF0x6C_AttnButtonPresent_WIDTH                         1
#define DxF0x6C_AttnButtonPresent_MASK                          0x1
#define DxF0x6C_PwrControllerPresent_OFFSET                     1
#define DxF0x6C_PwrControllerPresent_WIDTH                      1
#define DxF0x6C_PwrControllerPresent_MASK                       0x2
#define DxF0x6C_MrlSensorPresent_OFFSET                         2
#define DxF0x6C_MrlSensorPresent_WIDTH                          1
#define DxF0x6C_MrlSensorPresent_MASK                           0x4
#define DxF0x6C_AttnIndicatorPresent_OFFSET                     3
#define DxF0x6C_AttnIndicatorPresent_WIDTH                      1
#define DxF0x6C_AttnIndicatorPresent_MASK                       0x8
#define DxF0x6C_PwrIndicatorPresent_OFFSET                      4
#define DxF0x6C_PwrIndicatorPresent_WIDTH                       1
#define DxF0x6C_PwrIndicatorPresent_MASK                        0x10
#define DxF0x6C_HotplugSurprise_OFFSET                          5
#define DxF0x6C_HotplugSurprise_WIDTH                           1
#define DxF0x6C_HotplugSurprise_MASK                            0x20
#define DxF0x6C_HotplugCapable_OFFSET                           6
#define DxF0x6C_HotplugCapable_WIDTH                            1
#define DxF0x6C_HotplugCapable_MASK                             0x40
#define DxF0x6C_SlotPwrLimitValue_OFFSET                        7
#define DxF0x6C_SlotPwrLimitValue_WIDTH                         8
#define DxF0x6C_SlotPwrLimitValue_MASK                          0x7f80
#define DxF0x6C_SlotPwrLimitScale_OFFSET                        15
#define DxF0x6C_SlotPwrLimitScale_WIDTH                         2
#define DxF0x6C_SlotPwrLimitScale_MASK                          0x18000
#define DxF0x6C_ElecMechIlPresent_OFFSET                        17
#define DxF0x6C_ElecMechIlPresent_WIDTH                         1
#define DxF0x6C_ElecMechIlPresent_MASK                          0x20000
#define DxF0x6C_NoCmdCplSupport_OFFSET                          18
#define DxF0x6C_NoCmdCplSupport_WIDTH                           1
#define DxF0x6C_NoCmdCplSupport_MASK                            0x40000
#define DxF0x6C_PhysicalSlotNumber_OFFSET                       19
#define DxF0x6C_PhysicalSlotNumber_WIDTH                        13
#define DxF0x6C_PhysicalSlotNumber_MASK                         0xfff80000

/// DxF0x6C
typedef union {
  struct {                                                              ///<
    UINT32                                        AttnButtonPresent:1 ; ///<
    UINT32                                     PwrControllerPresent:1 ; ///<
    UINT32                                         MrlSensorPresent:1 ; ///<
    UINT32                                     AttnIndicatorPresent:1 ; ///<
    UINT32                                      PwrIndicatorPresent:1 ; ///<
    UINT32                                          HotplugSurprise:1 ; ///<
    UINT32                                           HotplugCapable:1 ; ///<
    UINT32                                        SlotPwrLimitValue:8 ; ///<
    UINT32                                        SlotPwrLimitScale:2 ; ///<
    UINT32                                        ElecMechIlPresent:1 ; ///<
    UINT32                                          NoCmdCplSupport:1 ; ///<
    UINT32                                       PhysicalSlotNumber:13; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} DxF0x6C_STRUCT;

// **** DxF0x70 Register Definition ****
// Address
#define DxF0x70_ADDRESS                                         0x70

// Type
#define DxF0x70_TYPE                                            TYPE_D4F0
// Field Data
#define DxF0x70_AttnButtonPressedEn_OFFSET                      0
#define DxF0x70_AttnButtonPressedEn_WIDTH                       1
#define DxF0x70_AttnButtonPressedEn_MASK                        0x1
#define DxF0x70_PwrFaultDetectedEn_OFFSET                       1
#define DxF0x70_PwrFaultDetectedEn_WIDTH                        1
#define DxF0x70_PwrFaultDetectedEn_MASK                         0x2
#define DxF0x70_MrlSensorChangedEn_OFFSET                       2
#define DxF0x70_MrlSensorChangedEn_WIDTH                        1
#define DxF0x70_MrlSensorChangedEn_MASK                         0x4
#define DxF0x70_PresenceDetectChangedEn_OFFSET                  3
#define DxF0x70_PresenceDetectChangedEn_WIDTH                   1
#define DxF0x70_PresenceDetectChangedEn_MASK                    0x8
#define DxF0x70_CmdCplIntrEn_OFFSET                             4
#define DxF0x70_CmdCplIntrEn_WIDTH                              1
#define DxF0x70_CmdCplIntrEn_MASK                               0x10
#define DxF0x70_HotplugIntrEn_OFFSET                            5
#define DxF0x70_HotplugIntrEn_WIDTH                             1
#define DxF0x70_HotplugIntrEn_MASK                              0x20
#define DxF0x70_AttnIndicatorControl_OFFSET                     6
#define DxF0x70_AttnIndicatorControl_WIDTH                      2
#define DxF0x70_AttnIndicatorControl_MASK                       0xc0
#define DxF0x70_PwrIndicatorCntl_OFFSET                         8
#define DxF0x70_PwrIndicatorCntl_WIDTH                          2
#define DxF0x70_PwrIndicatorCntl_MASK                           0x300
#define DxF0x70_PwrControllerCntl_OFFSET                        10
#define DxF0x70_PwrControllerCntl_WIDTH                         1
#define DxF0x70_PwrControllerCntl_MASK                          0x400
#define DxF0x70_ElecMechIlCntl_OFFSET                           11
#define DxF0x70_ElecMechIlCntl_WIDTH                            1
#define DxF0x70_ElecMechIlCntl_MASK                             0x800
#define DxF0x70_DlStateChangedEn_OFFSET                         12
#define DxF0x70_DlStateChangedEn_WIDTH                          1
#define DxF0x70_DlStateChangedEn_MASK                           0x1000
#define DxF0x70_Reserved_15_13_OFFSET                           13
#define DxF0x70_Reserved_15_13_WIDTH                            3
#define DxF0x70_Reserved_15_13_MASK                             0xe000
#define DxF0x70_AttnButtonPressed_OFFSET                        16
#define DxF0x70_AttnButtonPressed_WIDTH                         1
#define DxF0x70_AttnButtonPressed_MASK                          0x10000
#define DxF0x70_PwrFaultDetected_OFFSET                         17
#define DxF0x70_PwrFaultDetected_WIDTH                          1
#define DxF0x70_PwrFaultDetected_MASK                           0x20000
#define DxF0x70_MrlSensorChanged_OFFSET                         18
#define DxF0x70_MrlSensorChanged_WIDTH                          1
#define DxF0x70_MrlSensorChanged_MASK                           0x40000
#define DxF0x70_PresenceDetectChanged_OFFSET                    19
#define DxF0x70_PresenceDetectChanged_WIDTH                     1
#define DxF0x70_PresenceDetectChanged_MASK                      0x80000
#define DxF0x70_CmdCpl_OFFSET                                   20
#define DxF0x70_CmdCpl_WIDTH                                    1
#define DxF0x70_CmdCpl_MASK                                     0x100000
#define DxF0x70_MrlSensorState_OFFSET                           21
#define DxF0x70_MrlSensorState_WIDTH                            1
#define DxF0x70_MrlSensorState_MASK                             0x200000
#define DxF0x70_PresenceDetectState_OFFSET                      22
#define DxF0x70_PresenceDetectState_WIDTH                       1
#define DxF0x70_PresenceDetectState_MASK                        0x400000
#define DxF0x70_ElecMechIlSts_OFFSET                            23
#define DxF0x70_ElecMechIlSts_WIDTH                             1
#define DxF0x70_ElecMechIlSts_MASK                              0x800000
#define DxF0x70_DlStateChanged_OFFSET                           24
#define DxF0x70_DlStateChanged_WIDTH                            1
#define DxF0x70_DlStateChanged_MASK                             0x1000000
#define DxF0x70_Reserved_31_25_OFFSET                           25
#define DxF0x70_Reserved_31_25_WIDTH                            7
#define DxF0x70_Reserved_31_25_MASK                             0xfe000000

/// DxF0x70
typedef union {
  struct {                                                              ///<
    UINT32                                      AttnButtonPressedEn:1 ; ///<
    UINT32                                       PwrFaultDetectedEn:1 ; ///<
    UINT32                                       MrlSensorChangedEn:1 ; ///<
    UINT32                                  PresenceDetectChangedEn:1 ; ///<
    UINT32                                             CmdCplIntrEn:1 ; ///<
    UINT32                                            HotplugIntrEn:1 ; ///<
    UINT32                                     AttnIndicatorControl:2 ; ///<
    UINT32                                         PwrIndicatorCntl:2 ; ///<
    UINT32                                        PwrControllerCntl:1 ; ///<
    UINT32                                           ElecMechIlCntl:1 ; ///<
    UINT32                                         DlStateChangedEn:1 ; ///<
    UINT32                                           Reserved_15_13:3 ; ///<
    UINT32                                        AttnButtonPressed:1 ; ///<
    UINT32                                         PwrFaultDetected:1 ; ///<
    UINT32                                         MrlSensorChanged:1 ; ///<
    UINT32                                    PresenceDetectChanged:1 ; ///<
    UINT32                                                   CmdCpl:1 ; ///<
    UINT32                                           MrlSensorState:1 ; ///<
    UINT32                                      PresenceDetectState:1 ; ///<
    UINT32                                            ElecMechIlSts:1 ; ///<
    UINT32                                           DlStateChanged:1 ; ///<
    UINT32                                           Reserved_31_25:7 ; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} DxF0x70_STRUCT;

// **** DxF0x74 Register Definition ****
// Address
#define DxF0x74_ADDRESS                                         0x74

// Type
#define DxF0x74_TYPE                                            TYPE_D4F0
// Field Data
#define DxF0x74_SerrOnCorrErrEn_OFFSET                          0
#define DxF0x74_SerrOnCorrErrEn_WIDTH                           1
#define DxF0x74_SerrOnCorrErrEn_MASK                            0x1
#define DxF0x74_SerrOnNonFatalErrEn_OFFSET                      1
#define DxF0x74_SerrOnNonFatalErrEn_WIDTH                       1
#define DxF0x74_SerrOnNonFatalErrEn_MASK                        0x2
#define DxF0x74_SerrOnFatalErrEn_OFFSET                         2
#define DxF0x74_SerrOnFatalErrEn_WIDTH                          1
#define DxF0x74_SerrOnFatalErrEn_MASK                           0x4
#define DxF0x74_PmIntEn_OFFSET                                  3
#define DxF0x74_PmIntEn_WIDTH                                   1
#define DxF0x74_PmIntEn_MASK                                    0x8
#define DxF0x74_CrsSoftVisibilityEn_OFFSET                      4
#define DxF0x74_CrsSoftVisibilityEn_WIDTH                       1
#define DxF0x74_CrsSoftVisibilityEn_MASK                        0x10
#define DxF0x74_Reserved_15_5_OFFSET                            5
#define DxF0x74_Reserved_15_5_WIDTH                             11
#define DxF0x74_Reserved_15_5_MASK                              0xffe0
#define DxF0x74_CrsSoftVisibility_OFFSET                        16
#define DxF0x74_CrsSoftVisibility_WIDTH                         1
#define DxF0x74_CrsSoftVisibility_MASK                          0x10000
#define DxF0x74_Reserved_31_17_OFFSET                           17
#define DxF0x74_Reserved_31_17_WIDTH                            15
#define DxF0x74_Reserved_31_17_MASK                             0xfffe0000

/// DxF0x74
typedef union {
  struct {                                                              ///<
    UINT32                                          SerrOnCorrErrEn:1 ; ///<
    UINT32                                      SerrOnNonFatalErrEn:1 ; ///<
    UINT32                                         SerrOnFatalErrEn:1 ; ///<
    UINT32                                                  PmIntEn:1 ; ///<
    UINT32                                      CrsSoftVisibilityEn:1 ; ///<
    UINT32                                            Reserved_15_5:11; ///<
    UINT32                                        CrsSoftVisibility:1 ; ///<
    UINT32                                           Reserved_31_17:15; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} DxF0x74_STRUCT;

// **** DxF0x78 Register Definition ****
// Address
#define DxF0x78_ADDRESS                                         0x78

// Type
#define DxF0x78_TYPE                                            TYPE_D4F0
// Field Data
#define DxF0x78_PmeRequestorId_OFFSET                           0
#define DxF0x78_PmeRequestorId_WIDTH                            16
#define DxF0x78_PmeRequestorId_MASK                             0xffff
#define DxF0x78_PmeStatus_OFFSET                                16
#define DxF0x78_PmeStatus_WIDTH                                 1
#define DxF0x78_PmeStatus_MASK                                  0x10000
#define DxF0x78_PmePending_OFFSET                               17
#define DxF0x78_PmePending_WIDTH                                1
#define DxF0x78_PmePending_MASK                                 0x20000
#define DxF0x78_Reserved_31_18_OFFSET                           18
#define DxF0x78_Reserved_31_18_WIDTH                            14
#define DxF0x78_Reserved_31_18_MASK                             0xfffc0000

/// DxF0x78
typedef union {
  struct {                                                              ///<
    UINT32                                           PmeRequestorId:16; ///<
    UINT32                                                PmeStatus:1 ; ///<
    UINT32                                               PmePending:1 ; ///<
    UINT32                                           Reserved_31_18:14; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} DxF0x78_STRUCT;

// **** DxF0x7C Register Definition ****
// Address
#define DxF0x7C_ADDRESS                                         0x7c

// Type
#define DxF0x7C_TYPE                                            TYPE_D4F0
// Field Data
#define DxF0x7C_CplTimeoutRangeSup_OFFSET                       0
#define DxF0x7C_CplTimeoutRangeSup_WIDTH                        4
#define DxF0x7C_CplTimeoutRangeSup_MASK                         0xf
#define DxF0x7C_CplTimeoutDisSup_OFFSET                         4
#define DxF0x7C_CplTimeoutDisSup_WIDTH                          1
#define DxF0x7C_CplTimeoutDisSup_MASK                           0x10
#define DxF0x7C_AriForwardingSupported_OFFSET                   5
#define DxF0x7C_AriForwardingSupported_WIDTH                    1
#define DxF0x7C_AriForwardingSupported_MASK                     0x20
#define DxF0x7C_Reserved_31_6_OFFSET                            6
#define DxF0x7C_Reserved_31_6_WIDTH                             26
#define DxF0x7C_Reserved_31_6_MASK                              0xffffffc0

/// DxF0x7C
typedef union {
  struct {                                                              ///<
    UINT32                                       CplTimeoutRangeSup:4 ; ///<
    UINT32                                         CplTimeoutDisSup:1 ; ///<
    UINT32                                   AriForwardingSupported:1 ; ///<
    UINT32                                            Reserved_31_6:26; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} DxF0x7C_STRUCT;

// **** DxF0x80 Register Definition ****
// Address
#define DxF0x80_ADDRESS                                         0x80

// Type
#define DxF0x80_TYPE                                            TYPE_D4F0
// Field Data
#define DxF0x80_CplTimeoutValue_OFFSET                          0
#define DxF0x80_CplTimeoutValue_WIDTH                           4
#define DxF0x80_CplTimeoutValue_MASK                            0xf
#define DxF0x80_CplTimeoutDis_OFFSET                            4
#define DxF0x80_CplTimeoutDis_WIDTH                             1
#define DxF0x80_CplTimeoutDis_MASK                              0x10
#define DxF0x80_AriForwardingEn_OFFSET                          5
#define DxF0x80_AriForwardingEn_WIDTH                           1
#define DxF0x80_AriForwardingEn_MASK                            0x20
#define DxF0x80_Reserved_31_6_OFFSET                            6
#define DxF0x80_Reserved_31_6_WIDTH                             26
#define DxF0x80_Reserved_31_6_MASK                              0xffffffc0

/// DxF0x80
typedef union {
  struct {                                                              ///<
    UINT32                                          CplTimeoutValue:4 ; ///<
    UINT32                                            CplTimeoutDis:1 ; ///<
    UINT32                                          AriForwardingEn:1 ; ///<
    UINT32                                            Reserved_31_6:26; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} DxF0x80_STRUCT;

// **** DxF0x84 Register Definition ****
// Address
#define DxF0x84_ADDRESS                                         0x84

// Type
#define DxF0x84_TYPE                                            TYPE_D4F0
// Field Data
#define DxF0x84_Reserved_31_0_OFFSET                            0
#define DxF0x84_Reserved_31_0_WIDTH                             32
#define DxF0x84_Reserved_31_0_MASK                              0xffffffff

/// DxF0x84
typedef union {
  struct {                                                              ///<
    UINT32                                            Reserved_31_0:32; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} DxF0x84_STRUCT;

// **** DxF0x88 Register Definition ****
// Address
#define DxF0x88_ADDRESS                                         0x88

// Type
#define DxF0x88_TYPE                                            TYPE_D4F0
// Field Data
#define DxF0x88_TargetLinkSpeed_OFFSET                          0
#define DxF0x88_TargetLinkSpeed_WIDTH                           4
#define DxF0x88_TargetLinkSpeed_MASK                            0xf
#define DxF0x88_EnterCompliance_OFFSET                          4
#define DxF0x88_EnterCompliance_WIDTH                           1
#define DxF0x88_EnterCompliance_MASK                            0x10
#define DxF0x88_HwAutonomousSpeedDisable_OFFSET                 5
#define DxF0x88_HwAutonomousSpeedDisable_WIDTH                  1
#define DxF0x88_HwAutonomousSpeedDisable_MASK                   0x20
#define DxF0x88_SelectableDeemphasis_OFFSET                     6
#define DxF0x88_SelectableDeemphasis_WIDTH                      1
#define DxF0x88_SelectableDeemphasis_MASK                       0x40
#define DxF0x88_XmitMargin_OFFSET                               7
#define DxF0x88_XmitMargin_WIDTH                                3
#define DxF0x88_XmitMargin_MASK                                 0x380
#define DxF0x88_EnterModCompliance_OFFSET                       10
#define DxF0x88_EnterModCompliance_WIDTH                        1
#define DxF0x88_EnterModCompliance_MASK                         0x400
#define DxF0x88_ComplianceSOS_OFFSET                            11
#define DxF0x88_ComplianceSOS_WIDTH                             1
#define DxF0x88_ComplianceSOS_MASK                              0x800
#define DxF0x88_ComplianceDeemphasis_OFFSET                     12
#define DxF0x88_ComplianceDeemphasis_WIDTH                      1
#define DxF0x88_ComplianceDeemphasis_MASK                       0x1000
#define DxF0x88_Reserved_15_13_OFFSET                           13
#define DxF0x88_Reserved_15_13_WIDTH                            3
#define DxF0x88_Reserved_15_13_MASK                             0xe000
#define DxF0x88_CurDeemphasisLevel_OFFSET                       16
#define DxF0x88_CurDeemphasisLevel_WIDTH                        1
#define DxF0x88_CurDeemphasisLevel_MASK                         0x10000
#define DxF0x88_Reserved_31_17_OFFSET                           17
#define DxF0x88_Reserved_31_17_WIDTH                            15
#define DxF0x88_Reserved_31_17_MASK                             0xfffe0000

/// DxF0x88
typedef union {
  struct {                                                              ///<
    UINT32                                          TargetLinkSpeed:4 ; ///<
    UINT32                                          EnterCompliance:1 ; ///<
    UINT32                                 HwAutonomousSpeedDisable:1 ; ///<
    UINT32                                     SelectableDeemphasis:1 ; ///<
    UINT32                                               XmitMargin:3 ; ///<
    UINT32                                       EnterModCompliance:1 ; ///<
    UINT32                                            ComplianceSOS:1 ; ///<
    UINT32                                     ComplianceDeemphasis:1 ; ///<
    UINT32                                           Reserved_15_13:3 ; ///<
    UINT32                                       CurDeemphasisLevel:1 ; ///<
    UINT32                                           Reserved_31_17:15; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} DxF0x88_STRUCT;

// **** DxF0x8C Register Definition ****
// Address
#define DxF0x8C_ADDRESS                                         0x8c

// Type
#define DxF0x8C_TYPE                                            TYPE_D4F0
// Field Data
#define DxF0x8C_Reserved_31_0_OFFSET                            0
#define DxF0x8C_Reserved_31_0_WIDTH                             32
#define DxF0x8C_Reserved_31_0_MASK                              0xffffffff

/// DxF0x8C
typedef union {
  struct {                                                              ///<
    UINT32                                            Reserved_31_0:32; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} DxF0x8C_STRUCT;

// **** DxF0x90 Register Definition ****
// Address
#define DxF0x90_ADDRESS                                         0x90

// Type
#define DxF0x90_TYPE                                            TYPE_D4F0
// Field Data
#define DxF0x90_Reserved_31_0_OFFSET                            0
#define DxF0x90_Reserved_31_0_WIDTH                             32
#define DxF0x90_Reserved_31_0_MASK                              0xffffffff

/// DxF0x90
typedef union {
  struct {                                                              ///<
    UINT32                                            Reserved_31_0:32; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} DxF0x90_STRUCT;

// **** DxF0x128 Register Definition ****
// Address
#define DxF0x128_ADDRESS                                        0x128

// Type
#define DxF0x128_TYPE                                           TYPE_D4F0
// Field Data
#define DxF0x128_Reserved_15_0_OFFSET                           0
#define DxF0x128_Reserved_15_0_WIDTH                            16
#define DxF0x128_Reserved_15_0_MASK                             0xffff
#define DxF0x128_PortArbTableStatus_OFFSET                      16
#define DxF0x128_PortArbTableStatus_WIDTH                       1
#define DxF0x128_PortArbTableStatus_MASK                        0x10000
#define DxF0x128_VcNegotiationPending_OFFSET                    17
#define DxF0x128_VcNegotiationPending_WIDTH                     1
#define DxF0x128_VcNegotiationPending_MASK                      0x20000
#define DxF0x128_Reserved_31_18_OFFSET                          18
#define DxF0x128_Reserved_31_18_WIDTH                           14
#define DxF0x128_Reserved_31_18_MASK                            0xfffc0000

/// DxF0x128
typedef union {
  struct {                                                              ///<
    UINT32                                            Reserved_15_0:16; ///<
    UINT32                                       PortArbTableStatus:1 ; ///<
    UINT32                                     VcNegotiationPending:1 ; ///<
    UINT32                                           Reserved_31_18:14; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} DxF0x128_STRUCT;

// **** FCRxFE00_6000 Register Definition ****
// Address
#define FCRxFE00_6000_ADDRESS                                   0xfe006000

// Type
#define FCRxFE00_6000_TYPE                                      TYPE_FCR
// Field Data
#define FCRxFE00_6000_Reserved_6_0_OFFSET                       0
#define FCRxFE00_6000_Reserved_6_0_WIDTH                        7
#define FCRxFE00_6000_Reserved_6_0_MASK                         0x7f
#define FCRxFE00_6000_NbPs0Vid_OFFSET                           7
#define FCRxFE00_6000_NbPs0Vid_WIDTH                            7
#define FCRxFE00_6000_NbPs0Vid_MASK                             0x3f80
#define FCRxFE00_6000_NbPs1Vid_OFFSET                           14
#define FCRxFE00_6000_NbPs1Vid_WIDTH                            7
#define FCRxFE00_6000_NbPs1Vid_MASK                             0x1fc000
#define FCRxFE00_6000_Reserved_31_21_OFFSET                     21
#define FCRxFE00_6000_Reserved_31_21_WIDTH                      11
#define FCRxFE00_6000_Reserved_31_21_MASK                       0xffe00000

/// FCRxFE00_6000
typedef union {
  struct {                                                              ///<
    UINT32                                             Reserved_6_0:7 ; ///<
    UINT32                                                 NbPs0Vid:7 ; ///<
    UINT32                                                 NbPs1Vid:7 ; ///<
    UINT32                                           Reserved_31_21:11; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} FCRxFE00_6000_STRUCT;

// **** FCRxFE00_6002 Register Definition ****
// Address
#define FCRxFE00_6002_ADDRESS                                   0xfe006002

// Type
#define FCRxFE00_6002_TYPE                                      TYPE_FCR
// Field Data
#define FCRxFE00_6002_Reserved_4_0_OFFSET                       0
#define FCRxFE00_6002_Reserved_4_0_WIDTH                        5
#define FCRxFE00_6002_Reserved_4_0_MASK                         0x1f
#define FCRxFE00_6002_NbPs1VidAddl_OFFSET                       5
#define FCRxFE00_6002_NbPs1VidAddl_WIDTH                        7
#define FCRxFE00_6002_NbPs1VidAddl_MASK                         0xfe0
#define FCRxFE00_6002_NbPs1VidHigh_OFFSET                       12
#define FCRxFE00_6002_NbPs1VidHigh_WIDTH                        7
#define FCRxFE00_6002_NbPs1VidHigh_MASK                         0x7f000
#define FCRxFE00_6002_Reserved_31_19_OFFSET                     19
#define FCRxFE00_6002_Reserved_31_19_WIDTH                      13
#define FCRxFE00_6002_Reserved_31_19_MASK                       0xfff80000

/// FCRxFE00_6002
typedef union {
  struct {                                                              ///<
    UINT32                                             Reserved_4_0:5 ; ///<
    UINT32                                             NbPs1VidAddl:7 ; ///<
    UINT32                                             NbPs1VidHigh:7 ; ///<
    UINT32                                           Reserved_31_19:13; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} FCRxFE00_6002_STRUCT;

// **** FCRxFE00_7006 Register Definition ****
// Address
#define FCRxFE00_7006_ADDRESS                                   0xfe007006

// Type
#define FCRxFE00_7006_TYPE                                      TYPE_FCR
// Field Data
#define FCRxFE00_7006_Reserved_13_0_OFFSET                      0
#define FCRxFE00_7006_Reserved_13_0_WIDTH                       14
#define FCRxFE00_7006_Reserved_13_0_MASK                        0x3fff
#define FCRxFE00_7006_NbPs1NclkDiv_OFFSET                       14
#define FCRxFE00_7006_NbPs1NclkDiv_WIDTH                        7
#define FCRxFE00_7006_NbPs1NclkDiv_MASK                         0x1fc000
#define FCRxFE00_7006_MaxNbFreqAtMinVid_OFFSET                  21
#define FCRxFE00_7006_MaxNbFreqAtMinVid_WIDTH                   5
#define FCRxFE00_7006_MaxNbFreqAtMinVid_MASK                    0x3e00000
#define FCRxFE00_7006_Reserved_31_26_OFFSET                     26
#define FCRxFE00_7006_Reserved_31_26_WIDTH                      6
#define FCRxFE00_7006_Reserved_31_26_MASK                       0xfc000000

/// FCRxFE00_7006
typedef union {
  struct {                                                              ///<
    UINT32                                            Reserved_13_0:14; ///<
    UINT32                                             NbPs1NclkDiv:7 ; ///<
    UINT32                                        MaxNbFreqAtMinVid:5 ; ///<
    UINT32                                           Reserved_31_26:6 ; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} FCRxFE00_7006_STRUCT;

// **** FCRxFE00_7009 Register Definition ****
// Address
#define FCRxFE00_7009_ADDRESS                                   0xfe007009

// Type
#define FCRxFE00_7009_TYPE                                      TYPE_FCR
// Field Data
#define FCRxFE00_7009_Reserved_1_0_OFFSET                       0
#define FCRxFE00_7009_Reserved_1_0_WIDTH                        2
#define FCRxFE00_7009_Reserved_1_0_MASK                         0x3
#define FCRxFE00_7009_NbPs0NclkDiv_OFFSET                       2
#define FCRxFE00_7009_NbPs0NclkDiv_WIDTH                        7
#define FCRxFE00_7009_NbPs0NclkDiv_MASK                         0x1fc
#define FCRxFE00_7009_Reserved_31_9_OFFSET                      9
#define FCRxFE00_7009_Reserved_31_9_WIDTH                       23
#define FCRxFE00_7009_Reserved_31_9_MASK                        0xfffffe00

/// FCRxFE00_7009
typedef union {
  struct {                                                              ///<
    UINT32                                             Reserved_1_0:2 ; ///<
    UINT32                                             NbPs0NclkDiv:7 ; ///<
    UINT32                                            Reserved_31_9:23; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} FCRxFE00_7009_STRUCT;

// **** FCRxFE00_705F Register Definition ****
// Address
#define FCRxFE00_705F_ADDRESS                                   0xfe00705f

// Type
#define FCRxFE00_705F_TYPE                                      TYPE_FCR
// Field Data
#define FCRxFE00_705F_Reserved_4_0_OFFSET                       0
#define FCRxFE00_705F_Reserved_4_0_WIDTH                        5
#define FCRxFE00_705F_Reserved_4_0_MASK                         0x1f
#define FCRxFE00_705F_GnbIdleAdjustVid_OFFSET                   5
#define FCRxFE00_705F_GnbIdleAdjustVid_WIDTH                    4
#define FCRxFE00_705F_GnbIdleAdjustVid_MASK                     0x1e0
#define FCRxFE00_705F_Reserved_31_9_OFFSET                      9
#define FCRxFE00_705F_Reserved_31_9_WIDTH                       23
#define FCRxFE00_705F_Reserved_31_9_MASK                        0xfffffe00

/// FCRxFE00_705F
typedef union {
  struct {                                                              ///<
    UINT32                                             Reserved_4_0:5 ; ///<
    UINT32                                         GnbIdleAdjustVid:4 ; ///<
    UINT32                                            Reserved_31_9:23; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} FCRxFE00_705F_STRUCT;

// **** FCRxFE00_7110 Register Definition ****
// Address
#define FCRxFE00_7110_ADDRESS                                   0xfe007110

// Type
#define FCRxFE00_7110_TYPE                                      TYPE_FCR
// Field Data
#define FCRxFE00_7110_Reserved_5_0_OFFSET                       0
#define FCRxFE00_7110_Reserved_5_0_WIDTH                        6
#define FCRxFE00_7110_Reserved_5_0_MASK                         0x3f
#define FCRxFE00_7110_LclkDpmDid0_OFFSET                        6
#define FCRxFE00_7110_LclkDpmDid0_WIDTH                         7
#define FCRxFE00_7110_LclkDpmDid0_MASK                          0x1fc0
#define FCRxFE00_7110_LclkDpmDid1_OFFSET                        13
#define FCRxFE00_7110_LclkDpmDid1_WIDTH                         7
#define FCRxFE00_7110_LclkDpmDid1_MASK                          0xfe000
#define FCRxFE00_7110_LclkDpmDid2_OFFSET                        20
#define FCRxFE00_7110_LclkDpmDid2_WIDTH                         7
#define FCRxFE00_7110_LclkDpmDid2_MASK                          0x7f00000
#define FCRxFE00_7110_Reserved_31_27_OFFSET                     27
#define FCRxFE00_7110_Reserved_31_27_WIDTH                      5
#define FCRxFE00_7110_Reserved_31_27_MASK                       0xf8000000

/// FCRxFE00_7110
typedef union {
  struct {                                                              ///<
    UINT32                                             Reserved_5_0:6 ; ///<
    UINT32                                              LclkDpmDid0:7 ; ///<
    UINT32                                              LclkDpmDid1:7 ; ///<
    UINT32                                              LclkDpmDid2:7 ; ///<
    UINT32                                           Reserved_31_27:5 ; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} FCRxFE00_7110_STRUCT;

// **** FCRxFE00_7113 Register Definition ****
// Address
#define FCRxFE00_7113_ADDRESS                                   0xfe007113

// Type
#define FCRxFE00_7113_TYPE                                      TYPE_FCR
// Field Data
#define FCRxFE00_7113_Reserved_2_0_OFFSET                       0
#define FCRxFE00_7113_Reserved_2_0_WIDTH                        3
#define FCRxFE00_7113_Reserved_2_0_MASK                         0x7
#define FCRxFE00_7113_LclkDpmDid3_OFFSET                        3
#define FCRxFE00_7113_LclkDpmDid3_WIDTH                         7
#define FCRxFE00_7113_LclkDpmDid3_MASK                          0x3f8
#define FCRxFE00_7113_LclkDpmValid0_OFFSET                      10
#define FCRxFE00_7113_LclkDpmValid0_WIDTH                       1
#define FCRxFE00_7113_LclkDpmValid0_MASK                        0x400
#define FCRxFE00_7113_LclkDpmValid1_OFFSET                      11
#define FCRxFE00_7113_LclkDpmValid1_WIDTH                       1
#define FCRxFE00_7113_LclkDpmValid1_MASK                        0x800
#define FCRxFE00_7113_LclkDpmValid2_OFFSET                      12
#define FCRxFE00_7113_LclkDpmValid2_WIDTH                       1
#define FCRxFE00_7113_LclkDpmValid2_MASK                        0x1000
#define FCRxFE00_7113_LclkDpmValid3_OFFSET                      13
#define FCRxFE00_7113_LclkDpmValid3_WIDTH                       1
#define FCRxFE00_7113_LclkDpmValid3_MASK                        0x2000
#define FCRxFE00_7113_Reserved_31_14_OFFSET                     14
#define FCRxFE00_7113_Reserved_31_14_WIDTH                      18
#define FCRxFE00_7113_Reserved_31_14_MASK                       0xffffc000

/// FCRxFE00_7113
typedef union {
  struct {                                                              ///<
    UINT32                                             Reserved_2_0:3 ; ///<
    UINT32                                              LclkDpmDid3:7 ; ///<
    UINT32                                            LclkDpmValid0:1 ; ///<
    UINT32                                            LclkDpmValid1:1 ; ///<
    UINT32                                            LclkDpmValid2:1 ; ///<
    UINT32                                            LclkDpmValid3:1 ; ///<
    UINT32                                           Reserved_31_14:18; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} FCRxFE00_7113_STRUCT;

// **** FCRxFF30_0191 Register Definition ****
// Address
#define FCRxFF30_0191_ADDRESS                                   0xff300191

// Type
#define FCRxFF30_0191_TYPE                                      TYPE_FCR
// Field Data
#define FCRxFF30_0191_Reserved_15_0_OFFSET                      0
#define FCRxFF30_0191_Reserved_15_0_WIDTH                       16
#define FCRxFF30_0191_Reserved_15_0_MASK                        0xffff
#define FCRxFF30_0191_GfxIdleVoltChgEn_OFFSET                   16
#define FCRxFF30_0191_GfxIdleVoltChgEn_WIDTH                    1
#define FCRxFF30_0191_GfxIdleVoltChgEn_MASK                     0x10000
#define FCRxFF30_0191_GfxIdleVoltChgMode_OFFSET                 17
#define FCRxFF30_0191_GfxIdleVoltChgMode_WIDTH                  1
#define FCRxFF30_0191_GfxIdleVoltChgMode_MASK                   0x20000
#define FCRxFF30_0191_Reserved_31_18_OFFSET                     18
#define FCRxFF30_0191_Reserved_31_18_WIDTH                      14
#define FCRxFF30_0191_Reserved_31_18_MASK                       0xfffc0000

/// FCRxFF30_0191
typedef union {
  struct {                                                              ///<
    UINT32                                            Reserved_15_0:16; ///<
    UINT32                                         GfxIdleVoltChgEn:1 ; ///<
    UINT32                                       GfxIdleVoltChgMode:1 ; ///<
    UINT32                                           Reserved_31_18:14; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} FCRxFF30_0191_STRUCT;

// **** FCRxFF30_01E4 Register Definition ****
// Address
#define FCRxFF30_01E4_ADDRESS                                   0xff3001e4

// Type
#define FCRxFF30_01E4_TYPE                                      TYPE_FCR
// Field Data
#define FCRxFF30_01E4_Reserved_19_0_OFFSET                      0
#define FCRxFF30_01E4_Reserved_19_0_WIDTH                       20
#define FCRxFF30_01E4_Reserved_19_0_MASK                        0xfffff
#define FCRxFF30_01E4_VoltageChangeEn_OFFSET                    20
#define FCRxFF30_01E4_VoltageChangeEn_WIDTH                     1
#define FCRxFF30_01E4_VoltageChangeEn_MASK                      0x100000
#define FCRxFF30_01E4_Reserved_31_21_OFFSET                     21
#define FCRxFF30_01E4_Reserved_31_21_WIDTH                      11
#define FCRxFF30_01E4_Reserved_31_21_MASK                       0xffe00000

/// FCRxFF30_01E4
typedef union {
  struct {                                                              ///<
    UINT32                                            Reserved_19_0:20; ///<
    UINT32                                          VoltageChangeEn:1 ; ///<
    UINT32                                           Reserved_31_21:11; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} FCRxFF30_01E4_STRUCT;

// **** FCRxFF30_01F4 Register Definition ****
// Address
#define FCRxFF30_01F4_ADDRESS                                   0xff3001f4

// Type
#define FCRxFF30_01F4_TYPE                                      TYPE_FCR
// Field Data
#define FCRxFF30_01F4_CgRlcCgttSclkOverride_OFFSET              0
#define FCRxFF30_01F4_CgRlcCgttSclkOverride_WIDTH               1
#define FCRxFF30_01F4_CgRlcCgttSclkOverride_MASK                0x1
#define FCRxFF30_01F4_CgCpCgttSclkOverride_OFFSET               1
#define FCRxFF30_01F4_CgCpCgttSclkOverride_WIDTH                1
#define FCRxFF30_01F4_CgCpCgttSclkOverride_MASK                 0x2
#define FCRxFF30_01F4_CgVgtCgttSclkOverride_OFFSET              2
#define FCRxFF30_01F4_CgVgtCgttSclkOverride_WIDTH               1
#define FCRxFF30_01F4_CgVgtCgttSclkOverride_MASK                0x4
#define FCRxFF30_01F4_CgPaCgttSclkOverride_OFFSET               3
#define FCRxFF30_01F4_CgPaCgttSclkOverride_WIDTH                1
#define FCRxFF30_01F4_CgPaCgttSclkOverride_MASK                 0x8
#define FCRxFF30_01F4_CgScCgttSclkOverride_OFFSET               4
#define FCRxFF30_01F4_CgScCgttSclkOverride_WIDTH                1
#define FCRxFF30_01F4_CgScCgttSclkOverride_MASK                 0x10
#define FCRxFF30_01F4_CgSpimCgttSclkOverride_OFFSET             5
#define FCRxFF30_01F4_CgSpimCgttSclkOverride_WIDTH              1
#define FCRxFF30_01F4_CgSpimCgttSclkOverride_MASK               0x20
#define FCRxFF30_01F4_CgSxmCgttSclkOverride_OFFSET              6
#define FCRxFF30_01F4_CgSxmCgttSclkOverride_WIDTH               1
#define FCRxFF30_01F4_CgSxmCgttSclkOverride_MASK                0x40
#define FCRxFF30_01F4_CgSxsCgttSclkOverride_OFFSET              7
#define FCRxFF30_01F4_CgSxsCgttSclkOverride_WIDTH               1
#define FCRxFF30_01F4_CgSxsCgttSclkOverride_MASK                0x80
#define FCRxFF30_01F4_CgCb0CgttSclkOverride_OFFSET              8
#define FCRxFF30_01F4_CgCb0CgttSclkOverride_WIDTH               1
#define FCRxFF30_01F4_CgCb0CgttSclkOverride_MASK                0x100
#define FCRxFF30_01F4_CgCb1CgttSclkOverride_OFFSET              9
#define FCRxFF30_01F4_CgCb1CgttSclkOverride_WIDTH               1
#define FCRxFF30_01F4_CgCb1CgttSclkOverride_MASK                0x200
#define FCRxFF30_01F4_ReservedCgtt10Override_OFFSET             10
#define FCRxFF30_01F4_ReservedCgtt10Override_WIDTH              1
#define FCRxFF30_01F4_ReservedCgtt10Override_MASK               0x400
#define FCRxFF30_01F4_ReservedCgtt11Override_OFFSET             11
#define FCRxFF30_01F4_ReservedCgtt11Override_WIDTH              1
#define FCRxFF30_01F4_ReservedCgtt11Override_MASK               0x800
#define FCRxFF30_01F4_CgDb0CgttSclkOverride_OFFSET              12
#define FCRxFF30_01F4_CgDb0CgttSclkOverride_WIDTH               1
#define FCRxFF30_01F4_CgDb0CgttSclkOverride_MASK                0x1000
#define FCRxFF30_01F4_CgDb1CgttSclkOverride_OFFSET              13
#define FCRxFF30_01F4_CgDb1CgttSclkOverride_WIDTH               1
#define FCRxFF30_01F4_CgDb1CgttSclkOverride_MASK                0x2000
#define FCRxFF30_01F4_ReservedCgtt14Override_OFFSET             14
#define FCRxFF30_01F4_ReservedCgtt14Override_WIDTH              1
#define FCRxFF30_01F4_ReservedCgtt14Override_MASK               0x4000
#define FCRxFF30_01F4_ReservedCgtt15Override_OFFSET             15
#define FCRxFF30_01F4_ReservedCgtt15Override_WIDTH              1
#define FCRxFF30_01F4_ReservedCgtt15Override_MASK               0x8000
#define FCRxFF30_01F4_CgVcCgttSclkOverride_OFFSET               16
#define FCRxFF30_01F4_CgVcCgttSclkOverride_WIDTH                1
#define FCRxFF30_01F4_CgVcCgttSclkOverride_MASK                 0x10000
#define FCRxFF30_01F4_CgAvpCgttSclkOverride_OFFSET              17
#define FCRxFF30_01F4_CgAvpCgttSclkOverride_WIDTH               1
#define FCRxFF30_01F4_CgAvpCgttSclkOverride_MASK                0x20000
#define FCRxFF30_01F4_CgAvpCgttEclkOverride_OFFSET              18
#define FCRxFF30_01F4_CgAvpCgttEclkOverride_WIDTH               1
#define FCRxFF30_01F4_CgAvpCgttEclkOverride_MASK                0x40000
#define FCRxFF30_01F4_CgUvdmCgttSclkOverride_OFFSET             19
#define FCRxFF30_01F4_CgUvdmCgttSclkOverride_WIDTH              1
#define FCRxFF30_01F4_CgUvdmCgttSclkOverride_MASK               0x80000
#define FCRxFF30_01F4_CgUvdmCgttVclkOverride_OFFSET             20
#define FCRxFF30_01F4_CgUvdmCgttVclkOverride_WIDTH              1
#define FCRxFF30_01F4_CgUvdmCgttVclkOverride_MASK               0x100000
#define FCRxFF30_01F4_CgUvdmCgttDclkOverride_OFFSET             21
#define FCRxFF30_01F4_CgUvdmCgttDclkOverride_WIDTH              1
#define FCRxFF30_01F4_CgUvdmCgttDclkOverride_MASK               0x200000
#define FCRxFF30_01F4_CgBifCgttSclkOverride_OFFSET              22
#define FCRxFF30_01F4_CgBifCgttSclkOverride_WIDTH               1
#define FCRxFF30_01F4_CgBifCgttSclkOverride_MASK                0x400000
#define FCRxFF30_01F4_CgRomCgttSclkOverride_OFFSET              23
#define FCRxFF30_01F4_CgRomCgttSclkOverride_WIDTH               1
#define FCRxFF30_01F4_CgRomCgttSclkOverride_MASK                0x800000
#define FCRxFF30_01F4_CgDrmCgttSclkOverride_OFFSET              24
#define FCRxFF30_01F4_CgDrmCgttSclkOverride_WIDTH               1
#define FCRxFF30_01F4_CgDrmCgttSclkOverride_MASK                0x1000000
#define FCRxFF30_01F4_CgDcCgttSclkOverride_OFFSET               25
#define FCRxFF30_01F4_CgDcCgttSclkOverride_WIDTH                1
#define FCRxFF30_01F4_CgDcCgttSclkOverride_MASK                 0x2000000
#define FCRxFF30_01F4_ReservedCgtt26Override_OFFSET             26
#define FCRxFF30_01F4_ReservedCgtt26Override_WIDTH              1
#define FCRxFF30_01F4_ReservedCgtt26Override_MASK               0x4000000
#define FCRxFF30_01F4_CgMcbCgttSclkOverride_OFFSET              27
#define FCRxFF30_01F4_CgMcbCgttSclkOverride_WIDTH               1
#define FCRxFF30_01F4_CgMcbCgttSclkOverride_MASK                0x8000000
#define FCRxFF30_01F4_CgMcdwCgttSclkOverride_OFFSET             28
#define FCRxFF30_01F4_CgMcdwCgttSclkOverride_WIDTH              1
#define FCRxFF30_01F4_CgMcdwCgttSclkOverride_MASK               0x10000000
#define FCRxFF30_01F4_ReservedCgtt29Override_OFFSET             29
#define FCRxFF30_01F4_ReservedCgtt29Override_WIDTH              1
#define FCRxFF30_01F4_ReservedCgtt29Override_MASK               0x20000000
#define FCRxFF30_01F4_ReservedCgtt30Override_OFFSET             30
#define FCRxFF30_01F4_ReservedCgtt30Override_WIDTH              1
#define FCRxFF30_01F4_ReservedCgtt30Override_MASK               0x40000000
#define FCRxFF30_01F4_ReservedCgtt31Override_OFFSET             31
#define FCRxFF30_01F4_ReservedCgtt31Override_WIDTH              1
#define FCRxFF30_01F4_ReservedCgtt31Override_MASK               0x80000000

/// FCRxFF30_01F4
typedef union {
  struct {                                                              ///<
    UINT32                                    CgRlcCgttSclkOverride:1 ; ///<
    UINT32                                     CgCpCgttSclkOverride:1 ; ///<
    UINT32                                    CgVgtCgttSclkOverride:1 ; ///<
    UINT32                                     CgPaCgttSclkOverride:1 ; ///<
    UINT32                                     CgScCgttSclkOverride:1 ; ///<
    UINT32                                   CgSpimCgttSclkOverride:1 ; ///<
    UINT32                                    CgSxmCgttSclkOverride:1 ; ///<
    UINT32                                    CgSxsCgttSclkOverride:1 ; ///<
    UINT32                                    CgCb0CgttSclkOverride:1 ; ///<
    UINT32                                    CgCb1CgttSclkOverride:1 ; ///<
    UINT32                                   ReservedCgtt10Override:1 ; ///<
    UINT32                                   ReservedCgtt11Override:1 ; ///<
    UINT32                                    CgDb0CgttSclkOverride:1 ; ///<
    UINT32                                    CgDb1CgttSclkOverride:1 ; ///<
    UINT32                                   ReservedCgtt14Override:1 ; ///<
    UINT32                                   ReservedCgtt15Override:1 ; ///<
    UINT32                                     CgVcCgttSclkOverride:1 ; ///<
    UINT32                                    CgAvpCgttSclkOverride:1 ; ///<
    UINT32                                    CgAvpCgttEclkOverride:1 ; ///<
    UINT32                                   CgUvdmCgttSclkOverride:1 ; ///<
    UINT32                                   CgUvdmCgttVclkOverride:1 ; ///<
    UINT32                                   CgUvdmCgttDclkOverride:1 ; ///<
    UINT32                                    CgBifCgttSclkOverride:1 ; ///<
    UINT32                                    CgRomCgttSclkOverride:1 ; ///<
    UINT32                                    CgDrmCgttSclkOverride:1 ; ///<
    UINT32                                     CgDcCgttSclkOverride:1 ; ///<
    UINT32                                   ReservedCgtt26Override:1 ; ///<
    UINT32                                    CgMcbCgttSclkOverride:1 ; ///<
    UINT32                                   CgMcdwCgttSclkOverride:1 ; ///<
    UINT32                                   ReservedCgtt29Override:1 ; ///<
    UINT32                                   ReservedCgtt30Override:1 ; ///<
    UINT32                                   ReservedCgtt31Override:1 ; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} FCRxFF30_01F4_STRUCT;

// **** FCRxFF30_01F5 Register Definition ****
// Address
#define FCRxFF30_01F5_ADDRESS                                   0xff3001f5

// Type
#define FCRxFF30_01F5_TYPE                                      TYPE_FCR
// Field Data
#define FCRxFF30_01F5_ReservedCgtt32Override_OFFSET             0
#define FCRxFF30_01F5_ReservedCgtt32Override_WIDTH              1
#define FCRxFF30_01F5_ReservedCgtt32Override_MASK               0x1
#define FCRxFF30_01F5_ReservedCgtt33Override_OFFSET             1
#define FCRxFF30_01F5_ReservedCgtt33Override_WIDTH              1
#define FCRxFF30_01F5_ReservedCgtt33Override_MASK               0x2
#define FCRxFF30_01F5_ReservedCgtt34Override_OFFSET             2
#define FCRxFF30_01F5_ReservedCgtt34Override_WIDTH              1
#define FCRxFF30_01F5_ReservedCgtt34Override_MASK               0x4
#define FCRxFF30_01F5_ReservedCgtt35Override_OFFSET             3
#define FCRxFF30_01F5_ReservedCgtt35Override_WIDTH              1
#define FCRxFF30_01F5_ReservedCgtt35Override_MASK               0x8
#define FCRxFF30_01F5_CgTaCgttSclkOverride_OFFSET               4
#define FCRxFF30_01F5_CgTaCgttSclkOverride_WIDTH                1
#define FCRxFF30_01F5_CgTaCgttSclkOverride_MASK                 0x10
#define FCRxFF30_01F5_CgTdCgttSclkOverride_OFFSET               5
#define FCRxFF30_01F5_CgTdCgttSclkOverride_WIDTH                1
#define FCRxFF30_01F5_CgTdCgttSclkOverride_MASK                 0x20
#define FCRxFF30_01F5_CgTcaCgttSclkOverride_OFFSET              6
#define FCRxFF30_01F5_CgTcaCgttSclkOverride_WIDTH               1
#define FCRxFF30_01F5_CgTcaCgttSclkOverride_MASK                0x40
#define FCRxFF30_01F5_CgTcpCgttSclkOverride_OFFSET              7
#define FCRxFF30_01F5_CgTcpCgttSclkOverride_WIDTH               1
#define FCRxFF30_01F5_CgTcpCgttSclkOverride_MASK                0x80
#define FCRxFF30_01F5_CgTccCgttSclkOverride_OFFSET              8
#define FCRxFF30_01F5_CgTccCgttSclkOverride_WIDTH               1
#define FCRxFF30_01F5_CgTccCgttSclkOverride_MASK                0x100
#define FCRxFF30_01F5_CgSqCgttSclkOverride_OFFSET               9
#define FCRxFF30_01F5_CgSqCgttSclkOverride_WIDTH                1
#define FCRxFF30_01F5_CgSqCgttSclkOverride_MASK                 0x200
#define FCRxFF30_01F5_CgHdpCgttSclkOverride_OFFSET              10
#define FCRxFF30_01F5_CgHdpCgttSclkOverride_WIDTH               1
#define FCRxFF30_01F5_CgHdpCgttSclkOverride_MASK                0x400
#define FCRxFF30_01F5_CgVmcCgttSclkOverride_OFFSET              11
#define FCRxFF30_01F5_CgVmcCgttSclkOverride_WIDTH               1
#define FCRxFF30_01F5_CgVmcCgttSclkOverride_MASK                0x800
#define FCRxFF30_01F5_CgOrbCgttSclkOverride_OFFSET              12
#define FCRxFF30_01F5_CgOrbCgttSclkOverride_WIDTH               1
#define FCRxFF30_01F5_CgOrbCgttSclkOverride_MASK                0x1000
#define FCRxFF30_01F5_CgOrbCgttLclkOverride_OFFSET              13
#define FCRxFF30_01F5_CgOrbCgttLclkOverride_WIDTH               1
#define FCRxFF30_01F5_CgOrbCgttLclkOverride_MASK                0x2000
#define FCRxFF30_01F5_CgIocCgttSclkOverride_OFFSET              14
#define FCRxFF30_01F5_CgIocCgttSclkOverride_WIDTH               1
#define FCRxFF30_01F5_CgIocCgttSclkOverride_MASK                0x4000
#define FCRxFF30_01F5_CgIocCgttLclkOverride_OFFSET              15
#define FCRxFF30_01F5_CgIocCgttLclkOverride_WIDTH               1
#define FCRxFF30_01F5_CgIocCgttLclkOverride_MASK                0x8000
#define FCRxFF30_01F5_CgGrbmCgttSclkOverride_OFFSET             16
#define FCRxFF30_01F5_CgGrbmCgttSclkOverride_WIDTH              1
#define FCRxFF30_01F5_CgGrbmCgttSclkOverride_MASK               0x10000
#define FCRxFF30_01F5_ReservedCgtt49Override_OFFSET             17
#define FCRxFF30_01F5_ReservedCgtt49Override_WIDTH              1
#define FCRxFF30_01F5_ReservedCgtt49Override_MASK               0x20000
#define FCRxFF30_01F5_CgSmuCgttSclkOverride_OFFSET              18
#define FCRxFF30_01F5_CgSmuCgttSclkOverride_WIDTH               1
#define FCRxFF30_01F5_CgSmuCgttSclkOverride_MASK                0x40000
#define FCRxFF30_01F5_ReservedCgtt51Override_OFFSET             19
#define FCRxFF30_01F5_ReservedCgtt51Override_WIDTH              1
#define FCRxFF30_01F5_ReservedCgtt51Override_MASK               0x80000
#define FCRxFF30_01F5_CgIhCgttSclkOverride_OFFSET               20
#define FCRxFF30_01F5_CgIhCgttSclkOverride_WIDTH                1
#define FCRxFF30_01F5_CgIhCgttSclkOverride_MASK                 0x100000
#define FCRxFF30_01F5_CgDbgCgttSclkOverride_OFFSET              21
#define FCRxFF30_01F5_CgDbgCgttSclkOverride_WIDTH               1
#define FCRxFF30_01F5_CgDbgCgttSclkOverride_MASK                0x200000
#define FCRxFF30_01F5_CgSemCgttSclkOverride_OFFSET              22
#define FCRxFF30_01F5_CgSemCgttSclkOverride_WIDTH               1
#define FCRxFF30_01F5_CgSemCgttSclkOverride_MASK                0x400000
#define FCRxFF30_01F5_CgSrbmCgttSclkOverride_OFFSET             23
#define FCRxFF30_01F5_CgSrbmCgttSclkOverride_WIDTH              1
#define FCRxFF30_01F5_CgSrbmCgttSclkOverride_MASK               0x800000
#define FCRxFF30_01F5_CgDrmdmaCgttSclkOverride_OFFSET           24
#define FCRxFF30_01F5_CgDrmdmaCgttSclkOverride_WIDTH            1
#define FCRxFF30_01F5_CgDrmdmaCgttSclkOverride_MASK             0x1000000
#define FCRxFF30_01F5_CgUvduCgttSclkOverride_OFFSET             25
#define FCRxFF30_01F5_CgUvduCgttSclkOverride_WIDTH              1
#define FCRxFF30_01F5_CgUvduCgttSclkOverride_MASK               0x2000000
#define FCRxFF30_01F5_CgUvduCgttVclkOverride_OFFSET             26
#define FCRxFF30_01F5_CgUvduCgttVclkOverride_WIDTH              1
#define FCRxFF30_01F5_CgUvduCgttVclkOverride_MASK               0x4000000
#define FCRxFF30_01F5_CgUvduCgttDclkOverride_OFFSET             27
#define FCRxFF30_01F5_CgUvduCgttDclkOverride_WIDTH              1
#define FCRxFF30_01F5_CgUvduCgttDclkOverride_MASK               0x8000000
#define FCRxFF30_01F5_CgDcCgttDispclkOverride_OFFSET            28
#define FCRxFF30_01F5_CgDcCgttDispclkOverride_WIDTH             1
#define FCRxFF30_01F5_CgDcCgttDispclkOverride_MASK              0x10000000
#define FCRxFF30_01F5_CgXbrCgttSclkOverride_OFFSET              29
#define FCRxFF30_01F5_CgXbrCgttSclkOverride_WIDTH               1
#define FCRxFF30_01F5_CgXbrCgttSclkOverride_MASK                0x20000000
#define FCRxFF30_01F5_CgSpimCgtsSclkOverride_OFFSET             30
#define FCRxFF30_01F5_CgSpimCgtsSclkOverride_WIDTH              1
#define FCRxFF30_01F5_CgSpimCgtsSclkOverride_MASK               0x40000000
#define FCRxFF30_01F5_CgSpimCgtsSclkLsOverride_OFFSET           31
#define FCRxFF30_01F5_CgSpimCgtsSclkLsOverride_WIDTH            1
#define FCRxFF30_01F5_CgSpimCgtsSclkLsOverride_MASK             0x80000000

/// FCRxFF30_01F5
typedef union {
  struct {                                                              ///<
    UINT32                                   ReservedCgtt32Override:1 ; ///<
    UINT32                                   ReservedCgtt33Override:1 ; ///<
    UINT32                                   ReservedCgtt34Override:1 ; ///<
    UINT32                                   ReservedCgtt35Override:1 ; ///<
    UINT32                                     CgTaCgttSclkOverride:1 ; ///<
    UINT32                                     CgTdCgttSclkOverride:1 ; ///<
    UINT32                                    CgTcaCgttSclkOverride:1 ; ///<
    UINT32                                    CgTcpCgttSclkOverride:1 ; ///<
    UINT32                                    CgTccCgttSclkOverride:1 ; ///<
    UINT32                                     CgSqCgttSclkOverride:1 ; ///<
    UINT32                                    CgHdpCgttSclkOverride:1 ; ///<
    UINT32                                    CgVmcCgttSclkOverride:1 ; ///<
    UINT32                                    CgOrbCgttSclkOverride:1 ; ///<
    UINT32                                    CgOrbCgttLclkOverride:1 ; ///<
    UINT32                                    CgIocCgttSclkOverride:1 ; ///<
    UINT32                                    CgIocCgttLclkOverride:1 ; ///<
    UINT32                                   CgGrbmCgttSclkOverride:1 ; ///<
    UINT32                                   ReservedCgtt49Override:1 ; ///<
    UINT32                                    CgSmuCgttSclkOverride:1 ; ///<
    UINT32                                   ReservedCgtt51Override:1 ; ///<
    UINT32                                     CgIhCgttSclkOverride:1 ; ///<
    UINT32                                    CgDbgCgttSclkOverride:1 ; ///<
    UINT32                                    CgSemCgttSclkOverride:1 ; ///<
    UINT32                                   CgSrbmCgttSclkOverride:1 ; ///<
    UINT32                                 CgDrmdmaCgttSclkOverride:1 ; ///<
    UINT32                                   CgUvduCgttSclkOverride:1 ; ///<
    UINT32                                   CgUvduCgttVclkOverride:1 ; ///<
    UINT32                                   CgUvduCgttDclkOverride:1 ; ///<
    UINT32                                  CgDcCgttDispclkOverride:1 ; ///<
    UINT32                                    CgXbrCgttSclkOverride:1 ; ///<
    UINT32                                   CgSpimCgtsSclkOverride:1 ; ///<
    UINT32                                 CgSpimCgtsSclkLsOverride:1 ; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} FCRxFF30_01F5_STRUCT;

// **** FCRxFF30_0398 Register Definition ****
// Address
#define FCRxFF30_0398_ADDRESS                                   0xff300398

// Type
#define FCRxFF30_0398_TYPE                                      TYPE_FCR
// Field Data
#define FCRxFF30_0398_Reserved_0_0_OFFSET                       0
#define FCRxFF30_0398_Reserved_0_0_WIDTH                        1
#define FCRxFF30_0398_Reserved_0_0_MASK                         0x1
#define FCRxFF30_0398_SoftResetBif_OFFSET                       1
#define FCRxFF30_0398_SoftResetBif_WIDTH                        1
#define FCRxFF30_0398_SoftResetBif_MASK                         0x2
#define FCRxFF30_0398_SoftResetCg_OFFSET                        2
#define FCRxFF30_0398_SoftResetCg_WIDTH                         1
#define FCRxFF30_0398_SoftResetCg_MASK                          0x4
#define FCRxFF30_0398_Reserved_4_3_OFFSET                       3
#define FCRxFF30_0398_Reserved_4_3_WIDTH                        2
#define FCRxFF30_0398_Reserved_4_3_MASK                         0x18
#define FCRxFF30_0398_SoftResetDc_OFFSET                        5
#define FCRxFF30_0398_SoftResetDc_WIDTH                         1
#define FCRxFF30_0398_SoftResetDc_MASK                          0x20
#define FCRxFF30_0398_Reserved_6_6_OFFSET                       6
#define FCRxFF30_0398_Reserved_6_6_WIDTH                        1
#define FCRxFF30_0398_Reserved_6_6_MASK                         0x40
#define FCRxFF30_0398_SoftResetDrm_OFFSET                       7
#define FCRxFF30_0398_SoftResetDrm_WIDTH                        1
#define FCRxFF30_0398_SoftResetDrm_MASK                         0x80
#define FCRxFF30_0398_SoftResetGrbm_OFFSET                      8
#define FCRxFF30_0398_SoftResetGrbm_WIDTH                       1
#define FCRxFF30_0398_SoftResetGrbm_MASK                        0x100
#define FCRxFF30_0398_SoftResetHdp_OFFSET                       9
#define FCRxFF30_0398_SoftResetHdp_WIDTH                        1
#define FCRxFF30_0398_SoftResetHdp_MASK                         0x200
#define FCRxFF30_0398_SoftResetIh_OFFSET                        10
#define FCRxFF30_0398_SoftResetIh_WIDTH                         1
#define FCRxFF30_0398_SoftResetIh_MASK                          0x400
#define FCRxFF30_0398_SoftResetMc_OFFSET                        11
#define FCRxFF30_0398_SoftResetMc_WIDTH                         1
#define FCRxFF30_0398_SoftResetMc_MASK                          0x800
#define FCRxFF30_0398_Reserved_12_12_OFFSET                     12
#define FCRxFF30_0398_Reserved_12_12_WIDTH                      1
#define FCRxFF30_0398_Reserved_12_12_MASK                       0x1000
#define FCRxFF30_0398_SoftResetRlc_OFFSET                       13
#define FCRxFF30_0398_SoftResetRlc_WIDTH                        1
#define FCRxFF30_0398_SoftResetRlc_MASK                         0x2000
#define FCRxFF30_0398_SoftResetRom_OFFSET                       14
#define FCRxFF30_0398_SoftResetRom_WIDTH                        1
#define FCRxFF30_0398_SoftResetRom_MASK                         0x4000
#define FCRxFF30_0398_SoftResetSem_OFFSET                       15
#define FCRxFF30_0398_SoftResetSem_WIDTH                        1
#define FCRxFF30_0398_SoftResetSem_MASK                         0x8000
#define FCRxFF30_0398_Reserved_16_16_OFFSET                     16
#define FCRxFF30_0398_Reserved_16_16_WIDTH                      1
#define FCRxFF30_0398_Reserved_16_16_MASK                       0x10000
#define FCRxFF30_0398_SoftResetVmc_OFFSET                       17
#define FCRxFF30_0398_SoftResetVmc_WIDTH                        1
#define FCRxFF30_0398_SoftResetVmc_MASK                         0x20000
#define FCRxFF30_0398_SoftResetUvd_OFFSET                       18
#define FCRxFF30_0398_SoftResetUvd_WIDTH                        1
#define FCRxFF30_0398_SoftResetUvd_MASK                         0x40000
#define FCRxFF30_0398_Reserved_19_19_OFFSET                     19
#define FCRxFF30_0398_Reserved_19_19_WIDTH                      1
#define FCRxFF30_0398_Reserved_19_19_MASK                       0x80000
#define FCRxFF30_0398_SoftResetDrmdma_OFFSET                    20
#define FCRxFF30_0398_SoftResetDrmdma_WIDTH                     1
#define FCRxFF30_0398_SoftResetDrmdma_MASK                      0x100000
#define FCRxFF30_0398_SoftResetTst_OFFSET                       21
#define FCRxFF30_0398_SoftResetTst_WIDTH                        1
#define FCRxFF30_0398_SoftResetTst_MASK                         0x200000
#define FCRxFF30_0398_SoftResetRegbb_OFFSET                     22
#define FCRxFF30_0398_SoftResetRegbb_WIDTH                      1
#define FCRxFF30_0398_SoftResetRegbb_MASK                       0x400000
#define FCRxFF30_0398_SoftResetOrb_OFFSET                       23
#define FCRxFF30_0398_SoftResetOrb_WIDTH                        1
#define FCRxFF30_0398_SoftResetOrb_MASK                         0x800000
#define FCRxFF30_0398_Reserved_31_24_OFFSET                     24
#define FCRxFF30_0398_Reserved_31_24_WIDTH                      8
#define FCRxFF30_0398_Reserved_31_24_MASK                       0xff000000

/// FCRxFF30_0398
typedef union {
  struct {                                                              ///<
    UINT32                                             Reserved_0_0:1 ; ///<
    UINT32                                             SoftResetBif:1 ; ///<
    UINT32                                              SoftResetCg:1 ; ///<
    UINT32                                             Reserved_4_3:2 ; ///<
    UINT32                                              SoftResetDc:1 ; ///<
    UINT32                                             Reserved_6_6:1 ; ///<
    UINT32                                             SoftResetDrm:1 ; ///<
    UINT32                                            SoftResetGrbm:1 ; ///<
    UINT32                                             SoftResetHdp:1 ; ///<
    UINT32                                              SoftResetIh:1 ; ///<
    UINT32                                              SoftResetMc:1 ; ///<
    UINT32                                           Reserved_12_12:1 ; ///<
    UINT32                                             SoftResetRlc:1 ; ///<
    UINT32                                             SoftResetRom:1 ; ///<
    UINT32                                             SoftResetSem:1 ; ///<
    UINT32                                           Reserved_16_16:1 ; ///<
    UINT32                                             SoftResetVmc:1 ; ///<
    UINT32                                             SoftResetUvd:1 ; ///<
    UINT32                                           Reserved_19_19:1 ; ///<
    UINT32                                          SoftResetDrmdma:1 ; ///<
    UINT32                                             SoftResetTst:1 ; ///<
    UINT32                                           SoftResetRegbb:1 ; ///<
    UINT32                                             SoftResetOrb:1 ; ///<
    UINT32                                           Reserved_31_24:8 ; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} FCRxFF30_0398_STRUCT;

// **** FCRxFF30_1512 Register Definition ****
// Address
#define FCRxFF30_1512_ADDRESS                                   0xff301512

// Type
#define FCRxFF30_1512_TYPE                                      TYPE_FCR
// Field Data
#define FCRxFF30_1512_Reserved_30_0_OFFSET                      0
#define FCRxFF30_1512_Reserved_30_0_WIDTH                       31
#define FCRxFF30_1512_Reserved_30_0_MASK                        0x7fffffff
#define FCRxFF30_1512_SoftOverride0_OFFSET                      31
#define FCRxFF30_1512_SoftOverride0_WIDTH                       1
#define FCRxFF30_1512_SoftOverride0_MASK                        0x80000000

/// FCRxFF30_1512
typedef union {
  struct {                                                              ///<
    UINT32                                            Reserved_30_0:31; ///<
    UINT32                                            SoftOverride0:1 ; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} FCRxFF30_1512_STRUCT;

// **** FCRxFF30_1529 Register Definition ****
// Address
#define FCRxFF30_1529_ADDRESS                                   0xff301529

// Type
#define FCRxFF30_1529_TYPE                                      TYPE_FCR
// Field Data
#define FCRxFF30_1529_DelayCnt_OFFSET                           0
#define FCRxFF30_1529_DelayCnt_WIDTH                            6
#define FCRxFF30_1529_DelayCnt_MASK                             0x3f
#define FCRxFF30_1529_Reserved_31_6_OFFSET                      6
#define FCRxFF30_1529_Reserved_31_6_WIDTH                       26
#define FCRxFF30_1529_Reserved_31_6_MASK                        0xffffffc0

/// FCRxFF30_1529
typedef union {
  struct {                                                              ///<
    UINT32                                                 DelayCnt:6 ; ///<
    UINT32                                            Reserved_31_6:26; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} FCRxFF30_1529_STRUCT;

// **** D0F0x64_x00 Register Definition ****
// Address
#define D0F0x64_x00_ADDRESS                                     0x0

// Type
#define D0F0x64_x00_TYPE                                        TYPE_D0F0x64
// Field Data
#define D0F0x64_x00_Reserved_5_0_OFFSET                         0
#define D0F0x64_x00_Reserved_5_0_WIDTH                          6
#define D0F0x64_x00_Reserved_5_0_MASK                           0x3f
#define D0F0x64_x00_NbFchCfgEn_OFFSET                           6
#define D0F0x64_x00_NbFchCfgEn_WIDTH                            1
#define D0F0x64_x00_NbFchCfgEn_MASK                             0x40
#define D0F0x64_x00_HwInitWrLock_OFFSET                         7
#define D0F0x64_x00_HwInitWrLock_WIDTH                          1
#define D0F0x64_x00_HwInitWrLock_MASK                           0x80
#define D0F0x64_x00_Reserved_31_8_OFFSET                        8
#define D0F0x64_x00_Reserved_31_8_WIDTH                         24
#define D0F0x64_x00_Reserved_31_8_MASK                          0xffffff00

/// D0F0x64_x00
typedef union {
  struct {                                                              ///<
    UINT32                                             Reserved_5_0:6 ; ///<
    UINT32                                               NbFchCfgEn:1 ; ///<
    UINT32                                             HwInitWrLock:1 ; ///<
    UINT32                                            Reserved_31_8:24; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} D0F0x64_x00_STRUCT;

// **** D0F0x64_x0B Register Definition ****
// Address
#define D0F0x64_x0B_ADDRESS                                     0xb

// Type
#define D0F0x64_x0B_TYPE                                        TYPE_D0F0x64
// Field Data
#define D0F0x64_x0B_Reserved_19_0_OFFSET                        0
#define D0F0x64_x0B_Reserved_19_0_WIDTH                         20
#define D0F0x64_x0B_Reserved_19_0_MASK                          0xfffff
#define D0F0x64_x0B_SetPowEn_OFFSET                             20
#define D0F0x64_x0B_SetPowEn_WIDTH                              1
#define D0F0x64_x0B_SetPowEn_MASK                               0x100000
#define D0F0x64_x0B_IocFchSetPowEn_OFFSET                       21
#define D0F0x64_x0B_IocFchSetPowEn_WIDTH                        1
#define D0F0x64_x0B_IocFchSetPowEn_MASK                         0x200000
#define D0F0x64_x0B_Reserved_22_22_OFFSET                       22
#define D0F0x64_x0B_Reserved_22_22_WIDTH                        1
#define D0F0x64_x0B_Reserved_22_22_MASK                         0x400000
#define D0F0x64_x0B_IocFchSetPmeTurnOffEn_OFFSET                23
#define D0F0x64_x0B_IocFchSetPmeTurnOffEn_WIDTH                 1
#define D0F0x64_x0B_IocFchSetPmeTurnOffEn_MASK                  0x800000
#define D0F0x64_x0B_Reserved_31_24_OFFSET                       24
#define D0F0x64_x0B_Reserved_31_24_WIDTH                        8
#define D0F0x64_x0B_Reserved_31_24_MASK                         0xff000000

/// D0F0x64_x0B
typedef union {
  struct {                                                              ///<
    UINT32                                            Reserved_19_0:20; ///<
    UINT32                                                 SetPowEn:1 ; ///<
    UINT32                                           IocFchSetPowEn:1 ; ///<
    UINT32                                           Reserved_22_22:1 ; ///<
    UINT32                                    IocFchSetPmeTurnOffEn:1 ; ///<
    UINT32                                           Reserved_31_24:8 ; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} D0F0x64_x0B_STRUCT;

// **** D0F0x64_x0C Register Definition ****
// Address
#define D0F0x64_x0C_ADDRESS                                     0xc

// Type
#define D0F0x64_x0C_TYPE                                        TYPE_D0F0x64
// Field Data
#define D0F0x64_x0C_Reserved_1_0_OFFSET                         0
#define D0F0x64_x0C_Reserved_1_0_WIDTH                          2
#define D0F0x64_x0C_Reserved_1_0_MASK                           0x3
#define D0F0x64_x0C_Dev2BridgeDis_OFFSET                        2
#define D0F0x64_x0C_Dev2BridgeDis_WIDTH                         1
#define D0F0x64_x0C_Dev2BridgeDis_MASK                          0x4
#define D0F0x64_x0C_Dev3BridgeDis_OFFSET                        3
#define D0F0x64_x0C_Dev3BridgeDis_WIDTH                         1
#define D0F0x64_x0C_Dev3BridgeDis_MASK                          0x8
#define D0F0x64_x0C_Dev4BridgeDis_OFFSET                        4
#define D0F0x64_x0C_Dev4BridgeDis_WIDTH                         1
#define D0F0x64_x0C_Dev4BridgeDis_MASK                          0x10
#define D0F0x64_x0C_Dev5BridgeDis_OFFSET                        5
#define D0F0x64_x0C_Dev5BridgeDis_WIDTH                         1
#define D0F0x64_x0C_Dev5BridgeDis_MASK                          0x20
#define D0F0x64_x0C_Dev6BridgeDis_OFFSET                        6
#define D0F0x64_x0C_Dev6BridgeDis_WIDTH                         1
#define D0F0x64_x0C_Dev6BridgeDis_MASK                          0x40
#define D0F0x64_x0C_Dev7BridgeDis_OFFSET                        7
#define D0F0x64_x0C_Dev7BridgeDis_WIDTH                         1
#define D0F0x64_x0C_Dev7BridgeDis_MASK                          0x80
#define D0F0x64_x0C_Reserved_31_8_OFFSET                        8
#define D0F0x64_x0C_Reserved_31_8_WIDTH                         24
#define D0F0x64_x0C_Reserved_31_8_MASK                          0xffffff00

/// D0F0x64_x0C
typedef union {
  struct {                                                              ///<
    UINT32                                             Reserved_1_0:2 ; ///<
    UINT32                                            Dev2BridgeDis:1 ; ///<
    UINT32                                            Dev3BridgeDis:1 ; ///<
    UINT32                                            Dev4BridgeDis:1 ; ///<
    UINT32                                            Dev5BridgeDis:1 ; ///<
    UINT32                                            Dev6BridgeDis:1 ; ///<
    UINT32                                            Dev7BridgeDis:1 ; ///<
    UINT32                                            Reserved_31_8:24; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} D0F0x64_x0C_STRUCT;

// **** D0F0x64_x19 Register Definition ****
// Address
#define D0F0x64_x19_ADDRESS                                     0x19

// Type
#define D0F0x64_x19_TYPE                                        TYPE_D0F0x64
// Field Data
#define D0F0x64_x19_TomEn_OFFSET                                0
#define D0F0x64_x19_TomEn_WIDTH                                 1
#define D0F0x64_x19_TomEn_MASK                                  0x1
#define D0F0x64_x19_Reserved_22_1_OFFSET                        1
#define D0F0x64_x19_Reserved_22_1_WIDTH                         22
#define D0F0x64_x19_Reserved_22_1_MASK                          0x7ffffe
#define D0F0x64_x19_Tom2_31_23__OFFSET                          23
#define D0F0x64_x19_Tom2_31_23__WIDTH                           9
#define D0F0x64_x19_Tom2_31_23__MASK                            0xff800000

/// D0F0x64_x19
typedef union {
  struct {                                                              ///<
    UINT32                                                    TomEn:1 ; ///<
    UINT32                                            Reserved_22_1:22; ///<
    UINT32                                              Tom2_31_23_:9 ; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} D0F0x64_x19_STRUCT;

// **** D0F0x64_x1A Register Definition ****
// Address
#define D0F0x64_x1A_ADDRESS                                     0x1a

// Type
#define D0F0x64_x1A_TYPE                                        TYPE_D0F0x64
// Field Data
#define D0F0x64_x1A_Tom2_39_32__OFFSET                          0
#define D0F0x64_x1A_Tom2_39_32__WIDTH                           8
#define D0F0x64_x1A_Tom2_39_32__MASK                            0xff
#define D0F0x64_x1A_Reserved_31_8_OFFSET                        8
#define D0F0x64_x1A_Reserved_31_8_WIDTH                         24
#define D0F0x64_x1A_Reserved_31_8_MASK                          0xffffff00

/// D0F0x64_x1A
typedef union {
  struct {                                                              ///<
    UINT32                                              Tom2_39_32_:8 ; ///<
    UINT32                                            Reserved_31_8:24; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} D0F0x64_x1A_STRUCT;

// **** D0F0x64_x1D Register Definition ****
// Address
#define D0F0x64_x1D_ADDRESS                                     0x1d

// Type
#define D0F0x64_x1D_TYPE                                        TYPE_D0F0x64
// Field Data
#define D0F0x64_x1D_IntGfxAsPcieEn_OFFSET                       0
#define D0F0x64_x1D_IntGfxAsPcieEn_WIDTH                        1
#define D0F0x64_x1D_IntGfxAsPcieEn_MASK                         0x1
#define D0F0x64_x1D_VgaEn_OFFSET                                1
#define D0F0x64_x1D_VgaEn_WIDTH                                 1
#define D0F0x64_x1D_VgaEn_MASK                                  0x2
#define D0F0x64_x1D_Reserved_2_2_OFFSET                         2
#define D0F0x64_x1D_Reserved_2_2_WIDTH                          1
#define D0F0x64_x1D_Reserved_2_2_MASK                           0x4
#define D0F0x64_x1D_Vga16En_OFFSET                              3
#define D0F0x64_x1D_Vga16En_WIDTH                               1
#define D0F0x64_x1D_Vga16En_MASK                                0x8
#define D0F0x64_x1D_Reserved_31_4_OFFSET                        4
#define D0F0x64_x1D_Reserved_31_4_WIDTH                         28
#define D0F0x64_x1D_Reserved_31_4_MASK                          0xfffffff0

/// D0F0x64_x1D
typedef union {
  struct {                                                              ///<
    UINT32                                           IntGfxAsPcieEn:1 ; ///<
    UINT32                                                    VgaEn:1 ; ///<
    UINT32                                             Reserved_2_2:1 ; ///<
    UINT32                                                  Vga16En:1 ; ///<
    UINT32                                            Reserved_31_4:28; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} D0F0x64_x1D_STRUCT;

// **** D0F0x64_x20 Register Definition ****
// Address
#define D0F0x64_x20_ADDRESS                                     0x20

// Type
#define D0F0x64_x20_TYPE                                        TYPE_D0F0x64
// Field Data
#define D0F0x64_x20_Reserved_0_0_OFFSET                         0
#define D0F0x64_x20_Reserved_0_0_WIDTH                          1
#define D0F0x64_x20_Reserved_0_0_MASK                           0x1
#define D0F0x64_x20_IocPcieDevRemapDis_OFFSET                   1
#define D0F0x64_x20_IocPcieDevRemapDis_WIDTH                    1
#define D0F0x64_x20_IocPcieDevRemapDis_MASK                     0x2
#define D0F0x64_x20_Reserved_31_2_OFFSET                        2
#define D0F0x64_x20_Reserved_31_2_WIDTH                         30
#define D0F0x64_x20_Reserved_31_2_MASK                          0xfffffffc

/// D0F0x64_x20
typedef union {
  struct {                                                              ///<
    UINT32                                             Reserved_0_0:1 ; ///<
    UINT32                                       IocPcieDevRemapDis:1 ; ///<
    UINT32                                            Reserved_31_2:30; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} D0F0x64_x20_STRUCT;

// **** D0F0x64_x22 Register Definition ****
// Address
#define D0F0x64_x22_ADDRESS                                     0x22

// Type
#define D0F0x64_x22_TYPE                                        TYPE_D0F0x64
// Field Data
#define D0F0x64_x22_Reserved_3_0_OFFSET                         0
#define D0F0x64_x22_Reserved_3_0_WIDTH                          4
#define D0F0x64_x22_Reserved_3_0_MASK                           0xf
#define D0F0x64_x22_OffHysteresis_OFFSET                        4
#define D0F0x64_x22_OffHysteresis_WIDTH                         8
#define D0F0x64_x22_OffHysteresis_MASK                          0xff0
#define D0F0x64_x22_Reserved_25_12_OFFSET                       12
#define D0F0x64_x22_Reserved_25_12_WIDTH                        14
#define D0F0x64_x22_Reserved_25_12_MASK                         0x3fff000
#define D0F0x64_x22_SoftOverrideClk4_OFFSET                     26
#define D0F0x64_x22_SoftOverrideClk4_WIDTH                      1
#define D0F0x64_x22_SoftOverrideClk4_MASK                       0x4000000
#define D0F0x64_x22_SoftOverrideClk3_OFFSET                     27
#define D0F0x64_x22_SoftOverrideClk3_WIDTH                      1
#define D0F0x64_x22_SoftOverrideClk3_MASK                       0x8000000
#define D0F0x64_x22_SoftOverrideClk2_OFFSET                     28
#define D0F0x64_x22_SoftOverrideClk2_WIDTH                      1
#define D0F0x64_x22_SoftOverrideClk2_MASK                       0x10000000
#define D0F0x64_x22_SoftOverrideClk1_OFFSET                     29
#define D0F0x64_x22_SoftOverrideClk1_WIDTH                      1
#define D0F0x64_x22_SoftOverrideClk1_MASK                       0x20000000
#define D0F0x64_x22_SoftOverrideClk0_OFFSET                     30
#define D0F0x64_x22_SoftOverrideClk0_WIDTH                      1
#define D0F0x64_x22_SoftOverrideClk0_MASK                       0x40000000
#define D0F0x64_x22_Reserved_31_31_OFFSET                       31
#define D0F0x64_x22_Reserved_31_31_WIDTH                        1
#define D0F0x64_x22_Reserved_31_31_MASK                         0x80000000

/// D0F0x64_x22
typedef union {
  struct {                                                              ///<
    UINT32                                             Reserved_3_0:4 ; ///<
    UINT32                                            OffHysteresis:8 ; ///<
    UINT32                                           Reserved_25_12:14; ///<
    UINT32                                         SoftOverrideClk4:1 ; ///<
    UINT32                                         SoftOverrideClk3:1 ; ///<
    UINT32                                         SoftOverrideClk2:1 ; ///<
    UINT32                                         SoftOverrideClk1:1 ; ///<
    UINT32                                         SoftOverrideClk0:1 ; ///<
    UINT32                                           Reserved_31_31:1 ; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} D0F0x64_x22_STRUCT;

// **** D0F0x64_x23 Register Definition ****
// Address
#define D0F0x64_x23_ADDRESS                                     0x23

// Type
#define D0F0x64_x23_TYPE                                        TYPE_D0F0x64
// Field Data
#define D0F0x64_x23_Reserved_3_0_OFFSET                         0
#define D0F0x64_x23_Reserved_3_0_WIDTH                          4
#define D0F0x64_x23_Reserved_3_0_MASK                           0xf
#define D0F0x64_x23_OffHysteresis_OFFSET                        4
#define D0F0x64_x23_OffHysteresis_WIDTH                         8
#define D0F0x64_x23_OffHysteresis_MASK                          0xff0
#define D0F0x64_x23_Reserved_25_12_OFFSET                       12
#define D0F0x64_x23_Reserved_25_12_WIDTH                        14
#define D0F0x64_x23_Reserved_25_12_MASK                         0x3fff000
#define D0F0x64_x23_SoftOverrideClk4_OFFSET                     26
#define D0F0x64_x23_SoftOverrideClk4_WIDTH                      1
#define D0F0x64_x23_SoftOverrideClk4_MASK                       0x4000000
#define D0F0x64_x23_SoftOverrideClk3_OFFSET                     27
#define D0F0x64_x23_SoftOverrideClk3_WIDTH                      1
#define D0F0x64_x23_SoftOverrideClk3_MASK                       0x8000000
#define D0F0x64_x23_SoftOverrideClk2_OFFSET                     28
#define D0F0x64_x23_SoftOverrideClk2_WIDTH                      1
#define D0F0x64_x23_SoftOverrideClk2_MASK                       0x10000000
#define D0F0x64_x23_SoftOverrideClk1_OFFSET                     29
#define D0F0x64_x23_SoftOverrideClk1_WIDTH                      1
#define D0F0x64_x23_SoftOverrideClk1_MASK                       0x20000000
#define D0F0x64_x23_SoftOverrideClk0_OFFSET                     30
#define D0F0x64_x23_SoftOverrideClk0_WIDTH                      1
#define D0F0x64_x23_SoftOverrideClk0_MASK                       0x40000000
#define D0F0x64_x23_Reserved_31_31_OFFSET                       31
#define D0F0x64_x23_Reserved_31_31_WIDTH                        1
#define D0F0x64_x23_Reserved_31_31_MASK                         0x80000000

/// D0F0x64_x23
typedef union {
  struct {                                                              ///<
    UINT32                                             Reserved_3_0:4 ; ///<
    UINT32                                            OffHysteresis:8 ; ///<
    UINT32                                           Reserved_25_12:14; ///<
    UINT32                                         SoftOverrideClk4:1 ; ///<
    UINT32                                         SoftOverrideClk3:1 ; ///<
    UINT32                                         SoftOverrideClk2:1 ; ///<
    UINT32                                         SoftOverrideClk1:1 ; ///<
    UINT32                                         SoftOverrideClk0:1 ; ///<
    UINT32                                           Reserved_31_31:1 ; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} D0F0x64_x23_STRUCT;

// **** D0F0x64_x24 Register Definition ****
// Address
#define D0F0x64_x24_ADDRESS                                     0x24

// Type
#define D0F0x64_x24_TYPE                                        TYPE_D0F0x64
// Field Data
#define D0F0x64_x24_Reserved_3_0_OFFSET                         0
#define D0F0x64_x24_Reserved_3_0_WIDTH                          4
#define D0F0x64_x24_Reserved_3_0_MASK                           0xf
#define D0F0x64_x24_OffHysteresis_OFFSET                        4
#define D0F0x64_x24_OffHysteresis_WIDTH                         8
#define D0F0x64_x24_OffHysteresis_MASK                          0xff0
#define D0F0x64_x24_Reserved_28_12_OFFSET                       12
#define D0F0x64_x24_Reserved_28_12_WIDTH                        17
#define D0F0x64_x24_Reserved_28_12_MASK                         0x1ffff000
#define D0F0x64_x24_SoftOverrideClk1_OFFSET                     29
#define D0F0x64_x24_SoftOverrideClk1_WIDTH                      1
#define D0F0x64_x24_SoftOverrideClk1_MASK                       0x20000000
#define D0F0x64_x24_SoftOverrideClk0_OFFSET                     30
#define D0F0x64_x24_SoftOverrideClk0_WIDTH                      1
#define D0F0x64_x24_SoftOverrideClk0_MASK                       0x40000000
#define D0F0x64_x24_Reserved_31_31_OFFSET                       31
#define D0F0x64_x24_Reserved_31_31_WIDTH                        1
#define D0F0x64_x24_Reserved_31_31_MASK                         0x80000000

/// D0F0x64_x24
typedef union {
  struct {                                                              ///<
    UINT32                                             Reserved_3_0:4 ; ///<
    UINT32                                            OffHysteresis:8 ; ///<
    UINT32                                           Reserved_28_12:17; ///<
    UINT32                                         SoftOverrideClk1:1 ; ///<
    UINT32                                         SoftOverrideClk0:1 ; ///<
    UINT32                                           Reserved_31_31:1 ; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} D0F0x64_x24_STRUCT;


// **** D0F0x64_x4D Register Definition ****
// Address
#define D0F0x64_x4D_ADDRESS                                     0x4d

// Type
#define D0F0x64_x4D_TYPE                                        TYPE_D0F0x64
// Field Data
#define D0F0x64_x4D_WriteData_OFFSET                            0
#define D0F0x64_x4D_WriteData_WIDTH                             16
#define D0F0x64_x4D_WriteData_MASK                              0xffff
#define D0F0x64_x4D_SmuAddr_OFFSET                              16
#define D0F0x64_x4D_SmuAddr_WIDTH                               8
#define D0F0x64_x4D_SmuAddr_MASK                                0xff0000
#define D0F0x64_x4D_ReqToggle_OFFSET                            24
#define D0F0x64_x4D_ReqToggle_WIDTH                             1
#define D0F0x64_x4D_ReqToggle_MASK                              0x1000000
#define D0F0x64_x4D_ReqType_OFFSET                              25
#define D0F0x64_x4D_ReqType_WIDTH                               1
#define D0F0x64_x4D_ReqType_MASK                                0x2000000
#define D0F0x64_x4D_Reserved_31_26_OFFSET                       26
#define D0F0x64_x4D_Reserved_31_26_WIDTH                        6
#define D0F0x64_x4D_Reserved_31_26_MASK                         0xfc000000

/// D0F0x64_x4D
typedef union {
  struct {                                                              ///<
    UINT32                                                WriteData:16; ///<
    UINT32                                                  SmuAddr:8 ; ///<
    UINT32                                                ReqToggle:1 ; ///<
    UINT32                                                  ReqType:1 ; ///<
    UINT32                                           Reserved_31_26:6 ; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} D0F0x64_x4D_STRUCT;

// **** D0F0x64_x4E Register Definition ****
// Address
#define D0F0x64_x4E_ADDRESS                                     0x4e

// Type
#define D0F0x64_x4E_TYPE                                        TYPE_D0F0x64
// Field Data
#define D0F0x64_x4E_SmuReadData_OFFSET                          0
#define D0F0x64_x4E_SmuReadData_WIDTH                           32
#define D0F0x64_x4E_SmuReadData_MASK                            0xffffffff

/// D0F0x64_x4E
typedef union {
  struct {                                                              ///<
    UINT32                                              SmuReadData:32; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} D0F0x64_x4E_STRUCT;

// **** D0F0x64_x53 Register Definition ****
// Address
#define D0F0x64_x53_ADDRESS                                     0x53

// Type
#define D0F0x64_x53_TYPE                                        TYPE_D0F0x64
// Field Data
#define D0F0x64_x53_Reserved_19_0_OFFSET                        0
#define D0F0x64_x53_Reserved_19_0_WIDTH                         20
#define D0F0x64_x53_Reserved_19_0_MASK                          0xfffff
#define D0F0x64_x53_SetPowEn_OFFSET                             20
#define D0F0x64_x53_SetPowEn_WIDTH                              1
#define D0F0x64_x53_SetPowEn_MASK                               0x100000
#define D0F0x64_x53_Reserved_31_21_OFFSET                       21
#define D0F0x64_x53_Reserved_31_21_WIDTH                        11
#define D0F0x64_x53_Reserved_31_21_MASK                         0xffe00000

/// D0F0x64_x53
typedef union {
  struct {                                                              ///<
    UINT32                                            Reserved_19_0:20; ///<
    UINT32                                                 SetPowEn:1 ; ///<
    UINT32                                           Reserved_31_21:11; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} D0F0x64_x53_STRUCT;

// **** D0F0x64_x55 Register Definition ****
// Address
#define D0F0x64_x55_ADDRESS                                     0x55

// Type
#define D0F0x64_x55_TYPE                                        TYPE_D0F0x64
// Field Data
#define D0F0x64_x55_Reserved_19_0_OFFSET                        0
#define D0F0x64_x55_Reserved_19_0_WIDTH                         20
#define D0F0x64_x55_Reserved_19_0_MASK                          0xfffff
#define D0F0x64_x55_SetPowEn_OFFSET                             20
#define D0F0x64_x55_SetPowEn_WIDTH                              1
#define D0F0x64_x55_SetPowEn_MASK                               0x100000
#define D0F0x64_x55_Reserved_31_21_OFFSET                       21
#define D0F0x64_x55_Reserved_31_21_WIDTH                        11
#define D0F0x64_x55_Reserved_31_21_MASK                         0xffe00000

/// D0F0x64_x55
typedef union {
  struct {                                                              ///<
    UINT32                                            Reserved_19_0:20; ///<
    UINT32                                                 SetPowEn:1 ; ///<
    UINT32                                           Reserved_31_21:11; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} D0F0x64_x55_STRUCT;

// **** D0F0x64_x57 Register Definition ****
// Address
#define D0F0x64_x57_ADDRESS                                     0x57

// Type
#define D0F0x64_x57_TYPE                                        TYPE_D0F0x64
// Field Data
#define D0F0x64_x57_Reserved_19_0_OFFSET                        0
#define D0F0x64_x57_Reserved_19_0_WIDTH                         20
#define D0F0x64_x57_Reserved_19_0_MASK                          0xfffff
#define D0F0x64_x57_SetPowEn_OFFSET                             20
#define D0F0x64_x57_SetPowEn_WIDTH                              1
#define D0F0x64_x57_SetPowEn_MASK                               0x100000
#define D0F0x64_x57_Reserved_31_21_OFFSET                       21
#define D0F0x64_x57_Reserved_31_21_WIDTH                        11
#define D0F0x64_x57_Reserved_31_21_MASK                         0xffe00000

/// D0F0x64_x57
typedef union {
  struct {                                                              ///<
    UINT32                                            Reserved_19_0:20; ///<
    UINT32                                                 SetPowEn:1 ; ///<
    UINT32                                           Reserved_31_21:11; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} D0F0x64_x57_STRUCT;

// **** D0F0x64_x59 Register Definition ****
// Address
#define D0F0x64_x59_ADDRESS                                     0x59

// Type
#define D0F0x64_x59_TYPE                                        TYPE_D0F0x64
// Field Data
#define D0F0x64_x59_Reserved_19_0_OFFSET                        0
#define D0F0x64_x59_Reserved_19_0_WIDTH                         20
#define D0F0x64_x59_Reserved_19_0_MASK                          0xfffff
#define D0F0x64_x59_SetPowEn_OFFSET                             20
#define D0F0x64_x59_SetPowEn_WIDTH                              1
#define D0F0x64_x59_SetPowEn_MASK                               0x100000
#define D0F0x64_x59_Reserved_31_21_OFFSET                       21
#define D0F0x64_x59_Reserved_31_21_WIDTH                        11
#define D0F0x64_x59_Reserved_31_21_MASK                         0xffe00000

/// D0F0x64_x59
typedef union {
  struct {                                                              ///<
    UINT32                                            Reserved_19_0:20; ///<
    UINT32                                                 SetPowEn:1 ; ///<
    UINT32                                           Reserved_31_21:11; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} D0F0x64_x59_STRUCT;

// **** D0F0x64_x5B Register Definition ****
// Address
#define D0F0x64_x5B_ADDRESS                                     0x5b

// Type
#define D0F0x64_x5B_TYPE                                        TYPE_D0F0x64
// Field Data
#define D0F0x64_x5B_Reserved_19_0_OFFSET                        0
#define D0F0x64_x5B_Reserved_19_0_WIDTH                         20
#define D0F0x64_x5B_Reserved_19_0_MASK                          0xfffff
#define D0F0x64_x5B_SetPowEn_OFFSET                             20
#define D0F0x64_x5B_SetPowEn_WIDTH                              1
#define D0F0x64_x5B_SetPowEn_MASK                               0x100000
#define D0F0x64_x5B_Reserved_31_21_OFFSET                       21
#define D0F0x64_x5B_Reserved_31_21_WIDTH                        11
#define D0F0x64_x5B_Reserved_31_21_MASK                         0xffe00000

/// D0F0x64_x5B
typedef union {
  struct {                                                              ///<
    UINT32                                            Reserved_19_0:20; ///<
    UINT32                                                 SetPowEn:1 ; ///<
    UINT32                                           Reserved_31_21:11; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} D0F0x64_x5B_STRUCT;

// **** D0F0x64_x6A Register Definition ****
// Address
#define D0F0x64_x6A_ADDRESS                                     0x6a

// Type
#define D0F0x64_x6A_TYPE                                        TYPE_D0F0x64
// Field Data
#define D0F0x64_x6A_VoltageForceEn_OFFSET                       0
#define D0F0x64_x6A_VoltageForceEn_WIDTH                        1
#define D0F0x64_x6A_VoltageForceEn_MASK                         0x1
#define D0F0x64_x6A_VoltageChangeEn_OFFSET                      1
#define D0F0x64_x6A_VoltageChangeEn_WIDTH                       1
#define D0F0x64_x6A_VoltageChangeEn_MASK                        0x2
#define D0F0x64_x6A_VoltageChangeReq_OFFSET                     2
#define D0F0x64_x6A_VoltageChangeReq_WIDTH                      1
#define D0F0x64_x6A_VoltageChangeReq_MASK                       0x4
#define D0F0x64_x6A_VoltageLevel_OFFSET                         3
#define D0F0x64_x6A_VoltageLevel_WIDTH                          2
#define D0F0x64_x6A_VoltageLevel_MASK                           0x18
#define D0F0x64_x6A_Reserved_31_5_OFFSET                        5
#define D0F0x64_x6A_Reserved_31_5_WIDTH                         27
#define D0F0x64_x6A_Reserved_31_5_MASK                          0xffffffe0

/// D0F0x64_x6A
typedef union {
  struct {                                                              ///<
    UINT32                                           VoltageForceEn:1 ; ///<
    UINT32                                          VoltageChangeEn:1 ; ///<
    UINT32                                         VoltageChangeReq:1 ; ///<
    UINT32                                             VoltageLevel:2 ; ///<
    UINT32                                            Reserved_31_5:27; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} D0F0x64_x6A_STRUCT;

// **** D0F0x64_x6B Register Definition ****
// Address
#define D0F0x64_x6B_ADDRESS                                     0x6b

// Type
#define D0F0x64_x6B_TYPE                                        TYPE_D0F0x64
// Field Data
#define D0F0x64_x6B_VoltageChangeAck_OFFSET                     0
#define D0F0x64_x6B_VoltageChangeAck_WIDTH                      1
#define D0F0x64_x6B_VoltageChangeAck_MASK                       0x1
#define D0F0x64_x6B_CurrentVoltageLevel_OFFSET                  1
#define D0F0x64_x6B_CurrentVoltageLevel_WIDTH                   2
#define D0F0x64_x6B_CurrentVoltageLevel_MASK                    0x6
#define D0F0x64_x6B_Reserved_31_3_OFFSET                        3
#define D0F0x64_x6B_Reserved_31_3_WIDTH                         29
#define D0F0x64_x6B_Reserved_31_3_MASK                          0xfffffff8

/// D0F0x64_x6B
typedef union {
  struct {                                                              ///<
    UINT32                                         VoltageChangeAck:1 ; ///<
    UINT32                                      CurrentVoltageLevel:2 ; ///<
    UINT32                                            Reserved_31_3:29; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} D0F0x64_x6B_STRUCT;

// **** D0F0x98_x06 Register Definition ****
// Address
#define D0F0x98_x06_ADDRESS                                     0x6

// Type
#define D0F0x98_x06_TYPE                                        TYPE_D0F0x98
// Field Data
#define D0F0x98_x06_Reserved_25_0_OFFSET                        0
#define D0F0x98_x06_Reserved_25_0_WIDTH                         26
#define D0F0x98_x06_Reserved_25_0_MASK                          0x3ffffff
#define D0F0x98_x06_UmiNpMemWrEn_OFFSET                         26
#define D0F0x98_x06_UmiNpMemWrEn_WIDTH                          1
#define D0F0x98_x06_UmiNpMemWrEn_MASK                           0x4000000
#define D0F0x98_x06_Reserved_31_27_OFFSET                       27
#define D0F0x98_x06_Reserved_31_27_WIDTH                        5
#define D0F0x98_x06_Reserved_31_27_MASK                         0xf8000000

/// D0F0x98_x06
typedef union {
  struct {                                                              ///<
    UINT32                                            Reserved_25_0:26; ///<
    UINT32                                             UmiNpMemWrEn:1 ; ///<
    UINT32                                           Reserved_31_27:5 ; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} D0F0x98_x06_STRUCT;

// **** D0F0x98_x07 Register Definition ****
// Address
#define D0F0x98_x07_ADDRESS                                     0x7

// Type
#define D0F0x98_x07_TYPE                                        TYPE_D0F0x98
// Field Data
#define D0F0x98_x07_IocBwOptEn_OFFSET                           0
#define D0F0x98_x07_IocBwOptEn_WIDTH                            1
#define D0F0x98_x07_IocBwOptEn_MASK                             0x1
#define D0F0x98_x07_Reserved_13_1_OFFSET                        1
#define D0F0x98_x07_Reserved_13_1_WIDTH                         13
#define D0F0x98_x07_Reserved_13_1_MASK                          0x3ffe
#define D0F0x98_x07_MSIHTIntConversionEn_OFFSET                 14
#define D0F0x98_x07_MSIHTIntConversionEn_WIDTH                  1
#define D0F0x98_x07_MSIHTIntConversionEn_MASK                   0x4000
#define D0F0x98_x07_DropZeroMaskWrEn_OFFSET                     15
#define D0F0x98_x07_DropZeroMaskWrEn_WIDTH                      1
#define D0F0x98_x07_DropZeroMaskWrEn_MASK                       0x8000
#define D0F0x98_x07_Reserved_31_16_OFFSET                       16
#define D0F0x98_x07_Reserved_31_16_WIDTH                        16
#define D0F0x98_x07_Reserved_31_16_MASK                         0xffff0000

/// D0F0x98_x07
typedef union {
  struct {                                                              ///<
    UINT32                                               IocBwOptEn:1 ; ///<
    UINT32                                            Reserved_13_1:13; ///<
    UINT32                                     MSIHTIntConversionEn:1 ; ///<
    UINT32                                         DropZeroMaskWrEn:1 ; ///<
    UINT32                                           Reserved_31_16:16; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} D0F0x98_x07_STRUCT;

// **** D0F0x98_x08 Register Definition ****
// Address
#define D0F0x98_x08_ADDRESS                                     0x8

// Type
#define D0F0x98_x08_TYPE                                        TYPE_D0F0x98
// Field Data
#define D0F0x98_x08_NpWrrLenA_OFFSET                            0
#define D0F0x98_x08_NpWrrLenA_WIDTH                             8
#define D0F0x98_x08_NpWrrLenA_MASK                              0xff
#define D0F0x98_x08_Reserved_15_8_OFFSET                        8
#define D0F0x98_x08_Reserved_15_8_WIDTH                         8
#define D0F0x98_x08_Reserved_15_8_MASK                          0xff00
#define D0F0x98_x08_NpWrrLenC_OFFSET                            16
#define D0F0x98_x08_NpWrrLenC_WIDTH                             8
#define D0F0x98_x08_NpWrrLenC_MASK                              0xff0000
#define D0F0x98_x08_Reserved_31_24_OFFSET                       24
#define D0F0x98_x08_Reserved_31_24_WIDTH                        8
#define D0F0x98_x08_Reserved_31_24_MASK                         0xff000000

/// D0F0x98_x08
typedef union {
  struct {                                                              ///<
    UINT32                                                NpWrrLenA:8 ; ///<
    UINT32                                            Reserved_15_8:8 ; ///<
    UINT32                                                NpWrrLenC:8 ; ///<
    UINT32                                           Reserved_31_24:8 ; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} D0F0x98_x08_STRUCT;

// **** D0F0x98_x09 Register Definition ****
// Address
#define D0F0x98_x09_ADDRESS                                     0x9

// Type
#define D0F0x98_x09_TYPE                                        TYPE_D0F0x98
// Field Data
#define D0F0x98_x09_PWrrLenA_OFFSET                             0
#define D0F0x98_x09_PWrrLenA_WIDTH                              8
#define D0F0x98_x09_PWrrLenA_MASK                               0xff
#define D0F0x98_x09_Reserved_23_8_OFFSET                        8
#define D0F0x98_x09_Reserved_23_8_WIDTH                         16
#define D0F0x98_x09_Reserved_23_8_MASK                          0xffff00
#define D0F0x98_x09_PWrrLenD_OFFSET                             24
#define D0F0x98_x09_PWrrLenD_WIDTH                              8
#define D0F0x98_x09_PWrrLenD_MASK                               0xff000000

/// D0F0x98_x09
typedef union {
  struct {                                                              ///<
    UINT32                                                 PWrrLenA:8 ; ///<
    UINT32                                            Reserved_23_8:16; ///<
    UINT32                                                 PWrrLenD:8 ; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} D0F0x98_x09_STRUCT;


// **** D0F0x98_x0E Register Definition ****
// Address
#define D0F0x98_x0E_ADDRESS                                     0xe

// Type
#define D0F0x98_x0E_TYPE                                        TYPE_D0F0x98
// Field Data
#define D0F0x98_x0E_MsiHtRsvIntRemapEn_OFFSET                   0
#define D0F0x98_x0E_MsiHtRsvIntRemapEn_WIDTH                    1
#define D0F0x98_x0E_MsiHtRsvIntRemapEn_MASK                     0x1
#define D0F0x98_x0E_Reserved_1_1_OFFSET                         1
#define D0F0x98_x0E_Reserved_1_1_WIDTH                          1
#define D0F0x98_x0E_Reserved_1_1_MASK                           0x2
#define D0F0x98_x0E_MsiHtRsvIntMt_OFFSET                        2
#define D0F0x98_x0E_MsiHtRsvIntMt_WIDTH                         3
#define D0F0x98_x0E_MsiHtRsvIntMt_MASK                          0x1c
#define D0F0x98_x0E_MsiHtRsvIntRqEoi_OFFSET                     5
#define D0F0x98_x0E_MsiHtRsvIntRqEoi_WIDTH                      1
#define D0F0x98_x0E_MsiHtRsvIntRqEoi_MASK                       0x20
#define D0F0x98_x0E_MsiHtRsvIntDM_OFFSET                        6
#define D0F0x98_x0E_MsiHtRsvIntDM_WIDTH                         1
#define D0F0x98_x0E_MsiHtRsvIntDM_MASK                          0x40
#define D0F0x98_x0E_Reserved_7_7_OFFSET                         7
#define D0F0x98_x0E_Reserved_7_7_WIDTH                          1
#define D0F0x98_x0E_Reserved_7_7_MASK                           0x80
#define D0F0x98_x0E_MsiHtRsvIntDestination_OFFSET               8
#define D0F0x98_x0E_MsiHtRsvIntDestination_WIDTH                8
#define D0F0x98_x0E_MsiHtRsvIntDestination_MASK                 0xff00
#define D0F0x98_x0E_MsiHtRsvIntVector_OFFSET                    16
#define D0F0x98_x0E_MsiHtRsvIntVector_WIDTH                     8
#define D0F0x98_x0E_MsiHtRsvIntVector_MASK                      0xff0000
#define D0F0x98_x0E_Reserved_31_24_OFFSET                       24
#define D0F0x98_x0E_Reserved_31_24_WIDTH                        8
#define D0F0x98_x0E_Reserved_31_24_MASK                         0xff000000

/// D0F0x98_x0E
typedef union {
  struct {                                                              ///<
    UINT32                                       MsiHtRsvIntRemapEn:1 ; ///<
    UINT32                                             Reserved_1_1:1 ; ///<
    UINT32                                            MsiHtRsvIntMt:3 ; ///<
    UINT32                                         MsiHtRsvIntRqEoi:1 ; ///<
    UINT32                                            MsiHtRsvIntDM:1 ; ///<
    UINT32                                             Reserved_7_7:1 ; ///<
    UINT32                                   MsiHtRsvIntDestination:8 ; ///<
    UINT32                                        MsiHtRsvIntVector:8 ; ///<
    UINT32                                           Reserved_31_24:8 ; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} D0F0x98_x0E_STRUCT;

// **** D0F0x98_x1E Register Definition ****
// Address
#define D0F0x98_x1E_ADDRESS                                     0x1e

// Type
#define D0F0x98_x1E_TYPE                                        TYPE_D0F0x98
// Field Data
#define D0F0x98_x1E_Reserved_0_0_OFFSET                         0
#define D0F0x98_x1E_Reserved_0_0_WIDTH                          1
#define D0F0x98_x1E_Reserved_0_0_MASK                           0x1
#define D0F0x98_x1E_HiPriEn_OFFSET                              1
#define D0F0x98_x1E_HiPriEn_WIDTH                               1
#define D0F0x98_x1E_HiPriEn_MASK                                0x2
#define D0F0x98_x1E_Reserved_31_2_OFFSET                        2
#define D0F0x98_x1E_Reserved_31_2_WIDTH                         30
#define D0F0x98_x1E_Reserved_31_2_MASK                          0xfffffffc

/// D0F0x98_x1E
typedef union {
  struct {                                                              ///<
    UINT32                                             Reserved_0_0:1 ; ///<
    UINT32                                                  HiPriEn:1 ; ///<
    UINT32                                            Reserved_31_2:30; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} D0F0x98_x1E_STRUCT;

// **** D0F0x98_x28 Register Definition ****
// Address
#define D0F0x98_x28_ADDRESS                                     0x28

// Type
#define D0F0x98_x28_TYPE                                        TYPE_D0F0x98
// Field Data
#define D0F0x98_x28_SmuPmInterfaceEn_OFFSET                     0
#define D0F0x98_x28_SmuPmInterfaceEn_WIDTH                      1
#define D0F0x98_x28_SmuPmInterfaceEn_MASK                       0x1
#define D0F0x98_x28_ForceCoherentIntr_OFFSET                    1
#define D0F0x98_x28_ForceCoherentIntr_WIDTH                     1
#define D0F0x98_x28_ForceCoherentIntr_MASK                      0x2
#define D0F0x98_x28_Reserved_31_2_OFFSET                        2
#define D0F0x98_x28_Reserved_31_2_WIDTH                         30
#define D0F0x98_x28_Reserved_31_2_MASK                          0xfffffffc

/// D0F0x98_x28
typedef union {
  struct {                                                              ///<
    UINT32                                         SmuPmInterfaceEn:1 ; ///<
    UINT32                                        ForceCoherentIntr:1 ; ///<
    UINT32                                            Reserved_31_2:30; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} D0F0x98_x28_STRUCT;

// **** D0F0x98_x2C Register Definition ****
// Address
#define D0F0x98_x2C_ADDRESS                                     0x2c

// Type
#define D0F0x98_x2C_TYPE                                        TYPE_D0F0x98
// Field Data
#define D0F0x98_x2C_Reserved_0_0_OFFSET                         0
#define D0F0x98_x2C_Reserved_0_0_WIDTH                          1
#define D0F0x98_x2C_Reserved_0_0_MASK                           0x1
#define D0F0x98_x2C_DynWakeEn_OFFSET                            1
#define D0F0x98_x2C_DynWakeEn_WIDTH                             1
#define D0F0x98_x2C_DynWakeEn_MASK                              0x2
#define D0F0x98_x2C_Reserved_15_2_OFFSET                        2
#define D0F0x98_x2C_Reserved_15_2_WIDTH                         14
#define D0F0x98_x2C_Reserved_15_2_MASK                          0xfffc
#define D0F0x98_x2C_WakeHysteresis_OFFSET                       16
#define D0F0x98_x2C_WakeHysteresis_WIDTH                        16
#define D0F0x98_x2C_WakeHysteresis_MASK                         0xffff0000

/// D0F0x98_x2C
typedef union {
  struct {                                                              ///<
    UINT32                                             Reserved_0_0:1 ; ///<
    UINT32                                                DynWakeEn:1 ; ///<
    UINT32                                            Reserved_15_2:14; ///<
    UINT32                                           WakeHysteresis:16; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} D0F0x98_x2C_STRUCT;

// **** D0F0x98_x3A Register Definition ****
// Address
#define D0F0x98_x3A_ADDRESS                                     0x3a

// Type
#define D0F0x98_x3A_TYPE                                        TYPE_D0F0x98
// Field Data
#define D0F0x98_x3A_Reserved_2_0_OFFSET                         0
#define D0F0x98_x3A_Reserved_2_0_WIDTH                          3
#define D0F0x98_x3A_Reserved_2_0_MASK                           0x7
#define D0F0x98_x3A_ClumpingEn_OFFSET                           3
#define D0F0x98_x3A_ClumpingEn_WIDTH                            1
#define D0F0x98_x3A_ClumpingEn_MASK                             0x8
#define D0F0x98_x3A_Reserved_31_4_OFFSET                        4
#define D0F0x98_x3A_Reserved_31_4_WIDTH                         28
#define D0F0x98_x3A_Reserved_31_4_MASK                          0xfffffff0

/// D0F0x98_x3A
typedef union {
  struct {                                                              ///<
    UINT32                                             Reserved_2_0:3 ; ///<
    UINT32                                               ClumpingEn:1 ; ///<
    UINT32                                            Reserved_31_4:28; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} D0F0x98_x3A_STRUCT;

// **** D0F0x98_x49 Register Definition ****
// Address
#define D0F0x98_x49_ADDRESS                                     0x49

// Type
#define D0F0x98_x49_TYPE                                        TYPE_D0F0x98
// Field Data
#define D0F0x98_x49_Reserved_3_0_OFFSET                         0
#define D0F0x98_x49_Reserved_3_0_WIDTH                          4
#define D0F0x98_x49_Reserved_3_0_MASK                           0xf
#define D0F0x98_x49_OffHysteresis_OFFSET                        4
#define D0F0x98_x49_OffHysteresis_WIDTH                         8
#define D0F0x98_x49_OffHysteresis_MASK                          0xff0
#define D0F0x98_x49_Reserved_23_12_OFFSET                       12
#define D0F0x98_x49_Reserved_23_12_WIDTH                        12
#define D0F0x98_x49_Reserved_23_12_MASK                         0xfff000
#define D0F0x98_x49_SoftOverrideClk6_OFFSET                     24
#define D0F0x98_x49_SoftOverrideClk6_WIDTH                      1
#define D0F0x98_x49_SoftOverrideClk6_MASK                       0x1000000
#define D0F0x98_x49_SoftOverrideClk5_OFFSET                     25
#define D0F0x98_x49_SoftOverrideClk5_WIDTH                      1
#define D0F0x98_x49_SoftOverrideClk5_MASK                       0x2000000
#define D0F0x98_x49_SoftOverrideClk4_OFFSET                     26
#define D0F0x98_x49_SoftOverrideClk4_WIDTH                      1
#define D0F0x98_x49_SoftOverrideClk4_MASK                       0x4000000
#define D0F0x98_x49_SoftOverrideClk3_OFFSET                     27
#define D0F0x98_x49_SoftOverrideClk3_WIDTH                      1
#define D0F0x98_x49_SoftOverrideClk3_MASK                       0x8000000
#define D0F0x98_x49_SoftOverrideClk2_OFFSET                     28
#define D0F0x98_x49_SoftOverrideClk2_WIDTH                      1
#define D0F0x98_x49_SoftOverrideClk2_MASK                       0x10000000
#define D0F0x98_x49_SoftOverrideClk1_OFFSET                     29
#define D0F0x98_x49_SoftOverrideClk1_WIDTH                      1
#define D0F0x98_x49_SoftOverrideClk1_MASK                       0x20000000
#define D0F0x98_x49_SoftOverrideClk0_OFFSET                     30
#define D0F0x98_x49_SoftOverrideClk0_WIDTH                      1
#define D0F0x98_x49_SoftOverrideClk0_MASK                       0x40000000
#define D0F0x98_x49_Reserved_31_31_OFFSET                       31
#define D0F0x98_x49_Reserved_31_31_WIDTH                        1
#define D0F0x98_x49_Reserved_31_31_MASK                         0x80000000

/// D0F0x98_x49
typedef union {
  struct {                                                              ///<
    UINT32                                             Reserved_3_0:4 ; ///<
    UINT32                                            OffHysteresis:8 ; ///<
    UINT32                                           Reserved_23_12:12; ///<
    UINT32                                         SoftOverrideClk6:1 ; ///<
    UINT32                                         SoftOverrideClk5:1 ; ///<
    UINT32                                         SoftOverrideClk4:1 ; ///<
    UINT32                                         SoftOverrideClk3:1 ; ///<
    UINT32                                         SoftOverrideClk2:1 ; ///<
    UINT32                                         SoftOverrideClk1:1 ; ///<
    UINT32                                         SoftOverrideClk0:1 ; ///<
    UINT32                                           Reserved_31_31:1 ; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} D0F0x98_x49_STRUCT;

// **** D0F0x98_x4A Register Definition ****
// Address
#define D0F0x98_x4A_ADDRESS                                     0x4a

// Type
#define D0F0x98_x4A_TYPE                                        TYPE_D0F0x98
// Field Data
#define D0F0x98_x4A_Reserved_3_0_OFFSET                         0
#define D0F0x98_x4A_Reserved_3_0_WIDTH                          4
#define D0F0x98_x4A_Reserved_3_0_MASK                           0xf
#define D0F0x98_x4A_OffHysteresis_OFFSET                        4
#define D0F0x98_x4A_OffHysteresis_WIDTH                         8
#define D0F0x98_x4A_OffHysteresis_MASK                          0xff0
#define D0F0x98_x4A_Reserved_23_12_OFFSET                       12
#define D0F0x98_x4A_Reserved_23_12_WIDTH                        12
#define D0F0x98_x4A_Reserved_23_12_MASK                         0xfff000
#define D0F0x98_x4A_SoftOverrideClk6_OFFSET                     24
#define D0F0x98_x4A_SoftOverrideClk6_WIDTH                      1
#define D0F0x98_x4A_SoftOverrideClk6_MASK                       0x1000000
#define D0F0x98_x4A_SoftOverrideClk5_OFFSET                     25
#define D0F0x98_x4A_SoftOverrideClk5_WIDTH                      1
#define D0F0x98_x4A_SoftOverrideClk5_MASK                       0x2000000
#define D0F0x98_x4A_SoftOverrideClk4_OFFSET                     26
#define D0F0x98_x4A_SoftOverrideClk4_WIDTH                      1
#define D0F0x98_x4A_SoftOverrideClk4_MASK                       0x4000000
#define D0F0x98_x4A_SoftOverrideClk3_OFFSET                     27
#define D0F0x98_x4A_SoftOverrideClk3_WIDTH                      1
#define D0F0x98_x4A_SoftOverrideClk3_MASK                       0x8000000
#define D0F0x98_x4A_SoftOverrideClk2_OFFSET                     28
#define D0F0x98_x4A_SoftOverrideClk2_WIDTH                      1
#define D0F0x98_x4A_SoftOverrideClk2_MASK                       0x10000000
#define D0F0x98_x4A_SoftOverrideClk1_OFFSET                     29
#define D0F0x98_x4A_SoftOverrideClk1_WIDTH                      1
#define D0F0x98_x4A_SoftOverrideClk1_MASK                       0x20000000
#define D0F0x98_x4A_SoftOverrideClk0_OFFSET                     30
#define D0F0x98_x4A_SoftOverrideClk0_WIDTH                      1
#define D0F0x98_x4A_SoftOverrideClk0_MASK                       0x40000000
#define D0F0x98_x4A_Reserved_31_31_OFFSET                       31
#define D0F0x98_x4A_Reserved_31_31_WIDTH                        1
#define D0F0x98_x4A_Reserved_31_31_MASK                         0x80000000

/// D0F0x98_x4A
typedef union {
  struct {                                                              ///<
    UINT32                                             Reserved_3_0:4 ; ///<
    UINT32                                            OffHysteresis:8 ; ///<
    UINT32                                           Reserved_23_12:12; ///<
    UINT32                                         SoftOverrideClk6:1 ; ///<
    UINT32                                         SoftOverrideClk5:1 ; ///<
    UINT32                                         SoftOverrideClk4:1 ; ///<
    UINT32                                         SoftOverrideClk3:1 ; ///<
    UINT32                                         SoftOverrideClk2:1 ; ///<
    UINT32                                         SoftOverrideClk1:1 ; ///<
    UINT32                                         SoftOverrideClk0:1 ; ///<
    UINT32                                           Reserved_31_31:1 ; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} D0F0x98_x4A_STRUCT;

// **** D0F0x98_x4B Register Definition ****
// Address
#define D0F0x98_x4B_ADDRESS                                     0x4b

// Type
#define D0F0x98_x4B_TYPE                                        TYPE_D0F0x98
// Field Data
#define D0F0x98_x4B_Reserved_3_0_OFFSET                         0
#define D0F0x98_x4B_Reserved_3_0_WIDTH                          4
#define D0F0x98_x4B_Reserved_3_0_MASK                           0xf
#define D0F0x98_x4B_OffHysteresis_OFFSET                        4
#define D0F0x98_x4B_OffHysteresis_WIDTH                         8
#define D0F0x98_x4B_OffHysteresis_MASK                          0xff0
#define D0F0x98_x4B_Reserved_29_12_OFFSET                       12
#define D0F0x98_x4B_Reserved_29_12_WIDTH                        18
#define D0F0x98_x4B_Reserved_29_12_MASK                         0x3ffff000
#define D0F0x98_x4B_SoftOverrideClk_OFFSET                      30
#define D0F0x98_x4B_SoftOverrideClk_WIDTH                       1
#define D0F0x98_x4B_SoftOverrideClk_MASK                        0x40000000
#define D0F0x98_x4B_Reserved_31_31_OFFSET                       31
#define D0F0x98_x4B_Reserved_31_31_WIDTH                        1
#define D0F0x98_x4B_Reserved_31_31_MASK                         0x80000000

/// D0F0x98_x4B
typedef union {
  struct {                                                              ///<
    UINT32                                             Reserved_3_0:4 ; ///<
    UINT32                                            OffHysteresis:8 ; ///<
    UINT32                                           Reserved_29_12:18; ///<
    UINT32                                          SoftOverrideClk:1 ; ///<
    UINT32                                           Reserved_31_31:1 ; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} D0F0x98_x4B_STRUCT;

// **** D0F0xE4_WRAP_0080 Register Definition ****
// Address
#define D0F0xE4_WRAP_0080_ADDRESS                               0x80

// Type
#define D0F0xE4_WRAP_0080_TYPE                                  TYPE_D0F0xE4
// Field Data
#define D0F0xE4_WRAP_0080_StrapBifLinkConfig_OFFSET             0
#define D0F0xE4_WRAP_0080_StrapBifLinkConfig_WIDTH              4
#define D0F0xE4_WRAP_0080_StrapBifLinkConfig_MASK               0xf
#define D0F0xE4_WRAP_0080_Reserved_31_4_OFFSET                  4
#define D0F0xE4_WRAP_0080_Reserved_31_4_WIDTH                   28
#define D0F0xE4_WRAP_0080_Reserved_31_4_MASK                    0xfffffff0

/// D0F0xE4_WRAP_0080
typedef union {
  struct {                                                              ///<
    UINT32                                       StrapBifLinkConfig:4 ; ///<
    UINT32                                            Reserved_31_4:28; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} D0F0xE4_WRAP_0080_STRUCT;

// **** D0F0xE4_WRAP_0800 Register Definition ****
// Address
#define D0F0xE4_WRAP_0800_ADDRESS                               0x800

// Type
#define D0F0xE4_WRAP_0800_TYPE                                  TYPE_D0F0xE4
// Field Data
#define D0F0xE4_WRAP_0800_HoldTraining_OFFSET                   0
#define D0F0xE4_WRAP_0800_HoldTraining_WIDTH                    1
#define D0F0xE4_WRAP_0800_HoldTraining_MASK                     0x1
#define D0F0xE4_WRAP_0800_Reserved_31_1_OFFSET                  1
#define D0F0xE4_WRAP_0800_Reserved_31_1_WIDTH                   31
#define D0F0xE4_WRAP_0800_Reserved_31_1_MASK                    0xfffffffe

/// D0F0xE4_WRAP_0800
typedef union {
  struct {                                                              ///<
    UINT32                                             HoldTraining:1 ; ///<
    UINT32                                            Reserved_31_1:31; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} D0F0xE4_WRAP_0800_STRUCT;

// **** D0F0xE4_WRAP_0803 Register Definition ****
// Address
#define D0F0xE4_WRAP_0803_ADDRESS                               0x803

// Type
#define D0F0xE4_WRAP_0803_TYPE                                  TYPE_D0F0xE4
// Field Data
#define D0F0xE4_WRAP_0803_Reserved_4_0_OFFSET                   0
#define D0F0xE4_WRAP_0803_Reserved_4_0_WIDTH                    5
#define D0F0xE4_WRAP_0803_Reserved_4_0_MASK                     0x1f
#define D0F0xE4_WRAP_0803_StrapBifDeemphasisSel_OFFSET          5
#define D0F0xE4_WRAP_0803_StrapBifDeemphasisSel_WIDTH           1
#define D0F0xE4_WRAP_0803_StrapBifDeemphasisSel_MASK            0x20
#define D0F0xE4_WRAP_0803_Reserved_31_6_OFFSET                  6
#define D0F0xE4_WRAP_0803_Reserved_31_6_WIDTH                   26
#define D0F0xE4_WRAP_0803_Reserved_31_6_MASK                    0xffffffc0

/// D0F0xE4_WRAP_0803
typedef union {
  struct {                                                              ///<
    UINT32                                             Reserved_4_0:5 ; ///<
    UINT32                                    StrapBifDeemphasisSel:1 ; ///<
    UINT32                                            Reserved_31_6:26; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} D0F0xE4_WRAP_0803_STRUCT;

// **** D0F0xE4_WRAP_0903 Register Definition ****
// Address
#define D0F0xE4_WRAP_0903_ADDRESS                               0x903

// Type
#define D0F0xE4_WRAP_0903_TYPE                                  TYPE_D0F0xE4
// Field Data
#define D0F0xE4_WRAP_0903_Reserved_4_0_OFFSET                   0
#define D0F0xE4_WRAP_0903_Reserved_4_0_WIDTH                    5
#define D0F0xE4_WRAP_0903_Reserved_4_0_MASK                     0x1f
#define D0F0xE4_WRAP_0903_StrapBifDeemphasisSel_OFFSET          5
#define D0F0xE4_WRAP_0903_StrapBifDeemphasisSel_WIDTH           1
#define D0F0xE4_WRAP_0903_StrapBifDeemphasisSel_MASK            0x20
#define D0F0xE4_WRAP_0903_Reserved_31_6_OFFSET                  6
#define D0F0xE4_WRAP_0903_Reserved_31_6_WIDTH                   26
#define D0F0xE4_WRAP_0903_Reserved_31_6_MASK                    0xffffffc0

/// D0F0xE4_WRAP_0903
typedef union {
  struct {                                                              ///<
    UINT32                                             Reserved_4_0:5 ; ///<
    UINT32                                    StrapBifDeemphasisSel:1 ; ///<
    UINT32                                            Reserved_31_6:26; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} D0F0xE4_WRAP_0903_STRUCT;

// **** D0F0xE4_WRAP_8002 Register Definition ****
// Address
#define D0F0xE4_WRAP_8002_ADDRESS                               0x8002

// Type
#define D0F0xE4_WRAP_8002_TYPE                                  TYPE_D0F0xE4
// Field Data
#define D0F0xE4_WRAP_8002_PcieWrapScratch_OFFSET                0
#define D0F0xE4_WRAP_8002_PcieWrapScratch_WIDTH                 32
#define D0F0xE4_WRAP_8002_PcieWrapScratch_MASK                  0xffffffff

/// D0F0xE4_WRAP_8002
typedef union {
  struct {                                                              ///<
    UINT32                                          PcieWrapScratch:32; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} D0F0xE4_WRAP_8002_STRUCT;

// **** D0F0xE4_WRAP_8011 Register Definition ****
// Address
#define D0F0xE4_WRAP_8011_ADDRESS                               0x8011

// Type
#define D0F0xE4_WRAP_8011_TYPE                                  TYPE_D0F0xE4
// Field Data
#define D0F0xE4_WRAP_8011_TxclkDynGateLatency_OFFSET            0
#define D0F0xE4_WRAP_8011_TxclkDynGateLatency_WIDTH             6
#define D0F0xE4_WRAP_8011_TxclkDynGateLatency_MASK              0x3f
#define D0F0xE4_WRAP_8011_TxclkPermGateEven_OFFSET              6
#define D0F0xE4_WRAP_8011_TxclkPermGateEven_WIDTH               1
#define D0F0xE4_WRAP_8011_TxclkPermGateEven_MASK                0x40
#define D0F0xE4_WRAP_8011_TxclkDynGateEnable_OFFSET             7
#define D0F0xE4_WRAP_8011_TxclkDynGateEnable_WIDTH              1
#define D0F0xE4_WRAP_8011_TxclkDynGateEnable_MASK               0x80
#define D0F0xE4_WRAP_8011_TxclkPermStop_OFFSET                  8
#define D0F0xE4_WRAP_8011_TxclkPermStop_WIDTH                   1
#define D0F0xE4_WRAP_8011_TxclkPermStop_MASK                    0x100
#define D0F0xE4_WRAP_8011_TxclkRegsGateEnable_OFFSET            9
#define D0F0xE4_WRAP_8011_TxclkRegsGateEnable_WIDTH             1
#define D0F0xE4_WRAP_8011_TxclkRegsGateEnable_MASK              0x200
#define D0F0xE4_WRAP_8011_TxclkRegsGateLatency_OFFSET           10
#define D0F0xE4_WRAP_8011_TxclkRegsGateLatency_WIDTH            6
#define D0F0xE4_WRAP_8011_TxclkRegsGateLatency_MASK             0xfc00
#define D0F0xE4_WRAP_8011_RcvrDetClkEnable_OFFSET               16
#define D0F0xE4_WRAP_8011_RcvrDetClkEnable_WIDTH                1
#define D0F0xE4_WRAP_8011_RcvrDetClkEnable_MASK                 0x10000
#define D0F0xE4_WRAP_8011_TxclkPermGateLatency_OFFSET           17
#define D0F0xE4_WRAP_8011_TxclkPermGateLatency_WIDTH            6
#define D0F0xE4_WRAP_8011_TxclkPermGateLatency_MASK             0x7e0000
#define D0F0xE4_WRAP_8011_Reserved_23_23_OFFSET                 23
#define D0F0xE4_WRAP_8011_Reserved_23_23_WIDTH                  1
#define D0F0xE4_WRAP_8011_Reserved_23_23_MASK                   0x800000
#define D0F0xE4_WRAP_8011_TxclkLcntGateEnable_OFFSET            24
#define D0F0xE4_WRAP_8011_TxclkLcntGateEnable_WIDTH             1
#define D0F0xE4_WRAP_8011_TxclkLcntGateEnable_MASK              0x1000000
#define D0F0xE4_WRAP_8011_Reserved_30_25_OFFSET                 25
#define D0F0xE4_WRAP_8011_Reserved_30_25_WIDTH                  6
#define D0F0xE4_WRAP_8011_Reserved_30_25_MASK                   0x7e000000
#define D0F0xE4_WRAP_8011_StrapBifValid_OFFSET                  31
#define D0F0xE4_WRAP_8011_StrapBifValid_WIDTH                   1
#define D0F0xE4_WRAP_8011_StrapBifValid_MASK                    0x80000000

/// D0F0xE4_WRAP_8011
typedef union {
  struct {                                                              ///<
    UINT32                                      TxclkDynGateLatency:6 ; ///<
    UINT32                                        TxclkPermGateEven:1 ; ///<
    UINT32                                       TxclkDynGateEnable:1 ; ///<
    UINT32                                            TxclkPermStop:1 ; ///<
    UINT32                                      TxclkRegsGateEnable:1 ; ///<
    UINT32                                     TxclkRegsGateLatency:6 ; ///<
    UINT32                                         RcvrDetClkEnable:1 ; ///<
    UINT32                                     TxclkPermGateLatency:6 ; ///<
    UINT32                                           Reserved_23_23:1 ; ///<
    UINT32                                      TxclkLcntGateEnable:1 ; ///<
    UINT32                                           Reserved_30_25:6 ; ///<
    UINT32                                            StrapBifValid:1 ; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} D0F0xE4_WRAP_8011_STRUCT;

// **** D0F0xE4_WRAP_8012 Register Definition ****
// Address
#define D0F0xE4_WRAP_8012_ADDRESS                               0x8012

// Type
#define D0F0xE4_WRAP_8012_TYPE                                  TYPE_D0F0xE4
// Field Data
#define D0F0xE4_WRAP_8012_Pif1xIdleGateLatency_OFFSET           0
#define D0F0xE4_WRAP_8012_Pif1xIdleGateLatency_WIDTH            6
#define D0F0xE4_WRAP_8012_Pif1xIdleGateLatency_MASK             0x3f
#define D0F0xE4_WRAP_8012_Reserved_6_6_OFFSET                   6
#define D0F0xE4_WRAP_8012_Reserved_6_6_WIDTH                    1
#define D0F0xE4_WRAP_8012_Reserved_6_6_MASK                     0x40
#define D0F0xE4_WRAP_8012_Pif1xIdleGateEnable_OFFSET            7
#define D0F0xE4_WRAP_8012_Pif1xIdleGateEnable_WIDTH             1
#define D0F0xE4_WRAP_8012_Pif1xIdleGateEnable_MASK              0x80
#define D0F0xE4_WRAP_8012_Pif1xIdleResumeLatency_OFFSET         8
#define D0F0xE4_WRAP_8012_Pif1xIdleResumeLatency_WIDTH          6
#define D0F0xE4_WRAP_8012_Pif1xIdleResumeLatency_MASK           0x3f00
#define D0F0xE4_WRAP_8012_Reserved_15_14_OFFSET                 14
#define D0F0xE4_WRAP_8012_Reserved_15_14_WIDTH                  2
#define D0F0xE4_WRAP_8012_Reserved_15_14_MASK                   0xc000
#define D0F0xE4_WRAP_8012_Pif2p5xIdleGateLatency_OFFSET         16
#define D0F0xE4_WRAP_8012_Pif2p5xIdleGateLatency_WIDTH          6
#define D0F0xE4_WRAP_8012_Pif2p5xIdleGateLatency_MASK           0x3f0000
#define D0F0xE4_WRAP_8012_Reserved_22_22_OFFSET                 22
#define D0F0xE4_WRAP_8012_Reserved_22_22_WIDTH                  1
#define D0F0xE4_WRAP_8012_Reserved_22_22_MASK                   0x400000
#define D0F0xE4_WRAP_8012_Pif2p5xIdleGateEnable_OFFSET          23
#define D0F0xE4_WRAP_8012_Pif2p5xIdleGateEnable_WIDTH           1
#define D0F0xE4_WRAP_8012_Pif2p5xIdleGateEnable_MASK            0x800000
#define D0F0xE4_WRAP_8012_Pif2p5xIdleResumeLatency_OFFSET       24
#define D0F0xE4_WRAP_8012_Pif2p5xIdleResumeLatency_WIDTH        6
#define D0F0xE4_WRAP_8012_Pif2p5xIdleResumeLatency_MASK         0x3f000000
#define D0F0xE4_WRAP_8012_Reserved_31_30_OFFSET                 30
#define D0F0xE4_WRAP_8012_Reserved_31_30_WIDTH                  2
#define D0F0xE4_WRAP_8012_Reserved_31_30_MASK                   0xc0000000

/// D0F0xE4_WRAP_8012
typedef union {
  struct {                                                              ///<
    UINT32                                     Pif1xIdleGateLatency:6 ; ///<
    UINT32                                             Reserved_6_6:1 ; ///<
    UINT32                                      Pif1xIdleGateEnable:1 ; ///<
    UINT32                                   Pif1xIdleResumeLatency:6 ; ///<
    UINT32                                           Reserved_15_14:2 ; ///<
    UINT32                                   Pif2p5xIdleGateLatency:6 ; ///<
    UINT32                                           Reserved_22_22:1 ; ///<
    UINT32                                    Pif2p5xIdleGateEnable:1 ; ///<
    UINT32                                 Pif2p5xIdleResumeLatency:6 ; ///<
    UINT32                                           Reserved_31_30:2 ; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} D0F0xE4_WRAP_8012_STRUCT;


// **** D0F0xE4_WRAP_8021 Register Definition ****
// Address
#define D0F0xE4_WRAP_8021_ADDRESS                               0x8021

// Type
#define D0F0xE4_WRAP_8021_TYPE                                  TYPE_D0F0xE4
// Field Data
#define D0F0xE4_WRAP_8021_Lanes10_OFFSET                        0
#define D0F0xE4_WRAP_8021_Lanes10_WIDTH                         4
#define D0F0xE4_WRAP_8021_Lanes10_MASK                          0xf
#define D0F0xE4_WRAP_8021_Lanes32_OFFSET                        4
#define D0F0xE4_WRAP_8021_Lanes32_WIDTH                         4
#define D0F0xE4_WRAP_8021_Lanes32_MASK                          0xf0
#define D0F0xE4_WRAP_8021_Lanes54_OFFSET                        8
#define D0F0xE4_WRAP_8021_Lanes54_WIDTH                         4
#define D0F0xE4_WRAP_8021_Lanes54_MASK                          0xf00
#define D0F0xE4_WRAP_8021_Lanes76_OFFSET                        12
#define D0F0xE4_WRAP_8021_Lanes76_WIDTH                         4
#define D0F0xE4_WRAP_8021_Lanes76_MASK                          0xf000
#define D0F0xE4_WRAP_8021_Lanes98_OFFSET                        16
#define D0F0xE4_WRAP_8021_Lanes98_WIDTH                         4
#define D0F0xE4_WRAP_8021_Lanes98_MASK                          0xf0000
#define D0F0xE4_WRAP_8021_Lanes1110_OFFSET                      20
#define D0F0xE4_WRAP_8021_Lanes1110_WIDTH                       4
#define D0F0xE4_WRAP_8021_Lanes1110_MASK                        0xf00000
#define D0F0xE4_WRAP_8021_Lanes1312_OFFSET                      24
#define D0F0xE4_WRAP_8021_Lanes1312_WIDTH                       4
#define D0F0xE4_WRAP_8021_Lanes1312_MASK                        0xf000000
#define D0F0xE4_WRAP_8021_Lanes1514_OFFSET                      28
#define D0F0xE4_WRAP_8021_Lanes1514_WIDTH                       4
#define D0F0xE4_WRAP_8021_Lanes1514_MASK                        0xf0000000

/// D0F0xE4_WRAP_8021
typedef union {
  struct {                                                              ///<
    UINT32                                                  Lanes10:4 ; ///<
    UINT32                                                  Lanes32:4 ; ///<
    UINT32                                                  Lanes54:4 ; ///<
    UINT32                                                  Lanes76:4 ; ///<
    UINT32                                                  Lanes98:4 ; ///<
    UINT32                                                Lanes1110:4 ; ///<
    UINT32                                                Lanes1312:4 ; ///<
    UINT32                                                Lanes1514:4 ; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} D0F0xE4_WRAP_8021_STRUCT;

// **** D0F0xE4_WRAP_8022 Register Definition ****
// Address
#define D0F0xE4_WRAP_8022_ADDRESS                               0x8022

// Type
#define D0F0xE4_WRAP_8022_TYPE                                  TYPE_D0F0xE4
// Field Data
#define D0F0xE4_WRAP_8022_Lanes10_OFFSET                        0
#define D0F0xE4_WRAP_8022_Lanes10_WIDTH                         4
#define D0F0xE4_WRAP_8022_Lanes10_MASK                          0xf
#define D0F0xE4_WRAP_8022_Lanes32_OFFSET                        4
#define D0F0xE4_WRAP_8022_Lanes32_WIDTH                         4
#define D0F0xE4_WRAP_8022_Lanes32_MASK                          0xf0
#define D0F0xE4_WRAP_8022_Lanes54_OFFSET                        8
#define D0F0xE4_WRAP_8022_Lanes54_WIDTH                         4
#define D0F0xE4_WRAP_8022_Lanes54_MASK                          0xf00
#define D0F0xE4_WRAP_8022_Lanes76_OFFSET                        12
#define D0F0xE4_WRAP_8022_Lanes76_WIDTH                         4
#define D0F0xE4_WRAP_8022_Lanes76_MASK                          0xf000
#define D0F0xE4_WRAP_8022_Lanes98_OFFSET                        16
#define D0F0xE4_WRAP_8022_Lanes98_WIDTH                         4
#define D0F0xE4_WRAP_8022_Lanes98_MASK                          0xf0000
#define D0F0xE4_WRAP_8022_Lanes1110_OFFSET                      20
#define D0F0xE4_WRAP_8022_Lanes1110_WIDTH                       4
#define D0F0xE4_WRAP_8022_Lanes1110_MASK                        0xf00000
#define D0F0xE4_WRAP_8022_Lanes1312_OFFSET                      24
#define D0F0xE4_WRAP_8022_Lanes1312_WIDTH                       4
#define D0F0xE4_WRAP_8022_Lanes1312_MASK                        0xf000000
#define D0F0xE4_WRAP_8022_Lanes1514_OFFSET                      28
#define D0F0xE4_WRAP_8022_Lanes1514_WIDTH                       4
#define D0F0xE4_WRAP_8022_Lanes1514_MASK                        0xf0000000

/// D0F0xE4_WRAP_8022
typedef union {
  struct {                                                              ///<
    UINT32                                                  Lanes10:4 ; ///<
    UINT32                                                  Lanes32:4 ; ///<
    UINT32                                                  Lanes54:4 ; ///<
    UINT32                                                  Lanes76:4 ; ///<
    UINT32                                                  Lanes98:4 ; ///<
    UINT32                                                Lanes1110:4 ; ///<
    UINT32                                                Lanes1312:4 ; ///<
    UINT32                                                Lanes1514:4 ; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} D0F0xE4_WRAP_8022_STRUCT;

// **** D0F0xE4_WRAP_8023 Register Definition ****
// Address
#define D0F0xE4_WRAP_8023_ADDRESS                               0x8023

// Type
#define D0F0xE4_WRAP_8023_TYPE                                  TYPE_D0F0xE4
// Field Data
#define D0F0xE4_WRAP_8023_LaneEnable_OFFSET                     0
#define D0F0xE4_WRAP_8023_LaneEnable_WIDTH                      16
#define D0F0xE4_WRAP_8023_LaneEnable_MASK                       0xffff
#define D0F0xE4_WRAP_8023_Reserved_31_16_OFFSET                 16
#define D0F0xE4_WRAP_8023_Reserved_31_16_WIDTH                  16
#define D0F0xE4_WRAP_8023_Reserved_31_16_MASK                   0xffff0000

/// D0F0xE4_WRAP_8023
typedef union {
  struct {                                                              ///<
    UINT32                                               LaneEnable:16; ///<
    UINT32                                           Reserved_31_16:16; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} D0F0xE4_WRAP_8023_STRUCT;

// **** D0F0xE4_WRAP_8025 Register Definition ****
// Address
#define D0F0xE4_WRAP_8025_ADDRESS                               0x8025

// Type
#define D0F0xE4_WRAP_8025_TYPE                                  TYPE_D0F0xE4
// Field Data
#define D0F0xE4_WRAP_8025_LMTxPhyCmd0_OFFSET                    0
#define D0F0xE4_WRAP_8025_LMTxPhyCmd0_WIDTH                     3
#define D0F0xE4_WRAP_8025_LMTxPhyCmd0_MASK                      0x7
#define D0F0xE4_WRAP_8025_LMRxPhyCmd0_OFFSET                    3
#define D0F0xE4_WRAP_8025_LMRxPhyCmd0_WIDTH                     2
#define D0F0xE4_WRAP_8025_LMRxPhyCmd0_MASK                      0x18
#define D0F0xE4_WRAP_8025_LMLinkSpeed0_OFFSET                   5
#define D0F0xE4_WRAP_8025_LMLinkSpeed0_WIDTH                    1
#define D0F0xE4_WRAP_8025_LMLinkSpeed0_MASK                     0x20
#define D0F0xE4_WRAP_8025_Reserved_7_6_OFFSET                   6
#define D0F0xE4_WRAP_8025_Reserved_7_6_WIDTH                    2
#define D0F0xE4_WRAP_8025_Reserved_7_6_MASK                     0xc0
#define D0F0xE4_WRAP_8025_LMTxPhyCmd1_OFFSET                    8
#define D0F0xE4_WRAP_8025_LMTxPhyCmd1_WIDTH                     3
#define D0F0xE4_WRAP_8025_LMTxPhyCmd1_MASK                      0x700
#define D0F0xE4_WRAP_8025_LMRxPhyCmd1_OFFSET                    11
#define D0F0xE4_WRAP_8025_LMRxPhyCmd1_WIDTH                     2
#define D0F0xE4_WRAP_8025_LMRxPhyCmd1_MASK                      0x1800
#define D0F0xE4_WRAP_8025_LMLinkSpeed1_OFFSET                   13
#define D0F0xE4_WRAP_8025_LMLinkSpeed1_WIDTH                    1
#define D0F0xE4_WRAP_8025_LMLinkSpeed1_MASK                     0x2000
#define D0F0xE4_WRAP_8025_Reserved_15_14_OFFSET                 14
#define D0F0xE4_WRAP_8025_Reserved_15_14_WIDTH                  2
#define D0F0xE4_WRAP_8025_Reserved_15_14_MASK                   0xc000
#define D0F0xE4_WRAP_8025_LMTxPhyCmd2_OFFSET                    16
#define D0F0xE4_WRAP_8025_LMTxPhyCmd2_WIDTH                     3
#define D0F0xE4_WRAP_8025_LMTxPhyCmd2_MASK                      0x70000
#define D0F0xE4_WRAP_8025_LMRxPhyCmd2_OFFSET                    19
#define D0F0xE4_WRAP_8025_LMRxPhyCmd2_WIDTH                     2
#define D0F0xE4_WRAP_8025_LMRxPhyCmd2_MASK                      0x180000
#define D0F0xE4_WRAP_8025_LMLinkSpeed2_OFFSET                   21
#define D0F0xE4_WRAP_8025_LMLinkSpeed2_WIDTH                    1
#define D0F0xE4_WRAP_8025_LMLinkSpeed2_MASK                     0x200000
#define D0F0xE4_WRAP_8025_Reserved_23_22_OFFSET                 22
#define D0F0xE4_WRAP_8025_Reserved_23_22_WIDTH                  2
#define D0F0xE4_WRAP_8025_Reserved_23_22_MASK                   0xc00000
#define D0F0xE4_WRAP_8025_LMTxPhyCmd3_OFFSET                    24
#define D0F0xE4_WRAP_8025_LMTxPhyCmd3_WIDTH                     3
#define D0F0xE4_WRAP_8025_LMTxPhyCmd3_MASK                      0x7000000
#define D0F0xE4_WRAP_8025_LMRxPhyCmd3_OFFSET                    27
#define D0F0xE4_WRAP_8025_LMRxPhyCmd3_WIDTH                     2
#define D0F0xE4_WRAP_8025_LMRxPhyCmd3_MASK                      0x18000000
#define D0F0xE4_WRAP_8025_LMLinkSpeed3_OFFSET                   29
#define D0F0xE4_WRAP_8025_LMLinkSpeed3_WIDTH                    1
#define D0F0xE4_WRAP_8025_LMLinkSpeed3_MASK                     0x20000000
#define D0F0xE4_WRAP_8025_Reserved_31_30_OFFSET                 30
#define D0F0xE4_WRAP_8025_Reserved_31_30_WIDTH                  2
#define D0F0xE4_WRAP_8025_Reserved_31_30_MASK                   0xc0000000

/// D0F0xE4_WRAP_8025
typedef union {
  struct {                                                              ///<
    UINT32                                              LMTxPhyCmd0:3 ; ///<
    UINT32                                              LMRxPhyCmd0:2 ; ///<
    UINT32                                             LMLinkSpeed0:1 ; ///<
    UINT32                                             Reserved_7_6:2 ; ///<
    UINT32                                              LMTxPhyCmd1:3 ; ///<
    UINT32                                              LMRxPhyCmd1:2 ; ///<
    UINT32                                             LMLinkSpeed1:1 ; ///<
    UINT32                                           Reserved_15_14:2 ; ///<
    UINT32                                              LMTxPhyCmd2:3 ; ///<
    UINT32                                              LMRxPhyCmd2:2 ; ///<
    UINT32                                             LMLinkSpeed2:1 ; ///<
    UINT32                                           Reserved_23_22:2 ; ///<
    UINT32                                              LMTxPhyCmd3:3 ; ///<
    UINT32                                              LMRxPhyCmd3:2 ; ///<
    UINT32                                             LMLinkSpeed3:1 ; ///<
    UINT32                                           Reserved_31_30:2 ; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} D0F0xE4_WRAP_8025_STRUCT;

// **** D0F0xE4_WRAP_8031 Register Definition ****
// Address
#define D0F0xE4_WRAP_8031_ADDRESS                               0x8031

// Type
#define D0F0xE4_WRAP_8031_TYPE                                  TYPE_D0F0xE4
// Field Data
#define D0F0xE4_WRAP_8031_LnCntBandwidth_OFFSET                 0
#define D0F0xE4_WRAP_8031_LnCntBandwidth_WIDTH                  10
#define D0F0xE4_WRAP_8031_LnCntBandwidth_MASK                   0x3ff
#define D0F0xE4_WRAP_8031_Reserved_15_10_OFFSET                 10
#define D0F0xE4_WRAP_8031_Reserved_15_10_WIDTH                  6
#define D0F0xE4_WRAP_8031_Reserved_15_10_MASK                   0xfc00
#define D0F0xE4_WRAP_8031_LnCntValid_OFFSET                     16
#define D0F0xE4_WRAP_8031_LnCntValid_WIDTH                      1
#define D0F0xE4_WRAP_8031_LnCntValid_MASK                       0x10000
#define D0F0xE4_WRAP_8031_Reserved_31_17_OFFSET                 17
#define D0F0xE4_WRAP_8031_Reserved_31_17_WIDTH                  15
#define D0F0xE4_WRAP_8031_Reserved_31_17_MASK                   0xfffe0000

/// D0F0xE4_WRAP_8031
typedef union {
  struct {                                                              ///<
    UINT32                                           LnCntBandwidth:10; ///<
    UINT32                                           Reserved_15_10:6 ; ///<
    UINT32                                               LnCntValid:1 ; ///<
    UINT32                                           Reserved_31_17:15; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} D0F0xE4_WRAP_8031_STRUCT;

// **** D0F0xE4_WRAP_8040 Register Definition ****
// Address
#define D0F0xE4_WRAP_8040_ADDRESS                               0x8040

// Type
#define D0F0xE4_WRAP_8040_TYPE                                  TYPE_D0F0xE4
// Field Data
#define D0F0xE4_WRAP_8040_OwnPhyA_OFFSET                        0
#define D0F0xE4_WRAP_8040_OwnPhyA_WIDTH                         1
#define D0F0xE4_WRAP_8040_OwnPhyA_MASK                          0x1
#define D0F0xE4_WRAP_8040_OwnPhyB_OFFSET                        1
#define D0F0xE4_WRAP_8040_OwnPhyB_WIDTH                         1
#define D0F0xE4_WRAP_8040_OwnPhyB_MASK                          0x2
#define D0F0xE4_WRAP_8040_OwnPhyC_OFFSET                        2
#define D0F0xE4_WRAP_8040_OwnPhyC_WIDTH                         1
#define D0F0xE4_WRAP_8040_OwnPhyC_MASK                          0x4
#define D0F0xE4_WRAP_8040_OwnPhyD_OFFSET                        3
#define D0F0xE4_WRAP_8040_OwnPhyD_WIDTH                         1
#define D0F0xE4_WRAP_8040_OwnPhyD_MASK                          0x8
#define D0F0xE4_WRAP_8040_Reserved_7_4_OFFSET                   4
#define D0F0xE4_WRAP_8040_Reserved_7_4_WIDTH                    4
#define D0F0xE4_WRAP_8040_Reserved_7_4_MASK                     0xf0
#define D0F0xE4_WRAP_8040_DigaPwrdnValue_OFFSET                 8
#define D0F0xE4_WRAP_8040_DigaPwrdnValue_WIDTH                  3
#define D0F0xE4_WRAP_8040_DigaPwrdnValue_MASK                   0x700
#define D0F0xE4_WRAP_8040_Reserved_11_11_OFFSET                 11
#define D0F0xE4_WRAP_8040_Reserved_11_11_WIDTH                  1
#define D0F0xE4_WRAP_8040_Reserved_11_11_MASK                   0x800
#define D0F0xE4_WRAP_8040_DigbPwrdnValue_OFFSET                 12
#define D0F0xE4_WRAP_8040_DigbPwrdnValue_WIDTH                  3
#define D0F0xE4_WRAP_8040_DigbPwrdnValue_MASK                   0x7000
#define D0F0xE4_WRAP_8040_Reserved_15_15_OFFSET                 15
#define D0F0xE4_WRAP_8040_Reserved_15_15_WIDTH                  1
#define D0F0xE4_WRAP_8040_Reserved_15_15_MASK                   0x8000
#define D0F0xE4_WRAP_8040_CntPhyA_OFFSET                        16
#define D0F0xE4_WRAP_8040_CntPhyA_WIDTH                         1
#define D0F0xE4_WRAP_8040_CntPhyA_MASK                          0x10000
#define D0F0xE4_WRAP_8040_CntPhyB_OFFSET                        17
#define D0F0xE4_WRAP_8040_CntPhyB_WIDTH                         1
#define D0F0xE4_WRAP_8040_CntPhyB_MASK                          0x20000
#define D0F0xE4_WRAP_8040_CntPhyC_OFFSET                        18
#define D0F0xE4_WRAP_8040_CntPhyC_WIDTH                         1
#define D0F0xE4_WRAP_8040_CntPhyC_MASK                          0x40000
#define D0F0xE4_WRAP_8040_CntPhyD_OFFSET                        19
#define D0F0xE4_WRAP_8040_CntPhyD_WIDTH                         1
#define D0F0xE4_WRAP_8040_CntPhyD_MASK                          0x80000
#define D0F0xE4_WRAP_8040_CntDigA_OFFSET                        20
#define D0F0xE4_WRAP_8040_CntDigA_WIDTH                         1
#define D0F0xE4_WRAP_8040_CntDigA_MASK                          0x100000
#define D0F0xE4_WRAP_8040_CntDigB_OFFSET                        21
#define D0F0xE4_WRAP_8040_CntDigB_WIDTH                         1
#define D0F0xE4_WRAP_8040_CntDigB_MASK                          0x200000
#define D0F0xE4_WRAP_8040_ChangeLnSpd_OFFSET                    22
#define D0F0xE4_WRAP_8040_ChangeLnSpd_WIDTH                     1
#define D0F0xE4_WRAP_8040_ChangeLnSpd_MASK                      0x400000
#define D0F0xE4_WRAP_8040_Reserved_31_23_OFFSET                 23
#define D0F0xE4_WRAP_8040_Reserved_31_23_WIDTH                  9
#define D0F0xE4_WRAP_8040_Reserved_31_23_MASK                   0xff800000

/// D0F0xE4_WRAP_8040
typedef union {
  struct {                                                              ///<
    UINT32                                                  OwnPhyA:1 ; ///<
    UINT32                                                  OwnPhyB:1 ; ///<
    UINT32                                                  OwnPhyC:1 ; ///<
    UINT32                                                  OwnPhyD:1 ; ///<
    UINT32                                             Reserved_7_4:4 ; ///<
    UINT32                                           DigaPwrdnValue:3 ; ///<
    UINT32                                           Reserved_11_11:1 ; ///<
    UINT32                                           DigbPwrdnValue:3 ; ///<
    UINT32                                           Reserved_15_15:1 ; ///<
    UINT32                                                  CntPhyA:1 ; ///<
    UINT32                                                  CntPhyB:1 ; ///<
    UINT32                                                  CntPhyC:1 ; ///<
    UINT32                                                  CntPhyD:1 ; ///<
    UINT32                                                  CntDigA:1 ; ///<
    UINT32                                                  CntDigB:1 ; ///<
    UINT32                                              ChangeLnSpd:1 ; ///<
    UINT32                                           Reserved_31_23:9 ; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} D0F0xE4_WRAP_8040_STRUCT;

// **** D0F0xE4_WRAP_8060 Register Definition ****
// Address
#define D0F0xE4_WRAP_8060_ADDRESS                               0x8060

// Type
#define D0F0xE4_WRAP_8060_TYPE                                  TYPE_D0F0xE4
// Field Data
#define D0F0xE4_WRAP_8060_Reconfigure_OFFSET                    0
#define D0F0xE4_WRAP_8060_Reconfigure_WIDTH                     1
#define D0F0xE4_WRAP_8060_Reconfigure_MASK                      0x1
#define D0F0xE4_WRAP_8060_Reserved_1_1_OFFSET                   1
#define D0F0xE4_WRAP_8060_Reserved_1_1_WIDTH                    1
#define D0F0xE4_WRAP_8060_Reserved_1_1_MASK                     0x2
#define D0F0xE4_WRAP_8060_ResetComplete_OFFSET                  2
#define D0F0xE4_WRAP_8060_ResetComplete_WIDTH                   1
#define D0F0xE4_WRAP_8060_ResetComplete_MASK                    0x4
#define D0F0xE4_WRAP_8060_Reserved_15_3_OFFSET                  3
#define D0F0xE4_WRAP_8060_Reserved_15_3_WIDTH                   13
#define D0F0xE4_WRAP_8060_Reserved_15_3_MASK                    0xfff8
#define D0F0xE4_WRAP_8060_BifGlobalReset_OFFSET                 16
#define D0F0xE4_WRAP_8060_BifGlobalReset_WIDTH                  1
#define D0F0xE4_WRAP_8060_BifGlobalReset_MASK                   0x10000
#define D0F0xE4_WRAP_8060_BifCalibrationReset_OFFSET            17
#define D0F0xE4_WRAP_8060_BifCalibrationReset_WIDTH             1
#define D0F0xE4_WRAP_8060_BifCalibrationReset_MASK              0x20000
#define D0F0xE4_WRAP_8060_Reserved_31_18_OFFSET                 18
#define D0F0xE4_WRAP_8060_Reserved_31_18_WIDTH                  14
#define D0F0xE4_WRAP_8060_Reserved_31_18_MASK                   0xfffc0000

/// D0F0xE4_WRAP_8060
typedef union {
  struct {                                                              ///<
    UINT32                                              Reconfigure:1 ; ///<
    UINT32                                             Reserved_1_1:1 ; ///<
    UINT32                                            ResetComplete:1 ; ///<
    UINT32                                            Reserved_15_3:13; ///<
    UINT32                                           BifGlobalReset:1 ; ///<
    UINT32                                      BifCalibrationReset:1 ; ///<
    UINT32                                           Reserved_31_18:14; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} D0F0xE4_WRAP_8060_STRUCT;

// **** D0F0xE4_WRAP_8062 Register Definition ****
// Address
#define D0F0xE4_WRAP_8062_ADDRESS                               0x8062

// Type
#define D0F0xE4_WRAP_8062_TYPE                                  TYPE_D0F0xE4
// Field Data
#define D0F0xE4_WRAP_8062_ReconfigureEn_OFFSET                  0
#define D0F0xE4_WRAP_8062_ReconfigureEn_WIDTH                   1
#define D0F0xE4_WRAP_8062_ReconfigureEn_MASK                    0x1
#define D0F0xE4_WRAP_8062_Reserved_1_1_OFFSET                   1
#define D0F0xE4_WRAP_8062_Reserved_1_1_WIDTH                    1
#define D0F0xE4_WRAP_8062_Reserved_1_1_MASK                     0x2
#define D0F0xE4_WRAP_8062_ResetPeriod_OFFSET                    2
#define D0F0xE4_WRAP_8062_ResetPeriod_WIDTH                     3
#define D0F0xE4_WRAP_8062_ResetPeriod_MASK                      0x1c
#define D0F0xE4_WRAP_8062_Reserved_9_5_OFFSET                   5
#define D0F0xE4_WRAP_8062_Reserved_9_5_WIDTH                    5
#define D0F0xE4_WRAP_8062_Reserved_9_5_MASK                     0x3e0
#define D0F0xE4_WRAP_8062_BlockOnIdle_OFFSET                    10
#define D0F0xE4_WRAP_8062_BlockOnIdle_WIDTH                     1
#define D0F0xE4_WRAP_8062_BlockOnIdle_MASK                      0x400
#define D0F0xE4_WRAP_8062_ConfigXferMode_OFFSET                 11
#define D0F0xE4_WRAP_8062_ConfigXferMode_WIDTH                  1
#define D0F0xE4_WRAP_8062_ConfigXferMode_MASK                   0x800
#define D0F0xE4_WRAP_8062_Reserved_31_12_OFFSET                 12
#define D0F0xE4_WRAP_8062_Reserved_31_12_WIDTH                  20
#define D0F0xE4_WRAP_8062_Reserved_31_12_MASK                   0xfffff000

/// D0F0xE4_WRAP_8062
typedef union {
  struct {                                                              ///<
    UINT32                                            ReconfigureEn:1 ; ///<
    UINT32                                             Reserved_1_1:1 ; ///<
    UINT32                                              ResetPeriod:3 ; ///<
    UINT32                                             Reserved_9_5:5 ; ///<
    UINT32                                              BlockOnIdle:1 ; ///<
    UINT32                                           ConfigXferMode:1 ; ///<
    UINT32                                           Reserved_31_12:20; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} D0F0xE4_WRAP_8062_STRUCT;

// **** D0F0xE4_WRAP_80F0 Register Definition ****
// Address
#define D0F0xE4_WRAP_80F0_ADDRESS                               0x80f0

// Type
#define D0F0xE4_WRAP_80F0_TYPE                                  TYPE_D0F0xE4
// Field Data
#define D0F0xE4_WRAP_80F0_MicroSeconds_OFFSET                   0
#define D0F0xE4_WRAP_80F0_MicroSeconds_WIDTH                    32
#define D0F0xE4_WRAP_80F0_MicroSeconds_MASK                     0xffffffff

/// D0F0xE4_WRAP_80F0
typedef union {
  struct {                                                              ///<
    UINT32                                             MicroSeconds:32; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} D0F0xE4_WRAP_80F0_STRUCT;

// **** D0F0xE4_WRAP_80F1 Register Definition ****
// Address
#define D0F0xE4_WRAP_80F1_ADDRESS                               0x80f1

// Type
#define D0F0xE4_WRAP_80F1_TYPE                                  TYPE_D0F0xE4
// Field Data
#define D0F0xE4_WRAP_80F1_ClockRate_OFFSET                      0
#define D0F0xE4_WRAP_80F1_ClockRate_WIDTH                       8
#define D0F0xE4_WRAP_80F1_ClockRate_MASK                        0xff
#define D0F0xE4_WRAP_80F1_Reserved_31_8_OFFSET                  8
#define D0F0xE4_WRAP_80F1_Reserved_31_8_WIDTH                   24
#define D0F0xE4_WRAP_80F1_Reserved_31_8_MASK                    0xffffff00

/// D0F0xE4_WRAP_80F1
typedef union {
  struct {                                                              ///<
    UINT32                                                ClockRate:8 ; ///<
    UINT32                                            Reserved_31_8:24; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} D0F0xE4_WRAP_80F1_STRUCT;

// **** D0F0xE4_PIF_0010 Register Definition ****
// Address
#define D0F0xE4_PIF_0010_ADDRESS                                0x10

// Type
#define D0F0xE4_PIF_0010_TYPE                                   TYPE_D0F0xE4
// Field Data
#define D0F0xE4_PIF_0010_Reserved_3_0_OFFSET                    0
#define D0F0xE4_PIF_0010_Reserved_3_0_WIDTH                     4
#define D0F0xE4_PIF_0010_Reserved_3_0_MASK                      0xf
#define D0F0xE4_PIF_0010_EiDetCycleMode_OFFSET                  4
#define D0F0xE4_PIF_0010_EiDetCycleMode_WIDTH                   1
#define D0F0xE4_PIF_0010_EiDetCycleMode_MASK                    0x10
#define D0F0xE4_PIF_0010_Reserved_5_5_OFFSET                    5
#define D0F0xE4_PIF_0010_Reserved_5_5_WIDTH                     1
#define D0F0xE4_PIF_0010_Reserved_5_5_MASK                      0x20
#define D0F0xE4_PIF_0010_RxDetectFifoResetMode_OFFSET           6
#define D0F0xE4_PIF_0010_RxDetectFifoResetMode_WIDTH            1
#define D0F0xE4_PIF_0010_RxDetectFifoResetMode_MASK             0x40
#define D0F0xE4_PIF_0010_RxDetectTxPwrMode_OFFSET               7
#define D0F0xE4_PIF_0010_RxDetectTxPwrMode_WIDTH                1
#define D0F0xE4_PIF_0010_RxDetectTxPwrMode_MASK                 0x80
#define D0F0xE4_PIF_0010_Reserved_16_8_OFFSET                   8
#define D0F0xE4_PIF_0010_Reserved_16_8_WIDTH                    9
#define D0F0xE4_PIF_0010_Reserved_16_8_MASK                     0x1ff00
#define D0F0xE4_PIF_0010_Ls2ExitTime_OFFSET                     17
#define D0F0xE4_PIF_0010_Ls2ExitTime_WIDTH                      3
#define D0F0xE4_PIF_0010_Ls2ExitTime_MASK                       0xe0000
#define D0F0xE4_PIF_0010_EiCycleOffTime_OFFSET                  20
#define D0F0xE4_PIF_0010_EiCycleOffTime_WIDTH                   3
#define D0F0xE4_PIF_0010_EiCycleOffTime_MASK                    0x700000
#define D0F0xE4_PIF_0010_Reserved_31_23_OFFSET                  23
#define D0F0xE4_PIF_0010_Reserved_31_23_WIDTH                   9
#define D0F0xE4_PIF_0010_Reserved_31_23_MASK                    0xff800000

/// D0F0xE4_PIF_0010
typedef union {
  struct {                                                              ///<
    UINT32                                             Reserved_3_0:4 ; ///<
    UINT32                                           EiDetCycleMode:1 ; ///<
    UINT32                                             Reserved_5_5:1 ; ///<
    UINT32                                    RxDetectFifoResetMode:1 ; ///<
    UINT32                                        RxDetectTxPwrMode:1 ; ///<
    UINT32                                            Reserved_16_8:9 ; ///<
    UINT32                                              Ls2ExitTime:3 ; ///<
    UINT32                                           EiCycleOffTime:3 ; ///<
    UINT32                                           Reserved_31_23:9 ; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} D0F0xE4_PIF_0010_STRUCT;

// **** D0F0xE4_PIF_0011 Register Definition ****
// Address
#define D0F0xE4_PIF_0011_ADDRESS                                0x11

// Type
#define D0F0xE4_PIF_0011_TYPE                                   TYPE_D0F0xE4
// Field Data
#define D0F0xE4_PIF_0011_X2Lane10_OFFSET                        0
#define D0F0xE4_PIF_0011_X2Lane10_WIDTH                         1
#define D0F0xE4_PIF_0011_X2Lane10_MASK                          0x1
#define D0F0xE4_PIF_0011_X2Lane32_OFFSET                        1
#define D0F0xE4_PIF_0011_X2Lane32_WIDTH                         1
#define D0F0xE4_PIF_0011_X2Lane32_MASK                          0x2
#define D0F0xE4_PIF_0011_X2Lane54_OFFSET                        2
#define D0F0xE4_PIF_0011_X2Lane54_WIDTH                         1
#define D0F0xE4_PIF_0011_X2Lane54_MASK                          0x4
#define D0F0xE4_PIF_0011_X2Lane76_OFFSET                        3
#define D0F0xE4_PIF_0011_X2Lane76_WIDTH                         1
#define D0F0xE4_PIF_0011_X2Lane76_MASK                          0x8
#define D0F0xE4_PIF_0011_Reserved_7_4_OFFSET                    4
#define D0F0xE4_PIF_0011_Reserved_7_4_WIDTH                     4
#define D0F0xE4_PIF_0011_Reserved_7_4_MASK                      0xf0
#define D0F0xE4_PIF_0011_X4Lane30_OFFSET                        8
#define D0F0xE4_PIF_0011_X4Lane30_WIDTH                         1
#define D0F0xE4_PIF_0011_X4Lane30_MASK                          0x100
#define D0F0xE4_PIF_0011_X4Lane74_OFFSET                        9
#define D0F0xE4_PIF_0011_X4Lane74_WIDTH                         1
#define D0F0xE4_PIF_0011_X4Lane74_MASK                          0x200
#define D0F0xE4_PIF_0011_Reserved_11_10_OFFSET                  10
#define D0F0xE4_PIF_0011_Reserved_11_10_WIDTH                   2
#define D0F0xE4_PIF_0011_Reserved_11_10_MASK                    0xc00
#define D0F0xE4_PIF_0011_X4Lane52_OFFSET                        12
#define D0F0xE4_PIF_0011_X4Lane52_WIDTH                         1
#define D0F0xE4_PIF_0011_X4Lane52_MASK                          0x1000
#define D0F0xE4_PIF_0011_Reserved_15_13_OFFSET                  13
#define D0F0xE4_PIF_0011_Reserved_15_13_WIDTH                   3
#define D0F0xE4_PIF_0011_Reserved_15_13_MASK                    0xe000
#define D0F0xE4_PIF_0011_X8Lane70_OFFSET                        16
#define D0F0xE4_PIF_0011_X8Lane70_WIDTH                         1
#define D0F0xE4_PIF_0011_X8Lane70_MASK                          0x10000
#define D0F0xE4_PIF_0011_Reserved_24_17_OFFSET                  17
#define D0F0xE4_PIF_0011_Reserved_24_17_WIDTH                   8
#define D0F0xE4_PIF_0011_Reserved_24_17_MASK                    0x1fe0000
#define D0F0xE4_PIF_0011_MultiPif_OFFSET                        25
#define D0F0xE4_PIF_0011_MultiPif_WIDTH                         1
#define D0F0xE4_PIF_0011_MultiPif_MASK                          0x2000000
#define D0F0xE4_PIF_0011_Reserved_31_26_OFFSET                  26
#define D0F0xE4_PIF_0011_Reserved_31_26_WIDTH                   6
#define D0F0xE4_PIF_0011_Reserved_31_26_MASK                    0xfc000000

/// D0F0xE4_PIF_0011
typedef union {
  struct {                                                              ///<
    UINT32                                                 X2Lane10:1 ; ///<
    UINT32                                                 X2Lane32:1 ; ///<
    UINT32                                                 X2Lane54:1 ; ///<
    UINT32                                                 X2Lane76:1 ; ///<
    UINT32                                             Reserved_7_4:4 ; ///<
    UINT32                                                 X4Lane30:1 ; ///<
    UINT32                                                 X4Lane74:1 ; ///<
    UINT32                                           Reserved_11_10:2 ; ///<
    UINT32                                                 X4Lane52:1 ; ///<
    UINT32                                           Reserved_15_13:3 ; ///<
    UINT32                                                 X8Lane70:1 ; ///<
    UINT32                                           Reserved_24_17:8 ; ///<
    UINT32                                                 MultiPif:1 ; ///<
    UINT32                                           Reserved_31_26:6 ; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} D0F0xE4_PIF_0011_STRUCT;

// **** D0F0xE4_PIF_0012 Register Definition ****
// Address
#define D0F0xE4_PIF_0012_ADDRESS                                0x12

// Type
#define D0F0xE4_PIF_0012_TYPE                                   TYPE_D0F0xE4
// Field Data
#define D0F0xE4_PIF_0012_TxPowerStateInTxs2_OFFSET              0
#define D0F0xE4_PIF_0012_TxPowerStateInTxs2_WIDTH               3
#define D0F0xE4_PIF_0012_TxPowerStateInTxs2_MASK                0x7
#define D0F0xE4_PIF_0012_ForceRxEnInL0s_OFFSET                  3
#define D0F0xE4_PIF_0012_ForceRxEnInL0s_WIDTH                   1
#define D0F0xE4_PIF_0012_ForceRxEnInL0s_MASK                    0x8
#define D0F0xE4_PIF_0012_RxPowerStateInRxs2_OFFSET              4
#define D0F0xE4_PIF_0012_RxPowerStateInRxs2_WIDTH               3
#define D0F0xE4_PIF_0012_RxPowerStateInRxs2_MASK                0x70
#define D0F0xE4_PIF_0012_PllPowerStateInTxs2_OFFSET             7
#define D0F0xE4_PIF_0012_PllPowerStateInTxs2_WIDTH              3
#define D0F0xE4_PIF_0012_PllPowerStateInTxs2_MASK               0x380
#define D0F0xE4_PIF_0012_PllPowerStateInOff_OFFSET              10
#define D0F0xE4_PIF_0012_PllPowerStateInOff_WIDTH               3
#define D0F0xE4_PIF_0012_PllPowerStateInOff_MASK                0x1c00
#define D0F0xE4_PIF_0012_Reserved_15_13_OFFSET                  13
#define D0F0xE4_PIF_0012_Reserved_15_13_WIDTH                   3
#define D0F0xE4_PIF_0012_Reserved_15_13_MASK                    0xe000
#define D0F0xE4_PIF_0012_Tx2p5clkClockGatingEn_OFFSET           16
#define D0F0xE4_PIF_0012_Tx2p5clkClockGatingEn_WIDTH            1
#define D0F0xE4_PIF_0012_Tx2p5clkClockGatingEn_MASK             0x10000
#define D0F0xE4_PIF_0012_Reserved_23_17_OFFSET                  17
#define D0F0xE4_PIF_0012_Reserved_23_17_WIDTH                   7
#define D0F0xE4_PIF_0012_Reserved_23_17_MASK                    0xfe0000
#define D0F0xE4_PIF_0012_PllRampUpTime_OFFSET                   24
#define D0F0xE4_PIF_0012_PllRampUpTime_WIDTH                    3
#define D0F0xE4_PIF_0012_PllRampUpTime_MASK                     0x7000000
#define D0F0xE4_PIF_0012_Reserved_27_27_OFFSET                  27
#define D0F0xE4_PIF_0012_Reserved_27_27_WIDTH                   1
#define D0F0xE4_PIF_0012_Reserved_27_27_MASK                    0x8000000
#define D0F0xE4_PIF_0012_PllPwrOverrideEn_OFFSET                28
#define D0F0xE4_PIF_0012_PllPwrOverrideEn_WIDTH                 1
#define D0F0xE4_PIF_0012_PllPwrOverrideEn_MASK                  0x10000000
#define D0F0xE4_PIF_0012_PllPwrOverrideVal_OFFSET               29
#define D0F0xE4_PIF_0012_PllPwrOverrideVal_WIDTH                3
#define D0F0xE4_PIF_0012_PllPwrOverrideVal_MASK                 0xe0000000

/// D0F0xE4_PIF_0012
typedef union {
  struct {                                                              ///<
    UINT32                                       TxPowerStateInTxs2:3 ; ///<
    UINT32                                           ForceRxEnInL0s:1 ; ///<
    UINT32                                       RxPowerStateInRxs2:3 ; ///<
    UINT32                                      PllPowerStateInTxs2:3 ; ///<
    UINT32                                       PllPowerStateInOff:3 ; ///<
    UINT32                                           Reserved_15_13:3 ; ///<
    UINT32                                    Tx2p5clkClockGatingEn:1 ; ///<
    UINT32                                           Reserved_23_17:7 ; ///<
    UINT32                                            PllRampUpTime:3 ; ///<
    UINT32                                           Reserved_27_27:1 ; ///<
    UINT32                                         PllPwrOverrideEn:1 ; ///<
    UINT32                                        PllPwrOverrideVal:3 ; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} D0F0xE4_PIF_0012_STRUCT;

// **** D0F0xE4_PIF_0013 Register Definition ****
// Address
#define D0F0xE4_PIF_0013_ADDRESS                                0x13

// Type
#define D0F0xE4_PIF_0013_TYPE                                   TYPE_D0F0xE4
// Field Data
#define D0F0xE4_PIF_0013_TxPowerStateInTxs2_OFFSET              0
#define D0F0xE4_PIF_0013_TxPowerStateInTxs2_WIDTH               3
#define D0F0xE4_PIF_0013_TxPowerStateInTxs2_MASK                0x7
#define D0F0xE4_PIF_0013_ForceRxEnInL0s_OFFSET                  3
#define D0F0xE4_PIF_0013_ForceRxEnInL0s_WIDTH                   1
#define D0F0xE4_PIF_0013_ForceRxEnInL0s_MASK                    0x8
#define D0F0xE4_PIF_0013_RxPowerStateInRxs2_OFFSET              4
#define D0F0xE4_PIF_0013_RxPowerStateInRxs2_WIDTH               3
#define D0F0xE4_PIF_0013_RxPowerStateInRxs2_MASK                0x70
#define D0F0xE4_PIF_0013_PllPowerStateInTxs2_OFFSET             7
#define D0F0xE4_PIF_0013_PllPowerStateInTxs2_WIDTH              3
#define D0F0xE4_PIF_0013_PllPowerStateInTxs2_MASK               0x380
#define D0F0xE4_PIF_0013_PllPowerStateInOff_OFFSET              10
#define D0F0xE4_PIF_0013_PllPowerStateInOff_WIDTH               3
#define D0F0xE4_PIF_0013_PllPowerStateInOff_MASK                0x1c00
#define D0F0xE4_PIF_0013_Reserved_15_13_OFFSET                  13
#define D0F0xE4_PIF_0013_Reserved_15_13_WIDTH                   3
#define D0F0xE4_PIF_0013_Reserved_15_13_MASK                    0xe000
#define D0F0xE4_PIF_0013_Tx2p5clkClockGatingEn_OFFSET           16
#define D0F0xE4_PIF_0013_Tx2p5clkClockGatingEn_WIDTH            1
#define D0F0xE4_PIF_0013_Tx2p5clkClockGatingEn_MASK             0x10000
#define D0F0xE4_PIF_0013_Reserved_23_17_OFFSET                  17
#define D0F0xE4_PIF_0013_Reserved_23_17_WIDTH                   7
#define D0F0xE4_PIF_0013_Reserved_23_17_MASK                    0xfe0000
#define D0F0xE4_PIF_0013_PllRampUpTime_OFFSET                   24
#define D0F0xE4_PIF_0013_PllRampUpTime_WIDTH                    3
#define D0F0xE4_PIF_0013_PllRampUpTime_MASK                     0x7000000
#define D0F0xE4_PIF_0013_Reserved_27_27_OFFSET                  27
#define D0F0xE4_PIF_0013_Reserved_27_27_WIDTH                   1
#define D0F0xE4_PIF_0013_Reserved_27_27_MASK                    0x8000000
#define D0F0xE4_PIF_0013_PllPwrOverrideEn_OFFSET                28
#define D0F0xE4_PIF_0013_PllPwrOverrideEn_WIDTH                 1
#define D0F0xE4_PIF_0013_PllPwrOverrideEn_MASK                  0x10000000
#define D0F0xE4_PIF_0013_PllPwrOverrideVal_OFFSET               29
#define D0F0xE4_PIF_0013_PllPwrOverrideVal_WIDTH                3
#define D0F0xE4_PIF_0013_PllPwrOverrideVal_MASK                 0xe0000000

/// D0F0xE4_PIF_0013
typedef union {
  struct {                                                              ///<
    UINT32                                       TxPowerStateInTxs2:3 ; ///<
    UINT32                                           ForceRxEnInL0s:1 ; ///<
    UINT32                                       RxPowerStateInRxs2:3 ; ///<
    UINT32                                      PllPowerStateInTxs2:3 ; ///<
    UINT32                                       PllPowerStateInOff:3 ; ///<
    UINT32                                           Reserved_15_13:3 ; ///<
    UINT32                                    Tx2p5clkClockGatingEn:1 ; ///<
    UINT32                                           Reserved_23_17:7 ; ///<
    UINT32                                            PllRampUpTime:3 ; ///<
    UINT32                                           Reserved_27_27:1 ; ///<
    UINT32                                         PllPwrOverrideEn:1 ; ///<
    UINT32                                        PllPwrOverrideVal:3 ; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} D0F0xE4_PIF_0013_STRUCT;

// **** D0F0xE4_PIF_0015 Register Definition ****
// Address
#define D0F0xE4_PIF_0015_ADDRESS                                0x15

// Type
#define D0F0xE4_PIF_0015_TYPE                                   TYPE_D0F0xE4
// Field Data
#define D0F0xE4_PIF_0015_TxPhyStatus00_OFFSET                   0
#define D0F0xE4_PIF_0015_TxPhyStatus00_WIDTH                    1
#define D0F0xE4_PIF_0015_TxPhyStatus00_MASK                     0x1
#define D0F0xE4_PIF_0015_TxPhyStatus01_OFFSET                   1
#define D0F0xE4_PIF_0015_TxPhyStatus01_WIDTH                    1
#define D0F0xE4_PIF_0015_TxPhyStatus01_MASK                     0x2
#define D0F0xE4_PIF_0015_TxPhyStatus02_OFFSET                   2
#define D0F0xE4_PIF_0015_TxPhyStatus02_WIDTH                    1
#define D0F0xE4_PIF_0015_TxPhyStatus02_MASK                     0x4
#define D0F0xE4_PIF_0015_TxPhyStatus03_OFFSET                   3
#define D0F0xE4_PIF_0015_TxPhyStatus03_WIDTH                    1
#define D0F0xE4_PIF_0015_TxPhyStatus03_MASK                     0x8
#define D0F0xE4_PIF_0015_TxPhyStatus04_OFFSET                   4
#define D0F0xE4_PIF_0015_TxPhyStatus04_WIDTH                    1
#define D0F0xE4_PIF_0015_TxPhyStatus04_MASK                     0x10
#define D0F0xE4_PIF_0015_TxPhyStatus05_OFFSET                   5
#define D0F0xE4_PIF_0015_TxPhyStatus05_WIDTH                    1
#define D0F0xE4_PIF_0015_TxPhyStatus05_MASK                     0x20
#define D0F0xE4_PIF_0015_TxPhyStatus06_OFFSET                   6
#define D0F0xE4_PIF_0015_TxPhyStatus06_WIDTH                    1
#define D0F0xE4_PIF_0015_TxPhyStatus06_MASK                     0x40
#define D0F0xE4_PIF_0015_TxPhyStatus07_OFFSET                   7
#define D0F0xE4_PIF_0015_TxPhyStatus07_WIDTH                    1
#define D0F0xE4_PIF_0015_TxPhyStatus07_MASK                     0x80
#define D0F0xE4_PIF_0015_Reserved_31_8_OFFSET                   8
#define D0F0xE4_PIF_0015_Reserved_31_8_WIDTH                    24
#define D0F0xE4_PIF_0015_Reserved_31_8_MASK                     0xffffff00

/// D0F0xE4_PIF_0015
typedef union {
  struct {                                                              ///<
    UINT32                                            TxPhyStatus00:1 ; ///<
    UINT32                                            TxPhyStatus01:1 ; ///<
    UINT32                                            TxPhyStatus02:1 ; ///<
    UINT32                                            TxPhyStatus03:1 ; ///<
    UINT32                                            TxPhyStatus04:1 ; ///<
    UINT32                                            TxPhyStatus05:1 ; ///<
    UINT32                                            TxPhyStatus06:1 ; ///<
    UINT32                                            TxPhyStatus07:1 ; ///<
    UINT32                                            Reserved_31_8:24; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} D0F0xE4_PIF_0015_STRUCT;

// **** D0F0xE4_CORE_0002 Register Definition ****
// Address
#define D0F0xE4_CORE_0002_ADDRESS                               0x2

// Type
#define D0F0xE4_CORE_0002_TYPE                                  TYPE_D0F0xE4
// Field Data
#define D0F0xE4_CORE_0002_HwDebug_0__OFFSET                     0
#define D0F0xE4_CORE_0002_HwDebug_0__WIDTH                      1
#define D0F0xE4_CORE_0002_HwDebug_0__MASK                       0x1
#define D0F0xE4_CORE_0002_Reserved_31_1_OFFSET                  1
#define D0F0xE4_CORE_0002_Reserved_31_1_WIDTH                   31
#define D0F0xE4_CORE_0002_Reserved_31_1_MASK                    0xfffffffe

/// D0F0xE4_CORE_0002
typedef union {
  struct {                                                              ///<
    UINT32                                               HwDebug_0_:1 ; ///<
    UINT32                                            Reserved_31_1:31; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} D0F0xE4_CORE_0002_STRUCT;


// **** D0F0xE4_CORE_0011 Register Definition ****
// Address
#define D0F0xE4_CORE_0011_ADDRESS                               0x11

// Type
#define D0F0xE4_CORE_0011_TYPE                                  TYPE_D0F0xE4
// Field Data
#define D0F0xE4_CORE_0011_DynClkLatency_OFFSET                  0
#define D0F0xE4_CORE_0011_DynClkLatency_WIDTH                   4
#define D0F0xE4_CORE_0011_DynClkLatency_MASK                    0xf
#define D0F0xE4_CORE_0011_Reserved_31_4_OFFSET                  4
#define D0F0xE4_CORE_0011_Reserved_31_4_WIDTH                   28
#define D0F0xE4_CORE_0011_Reserved_31_4_MASK                    0xfffffff0

/// D0F0xE4_CORE_0011
typedef union {
  struct {                                                              ///<
    UINT32                                            DynClkLatency:4 ; ///<
    UINT32                                            Reserved_31_4:28; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} D0F0xE4_CORE_0011_STRUCT;

// **** D0F0xE4_CORE_001C Register Definition ****
// Address
#define D0F0xE4_CORE_001C_ADDRESS                               0x1c

// Type
#define D0F0xE4_CORE_001C_TYPE                                  TYPE_D0F0xE4
// Field Data
#define D0F0xE4_CORE_001C_TxArbRoundRobinEn_OFFSET              0
#define D0F0xE4_CORE_001C_TxArbRoundRobinEn_WIDTH               1
#define D0F0xE4_CORE_001C_TxArbRoundRobinEn_MASK                0x1
#define D0F0xE4_CORE_001C_TxArbSlvLimit_OFFSET                  1
#define D0F0xE4_CORE_001C_TxArbSlvLimit_WIDTH                   5
#define D0F0xE4_CORE_001C_TxArbSlvLimit_MASK                    0x3e
#define D0F0xE4_CORE_001C_TxArbMstLimit_OFFSET                  6
#define D0F0xE4_CORE_001C_TxArbMstLimit_WIDTH                   5
#define D0F0xE4_CORE_001C_TxArbMstLimit_MASK                    0x7c0
#define D0F0xE4_CORE_001C_Reserved_31_11_OFFSET                 11
#define D0F0xE4_CORE_001C_Reserved_31_11_WIDTH                  21
#define D0F0xE4_CORE_001C_Reserved_31_11_MASK                   0xfffff800

/// D0F0xE4_CORE_001C
typedef union {
  struct {                                                              ///<
    UINT32                                        TxArbRoundRobinEn:1 ; ///<
    UINT32                                            TxArbSlvLimit:5 ; ///<
    UINT32                                            TxArbMstLimit:5 ; ///<
    UINT32                                           Reserved_31_11:21; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} D0F0xE4_CORE_001C_STRUCT;

// **** D0F0xE4_CORE_0040 Register Definition ****
// Address
#define D0F0xE4_CORE_0040_ADDRESS                               0x40

// Type
#define D0F0xE4_CORE_0040_TYPE                                  TYPE_D0F0xE4
// Field Data
#define D0F0xE4_CORE_0040_Reserved_13_0_OFFSET                  0
#define D0F0xE4_CORE_0040_Reserved_13_0_WIDTH                   14
#define D0F0xE4_CORE_0040_Reserved_13_0_MASK                    0x3fff
#define D0F0xE4_CORE_0040_PElecIdleMode_OFFSET                  14
#define D0F0xE4_CORE_0040_PElecIdleMode_WIDTH                   2
#define D0F0xE4_CORE_0040_PElecIdleMode_MASK                    0xc000
#define D0F0xE4_CORE_0040_Reserved_31_16_OFFSET                 16
#define D0F0xE4_CORE_0040_Reserved_31_16_WIDTH                  16
#define D0F0xE4_CORE_0040_Reserved_31_16_MASK                   0xffff0000

/// D0F0xE4_CORE_0040
typedef union {
  struct {                                                              ///<
    UINT32                                            Reserved_13_0:14; ///<
    UINT32                                            PElecIdleMode:2 ; ///<
    UINT32                                           Reserved_31_16:16; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} D0F0xE4_CORE_0040_STRUCT;

// **** D0F0xE4_CORE_00B0 Register Definition ****
// Address
#define D0F0xE4_CORE_00B0_ADDRESS                               0xb0

// Type
#define D0F0xE4_CORE_00B0_TYPE                                  TYPE_D0F0xE4
// Field Data
#define D0F0xE4_CORE_00B0_Reserved_1_0_OFFSET                   0
#define D0F0xE4_CORE_00B0_Reserved_1_0_WIDTH                    2
#define D0F0xE4_CORE_00B0_Reserved_1_0_MASK                     0x3
#define D0F0xE4_CORE_00B0_StrapF0MsiEn_OFFSET                   2
#define D0F0xE4_CORE_00B0_StrapF0MsiEn_WIDTH                    1
#define D0F0xE4_CORE_00B0_StrapF0MsiEn_MASK                     0x4
#define D0F0xE4_CORE_00B0_Reserved_4_3_OFFSET                   3
#define D0F0xE4_CORE_00B0_Reserved_4_3_WIDTH                    2
#define D0F0xE4_CORE_00B0_Reserved_4_3_MASK                     0x18
#define D0F0xE4_CORE_00B0_StrapF0AerEn_OFFSET                   5
#define D0F0xE4_CORE_00B0_StrapF0AerEn_WIDTH                    1
#define D0F0xE4_CORE_00B0_StrapF0AerEn_MASK                     0x20
#define D0F0xE4_CORE_00B0_Reserved_31_6_OFFSET                  6
#define D0F0xE4_CORE_00B0_Reserved_31_6_WIDTH                   26
#define D0F0xE4_CORE_00B0_Reserved_31_6_MASK                    0xffffffc0

/// D0F0xE4_CORE_00B0
typedef union {
  struct {                                                              ///<
    UINT32                                             Reserved_1_0:2 ; ///<
    UINT32                                             StrapF0MsiEn:1 ; ///<
    UINT32                                             Reserved_4_3:2 ; ///<
    UINT32                                             StrapF0AerEn:1 ; ///<
    UINT32                                            Reserved_31_6:26; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} D0F0xE4_CORE_00B0_STRUCT;

// **** D0F0xE4_CORE_00C0 Register Definition ****
// Address
#define D0F0xE4_CORE_00C0_ADDRESS                               0xc0

// Type
#define D0F0xE4_CORE_00C0_TYPE                                  TYPE_D0F0xE4
// Field Data
#define D0F0xE4_CORE_00C0_Reserved_27_0_OFFSET                  0
#define D0F0xE4_CORE_00C0_Reserved_27_0_WIDTH                   28
#define D0F0xE4_CORE_00C0_Reserved_27_0_MASK                    0xfffffff
#define D0F0xE4_CORE_00C0_StrapReverseAll_OFFSET                28
#define D0F0xE4_CORE_00C0_StrapReverseAll_WIDTH                 1
#define D0F0xE4_CORE_00C0_StrapReverseAll_MASK                  0x10000000
#define D0F0xE4_CORE_00C0_StrapMstAdr64En_OFFSET                29
#define D0F0xE4_CORE_00C0_StrapMstAdr64En_WIDTH                 1
#define D0F0xE4_CORE_00C0_StrapMstAdr64En_MASK                  0x20000000
#define D0F0xE4_CORE_00C0_Reserved_31_30_OFFSET                 30
#define D0F0xE4_CORE_00C0_Reserved_31_30_WIDTH                  2
#define D0F0xE4_CORE_00C0_Reserved_31_30_MASK                   0xc0000000

/// D0F0xE4_CORE_00C0
typedef union {
  struct {                                                              ///<
    UINT32                                            Reserved_27_0:28; ///<
    UINT32                                          StrapReverseAll:1 ; ///<
    UINT32                                          StrapMstAdr64En:1 ; ///<
    UINT32                                           Reserved_31_30:2 ; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} D0F0xE4_CORE_00C0_STRUCT;

// **** D0F0xE4_CORE_00C1 Register Definition ****
// Address
#define D0F0xE4_CORE_00C1_ADDRESS                               0xc1

// Type
#define D0F0xE4_CORE_00C1_TYPE                                  TYPE_D0F0xE4
// Field Data
#define D0F0xE4_CORE_00C1_StrapLinkBwNotificationCapEn_OFFSET   0
#define D0F0xE4_CORE_00C1_StrapLinkBwNotificationCapEn_WIDTH    1
#define D0F0xE4_CORE_00C1_StrapLinkBwNotificationCapEn_MASK     0x1
#define D0F0xE4_CORE_00C1_StrapGen2Compliance_OFFSET            1
#define D0F0xE4_CORE_00C1_StrapGen2Compliance_WIDTH             1
#define D0F0xE4_CORE_00C1_StrapGen2Compliance_MASK              0x2
#define D0F0xE4_CORE_00C1_Reserved_31_2_OFFSET                  2
#define D0F0xE4_CORE_00C1_Reserved_31_2_WIDTH                   30
#define D0F0xE4_CORE_00C1_Reserved_31_2_MASK                    0xfffffffc

/// D0F0xE4_CORE_00C1
typedef union {
  struct {                                                              ///<
    UINT32                             StrapLinkBwNotificationCapEn:1 ; ///<
    UINT32                                      StrapGen2Compliance:1 ; ///<
    UINT32                                            Reserved_31_2:30; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} D0F0xE4_CORE_00C1_STRUCT;

// **** D0F0xE4_PHY_0009 Register Definition ****
// Address
#define D0F0xE4_PHY_0009_ADDRESS                                0x9

// Type
#define D0F0xE4_PHY_0009_TYPE                                   TYPE_D0F0xE4
// Field Data
#define D0F0xE4_PHY_0009_Reserved_23_0_OFFSET                   0
#define D0F0xE4_PHY_0009_Reserved_23_0_WIDTH                    24
#define D0F0xE4_PHY_0009_Reserved_23_0_MASK                     0xffffff
#define D0F0xE4_PHY_0009_ClkOff_OFFSET                          24
#define D0F0xE4_PHY_0009_ClkOff_WIDTH                           1
#define D0F0xE4_PHY_0009_ClkOff_MASK                            0x1000000
#define D0F0xE4_PHY_0009_DisplayStream_OFFSET                   25
#define D0F0xE4_PHY_0009_DisplayStream_WIDTH                    1
#define D0F0xE4_PHY_0009_DisplayStream_MASK                     0x2000000
#define D0F0xE4_PHY_0009_Reserved_27_26_OFFSET                  26
#define D0F0xE4_PHY_0009_Reserved_27_26_WIDTH                   2
#define D0F0xE4_PHY_0009_Reserved_27_26_MASK                    0xc000000
#define D0F0xE4_PHY_0009_CascadedPllSel_OFFSET                  28
#define D0F0xE4_PHY_0009_CascadedPllSel_WIDTH                   1
#define D0F0xE4_PHY_0009_CascadedPllSel_MASK                    0x10000000
#define D0F0xE4_PHY_0009_Reserved_30_29_OFFSET                  29
#define D0F0xE4_PHY_0009_Reserved_30_29_WIDTH                   2
#define D0F0xE4_PHY_0009_Reserved_30_29_MASK                    0x60000000
#define D0F0xE4_PHY_0009_PCIePllSel_OFFSET                      31
#define D0F0xE4_PHY_0009_PCIePllSel_WIDTH                       1
#define D0F0xE4_PHY_0009_PCIePllSel_MASK                        0x80000000

/// D0F0xE4_PHY_0009
typedef union {
  struct {                                                              ///<
    UINT32                                            Reserved_23_0:24; ///<
    UINT32                                                   ClkOff:1 ; ///<
    UINT32                                            DisplayStream:1 ; ///<
    UINT32                                           Reserved_27_26:2 ; ///<
    UINT32                                           CascadedPllSel:1 ; ///<
    UINT32                                           Reserved_30_29:2 ; ///<
    UINT32                                               PCIePllSel:1 ; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} D0F0xE4_PHY_0009_STRUCT;

// **** D0F0xE4_PHY_000A Register Definition ****
// Address
#define D0F0xE4_PHY_000A_ADDRESS                                0xa

// Type
#define D0F0xE4_PHY_000A_TYPE                                   TYPE_D0F0xE4
// Field Data
#define D0F0xE4_PHY_000A_Reserved_23_0_OFFSET                   0
#define D0F0xE4_PHY_000A_Reserved_23_0_WIDTH                    24
#define D0F0xE4_PHY_000A_Reserved_23_0_MASK                     0xffffff
#define D0F0xE4_PHY_000A_ClkOff_OFFSET                          24
#define D0F0xE4_PHY_000A_ClkOff_WIDTH                           1
#define D0F0xE4_PHY_000A_ClkOff_MASK                            0x1000000
#define D0F0xE4_PHY_000A_DisplayStream_OFFSET                   25
#define D0F0xE4_PHY_000A_DisplayStream_WIDTH                    1
#define D0F0xE4_PHY_000A_DisplayStream_MASK                     0x2000000
#define D0F0xE4_PHY_000A_Reserved_27_26_OFFSET                  26
#define D0F0xE4_PHY_000A_Reserved_27_26_WIDTH                   2
#define D0F0xE4_PHY_000A_Reserved_27_26_MASK                    0xc000000
#define D0F0xE4_PHY_000A_CascadedPllSel_OFFSET                  28
#define D0F0xE4_PHY_000A_CascadedPllSel_WIDTH                   1
#define D0F0xE4_PHY_000A_CascadedPllSel_MASK                    0x10000000
#define D0F0xE4_PHY_000A_Reserved_30_29_OFFSET                  29
#define D0F0xE4_PHY_000A_Reserved_30_29_WIDTH                   2
#define D0F0xE4_PHY_000A_Reserved_30_29_MASK                    0x60000000
#define D0F0xE4_PHY_000A_PCIePllSel_OFFSET                      31
#define D0F0xE4_PHY_000A_PCIePllSel_WIDTH                       1
#define D0F0xE4_PHY_000A_PCIePllSel_MASK                        0x80000000

/// D0F0xE4_PHY_000A
typedef union {
  struct {                                                              ///<
    UINT32                                            Reserved_23_0:24; ///<
    UINT32                                                   ClkOff:1 ; ///<
    UINT32                                            DisplayStream:1 ; ///<
    UINT32                                           Reserved_27_26:2 ; ///<
    UINT32                                           CascadedPllSel:1 ; ///<
    UINT32                                           Reserved_30_29:2 ; ///<
    UINT32                                               PCIePllSel:1 ; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} D0F0xE4_PHY_000A_STRUCT;

// **** D0F0xE4_PHY_000B Register Definition ****
// Address
#define D0F0xE4_PHY_000B_ADDRESS                                0xb

// Type
#define D0F0xE4_PHY_000B_TYPE                                   TYPE_D0F0xE4
// Field Data
#define D0F0xE4_PHY_000B_TxPwrSbiEn_OFFSET                      0
#define D0F0xE4_PHY_000B_TxPwrSbiEn_WIDTH                       1
#define D0F0xE4_PHY_000B_TxPwrSbiEn_MASK                        0x1
#define D0F0xE4_PHY_000B_RxPwrSbiEn_OFFSET                      1
#define D0F0xE4_PHY_000B_RxPwrSbiEn_WIDTH                       1
#define D0F0xE4_PHY_000B_RxPwrSbiEn_MASK                        0x2
#define D0F0xE4_PHY_000B_PcieModeSbiEn_OFFSET                   2
#define D0F0xE4_PHY_000B_PcieModeSbiEn_WIDTH                    1
#define D0F0xE4_PHY_000B_PcieModeSbiEn_MASK                     0x4
#define D0F0xE4_PHY_000B_FreqDivSbiEn_OFFSET                    3
#define D0F0xE4_PHY_000B_FreqDivSbiEn_WIDTH                     1
#define D0F0xE4_PHY_000B_FreqDivSbiEn_MASK                      0x8
#define D0F0xE4_PHY_000B_DllLockSbiEn_OFFSET                    4
#define D0F0xE4_PHY_000B_DllLockSbiEn_WIDTH                     1
#define D0F0xE4_PHY_000B_DllLockSbiEn_MASK                      0x10
#define D0F0xE4_PHY_000B_OffsetCancelSbiEn_OFFSET               5
#define D0F0xE4_PHY_000B_OffsetCancelSbiEn_WIDTH                1
#define D0F0xE4_PHY_000B_OffsetCancelSbiEn_MASK                 0x20
#define D0F0xE4_PHY_000B_SkipBitSbiEn_OFFSET                    6
#define D0F0xE4_PHY_000B_SkipBitSbiEn_WIDTH                     1
#define D0F0xE4_PHY_000B_SkipBitSbiEn_MASK                      0x40
#define D0F0xE4_PHY_000B_IncoherentClkSbiEn_OFFSET              7
#define D0F0xE4_PHY_000B_IncoherentClkSbiEn_WIDTH               1
#define D0F0xE4_PHY_000B_IncoherentClkSbiEn_MASK                0x80
#define D0F0xE4_PHY_000B_EiDetSbiEn_OFFSET                      8
#define D0F0xE4_PHY_000B_EiDetSbiEn_WIDTH                       1
#define D0F0xE4_PHY_000B_EiDetSbiEn_MASK                        0x100
#define D0F0xE4_PHY_000B_Reserved_13_9_OFFSET                   9
#define D0F0xE4_PHY_000B_Reserved_13_9_WIDTH                    5
#define D0F0xE4_PHY_000B_Reserved_13_9_MASK                     0x3e00
#define D0F0xE4_PHY_000B_MargPktSbiEn_OFFSET                    14
#define D0F0xE4_PHY_000B_MargPktSbiEn_WIDTH                     1
#define D0F0xE4_PHY_000B_MargPktSbiEn_MASK                      0x4000
#define D0F0xE4_PHY_000B_PllCmpPktSbiEn_OFFSET                  15
#define D0F0xE4_PHY_000B_PllCmpPktSbiEn_WIDTH                   1
#define D0F0xE4_PHY_000B_PllCmpPktSbiEn_MASK                    0x8000
#define D0F0xE4_PHY_000B_Reserved_31_16_OFFSET                  16
#define D0F0xE4_PHY_000B_Reserved_31_16_WIDTH                   16
#define D0F0xE4_PHY_000B_Reserved_31_16_MASK                    0xffff0000

/// D0F0xE4_PHY_000B
typedef union {
  struct {                                                              ///<
    UINT32                                               TxPwrSbiEn:1 ; ///<
    UINT32                                               RxPwrSbiEn:1 ; ///<
    UINT32                                            PcieModeSbiEn:1 ; ///<
    UINT32                                             FreqDivSbiEn:1 ; ///<
    UINT32                                             DllLockSbiEn:1 ; ///<
    UINT32                                        OffsetCancelSbiEn:1 ; ///<
    UINT32                                             SkipBitSbiEn:1 ; ///<
    UINT32                                       IncoherentClkSbiEn:1 ; ///<
    UINT32                                               EiDetSbiEn:1 ; ///<
    UINT32                                            Reserved_13_9:5 ; ///<
    UINT32                                             MargPktSbiEn:1 ; ///<
    UINT32                                           PllCmpPktSbiEn:1 ; ///<
    UINT32                                           Reserved_31_16:16; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} D0F0xE4_PHY_000B_STRUCT;

// **** D0F0xE4_PHY_2000 Register Definition ****
// Address
#define D0F0xE4_PHY_2000_ADDRESS                                0x2000

// Type
#define D0F0xE4_PHY_2000_TYPE                                   TYPE_D0F0xE4
// Field Data
#define D0F0xE4_PHY_2000_PllPowerDownEn_OFFSET                  0
#define D0F0xE4_PHY_2000_PllPowerDownEn_WIDTH                   3
#define D0F0xE4_PHY_2000_PllPowerDownEn_MASK                    0x7
#define D0F0xE4_PHY_2000_PllAutoPwrDownDis_OFFSET               3
#define D0F0xE4_PHY_2000_PllAutoPwrDownDis_WIDTH                1
#define D0F0xE4_PHY_2000_PllAutoPwrDownDis_MASK                 0x8
#define D0F0xE4_PHY_2000_Reserved_31_4_OFFSET                   4
#define D0F0xE4_PHY_2000_Reserved_31_4_WIDTH                    28
#define D0F0xE4_PHY_2000_Reserved_31_4_MASK                     0xfffffff0

/// D0F0xE4_PHY_2000
typedef union {
  struct {                                                              ///<
    UINT32                                           PllPowerDownEn:3 ; ///<
    UINT32                                        PllAutoPwrDownDis:1 ; ///<
    UINT32                                            Reserved_31_4:28; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} D0F0xE4_PHY_2000_STRUCT;


// **** D0F0xE4_PHY_2005 Register Definition ****
// Address
#define D0F0xE4_PHY_2005_ADDRESS                                0x2005

// Type
#define D0F0xE4_PHY_2005_TYPE                                   TYPE_D0F0xE4
// Field Data
#define D0F0xE4_PHY_2005_PllClkFreq_OFFSET                      0
#define D0F0xE4_PHY_2005_PllClkFreq_WIDTH                       4
#define D0F0xE4_PHY_2005_PllClkFreq_MASK                        0xf
#define D0F0xE4_PHY_2005_Reserved_8_4_OFFSET                    4
#define D0F0xE4_PHY_2005_Reserved_8_4_WIDTH                     5
#define D0F0xE4_PHY_2005_Reserved_8_4_MASK                      0x1f0
#define D0F0xE4_PHY_2005_PllClkFreqExt_OFFSET                   9
#define D0F0xE4_PHY_2005_PllClkFreqExt_WIDTH                    2
#define D0F0xE4_PHY_2005_PllClkFreqExt_MASK                     0x600
#define D0F0xE4_PHY_2005_Reserved_12_11_OFFSET                  11
#define D0F0xE4_PHY_2005_Reserved_12_11_WIDTH                   2
#define D0F0xE4_PHY_2005_Reserved_12_11_MASK                    0x1800
#define D0F0xE4_PHY_2005_PllMode_OFFSET                         13
#define D0F0xE4_PHY_2005_PllMode_WIDTH                          2
#define D0F0xE4_PHY_2005_PllMode_MASK                           0x6000
#define D0F0xE4_PHY_2005_Reserved_31_15_OFFSET                  15
#define D0F0xE4_PHY_2005_Reserved_31_15_WIDTH                   17
#define D0F0xE4_PHY_2005_Reserved_31_15_MASK                    0xffff8000

/// D0F0xE4_PHY_2005
typedef union {
  struct {                                                              ///<
    UINT32                                               PllClkFreq:4 ; ///<
    UINT32                                             Reserved_8_4:5 ; ///<
    UINT32                                            PllClkFreqExt:2 ; ///<
    UINT32                                           Reserved_12_11:2 ; ///<
    UINT32                                                  PllMode:2 ; ///<
    UINT32                                           Reserved_31_15:17; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} D0F0xE4_PHY_2005_STRUCT;

// **** D0F0xE4_PHY_2008 Register Definition ****
// Address
#define D0F0xE4_PHY_2008_ADDRESS                                0x2008

// Type
#define D0F0xE4_PHY_2008_TYPE                                   TYPE_D0F0xE4
// Field Data
#define D0F0xE4_PHY_2008_PllControlUpdate_OFFSET                0
#define D0F0xE4_PHY_2008_PllControlUpdate_WIDTH                 1
#define D0F0xE4_PHY_2008_PllControlUpdate_MASK                  0x1
#define D0F0xE4_PHY_2008_Reserved_22_1_OFFSET                   1
#define D0F0xE4_PHY_2008_Reserved_22_1_WIDTH                    22
#define D0F0xE4_PHY_2008_Reserved_22_1_MASK                     0x7ffffe
#define D0F0xE4_PHY_2008_MeasCycCntVal_2_0__OFFSET              23
#define D0F0xE4_PHY_2008_MeasCycCntVal_2_0__WIDTH               3
#define D0F0xE4_PHY_2008_MeasCycCntVal_2_0__MASK                0x3800000
#define D0F0xE4_PHY_2008_Reserved_28_26_OFFSET                  26
#define D0F0xE4_PHY_2008_Reserved_28_26_WIDTH                   3
#define D0F0xE4_PHY_2008_Reserved_28_26_MASK                    0x1c000000
#define D0F0xE4_PHY_2008_VdDetectEn_OFFSET                      29
#define D0F0xE4_PHY_2008_VdDetectEn_WIDTH                       1
#define D0F0xE4_PHY_2008_VdDetectEn_MASK                        0x20000000
#define D0F0xE4_PHY_2008_Reserved_31_30_OFFSET                  30
#define D0F0xE4_PHY_2008_Reserved_31_30_WIDTH                   2
#define D0F0xE4_PHY_2008_Reserved_31_30_MASK                    0xc0000000

/// D0F0xE4_PHY_2008
typedef union {
  struct {                                                              ///<
    UINT32                                         PllControlUpdate:1 ; ///<
    UINT32                                            Reserved_22_1:22; ///<
    UINT32                                       MeasCycCntVal_2_0_:3 ; ///<
    UINT32                                           Reserved_28_26:3 ; ///<
    UINT32                                               VdDetectEn:1 ; ///<
    UINT32                                           Reserved_31_30:2 ; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} D0F0xE4_PHY_2008_STRUCT;

// **** D0F0xE4_PHY_4001 Register Definition ****
// Address
#define D0F0xE4_PHY_4001_ADDRESS                                0x4001

// Type
#define D0F0xE4_PHY_4001_TYPE                                   TYPE_D0F0xE4
// Field Data
#define D0F0xE4_PHY_4001_Reserved_14_0_OFFSET                   0
#define D0F0xE4_PHY_4001_Reserved_14_0_WIDTH                    15
#define D0F0xE4_PHY_4001_Reserved_14_0_MASK                     0x7fff
#define D0F0xE4_PHY_4001_ForceDccRecalc_OFFSET                  15
#define D0F0xE4_PHY_4001_ForceDccRecalc_WIDTH                   1
#define D0F0xE4_PHY_4001_ForceDccRecalc_MASK                    0x8000
#define D0F0xE4_PHY_4001_Reserved_31_16_OFFSET                  16
#define D0F0xE4_PHY_4001_Reserved_31_16_WIDTH                   16
#define D0F0xE4_PHY_4001_Reserved_31_16_MASK                    0xffff0000

/// D0F0xE4_PHY_4001
typedef union {
  struct {                                                              ///<
    UINT32                                            Reserved_14_0:15; ///<
    UINT32                                           ForceDccRecalc:1 ; ///<
    UINT32                                           Reserved_31_16:16; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} D0F0xE4_PHY_4001_STRUCT;

// **** D0F0xE4_PHY_4002 Register Definition ****
// Address
#define D0F0xE4_PHY_4002_ADDRESS                                0x4002

// Type
#define D0F0xE4_PHY_4002_TYPE                                   TYPE_D0F0xE4
// Field Data
#define D0F0xE4_PHY_4002_Reserved_2_0_OFFSET                    0
#define D0F0xE4_PHY_4002_Reserved_2_0_WIDTH                     3
#define D0F0xE4_PHY_4002_Reserved_2_0_MASK                      0x7
#define D0F0xE4_PHY_4002_SamClkPiOffsetSign_OFFSET              3
#define D0F0xE4_PHY_4002_SamClkPiOffsetSign_WIDTH               1
#define D0F0xE4_PHY_4002_SamClkPiOffsetSign_MASK                0x8
#define D0F0xE4_PHY_4002_SamClkPiOffset_OFFSET                  4
#define D0F0xE4_PHY_4002_SamClkPiOffset_WIDTH                   3
#define D0F0xE4_PHY_4002_SamClkPiOffset_MASK                    0x70
#define D0F0xE4_PHY_4002_SamClkPiOffsetEn_OFFSET                7
#define D0F0xE4_PHY_4002_SamClkPiOffsetEn_WIDTH                 1
#define D0F0xE4_PHY_4002_SamClkPiOffsetEn_MASK                  0x80
#define D0F0xE4_PHY_4002_Reserved_13_8_OFFSET                   8
#define D0F0xE4_PHY_4002_Reserved_13_8_WIDTH                    6
#define D0F0xE4_PHY_4002_Reserved_13_8_MASK                     0x3f00
#define D0F0xE4_PHY_4002_LfcMin_OFFSET                          14
#define D0F0xE4_PHY_4002_LfcMin_WIDTH                           8
#define D0F0xE4_PHY_4002_LfcMin_MASK                            0x3fc000
#define D0F0xE4_PHY_4002_LfcMax_OFFSET                          22
#define D0F0xE4_PHY_4002_LfcMax_WIDTH                           8
#define D0F0xE4_PHY_4002_LfcMax_MASK                            0x3fc00000
#define D0F0xE4_PHY_4002_Reserved_31_30_OFFSET                  30
#define D0F0xE4_PHY_4002_Reserved_31_30_WIDTH                   2
#define D0F0xE4_PHY_4002_Reserved_31_30_MASK                    0xc0000000

/// D0F0xE4_PHY_4002
typedef union {
  struct {                                                              ///<
    UINT32                                             Reserved_2_0:3 ; ///<
    UINT32                                       SamClkPiOffsetSign:1 ; ///<
    UINT32                                           SamClkPiOffset:3 ; ///<
    UINT32                                         SamClkPiOffsetEn:1 ; ///<
    UINT32                                            Reserved_13_8:6 ; ///<
    UINT32                                                   LfcMin:8 ; ///<
    UINT32                                                   LfcMax:8 ; ///<
    UINT32                                           Reserved_31_30:2 ; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} D0F0xE4_PHY_4002_STRUCT;

// **** D0F0xE4_PHY_4005 Register Definition ****
// Address
#define D0F0xE4_PHY_4005_ADDRESS                                0x4005

// Type
#define D0F0xE4_PHY_4005_TYPE                                   TYPE_D0F0xE4
// Field Data
#define D0F0xE4_PHY_4005_Reserved_8_0_OFFSET                    0
#define D0F0xE4_PHY_4005_Reserved_8_0_WIDTH                     9
#define D0F0xE4_PHY_4005_Reserved_8_0_MASK                      0x1ff
#define D0F0xE4_PHY_4005_JitterInjHold_OFFSET                   9
#define D0F0xE4_PHY_4005_JitterInjHold_WIDTH                    1
#define D0F0xE4_PHY_4005_JitterInjHold_MASK                     0x200
#define D0F0xE4_PHY_4005_JitterInjOffCnt_OFFSET                 10
#define D0F0xE4_PHY_4005_JitterInjOffCnt_WIDTH                  6
#define D0F0xE4_PHY_4005_JitterInjOffCnt_MASK                   0xfc00
#define D0F0xE4_PHY_4005_Reserved_22_16_OFFSET                  16
#define D0F0xE4_PHY_4005_Reserved_22_16_WIDTH                   7
#define D0F0xE4_PHY_4005_Reserved_22_16_MASK                    0x7f0000
#define D0F0xE4_PHY_4005_JitterInjOnCnt_OFFSET                  23
#define D0F0xE4_PHY_4005_JitterInjOnCnt_WIDTH                   6
#define D0F0xE4_PHY_4005_JitterInjOnCnt_MASK                    0x1f800000
#define D0F0xE4_PHY_4005_JitterInjDir_OFFSET                    29
#define D0F0xE4_PHY_4005_JitterInjDir_WIDTH                     1
#define D0F0xE4_PHY_4005_JitterInjDir_MASK                      0x20000000
#define D0F0xE4_PHY_4005_JitterInjEn_OFFSET                     30
#define D0F0xE4_PHY_4005_JitterInjEn_WIDTH                      1
#define D0F0xE4_PHY_4005_JitterInjEn_MASK                       0x40000000
#define D0F0xE4_PHY_4005_Reserved_31_31_OFFSET                  31
#define D0F0xE4_PHY_4005_Reserved_31_31_WIDTH                   1
#define D0F0xE4_PHY_4005_Reserved_31_31_MASK                    0x80000000

/// D0F0xE4_PHY_4005
typedef union {
  struct {                                                              ///<
    UINT32                                             Reserved_8_0:9 ; ///<
    UINT32                                            JitterInjHold:1 ; ///<
    UINT32                                          JitterInjOffCnt:6 ; ///<
    UINT32                                           Reserved_22_16:7 ; ///<
    UINT32                                           JitterInjOnCnt:6 ; ///<
    UINT32                                             JitterInjDir:1 ; ///<
    UINT32                                              JitterInjEn:1 ; ///<
    UINT32                                           Reserved_31_31:1 ; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} D0F0xE4_PHY_4005_STRUCT;

// **** D0F0xE4_PHY_4006 Register Definition ****
// Address
#define D0F0xE4_PHY_4006_ADDRESS                                0x4006

// Type
#define D0F0xE4_PHY_4006_TYPE                                   TYPE_D0F0xE4
// Field Data
#define D0F0xE4_PHY_4006_Reserved_4_0_OFFSET                    0
#define D0F0xE4_PHY_4006_Reserved_4_0_WIDTH                     5
#define D0F0xE4_PHY_4006_Reserved_4_0_MASK                      0x1f
#define D0F0xE4_PHY_4006_DfeVoltage_OFFSET                      5
#define D0F0xE4_PHY_4006_DfeVoltage_WIDTH                       2
#define D0F0xE4_PHY_4006_DfeVoltage_MASK                        0x60
#define D0F0xE4_PHY_4006_DfeEn_OFFSET                           7
#define D0F0xE4_PHY_4006_DfeEn_WIDTH                            1
#define D0F0xE4_PHY_4006_DfeEn_MASK                             0x80
#define D0F0xE4_PHY_4006_Reserved_31_8_OFFSET                   8
#define D0F0xE4_PHY_4006_Reserved_31_8_WIDTH                    24
#define D0F0xE4_PHY_4006_Reserved_31_8_MASK                     0xffffff00

/// D0F0xE4_PHY_4006
typedef union {
  struct {                                                              ///<
    UINT32                                             Reserved_4_0:5 ; ///<
    UINT32                                               DfeVoltage:2 ; ///<
    UINT32                                                    DfeEn:1 ; ///<
    UINT32                                            Reserved_31_8:24; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} D0F0xE4_PHY_4006_STRUCT;

// **** D0F0xE4_PHY_400A Register Definition ****
// Address
#define D0F0xE4_PHY_400A_ADDRESS                                0x400a

// Type
#define D0F0xE4_PHY_400A_TYPE                                   TYPE_D0F0xE4
// Field Data
#define D0F0xE4_PHY_400A_EnCoreLoopFirst_OFFSET                 0
#define D0F0xE4_PHY_400A_EnCoreLoopFirst_WIDTH                  1
#define D0F0xE4_PHY_400A_EnCoreLoopFirst_MASK                   0x1
#define D0F0xE4_PHY_400A_Reserved_3_1_OFFSET                    1
#define D0F0xE4_PHY_400A_Reserved_3_1_WIDTH                     3
#define D0F0xE4_PHY_400A_Reserved_3_1_MASK                      0xe
#define D0F0xE4_PHY_400A_LockDetOnLs2Exit_OFFSET                4
#define D0F0xE4_PHY_400A_LockDetOnLs2Exit_WIDTH                 1
#define D0F0xE4_PHY_400A_LockDetOnLs2Exit_MASK                  0x10
#define D0F0xE4_PHY_400A_Reserved_6_5_OFFSET                    5
#define D0F0xE4_PHY_400A_Reserved_6_5_WIDTH                     2
#define D0F0xE4_PHY_400A_Reserved_6_5_MASK                      0x60
#define D0F0xE4_PHY_400A_BiasDisInLs2_OFFSET                    7
#define D0F0xE4_PHY_400A_BiasDisInLs2_WIDTH                     1
#define D0F0xE4_PHY_400A_BiasDisInLs2_MASK                      0x80
#define D0F0xE4_PHY_400A_Reserved_12_8_OFFSET                   8
#define D0F0xE4_PHY_400A_Reserved_12_8_WIDTH                    5
#define D0F0xE4_PHY_400A_Reserved_12_8_MASK                     0x1f00
#define D0F0xE4_PHY_400A_AnalogWaitTime_OFFSET                  13
#define D0F0xE4_PHY_400A_AnalogWaitTime_WIDTH                   2
#define D0F0xE4_PHY_400A_AnalogWaitTime_MASK                    0x6000
#define D0F0xE4_PHY_400A_Reserved_16_15_OFFSET                  15
#define D0F0xE4_PHY_400A_Reserved_16_15_WIDTH                   2
#define D0F0xE4_PHY_400A_Reserved_16_15_MASK                    0x18000
#define D0F0xE4_PHY_400A_DllLockFastModeEn_OFFSET               17
#define D0F0xE4_PHY_400A_DllLockFastModeEn_WIDTH                1
#define D0F0xE4_PHY_400A_DllLockFastModeEn_MASK                 0x20000
#define D0F0xE4_PHY_400A_Reserved_28_18_OFFSET                  18
#define D0F0xE4_PHY_400A_Reserved_28_18_WIDTH                   11
#define D0F0xE4_PHY_400A_Reserved_28_18_MASK                    0x1ffc0000
#define D0F0xE4_PHY_400A_Ls2ExitTime_OFFSET                     29
#define D0F0xE4_PHY_400A_Ls2ExitTime_WIDTH                      3
#define D0F0xE4_PHY_400A_Ls2ExitTime_MASK                       0xe0000000

/// D0F0xE4_PHY_400A
typedef union {
  struct {                                                              ///<
    UINT32                                          EnCoreLoopFirst:1 ; ///<
    UINT32                                             Reserved_3_1:3 ; ///<
    UINT32                                         LockDetOnLs2Exit:1 ; ///<
    UINT32                                             Reserved_6_5:2 ; ///<
    UINT32                                             BiasDisInLs2:1 ; ///<
    UINT32                                            Reserved_12_8:5 ; ///<
    UINT32                                           AnalogWaitTime:2 ; ///<
    UINT32                                           Reserved_16_15:2 ; ///<
    UINT32                                        DllLockFastModeEn:1 ; ///<
    UINT32                                           Reserved_28_18:11; ///<
    UINT32                                              Ls2ExitTime:3 ; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} D0F0xE4_PHY_400A_STRUCT;

// **** D0F0xE4_PHY_6005 Register Definition ****
// Address
#define D0F0xE4_PHY_6005_ADDRESS                                0x6005

// Type
#define D0F0xE4_PHY_6005_TYPE                                   TYPE_D0F0xE4
// Field Data
#define D0F0xE4_PHY_6005_Reserved_28_0_OFFSET                   0
#define D0F0xE4_PHY_6005_Reserved_28_0_WIDTH                    29
#define D0F0xE4_PHY_6005_Reserved_28_0_MASK                     0x1fffffff
#define D0F0xE4_PHY_6005_IsOwnMstr_OFFSET                       29
#define D0F0xE4_PHY_6005_IsOwnMstr_WIDTH                        1
#define D0F0xE4_PHY_6005_IsOwnMstr_MASK                         0x20000000
#define D0F0xE4_PHY_6005_Reserved_30_30_OFFSET                  30
#define D0F0xE4_PHY_6005_Reserved_30_30_WIDTH                   1
#define D0F0xE4_PHY_6005_Reserved_30_30_MASK                    0x40000000
#define D0F0xE4_PHY_6005_GangedModeEn_OFFSET                    31
#define D0F0xE4_PHY_6005_GangedModeEn_WIDTH                     1
#define D0F0xE4_PHY_6005_GangedModeEn_MASK                      0x80000000

/// D0F0xE4_PHY_6005
typedef union {
  struct {                                                              ///<
    UINT32                                            Reserved_28_0:29; ///<
    UINT32                                                IsOwnMstr:1 ; ///<
    UINT32                                           Reserved_30_30:1 ; ///<
    UINT32                                             GangedModeEn:1 ; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} D0F0xE4_PHY_6005_STRUCT;

// **** D18F2x09C_x0000_0000 Register Definition ****
// Address
#define D18F2x09C_x0000_0000_ADDRESS                            0x0

// Type
#define D18F2x09C_x0000_0000_TYPE                               TYPE_D18F2x09C
// Field Data
#define D18F2x09C_x0000_0000_CkeDrvStren_OFFSET                 0
#define D18F2x09C_x0000_0000_CkeDrvStren_WIDTH                  3
#define D18F2x09C_x0000_0000_CkeDrvStren_MASK                   0x7
#define D18F2x09C_x0000_0000_Reserved_3_3_OFFSET                3
#define D18F2x09C_x0000_0000_Reserved_3_3_WIDTH                 1
#define D18F2x09C_x0000_0000_Reserved_3_3_MASK                  0x8
#define D18F2x09C_x0000_0000_CsOdtDrvStren_OFFSET               4
#define D18F2x09C_x0000_0000_CsOdtDrvStren_WIDTH                3
#define D18F2x09C_x0000_0000_CsOdtDrvStren_MASK                 0x70
#define D18F2x09C_x0000_0000_Reserved_7_7_OFFSET                7
#define D18F2x09C_x0000_0000_Reserved_7_7_WIDTH                 1
#define D18F2x09C_x0000_0000_Reserved_7_7_MASK                  0x80
#define D18F2x09C_x0000_0000_AddrCmdDrvStren_OFFSET             8
#define D18F2x09C_x0000_0000_AddrCmdDrvStren_WIDTH              3
#define D18F2x09C_x0000_0000_AddrCmdDrvStren_MASK               0x700
#define D18F2x09C_x0000_0000_Reserved_11_11_OFFSET              11
#define D18F2x09C_x0000_0000_Reserved_11_11_WIDTH               1
#define D18F2x09C_x0000_0000_Reserved_11_11_MASK                0x800
#define D18F2x09C_x0000_0000_ClkDrvStren_OFFSET                 12
#define D18F2x09C_x0000_0000_ClkDrvStren_WIDTH                  3
#define D18F2x09C_x0000_0000_ClkDrvStren_MASK                   0x7000
#define D18F2x09C_x0000_0000_Reserved_15_15_OFFSET              15
#define D18F2x09C_x0000_0000_Reserved_15_15_WIDTH               1
#define D18F2x09C_x0000_0000_Reserved_15_15_MASK                0x8000
#define D18F2x09C_x0000_0000_DataDrvStren_OFFSET                16
#define D18F2x09C_x0000_0000_DataDrvStren_WIDTH                 3
#define D18F2x09C_x0000_0000_DataDrvStren_MASK                  0x70000
#define D18F2x09C_x0000_0000_Reserved_19_19_OFFSET              19
#define D18F2x09C_x0000_0000_Reserved_19_19_WIDTH               1
#define D18F2x09C_x0000_0000_Reserved_19_19_MASK                0x80000
#define D18F2x09C_x0000_0000_DqsDrvStren_OFFSET                 20
#define D18F2x09C_x0000_0000_DqsDrvStren_WIDTH                  3
#define D18F2x09C_x0000_0000_DqsDrvStren_MASK                   0x700000
#define D18F2x09C_x0000_0000_Reserved_27_23_OFFSET              23
#define D18F2x09C_x0000_0000_Reserved_27_23_WIDTH               5
#define D18F2x09C_x0000_0000_Reserved_27_23_MASK                0xf800000
#define D18F2x09C_x0000_0000_ProcOdt_OFFSET                     28
#define D18F2x09C_x0000_0000_ProcOdt_WIDTH                      3
#define D18F2x09C_x0000_0000_ProcOdt_MASK                       0x70000000
#define D18F2x09C_x0000_0000_Reserved_31_31_OFFSET              31
#define D18F2x09C_x0000_0000_Reserved_31_31_WIDTH               1
#define D18F2x09C_x0000_0000_Reserved_31_31_MASK                0x80000000

/// D18F2x09C_x0000_0000
typedef union {
  struct {                                                              ///<
    UINT32                                              CkeDrvStren:3 ; ///<
    UINT32                                             Reserved_3_3:1 ; ///<
    UINT32                                            CsOdtDrvStren:3 ; ///<
    UINT32                                             Reserved_7_7:1 ; ///<
    UINT32                                          AddrCmdDrvStren:3 ; ///<
    UINT32                                           Reserved_11_11:1 ; ///<
    UINT32                                              ClkDrvStren:3 ; ///<
    UINT32                                           Reserved_15_15:1 ; ///<
    UINT32                                             DataDrvStren:3 ; ///<
    UINT32                                           Reserved_19_19:1 ; ///<
    UINT32                                              DqsDrvStren:3 ; ///<
    UINT32                                           Reserved_27_23:5 ; ///<
    UINT32                                                  ProcOdt:3 ; ///<
    UINT32                                           Reserved_31_31:1 ; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} D18F2x09C_x0000_0000_STRUCT;

// **** D18F2x09C_x0000_0001 Register Definition ****
// Address
#define D18F2x09C_x0000_0001_ADDRESS                            0x1

// Type
#define D18F2x09C_x0000_0001_TYPE                               TYPE_D18F2x09C
// Field Data
#define D18F2x09C_x0000_0001_WrDatFineDly_Byte0_OFFSET          0
#define D18F2x09C_x0000_0001_WrDatFineDly_Byte0_WIDTH           5
#define D18F2x09C_x0000_0001_WrDatFineDly_Byte0_MASK            0x1f
#define D18F2x09C_x0000_0001_WrDatGrossDly_Byte0_OFFSET         5
#define D18F2x09C_x0000_0001_WrDatGrossDly_Byte0_WIDTH          3
#define D18F2x09C_x0000_0001_WrDatGrossDly_Byte0_MASK           0xe0
#define D18F2x09C_x0000_0001_WrDatFineDly_Byte1_OFFSET          8
#define D18F2x09C_x0000_0001_WrDatFineDly_Byte1_WIDTH           5
#define D18F2x09C_x0000_0001_WrDatFineDly_Byte1_MASK            0x1f00
#define D18F2x09C_x0000_0001_WrDatGrossDly_Byte1_OFFSET         13
#define D18F2x09C_x0000_0001_WrDatGrossDly_Byte1_WIDTH          3
#define D18F2x09C_x0000_0001_WrDatGrossDly_Byte1_MASK           0xe000
#define D18F2x09C_x0000_0001_WrDatFineDly_Byte2_OFFSET          16
#define D18F2x09C_x0000_0001_WrDatFineDly_Byte2_WIDTH           5
#define D18F2x09C_x0000_0001_WrDatFineDly_Byte2_MASK            0x1f0000
#define D18F2x09C_x0000_0001_WrDatGrossDly_Byte2_OFFSET         21
#define D18F2x09C_x0000_0001_WrDatGrossDly_Byte2_WIDTH          3
#define D18F2x09C_x0000_0001_WrDatGrossDly_Byte2_MASK           0xe00000
#define D18F2x09C_x0000_0001_WrDatFineDly_Byte3_OFFSET          24
#define D18F2x09C_x0000_0001_WrDatFineDly_Byte3_WIDTH           5
#define D18F2x09C_x0000_0001_WrDatFineDly_Byte3_MASK            0x1f000000
#define D18F2x09C_x0000_0001_WrDatGrossDly_Byte3_OFFSET         29
#define D18F2x09C_x0000_0001_WrDatGrossDly_Byte3_WIDTH          3
#define D18F2x09C_x0000_0001_WrDatGrossDly_Byte3_MASK           0xe0000000

/// D18F2x09C_x0000_0001
typedef union {
  struct {                                                              ///<
    UINT32                                       WrDatFineDly_Byte0:5 ; ///<
    UINT32                                      WrDatGrossDly_Byte0:3 ; ///<
    UINT32                                       WrDatFineDly_Byte1:5 ; ///<
    UINT32                                      WrDatGrossDly_Byte1:3 ; ///<
    UINT32                                       WrDatFineDly_Byte2:5 ; ///<
    UINT32                                      WrDatGrossDly_Byte2:3 ; ///<
    UINT32                                       WrDatFineDly_Byte3:5 ; ///<
    UINT32                                      WrDatGrossDly_Byte3:3 ; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} D18F2x09C_x0000_0001_STRUCT;

// **** D18F2x09C_x0000_0002 Register Definition ****
// Address
#define D18F2x09C_x0000_0002_ADDRESS                            0x2

// Type
#define D18F2x09C_x0000_0002_TYPE                               TYPE_D18F2x09C
// Field Data
#define D18F2x09C_x0000_0002_WrDatFineDly_Byte4_OFFSET          0
#define D18F2x09C_x0000_0002_WrDatFineDly_Byte4_WIDTH           5
#define D18F2x09C_x0000_0002_WrDatFineDly_Byte4_MASK            0x1f
#define D18F2x09C_x0000_0002_WrDatGrossDly_Byte4_OFFSET         5
#define D18F2x09C_x0000_0002_WrDatGrossDly_Byte4_WIDTH          3
#define D18F2x09C_x0000_0002_WrDatGrossDly_Byte4_MASK           0xe0
#define D18F2x09C_x0000_0002_WrDatFineDly_Byte5_OFFSET          8
#define D18F2x09C_x0000_0002_WrDatFineDly_Byte5_WIDTH           5
#define D18F2x09C_x0000_0002_WrDatFineDly_Byte5_MASK            0x1f00
#define D18F2x09C_x0000_0002_WrDatGrossDly_Byte5_OFFSET         13
#define D18F2x09C_x0000_0002_WrDatGrossDly_Byte5_WIDTH          3
#define D18F2x09C_x0000_0002_WrDatGrossDly_Byte5_MASK           0xe000
#define D18F2x09C_x0000_0002_WrDatFineDly_Byte6_OFFSET          16
#define D18F2x09C_x0000_0002_WrDatFineDly_Byte6_WIDTH           5
#define D18F2x09C_x0000_0002_WrDatFineDly_Byte6_MASK            0x1f0000
#define D18F2x09C_x0000_0002_WrDatGrossDly_Byte6_OFFSET         21
#define D18F2x09C_x0000_0002_WrDatGrossDly_Byte6_WIDTH          3
#define D18F2x09C_x0000_0002_WrDatGrossDly_Byte6_MASK           0xe00000
#define D18F2x09C_x0000_0002_WrDatFineDly_Byte7_OFFSET          24
#define D18F2x09C_x0000_0002_WrDatFineDly_Byte7_WIDTH           5
#define D18F2x09C_x0000_0002_WrDatFineDly_Byte7_MASK            0x1f000000
#define D18F2x09C_x0000_0002_WrDatGrossDly_Byte7_OFFSET         29
#define D18F2x09C_x0000_0002_WrDatGrossDly_Byte7_WIDTH          3
#define D18F2x09C_x0000_0002_WrDatGrossDly_Byte7_MASK           0xe0000000

/// D18F2x09C_x0000_0002
typedef union {
  struct {                                                              ///<
    UINT32                                       WrDatFineDly_Byte4:5 ; ///<
    UINT32                                      WrDatGrossDly_Byte4:3 ; ///<
    UINT32                                       WrDatFineDly_Byte5:5 ; ///<
    UINT32                                      WrDatGrossDly_Byte5:3 ; ///<
    UINT32                                       WrDatFineDly_Byte6:5 ; ///<
    UINT32                                      WrDatGrossDly_Byte6:3 ; ///<
    UINT32                                       WrDatFineDly_Byte7:5 ; ///<
    UINT32                                      WrDatGrossDly_Byte7:3 ; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} D18F2x09C_x0000_0002_STRUCT;

// **** D18F2x09C_x0000_0004 Register Definition ****
// Address
#define D18F2x09C_x0000_0004_ADDRESS                            0x4

// Type
#define D18F2x09C_x0000_0004_TYPE                               TYPE_D18F2x09C
// Field Data
#define D18F2x09C_x0000_0004_CkeFineDelay_OFFSET                0
#define D18F2x09C_x0000_0004_CkeFineDelay_WIDTH                 5
#define D18F2x09C_x0000_0004_CkeFineDelay_MASK                  0x1f
#define D18F2x09C_x0000_0004_CkeSetup_OFFSET                    5
#define D18F2x09C_x0000_0004_CkeSetup_WIDTH                     1
#define D18F2x09C_x0000_0004_CkeSetup_MASK                      0x20
#define D18F2x09C_x0000_0004_Reserved_7_6_OFFSET                6
#define D18F2x09C_x0000_0004_Reserved_7_6_WIDTH                 2
#define D18F2x09C_x0000_0004_Reserved_7_6_MASK                  0xc0
#define D18F2x09C_x0000_0004_CsOdtFineDelay_OFFSET              8
#define D18F2x09C_x0000_0004_CsOdtFineDelay_WIDTH               5
#define D18F2x09C_x0000_0004_CsOdtFineDelay_MASK                0x1f00
#define D18F2x09C_x0000_0004_CsOdtSetup_OFFSET                  13
#define D18F2x09C_x0000_0004_CsOdtSetup_WIDTH                   1
#define D18F2x09C_x0000_0004_CsOdtSetup_MASK                    0x2000
#define D18F2x09C_x0000_0004_Reserved_15_14_OFFSET              14
#define D18F2x09C_x0000_0004_Reserved_15_14_WIDTH               2
#define D18F2x09C_x0000_0004_Reserved_15_14_MASK                0xc000
#define D18F2x09C_x0000_0004_AddrCmdFineDelay_OFFSET            16
#define D18F2x09C_x0000_0004_AddrCmdFineDelay_WIDTH             5
#define D18F2x09C_x0000_0004_AddrCmdFineDelay_MASK              0x1f0000
#define D18F2x09C_x0000_0004_AddrCmdSetup_OFFSET                21
#define D18F2x09C_x0000_0004_AddrCmdSetup_WIDTH                 1
#define D18F2x09C_x0000_0004_AddrCmdSetup_MASK                  0x200000
#define D18F2x09C_x0000_0004_Reserved_31_22_OFFSET              22
#define D18F2x09C_x0000_0004_Reserved_31_22_WIDTH               10
#define D18F2x09C_x0000_0004_Reserved_31_22_MASK                0xffc00000

/// D18F2x09C_x0000_0004
typedef union {
  struct {                                                              ///<
    UINT32                                             CkeFineDelay:5 ; ///<
    UINT32                                                 CkeSetup:1 ; ///<
    UINT32                                             Reserved_7_6:2 ; ///<
    UINT32                                           CsOdtFineDelay:5 ; ///<
    UINT32                                               CsOdtSetup:1 ; ///<
    UINT32                                           Reserved_15_14:2 ; ///<
    UINT32                                         AddrCmdFineDelay:5 ; ///<
    UINT32                                             AddrCmdSetup:1 ; ///<
    UINT32                                           Reserved_31_22:10; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} D18F2x09C_x0000_0004_STRUCT;

// **** D18F2x09C_x0000_0005 Register Definition ****
// Address
#define D18F2x09C_x0000_0005_ADDRESS                            0x5

// Type
#define D18F2x09C_x0000_0005_TYPE                               TYPE_D18F2x09C
// Field Data
#define D18F2x09C_x0000_0005_Reserved_0_0_OFFSET                0
#define D18F2x09C_x0000_0005_Reserved_0_0_WIDTH                 1
#define D18F2x09C_x0000_0005_Reserved_0_0_MASK                  0x1
#define D18F2x09C_x0000_0005_RdDqsTime_Byte0_OFFSET             1
#define D18F2x09C_x0000_0005_RdDqsTime_Byte0_WIDTH              5
#define D18F2x09C_x0000_0005_RdDqsTime_Byte0_MASK               0x3e
#define D18F2x09C_x0000_0005_Reserved_8_6_OFFSET                6
#define D18F2x09C_x0000_0005_Reserved_8_6_WIDTH                 3
#define D18F2x09C_x0000_0005_Reserved_8_6_MASK                  0x1c0
#define D18F2x09C_x0000_0005_RdDqsTime_Byte1_OFFSET             9
#define D18F2x09C_x0000_0005_RdDqsTime_Byte1_WIDTH              5
#define D18F2x09C_x0000_0005_RdDqsTime_Byte1_MASK               0x3e00
#define D18F2x09C_x0000_0005_Reserved_16_14_OFFSET              14
#define D18F2x09C_x0000_0005_Reserved_16_14_WIDTH               3
#define D18F2x09C_x0000_0005_Reserved_16_14_MASK                0x1c000
#define D18F2x09C_x0000_0005_RdDqsTime_Byte2_OFFSET             17
#define D18F2x09C_x0000_0005_RdDqsTime_Byte2_WIDTH              5
#define D18F2x09C_x0000_0005_RdDqsTime_Byte2_MASK               0x3e0000
#define D18F2x09C_x0000_0005_Reserved_24_22_OFFSET              22
#define D18F2x09C_x0000_0005_Reserved_24_22_WIDTH               3
#define D18F2x09C_x0000_0005_Reserved_24_22_MASK                0x1c00000
#define D18F2x09C_x0000_0005_RdDqsTime_Byte3_OFFSET             25
#define D18F2x09C_x0000_0005_RdDqsTime_Byte3_WIDTH              5
#define D18F2x09C_x0000_0005_RdDqsTime_Byte3_MASK               0x3e000000
#define D18F2x09C_x0000_0005_Reserved_31_30_OFFSET              30
#define D18F2x09C_x0000_0005_Reserved_31_30_WIDTH               2
#define D18F2x09C_x0000_0005_Reserved_31_30_MASK                0xc0000000

/// D18F2x09C_x0000_0005
typedef union {
  struct {                                                              ///<
    UINT32                                             Reserved_0_0:1 ; ///<
    UINT32                                          RdDqsTime_Byte0:5 ; ///<
    UINT32                                             Reserved_8_6:3 ; ///<
    UINT32                                          RdDqsTime_Byte1:5 ; ///<
    UINT32                                           Reserved_16_14:3 ; ///<
    UINT32                                          RdDqsTime_Byte2:5 ; ///<
    UINT32                                           Reserved_24_22:3 ; ///<
    UINT32                                          RdDqsTime_Byte3:5 ; ///<
    UINT32                                           Reserved_31_30:2 ; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} D18F2x09C_x0000_0005_STRUCT;

// **** D18F2x09C_x0000_0006 Register Definition ****
// Address
#define D18F2x09C_x0000_0006_ADDRESS                            0x6

// Type
#define D18F2x09C_x0000_0006_TYPE                               TYPE_D18F2x09C
// Field Data
#define D18F2x09C_x0000_0006_Reserved_0_0_OFFSET                0
#define D18F2x09C_x0000_0006_Reserved_0_0_WIDTH                 1
#define D18F2x09C_x0000_0006_Reserved_0_0_MASK                  0x1
#define D18F2x09C_x0000_0006_RdDqsTime_Byte4_OFFSET             1
#define D18F2x09C_x0000_0006_RdDqsTime_Byte4_WIDTH              5
#define D18F2x09C_x0000_0006_RdDqsTime_Byte4_MASK               0x3e
#define D18F2x09C_x0000_0006_Reserved_8_6_OFFSET                6
#define D18F2x09C_x0000_0006_Reserved_8_6_WIDTH                 3
#define D18F2x09C_x0000_0006_Reserved_8_6_MASK                  0x1c0
#define D18F2x09C_x0000_0006_RdDqsTime_Byte5_OFFSET             9
#define D18F2x09C_x0000_0006_RdDqsTime_Byte5_WIDTH              5
#define D18F2x09C_x0000_0006_RdDqsTime_Byte5_MASK               0x3e00
#define D18F2x09C_x0000_0006_Reserved_16_14_OFFSET              14
#define D18F2x09C_x0000_0006_Reserved_16_14_WIDTH               3
#define D18F2x09C_x0000_0006_Reserved_16_14_MASK                0x1c000
#define D18F2x09C_x0000_0006_RdDqsTime_Byte6_OFFSET             17
#define D18F2x09C_x0000_0006_RdDqsTime_Byte6_WIDTH              5
#define D18F2x09C_x0000_0006_RdDqsTime_Byte6_MASK               0x3e0000
#define D18F2x09C_x0000_0006_Reserved_24_22_OFFSET              22
#define D18F2x09C_x0000_0006_Reserved_24_22_WIDTH               3
#define D18F2x09C_x0000_0006_Reserved_24_22_MASK                0x1c00000
#define D18F2x09C_x0000_0006_RdDqsTime_Byte7_OFFSET             25
#define D18F2x09C_x0000_0006_RdDqsTime_Byte7_WIDTH              5
#define D18F2x09C_x0000_0006_RdDqsTime_Byte7_MASK               0x3e000000
#define D18F2x09C_x0000_0006_Reserved_31_30_OFFSET              30
#define D18F2x09C_x0000_0006_Reserved_31_30_WIDTH               2
#define D18F2x09C_x0000_0006_Reserved_31_30_MASK                0xc0000000

/// D18F2x09C_x0000_0006
typedef union {
  struct {                                                              ///<
    UINT32                                             Reserved_0_0:1 ; ///<
    UINT32                                          RdDqsTime_Byte4:5 ; ///<
    UINT32                                             Reserved_8_6:3 ; ///<
    UINT32                                          RdDqsTime_Byte5:5 ; ///<
    UINT32                                           Reserved_16_14:3 ; ///<
    UINT32                                          RdDqsTime_Byte6:5 ; ///<
    UINT32                                           Reserved_24_22:3 ; ///<
    UINT32                                          RdDqsTime_Byte7:5 ; ///<
    UINT32                                           Reserved_31_30:2 ; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} D18F2x09C_x0000_0006_STRUCT;

// **** D18F2x09C_x0000_0008 Register Definition ****
// Address
#define D18F2x09C_x0000_0008_ADDRESS                            0x8

// Type
#define D18F2x09C_x0000_0008_TYPE                               TYPE_D18F2x09C
// Field Data
#define D18F2x09C_x0000_0008_WrtLvTrEn_OFFSET                   0
#define D18F2x09C_x0000_0008_WrtLvTrEn_WIDTH                    1
#define D18F2x09C_x0000_0008_WrtLvTrEn_MASK                     0x1
#define D18F2x09C_x0000_0008_Reserved_1_1_OFFSET                1
#define D18F2x09C_x0000_0008_Reserved_1_1_WIDTH                 1
#define D18F2x09C_x0000_0008_Reserved_1_1_MASK                  0x2
#define D18F2x09C_x0000_0008_Reserved_2_2_OFFSET                2
#define D18F2x09C_x0000_0008_Reserved_2_2_WIDTH                 1
#define D18F2x09C_x0000_0008_Reserved_2_2_MASK                  0x4
#define D18F2x09C_x0000_0008_PhyFenceTrEn_OFFSET                3
#define D18F2x09C_x0000_0008_PhyFenceTrEn_WIDTH                 1
#define D18F2x09C_x0000_0008_PhyFenceTrEn_MASK                  0x8
#define D18F2x09C_x0000_0008_TrDimmSel_OFFSET                   4
#define D18F2x09C_x0000_0008_TrDimmSel_WIDTH                    1
#define D18F2x09C_x0000_0008_TrDimmSel_MASK                     0x10
#define D18F2x09C_x0000_0008_Reserved_5_5_OFFSET                5
#define D18F2x09C_x0000_0008_Reserved_5_5_WIDTH                 1
#define D18F2x09C_x0000_0008_Reserved_5_5_MASK                  0x20
#define D18F2x09C_x0000_0008_FenceTrSel_OFFSET                  6
#define D18F2x09C_x0000_0008_FenceTrSel_WIDTH                   2
#define D18F2x09C_x0000_0008_FenceTrSel_MASK                    0xc0
#define D18F2x09C_x0000_0008_WrLvOdt_OFFSET                     8
#define D18F2x09C_x0000_0008_WrLvOdt_WIDTH                      4
#define D18F2x09C_x0000_0008_WrLvOdt_MASK                       0xf00
#define D18F2x09C_x0000_0008_WrLvOdtEn_OFFSET                   12
#define D18F2x09C_x0000_0008_WrLvOdtEn_WIDTH                    1
#define D18F2x09C_x0000_0008_WrLvOdtEn_MASK                     0x1000
#define D18F2x09C_x0000_0008_DqsRcvTrEn_OFFSET                  13
#define D18F2x09C_x0000_0008_DqsRcvTrEn_WIDTH                   1
#define D18F2x09C_x0000_0008_DqsRcvTrEn_MASK                    0x2000
#define D18F2x09C_x0000_0008_Reserved_14_14_OFFSET              14
#define D18F2x09C_x0000_0008_Reserved_14_14_WIDTH               1
#define D18F2x09C_x0000_0008_Reserved_14_14_MASK                0x4000
#define D18F2x09C_x0000_0008_PllMult_OFFSET                     15
#define D18F2x09C_x0000_0008_PllMult_WIDTH                      7
#define D18F2x09C_x0000_0008_PllMult_MASK                       0x3f8000
#define D18F2x09C_x0000_0008_Reserved_23_22_OFFSET              22
#define D18F2x09C_x0000_0008_Reserved_23_22_WIDTH               2
#define D18F2x09C_x0000_0008_Reserved_23_22_MASK                0xc00000
#define D18F2x09C_x0000_0008_PllDiv_OFFSET                      24
#define D18F2x09C_x0000_0008_PllDiv_WIDTH                       4
#define D18F2x09C_x0000_0008_PllDiv_MASK                        0xf000000
#define D18F2x09C_x0000_0008_Reserved_31_28_OFFSET              28
#define D18F2x09C_x0000_0008_Reserved_31_28_WIDTH               4
#define D18F2x09C_x0000_0008_Reserved_31_28_MASK                0xf0000000

/// D18F2x09C_x0000_0008
typedef union {
  struct {                                                              ///<
    UINT32                                                WrtLvTrEn:1 ; ///<
    UINT32                                             Reserved_1_1:1 ; ///<
    UINT32                                             Reserved_2_2:1 ; ///<
    UINT32                                             PhyFenceTrEn:1 ; ///<
    UINT32                                                TrDimmSel:1 ; ///<
    UINT32                                             Reserved_5_5:1 ; ///<
    UINT32                                               FenceTrSel:2 ; ///<
    UINT32                                                  WrLvOdt:4 ; ///<
    UINT32                                                WrLvOdtEn:1 ; ///<
    UINT32                                               DqsRcvTrEn:1 ; ///<
    UINT32                                           Reserved_14_14:1 ; ///<
    UINT32                                                  PllMult:7 ; ///<
    UINT32                                           Reserved_23_22:2 ; ///<
    UINT32                                                   PllDiv:4 ; ///<
    UINT32                                           Reserved_31_28:4 ; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} D18F2x09C_x0000_0008_STRUCT;

// **** D18F2x09C_x0000_000B Register Definition ****
// Address
#define D18F2x09C_x0000_000B_ADDRESS                            0xb

// Type
#define D18F2x09C_x0000_000B_TYPE                               TYPE_D18F2x09C
// Field Data
#define D18F2x09C_x0000_000B_Reserved_22_0_OFFSET               0
#define D18F2x09C_x0000_000B_Reserved_22_0_WIDTH                23
#define D18F2x09C_x0000_000B_Reserved_22_0_MASK                 0x7fffff
#define D18F2x09C_x0000_000B_PhySelfRefreshMode_OFFSET          23
#define D18F2x09C_x0000_000B_PhySelfRefreshMode_WIDTH           1
#define D18F2x09C_x0000_000B_PhySelfRefreshMode_MASK            0x800000
#define D18F2x09C_x0000_000B_Reserved_30_24_OFFSET              24
#define D18F2x09C_x0000_000B_Reserved_30_24_WIDTH               7
#define D18F2x09C_x0000_000B_Reserved_30_24_MASK                0x7f000000
#define D18F2x09C_x0000_000B_DynModeChange_OFFSET               31
#define D18F2x09C_x0000_000B_DynModeChange_WIDTH                1
#define D18F2x09C_x0000_000B_DynModeChange_MASK                 0x80000000

/// D18F2x09C_x0000_000B
typedef union {
  struct {                                                              ///<
    UINT32                                            Reserved_22_0:23; ///<
    UINT32                                       PhySelfRefreshMode:1 ; ///<
    UINT32                                           Reserved_30_24:7 ; ///<
    UINT32                                            DynModeChange:1 ; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} D18F2x09C_x0000_000B_STRUCT;

// **** D18F2x09C_x0000_000C Register Definition ****
// Address
#define D18F2x09C_x0000_000C_ADDRESS                            0xc

// Type
#define D18F2x09C_x0000_000C_TYPE                               TYPE_D18F2x09C
// Field Data
#define D18F2x09C_x0000_000C_ChipSelTri_OFFSET                  0
#define D18F2x09C_x0000_000C_ChipSelTri_WIDTH                   8
#define D18F2x09C_x0000_000C_ChipSelTri_MASK                    0xff
#define D18F2x09C_x0000_000C_ODTTri_OFFSET                      8
#define D18F2x09C_x0000_000C_ODTTri_WIDTH                       4
#define D18F2x09C_x0000_000C_ODTTri_MASK                        0xf00
#define D18F2x09C_x0000_000C_CKETri_OFFSET                      12
#define D18F2x09C_x0000_000C_CKETri_WIDTH                       2
#define D18F2x09C_x0000_000C_CKETri_MASK                        0x3000
#define D18F2x09C_x0000_000C_Reserved_15_14_OFFSET              14
#define D18F2x09C_x0000_000C_Reserved_15_14_WIDTH               2
#define D18F2x09C_x0000_000C_Reserved_15_14_MASK                0xc000
#define D18F2x09C_x0000_000C_FenceThresholdTxPad_OFFSET         16
#define D18F2x09C_x0000_000C_FenceThresholdTxPad_WIDTH          5
#define D18F2x09C_x0000_000C_FenceThresholdTxPad_MASK           0x1f0000
#define D18F2x09C_x0000_000C_FenceThresholdRxDll_OFFSET         21
#define D18F2x09C_x0000_000C_FenceThresholdRxDll_WIDTH          5
#define D18F2x09C_x0000_000C_FenceThresholdRxDll_MASK           0x3e00000
#define D18F2x09C_x0000_000C_FenceThresholdTxDll_OFFSET         26
#define D18F2x09C_x0000_000C_FenceThresholdTxDll_WIDTH          5
#define D18F2x09C_x0000_000C_FenceThresholdTxDll_MASK           0x7c000000
#define D18F2x09C_x0000_000C_Reserved_31_31_OFFSET              31
#define D18F2x09C_x0000_000C_Reserved_31_31_WIDTH               1
#define D18F2x09C_x0000_000C_Reserved_31_31_MASK                0x80000000

/// D18F2x09C_x0000_000C
typedef union {
  struct {                                                              ///<
    UINT32                                               ChipSelTri:8 ; ///<
    UINT32                                                   ODTTri:4 ; ///<
    UINT32                                                   CKETri:2 ; ///<
    UINT32                                           Reserved_15_14:2 ; ///<
    UINT32                                      FenceThresholdTxPad:5 ; ///<
    UINT32                                      FenceThresholdRxDll:5 ; ///<
    UINT32                                      FenceThresholdTxDll:5 ; ///<
    UINT32                                           Reserved_31_31:1 ; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} D18F2x09C_x0000_000C_STRUCT;

// **** D18F2x09C_x0000_000D Register Definition ****
// Address
#define D18F2x09C_x0000_000D_ADDRESS                            0xd

// Type
#define D18F2x09C_x0000_000D_TYPE                               TYPE_D18F2x09C
// Field Data
#define D18F2x09C_x0000_000D_TxMaxDurDllNoLock_OFFSET           0
#define D18F2x09C_x0000_000D_TxMaxDurDllNoLock_WIDTH            4
#define D18F2x09C_x0000_000D_TxMaxDurDllNoLock_MASK             0xf
#define D18F2x09C_x0000_000D_TxCPUpdPeriod_OFFSET               4
#define D18F2x09C_x0000_000D_TxCPUpdPeriod_WIDTH                3
#define D18F2x09C_x0000_000D_TxCPUpdPeriod_MASK                 0x70
#define D18F2x09C_x0000_000D_Reserved_7_7_OFFSET                7
#define D18F2x09C_x0000_000D_Reserved_7_7_WIDTH                 1
#define D18F2x09C_x0000_000D_Reserved_7_7_MASK                  0x80
#define D18F2x09C_x0000_000D_TxDLLWakeupTime_OFFSET             8
#define D18F2x09C_x0000_000D_TxDLLWakeupTime_WIDTH              2
#define D18F2x09C_x0000_000D_TxDLLWakeupTime_MASK               0x300
#define D18F2x09C_x0000_000D_Reserved_15_10_OFFSET              10
#define D18F2x09C_x0000_000D_Reserved_15_10_WIDTH               6
#define D18F2x09C_x0000_000D_Reserved_15_10_MASK                0xfc00
#define D18F2x09C_x0000_000D_RxMaxDurDllNoLock_OFFSET           16
#define D18F2x09C_x0000_000D_RxMaxDurDllNoLock_WIDTH            4
#define D18F2x09C_x0000_000D_RxMaxDurDllNoLock_MASK             0xf0000
#define D18F2x09C_x0000_000D_RxCPUpdPeriod_OFFSET               20
#define D18F2x09C_x0000_000D_RxCPUpdPeriod_WIDTH                3
#define D18F2x09C_x0000_000D_RxCPUpdPeriod_MASK                 0x700000
#define D18F2x09C_x0000_000D_Reserved_23_23_OFFSET              23
#define D18F2x09C_x0000_000D_Reserved_23_23_WIDTH               1
#define D18F2x09C_x0000_000D_Reserved_23_23_MASK                0x800000
#define D18F2x09C_x0000_000D_RxDLLWakeupTime_OFFSET             24
#define D18F2x09C_x0000_000D_RxDLLWakeupTime_WIDTH              2
#define D18F2x09C_x0000_000D_RxDLLWakeupTime_MASK               0x3000000
#define D18F2x09C_x0000_000D_Reserved_31_26_OFFSET              26
#define D18F2x09C_x0000_000D_Reserved_31_26_WIDTH               6
#define D18F2x09C_x0000_000D_Reserved_31_26_MASK                0xfc000000

/// D18F2x09C_x0000_000D
typedef union {
  struct {                                                              ///<
    UINT32                                        TxMaxDurDllNoLock:4 ; ///<
    UINT32                                            TxCPUpdPeriod:3 ; ///<
    UINT32                                             Reserved_7_7:1 ; ///<
    UINT32                                          TxDLLWakeupTime:2 ; ///<
    UINT32                                           Reserved_15_10:6 ; ///<
    UINT32                                        RxMaxDurDllNoLock:4 ; ///<
    UINT32                                            RxCPUpdPeriod:3 ; ///<
    UINT32                                           Reserved_23_23:1 ; ///<
    UINT32                                          RxDLLWakeupTime:2 ; ///<
    UINT32                                           Reserved_31_26:6 ; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} D18F2x09C_x0000_000D_STRUCT;

// **** D18F2x09C_x0000_0010 Register Definition ****
// Address
#define D18F2x09C_x0000_0010_ADDRESS                            0x10

// Type
#define D18F2x09C_x0000_0010_TYPE                               TYPE_D18F2x09C
// Field Data
#define D18F2x09C_x0000_0010_DqsRcvEnFineDelay_Byte0_OFFSET     0
#define D18F2x09C_x0000_0010_DqsRcvEnFineDelay_Byte0_WIDTH      5
#define D18F2x09C_x0000_0010_DqsRcvEnFineDelay_Byte0_MASK       0x1f
#define D18F2x09C_x0000_0010_DqsRcvEnGrossDelay_Byte0_OFFSET    5
#define D18F2x09C_x0000_0010_DqsRcvEnGrossDelay_Byte0_WIDTH     4
#define D18F2x09C_x0000_0010_DqsRcvEnGrossDelay_Byte0_MASK      0x1e0
#define D18F2x09C_x0000_0010_Reserved_15_9_OFFSET               9
#define D18F2x09C_x0000_0010_Reserved_15_9_WIDTH                7
#define D18F2x09C_x0000_0010_Reserved_15_9_MASK                 0xfe00
#define D18F2x09C_x0000_0010_DqsRcvEnFineDelay_Byte1_OFFSET     16
#define D18F2x09C_x0000_0010_DqsRcvEnFineDelay_Byte1_WIDTH      5
#define D18F2x09C_x0000_0010_DqsRcvEnFineDelay_Byte1_MASK       0x1f0000
#define D18F2x09C_x0000_0010_DqsRcvEnGrossDelay_Byte1_OFFSET    21
#define D18F2x09C_x0000_0010_DqsRcvEnGrossDelay_Byte1_WIDTH     4
#define D18F2x09C_x0000_0010_DqsRcvEnGrossDelay_Byte1_MASK      0x1e00000
#define D18F2x09C_x0000_0010_Reserved_31_25_OFFSET              25
#define D18F2x09C_x0000_0010_Reserved_31_25_WIDTH               7
#define D18F2x09C_x0000_0010_Reserved_31_25_MASK                0xfe000000

/// D18F2x09C_x0000_0010
typedef union {
  struct {                                                              ///<
    UINT32                                  DqsRcvEnFineDelay_Byte0:5 ; ///<
    UINT32                                 DqsRcvEnGrossDelay_Byte0:4 ; ///<
    UINT32                                            Reserved_15_9:7 ; ///<
    UINT32                                  DqsRcvEnFineDelay_Byte1:5 ; ///<
    UINT32                                 DqsRcvEnGrossDelay_Byte1:4 ; ///<
    UINT32                                           Reserved_31_25:7 ; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} D18F2x09C_x0000_0010_STRUCT;

// **** D18F2x09C_x0000_0011 Register Definition ****
// Address
#define D18F2x09C_x0000_0011_ADDRESS                            0x11

// Type
#define D18F2x09C_x0000_0011_TYPE                               TYPE_D18F2x09C
// Field Data
#define D18F2x09C_x0000_0011_DqsRcvEnFineDelay_Byte2_OFFSET     0
#define D18F2x09C_x0000_0011_DqsRcvEnFineDelay_Byte2_WIDTH      5
#define D18F2x09C_x0000_0011_DqsRcvEnFineDelay_Byte2_MASK       0x1f
#define D18F2x09C_x0000_0011_DqsRcvEnGrossDelay_Byte2_OFFSET    5
#define D18F2x09C_x0000_0011_DqsRcvEnGrossDelay_Byte2_WIDTH     4
#define D18F2x09C_x0000_0011_DqsRcvEnGrossDelay_Byte2_MASK      0x1e0
#define D18F2x09C_x0000_0011_Reserved_15_9_OFFSET               9
#define D18F2x09C_x0000_0011_Reserved_15_9_WIDTH                7
#define D18F2x09C_x0000_0011_Reserved_15_9_MASK                 0xfe00
#define D18F2x09C_x0000_0011_DqsRcvEnFineDelay_Byte3_OFFSET     16
#define D18F2x09C_x0000_0011_DqsRcvEnFineDelay_Byte3_WIDTH      5
#define D18F2x09C_x0000_0011_DqsRcvEnFineDelay_Byte3_MASK       0x1f0000
#define D18F2x09C_x0000_0011_DqsRcvEnGrossDelay_Byte3_OFFSET    21
#define D18F2x09C_x0000_0011_DqsRcvEnGrossDelay_Byte3_WIDTH     4
#define D18F2x09C_x0000_0011_DqsRcvEnGrossDelay_Byte3_MASK      0x1e00000
#define D18F2x09C_x0000_0011_Reserved_31_25_OFFSET              25
#define D18F2x09C_x0000_0011_Reserved_31_25_WIDTH               7
#define D18F2x09C_x0000_0011_Reserved_31_25_MASK                0xfe000000

/// D18F2x09C_x0000_0011
typedef union {
  struct {                                                              ///<
    UINT32                                  DqsRcvEnFineDelay_Byte2:5 ; ///<
    UINT32                                 DqsRcvEnGrossDelay_Byte2:4 ; ///<
    UINT32                                            Reserved_15_9:7 ; ///<
    UINT32                                  DqsRcvEnFineDelay_Byte3:5 ; ///<
    UINT32                                 DqsRcvEnGrossDelay_Byte3:4 ; ///<
    UINT32                                           Reserved_31_25:7 ; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} D18F2x09C_x0000_0011_STRUCT;

// **** D18F2x09C_x0000_0013 Register Definition ****
// Address
#define D18F2x09C_x0000_0013_ADDRESS                            0x13

// Type
#define D18F2x09C_x0000_0013_TYPE                               TYPE_D18F2x09C
// Field Data
#define D18F2x09C_x0000_0013_DqsRcvEnFineDelay_Byte0_OFFSET     0
#define D18F2x09C_x0000_0013_DqsRcvEnFineDelay_Byte0_WIDTH      5
#define D18F2x09C_x0000_0013_DqsRcvEnFineDelay_Byte0_MASK       0x1f
#define D18F2x09C_x0000_0013_DqsRcvEnGrossDelay_Byte0_OFFSET    5
#define D18F2x09C_x0000_0013_DqsRcvEnGrossDelay_Byte0_WIDTH     4
#define D18F2x09C_x0000_0013_DqsRcvEnGrossDelay_Byte0_MASK      0x1e0
#define D18F2x09C_x0000_0013_Reserved_15_9_OFFSET               9
#define D18F2x09C_x0000_0013_Reserved_15_9_WIDTH                7
#define D18F2x09C_x0000_0013_Reserved_15_9_MASK                 0xfe00
#define D18F2x09C_x0000_0013_DqsRcvEnFineDelay_Byte1_OFFSET     16
#define D18F2x09C_x0000_0013_DqsRcvEnFineDelay_Byte1_WIDTH      5
#define D18F2x09C_x0000_0013_DqsRcvEnFineDelay_Byte1_MASK       0x1f0000
#define D18F2x09C_x0000_0013_DqsRcvEnGrossDelay_Byte1_OFFSET    21
#define D18F2x09C_x0000_0013_DqsRcvEnGrossDelay_Byte1_WIDTH     4
#define D18F2x09C_x0000_0013_DqsRcvEnGrossDelay_Byte1_MASK      0x1e00000
#define D18F2x09C_x0000_0013_Reserved_31_25_OFFSET              25
#define D18F2x09C_x0000_0013_Reserved_31_25_WIDTH               7
#define D18F2x09C_x0000_0013_Reserved_31_25_MASK                0xfe000000

/// D18F2x09C_x0000_0013
typedef union {
  struct {                                                              ///<
    UINT32                                  DqsRcvEnFineDelay_Byte0:5 ; ///<
    UINT32                                 DqsRcvEnGrossDelay_Byte0:4 ; ///<
    UINT32                                            Reserved_15_9:7 ; ///<
    UINT32                                  DqsRcvEnFineDelay_Byte1:5 ; ///<
    UINT32                                 DqsRcvEnGrossDelay_Byte1:4 ; ///<
    UINT32                                           Reserved_31_25:7 ; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} D18F2x09C_x0000_0013_STRUCT;

// **** D18F2x09C_x0000_0014 Register Definition ****
// Address
#define D18F2x09C_x0000_0014_ADDRESS                            0x14

// Type
#define D18F2x09C_x0000_0014_TYPE                               TYPE_D18F2x09C
// Field Data
#define D18F2x09C_x0000_0014_DqsRcvEnFineDelay_Byte2_OFFSET     0
#define D18F2x09C_x0000_0014_DqsRcvEnFineDelay_Byte2_WIDTH      5
#define D18F2x09C_x0000_0014_DqsRcvEnFineDelay_Byte2_MASK       0x1f
#define D18F2x09C_x0000_0014_DqsRcvEnGrossDelay_Byte2_OFFSET    5
#define D18F2x09C_x0000_0014_DqsRcvEnGrossDelay_Byte2_WIDTH     4
#define D18F2x09C_x0000_0014_DqsRcvEnGrossDelay_Byte2_MASK      0x1e0
#define D18F2x09C_x0000_0014_Reserved_15_9_OFFSET               9
#define D18F2x09C_x0000_0014_Reserved_15_9_WIDTH                7
#define D18F2x09C_x0000_0014_Reserved_15_9_MASK                 0xfe00
#define D18F2x09C_x0000_0014_DqsRcvEnFineDelay_Byte3_OFFSET     16
#define D18F2x09C_x0000_0014_DqsRcvEnFineDelay_Byte3_WIDTH      5
#define D18F2x09C_x0000_0014_DqsRcvEnFineDelay_Byte3_MASK       0x1f0000
#define D18F2x09C_x0000_0014_DqsRcvEnGrossDelay_Byte3_OFFSET    21
#define D18F2x09C_x0000_0014_DqsRcvEnGrossDelay_Byte3_WIDTH     4
#define D18F2x09C_x0000_0014_DqsRcvEnGrossDelay_Byte3_MASK      0x1e00000
#define D18F2x09C_x0000_0014_Reserved_31_25_OFFSET              25
#define D18F2x09C_x0000_0014_Reserved_31_25_WIDTH               7
#define D18F2x09C_x0000_0014_Reserved_31_25_MASK                0xfe000000

/// D18F2x09C_x0000_0014
typedef union {
  struct {                                                              ///<
    UINT32                                  DqsRcvEnFineDelay_Byte2:5 ; ///<
    UINT32                                 DqsRcvEnGrossDelay_Byte2:4 ; ///<
    UINT32                                            Reserved_15_9:7 ; ///<
    UINT32                                  DqsRcvEnFineDelay_Byte3:5 ; ///<
    UINT32                                 DqsRcvEnGrossDelay_Byte3:4 ; ///<
    UINT32                                           Reserved_31_25:7 ; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} D18F2x09C_x0000_0014_STRUCT;

// **** D18F2x09C_x0000_0020 Register Definition ****
// Address
#define D18F2x09C_x0000_0020_ADDRESS                            0x20

// Type
#define D18F2x09C_x0000_0020_TYPE                               TYPE_D18F2x09C
// Field Data
#define D18F2x09C_x0000_0020_DqsRcvEnFineDelay_Byte4_OFFSET     0
#define D18F2x09C_x0000_0020_DqsRcvEnFineDelay_Byte4_WIDTH      5
#define D18F2x09C_x0000_0020_DqsRcvEnFineDelay_Byte4_MASK       0x1f
#define D18F2x09C_x0000_0020_DqsRcvEnGrossDelay_Byte4_OFFSET    5
#define D18F2x09C_x0000_0020_DqsRcvEnGrossDelay_Byte4_WIDTH     4
#define D18F2x09C_x0000_0020_DqsRcvEnGrossDelay_Byte4_MASK      0x1e0
#define D18F2x09C_x0000_0020_Reserved_15_9_OFFSET               9
#define D18F2x09C_x0000_0020_Reserved_15_9_WIDTH                7
#define D18F2x09C_x0000_0020_Reserved_15_9_MASK                 0xfe00
#define D18F2x09C_x0000_0020_DqsRcvEnFineDelay_Byte5_OFFSET     16
#define D18F2x09C_x0000_0020_DqsRcvEnFineDelay_Byte5_WIDTH      5
#define D18F2x09C_x0000_0020_DqsRcvEnFineDelay_Byte5_MASK       0x1f0000
#define D18F2x09C_x0000_0020_DqsRcvEnGrossDelay_Byte5_OFFSET    21
#define D18F2x09C_x0000_0020_DqsRcvEnGrossDelay_Byte5_WIDTH     4
#define D18F2x09C_x0000_0020_DqsRcvEnGrossDelay_Byte5_MASK      0x1e00000
#define D18F2x09C_x0000_0020_Reserved_31_25_OFFSET              25
#define D18F2x09C_x0000_0020_Reserved_31_25_WIDTH               7
#define D18F2x09C_x0000_0020_Reserved_31_25_MASK                0xfe000000

/// D18F2x09C_x0000_0020
typedef union {
  struct {                                                              ///<
    UINT32                                  DqsRcvEnFineDelay_Byte4:5 ; ///<
    UINT32                                 DqsRcvEnGrossDelay_Byte4:4 ; ///<
    UINT32                                            Reserved_15_9:7 ; ///<
    UINT32                                  DqsRcvEnFineDelay_Byte5:5 ; ///<
    UINT32                                 DqsRcvEnGrossDelay_Byte5:4 ; ///<
    UINT32                                           Reserved_31_25:7 ; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} D18F2x09C_x0000_0020_STRUCT;

// **** D18F2x09C_x0000_0021 Register Definition ****
// Address
#define D18F2x09C_x0000_0021_ADDRESS                            0x21

// Type
#define D18F2x09C_x0000_0021_TYPE                               TYPE_D18F2x09C
// Field Data
#define D18F2x09C_x0000_0021_DqsRcvEnFineDelay_Byte6_OFFSET     0
#define D18F2x09C_x0000_0021_DqsRcvEnFineDelay_Byte6_WIDTH      5
#define D18F2x09C_x0000_0021_DqsRcvEnFineDelay_Byte6_MASK       0x1f
#define D18F2x09C_x0000_0021_DqsRcvEnGrossDelay_Byte6_OFFSET    5
#define D18F2x09C_x0000_0021_DqsRcvEnGrossDelay_Byte6_WIDTH     4
#define D18F2x09C_x0000_0021_DqsRcvEnGrossDelay_Byte6_MASK      0x1e0
#define D18F2x09C_x0000_0021_Reserved_15_9_OFFSET               9
#define D18F2x09C_x0000_0021_Reserved_15_9_WIDTH                7
#define D18F2x09C_x0000_0021_Reserved_15_9_MASK                 0xfe00
#define D18F2x09C_x0000_0021_DqsRcvEnFineDelay_Byte7_OFFSET     16
#define D18F2x09C_x0000_0021_DqsRcvEnFineDelay_Byte7_WIDTH      5
#define D18F2x09C_x0000_0021_DqsRcvEnFineDelay_Byte7_MASK       0x1f0000
#define D18F2x09C_x0000_0021_DqsRcvEnGrossDelay_Byte7_OFFSET    21
#define D18F2x09C_x0000_0021_DqsRcvEnGrossDelay_Byte7_WIDTH     4
#define D18F2x09C_x0000_0021_DqsRcvEnGrossDelay_Byte7_MASK      0x1e00000
#define D18F2x09C_x0000_0021_Reserved_31_25_OFFSET              25
#define D18F2x09C_x0000_0021_Reserved_31_25_WIDTH               7
#define D18F2x09C_x0000_0021_Reserved_31_25_MASK                0xfe000000

/// D18F2x09C_x0000_0021
typedef union {
  struct {                                                              ///<
    UINT32                                  DqsRcvEnFineDelay_Byte6:5 ; ///<
    UINT32                                 DqsRcvEnGrossDelay_Byte6:4 ; ///<
    UINT32                                            Reserved_15_9:7 ; ///<
    UINT32                                  DqsRcvEnFineDelay_Byte7:5 ; ///<
    UINT32                                 DqsRcvEnGrossDelay_Byte7:4 ; ///<
    UINT32                                           Reserved_31_25:7 ; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} D18F2x09C_x0000_0021_STRUCT;

// **** D18F2x09C_x0000_0023 Register Definition ****
// Address
#define D18F2x09C_x0000_0023_ADDRESS                            0x23

// Type
#define D18F2x09C_x0000_0023_TYPE                               TYPE_D18F2x09C
// Field Data
#define D18F2x09C_x0000_0023_DqsRcvEnFineDelay_Byte4_OFFSET     0
#define D18F2x09C_x0000_0023_DqsRcvEnFineDelay_Byte4_WIDTH      5
#define D18F2x09C_x0000_0023_DqsRcvEnFineDelay_Byte4_MASK       0x1f
#define D18F2x09C_x0000_0023_DqsRcvEnGrossDelay_Byte4_OFFSET    5
#define D18F2x09C_x0000_0023_DqsRcvEnGrossDelay_Byte4_WIDTH     4
#define D18F2x09C_x0000_0023_DqsRcvEnGrossDelay_Byte4_MASK      0x1e0
#define D18F2x09C_x0000_0023_Reserved_15_9_OFFSET               9
#define D18F2x09C_x0000_0023_Reserved_15_9_WIDTH                7
#define D18F2x09C_x0000_0023_Reserved_15_9_MASK                 0xfe00
#define D18F2x09C_x0000_0023_DqsRcvEnFineDelay_Byte5_OFFSET     16
#define D18F2x09C_x0000_0023_DqsRcvEnFineDelay_Byte5_WIDTH      5
#define D18F2x09C_x0000_0023_DqsRcvEnFineDelay_Byte5_MASK       0x1f0000
#define D18F2x09C_x0000_0023_DqsRcvEnGrossDelay_Byte5_OFFSET    21
#define D18F2x09C_x0000_0023_DqsRcvEnGrossDelay_Byte5_WIDTH     4
#define D18F2x09C_x0000_0023_DqsRcvEnGrossDelay_Byte5_MASK      0x1e00000
#define D18F2x09C_x0000_0023_Reserved_31_25_OFFSET              25
#define D18F2x09C_x0000_0023_Reserved_31_25_WIDTH               7
#define D18F2x09C_x0000_0023_Reserved_31_25_MASK                0xfe000000

/// D18F2x09C_x0000_0023
typedef union {
  struct {                                                              ///<
    UINT32                                  DqsRcvEnFineDelay_Byte4:5 ; ///<
    UINT32                                 DqsRcvEnGrossDelay_Byte4:4 ; ///<
    UINT32                                            Reserved_15_9:7 ; ///<
    UINT32                                  DqsRcvEnFineDelay_Byte5:5 ; ///<
    UINT32                                 DqsRcvEnGrossDelay_Byte5:4 ; ///<
    UINT32                                           Reserved_31_25:7 ; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} D18F2x09C_x0000_0023_STRUCT;

// **** D18F2x09C_x0000_0024 Register Definition ****
// Address
#define D18F2x09C_x0000_0024_ADDRESS                            0x24

// Type
#define D18F2x09C_x0000_0024_TYPE                               TYPE_D18F2x09C
// Field Data
#define D18F2x09C_x0000_0024_DqsRcvEnFineDelay_Byte6_OFFSET     0
#define D18F2x09C_x0000_0024_DqsRcvEnFineDelay_Byte6_WIDTH      5
#define D18F2x09C_x0000_0024_DqsRcvEnFineDelay_Byte6_MASK       0x1f
#define D18F2x09C_x0000_0024_DqsRcvEnGrossDelay_Byte6_OFFSET    5
#define D18F2x09C_x0000_0024_DqsRcvEnGrossDelay_Byte6_WIDTH     4
#define D18F2x09C_x0000_0024_DqsRcvEnGrossDelay_Byte6_MASK      0x1e0
#define D18F2x09C_x0000_0024_Reserved_15_9_OFFSET               9
#define D18F2x09C_x0000_0024_Reserved_15_9_WIDTH                7
#define D18F2x09C_x0000_0024_Reserved_15_9_MASK                 0xfe00
#define D18F2x09C_x0000_0024_DqsRcvEnFineDelay_Byte7_OFFSET     16
#define D18F2x09C_x0000_0024_DqsRcvEnFineDelay_Byte7_WIDTH      5
#define D18F2x09C_x0000_0024_DqsRcvEnFineDelay_Byte7_MASK       0x1f0000
#define D18F2x09C_x0000_0024_DqsRcvEnGrossDelay_Byte7_OFFSET    21
#define D18F2x09C_x0000_0024_DqsRcvEnGrossDelay_Byte7_WIDTH     4
#define D18F2x09C_x0000_0024_DqsRcvEnGrossDelay_Byte7_MASK      0x1e00000
#define D18F2x09C_x0000_0024_Reserved_31_25_OFFSET              25
#define D18F2x09C_x0000_0024_Reserved_31_25_WIDTH               7
#define D18F2x09C_x0000_0024_Reserved_31_25_MASK                0xfe000000

/// D18F2x09C_x0000_0024
typedef union {
  struct {                                                              ///<
    UINT32                                  DqsRcvEnFineDelay_Byte6:5 ; ///<
    UINT32                                 DqsRcvEnGrossDelay_Byte6:4 ; ///<
    UINT32                                            Reserved_15_9:7 ; ///<
    UINT32                                  DqsRcvEnFineDelay_Byte7:5 ; ///<
    UINT32                                 DqsRcvEnGrossDelay_Byte7:4 ; ///<
    UINT32                                           Reserved_31_25:7 ; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} D18F2x09C_x0000_0024_STRUCT;

// **** D18F2x09C_x0000_0030 Register Definition ****
// Address
#define D18F2x09C_x0000_0030_ADDRESS                            0x30

// Type
#define D18F2x09C_x0000_0030_TYPE                               TYPE_D18F2x09C
// Field Data
#define D18F2x09C_x0000_0030_WrDqsFineDly_Byte0_OFFSET          0
#define D18F2x09C_x0000_0030_WrDqsFineDly_Byte0_WIDTH           5
#define D18F2x09C_x0000_0030_WrDqsFineDly_Byte0_MASK            0x1f
#define D18F2x09C_x0000_0030_WrDqsGrossDly_Byte0_OFFSET         5
#define D18F2x09C_x0000_0030_WrDqsGrossDly_Byte0_WIDTH          3
#define D18F2x09C_x0000_0030_WrDqsGrossDly_Byte0_MASK           0xe0
#define D18F2x09C_x0000_0030_Reserved_15_8_OFFSET               8
#define D18F2x09C_x0000_0030_Reserved_15_8_WIDTH                8
#define D18F2x09C_x0000_0030_Reserved_15_8_MASK                 0xff00
#define D18F2x09C_x0000_0030_WrDqsFineDly_Byte1_OFFSET          16
#define D18F2x09C_x0000_0030_WrDqsFineDly_Byte1_WIDTH           5
#define D18F2x09C_x0000_0030_WrDqsFineDly_Byte1_MASK            0x1f0000
#define D18F2x09C_x0000_0030_WrDqsGrossDly_Byte1_OFFSET         21
#define D18F2x09C_x0000_0030_WrDqsGrossDly_Byte1_WIDTH          3
#define D18F2x09C_x0000_0030_WrDqsGrossDly_Byte1_MASK           0xe00000
#define D18F2x09C_x0000_0030_Reserved_31_24_OFFSET              24
#define D18F2x09C_x0000_0030_Reserved_31_24_WIDTH               8
#define D18F2x09C_x0000_0030_Reserved_31_24_MASK                0xff000000

/// D18F2x09C_x0000_0030
typedef union {
  struct {                                                              ///<
    UINT32                                       WrDqsFineDly_Byte0:5 ; ///<
    UINT32                                      WrDqsGrossDly_Byte0:3 ; ///<
    UINT32                                            Reserved_15_8:8 ; ///<
    UINT32                                       WrDqsFineDly_Byte1:5 ; ///<
    UINT32                                      WrDqsGrossDly_Byte1:3 ; ///<
    UINT32                                           Reserved_31_24:8 ; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} D18F2x09C_x0000_0030_STRUCT;

// **** D18F2x09C_x0000_0031 Register Definition ****
// Address
#define D18F2x09C_x0000_0031_ADDRESS                            0x31

// Type
#define D18F2x09C_x0000_0031_TYPE                               TYPE_D18F2x09C
// Field Data
#define D18F2x09C_x0000_0031_WrDqsFineDly_Byte2_OFFSET          0
#define D18F2x09C_x0000_0031_WrDqsFineDly_Byte2_WIDTH           5
#define D18F2x09C_x0000_0031_WrDqsFineDly_Byte2_MASK            0x1f
#define D18F2x09C_x0000_0031_WrDqsGrossDly_Byte2_OFFSET         5
#define D18F2x09C_x0000_0031_WrDqsGrossDly_Byte2_WIDTH          3
#define D18F2x09C_x0000_0031_WrDqsGrossDly_Byte2_MASK           0xe0
#define D18F2x09C_x0000_0031_Reserved_15_8_OFFSET               8
#define D18F2x09C_x0000_0031_Reserved_15_8_WIDTH                8
#define D18F2x09C_x0000_0031_Reserved_15_8_MASK                 0xff00
#define D18F2x09C_x0000_0031_WrDqsFineDly_Byte3_OFFSET          16
#define D18F2x09C_x0000_0031_WrDqsFineDly_Byte3_WIDTH           5
#define D18F2x09C_x0000_0031_WrDqsFineDly_Byte3_MASK            0x1f0000
#define D18F2x09C_x0000_0031_WrDqsGrossDly_Byte3_OFFSET         21
#define D18F2x09C_x0000_0031_WrDqsGrossDly_Byte3_WIDTH          3
#define D18F2x09C_x0000_0031_WrDqsGrossDly_Byte3_MASK           0xe00000
#define D18F2x09C_x0000_0031_Reserved_31_24_OFFSET              24
#define D18F2x09C_x0000_0031_Reserved_31_24_WIDTH               8
#define D18F2x09C_x0000_0031_Reserved_31_24_MASK                0xff000000

/// D18F2x09C_x0000_0031
typedef union {
  struct {                                                              ///<
    UINT32                                       WrDqsFineDly_Byte2:5 ; ///<
    UINT32                                      WrDqsGrossDly_Byte2:3 ; ///<
    UINT32                                            Reserved_15_8:8 ; ///<
    UINT32                                       WrDqsFineDly_Byte3:5 ; ///<
    UINT32                                      WrDqsGrossDly_Byte3:3 ; ///<
    UINT32                                           Reserved_31_24:8 ; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} D18F2x09C_x0000_0031_STRUCT;

// **** D18F2x09C_x0000_0033 Register Definition ****
// Address
#define D18F2x09C_x0000_0033_ADDRESS                            0x33

// Type
#define D18F2x09C_x0000_0033_TYPE                               TYPE_D18F2x09C
// Field Data
#define D18F2x09C_x0000_0033_WrDqsFineDly_Byte0_OFFSET          0
#define D18F2x09C_x0000_0033_WrDqsFineDly_Byte0_WIDTH           5
#define D18F2x09C_x0000_0033_WrDqsFineDly_Byte0_MASK            0x1f
#define D18F2x09C_x0000_0033_WrDqsGrossDly_Byte0_OFFSET         5
#define D18F2x09C_x0000_0033_WrDqsGrossDly_Byte0_WIDTH          3
#define D18F2x09C_x0000_0033_WrDqsGrossDly_Byte0_MASK           0xe0
#define D18F2x09C_x0000_0033_Reserved_15_8_OFFSET               8
#define D18F2x09C_x0000_0033_Reserved_15_8_WIDTH                8
#define D18F2x09C_x0000_0033_Reserved_15_8_MASK                 0xff00
#define D18F2x09C_x0000_0033_WrDqsFineDly_Byte1_OFFSET          16
#define D18F2x09C_x0000_0033_WrDqsFineDly_Byte1_WIDTH           5
#define D18F2x09C_x0000_0033_WrDqsFineDly_Byte1_MASK            0x1f0000
#define D18F2x09C_x0000_0033_WrDqsGrossDly_Byte1_OFFSET         21
#define D18F2x09C_x0000_0033_WrDqsGrossDly_Byte1_WIDTH          3
#define D18F2x09C_x0000_0033_WrDqsGrossDly_Byte1_MASK           0xe00000
#define D18F2x09C_x0000_0033_Reserved_31_24_OFFSET              24
#define D18F2x09C_x0000_0033_Reserved_31_24_WIDTH               8
#define D18F2x09C_x0000_0033_Reserved_31_24_MASK                0xff000000

/// D18F2x09C_x0000_0033
typedef union {
  struct {                                                              ///<
    UINT32                                       WrDqsFineDly_Byte0:5 ; ///<
    UINT32                                      WrDqsGrossDly_Byte0:3 ; ///<
    UINT32                                            Reserved_15_8:8 ; ///<
    UINT32                                       WrDqsFineDly_Byte1:5 ; ///<
    UINT32                                      WrDqsGrossDly_Byte1:3 ; ///<
    UINT32                                           Reserved_31_24:8 ; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} D18F2x09C_x0000_0033_STRUCT;

// **** D18F2x09C_x0000_0034 Register Definition ****
// Address
#define D18F2x09C_x0000_0034_ADDRESS                            0x34

// Type
#define D18F2x09C_x0000_0034_TYPE                               TYPE_D18F2x09C
// Field Data
#define D18F2x09C_x0000_0034_WrDqsFineDly_Byte2_OFFSET          0
#define D18F2x09C_x0000_0034_WrDqsFineDly_Byte2_WIDTH           5
#define D18F2x09C_x0000_0034_WrDqsFineDly_Byte2_MASK            0x1f
#define D18F2x09C_x0000_0034_WrDqsGrossDly_Byte2_OFFSET         5
#define D18F2x09C_x0000_0034_WrDqsGrossDly_Byte2_WIDTH          3
#define D18F2x09C_x0000_0034_WrDqsGrossDly_Byte2_MASK           0xe0
#define D18F2x09C_x0000_0034_Reserved_15_8_OFFSET               8
#define D18F2x09C_x0000_0034_Reserved_15_8_WIDTH                8
#define D18F2x09C_x0000_0034_Reserved_15_8_MASK                 0xff00
#define D18F2x09C_x0000_0034_WrDqsFineDly_Byte3_OFFSET          16
#define D18F2x09C_x0000_0034_WrDqsFineDly_Byte3_WIDTH           5
#define D18F2x09C_x0000_0034_WrDqsFineDly_Byte3_MASK            0x1f0000
#define D18F2x09C_x0000_0034_WrDqsGrossDly_Byte3_OFFSET         21
#define D18F2x09C_x0000_0034_WrDqsGrossDly_Byte3_WIDTH          3
#define D18F2x09C_x0000_0034_WrDqsGrossDly_Byte3_MASK           0xe00000
#define D18F2x09C_x0000_0034_Reserved_31_24_OFFSET              24
#define D18F2x09C_x0000_0034_Reserved_31_24_WIDTH               8
#define D18F2x09C_x0000_0034_Reserved_31_24_MASK                0xff000000

/// D18F2x09C_x0000_0034
typedef union {
  struct {                                                              ///<
    UINT32                                       WrDqsFineDly_Byte2:5 ; ///<
    UINT32                                      WrDqsGrossDly_Byte2:3 ; ///<
    UINT32                                            Reserved_15_8:8 ; ///<
    UINT32                                       WrDqsFineDly_Byte3:5 ; ///<
    UINT32                                      WrDqsGrossDly_Byte3:3 ; ///<
    UINT32                                           Reserved_31_24:8 ; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} D18F2x09C_x0000_0034_STRUCT;

// **** D18F2x09C_x0000_0040 Register Definition ****
// Address
#define D18F2x09C_x0000_0040_ADDRESS                            0x40

// Type
#define D18F2x09C_x0000_0040_TYPE                               TYPE_D18F2x09C
// Field Data
#define D18F2x09C_x0000_0040_WrDqsFineDly_Byte4_OFFSET          0
#define D18F2x09C_x0000_0040_WrDqsFineDly_Byte4_WIDTH           5
#define D18F2x09C_x0000_0040_WrDqsFineDly_Byte4_MASK            0x1f
#define D18F2x09C_x0000_0040_WrDqsGrossDly_Byte4_OFFSET         5
#define D18F2x09C_x0000_0040_WrDqsGrossDly_Byte4_WIDTH          3
#define D18F2x09C_x0000_0040_WrDqsGrossDly_Byte4_MASK           0xe0
#define D18F2x09C_x0000_0040_Reserved_15_8_OFFSET               8
#define D18F2x09C_x0000_0040_Reserved_15_8_WIDTH                8
#define D18F2x09C_x0000_0040_Reserved_15_8_MASK                 0xff00
#define D18F2x09C_x0000_0040_WrDqsFineDly_Byte5_OFFSET          16
#define D18F2x09C_x0000_0040_WrDqsFineDly_Byte5_WIDTH           5
#define D18F2x09C_x0000_0040_WrDqsFineDly_Byte5_MASK            0x1f0000
#define D18F2x09C_x0000_0040_WrDqsGrossDly_Byte5_OFFSET         21
#define D18F2x09C_x0000_0040_WrDqsGrossDly_Byte5_WIDTH          3
#define D18F2x09C_x0000_0040_WrDqsGrossDly_Byte5_MASK           0xe00000
#define D18F2x09C_x0000_0040_Reserved_31_24_OFFSET              24
#define D18F2x09C_x0000_0040_Reserved_31_24_WIDTH               8
#define D18F2x09C_x0000_0040_Reserved_31_24_MASK                0xff000000

/// D18F2x09C_x0000_0040
typedef union {
  struct {                                                              ///<
    UINT32                                       WrDqsFineDly_Byte4:5 ; ///<
    UINT32                                      WrDqsGrossDly_Byte4:3 ; ///<
    UINT32                                            Reserved_15_8:8 ; ///<
    UINT32                                       WrDqsFineDly_Byte5:5 ; ///<
    UINT32                                      WrDqsGrossDly_Byte5:3 ; ///<
    UINT32                                           Reserved_31_24:8 ; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} D18F2x09C_x0000_0040_STRUCT;

// **** D18F2x09C_x0000_0041 Register Definition ****
// Address
#define D18F2x09C_x0000_0041_ADDRESS                            0x41

// Type
#define D18F2x09C_x0000_0041_TYPE                               TYPE_D18F2x09C
// Field Data
#define D18F2x09C_x0000_0041_WrDqsFineDly_Byte6_OFFSET          0
#define D18F2x09C_x0000_0041_WrDqsFineDly_Byte6_WIDTH           5
#define D18F2x09C_x0000_0041_WrDqsFineDly_Byte6_MASK            0x1f
#define D18F2x09C_x0000_0041_WrDqsGrossDly_Byte6_OFFSET         5
#define D18F2x09C_x0000_0041_WrDqsGrossDly_Byte6_WIDTH          3
#define D18F2x09C_x0000_0041_WrDqsGrossDly_Byte6_MASK           0xe0
#define D18F2x09C_x0000_0041_Reserved_15_8_OFFSET               8
#define D18F2x09C_x0000_0041_Reserved_15_8_WIDTH                8
#define D18F2x09C_x0000_0041_Reserved_15_8_MASK                 0xff00
#define D18F2x09C_x0000_0041_WrDqsFineDly_Byte7_OFFSET          16
#define D18F2x09C_x0000_0041_WrDqsFineDly_Byte7_WIDTH           5
#define D18F2x09C_x0000_0041_WrDqsFineDly_Byte7_MASK            0x1f0000
#define D18F2x09C_x0000_0041_WrDqsGrossDly_Byte7_OFFSET         21
#define D18F2x09C_x0000_0041_WrDqsGrossDly_Byte7_WIDTH          3
#define D18F2x09C_x0000_0041_WrDqsGrossDly_Byte7_MASK           0xe00000
#define D18F2x09C_x0000_0041_Reserved_31_24_OFFSET              24
#define D18F2x09C_x0000_0041_Reserved_31_24_WIDTH               8
#define D18F2x09C_x0000_0041_Reserved_31_24_MASK                0xff000000

/// D18F2x09C_x0000_0041
typedef union {
  struct {                                                              ///<
    UINT32                                       WrDqsFineDly_Byte6:5 ; ///<
    UINT32                                      WrDqsGrossDly_Byte6:3 ; ///<
    UINT32                                            Reserved_15_8:8 ; ///<
    UINT32                                       WrDqsFineDly_Byte7:5 ; ///<
    UINT32                                      WrDqsGrossDly_Byte7:3 ; ///<
    UINT32                                           Reserved_31_24:8 ; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} D18F2x09C_x0000_0041_STRUCT;

// **** D18F2x09C_x0000_0043 Register Definition ****
// Address
#define D18F2x09C_x0000_0043_ADDRESS                            0x43

// Type
#define D18F2x09C_x0000_0043_TYPE                               TYPE_D18F2x09C
// Field Data
#define D18F2x09C_x0000_0043_WrDqsFineDly_Byte4_OFFSET          0
#define D18F2x09C_x0000_0043_WrDqsFineDly_Byte4_WIDTH           5
#define D18F2x09C_x0000_0043_WrDqsFineDly_Byte4_MASK            0x1f
#define D18F2x09C_x0000_0043_WrDqsGrossDly_Byte4_OFFSET         5
#define D18F2x09C_x0000_0043_WrDqsGrossDly_Byte4_WIDTH          3
#define D18F2x09C_x0000_0043_WrDqsGrossDly_Byte4_MASK           0xe0
#define D18F2x09C_x0000_0043_Reserved_15_8_OFFSET               8
#define D18F2x09C_x0000_0043_Reserved_15_8_WIDTH                8
#define D18F2x09C_x0000_0043_Reserved_15_8_MASK                 0xff00
#define D18F2x09C_x0000_0043_WrDqsFineDly_Byte5_OFFSET          16
#define D18F2x09C_x0000_0043_WrDqsFineDly_Byte5_WIDTH           5
#define D18F2x09C_x0000_0043_WrDqsFineDly_Byte5_MASK            0x1f0000
#define D18F2x09C_x0000_0043_WrDqsGrossDly_Byte5_OFFSET         21
#define D18F2x09C_x0000_0043_WrDqsGrossDly_Byte5_WIDTH          3
#define D18F2x09C_x0000_0043_WrDqsGrossDly_Byte5_MASK           0xe00000
#define D18F2x09C_x0000_0043_Reserved_31_24_OFFSET              24
#define D18F2x09C_x0000_0043_Reserved_31_24_WIDTH               8
#define D18F2x09C_x0000_0043_Reserved_31_24_MASK                0xff000000

/// D18F2x09C_x0000_0043
typedef union {
  struct {                                                              ///<
    UINT32                                       WrDqsFineDly_Byte4:5 ; ///<
    UINT32                                      WrDqsGrossDly_Byte4:3 ; ///<
    UINT32                                            Reserved_15_8:8 ; ///<
    UINT32                                       WrDqsFineDly_Byte5:5 ; ///<
    UINT32                                      WrDqsGrossDly_Byte5:3 ; ///<
    UINT32                                           Reserved_31_24:8 ; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} D18F2x09C_x0000_0043_STRUCT;

// **** D18F2x09C_x0000_0044 Register Definition ****
// Address
#define D18F2x09C_x0000_0044_ADDRESS                            0x44

// Type
#define D18F2x09C_x0000_0044_TYPE                               TYPE_D18F2x09C
// Field Data
#define D18F2x09C_x0000_0044_WrDqsFineDly_Byte6_OFFSET          0
#define D18F2x09C_x0000_0044_WrDqsFineDly_Byte6_WIDTH           5
#define D18F2x09C_x0000_0044_WrDqsFineDly_Byte6_MASK            0x1f
#define D18F2x09C_x0000_0044_WrDqsGrossDly_Byte6_OFFSET         5
#define D18F2x09C_x0000_0044_WrDqsGrossDly_Byte6_WIDTH          3
#define D18F2x09C_x0000_0044_WrDqsGrossDly_Byte6_MASK           0xe0
#define D18F2x09C_x0000_0044_Reserved_15_8_OFFSET               8
#define D18F2x09C_x0000_0044_Reserved_15_8_WIDTH                8
#define D18F2x09C_x0000_0044_Reserved_15_8_MASK                 0xff00
#define D18F2x09C_x0000_0044_WrDqsFineDly_Byte7_OFFSET          16
#define D18F2x09C_x0000_0044_WrDqsFineDly_Byte7_WIDTH           5
#define D18F2x09C_x0000_0044_WrDqsFineDly_Byte7_MASK            0x1f0000
#define D18F2x09C_x0000_0044_WrDqsGrossDly_Byte7_OFFSET         21
#define D18F2x09C_x0000_0044_WrDqsGrossDly_Byte7_WIDTH          3
#define D18F2x09C_x0000_0044_WrDqsGrossDly_Byte7_MASK           0xe00000
#define D18F2x09C_x0000_0044_Reserved_31_24_OFFSET              24
#define D18F2x09C_x0000_0044_Reserved_31_24_WIDTH               8
#define D18F2x09C_x0000_0044_Reserved_31_24_MASK                0xff000000

/// D18F2x09C_x0000_0044
typedef union {
  struct {                                                              ///<
    UINT32                                       WrDqsFineDly_Byte6:5 ; ///<
    UINT32                                      WrDqsGrossDly_Byte6:3 ; ///<
    UINT32                                            Reserved_15_8:8 ; ///<
    UINT32                                       WrDqsFineDly_Byte7:5 ; ///<
    UINT32                                      WrDqsGrossDly_Byte7:3 ; ///<
    UINT32                                           Reserved_31_24:8 ; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} D18F2x09C_x0000_0044_STRUCT;

// **** D18F2x09C_x0000_0050 Register Definition ****
// Address
#define D18F2x09C_x0000_0050_ADDRESS                            0x50

// Type
#define D18F2x09C_x0000_0050_TYPE                               TYPE_D18F2x09C
// Field Data
#define D18F2x09C_x0000_0050_PhRecFineDly_Byte0_OFFSET          0
#define D18F2x09C_x0000_0050_PhRecFineDly_Byte0_WIDTH           5
#define D18F2x09C_x0000_0050_PhRecFineDly_Byte0_MASK            0x1f
#define D18F2x09C_x0000_0050_PhRecGrossDly_Byte0_OFFSET         5
#define D18F2x09C_x0000_0050_PhRecGrossDly_Byte0_WIDTH          2
#define D18F2x09C_x0000_0050_PhRecGrossDly_Byte0_MASK           0x60
#define D18F2x09C_x0000_0050_Reserved_7_7_OFFSET                7
#define D18F2x09C_x0000_0050_Reserved_7_7_WIDTH                 1
#define D18F2x09C_x0000_0050_Reserved_7_7_MASK                  0x80
#define D18F2x09C_x0000_0050_PhRecFineDly_Byte1_OFFSET          8
#define D18F2x09C_x0000_0050_PhRecFineDly_Byte1_WIDTH           5
#define D18F2x09C_x0000_0050_PhRecFineDly_Byte1_MASK            0x1f00
#define D18F2x09C_x0000_0050_PhRecGrossDly_Byte1_OFFSET         13
#define D18F2x09C_x0000_0050_PhRecGrossDly_Byte1_WIDTH          2
#define D18F2x09C_x0000_0050_PhRecGrossDly_Byte1_MASK           0x6000
#define D18F2x09C_x0000_0050_Reserved_15_15_OFFSET              15
#define D18F2x09C_x0000_0050_Reserved_15_15_WIDTH               1
#define D18F2x09C_x0000_0050_Reserved_15_15_MASK                0x8000
#define D18F2x09C_x0000_0050_PhRecFineDly_Byte2_OFFSET          16
#define D18F2x09C_x0000_0050_PhRecFineDly_Byte2_WIDTH           5
#define D18F2x09C_x0000_0050_PhRecFineDly_Byte2_MASK            0x1f0000
#define D18F2x09C_x0000_0050_PhRecGrossDly_Byte2_OFFSET         21
#define D18F2x09C_x0000_0050_PhRecGrossDly_Byte2_WIDTH          2
#define D18F2x09C_x0000_0050_PhRecGrossDly_Byte2_MASK           0x600000
#define D18F2x09C_x0000_0050_Reserved_23_23_OFFSET              23
#define D18F2x09C_x0000_0050_Reserved_23_23_WIDTH               1
#define D18F2x09C_x0000_0050_Reserved_23_23_MASK                0x800000
#define D18F2x09C_x0000_0050_PhRecFineDly_Byte3_OFFSET          24
#define D18F2x09C_x0000_0050_PhRecFineDly_Byte3_WIDTH           5
#define D18F2x09C_x0000_0050_PhRecFineDly_Byte3_MASK            0x1f000000
#define D18F2x09C_x0000_0050_PhRecGrossDly_Byte3_OFFSET         29
#define D18F2x09C_x0000_0050_PhRecGrossDly_Byte3_WIDTH          2
#define D18F2x09C_x0000_0050_PhRecGrossDly_Byte3_MASK           0x60000000
#define D18F2x09C_x0000_0050_Reserved_31_31_OFFSET              31
#define D18F2x09C_x0000_0050_Reserved_31_31_WIDTH               1
#define D18F2x09C_x0000_0050_Reserved_31_31_MASK                0x80000000

/// D18F2x09C_x0000_0050
typedef union {
  struct {                                                              ///<
    UINT32                                       PhRecFineDly_Byte0:5 ; ///<
    UINT32                                      PhRecGrossDly_Byte0:2 ; ///<
    UINT32                                             Reserved_7_7:1 ; ///<
    UINT32                                       PhRecFineDly_Byte1:5 ; ///<
    UINT32                                      PhRecGrossDly_Byte1:2 ; ///<
    UINT32                                           Reserved_15_15:1 ; ///<
    UINT32                                       PhRecFineDly_Byte2:5 ; ///<
    UINT32                                      PhRecGrossDly_Byte2:2 ; ///<
    UINT32                                           Reserved_23_23:1 ; ///<
    UINT32                                       PhRecFineDly_Byte3:5 ; ///<
    UINT32                                      PhRecGrossDly_Byte3:2 ; ///<
    UINT32                                           Reserved_31_31:1 ; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} D18F2x09C_x0000_0050_STRUCT;

// **** D18F2x09C_x0000_0051 Register Definition ****
// Address
#define D18F2x09C_x0000_0051_ADDRESS                            0x51

// Type
#define D18F2x09C_x0000_0051_TYPE                               TYPE_D18F2x09C
// Field Data
#define D18F2x09C_x0000_0051_PhRecFineDly_Byte4_OFFSET          0
#define D18F2x09C_x0000_0051_PhRecFineDly_Byte4_WIDTH           5
#define D18F2x09C_x0000_0051_PhRecFineDly_Byte4_MASK            0x1f
#define D18F2x09C_x0000_0051_PhRecGrossDly_Byte4_OFFSET         5
#define D18F2x09C_x0000_0051_PhRecGrossDly_Byte4_WIDTH          2
#define D18F2x09C_x0000_0051_PhRecGrossDly_Byte4_MASK           0x60
#define D18F2x09C_x0000_0051_Reserved_7_7_OFFSET                7
#define D18F2x09C_x0000_0051_Reserved_7_7_WIDTH                 1
#define D18F2x09C_x0000_0051_Reserved_7_7_MASK                  0x80
#define D18F2x09C_x0000_0051_PhRecFineDly_Byte5_OFFSET          8
#define D18F2x09C_x0000_0051_PhRecFineDly_Byte5_WIDTH           5
#define D18F2x09C_x0000_0051_PhRecFineDly_Byte5_MASK            0x1f00
#define D18F2x09C_x0000_0051_PhRecGrossDly_Byte5_OFFSET         13
#define D18F2x09C_x0000_0051_PhRecGrossDly_Byte5_WIDTH          2
#define D18F2x09C_x0000_0051_PhRecGrossDly_Byte5_MASK           0x6000
#define D18F2x09C_x0000_0051_Reserved_15_15_OFFSET              15
#define D18F2x09C_x0000_0051_Reserved_15_15_WIDTH               1
#define D18F2x09C_x0000_0051_Reserved_15_15_MASK                0x8000
#define D18F2x09C_x0000_0051_PhRecFineDly_Byte6_OFFSET          16
#define D18F2x09C_x0000_0051_PhRecFineDly_Byte6_WIDTH           5
#define D18F2x09C_x0000_0051_PhRecFineDly_Byte6_MASK            0x1f0000
#define D18F2x09C_x0000_0051_PhRecGrossDly_Byte6_OFFSET         21
#define D18F2x09C_x0000_0051_PhRecGrossDly_Byte6_WIDTH          2
#define D18F2x09C_x0000_0051_PhRecGrossDly_Byte6_MASK           0x600000
#define D18F2x09C_x0000_0051_Reserved_23_23_OFFSET              23
#define D18F2x09C_x0000_0051_Reserved_23_23_WIDTH               1
#define D18F2x09C_x0000_0051_Reserved_23_23_MASK                0x800000
#define D18F2x09C_x0000_0051_PhRecFineDly_Byte7_OFFSET          24
#define D18F2x09C_x0000_0051_PhRecFineDly_Byte7_WIDTH           5
#define D18F2x09C_x0000_0051_PhRecFineDly_Byte7_MASK            0x1f000000
#define D18F2x09C_x0000_0051_PhRecGrossDly_Byte7_OFFSET         29
#define D18F2x09C_x0000_0051_PhRecGrossDly_Byte7_WIDTH          2
#define D18F2x09C_x0000_0051_PhRecGrossDly_Byte7_MASK           0x60000000
#define D18F2x09C_x0000_0051_Reserved_31_31_OFFSET              31
#define D18F2x09C_x0000_0051_Reserved_31_31_WIDTH               1
#define D18F2x09C_x0000_0051_Reserved_31_31_MASK                0x80000000

/// D18F2x09C_x0000_0051
typedef union {
  struct {                                                              ///<
    UINT32                                       PhRecFineDly_Byte4:5 ; ///<
    UINT32                                      PhRecGrossDly_Byte4:2 ; ///<
    UINT32                                             Reserved_7_7:1 ; ///<
    UINT32                                       PhRecFineDly_Byte5:5 ; ///<
    UINT32                                      PhRecGrossDly_Byte5:2 ; ///<
    UINT32                                           Reserved_15_15:1 ; ///<
    UINT32                                       PhRecFineDly_Byte6:5 ; ///<
    UINT32                                      PhRecGrossDly_Byte6:2 ; ///<
    UINT32                                           Reserved_23_23:1 ; ///<
    UINT32                                       PhRecFineDly_Byte7:5 ; ///<
    UINT32                                      PhRecGrossDly_Byte7:2 ; ///<
    UINT32                                           Reserved_31_31:1 ; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} D18F2x09C_x0000_0051_STRUCT;

// **** D18F2x09C_x0000_0101 Register Definition ****
// Address
#define D18F2x09C_x0000_0101_ADDRESS                            0x101

// Type
#define D18F2x09C_x0000_0101_TYPE                               TYPE_D18F2x09C
// Field Data
#define D18F2x09C_x0000_0101_WrDatFineDly_Byte0_OFFSET          0
#define D18F2x09C_x0000_0101_WrDatFineDly_Byte0_WIDTH           5
#define D18F2x09C_x0000_0101_WrDatFineDly_Byte0_MASK            0x1f
#define D18F2x09C_x0000_0101_WrDatGrossDly_Byte0_OFFSET         5
#define D18F2x09C_x0000_0101_WrDatGrossDly_Byte0_WIDTH          3
#define D18F2x09C_x0000_0101_WrDatGrossDly_Byte0_MASK           0xe0
#define D18F2x09C_x0000_0101_WrDatFineDly_Byte1_OFFSET          8
#define D18F2x09C_x0000_0101_WrDatFineDly_Byte1_WIDTH           5
#define D18F2x09C_x0000_0101_WrDatFineDly_Byte1_MASK            0x1f00
#define D18F2x09C_x0000_0101_WrDatGrossDly_Byte1_OFFSET         13
#define D18F2x09C_x0000_0101_WrDatGrossDly_Byte1_WIDTH          3
#define D18F2x09C_x0000_0101_WrDatGrossDly_Byte1_MASK           0xe000
#define D18F2x09C_x0000_0101_WrDatFineDly_Byte2_OFFSET          16
#define D18F2x09C_x0000_0101_WrDatFineDly_Byte2_WIDTH           5
#define D18F2x09C_x0000_0101_WrDatFineDly_Byte2_MASK            0x1f0000
#define D18F2x09C_x0000_0101_WrDatGrossDly_Byte2_OFFSET         21
#define D18F2x09C_x0000_0101_WrDatGrossDly_Byte2_WIDTH          3
#define D18F2x09C_x0000_0101_WrDatGrossDly_Byte2_MASK           0xe00000
#define D18F2x09C_x0000_0101_WrDatFineDly_Byte3_OFFSET          24
#define D18F2x09C_x0000_0101_WrDatFineDly_Byte3_WIDTH           5
#define D18F2x09C_x0000_0101_WrDatFineDly_Byte3_MASK            0x1f000000
#define D18F2x09C_x0000_0101_WrDatGrossDly_Byte3_OFFSET         29
#define D18F2x09C_x0000_0101_WrDatGrossDly_Byte3_WIDTH          3
#define D18F2x09C_x0000_0101_WrDatGrossDly_Byte3_MASK           0xe0000000

/// D18F2x09C_x0000_0101
typedef union {
  struct {                                                              ///<
    UINT32                                       WrDatFineDly_Byte0:5 ; ///<
    UINT32                                      WrDatGrossDly_Byte0:3 ; ///<
    UINT32                                       WrDatFineDly_Byte1:5 ; ///<
    UINT32                                      WrDatGrossDly_Byte1:3 ; ///<
    UINT32                                       WrDatFineDly_Byte2:5 ; ///<
    UINT32                                      WrDatGrossDly_Byte2:3 ; ///<
    UINT32                                       WrDatFineDly_Byte3:5 ; ///<
    UINT32                                      WrDatGrossDly_Byte3:3 ; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} D18F2x09C_x0000_0101_STRUCT;

// **** D18F2x09C_x0000_0102 Register Definition ****
// Address
#define D18F2x09C_x0000_0102_ADDRESS                            0x102

// Type
#define D18F2x09C_x0000_0102_TYPE                               TYPE_D18F2x09C
// Field Data
#define D18F2x09C_x0000_0102_WrDatFineDly_Byte4_OFFSET          0
#define D18F2x09C_x0000_0102_WrDatFineDly_Byte4_WIDTH           5
#define D18F2x09C_x0000_0102_WrDatFineDly_Byte4_MASK            0x1f
#define D18F2x09C_x0000_0102_WrDatGrossDly_Byte4_OFFSET         5
#define D18F2x09C_x0000_0102_WrDatGrossDly_Byte4_WIDTH          3
#define D18F2x09C_x0000_0102_WrDatGrossDly_Byte4_MASK           0xe0
#define D18F2x09C_x0000_0102_WrDatFineDly_Byte5_OFFSET          8
#define D18F2x09C_x0000_0102_WrDatFineDly_Byte5_WIDTH           5
#define D18F2x09C_x0000_0102_WrDatFineDly_Byte5_MASK            0x1f00
#define D18F2x09C_x0000_0102_WrDatGrossDly_Byte5_OFFSET         13
#define D18F2x09C_x0000_0102_WrDatGrossDly_Byte5_WIDTH          3
#define D18F2x09C_x0000_0102_WrDatGrossDly_Byte5_MASK           0xe000
#define D18F2x09C_x0000_0102_WrDatFineDly_Byte6_OFFSET          16
#define D18F2x09C_x0000_0102_WrDatFineDly_Byte6_WIDTH           5
#define D18F2x09C_x0000_0102_WrDatFineDly_Byte6_MASK            0x1f0000
#define D18F2x09C_x0000_0102_WrDatGrossDly_Byte6_OFFSET         21
#define D18F2x09C_x0000_0102_WrDatGrossDly_Byte6_WIDTH          3
#define D18F2x09C_x0000_0102_WrDatGrossDly_Byte6_MASK           0xe00000
#define D18F2x09C_x0000_0102_WrDatFineDly_Byte7_OFFSET          24
#define D18F2x09C_x0000_0102_WrDatFineDly_Byte7_WIDTH           5
#define D18F2x09C_x0000_0102_WrDatFineDly_Byte7_MASK            0x1f000000
#define D18F2x09C_x0000_0102_WrDatGrossDly_Byte7_OFFSET         29
#define D18F2x09C_x0000_0102_WrDatGrossDly_Byte7_WIDTH          3
#define D18F2x09C_x0000_0102_WrDatGrossDly_Byte7_MASK           0xe0000000

/// D18F2x09C_x0000_0102
typedef union {
  struct {                                                              ///<
    UINT32                                       WrDatFineDly_Byte4:5 ; ///<
    UINT32                                      WrDatGrossDly_Byte4:3 ; ///<
    UINT32                                       WrDatFineDly_Byte5:5 ; ///<
    UINT32                                      WrDatGrossDly_Byte5:3 ; ///<
    UINT32                                       WrDatFineDly_Byte6:5 ; ///<
    UINT32                                      WrDatGrossDly_Byte6:3 ; ///<
    UINT32                                       WrDatFineDly_Byte7:5 ; ///<
    UINT32                                      WrDatGrossDly_Byte7:3 ; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} D18F2x09C_x0000_0102_STRUCT;

// **** D18F2x09C_x0000_0105 Register Definition ****
// Address
#define D18F2x09C_x0000_0105_ADDRESS                            0x105

// Type
#define D18F2x09C_x0000_0105_TYPE                               TYPE_D18F2x09C
// Field Data
#define D18F2x09C_x0000_0105_Reserved_0_0_OFFSET                0
#define D18F2x09C_x0000_0105_Reserved_0_0_WIDTH                 1
#define D18F2x09C_x0000_0105_Reserved_0_0_MASK                  0x1
#define D18F2x09C_x0000_0105_RdDqsTime_Byte0_OFFSET             1
#define D18F2x09C_x0000_0105_RdDqsTime_Byte0_WIDTH              5
#define D18F2x09C_x0000_0105_RdDqsTime_Byte0_MASK               0x3e
#define D18F2x09C_x0000_0105_Reserved_8_6_OFFSET                6
#define D18F2x09C_x0000_0105_Reserved_8_6_WIDTH                 3
#define D18F2x09C_x0000_0105_Reserved_8_6_MASK                  0x1c0
#define D18F2x09C_x0000_0105_RdDqsTime_Byte1_OFFSET             9
#define D18F2x09C_x0000_0105_RdDqsTime_Byte1_WIDTH              5
#define D18F2x09C_x0000_0105_RdDqsTime_Byte1_MASK               0x3e00
#define D18F2x09C_x0000_0105_Reserved_16_14_OFFSET              14
#define D18F2x09C_x0000_0105_Reserved_16_14_WIDTH               3
#define D18F2x09C_x0000_0105_Reserved_16_14_MASK                0x1c000
#define D18F2x09C_x0000_0105_RdDqsTime_Byte2_OFFSET             17
#define D18F2x09C_x0000_0105_RdDqsTime_Byte2_WIDTH              5
#define D18F2x09C_x0000_0105_RdDqsTime_Byte2_MASK               0x3e0000
#define D18F2x09C_x0000_0105_Reserved_24_22_OFFSET              22
#define D18F2x09C_x0000_0105_Reserved_24_22_WIDTH               3
#define D18F2x09C_x0000_0105_Reserved_24_22_MASK                0x1c00000
#define D18F2x09C_x0000_0105_RdDqsTime_Byte3_OFFSET             25
#define D18F2x09C_x0000_0105_RdDqsTime_Byte3_WIDTH              5
#define D18F2x09C_x0000_0105_RdDqsTime_Byte3_MASK               0x3e000000
#define D18F2x09C_x0000_0105_Reserved_31_30_OFFSET              30
#define D18F2x09C_x0000_0105_Reserved_31_30_WIDTH               2
#define D18F2x09C_x0000_0105_Reserved_31_30_MASK                0xc0000000

/// D18F2x09C_x0000_0105
typedef union {
  struct {                                                              ///<
    UINT32                                             Reserved_0_0:1 ; ///<
    UINT32                                          RdDqsTime_Byte0:5 ; ///<
    UINT32                                             Reserved_8_6:3 ; ///<
    UINT32                                          RdDqsTime_Byte1:5 ; ///<
    UINT32                                           Reserved_16_14:3 ; ///<
    UINT32                                          RdDqsTime_Byte2:5 ; ///<
    UINT32                                           Reserved_24_22:3 ; ///<
    UINT32                                          RdDqsTime_Byte3:5 ; ///<
    UINT32                                           Reserved_31_30:2 ; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} D18F2x09C_x0000_0105_STRUCT;

// **** D18F2x09C_x0000_0106 Register Definition ****
// Address
#define D18F2x09C_x0000_0106_ADDRESS                            0x106

// Type
#define D18F2x09C_x0000_0106_TYPE                               TYPE_D18F2x09C
// Field Data
#define D18F2x09C_x0000_0106_Reserved_0_0_OFFSET                0
#define D18F2x09C_x0000_0106_Reserved_0_0_WIDTH                 1
#define D18F2x09C_x0000_0106_Reserved_0_0_MASK                  0x1
#define D18F2x09C_x0000_0106_RdDqsTime_Byte4_OFFSET             1
#define D18F2x09C_x0000_0106_RdDqsTime_Byte4_WIDTH              5
#define D18F2x09C_x0000_0106_RdDqsTime_Byte4_MASK               0x3e
#define D18F2x09C_x0000_0106_Reserved_8_6_OFFSET                6
#define D18F2x09C_x0000_0106_Reserved_8_6_WIDTH                 3
#define D18F2x09C_x0000_0106_Reserved_8_6_MASK                  0x1c0
#define D18F2x09C_x0000_0106_RdDqsTime_Byte5_OFFSET             9
#define D18F2x09C_x0000_0106_RdDqsTime_Byte5_WIDTH              5
#define D18F2x09C_x0000_0106_RdDqsTime_Byte5_MASK               0x3e00
#define D18F2x09C_x0000_0106_Reserved_16_14_OFFSET              14
#define D18F2x09C_x0000_0106_Reserved_16_14_WIDTH               3
#define D18F2x09C_x0000_0106_Reserved_16_14_MASK                0x1c000
#define D18F2x09C_x0000_0106_RdDqsTime_Byte6_OFFSET             17
#define D18F2x09C_x0000_0106_RdDqsTime_Byte6_WIDTH              5
#define D18F2x09C_x0000_0106_RdDqsTime_Byte6_MASK               0x3e0000
#define D18F2x09C_x0000_0106_Reserved_24_22_OFFSET              22
#define D18F2x09C_x0000_0106_Reserved_24_22_WIDTH               3
#define D18F2x09C_x0000_0106_Reserved_24_22_MASK                0x1c00000
#define D18F2x09C_x0000_0106_RdDqsTime_Byte7_OFFSET             25
#define D18F2x09C_x0000_0106_RdDqsTime_Byte7_WIDTH              5
#define D18F2x09C_x0000_0106_RdDqsTime_Byte7_MASK               0x3e000000
#define D18F2x09C_x0000_0106_Reserved_31_30_OFFSET              30
#define D18F2x09C_x0000_0106_Reserved_31_30_WIDTH               2
#define D18F2x09C_x0000_0106_Reserved_31_30_MASK                0xc0000000

/// D18F2x09C_x0000_0106
typedef union {
  struct {                                                              ///<
    UINT32                                             Reserved_0_0:1 ; ///<
    UINT32                                          RdDqsTime_Byte4:5 ; ///<
    UINT32                                             Reserved_8_6:3 ; ///<
    UINT32                                          RdDqsTime_Byte5:5 ; ///<
    UINT32                                           Reserved_16_14:3 ; ///<
    UINT32                                          RdDqsTime_Byte6:5 ; ///<
    UINT32                                           Reserved_24_22:3 ; ///<
    UINT32                                          RdDqsTime_Byte7:5 ; ///<
    UINT32                                           Reserved_31_30:2 ; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} D18F2x09C_x0000_0106_STRUCT;

// **** D18F2x09C_x0D0F_0002 Register Definition ****
// Address
#define D18F2x09C_x0D0F_0002_ADDRESS                            0xd0f0002

// Type
#define D18F2x09C_x0D0F_0002_TYPE                               TYPE_D18F2x09C
// Field Data
#define D18F2x09C_x0D0F_0002_TxPreN_OFFSET                      0
#define D18F2x09C_x0D0F_0002_TxPreN_WIDTH                       6
#define D18F2x09C_x0D0F_0002_TxPreN_MASK                        0x3f
#define D18F2x09C_x0D0F_0002_TxPreP_OFFSET                      6
#define D18F2x09C_x0D0F_0002_TxPreP_WIDTH                       6
#define D18F2x09C_x0D0F_0002_TxPreP_MASK                        0xfc0
#define D18F2x09C_x0D0F_0002_Reserved_14_12_OFFSET              12
#define D18F2x09C_x0D0F_0002_Reserved_14_12_WIDTH               3
#define D18F2x09C_x0D0F_0002_Reserved_14_12_MASK                0x7000
#define D18F2x09C_x0D0F_0002_ValidTxAndPre_OFFSET               15
#define D18F2x09C_x0D0F_0002_ValidTxAndPre_WIDTH                1
#define D18F2x09C_x0D0F_0002_ValidTxAndPre_MASK                 0x8000
#define D18F2x09C_x0D0F_0002_Reserved_31_16_OFFSET              16
#define D18F2x09C_x0D0F_0002_Reserved_31_16_WIDTH               16
#define D18F2x09C_x0D0F_0002_Reserved_31_16_MASK                0xffff0000

/// D18F2x09C_x0D0F_0002
typedef union {
  struct {                                                              ///<
    UINT32                                                   TxPreN:6 ; ///<
    UINT32                                                   TxPreP:6 ; ///<
    UINT32                                           Reserved_14_12:3 ; ///<
    UINT32                                            ValidTxAndPre:1 ; ///<
    UINT32                                           Reserved_31_16:16; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} D18F2x09C_x0D0F_0002_STRUCT;

// **** D18F2x09C_x0D0F_0006 Register Definition ****
// Address
#define D18F2x09C_x0D0F_0006_ADDRESS                            0xd0f0006

// Type
#define D18F2x09C_x0D0F_0006_TYPE                               TYPE_D18F2x09C
// Field Data
#define D18F2x09C_x0D0F_0006_TxPreN_OFFSET                      0
#define D18F2x09C_x0D0F_0006_TxPreN_WIDTH                       6
#define D18F2x09C_x0D0F_0006_TxPreN_MASK                        0x3f
#define D18F2x09C_x0D0F_0006_TxPreP_OFFSET                      6
#define D18F2x09C_x0D0F_0006_TxPreP_WIDTH                       6
#define D18F2x09C_x0D0F_0006_TxPreP_MASK                        0xfc0
#define D18F2x09C_x0D0F_0006_Reserved_31_12_OFFSET              12
#define D18F2x09C_x0D0F_0006_Reserved_31_12_WIDTH               20
#define D18F2x09C_x0D0F_0006_Reserved_31_12_MASK                0xfffff000

/// D18F2x09C_x0D0F_0006
typedef union {
  struct {                                                              ///<
    UINT32                                                   TxPreN:6 ; ///<
    UINT32                                                   TxPreP:6 ; ///<
    UINT32                                           Reserved_31_12:20; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} D18F2x09C_x0D0F_0006_STRUCT;

// **** D18F2x09C_x0D0F_000A Register Definition ****
// Address
#define D18F2x09C_x0D0F_000A_ADDRESS                            0xd0f000a

// Type
#define D18F2x09C_x0D0F_000A_TYPE                               TYPE_D18F2x09C
// Field Data
#define D18F2x09C_x0D0F_000A_TxPreN_OFFSET                      0
#define D18F2x09C_x0D0F_000A_TxPreN_WIDTH                       6
#define D18F2x09C_x0D0F_000A_TxPreN_MASK                        0x3f
#define D18F2x09C_x0D0F_000A_TxPreP_OFFSET                      6
#define D18F2x09C_x0D0F_000A_TxPreP_WIDTH                       6
#define D18F2x09C_x0D0F_000A_TxPreP_MASK                        0xfc0
#define D18F2x09C_x0D0F_000A_Reserved_31_12_OFFSET              12
#define D18F2x09C_x0D0F_000A_Reserved_31_12_WIDTH               20
#define D18F2x09C_x0D0F_000A_Reserved_31_12_MASK                0xfffff000

/// D18F2x09C_x0D0F_000A
typedef union {
  struct {                                                              ///<
    UINT32                                                   TxPreN:6 ; ///<
    UINT32                                                   TxPreP:6 ; ///<
    UINT32                                           Reserved_31_12:20; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} D18F2x09C_x0D0F_000A_STRUCT;

// **** D18F2x09C_x0D0F_000F Register Definition ****
// Address
#define D18F2x09C_x0D0F_000F_ADDRESS                            0xd0f000f

// Type
#define D18F2x09C_x0D0F_000F_TYPE                               TYPE_D18F2x09C
// Field Data
#define D18F2x09C_x0D0F_000F_Reserved_11_0_OFFSET               0
#define D18F2x09C_x0D0F_000F_Reserved_11_0_WIDTH                12
#define D18F2x09C_x0D0F_000F_Reserved_11_0_MASK                 0xfff
#define D18F2x09C_x0D0F_000F_AlwaysEnDllClks_OFFSET             12
#define D18F2x09C_x0D0F_000F_AlwaysEnDllClks_WIDTH              3
#define D18F2x09C_x0D0F_000F_AlwaysEnDllClks_MASK               0x7000
#define D18F2x09C_x0D0F_000F_Reserved_31_15_OFFSET              15
#define D18F2x09C_x0D0F_000F_Reserved_31_15_WIDTH               17
#define D18F2x09C_x0D0F_000F_Reserved_31_15_MASK                0xffff8000

/// D18F2x09C_x0D0F_000F
typedef union {
  struct {                                                              ///<
    UINT32                                            Reserved_11_0:12; ///<
    UINT32                                          AlwaysEnDllClks:3 ; ///<
    UINT32                                           Reserved_31_15:17; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} D18F2x09C_x0D0F_000F_STRUCT;

// **** D18F2x09C_x0D0F_0010 Register Definition ****
// Address
#define D18F2x09C_x0D0F_0010_ADDRESS                            0xd0f0010

// Type
#define D18F2x09C_x0D0F_0010_TYPE                               TYPE_D18F2x09C
// Field Data
#define D18F2x09C_x0D0F_0010_Reserved_11_0_OFFSET               0
#define D18F2x09C_x0D0F_0010_Reserved_11_0_WIDTH                12
#define D18F2x09C_x0D0F_0010_Reserved_11_0_MASK                 0xfff
#define D18F2x09C_x0D0F_0010_EnRxPadStandby_OFFSET              12
#define D18F2x09C_x0D0F_0010_EnRxPadStandby_WIDTH               1
#define D18F2x09C_x0D0F_0010_EnRxPadStandby_MASK                0x1000
#define D18F2x09C_x0D0F_0010_Reserved_31_13_OFFSET              13
#define D18F2x09C_x0D0F_0010_Reserved_31_13_WIDTH               19
#define D18F2x09C_x0D0F_0010_Reserved_31_13_MASK                0xffffe000

/// D18F2x09C_x0D0F_0010
typedef union {
  struct {                                                              ///<
    UINT32                                            Reserved_11_0:12; ///<
    UINT32                                           EnRxPadStandby:1 ; ///<
    UINT32                                           Reserved_31_13:19; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} D18F2x09C_x0D0F_0010_STRUCT;

// **** D18F2x09C_x0D0F_001F Register Definition ****
// Address
#define D18F2x09C_x0D0F_001F_ADDRESS                            0xd0f001f

// Type
#define D18F2x09C_x0D0F_001F_TYPE                               TYPE_D18F2x09C
// Field Data
#define D18F2x09C_x0D0F_001F_Reserved_2_0_OFFSET                0
#define D18F2x09C_x0D0F_001F_Reserved_2_0_WIDTH                 3
#define D18F2x09C_x0D0F_001F_Reserved_2_0_MASK                  0x7
#define D18F2x09C_x0D0F_001F_RxVioLvl_OFFSET                    3
#define D18F2x09C_x0D0F_001F_RxVioLvl_WIDTH                     2
#define D18F2x09C_x0D0F_001F_RxVioLvl_MASK                      0x18
#define D18F2x09C_x0D0F_001F_Reserved_31_5_OFFSET               5
#define D18F2x09C_x0D0F_001F_Reserved_31_5_WIDTH                27
#define D18F2x09C_x0D0F_001F_Reserved_31_5_MASK                 0xffffffe0

/// D18F2x09C_x0D0F_001F
typedef union {
  struct {                                                              ///<
    UINT32                                             Reserved_2_0:3 ; ///<
    UINT32                                                 RxVioLvl:2 ; ///<
    UINT32                                            Reserved_31_5:27; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} D18F2x09C_x0D0F_001F_STRUCT;

// **** D18F2x09C_x0D0F_0030 Register Definition ****
// Address
#define D18F2x09C_x0D0F_0030_ADDRESS                            0xd0f0030

// Type
#define D18F2x09C_x0D0F_0030_TYPE                               TYPE_D18F2x09C
// Field Data
#define D18F2x09C_x0D0F_0030_Reserved_4_0_OFFSET                0
#define D18F2x09C_x0D0F_0030_Reserved_4_0_WIDTH                 5
#define D18F2x09C_x0D0F_0030_Reserved_4_0_MASK                  0x1f
#define D18F2x09C_x0D0F_0030_PchgPdTxCClkGateDis_OFFSET         5
#define D18F2x09C_x0D0F_0030_PchgPdTxCClkGateDis_WIDTH          1
#define D18F2x09C_x0D0F_0030_PchgPdTxCClkGateDis_MASK           0x20
#define D18F2x09C_x0D0F_0030_Reserved_31_6_OFFSET               6
#define D18F2x09C_x0D0F_0030_Reserved_31_6_WIDTH                26
#define D18F2x09C_x0D0F_0030_Reserved_31_6_MASK                 0xffffffc0

/// D18F2x09C_x0D0F_0030
typedef union {
  struct {                                                              ///<
    UINT32                                             Reserved_4_0:5 ; ///<
    UINT32                                      PchgPdTxCClkGateDis:1 ; ///<
    UINT32                                            Reserved_31_6:26; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} D18F2x09C_x0D0F_0030_STRUCT;

// **** D18F2x09C_x0D0F_0031 Register Definition ****
// Address
#define D18F2x09C_x0D0F_0031_ADDRESS                            0xd0f0031

// Type
#define D18F2x09C_x0D0F_0031_TYPE                               TYPE_D18F2x09C
// Field Data
#define D18F2x09C_x0D0F_0031_Fence2ThresholdTxPad_OFFSET        0
#define D18F2x09C_x0D0F_0031_Fence2ThresholdTxPad_WIDTH         4
#define D18F2x09C_x0D0F_0031_Fence2ThresholdTxPad_MASK          0xf
#define D18F2x09C_x0D0F_0031_Fence2EnableTxPad_OFFSET           4
#define D18F2x09C_x0D0F_0031_Fence2EnableTxPad_WIDTH            1
#define D18F2x09C_x0D0F_0031_Fence2EnableTxPad_MASK             0x10
#define D18F2x09C_x0D0F_0031_Fence2ThresholdTxDll_OFFSET        5
#define D18F2x09C_x0D0F_0031_Fence2ThresholdTxDll_WIDTH         4
#define D18F2x09C_x0D0F_0031_Fence2ThresholdTxDll_MASK          0x1e0
#define D18F2x09C_x0D0F_0031_Fence2EnableTxDll_OFFSET           9
#define D18F2x09C_x0D0F_0031_Fence2EnableTxDll_WIDTH            1
#define D18F2x09C_x0D0F_0031_Fence2EnableTxDll_MASK             0x200
#define D18F2x09C_x0D0F_0031_Fence2ThresholdRxDll_OFFSET        10
#define D18F2x09C_x0D0F_0031_Fence2ThresholdRxDll_WIDTH         4
#define D18F2x09C_x0D0F_0031_Fence2ThresholdRxDll_MASK          0x3c00
#define D18F2x09C_x0D0F_0031_Fence2EnableRxDll_OFFSET           14
#define D18F2x09C_x0D0F_0031_Fence2EnableRxDll_WIDTH            1
#define D18F2x09C_x0D0F_0031_Fence2EnableRxDll_MASK             0x4000
#define D18F2x09C_x0D0F_0031_Reserved_31_15_OFFSET              15
#define D18F2x09C_x0D0F_0031_Reserved_31_15_WIDTH               17
#define D18F2x09C_x0D0F_0031_Reserved_31_15_MASK                0xffff8000

/// D18F2x09C_x0D0F_0031
typedef union {
  struct {                                                              ///<
    UINT32                                     Fence2ThresholdTxPad:4 ; ///<
    UINT32                                        Fence2EnableTxPad:1 ; ///<
    UINT32                                     Fence2ThresholdTxDll:4 ; ///<
    UINT32                                        Fence2EnableTxDll:1 ; ///<
    UINT32                                     Fence2ThresholdRxDll:4 ; ///<
    UINT32                                        Fence2EnableRxDll:1 ; ///<
    UINT32                                           Reserved_31_15:17; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} D18F2x09C_x0D0F_0031_STRUCT;

// **** D18F2x09C_x0D0F_0102 Register Definition ****
// Address
#define D18F2x09C_x0D0F_0102_ADDRESS                            0xd0f0102

// Type
#define D18F2x09C_x0D0F_0102_TYPE                               TYPE_D18F2x09C
// Field Data
#define D18F2x09C_x0D0F_0102_TxPreN_OFFSET                      0
#define D18F2x09C_x0D0F_0102_TxPreN_WIDTH                       6
#define D18F2x09C_x0D0F_0102_TxPreN_MASK                        0x3f
#define D18F2x09C_x0D0F_0102_TxPreP_OFFSET                      6
#define D18F2x09C_x0D0F_0102_TxPreP_WIDTH                       6
#define D18F2x09C_x0D0F_0102_TxPreP_MASK                        0xfc0
#define D18F2x09C_x0D0F_0102_Reserved_14_12_OFFSET              12
#define D18F2x09C_x0D0F_0102_Reserved_14_12_WIDTH               3
#define D18F2x09C_x0D0F_0102_Reserved_14_12_MASK                0x7000
#define D18F2x09C_x0D0F_0102_ValidTxAndPre_OFFSET               15
#define D18F2x09C_x0D0F_0102_ValidTxAndPre_WIDTH                1
#define D18F2x09C_x0D0F_0102_ValidTxAndPre_MASK                 0x8000
#define D18F2x09C_x0D0F_0102_Reserved_31_16_OFFSET              16
#define D18F2x09C_x0D0F_0102_Reserved_31_16_WIDTH               16
#define D18F2x09C_x0D0F_0102_Reserved_31_16_MASK                0xffff0000

/// D18F2x09C_x0D0F_0102
typedef union {
  struct {                                                              ///<
    UINT32                                                   TxPreN:6 ; ///<
    UINT32                                                   TxPreP:6 ; ///<
    UINT32                                           Reserved_14_12:3 ; ///<
    UINT32                                            ValidTxAndPre:1 ; ///<
    UINT32                                           Reserved_31_16:16; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} D18F2x09C_x0D0F_0102_STRUCT;

// **** D18F2x09C_x0D0F_0106 Register Definition ****
// Address
#define D18F2x09C_x0D0F_0106_ADDRESS                            0xd0f0106

// Type
#define D18F2x09C_x0D0F_0106_TYPE                               TYPE_D18F2x09C
// Field Data
#define D18F2x09C_x0D0F_0106_TxPreN_OFFSET                      0
#define D18F2x09C_x0D0F_0106_TxPreN_WIDTH                       6
#define D18F2x09C_x0D0F_0106_TxPreN_MASK                        0x3f
#define D18F2x09C_x0D0F_0106_TxPreP_OFFSET                      6
#define D18F2x09C_x0D0F_0106_TxPreP_WIDTH                       6
#define D18F2x09C_x0D0F_0106_TxPreP_MASK                        0xfc0
#define D18F2x09C_x0D0F_0106_Reserved_31_12_OFFSET              12
#define D18F2x09C_x0D0F_0106_Reserved_31_12_WIDTH               20
#define D18F2x09C_x0D0F_0106_Reserved_31_12_MASK                0xfffff000

/// D18F2x09C_x0D0F_0106
typedef union {
  struct {                                                              ///<
    UINT32                                                   TxPreN:6 ; ///<
    UINT32                                                   TxPreP:6 ; ///<
    UINT32                                           Reserved_31_12:20; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} D18F2x09C_x0D0F_0106_STRUCT;

// **** D18F2x09C_x0D0F_010A Register Definition ****
// Address
#define D18F2x09C_x0D0F_010A_ADDRESS                            0xd0f010a

// Type
#define D18F2x09C_x0D0F_010A_TYPE                               TYPE_D18F2x09C
// Field Data
#define D18F2x09C_x0D0F_010A_TxPreN_OFFSET                      0
#define D18F2x09C_x0D0F_010A_TxPreN_WIDTH                       6
#define D18F2x09C_x0D0F_010A_TxPreN_MASK                        0x3f
#define D18F2x09C_x0D0F_010A_TxPreP_OFFSET                      6
#define D18F2x09C_x0D0F_010A_TxPreP_WIDTH                       6
#define D18F2x09C_x0D0F_010A_TxPreP_MASK                        0xfc0
#define D18F2x09C_x0D0F_010A_Reserved_31_12_OFFSET              12
#define D18F2x09C_x0D0F_010A_Reserved_31_12_WIDTH               20
#define D18F2x09C_x0D0F_010A_Reserved_31_12_MASK                0xfffff000

/// D18F2x09C_x0D0F_010A
typedef union {
  struct {                                                              ///<
    UINT32                                                   TxPreN:6 ; ///<
    UINT32                                                   TxPreP:6 ; ///<
    UINT32                                           Reserved_31_12:20; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} D18F2x09C_x0D0F_010A_STRUCT;

// **** D18F2x09C_x0D0F_010F Register Definition ****
// Address
#define D18F2x09C_x0D0F_010F_ADDRESS                            0xd0f010f

// Type
#define D18F2x09C_x0D0F_010F_TYPE                               TYPE_D18F2x09C
// Field Data
#define D18F2x09C_x0D0F_010F_Reserved_11_0_OFFSET               0
#define D18F2x09C_x0D0F_010F_Reserved_11_0_WIDTH                12
#define D18F2x09C_x0D0F_010F_Reserved_11_0_MASK                 0xfff
#define D18F2x09C_x0D0F_010F_AlwaysEnDllClks_OFFSET             12
#define D18F2x09C_x0D0F_010F_AlwaysEnDllClks_WIDTH              3
#define D18F2x09C_x0D0F_010F_AlwaysEnDllClks_MASK               0x7000
#define D18F2x09C_x0D0F_010F_Reserved_31_15_OFFSET              15
#define D18F2x09C_x0D0F_010F_Reserved_31_15_WIDTH               17
#define D18F2x09C_x0D0F_010F_Reserved_31_15_MASK                0xffff8000

/// D18F2x09C_x0D0F_010F
typedef union {
  struct {                                                              ///<
    UINT32                                            Reserved_11_0:12; ///<
    UINT32                                          AlwaysEnDllClks:3 ; ///<
    UINT32                                           Reserved_31_15:17; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} D18F2x09C_x0D0F_010F_STRUCT;

// **** D18F2x09C_x0D0F_0110 Register Definition ****
// Address
#define D18F2x09C_x0D0F_0110_ADDRESS                            0xd0f0110

// Type
#define D18F2x09C_x0D0F_0110_TYPE                               TYPE_D18F2x09C
// Field Data
#define D18F2x09C_x0D0F_0110_Reserved_11_0_OFFSET               0
#define D18F2x09C_x0D0F_0110_Reserved_11_0_WIDTH                12
#define D18F2x09C_x0D0F_0110_Reserved_11_0_MASK                 0xfff
#define D18F2x09C_x0D0F_0110_EnRxPadStandby_OFFSET              12
#define D18F2x09C_x0D0F_0110_EnRxPadStandby_WIDTH               1
#define D18F2x09C_x0D0F_0110_EnRxPadStandby_MASK                0x1000
#define D18F2x09C_x0D0F_0110_Reserved_31_13_OFFSET              13
#define D18F2x09C_x0D0F_0110_Reserved_31_13_WIDTH               19
#define D18F2x09C_x0D0F_0110_Reserved_31_13_MASK                0xffffe000

/// D18F2x09C_x0D0F_0110
typedef union {
  struct {                                                              ///<
    UINT32                                            Reserved_11_0:12; ///<
    UINT32                                           EnRxPadStandby:1 ; ///<
    UINT32                                           Reserved_31_13:19; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} D18F2x09C_x0D0F_0110_STRUCT;

// **** D18F2x09C_x0D0F_011F Register Definition ****
// Address
#define D18F2x09C_x0D0F_011F_ADDRESS                            0xd0f011f

// Type
#define D18F2x09C_x0D0F_011F_TYPE                               TYPE_D18F2x09C
// Field Data
#define D18F2x09C_x0D0F_011F_Reserved_2_0_OFFSET                0
#define D18F2x09C_x0D0F_011F_Reserved_2_0_WIDTH                 3
#define D18F2x09C_x0D0F_011F_Reserved_2_0_MASK                  0x7
#define D18F2x09C_x0D0F_011F_RxVioLvl_OFFSET                    3
#define D18F2x09C_x0D0F_011F_RxVioLvl_WIDTH                     2
#define D18F2x09C_x0D0F_011F_RxVioLvl_MASK                      0x18
#define D18F2x09C_x0D0F_011F_Reserved_31_5_OFFSET               5
#define D18F2x09C_x0D0F_011F_Reserved_31_5_WIDTH                27
#define D18F2x09C_x0D0F_011F_Reserved_31_5_MASK                 0xffffffe0

/// D18F2x09C_x0D0F_011F
typedef union {
  struct {                                                              ///<
    UINT32                                             Reserved_2_0:3 ; ///<
    UINT32                                                 RxVioLvl:2 ; ///<
    UINT32                                            Reserved_31_5:27; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} D18F2x09C_x0D0F_011F_STRUCT;

// **** D18F2x09C_x0D0F_0130 Register Definition ****
// Address
#define D18F2x09C_x0D0F_0130_ADDRESS                            0xd0f0130

// Type
#define D18F2x09C_x0D0F_0130_TYPE                               TYPE_D18F2x09C
// Field Data
#define D18F2x09C_x0D0F_0130_Reserved_4_0_OFFSET                0
#define D18F2x09C_x0D0F_0130_Reserved_4_0_WIDTH                 5
#define D18F2x09C_x0D0F_0130_Reserved_4_0_MASK                  0x1f
#define D18F2x09C_x0D0F_0130_PchgPdTxCClkGateDis_OFFSET         5
#define D18F2x09C_x0D0F_0130_PchgPdTxCClkGateDis_WIDTH          1
#define D18F2x09C_x0D0F_0130_PchgPdTxCClkGateDis_MASK           0x20
#define D18F2x09C_x0D0F_0130_Reserved_31_6_OFFSET               6
#define D18F2x09C_x0D0F_0130_Reserved_31_6_WIDTH                26
#define D18F2x09C_x0D0F_0130_Reserved_31_6_MASK                 0xffffffc0

/// D18F2x09C_x0D0F_0130
typedef union {
  struct {                                                              ///<
    UINT32                                             Reserved_4_0:5 ; ///<
    UINT32                                      PchgPdTxCClkGateDis:1 ; ///<
    UINT32                                            Reserved_31_6:26; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} D18F2x09C_x0D0F_0130_STRUCT;

// **** D18F2x09C_x0D0F_0131 Register Definition ****
// Address
#define D18F2x09C_x0D0F_0131_ADDRESS                            0xd0f0131

// Type
#define D18F2x09C_x0D0F_0131_TYPE                               TYPE_D18F2x09C
// Field Data
#define D18F2x09C_x0D0F_0131_Fence2ThresholdTxPad_OFFSET        0
#define D18F2x09C_x0D0F_0131_Fence2ThresholdTxPad_WIDTH         4
#define D18F2x09C_x0D0F_0131_Fence2ThresholdTxPad_MASK          0xf
#define D18F2x09C_x0D0F_0131_Fence2EnableTxPad_OFFSET           4
#define D18F2x09C_x0D0F_0131_Fence2EnableTxPad_WIDTH            1
#define D18F2x09C_x0D0F_0131_Fence2EnableTxPad_MASK             0x10
#define D18F2x09C_x0D0F_0131_Fence2ThresholdTxDll_OFFSET        5
#define D18F2x09C_x0D0F_0131_Fence2ThresholdTxDll_WIDTH         4
#define D18F2x09C_x0D0F_0131_Fence2ThresholdTxDll_MASK          0x1e0
#define D18F2x09C_x0D0F_0131_Fence2EnableTxDll_OFFSET           9
#define D18F2x09C_x0D0F_0131_Fence2EnableTxDll_WIDTH            1
#define D18F2x09C_x0D0F_0131_Fence2EnableTxDll_MASK             0x200
#define D18F2x09C_x0D0F_0131_Fence2ThresholdRxDll_OFFSET        10
#define D18F2x09C_x0D0F_0131_Fence2ThresholdRxDll_WIDTH         4
#define D18F2x09C_x0D0F_0131_Fence2ThresholdRxDll_MASK          0x3c00
#define D18F2x09C_x0D0F_0131_Fence2EnableRxDll_OFFSET           14
#define D18F2x09C_x0D0F_0131_Fence2EnableRxDll_WIDTH            1
#define D18F2x09C_x0D0F_0131_Fence2EnableRxDll_MASK             0x4000
#define D18F2x09C_x0D0F_0131_Reserved_31_15_OFFSET              15
#define D18F2x09C_x0D0F_0131_Reserved_31_15_WIDTH               17
#define D18F2x09C_x0D0F_0131_Reserved_31_15_MASK                0xffff8000

/// D18F2x09C_x0D0F_0131
typedef union {
  struct {                                                              ///<
    UINT32                                     Fence2ThresholdTxPad:4 ; ///<
    UINT32                                        Fence2EnableTxPad:1 ; ///<
    UINT32                                     Fence2ThresholdTxDll:4 ; ///<
    UINT32                                        Fence2EnableTxDll:1 ; ///<
    UINT32                                     Fence2ThresholdRxDll:4 ; ///<
    UINT32                                        Fence2EnableRxDll:1 ; ///<
    UINT32                                           Reserved_31_15:17; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} D18F2x09C_x0D0F_0131_STRUCT;

// **** D18F2x09C_x0D0F_0202 Register Definition ****
// Address
#define D18F2x09C_x0D0F_0202_ADDRESS                            0xd0f0202

// Type
#define D18F2x09C_x0D0F_0202_TYPE                               TYPE_D18F2x09C
// Field Data
#define D18F2x09C_x0D0F_0202_TxPreN_OFFSET                      0
#define D18F2x09C_x0D0F_0202_TxPreN_WIDTH                       6
#define D18F2x09C_x0D0F_0202_TxPreN_MASK                        0x3f
#define D18F2x09C_x0D0F_0202_TxPreP_OFFSET                      6
#define D18F2x09C_x0D0F_0202_TxPreP_WIDTH                       6
#define D18F2x09C_x0D0F_0202_TxPreP_MASK                        0xfc0
#define D18F2x09C_x0D0F_0202_Reserved_14_12_OFFSET              12
#define D18F2x09C_x0D0F_0202_Reserved_14_12_WIDTH               3
#define D18F2x09C_x0D0F_0202_Reserved_14_12_MASK                0x7000
#define D18F2x09C_x0D0F_0202_ValidTxAndPre_OFFSET               15
#define D18F2x09C_x0D0F_0202_ValidTxAndPre_WIDTH                1
#define D18F2x09C_x0D0F_0202_ValidTxAndPre_MASK                 0x8000
#define D18F2x09C_x0D0F_0202_Reserved_31_16_OFFSET              16
#define D18F2x09C_x0D0F_0202_Reserved_31_16_WIDTH               16
#define D18F2x09C_x0D0F_0202_Reserved_31_16_MASK                0xffff0000

/// D18F2x09C_x0D0F_0202
typedef union {
  struct {                                                              ///<
    UINT32                                                   TxPreN:6 ; ///<
    UINT32                                                   TxPreP:6 ; ///<
    UINT32                                           Reserved_14_12:3 ; ///<
    UINT32                                            ValidTxAndPre:1 ; ///<
    UINT32                                           Reserved_31_16:16; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} D18F2x09C_x0D0F_0202_STRUCT;

// **** D18F2x09C_x0D0F_0206 Register Definition ****
// Address
#define D18F2x09C_x0D0F_0206_ADDRESS                            0xd0f0206

// Type
#define D18F2x09C_x0D0F_0206_TYPE                               TYPE_D18F2x09C
// Field Data
#define D18F2x09C_x0D0F_0206_TxPreN_OFFSET                      0
#define D18F2x09C_x0D0F_0206_TxPreN_WIDTH                       6
#define D18F2x09C_x0D0F_0206_TxPreN_MASK                        0x3f
#define D18F2x09C_x0D0F_0206_TxPreP_OFFSET                      6
#define D18F2x09C_x0D0F_0206_TxPreP_WIDTH                       6
#define D18F2x09C_x0D0F_0206_TxPreP_MASK                        0xfc0
#define D18F2x09C_x0D0F_0206_Reserved_31_12_OFFSET              12
#define D18F2x09C_x0D0F_0206_Reserved_31_12_WIDTH               20
#define D18F2x09C_x0D0F_0206_Reserved_31_12_MASK                0xfffff000

/// D18F2x09C_x0D0F_0206
typedef union {
  struct {                                                              ///<
    UINT32                                                   TxPreN:6 ; ///<
    UINT32                                                   TxPreP:6 ; ///<
    UINT32                                           Reserved_31_12:20; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} D18F2x09C_x0D0F_0206_STRUCT;

// **** D18F2x09C_x0D0F_020A Register Definition ****
// Address
#define D18F2x09C_x0D0F_020A_ADDRESS                            0xd0f020a

// Type
#define D18F2x09C_x0D0F_020A_TYPE                               TYPE_D18F2x09C
// Field Data
#define D18F2x09C_x0D0F_020A_TxPreN_OFFSET                      0
#define D18F2x09C_x0D0F_020A_TxPreN_WIDTH                       6
#define D18F2x09C_x0D0F_020A_TxPreN_MASK                        0x3f
#define D18F2x09C_x0D0F_020A_TxPreP_OFFSET                      6
#define D18F2x09C_x0D0F_020A_TxPreP_WIDTH                       6
#define D18F2x09C_x0D0F_020A_TxPreP_MASK                        0xfc0
#define D18F2x09C_x0D0F_020A_Reserved_31_12_OFFSET              12
#define D18F2x09C_x0D0F_020A_Reserved_31_12_WIDTH               20
#define D18F2x09C_x0D0F_020A_Reserved_31_12_MASK                0xfffff000

/// D18F2x09C_x0D0F_020A
typedef union {
  struct {                                                              ///<
    UINT32                                                   TxPreN:6 ; ///<
    UINT32                                                   TxPreP:6 ; ///<
    UINT32                                           Reserved_31_12:20; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} D18F2x09C_x0D0F_020A_STRUCT;

// **** D18F2x09C_x0D0F_020F Register Definition ****
// Address
#define D18F2x09C_x0D0F_020F_ADDRESS                            0xd0f020f

// Type
#define D18F2x09C_x0D0F_020F_TYPE                               TYPE_D18F2x09C
// Field Data
#define D18F2x09C_x0D0F_020F_Reserved_11_0_OFFSET               0
#define D18F2x09C_x0D0F_020F_Reserved_11_0_WIDTH                12
#define D18F2x09C_x0D0F_020F_Reserved_11_0_MASK                 0xfff
#define D18F2x09C_x0D0F_020F_AlwaysEnDllClks_OFFSET             12
#define D18F2x09C_x0D0F_020F_AlwaysEnDllClks_WIDTH              3
#define D18F2x09C_x0D0F_020F_AlwaysEnDllClks_MASK               0x7000
#define D18F2x09C_x0D0F_020F_Reserved_31_15_OFFSET              15
#define D18F2x09C_x0D0F_020F_Reserved_31_15_WIDTH               17
#define D18F2x09C_x0D0F_020F_Reserved_31_15_MASK                0xffff8000

/// D18F2x09C_x0D0F_020F
typedef union {
  struct {                                                              ///<
    UINT32                                            Reserved_11_0:12; ///<
    UINT32                                          AlwaysEnDllClks:3 ; ///<
    UINT32                                           Reserved_31_15:17; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} D18F2x09C_x0D0F_020F_STRUCT;

// **** D18F2x09C_x0D0F_0210 Register Definition ****
// Address
#define D18F2x09C_x0D0F_0210_ADDRESS                            0xd0f0210

// Type
#define D18F2x09C_x0D0F_0210_TYPE                               TYPE_D18F2x09C
// Field Data
#define D18F2x09C_x0D0F_0210_Reserved_11_0_OFFSET               0
#define D18F2x09C_x0D0F_0210_Reserved_11_0_WIDTH                12
#define D18F2x09C_x0D0F_0210_Reserved_11_0_MASK                 0xfff
#define D18F2x09C_x0D0F_0210_EnRxPadStandby_OFFSET              12
#define D18F2x09C_x0D0F_0210_EnRxPadStandby_WIDTH               1
#define D18F2x09C_x0D0F_0210_EnRxPadStandby_MASK                0x1000
#define D18F2x09C_x0D0F_0210_Reserved_31_13_OFFSET              13
#define D18F2x09C_x0D0F_0210_Reserved_31_13_WIDTH               19
#define D18F2x09C_x0D0F_0210_Reserved_31_13_MASK                0xffffe000

/// D18F2x09C_x0D0F_0210
typedef union {
  struct {                                                              ///<
    UINT32                                            Reserved_11_0:12; ///<
    UINT32                                           EnRxPadStandby:1 ; ///<
    UINT32                                           Reserved_31_13:19; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} D18F2x09C_x0D0F_0210_STRUCT;

// **** D18F2x09C_x0D0F_021F Register Definition ****
// Address
#define D18F2x09C_x0D0F_021F_ADDRESS                            0xd0f021f

// Type
#define D18F2x09C_x0D0F_021F_TYPE                               TYPE_D18F2x09C
// Field Data
#define D18F2x09C_x0D0F_021F_Reserved_2_0_OFFSET                0
#define D18F2x09C_x0D0F_021F_Reserved_2_0_WIDTH                 3
#define D18F2x09C_x0D0F_021F_Reserved_2_0_MASK                  0x7
#define D18F2x09C_x0D0F_021F_RxVioLvl_OFFSET                    3
#define D18F2x09C_x0D0F_021F_RxVioLvl_WIDTH                     2
#define D18F2x09C_x0D0F_021F_RxVioLvl_MASK                      0x18
#define D18F2x09C_x0D0F_021F_Reserved_31_5_OFFSET               5
#define D18F2x09C_x0D0F_021F_Reserved_31_5_WIDTH                27
#define D18F2x09C_x0D0F_021F_Reserved_31_5_MASK                 0xffffffe0

/// D18F2x09C_x0D0F_021F
typedef union {
  struct {                                                              ///<
    UINT32                                             Reserved_2_0:3 ; ///<
    UINT32                                                 RxVioLvl:2 ; ///<
    UINT32                                            Reserved_31_5:27; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} D18F2x09C_x0D0F_021F_STRUCT;

// **** D18F2x09C_x0D0F_0230 Register Definition ****
// Address
#define D18F2x09C_x0D0F_0230_ADDRESS                            0xd0f0230

// Type
#define D18F2x09C_x0D0F_0230_TYPE                               TYPE_D18F2x09C
// Field Data
#define D18F2x09C_x0D0F_0230_Reserved_4_0_OFFSET                0
#define D18F2x09C_x0D0F_0230_Reserved_4_0_WIDTH                 5
#define D18F2x09C_x0D0F_0230_Reserved_4_0_MASK                  0x1f
#define D18F2x09C_x0D0F_0230_PchgPdTxCClkGateDis_OFFSET         5
#define D18F2x09C_x0D0F_0230_PchgPdTxCClkGateDis_WIDTH          1
#define D18F2x09C_x0D0F_0230_PchgPdTxCClkGateDis_MASK           0x20
#define D18F2x09C_x0D0F_0230_Reserved_31_6_OFFSET               6
#define D18F2x09C_x0D0F_0230_Reserved_31_6_WIDTH                26
#define D18F2x09C_x0D0F_0230_Reserved_31_6_MASK                 0xffffffc0

/// D18F2x09C_x0D0F_0230
typedef union {
  struct {                                                              ///<
    UINT32                                             Reserved_4_0:5 ; ///<
    UINT32                                      PchgPdTxCClkGateDis:1 ; ///<
    UINT32                                            Reserved_31_6:26; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} D18F2x09C_x0D0F_0230_STRUCT;

// **** D18F2x09C_x0D0F_0231 Register Definition ****
// Address
#define D18F2x09C_x0D0F_0231_ADDRESS                            0xd0f0231

// Type
#define D18F2x09C_x0D0F_0231_TYPE                               TYPE_D18F2x09C
// Field Data
#define D18F2x09C_x0D0F_0231_Fence2ThresholdTxPad_OFFSET        0
#define D18F2x09C_x0D0F_0231_Fence2ThresholdTxPad_WIDTH         4
#define D18F2x09C_x0D0F_0231_Fence2ThresholdTxPad_MASK          0xf
#define D18F2x09C_x0D0F_0231_Fence2EnableTxPad_OFFSET           4
#define D18F2x09C_x0D0F_0231_Fence2EnableTxPad_WIDTH            1
#define D18F2x09C_x0D0F_0231_Fence2EnableTxPad_MASK             0x10
#define D18F2x09C_x0D0F_0231_Fence2ThresholdTxDll_OFFSET        5
#define D18F2x09C_x0D0F_0231_Fence2ThresholdTxDll_WIDTH         4
#define D18F2x09C_x0D0F_0231_Fence2ThresholdTxDll_MASK          0x1e0
#define D18F2x09C_x0D0F_0231_Fence2EnableTxDll_OFFSET           9
#define D18F2x09C_x0D0F_0231_Fence2EnableTxDll_WIDTH            1
#define D18F2x09C_x0D0F_0231_Fence2EnableTxDll_MASK             0x200
#define D18F2x09C_x0D0F_0231_Fence2ThresholdRxDll_OFFSET        10
#define D18F2x09C_x0D0F_0231_Fence2ThresholdRxDll_WIDTH         4
#define D18F2x09C_x0D0F_0231_Fence2ThresholdRxDll_MASK          0x3c00
#define D18F2x09C_x0D0F_0231_Fence2EnableRxDll_OFFSET           14
#define D18F2x09C_x0D0F_0231_Fence2EnableRxDll_WIDTH            1
#define D18F2x09C_x0D0F_0231_Fence2EnableRxDll_MASK             0x4000
#define D18F2x09C_x0D0F_0231_Reserved_31_15_OFFSET              15
#define D18F2x09C_x0D0F_0231_Reserved_31_15_WIDTH               17
#define D18F2x09C_x0D0F_0231_Reserved_31_15_MASK                0xffff8000

/// D18F2x09C_x0D0F_0231
typedef union {
  struct {                                                              ///<
    UINT32                                     Fence2ThresholdTxPad:4 ; ///<
    UINT32                                        Fence2EnableTxPad:1 ; ///<
    UINT32                                     Fence2ThresholdTxDll:4 ; ///<
    UINT32                                        Fence2EnableTxDll:1 ; ///<
    UINT32                                     Fence2ThresholdRxDll:4 ; ///<
    UINT32                                        Fence2EnableRxDll:1 ; ///<
    UINT32                                           Reserved_31_15:17; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} D18F2x09C_x0D0F_0231_STRUCT;

// **** D18F2x09C_x0D0F_0302 Register Definition ****
// Address
#define D18F2x09C_x0D0F_0302_ADDRESS                            0xd0f0302

// Type
#define D18F2x09C_x0D0F_0302_TYPE                               TYPE_D18F2x09C
// Field Data
#define D18F2x09C_x0D0F_0302_TxPreN_OFFSET                      0
#define D18F2x09C_x0D0F_0302_TxPreN_WIDTH                       6
#define D18F2x09C_x0D0F_0302_TxPreN_MASK                        0x3f
#define D18F2x09C_x0D0F_0302_TxPreP_OFFSET                      6
#define D18F2x09C_x0D0F_0302_TxPreP_WIDTH                       6
#define D18F2x09C_x0D0F_0302_TxPreP_MASK                        0xfc0
#define D18F2x09C_x0D0F_0302_Reserved_14_12_OFFSET              12
#define D18F2x09C_x0D0F_0302_Reserved_14_12_WIDTH               3
#define D18F2x09C_x0D0F_0302_Reserved_14_12_MASK                0x7000
#define D18F2x09C_x0D0F_0302_ValidTxAndPre_OFFSET               15
#define D18F2x09C_x0D0F_0302_ValidTxAndPre_WIDTH                1
#define D18F2x09C_x0D0F_0302_ValidTxAndPre_MASK                 0x8000
#define D18F2x09C_x0D0F_0302_Reserved_31_16_OFFSET              16
#define D18F2x09C_x0D0F_0302_Reserved_31_16_WIDTH               16
#define D18F2x09C_x0D0F_0302_Reserved_31_16_MASK                0xffff0000

/// D18F2x09C_x0D0F_0302
typedef union {
  struct {                                                              ///<
    UINT32                                                   TxPreN:6 ; ///<
    UINT32                                                   TxPreP:6 ; ///<
    UINT32                                           Reserved_14_12:3 ; ///<
    UINT32                                            ValidTxAndPre:1 ; ///<
    UINT32                                           Reserved_31_16:16; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} D18F2x09C_x0D0F_0302_STRUCT;

// **** D18F2x09C_x0D0F_0306 Register Definition ****
// Address
#define D18F2x09C_x0D0F_0306_ADDRESS                            0xd0f0306

// Type
#define D18F2x09C_x0D0F_0306_TYPE                               TYPE_D18F2x09C
// Field Data
#define D18F2x09C_x0D0F_0306_TxPreN_OFFSET                      0
#define D18F2x09C_x0D0F_0306_TxPreN_WIDTH                       6
#define D18F2x09C_x0D0F_0306_TxPreN_MASK                        0x3f
#define D18F2x09C_x0D0F_0306_TxPreP_OFFSET                      6
#define D18F2x09C_x0D0F_0306_TxPreP_WIDTH                       6
#define D18F2x09C_x0D0F_0306_TxPreP_MASK                        0xfc0
#define D18F2x09C_x0D0F_0306_Reserved_31_12_OFFSET              12
#define D18F2x09C_x0D0F_0306_Reserved_31_12_WIDTH               20
#define D18F2x09C_x0D0F_0306_Reserved_31_12_MASK                0xfffff000

/// D18F2x09C_x0D0F_0306
typedef union {
  struct {                                                              ///<
    UINT32                                                   TxPreN:6 ; ///<
    UINT32                                                   TxPreP:6 ; ///<
    UINT32                                           Reserved_31_12:20; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} D18F2x09C_x0D0F_0306_STRUCT;

// **** D18F2x09C_x0D0F_030A Register Definition ****
// Address
#define D18F2x09C_x0D0F_030A_ADDRESS                            0xd0f030a

// Type
#define D18F2x09C_x0D0F_030A_TYPE                               TYPE_D18F2x09C
// Field Data
#define D18F2x09C_x0D0F_030A_TxPreN_OFFSET                      0
#define D18F2x09C_x0D0F_030A_TxPreN_WIDTH                       6
#define D18F2x09C_x0D0F_030A_TxPreN_MASK                        0x3f
#define D18F2x09C_x0D0F_030A_TxPreP_OFFSET                      6
#define D18F2x09C_x0D0F_030A_TxPreP_WIDTH                       6
#define D18F2x09C_x0D0F_030A_TxPreP_MASK                        0xfc0
#define D18F2x09C_x0D0F_030A_Reserved_31_12_OFFSET              12
#define D18F2x09C_x0D0F_030A_Reserved_31_12_WIDTH               20
#define D18F2x09C_x0D0F_030A_Reserved_31_12_MASK                0xfffff000

/// D18F2x09C_x0D0F_030A
typedef union {
  struct {                                                              ///<
    UINT32                                                   TxPreN:6 ; ///<
    UINT32                                                   TxPreP:6 ; ///<
    UINT32                                           Reserved_31_12:20; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} D18F2x09C_x0D0F_030A_STRUCT;

// **** D18F2x09C_x0D0F_030F Register Definition ****
// Address
#define D18F2x09C_x0D0F_030F_ADDRESS                            0xd0f030f

// Type
#define D18F2x09C_x0D0F_030F_TYPE                               TYPE_D18F2x09C
// Field Data
#define D18F2x09C_x0D0F_030F_Reserved_11_0_OFFSET               0
#define D18F2x09C_x0D0F_030F_Reserved_11_0_WIDTH                12
#define D18F2x09C_x0D0F_030F_Reserved_11_0_MASK                 0xfff
#define D18F2x09C_x0D0F_030F_AlwaysEnDllClks_OFFSET             12
#define D18F2x09C_x0D0F_030F_AlwaysEnDllClks_WIDTH              3
#define D18F2x09C_x0D0F_030F_AlwaysEnDllClks_MASK               0x7000
#define D18F2x09C_x0D0F_030F_Reserved_31_15_OFFSET              15
#define D18F2x09C_x0D0F_030F_Reserved_31_15_WIDTH               17
#define D18F2x09C_x0D0F_030F_Reserved_31_15_MASK                0xffff8000

/// D18F2x09C_x0D0F_030F
typedef union {
  struct {                                                              ///<
    UINT32                                            Reserved_11_0:12; ///<
    UINT32                                          AlwaysEnDllClks:3 ; ///<
    UINT32                                           Reserved_31_15:17; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} D18F2x09C_x0D0F_030F_STRUCT;

// **** D18F2x09C_x0D0F_0310 Register Definition ****
// Address
#define D18F2x09C_x0D0F_0310_ADDRESS                            0xd0f0310

// Type
#define D18F2x09C_x0D0F_0310_TYPE                               TYPE_D18F2x09C
// Field Data
#define D18F2x09C_x0D0F_0310_Reserved_11_0_OFFSET               0
#define D18F2x09C_x0D0F_0310_Reserved_11_0_WIDTH                12
#define D18F2x09C_x0D0F_0310_Reserved_11_0_MASK                 0xfff
#define D18F2x09C_x0D0F_0310_EnRxPadStandby_OFFSET              12
#define D18F2x09C_x0D0F_0310_EnRxPadStandby_WIDTH               1
#define D18F2x09C_x0D0F_0310_EnRxPadStandby_MASK                0x1000
#define D18F2x09C_x0D0F_0310_Reserved_31_13_OFFSET              13
#define D18F2x09C_x0D0F_0310_Reserved_31_13_WIDTH               19
#define D18F2x09C_x0D0F_0310_Reserved_31_13_MASK                0xffffe000

/// D18F2x09C_x0D0F_0310
typedef union {
  struct {                                                              ///<
    UINT32                                            Reserved_11_0:12; ///<
    UINT32                                           EnRxPadStandby:1 ; ///<
    UINT32                                           Reserved_31_13:19; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} D18F2x09C_x0D0F_0310_STRUCT;

// **** D18F2x09C_x0D0F_031F Register Definition ****
// Address
#define D18F2x09C_x0D0F_031F_ADDRESS                            0xd0f031f

// Type
#define D18F2x09C_x0D0F_031F_TYPE                               TYPE_D18F2x09C
// Field Data
#define D18F2x09C_x0D0F_031F_Reserved_2_0_OFFSET                0
#define D18F2x09C_x0D0F_031F_Reserved_2_0_WIDTH                 3
#define D18F2x09C_x0D0F_031F_Reserved_2_0_MASK                  0x7
#define D18F2x09C_x0D0F_031F_RxVioLvl_OFFSET                    3
#define D18F2x09C_x0D0F_031F_RxVioLvl_WIDTH                     2
#define D18F2x09C_x0D0F_031F_RxVioLvl_MASK                      0x18
#define D18F2x09C_x0D0F_031F_Reserved_31_5_OFFSET               5
#define D18F2x09C_x0D0F_031F_Reserved_31_5_WIDTH                27
#define D18F2x09C_x0D0F_031F_Reserved_31_5_MASK                 0xffffffe0

/// D18F2x09C_x0D0F_031F
typedef union {
  struct {                                                              ///<
    UINT32                                             Reserved_2_0:3 ; ///<
    UINT32                                                 RxVioLvl:2 ; ///<
    UINT32                                            Reserved_31_5:27; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} D18F2x09C_x0D0F_031F_STRUCT;

// **** D18F2x09C_x0D0F_0330 Register Definition ****
// Address
#define D18F2x09C_x0D0F_0330_ADDRESS                            0xd0f0330

// Type
#define D18F2x09C_x0D0F_0330_TYPE                               TYPE_D18F2x09C
// Field Data
#define D18F2x09C_x0D0F_0330_Reserved_4_0_OFFSET                0
#define D18F2x09C_x0D0F_0330_Reserved_4_0_WIDTH                 5
#define D18F2x09C_x0D0F_0330_Reserved_4_0_MASK                  0x1f
#define D18F2x09C_x0D0F_0330_PchgPdTxCClkGateDis_OFFSET         5
#define D18F2x09C_x0D0F_0330_PchgPdTxCClkGateDis_WIDTH          1
#define D18F2x09C_x0D0F_0330_PchgPdTxCClkGateDis_MASK           0x20
#define D18F2x09C_x0D0F_0330_Reserved_31_6_OFFSET               6
#define D18F2x09C_x0D0F_0330_Reserved_31_6_WIDTH                26
#define D18F2x09C_x0D0F_0330_Reserved_31_6_MASK                 0xffffffc0

/// D18F2x09C_x0D0F_0330
typedef union {
  struct {                                                              ///<
    UINT32                                             Reserved_4_0:5 ; ///<
    UINT32                                      PchgPdTxCClkGateDis:1 ; ///<
    UINT32                                            Reserved_31_6:26; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} D18F2x09C_x0D0F_0330_STRUCT;

// **** D18F2x09C_x0D0F_0331 Register Definition ****
// Address
#define D18F2x09C_x0D0F_0331_ADDRESS                            0xd0f0331

// Type
#define D18F2x09C_x0D0F_0331_TYPE                               TYPE_D18F2x09C
// Field Data
#define D18F2x09C_x0D0F_0331_Fence2ThresholdTxPad_OFFSET        0
#define D18F2x09C_x0D0F_0331_Fence2ThresholdTxPad_WIDTH         4
#define D18F2x09C_x0D0F_0331_Fence2ThresholdTxPad_MASK          0xf
#define D18F2x09C_x0D0F_0331_Fence2EnableTxPad_OFFSET           4
#define D18F2x09C_x0D0F_0331_Fence2EnableTxPad_WIDTH            1
#define D18F2x09C_x0D0F_0331_Fence2EnableTxPad_MASK             0x10
#define D18F2x09C_x0D0F_0331_Fence2ThresholdTxDll_OFFSET        5
#define D18F2x09C_x0D0F_0331_Fence2ThresholdTxDll_WIDTH         4
#define D18F2x09C_x0D0F_0331_Fence2ThresholdTxDll_MASK          0x1e0
#define D18F2x09C_x0D0F_0331_Fence2EnableTxDll_OFFSET           9
#define D18F2x09C_x0D0F_0331_Fence2EnableTxDll_WIDTH            1
#define D18F2x09C_x0D0F_0331_Fence2EnableTxDll_MASK             0x200
#define D18F2x09C_x0D0F_0331_Fence2ThresholdRxDll_OFFSET        10
#define D18F2x09C_x0D0F_0331_Fence2ThresholdRxDll_WIDTH         4
#define D18F2x09C_x0D0F_0331_Fence2ThresholdRxDll_MASK          0x3c00
#define D18F2x09C_x0D0F_0331_Fence2EnableRxDll_OFFSET           14
#define D18F2x09C_x0D0F_0331_Fence2EnableRxDll_WIDTH            1
#define D18F2x09C_x0D0F_0331_Fence2EnableRxDll_MASK             0x4000
#define D18F2x09C_x0D0F_0331_Reserved_31_15_OFFSET              15
#define D18F2x09C_x0D0F_0331_Reserved_31_15_WIDTH               17
#define D18F2x09C_x0D0F_0331_Reserved_31_15_MASK                0xffff8000

/// D18F2x09C_x0D0F_0331
typedef union {
  struct {                                                              ///<
    UINT32                                     Fence2ThresholdTxPad:4 ; ///<
    UINT32                                        Fence2EnableTxPad:1 ; ///<
    UINT32                                     Fence2ThresholdTxDll:4 ; ///<
    UINT32                                        Fence2EnableTxDll:1 ; ///<
    UINT32                                     Fence2ThresholdRxDll:4 ; ///<
    UINT32                                        Fence2EnableRxDll:1 ; ///<
    UINT32                                           Reserved_31_15:17; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} D18F2x09C_x0D0F_0331_STRUCT;

// **** D18F2x09C_x0D0F_0402 Register Definition ****
// Address
#define D18F2x09C_x0D0F_0402_ADDRESS                            0xd0f0402

// Type
#define D18F2x09C_x0D0F_0402_TYPE                               TYPE_D18F2x09C
// Field Data
#define D18F2x09C_x0D0F_0402_TxPreN_OFFSET                      0
#define D18F2x09C_x0D0F_0402_TxPreN_WIDTH                       6
#define D18F2x09C_x0D0F_0402_TxPreN_MASK                        0x3f
#define D18F2x09C_x0D0F_0402_TxPreP_OFFSET                      6
#define D18F2x09C_x0D0F_0402_TxPreP_WIDTH                       6
#define D18F2x09C_x0D0F_0402_TxPreP_MASK                        0xfc0
#define D18F2x09C_x0D0F_0402_Reserved_14_12_OFFSET              12
#define D18F2x09C_x0D0F_0402_Reserved_14_12_WIDTH               3
#define D18F2x09C_x0D0F_0402_Reserved_14_12_MASK                0x7000
#define D18F2x09C_x0D0F_0402_ValidTxAndPre_OFFSET               15
#define D18F2x09C_x0D0F_0402_ValidTxAndPre_WIDTH                1
#define D18F2x09C_x0D0F_0402_ValidTxAndPre_MASK                 0x8000
#define D18F2x09C_x0D0F_0402_Reserved_31_16_OFFSET              16
#define D18F2x09C_x0D0F_0402_Reserved_31_16_WIDTH               16
#define D18F2x09C_x0D0F_0402_Reserved_31_16_MASK                0xffff0000

/// D18F2x09C_x0D0F_0402
typedef union {
  struct {                                                              ///<
    UINT32                                                   TxPreN:6 ; ///<
    UINT32                                                   TxPreP:6 ; ///<
    UINT32                                           Reserved_14_12:3 ; ///<
    UINT32                                            ValidTxAndPre:1 ; ///<
    UINT32                                           Reserved_31_16:16; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} D18F2x09C_x0D0F_0402_STRUCT;

// **** D18F2x09C_x0D0F_0406 Register Definition ****
// Address
#define D18F2x09C_x0D0F_0406_ADDRESS                            0xd0f0406

// Type
#define D18F2x09C_x0D0F_0406_TYPE                               TYPE_D18F2x09C
// Field Data
#define D18F2x09C_x0D0F_0406_TxPreN_OFFSET                      0
#define D18F2x09C_x0D0F_0406_TxPreN_WIDTH                       6
#define D18F2x09C_x0D0F_0406_TxPreN_MASK                        0x3f
#define D18F2x09C_x0D0F_0406_TxPreP_OFFSET                      6
#define D18F2x09C_x0D0F_0406_TxPreP_WIDTH                       6
#define D18F2x09C_x0D0F_0406_TxPreP_MASK                        0xfc0
#define D18F2x09C_x0D0F_0406_Reserved_31_12_OFFSET              12
#define D18F2x09C_x0D0F_0406_Reserved_31_12_WIDTH               20
#define D18F2x09C_x0D0F_0406_Reserved_31_12_MASK                0xfffff000

/// D18F2x09C_x0D0F_0406
typedef union {
  struct {                                                              ///<
    UINT32                                                   TxPreN:6 ; ///<
    UINT32                                                   TxPreP:6 ; ///<
    UINT32                                           Reserved_31_12:20; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} D18F2x09C_x0D0F_0406_STRUCT;

// **** D18F2x09C_x0D0F_040A Register Definition ****
// Address
#define D18F2x09C_x0D0F_040A_ADDRESS                            0xd0f040a

// Type
#define D18F2x09C_x0D0F_040A_TYPE                               TYPE_D18F2x09C
// Field Data
#define D18F2x09C_x0D0F_040A_TxPreN_OFFSET                      0
#define D18F2x09C_x0D0F_040A_TxPreN_WIDTH                       6
#define D18F2x09C_x0D0F_040A_TxPreN_MASK                        0x3f
#define D18F2x09C_x0D0F_040A_TxPreP_OFFSET                      6
#define D18F2x09C_x0D0F_040A_TxPreP_WIDTH                       6
#define D18F2x09C_x0D0F_040A_TxPreP_MASK                        0xfc0
#define D18F2x09C_x0D0F_040A_Reserved_31_12_OFFSET              12
#define D18F2x09C_x0D0F_040A_Reserved_31_12_WIDTH               20
#define D18F2x09C_x0D0F_040A_Reserved_31_12_MASK                0xfffff000

/// D18F2x09C_x0D0F_040A
typedef union {
  struct {                                                              ///<
    UINT32                                                   TxPreN:6 ; ///<
    UINT32                                                   TxPreP:6 ; ///<
    UINT32                                           Reserved_31_12:20; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} D18F2x09C_x0D0F_040A_STRUCT;

// **** D18F2x09C_x0D0F_040F Register Definition ****
// Address
#define D18F2x09C_x0D0F_040F_ADDRESS                            0xd0f040f

// Type
#define D18F2x09C_x0D0F_040F_TYPE                               TYPE_D18F2x09C
// Field Data
#define D18F2x09C_x0D0F_040F_Reserved_11_0_OFFSET               0
#define D18F2x09C_x0D0F_040F_Reserved_11_0_WIDTH                12
#define D18F2x09C_x0D0F_040F_Reserved_11_0_MASK                 0xfff
#define D18F2x09C_x0D0F_040F_AlwaysEnDllClks_OFFSET             12
#define D18F2x09C_x0D0F_040F_AlwaysEnDllClks_WIDTH              3
#define D18F2x09C_x0D0F_040F_AlwaysEnDllClks_MASK               0x7000
#define D18F2x09C_x0D0F_040F_Reserved_31_15_OFFSET              15
#define D18F2x09C_x0D0F_040F_Reserved_31_15_WIDTH               17
#define D18F2x09C_x0D0F_040F_Reserved_31_15_MASK                0xffff8000

/// D18F2x09C_x0D0F_040F
typedef union {
  struct {                                                              ///<
    UINT32                                            Reserved_11_0:12; ///<
    UINT32                                          AlwaysEnDllClks:3 ; ///<
    UINT32                                           Reserved_31_15:17; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} D18F2x09C_x0D0F_040F_STRUCT;

// **** D18F2x09C_x0D0F_0410 Register Definition ****
// Address
#define D18F2x09C_x0D0F_0410_ADDRESS                            0xd0f0410

// Type
#define D18F2x09C_x0D0F_0410_TYPE                               TYPE_D18F2x09C
// Field Data
#define D18F2x09C_x0D0F_0410_Reserved_11_0_OFFSET               0
#define D18F2x09C_x0D0F_0410_Reserved_11_0_WIDTH                12
#define D18F2x09C_x0D0F_0410_Reserved_11_0_MASK                 0xfff
#define D18F2x09C_x0D0F_0410_EnRxPadStandby_OFFSET              12
#define D18F2x09C_x0D0F_0410_EnRxPadStandby_WIDTH               1
#define D18F2x09C_x0D0F_0410_EnRxPadStandby_MASK                0x1000
#define D18F2x09C_x0D0F_0410_Reserved_31_13_OFFSET              13
#define D18F2x09C_x0D0F_0410_Reserved_31_13_WIDTH               19
#define D18F2x09C_x0D0F_0410_Reserved_31_13_MASK                0xffffe000

/// D18F2x09C_x0D0F_0410
typedef union {
  struct {                                                              ///<
    UINT32                                            Reserved_11_0:12; ///<
    UINT32                                           EnRxPadStandby:1 ; ///<
    UINT32                                           Reserved_31_13:19; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} D18F2x09C_x0D0F_0410_STRUCT;

// **** D18F2x09C_x0D0F_041F Register Definition ****
// Address
#define D18F2x09C_x0D0F_041F_ADDRESS                            0xd0f041f

// Type
#define D18F2x09C_x0D0F_041F_TYPE                               TYPE_D18F2x09C
// Field Data
#define D18F2x09C_x0D0F_041F_Reserved_2_0_OFFSET                0
#define D18F2x09C_x0D0F_041F_Reserved_2_0_WIDTH                 3
#define D18F2x09C_x0D0F_041F_Reserved_2_0_MASK                  0x7
#define D18F2x09C_x0D0F_041F_RxVioLvl_OFFSET                    3
#define D18F2x09C_x0D0F_041F_RxVioLvl_WIDTH                     2
#define D18F2x09C_x0D0F_041F_RxVioLvl_MASK                      0x18
#define D18F2x09C_x0D0F_041F_Reserved_31_5_OFFSET               5
#define D18F2x09C_x0D0F_041F_Reserved_31_5_WIDTH                27
#define D18F2x09C_x0D0F_041F_Reserved_31_5_MASK                 0xffffffe0

/// D18F2x09C_x0D0F_041F
typedef union {
  struct {                                                              ///<
    UINT32                                             Reserved_2_0:3 ; ///<
    UINT32                                                 RxVioLvl:2 ; ///<
    UINT32                                            Reserved_31_5:27; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} D18F2x09C_x0D0F_041F_STRUCT;

// **** D18F2x09C_x0D0F_0430 Register Definition ****
// Address
#define D18F2x09C_x0D0F_0430_ADDRESS                            0xd0f0430

// Type
#define D18F2x09C_x0D0F_0430_TYPE                               TYPE_D18F2x09C
// Field Data
#define D18F2x09C_x0D0F_0430_Reserved_4_0_OFFSET                0
#define D18F2x09C_x0D0F_0430_Reserved_4_0_WIDTH                 5
#define D18F2x09C_x0D0F_0430_Reserved_4_0_MASK                  0x1f
#define D18F2x09C_x0D0F_0430_PchgPdTxCClkGateDis_OFFSET         5
#define D18F2x09C_x0D0F_0430_PchgPdTxCClkGateDis_WIDTH          1
#define D18F2x09C_x0D0F_0430_PchgPdTxCClkGateDis_MASK           0x20
#define D18F2x09C_x0D0F_0430_Reserved_31_6_OFFSET               6
#define D18F2x09C_x0D0F_0430_Reserved_31_6_WIDTH                26
#define D18F2x09C_x0D0F_0430_Reserved_31_6_MASK                 0xffffffc0

/// D18F2x09C_x0D0F_0430
typedef union {
  struct {                                                              ///<
    UINT32                                             Reserved_4_0:5 ; ///<
    UINT32                                      PchgPdTxCClkGateDis:1 ; ///<
    UINT32                                            Reserved_31_6:26; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} D18F2x09C_x0D0F_0430_STRUCT;

// **** D18F2x09C_x0D0F_0431 Register Definition ****
// Address
#define D18F2x09C_x0D0F_0431_ADDRESS                            0xd0f0431

// Type
#define D18F2x09C_x0D0F_0431_TYPE                               TYPE_D18F2x09C
// Field Data
#define D18F2x09C_x0D0F_0431_Fence2ThresholdTxPad_OFFSET        0
#define D18F2x09C_x0D0F_0431_Fence2ThresholdTxPad_WIDTH         4
#define D18F2x09C_x0D0F_0431_Fence2ThresholdTxPad_MASK          0xf
#define D18F2x09C_x0D0F_0431_Fence2EnableTxPad_OFFSET           4
#define D18F2x09C_x0D0F_0431_Fence2EnableTxPad_WIDTH            1
#define D18F2x09C_x0D0F_0431_Fence2EnableTxPad_MASK             0x10
#define D18F2x09C_x0D0F_0431_Fence2ThresholdTxDll_OFFSET        5
#define D18F2x09C_x0D0F_0431_Fence2ThresholdTxDll_WIDTH         4
#define D18F2x09C_x0D0F_0431_Fence2ThresholdTxDll_MASK          0x1e0
#define D18F2x09C_x0D0F_0431_Fence2EnableTxDll_OFFSET           9
#define D18F2x09C_x0D0F_0431_Fence2EnableTxDll_WIDTH            1
#define D18F2x09C_x0D0F_0431_Fence2EnableTxDll_MASK             0x200
#define D18F2x09C_x0D0F_0431_Fence2ThresholdRxDll_OFFSET        10
#define D18F2x09C_x0D0F_0431_Fence2ThresholdRxDll_WIDTH         4
#define D18F2x09C_x0D0F_0431_Fence2ThresholdRxDll_MASK          0x3c00
#define D18F2x09C_x0D0F_0431_Fence2EnableRxDll_OFFSET           14
#define D18F2x09C_x0D0F_0431_Fence2EnableRxDll_WIDTH            1
#define D18F2x09C_x0D0F_0431_Fence2EnableRxDll_MASK             0x4000
#define D18F2x09C_x0D0F_0431_Reserved_31_15_OFFSET              15
#define D18F2x09C_x0D0F_0431_Reserved_31_15_WIDTH               17
#define D18F2x09C_x0D0F_0431_Reserved_31_15_MASK                0xffff8000

/// D18F2x09C_x0D0F_0431
typedef union {
  struct {                                                              ///<
    UINT32                                     Fence2ThresholdTxPad:4 ; ///<
    UINT32                                        Fence2EnableTxPad:1 ; ///<
    UINT32                                     Fence2ThresholdTxDll:4 ; ///<
    UINT32                                        Fence2EnableTxDll:1 ; ///<
    UINT32                                     Fence2ThresholdRxDll:4 ; ///<
    UINT32                                        Fence2EnableRxDll:1 ; ///<
    UINT32                                           Reserved_31_15:17; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} D18F2x09C_x0D0F_0431_STRUCT;

// **** D18F2x09C_x0D0F_0502 Register Definition ****
// Address
#define D18F2x09C_x0D0F_0502_ADDRESS                            0xd0f0502

// Type
#define D18F2x09C_x0D0F_0502_TYPE                               TYPE_D18F2x09C
// Field Data
#define D18F2x09C_x0D0F_0502_TxPreN_OFFSET                      0
#define D18F2x09C_x0D0F_0502_TxPreN_WIDTH                       6
#define D18F2x09C_x0D0F_0502_TxPreN_MASK                        0x3f
#define D18F2x09C_x0D0F_0502_TxPreP_OFFSET                      6
#define D18F2x09C_x0D0F_0502_TxPreP_WIDTH                       6
#define D18F2x09C_x0D0F_0502_TxPreP_MASK                        0xfc0
#define D18F2x09C_x0D0F_0502_Reserved_14_12_OFFSET              12
#define D18F2x09C_x0D0F_0502_Reserved_14_12_WIDTH               3
#define D18F2x09C_x0D0F_0502_Reserved_14_12_MASK                0x7000
#define D18F2x09C_x0D0F_0502_ValidTxAndPre_OFFSET               15
#define D18F2x09C_x0D0F_0502_ValidTxAndPre_WIDTH                1
#define D18F2x09C_x0D0F_0502_ValidTxAndPre_MASK                 0x8000
#define D18F2x09C_x0D0F_0502_Reserved_31_16_OFFSET              16
#define D18F2x09C_x0D0F_0502_Reserved_31_16_WIDTH               16
#define D18F2x09C_x0D0F_0502_Reserved_31_16_MASK                0xffff0000

/// D18F2x09C_x0D0F_0502
typedef union {
  struct {                                                              ///<
    UINT32                                                   TxPreN:6 ; ///<
    UINT32                                                   TxPreP:6 ; ///<
    UINT32                                           Reserved_14_12:3 ; ///<
    UINT32                                            ValidTxAndPre:1 ; ///<
    UINT32                                           Reserved_31_16:16; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} D18F2x09C_x0D0F_0502_STRUCT;

// **** D18F2x09C_x0D0F_0506 Register Definition ****
// Address
#define D18F2x09C_x0D0F_0506_ADDRESS                            0xd0f0506

// Type
#define D18F2x09C_x0D0F_0506_TYPE                               TYPE_D18F2x09C
// Field Data
#define D18F2x09C_x0D0F_0506_TxPreN_OFFSET                      0
#define D18F2x09C_x0D0F_0506_TxPreN_WIDTH                       6
#define D18F2x09C_x0D0F_0506_TxPreN_MASK                        0x3f
#define D18F2x09C_x0D0F_0506_TxPreP_OFFSET                      6
#define D18F2x09C_x0D0F_0506_TxPreP_WIDTH                       6
#define D18F2x09C_x0D0F_0506_TxPreP_MASK                        0xfc0
#define D18F2x09C_x0D0F_0506_Reserved_31_12_OFFSET              12
#define D18F2x09C_x0D0F_0506_Reserved_31_12_WIDTH               20
#define D18F2x09C_x0D0F_0506_Reserved_31_12_MASK                0xfffff000

/// D18F2x09C_x0D0F_0506
typedef union {
  struct {                                                              ///<
    UINT32                                                   TxPreN:6 ; ///<
    UINT32                                                   TxPreP:6 ; ///<
    UINT32                                           Reserved_31_12:20; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} D18F2x09C_x0D0F_0506_STRUCT;

// **** D18F2x09C_x0D0F_050A Register Definition ****
// Address
#define D18F2x09C_x0D0F_050A_ADDRESS                            0xd0f050a

// Type
#define D18F2x09C_x0D0F_050A_TYPE                               TYPE_D18F2x09C
// Field Data
#define D18F2x09C_x0D0F_050A_TxPreN_OFFSET                      0
#define D18F2x09C_x0D0F_050A_TxPreN_WIDTH                       6
#define D18F2x09C_x0D0F_050A_TxPreN_MASK                        0x3f
#define D18F2x09C_x0D0F_050A_TxPreP_OFFSET                      6
#define D18F2x09C_x0D0F_050A_TxPreP_WIDTH                       6
#define D18F2x09C_x0D0F_050A_TxPreP_MASK                        0xfc0
#define D18F2x09C_x0D0F_050A_Reserved_31_12_OFFSET              12
#define D18F2x09C_x0D0F_050A_Reserved_31_12_WIDTH               20
#define D18F2x09C_x0D0F_050A_Reserved_31_12_MASK                0xfffff000

/// D18F2x09C_x0D0F_050A
typedef union {
  struct {                                                              ///<
    UINT32                                                   TxPreN:6 ; ///<
    UINT32                                                   TxPreP:6 ; ///<
    UINT32                                           Reserved_31_12:20; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} D18F2x09C_x0D0F_050A_STRUCT;

// **** D18F2x09C_x0D0F_050F Register Definition ****
// Address
#define D18F2x09C_x0D0F_050F_ADDRESS                            0xd0f050f

// Type
#define D18F2x09C_x0D0F_050F_TYPE                               TYPE_D18F2x09C
// Field Data
#define D18F2x09C_x0D0F_050F_Reserved_11_0_OFFSET               0
#define D18F2x09C_x0D0F_050F_Reserved_11_0_WIDTH                12
#define D18F2x09C_x0D0F_050F_Reserved_11_0_MASK                 0xfff
#define D18F2x09C_x0D0F_050F_AlwaysEnDllClks_OFFSET             12
#define D18F2x09C_x0D0F_050F_AlwaysEnDllClks_WIDTH              3
#define D18F2x09C_x0D0F_050F_AlwaysEnDllClks_MASK               0x7000
#define D18F2x09C_x0D0F_050F_Reserved_31_15_OFFSET              15
#define D18F2x09C_x0D0F_050F_Reserved_31_15_WIDTH               17
#define D18F2x09C_x0D0F_050F_Reserved_31_15_MASK                0xffff8000

/// D18F2x09C_x0D0F_050F
typedef union {
  struct {                                                              ///<
    UINT32                                            Reserved_11_0:12; ///<
    UINT32                                          AlwaysEnDllClks:3 ; ///<
    UINT32                                           Reserved_31_15:17; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} D18F2x09C_x0D0F_050F_STRUCT;

// **** D18F2x09C_x0D0F_0510 Register Definition ****
// Address
#define D18F2x09C_x0D0F_0510_ADDRESS                            0xd0f0510

// Type
#define D18F2x09C_x0D0F_0510_TYPE                               TYPE_D18F2x09C
// Field Data
#define D18F2x09C_x0D0F_0510_Reserved_11_0_OFFSET               0
#define D18F2x09C_x0D0F_0510_Reserved_11_0_WIDTH                12
#define D18F2x09C_x0D0F_0510_Reserved_11_0_MASK                 0xfff
#define D18F2x09C_x0D0F_0510_EnRxPadStandby_OFFSET              12
#define D18F2x09C_x0D0F_0510_EnRxPadStandby_WIDTH               1
#define D18F2x09C_x0D0F_0510_EnRxPadStandby_MASK                0x1000
#define D18F2x09C_x0D0F_0510_Reserved_31_13_OFFSET              13
#define D18F2x09C_x0D0F_0510_Reserved_31_13_WIDTH               19
#define D18F2x09C_x0D0F_0510_Reserved_31_13_MASK                0xffffe000

/// D18F2x09C_x0D0F_0510
typedef union {
  struct {                                                              ///<
    UINT32                                            Reserved_11_0:12; ///<
    UINT32                                           EnRxPadStandby:1 ; ///<
    UINT32                                           Reserved_31_13:19; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} D18F2x09C_x0D0F_0510_STRUCT;

// **** D18F2x09C_x0D0F_051F Register Definition ****
// Address
#define D18F2x09C_x0D0F_051F_ADDRESS                            0xd0f051f

// Type
#define D18F2x09C_x0D0F_051F_TYPE                               TYPE_D18F2x09C
// Field Data
#define D18F2x09C_x0D0F_051F_Reserved_2_0_OFFSET                0
#define D18F2x09C_x0D0F_051F_Reserved_2_0_WIDTH                 3
#define D18F2x09C_x0D0F_051F_Reserved_2_0_MASK                  0x7
#define D18F2x09C_x0D0F_051F_RxVioLvl_OFFSET                    3
#define D18F2x09C_x0D0F_051F_RxVioLvl_WIDTH                     2
#define D18F2x09C_x0D0F_051F_RxVioLvl_MASK                      0x18
#define D18F2x09C_x0D0F_051F_Reserved_31_5_OFFSET               5
#define D18F2x09C_x0D0F_051F_Reserved_31_5_WIDTH                27
#define D18F2x09C_x0D0F_051F_Reserved_31_5_MASK                 0xffffffe0

/// D18F2x09C_x0D0F_051F
typedef union {
  struct {                                                              ///<
    UINT32                                             Reserved_2_0:3 ; ///<
    UINT32                                                 RxVioLvl:2 ; ///<
    UINT32                                            Reserved_31_5:27; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} D18F2x09C_x0D0F_051F_STRUCT;

// **** D18F2x09C_x0D0F_0530 Register Definition ****
// Address
#define D18F2x09C_x0D0F_0530_ADDRESS                            0xd0f0530

// Type
#define D18F2x09C_x0D0F_0530_TYPE                               TYPE_D18F2x09C
// Field Data
#define D18F2x09C_x0D0F_0530_Reserved_4_0_OFFSET                0
#define D18F2x09C_x0D0F_0530_Reserved_4_0_WIDTH                 5
#define D18F2x09C_x0D0F_0530_Reserved_4_0_MASK                  0x1f
#define D18F2x09C_x0D0F_0530_PchgPdTxCClkGateDis_OFFSET         5
#define D18F2x09C_x0D0F_0530_PchgPdTxCClkGateDis_WIDTH          1
#define D18F2x09C_x0D0F_0530_PchgPdTxCClkGateDis_MASK           0x20
#define D18F2x09C_x0D0F_0530_Reserved_31_6_OFFSET               6
#define D18F2x09C_x0D0F_0530_Reserved_31_6_WIDTH                26
#define D18F2x09C_x0D0F_0530_Reserved_31_6_MASK                 0xffffffc0

/// D18F2x09C_x0D0F_0530
typedef union {
  struct {                                                              ///<
    UINT32                                             Reserved_4_0:5 ; ///<
    UINT32                                      PchgPdTxCClkGateDis:1 ; ///<
    UINT32                                            Reserved_31_6:26; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} D18F2x09C_x0D0F_0530_STRUCT;

// **** D18F2x09C_x0D0F_0531 Register Definition ****
// Address
#define D18F2x09C_x0D0F_0531_ADDRESS                            0xd0f0531

// Type
#define D18F2x09C_x0D0F_0531_TYPE                               TYPE_D18F2x09C
// Field Data
#define D18F2x09C_x0D0F_0531_Fence2ThresholdTxPad_OFFSET        0
#define D18F2x09C_x0D0F_0531_Fence2ThresholdTxPad_WIDTH         4
#define D18F2x09C_x0D0F_0531_Fence2ThresholdTxPad_MASK          0xf
#define D18F2x09C_x0D0F_0531_Fence2EnableTxPad_OFFSET           4
#define D18F2x09C_x0D0F_0531_Fence2EnableTxPad_WIDTH            1
#define D18F2x09C_x0D0F_0531_Fence2EnableTxPad_MASK             0x10
#define D18F2x09C_x0D0F_0531_Fence2ThresholdTxDll_OFFSET        5
#define D18F2x09C_x0D0F_0531_Fence2ThresholdTxDll_WIDTH         4
#define D18F2x09C_x0D0F_0531_Fence2ThresholdTxDll_MASK          0x1e0
#define D18F2x09C_x0D0F_0531_Fence2EnableTxDll_OFFSET           9
#define D18F2x09C_x0D0F_0531_Fence2EnableTxDll_WIDTH            1
#define D18F2x09C_x0D0F_0531_Fence2EnableTxDll_MASK             0x200
#define D18F2x09C_x0D0F_0531_Fence2ThresholdRxDll_OFFSET        10
#define D18F2x09C_x0D0F_0531_Fence2ThresholdRxDll_WIDTH         4
#define D18F2x09C_x0D0F_0531_Fence2ThresholdRxDll_MASK          0x3c00
#define D18F2x09C_x0D0F_0531_Fence2EnableRxDll_OFFSET           14
#define D18F2x09C_x0D0F_0531_Fence2EnableRxDll_WIDTH            1
#define D18F2x09C_x0D0F_0531_Fence2EnableRxDll_MASK             0x4000
#define D18F2x09C_x0D0F_0531_Reserved_31_15_OFFSET              15
#define D18F2x09C_x0D0F_0531_Reserved_31_15_WIDTH               17
#define D18F2x09C_x0D0F_0531_Reserved_31_15_MASK                0xffff8000

/// D18F2x09C_x0D0F_0531
typedef union {
  struct {                                                              ///<
    UINT32                                     Fence2ThresholdTxPad:4 ; ///<
    UINT32                                        Fence2EnableTxPad:1 ; ///<
    UINT32                                     Fence2ThresholdTxDll:4 ; ///<
    UINT32                                        Fence2EnableTxDll:1 ; ///<
    UINT32                                     Fence2ThresholdRxDll:4 ; ///<
    UINT32                                        Fence2EnableRxDll:1 ; ///<
    UINT32                                           Reserved_31_15:17; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} D18F2x09C_x0D0F_0531_STRUCT;

// **** D18F2x09C_x0D0F_0602 Register Definition ****
// Address
#define D18F2x09C_x0D0F_0602_ADDRESS                            0xd0f0602

// Type
#define D18F2x09C_x0D0F_0602_TYPE                               TYPE_D18F2x09C
// Field Data
#define D18F2x09C_x0D0F_0602_TxPreN_OFFSET                      0
#define D18F2x09C_x0D0F_0602_TxPreN_WIDTH                       6
#define D18F2x09C_x0D0F_0602_TxPreN_MASK                        0x3f
#define D18F2x09C_x0D0F_0602_TxPreP_OFFSET                      6
#define D18F2x09C_x0D0F_0602_TxPreP_WIDTH                       6
#define D18F2x09C_x0D0F_0602_TxPreP_MASK                        0xfc0
#define D18F2x09C_x0D0F_0602_Reserved_14_12_OFFSET              12
#define D18F2x09C_x0D0F_0602_Reserved_14_12_WIDTH               3
#define D18F2x09C_x0D0F_0602_Reserved_14_12_MASK                0x7000
#define D18F2x09C_x0D0F_0602_ValidTxAndPre_OFFSET               15
#define D18F2x09C_x0D0F_0602_ValidTxAndPre_WIDTH                1
#define D18F2x09C_x0D0F_0602_ValidTxAndPre_MASK                 0x8000
#define D18F2x09C_x0D0F_0602_Reserved_31_16_OFFSET              16
#define D18F2x09C_x0D0F_0602_Reserved_31_16_WIDTH               16
#define D18F2x09C_x0D0F_0602_Reserved_31_16_MASK                0xffff0000

/// D18F2x09C_x0D0F_0602
typedef union {
  struct {                                                              ///<
    UINT32                                                   TxPreN:6 ; ///<
    UINT32                                                   TxPreP:6 ; ///<
    UINT32                                           Reserved_14_12:3 ; ///<
    UINT32                                            ValidTxAndPre:1 ; ///<
    UINT32                                           Reserved_31_16:16; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} D18F2x09C_x0D0F_0602_STRUCT;

// **** D18F2x09C_x0D0F_0606 Register Definition ****
// Address
#define D18F2x09C_x0D0F_0606_ADDRESS                            0xd0f0606

// Type
#define D18F2x09C_x0D0F_0606_TYPE                               TYPE_D18F2x09C
// Field Data
#define D18F2x09C_x0D0F_0606_TxPreN_OFFSET                      0
#define D18F2x09C_x0D0F_0606_TxPreN_WIDTH                       6
#define D18F2x09C_x0D0F_0606_TxPreN_MASK                        0x3f
#define D18F2x09C_x0D0F_0606_TxPreP_OFFSET                      6
#define D18F2x09C_x0D0F_0606_TxPreP_WIDTH                       6
#define D18F2x09C_x0D0F_0606_TxPreP_MASK                        0xfc0
#define D18F2x09C_x0D0F_0606_Reserved_31_12_OFFSET              12
#define D18F2x09C_x0D0F_0606_Reserved_31_12_WIDTH               20
#define D18F2x09C_x0D0F_0606_Reserved_31_12_MASK                0xfffff000

/// D18F2x09C_x0D0F_0606
typedef union {
  struct {                                                              ///<
    UINT32                                                   TxPreN:6 ; ///<
    UINT32                                                   TxPreP:6 ; ///<
    UINT32                                           Reserved_31_12:20; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} D18F2x09C_x0D0F_0606_STRUCT;

// **** D18F2x09C_x0D0F_060A Register Definition ****
// Address
#define D18F2x09C_x0D0F_060A_ADDRESS                            0xd0f060a

// Type
#define D18F2x09C_x0D0F_060A_TYPE                               TYPE_D18F2x09C
// Field Data
#define D18F2x09C_x0D0F_060A_TxPreN_OFFSET                      0
#define D18F2x09C_x0D0F_060A_TxPreN_WIDTH                       6
#define D18F2x09C_x0D0F_060A_TxPreN_MASK                        0x3f
#define D18F2x09C_x0D0F_060A_TxPreP_OFFSET                      6
#define D18F2x09C_x0D0F_060A_TxPreP_WIDTH                       6
#define D18F2x09C_x0D0F_060A_TxPreP_MASK                        0xfc0
#define D18F2x09C_x0D0F_060A_Reserved_31_12_OFFSET              12
#define D18F2x09C_x0D0F_060A_Reserved_31_12_WIDTH               20
#define D18F2x09C_x0D0F_060A_Reserved_31_12_MASK                0xfffff000

/// D18F2x09C_x0D0F_060A
typedef union {
  struct {                                                              ///<
    UINT32                                                   TxPreN:6 ; ///<
    UINT32                                                   TxPreP:6 ; ///<
    UINT32                                           Reserved_31_12:20; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} D18F2x09C_x0D0F_060A_STRUCT;

// **** D18F2x09C_x0D0F_060F Register Definition ****
// Address
#define D18F2x09C_x0D0F_060F_ADDRESS                            0xd0f060f

// Type
#define D18F2x09C_x0D0F_060F_TYPE                               TYPE_D18F2x09C
// Field Data
#define D18F2x09C_x0D0F_060F_Reserved_11_0_OFFSET               0
#define D18F2x09C_x0D0F_060F_Reserved_11_0_WIDTH                12
#define D18F2x09C_x0D0F_060F_Reserved_11_0_MASK                 0xfff
#define D18F2x09C_x0D0F_060F_AlwaysEnDllClks_OFFSET             12
#define D18F2x09C_x0D0F_060F_AlwaysEnDllClks_WIDTH              3
#define D18F2x09C_x0D0F_060F_AlwaysEnDllClks_MASK               0x7000
#define D18F2x09C_x0D0F_060F_Reserved_31_15_OFFSET              15
#define D18F2x09C_x0D0F_060F_Reserved_31_15_WIDTH               17
#define D18F2x09C_x0D0F_060F_Reserved_31_15_MASK                0xffff8000

/// D18F2x09C_x0D0F_060F
typedef union {
  struct {                                                              ///<
    UINT32                                            Reserved_11_0:12; ///<
    UINT32                                          AlwaysEnDllClks:3 ; ///<
    UINT32                                           Reserved_31_15:17; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} D18F2x09C_x0D0F_060F_STRUCT;

// **** D18F2x09C_x0D0F_0610 Register Definition ****
// Address
#define D18F2x09C_x0D0F_0610_ADDRESS                            0xd0f0610

// Type
#define D18F2x09C_x0D0F_0610_TYPE                               TYPE_D18F2x09C
// Field Data
#define D18F2x09C_x0D0F_0610_Reserved_11_0_OFFSET               0
#define D18F2x09C_x0D0F_0610_Reserved_11_0_WIDTH                12
#define D18F2x09C_x0D0F_0610_Reserved_11_0_MASK                 0xfff
#define D18F2x09C_x0D0F_0610_EnRxPadStandby_OFFSET              12
#define D18F2x09C_x0D0F_0610_EnRxPadStandby_WIDTH               1
#define D18F2x09C_x0D0F_0610_EnRxPadStandby_MASK                0x1000
#define D18F2x09C_x0D0F_0610_Reserved_31_13_OFFSET              13
#define D18F2x09C_x0D0F_0610_Reserved_31_13_WIDTH               19
#define D18F2x09C_x0D0F_0610_Reserved_31_13_MASK                0xffffe000

/// D18F2x09C_x0D0F_0610
typedef union {
  struct {                                                              ///<
    UINT32                                            Reserved_11_0:12; ///<
    UINT32                                           EnRxPadStandby:1 ; ///<
    UINT32                                           Reserved_31_13:19; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} D18F2x09C_x0D0F_0610_STRUCT;

// **** D18F2x09C_x0D0F_061F Register Definition ****
// Address
#define D18F2x09C_x0D0F_061F_ADDRESS                            0xd0f061f

// Type
#define D18F2x09C_x0D0F_061F_TYPE                               TYPE_D18F2x09C
// Field Data
#define D18F2x09C_x0D0F_061F_Reserved_2_0_OFFSET                0
#define D18F2x09C_x0D0F_061F_Reserved_2_0_WIDTH                 3
#define D18F2x09C_x0D0F_061F_Reserved_2_0_MASK                  0x7
#define D18F2x09C_x0D0F_061F_RxVioLvl_OFFSET                    3
#define D18F2x09C_x0D0F_061F_RxVioLvl_WIDTH                     2
#define D18F2x09C_x0D0F_061F_RxVioLvl_MASK                      0x18
#define D18F2x09C_x0D0F_061F_Reserved_31_5_OFFSET               5
#define D18F2x09C_x0D0F_061F_Reserved_31_5_WIDTH                27
#define D18F2x09C_x0D0F_061F_Reserved_31_5_MASK                 0xffffffe0

/// D18F2x09C_x0D0F_061F
typedef union {
  struct {                                                              ///<
    UINT32                                             Reserved_2_0:3 ; ///<
    UINT32                                                 RxVioLvl:2 ; ///<
    UINT32                                            Reserved_31_5:27; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} D18F2x09C_x0D0F_061F_STRUCT;

// **** D18F2x09C_x0D0F_0630 Register Definition ****
// Address
#define D18F2x09C_x0D0F_0630_ADDRESS                            0xd0f0630

// Type
#define D18F2x09C_x0D0F_0630_TYPE                               TYPE_D18F2x09C
// Field Data
#define D18F2x09C_x0D0F_0630_Reserved_4_0_OFFSET                0
#define D18F2x09C_x0D0F_0630_Reserved_4_0_WIDTH                 5
#define D18F2x09C_x0D0F_0630_Reserved_4_0_MASK                  0x1f
#define D18F2x09C_x0D0F_0630_PchgPdTxCClkGateDis_OFFSET         5
#define D18F2x09C_x0D0F_0630_PchgPdTxCClkGateDis_WIDTH          1
#define D18F2x09C_x0D0F_0630_PchgPdTxCClkGateDis_MASK           0x20
#define D18F2x09C_x0D0F_0630_Reserved_31_6_OFFSET               6
#define D18F2x09C_x0D0F_0630_Reserved_31_6_WIDTH                26
#define D18F2x09C_x0D0F_0630_Reserved_31_6_MASK                 0xffffffc0

/// D18F2x09C_x0D0F_0630
typedef union {
  struct {                                                              ///<
    UINT32                                             Reserved_4_0:5 ; ///<
    UINT32                                      PchgPdTxCClkGateDis:1 ; ///<
    UINT32                                            Reserved_31_6:26; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} D18F2x09C_x0D0F_0630_STRUCT;

// **** D18F2x09C_x0D0F_0631 Register Definition ****
// Address
#define D18F2x09C_x0D0F_0631_ADDRESS                            0xd0f0631

// Type
#define D18F2x09C_x0D0F_0631_TYPE                               TYPE_D18F2x09C
// Field Data
#define D18F2x09C_x0D0F_0631_Fence2ThresholdTxPad_OFFSET        0
#define D18F2x09C_x0D0F_0631_Fence2ThresholdTxPad_WIDTH         4
#define D18F2x09C_x0D0F_0631_Fence2ThresholdTxPad_MASK          0xf
#define D18F2x09C_x0D0F_0631_Fence2EnableTxPad_OFFSET           4
#define D18F2x09C_x0D0F_0631_Fence2EnableTxPad_WIDTH            1
#define D18F2x09C_x0D0F_0631_Fence2EnableTxPad_MASK             0x10
#define D18F2x09C_x0D0F_0631_Fence2ThresholdTxDll_OFFSET        5
#define D18F2x09C_x0D0F_0631_Fence2ThresholdTxDll_WIDTH         4
#define D18F2x09C_x0D0F_0631_Fence2ThresholdTxDll_MASK          0x1e0
#define D18F2x09C_x0D0F_0631_Fence2EnableTxDll_OFFSET           9
#define D18F2x09C_x0D0F_0631_Fence2EnableTxDll_WIDTH            1
#define D18F2x09C_x0D0F_0631_Fence2EnableTxDll_MASK             0x200
#define D18F2x09C_x0D0F_0631_Fence2ThresholdRxDll_OFFSET        10
#define D18F2x09C_x0D0F_0631_Fence2ThresholdRxDll_WIDTH         4
#define D18F2x09C_x0D0F_0631_Fence2ThresholdRxDll_MASK          0x3c00
#define D18F2x09C_x0D0F_0631_Fence2EnableRxDll_OFFSET           14
#define D18F2x09C_x0D0F_0631_Fence2EnableRxDll_WIDTH            1
#define D18F2x09C_x0D0F_0631_Fence2EnableRxDll_MASK             0x4000
#define D18F2x09C_x0D0F_0631_Reserved_31_15_OFFSET              15
#define D18F2x09C_x0D0F_0631_Reserved_31_15_WIDTH               17
#define D18F2x09C_x0D0F_0631_Reserved_31_15_MASK                0xffff8000

/// D18F2x09C_x0D0F_0631
typedef union {
  struct {                                                              ///<
    UINT32                                     Fence2ThresholdTxPad:4 ; ///<
    UINT32                                        Fence2EnableTxPad:1 ; ///<
    UINT32                                     Fence2ThresholdTxDll:4 ; ///<
    UINT32                                        Fence2EnableTxDll:1 ; ///<
    UINT32                                     Fence2ThresholdRxDll:4 ; ///<
    UINT32                                        Fence2EnableRxDll:1 ; ///<
    UINT32                                           Reserved_31_15:17; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} D18F2x09C_x0D0F_0631_STRUCT;

// **** D18F2x09C_x0D0F_0702 Register Definition ****
// Address
#define D18F2x09C_x0D0F_0702_ADDRESS                            0xd0f0702

// Type
#define D18F2x09C_x0D0F_0702_TYPE                               TYPE_D18F2x09C
// Field Data
#define D18F2x09C_x0D0F_0702_TxPreN_OFFSET                      0
#define D18F2x09C_x0D0F_0702_TxPreN_WIDTH                       6
#define D18F2x09C_x0D0F_0702_TxPreN_MASK                        0x3f
#define D18F2x09C_x0D0F_0702_TxPreP_OFFSET                      6
#define D18F2x09C_x0D0F_0702_TxPreP_WIDTH                       6
#define D18F2x09C_x0D0F_0702_TxPreP_MASK                        0xfc0
#define D18F2x09C_x0D0F_0702_Reserved_14_12_OFFSET              12
#define D18F2x09C_x0D0F_0702_Reserved_14_12_WIDTH               3
#define D18F2x09C_x0D0F_0702_Reserved_14_12_MASK                0x7000
#define D18F2x09C_x0D0F_0702_ValidTxAndPre_OFFSET               15
#define D18F2x09C_x0D0F_0702_ValidTxAndPre_WIDTH                1
#define D18F2x09C_x0D0F_0702_ValidTxAndPre_MASK                 0x8000
#define D18F2x09C_x0D0F_0702_Reserved_31_16_OFFSET              16
#define D18F2x09C_x0D0F_0702_Reserved_31_16_WIDTH               16
#define D18F2x09C_x0D0F_0702_Reserved_31_16_MASK                0xffff0000

/// D18F2x09C_x0D0F_0702
typedef union {
  struct {                                                              ///<
    UINT32                                                   TxPreN:6 ; ///<
    UINT32                                                   TxPreP:6 ; ///<
    UINT32                                           Reserved_14_12:3 ; ///<
    UINT32                                            ValidTxAndPre:1 ; ///<
    UINT32                                           Reserved_31_16:16; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} D18F2x09C_x0D0F_0702_STRUCT;

// **** D18F2x09C_x0D0F_0706 Register Definition ****
// Address
#define D18F2x09C_x0D0F_0706_ADDRESS                            0xd0f0706

// Type
#define D18F2x09C_x0D0F_0706_TYPE                               TYPE_D18F2x09C
// Field Data
#define D18F2x09C_x0D0F_0706_TxPreN_OFFSET                      0
#define D18F2x09C_x0D0F_0706_TxPreN_WIDTH                       6
#define D18F2x09C_x0D0F_0706_TxPreN_MASK                        0x3f
#define D18F2x09C_x0D0F_0706_TxPreP_OFFSET                      6
#define D18F2x09C_x0D0F_0706_TxPreP_WIDTH                       6
#define D18F2x09C_x0D0F_0706_TxPreP_MASK                        0xfc0
#define D18F2x09C_x0D0F_0706_Reserved_31_12_OFFSET              12
#define D18F2x09C_x0D0F_0706_Reserved_31_12_WIDTH               20
#define D18F2x09C_x0D0F_0706_Reserved_31_12_MASK                0xfffff000

/// D18F2x09C_x0D0F_0706
typedef union {
  struct {                                                              ///<
    UINT32                                                   TxPreN:6 ; ///<
    UINT32                                                   TxPreP:6 ; ///<
    UINT32                                           Reserved_31_12:20; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} D18F2x09C_x0D0F_0706_STRUCT;

// **** D18F2x09C_x0D0F_070A Register Definition ****
// Address
#define D18F2x09C_x0D0F_070A_ADDRESS                            0xd0f070a

// Type
#define D18F2x09C_x0D0F_070A_TYPE                               TYPE_D18F2x09C
// Field Data
#define D18F2x09C_x0D0F_070A_TxPreN_OFFSET                      0
#define D18F2x09C_x0D0F_070A_TxPreN_WIDTH                       6
#define D18F2x09C_x0D0F_070A_TxPreN_MASK                        0x3f
#define D18F2x09C_x0D0F_070A_TxPreP_OFFSET                      6
#define D18F2x09C_x0D0F_070A_TxPreP_WIDTH                       6
#define D18F2x09C_x0D0F_070A_TxPreP_MASK                        0xfc0
#define D18F2x09C_x0D0F_070A_Reserved_31_12_OFFSET              12
#define D18F2x09C_x0D0F_070A_Reserved_31_12_WIDTH               20
#define D18F2x09C_x0D0F_070A_Reserved_31_12_MASK                0xfffff000

/// D18F2x09C_x0D0F_070A
typedef union {
  struct {                                                              ///<
    UINT32                                                   TxPreN:6 ; ///<
    UINT32                                                   TxPreP:6 ; ///<
    UINT32                                           Reserved_31_12:20; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} D18F2x09C_x0D0F_070A_STRUCT;

// **** D18F2x09C_x0D0F_070F Register Definition ****
// Address
#define D18F2x09C_x0D0F_070F_ADDRESS                            0xd0f070f

// Type
#define D18F2x09C_x0D0F_070F_TYPE                               TYPE_D18F2x09C
// Field Data
#define D18F2x09C_x0D0F_070F_Reserved_11_0_OFFSET               0
#define D18F2x09C_x0D0F_070F_Reserved_11_0_WIDTH                12
#define D18F2x09C_x0D0F_070F_Reserved_11_0_MASK                 0xfff
#define D18F2x09C_x0D0F_070F_AlwaysEnDllClks_OFFSET             12
#define D18F2x09C_x0D0F_070F_AlwaysEnDllClks_WIDTH              3
#define D18F2x09C_x0D0F_070F_AlwaysEnDllClks_MASK               0x7000
#define D18F2x09C_x0D0F_070F_Reserved_31_15_OFFSET              15
#define D18F2x09C_x0D0F_070F_Reserved_31_15_WIDTH               17
#define D18F2x09C_x0D0F_070F_Reserved_31_15_MASK                0xffff8000

/// D18F2x09C_x0D0F_070F
typedef union {
  struct {                                                              ///<
    UINT32                                            Reserved_11_0:12; ///<
    UINT32                                          AlwaysEnDllClks:3 ; ///<
    UINT32                                           Reserved_31_15:17; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} D18F2x09C_x0D0F_070F_STRUCT;

// **** D18F2x09C_x0D0F_0710 Register Definition ****
// Address
#define D18F2x09C_x0D0F_0710_ADDRESS                            0xd0f0710

// Type
#define D18F2x09C_x0D0F_0710_TYPE                               TYPE_D18F2x09C
// Field Data
#define D18F2x09C_x0D0F_0710_Reserved_11_0_OFFSET               0
#define D18F2x09C_x0D0F_0710_Reserved_11_0_WIDTH                12
#define D18F2x09C_x0D0F_0710_Reserved_11_0_MASK                 0xfff
#define D18F2x09C_x0D0F_0710_EnRxPadStandby_OFFSET              12
#define D18F2x09C_x0D0F_0710_EnRxPadStandby_WIDTH               1
#define D18F2x09C_x0D0F_0710_EnRxPadStandby_MASK                0x1000
#define D18F2x09C_x0D0F_0710_Reserved_31_13_OFFSET              13
#define D18F2x09C_x0D0F_0710_Reserved_31_13_WIDTH               19
#define D18F2x09C_x0D0F_0710_Reserved_31_13_MASK                0xffffe000

/// D18F2x09C_x0D0F_0710
typedef union {
  struct {                                                              ///<
    UINT32                                            Reserved_11_0:12; ///<
    UINT32                                           EnRxPadStandby:1 ; ///<
    UINT32                                           Reserved_31_13:19; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} D18F2x09C_x0D0F_0710_STRUCT;

// **** D18F2x09C_x0D0F_071F Register Definition ****
// Address
#define D18F2x09C_x0D0F_071F_ADDRESS                            0xd0f071f

// Type
#define D18F2x09C_x0D0F_071F_TYPE                               TYPE_D18F2x09C
// Field Data
#define D18F2x09C_x0D0F_071F_Reserved_2_0_OFFSET                0
#define D18F2x09C_x0D0F_071F_Reserved_2_0_WIDTH                 3
#define D18F2x09C_x0D0F_071F_Reserved_2_0_MASK                  0x7
#define D18F2x09C_x0D0F_071F_RxVioLvl_OFFSET                    3
#define D18F2x09C_x0D0F_071F_RxVioLvl_WIDTH                     2
#define D18F2x09C_x0D0F_071F_RxVioLvl_MASK                      0x18
#define D18F2x09C_x0D0F_071F_Reserved_31_5_OFFSET               5
#define D18F2x09C_x0D0F_071F_Reserved_31_5_WIDTH                27
#define D18F2x09C_x0D0F_071F_Reserved_31_5_MASK                 0xffffffe0

/// D18F2x09C_x0D0F_071F
typedef union {
  struct {                                                              ///<
    UINT32                                             Reserved_2_0:3 ; ///<
    UINT32                                                 RxVioLvl:2 ; ///<
    UINT32                                            Reserved_31_5:27; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} D18F2x09C_x0D0F_071F_STRUCT;

// **** D18F2x09C_x0D0F_0730 Register Definition ****
// Address
#define D18F2x09C_x0D0F_0730_ADDRESS                            0xd0f0730

// Type
#define D18F2x09C_x0D0F_0730_TYPE                               TYPE_D18F2x09C
// Field Data
#define D18F2x09C_x0D0F_0730_Reserved_4_0_OFFSET                0
#define D18F2x09C_x0D0F_0730_Reserved_4_0_WIDTH                 5
#define D18F2x09C_x0D0F_0730_Reserved_4_0_MASK                  0x1f
#define D18F2x09C_x0D0F_0730_PchgPdTxCClkGateDis_OFFSET         5
#define D18F2x09C_x0D0F_0730_PchgPdTxCClkGateDis_WIDTH          1
#define D18F2x09C_x0D0F_0730_PchgPdTxCClkGateDis_MASK           0x20
#define D18F2x09C_x0D0F_0730_Reserved_31_6_OFFSET               6
#define D18F2x09C_x0D0F_0730_Reserved_31_6_WIDTH                26
#define D18F2x09C_x0D0F_0730_Reserved_31_6_MASK                 0xffffffc0

/// D18F2x09C_x0D0F_0730
typedef union {
  struct {                                                              ///<
    UINT32                                             Reserved_4_0:5 ; ///<
    UINT32                                      PchgPdTxCClkGateDis:1 ; ///<
    UINT32                                            Reserved_31_6:26; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} D18F2x09C_x0D0F_0730_STRUCT;

// **** D18F2x09C_x0D0F_0731 Register Definition ****
// Address
#define D18F2x09C_x0D0F_0731_ADDRESS                            0xd0f0731

// Type
#define D18F2x09C_x0D0F_0731_TYPE                               TYPE_D18F2x09C
// Field Data
#define D18F2x09C_x0D0F_0731_Fence2ThresholdTxPad_OFFSET        0
#define D18F2x09C_x0D0F_0731_Fence2ThresholdTxPad_WIDTH         4
#define D18F2x09C_x0D0F_0731_Fence2ThresholdTxPad_MASK          0xf
#define D18F2x09C_x0D0F_0731_Fence2EnableTxPad_OFFSET           4
#define D18F2x09C_x0D0F_0731_Fence2EnableTxPad_WIDTH            1
#define D18F2x09C_x0D0F_0731_Fence2EnableTxPad_MASK             0x10
#define D18F2x09C_x0D0F_0731_Fence2ThresholdTxDll_OFFSET        5
#define D18F2x09C_x0D0F_0731_Fence2ThresholdTxDll_WIDTH         4
#define D18F2x09C_x0D0F_0731_Fence2ThresholdTxDll_MASK          0x1e0
#define D18F2x09C_x0D0F_0731_Fence2EnableTxDll_OFFSET           9
#define D18F2x09C_x0D0F_0731_Fence2EnableTxDll_WIDTH            1
#define D18F2x09C_x0D0F_0731_Fence2EnableTxDll_MASK             0x200
#define D18F2x09C_x0D0F_0731_Fence2ThresholdRxDll_OFFSET        10
#define D18F2x09C_x0D0F_0731_Fence2ThresholdRxDll_WIDTH         4
#define D18F2x09C_x0D0F_0731_Fence2ThresholdRxDll_MASK          0x3c00
#define D18F2x09C_x0D0F_0731_Fence2EnableRxDll_OFFSET           14
#define D18F2x09C_x0D0F_0731_Fence2EnableRxDll_WIDTH            1
#define D18F2x09C_x0D0F_0731_Fence2EnableRxDll_MASK             0x4000
#define D18F2x09C_x0D0F_0731_Reserved_31_15_OFFSET              15
#define D18F2x09C_x0D0F_0731_Reserved_31_15_WIDTH               17
#define D18F2x09C_x0D0F_0731_Reserved_31_15_MASK                0xffff8000

/// D18F2x09C_x0D0F_0731
typedef union {
  struct {                                                              ///<
    UINT32                                     Fence2ThresholdTxPad:4 ; ///<
    UINT32                                        Fence2EnableTxPad:1 ; ///<
    UINT32                                     Fence2ThresholdTxDll:4 ; ///<
    UINT32                                        Fence2EnableTxDll:1 ; ///<
    UINT32                                     Fence2ThresholdRxDll:4 ; ///<
    UINT32                                        Fence2EnableRxDll:1 ; ///<
    UINT32                                           Reserved_31_15:17; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} D18F2x09C_x0D0F_0731_STRUCT;

// **** D18F2x09C_x0D0F_0F02 Register Definition ****
// Address
#define D18F2x09C_x0D0F_0F02_ADDRESS                            0xd0f0f02

// Type
#define D18F2x09C_x0D0F_0F02_TYPE                               TYPE_D18F2x09C
// Field Data
#define D18F2x09C_x0D0F_0F02_TxPreN_OFFSET                      0
#define D18F2x09C_x0D0F_0F02_TxPreN_WIDTH                       6
#define D18F2x09C_x0D0F_0F02_TxPreN_MASK                        0x3f
#define D18F2x09C_x0D0F_0F02_TxPreP_OFFSET                      6
#define D18F2x09C_x0D0F_0F02_TxPreP_WIDTH                       6
#define D18F2x09C_x0D0F_0F02_TxPreP_MASK                        0xfc0
#define D18F2x09C_x0D0F_0F02_Reserved_14_12_OFFSET              12
#define D18F2x09C_x0D0F_0F02_Reserved_14_12_WIDTH               3
#define D18F2x09C_x0D0F_0F02_Reserved_14_12_MASK                0x7000
#define D18F2x09C_x0D0F_0F02_ValidTxAndPre_OFFSET               15
#define D18F2x09C_x0D0F_0F02_ValidTxAndPre_WIDTH                1
#define D18F2x09C_x0D0F_0F02_ValidTxAndPre_MASK                 0x8000
#define D18F2x09C_x0D0F_0F02_Reserved_31_16_OFFSET              16
#define D18F2x09C_x0D0F_0F02_Reserved_31_16_WIDTH               16
#define D18F2x09C_x0D0F_0F02_Reserved_31_16_MASK                0xffff0000

/// D18F2x09C_x0D0F_0F02
typedef union {
  struct {                                                              ///<
    UINT32                                                   TxPreN:6 ; ///<
    UINT32                                                   TxPreP:6 ; ///<
    UINT32                                           Reserved_14_12:3 ; ///<
    UINT32                                            ValidTxAndPre:1 ; ///<
    UINT32                                           Reserved_31_16:16; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} D18F2x09C_x0D0F_0F02_STRUCT;

// **** D18F2x09C_x0D0F_0F06 Register Definition ****
// Address
#define D18F2x09C_x0D0F_0F06_ADDRESS                            0xd0f0f06

// Type
#define D18F2x09C_x0D0F_0F06_TYPE                               TYPE_D18F2x09C
// Field Data
#define D18F2x09C_x0D0F_0F06_TxPreN_OFFSET                      0
#define D18F2x09C_x0D0F_0F06_TxPreN_WIDTH                       6
#define D18F2x09C_x0D0F_0F06_TxPreN_MASK                        0x3f
#define D18F2x09C_x0D0F_0F06_TxPreP_OFFSET                      6
#define D18F2x09C_x0D0F_0F06_TxPreP_WIDTH                       6
#define D18F2x09C_x0D0F_0F06_TxPreP_MASK                        0xfc0
#define D18F2x09C_x0D0F_0F06_Reserved_31_12_OFFSET              12
#define D18F2x09C_x0D0F_0F06_Reserved_31_12_WIDTH               20
#define D18F2x09C_x0D0F_0F06_Reserved_31_12_MASK                0xfffff000

/// D18F2x09C_x0D0F_0F06
typedef union {
  struct {                                                              ///<
    UINT32                                                   TxPreN:6 ; ///<
    UINT32                                                   TxPreP:6 ; ///<
    UINT32                                           Reserved_31_12:20; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} D18F2x09C_x0D0F_0F06_STRUCT;

// **** D18F2x09C_x0D0F_0F0A Register Definition ****
// Address
#define D18F2x09C_x0D0F_0F0A_ADDRESS                            0xd0f0f0a

// Type
#define D18F2x09C_x0D0F_0F0A_TYPE                               TYPE_D18F2x09C
// Field Data
#define D18F2x09C_x0D0F_0F0A_TxPreN_OFFSET                      0
#define D18F2x09C_x0D0F_0F0A_TxPreN_WIDTH                       6
#define D18F2x09C_x0D0F_0F0A_TxPreN_MASK                        0x3f
#define D18F2x09C_x0D0F_0F0A_TxPreP_OFFSET                      6
#define D18F2x09C_x0D0F_0F0A_TxPreP_WIDTH                       6
#define D18F2x09C_x0D0F_0F0A_TxPreP_MASK                        0xfc0
#define D18F2x09C_x0D0F_0F0A_Reserved_31_12_OFFSET              12
#define D18F2x09C_x0D0F_0F0A_Reserved_31_12_WIDTH               20
#define D18F2x09C_x0D0F_0F0A_Reserved_31_12_MASK                0xfffff000

/// D18F2x09C_x0D0F_0F0A
typedef union {
  struct {                                                              ///<
    UINT32                                                   TxPreN:6 ; ///<
    UINT32                                                   TxPreP:6 ; ///<
    UINT32                                           Reserved_31_12:20; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} D18F2x09C_x0D0F_0F0A_STRUCT;

// **** D18F2x09C_x0D0F_0F0F Register Definition ****
// Address
#define D18F2x09C_x0D0F_0F0F_ADDRESS                            0xd0f0f0f

// Type
#define D18F2x09C_x0D0F_0F0F_TYPE                               TYPE_D18F2x09C
// Field Data
#define D18F2x09C_x0D0F_0F0F_Reserved_11_0_OFFSET               0
#define D18F2x09C_x0D0F_0F0F_Reserved_11_0_WIDTH                12
#define D18F2x09C_x0D0F_0F0F_Reserved_11_0_MASK                 0xfff
#define D18F2x09C_x0D0F_0F0F_AlwaysEnDllClks_OFFSET             12
#define D18F2x09C_x0D0F_0F0F_AlwaysEnDllClks_WIDTH              3
#define D18F2x09C_x0D0F_0F0F_AlwaysEnDllClks_MASK               0x7000
#define D18F2x09C_x0D0F_0F0F_Reserved_31_15_OFFSET              15
#define D18F2x09C_x0D0F_0F0F_Reserved_31_15_WIDTH               17
#define D18F2x09C_x0D0F_0F0F_Reserved_31_15_MASK                0xffff8000

/// D18F2x09C_x0D0F_0F0F
typedef union {
  struct {                                                              ///<
    UINT32                                            Reserved_11_0:12; ///<
    UINT32                                          AlwaysEnDllClks:3 ; ///<
    UINT32                                           Reserved_31_15:17; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} D18F2x09C_x0D0F_0F0F_STRUCT;

// **** D18F2x09C_x0D0F_0F10 Register Definition ****
// Address
#define D18F2x09C_x0D0F_0F10_ADDRESS                            0xd0f0f10

// Type
#define D18F2x09C_x0D0F_0F10_TYPE                               TYPE_D18F2x09C
// Field Data
#define D18F2x09C_x0D0F_0F10_Reserved_11_0_OFFSET               0
#define D18F2x09C_x0D0F_0F10_Reserved_11_0_WIDTH                12
#define D18F2x09C_x0D0F_0F10_Reserved_11_0_MASK                 0xfff
#define D18F2x09C_x0D0F_0F10_EnRxPadStandby_OFFSET              12
#define D18F2x09C_x0D0F_0F10_EnRxPadStandby_WIDTH               1
#define D18F2x09C_x0D0F_0F10_EnRxPadStandby_MASK                0x1000
#define D18F2x09C_x0D0F_0F10_Reserved_31_13_OFFSET              13
#define D18F2x09C_x0D0F_0F10_Reserved_31_13_WIDTH               19
#define D18F2x09C_x0D0F_0F10_Reserved_31_13_MASK                0xffffe000

/// D18F2x09C_x0D0F_0F10
typedef union {
  struct {                                                              ///<
    UINT32                                            Reserved_11_0:12; ///<
    UINT32                                           EnRxPadStandby:1 ; ///<
    UINT32                                           Reserved_31_13:19; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} D18F2x09C_x0D0F_0F10_STRUCT;

// **** D18F2x09C_x0D0F_0F13 Register Definition ****
// Address
#define D18F2x09C_x0D0F_0F13_ADDRESS                            0xd0f0f13

// Type
#define D18F2x09C_x0D0F_0F13_TYPE                               TYPE_D18F2x09C
// Field Data
#define D18F2x09C_x0D0F_0F13_DllDisEarlyL_OFFSET                0
#define D18F2x09C_x0D0F_0F13_DllDisEarlyL_WIDTH                 1
#define D18F2x09C_x0D0F_0F13_DllDisEarlyL_MASK                  0x1
#define D18F2x09C_x0D0F_0F13_DllDisEarlyU_OFFSET                1
#define D18F2x09C_x0D0F_0F13_DllDisEarlyU_WIDTH                 1
#define D18F2x09C_x0D0F_0F13_DllDisEarlyU_MASK                  0x2
#define D18F2x09C_x0D0F_0F13_Reserved_6_2_OFFSET                2
#define D18F2x09C_x0D0F_0F13_Reserved_6_2_WIDTH                 5
#define D18F2x09C_x0D0F_0F13_Reserved_6_2_MASK                  0x7c
#define D18F2x09C_x0D0F_0F13_RxDqsUDllPowerDown_OFFSET          7
#define D18F2x09C_x0D0F_0F13_RxDqsUDllPowerDown_WIDTH           1
#define D18F2x09C_x0D0F_0F13_RxDqsUDllPowerDown_MASK            0x80
#define D18F2x09C_x0D0F_0F13_Reserved_13_8_OFFSET               8
#define D18F2x09C_x0D0F_0F13_Reserved_13_8_WIDTH                6
#define D18F2x09C_x0D0F_0F13_Reserved_13_8_MASK                 0x3f00
#define D18F2x09C_x0D0F_0F13_ProcOdtAdv_OFFSET                  14
#define D18F2x09C_x0D0F_0F13_ProcOdtAdv_WIDTH                   1
#define D18F2x09C_x0D0F_0F13_ProcOdtAdv_MASK                    0x4000
#define D18F2x09C_x0D0F_0F13_Reserved_31_15_OFFSET              15
#define D18F2x09C_x0D0F_0F13_Reserved_31_15_WIDTH               17
#define D18F2x09C_x0D0F_0F13_Reserved_31_15_MASK                0xffff8000

/// D18F2x09C_x0D0F_0F13
typedef union {
  struct {                                                              ///<
    UINT32                                             DllDisEarlyL:1 ; ///<
    UINT32                                             DllDisEarlyU:1 ; ///<
    UINT32                                             Reserved_6_2:5 ; ///<
    UINT32                                       RxDqsUDllPowerDown:1 ; ///<
    UINT32                                            Reserved_13_8:6 ; ///<
    UINT32                                               ProcOdtAdv:1 ; ///<
    UINT32                                           Reserved_31_15:17; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} D18F2x09C_x0D0F_0F13_STRUCT;

// **** D18F2x09C_x0D0F_0F1F Register Definition ****
// Address
#define D18F2x09C_x0D0F_0F1F_ADDRESS                            0xd0f0f1f

// Type
#define D18F2x09C_x0D0F_0F1F_TYPE                               TYPE_D18F2x09C
// Field Data
#define D18F2x09C_x0D0F_0F1F_Reserved_2_0_OFFSET                0
#define D18F2x09C_x0D0F_0F1F_Reserved_2_0_WIDTH                 3
#define D18F2x09C_x0D0F_0F1F_Reserved_2_0_MASK                  0x7
#define D18F2x09C_x0D0F_0F1F_RxVioLvl_OFFSET                    3
#define D18F2x09C_x0D0F_0F1F_RxVioLvl_WIDTH                     2
#define D18F2x09C_x0D0F_0F1F_RxVioLvl_MASK                      0x18
#define D18F2x09C_x0D0F_0F1F_Reserved_31_5_OFFSET               5
#define D18F2x09C_x0D0F_0F1F_Reserved_31_5_WIDTH                27
#define D18F2x09C_x0D0F_0F1F_Reserved_31_5_MASK                 0xffffffe0

/// D18F2x09C_x0D0F_0F1F
typedef union {
  struct {                                                              ///<
    UINT32                                             Reserved_2_0:3 ; ///<
    UINT32                                                 RxVioLvl:2 ; ///<
    UINT32                                            Reserved_31_5:27; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} D18F2x09C_x0D0F_0F1F_STRUCT;

// **** D18F2x09C_x0D0F_0F30 Register Definition ****
// Address
#define D18F2x09C_x0D0F_0F30_ADDRESS                            0xd0f0f30

// Type
#define D18F2x09C_x0D0F_0F30_TYPE                               TYPE_D18F2x09C
// Field Data
#define D18F2x09C_x0D0F_0F30_Reserved_4_0_OFFSET                0
#define D18F2x09C_x0D0F_0F30_Reserved_4_0_WIDTH                 5
#define D18F2x09C_x0D0F_0F30_Reserved_4_0_MASK                  0x1f
#define D18F2x09C_x0D0F_0F30_PchgPdTxCClkGateDis_OFFSET         5
#define D18F2x09C_x0D0F_0F30_PchgPdTxCClkGateDis_WIDTH          1
#define D18F2x09C_x0D0F_0F30_PchgPdTxCClkGateDis_MASK           0x20
#define D18F2x09C_x0D0F_0F30_Reserved_31_6_OFFSET               6
#define D18F2x09C_x0D0F_0F30_Reserved_31_6_WIDTH                26
#define D18F2x09C_x0D0F_0F30_Reserved_31_6_MASK                 0xffffffc0

/// D18F2x09C_x0D0F_0F30
typedef union {
  struct {                                                              ///<
    UINT32                                             Reserved_4_0:5 ; ///<
    UINT32                                      PchgPdTxCClkGateDis:1 ; ///<
    UINT32                                            Reserved_31_6:26; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} D18F2x09C_x0D0F_0F30_STRUCT;

// **** D18F2x09C_x0D0F_0F31 Register Definition ****
// Address
#define D18F2x09C_x0D0F_0F31_ADDRESS                            0xd0f0f31

// Type
#define D18F2x09C_x0D0F_0F31_TYPE                               TYPE_D18F2x09C
// Field Data
#define D18F2x09C_x0D0F_0F31_Fence2ThresholdTxPad_OFFSET        0
#define D18F2x09C_x0D0F_0F31_Fence2ThresholdTxPad_WIDTH         4
#define D18F2x09C_x0D0F_0F31_Fence2ThresholdTxPad_MASK          0xf
#define D18F2x09C_x0D0F_0F31_Fence2EnableTxPad_OFFSET           4
#define D18F2x09C_x0D0F_0F31_Fence2EnableTxPad_WIDTH            1
#define D18F2x09C_x0D0F_0F31_Fence2EnableTxPad_MASK             0x10
#define D18F2x09C_x0D0F_0F31_Fence2ThresholdTxDll_OFFSET        5
#define D18F2x09C_x0D0F_0F31_Fence2ThresholdTxDll_WIDTH         4
#define D18F2x09C_x0D0F_0F31_Fence2ThresholdTxDll_MASK          0x1e0
#define D18F2x09C_x0D0F_0F31_Fence2EnableTxDll_OFFSET           9
#define D18F2x09C_x0D0F_0F31_Fence2EnableTxDll_WIDTH            1
#define D18F2x09C_x0D0F_0F31_Fence2EnableTxDll_MASK             0x200
#define D18F2x09C_x0D0F_0F31_Fence2ThresholdRxDll_OFFSET        10
#define D18F2x09C_x0D0F_0F31_Fence2ThresholdRxDll_WIDTH         4
#define D18F2x09C_x0D0F_0F31_Fence2ThresholdRxDll_MASK          0x3c00
#define D18F2x09C_x0D0F_0F31_Fence2EnableRxDll_OFFSET           14
#define D18F2x09C_x0D0F_0F31_Fence2EnableRxDll_WIDTH            1
#define D18F2x09C_x0D0F_0F31_Fence2EnableRxDll_MASK             0x4000
#define D18F2x09C_x0D0F_0F31_Reserved_31_15_OFFSET              15
#define D18F2x09C_x0D0F_0F31_Reserved_31_15_WIDTH               17
#define D18F2x09C_x0D0F_0F31_Reserved_31_15_MASK                0xffff8000

/// D18F2x09C_x0D0F_0F31
typedef union {
  struct {                                                              ///<
    UINT32                                     Fence2ThresholdTxPad:4 ; ///<
    UINT32                                        Fence2EnableTxPad:1 ; ///<
    UINT32                                     Fence2ThresholdTxDll:4 ; ///<
    UINT32                                        Fence2EnableTxDll:1 ; ///<
    UINT32                                     Fence2ThresholdRxDll:4 ; ///<
    UINT32                                        Fence2EnableRxDll:1 ; ///<
    UINT32                                           Reserved_31_15:17; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} D18F2x09C_x0D0F_0F31_STRUCT;

// **** D18F2x09C_x0D0F_2002 Register Definition ****
// Address
#define D18F2x09C_x0D0F_2002_ADDRESS                            0xd0f2002

// Type
#define D18F2x09C_x0D0F_2002_TYPE                               TYPE_D18F2x09C
// Field Data
#define D18F2x09C_x0D0F_2002_TxPreN_OFFSET                      0
#define D18F2x09C_x0D0F_2002_TxPreN_WIDTH                       6
#define D18F2x09C_x0D0F_2002_TxPreN_MASK                        0x3f
#define D18F2x09C_x0D0F_2002_TxPreP_OFFSET                      6
#define D18F2x09C_x0D0F_2002_TxPreP_WIDTH                       6
#define D18F2x09C_x0D0F_2002_TxPreP_MASK                        0xfc0
#define D18F2x09C_x0D0F_2002_Reserved_14_12_OFFSET              12
#define D18F2x09C_x0D0F_2002_Reserved_14_12_WIDTH               3
#define D18F2x09C_x0D0F_2002_Reserved_14_12_MASK                0x7000
#define D18F2x09C_x0D0F_2002_ValidTxAndPre_OFFSET               15
#define D18F2x09C_x0D0F_2002_ValidTxAndPre_WIDTH                1
#define D18F2x09C_x0D0F_2002_ValidTxAndPre_MASK                 0x8000
#define D18F2x09C_x0D0F_2002_Reserved_31_16_OFFSET              16
#define D18F2x09C_x0D0F_2002_Reserved_31_16_WIDTH               16
#define D18F2x09C_x0D0F_2002_Reserved_31_16_MASK                0xffff0000

/// D18F2x09C_x0D0F_2002
typedef union {
  struct {                                                              ///<
    UINT32                                                   TxPreN:6 ; ///<
    UINT32                                                   TxPreP:6 ; ///<
    UINT32                                           Reserved_14_12:3 ; ///<
    UINT32                                            ValidTxAndPre:1 ; ///<
    UINT32                                           Reserved_31_16:16; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} D18F2x09C_x0D0F_2002_STRUCT;

// **** D18F2x09C_x0D0F_201F Register Definition ****
// Address
#define D18F2x09C_x0D0F_201F_ADDRESS                            0xd0f201f

// Type
#define D18F2x09C_x0D0F_201F_TYPE                               TYPE_D18F2x09C
// Field Data
#define D18F2x09C_x0D0F_201F_Reserved_2_0_OFFSET                0
#define D18F2x09C_x0D0F_201F_Reserved_2_0_WIDTH                 3
#define D18F2x09C_x0D0F_201F_Reserved_2_0_MASK                  0x7
#define D18F2x09C_x0D0F_201F_RxVioLvl_OFFSET                    3
#define D18F2x09C_x0D0F_201F_RxVioLvl_WIDTH                     2
#define D18F2x09C_x0D0F_201F_RxVioLvl_MASK                      0x18
#define D18F2x09C_x0D0F_201F_Reserved_31_5_OFFSET               5
#define D18F2x09C_x0D0F_201F_Reserved_31_5_WIDTH                27
#define D18F2x09C_x0D0F_201F_Reserved_31_5_MASK                 0xffffffe0

/// D18F2x09C_x0D0F_201F
typedef union {
  struct {                                                              ///<
    UINT32                                             Reserved_2_0:3 ; ///<
    UINT32                                                 RxVioLvl:2 ; ///<
    UINT32                                            Reserved_31_5:27; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} D18F2x09C_x0D0F_201F_STRUCT;

// **** D18F2x09C_x0D0F_2020 Register Definition ****
// Address
#define D18F2x09C_x0D0F_2020_ADDRESS                            0xd0f2020

// Type
#define D18F2x09C_x0D0F_2020_TYPE                               TYPE_D18F2x09C
// Field Data
#define D18F2x09C_x0D0F_2020_ClkFineDly_OFFSET                  0
#define D18F2x09C_x0D0F_2020_ClkFineDly_WIDTH                   5
#define D18F2x09C_x0D0F_2020_ClkFineDly_MASK                    0x1f
#define D18F2x09C_x0D0F_2020_Reserved_6_5_OFFSET                5
#define D18F2x09C_x0D0F_2020_Reserved_6_5_WIDTH                 2
#define D18F2x09C_x0D0F_2020_Reserved_6_5_MASK                  0x60
#define D18F2x09C_x0D0F_2020_FenceBit_OFFSET                    7
#define D18F2x09C_x0D0F_2020_FenceBit_WIDTH                     1
#define D18F2x09C_x0D0F_2020_FenceBit_MASK                      0x80
#define D18F2x09C_x0D0F_2020_Reserved_13_8_OFFSET               8
#define D18F2x09C_x0D0F_2020_Reserved_13_8_WIDTH                6
#define D18F2x09C_x0D0F_2020_Reserved_13_8_MASK                 0x3f00
#define D18F2x09C_x0D0F_2020_DllNukeLoad_OFFSET                 14
#define D18F2x09C_x0D0F_2020_DllNukeLoad_WIDTH                  1
#define D18F2x09C_x0D0F_2020_DllNukeLoad_MASK                   0x4000
#define D18F2x09C_x0D0F_2020_Reserved_31_15_OFFSET              15
#define D18F2x09C_x0D0F_2020_Reserved_31_15_WIDTH               17
#define D18F2x09C_x0D0F_2020_Reserved_31_15_MASK                0xffff8000

/// D18F2x09C_x0D0F_2020
typedef union {
  struct {                                                              ///<
    UINT32                                               ClkFineDly:5 ; ///<
    UINT32                                             Reserved_6_5:2 ; ///<
    UINT32                                                 FenceBit:1 ; ///<
    UINT32                                            Reserved_13_8:6 ; ///<
    UINT32                                              DllNukeLoad:1 ; ///<
    UINT32                                           Reserved_31_15:17; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} D18F2x09C_x0D0F_2020_STRUCT;

// **** D18F2x09C_x0D0F_2030 Register Definition ****
// Address
#define D18F2x09C_x0D0F_2030_ADDRESS                            0xd0f2030

// Type
#define D18F2x09C_x0D0F_2030_TYPE                               TYPE_D18F2x09C
// Field Data
#define D18F2x09C_x0D0F_2030_Reserved_3_0_OFFSET                0
#define D18F2x09C_x0D0F_2030_Reserved_3_0_WIDTH                 4
#define D18F2x09C_x0D0F_2030_Reserved_3_0_MASK                  0xf
#define D18F2x09C_x0D0F_2030_PwrDn_OFFSET                       4
#define D18F2x09C_x0D0F_2030_PwrDn_WIDTH                        1
#define D18F2x09C_x0D0F_2030_PwrDn_MASK                         0x10
#define D18F2x09C_x0D0F_2030_Reserved_31_5_OFFSET               5
#define D18F2x09C_x0D0F_2030_Reserved_31_5_WIDTH                27
#define D18F2x09C_x0D0F_2030_Reserved_31_5_MASK                 0xffffffe0

/// D18F2x09C_x0D0F_2030
typedef union {
  struct {                                                              ///<
    UINT32                                             Reserved_3_0:4 ; ///<
    UINT32                                                    PwrDn:1 ; ///<
    UINT32                                            Reserved_31_5:27; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} D18F2x09C_x0D0F_2030_STRUCT;

// **** D18F2x09C_x0D0F_2031 Register Definition ****
// Address
#define D18F2x09C_x0D0F_2031_ADDRESS                            0xd0f2031

// Type
#define D18F2x09C_x0D0F_2031_TYPE                               TYPE_D18F2x09C
// Field Data
#define D18F2x09C_x0D0F_2031_Fence2ThresholdTxPad_OFFSET        0
#define D18F2x09C_x0D0F_2031_Fence2ThresholdTxPad_WIDTH         4
#define D18F2x09C_x0D0F_2031_Fence2ThresholdTxPad_MASK          0xf
#define D18F2x09C_x0D0F_2031_Fence2EnableTxPad_OFFSET           4
#define D18F2x09C_x0D0F_2031_Fence2EnableTxPad_WIDTH            1
#define D18F2x09C_x0D0F_2031_Fence2EnableTxPad_MASK             0x10
#define D18F2x09C_x0D0F_2031_Reserved_31_5_OFFSET               5
#define D18F2x09C_x0D0F_2031_Reserved_31_5_WIDTH                27
#define D18F2x09C_x0D0F_2031_Reserved_31_5_MASK                 0xffffffe0

/// D18F2x09C_x0D0F_2031
typedef union {
  struct {                                                              ///<
    UINT32                                     Fence2ThresholdTxPad:4 ; ///<
    UINT32                                        Fence2EnableTxPad:1 ; ///<
    UINT32                                            Reserved_31_5:27; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} D18F2x09C_x0D0F_2031_STRUCT;

// **** D18F2x09C_x0D0F_2102 Register Definition ****
// Address
#define D18F2x09C_x0D0F_2102_ADDRESS                            0xd0f2102

// Type
#define D18F2x09C_x0D0F_2102_TYPE                               TYPE_D18F2x09C
// Field Data
#define D18F2x09C_x0D0F_2102_TxPreN_OFFSET                      0
#define D18F2x09C_x0D0F_2102_TxPreN_WIDTH                       6
#define D18F2x09C_x0D0F_2102_TxPreN_MASK                        0x3f
#define D18F2x09C_x0D0F_2102_TxPreP_OFFSET                      6
#define D18F2x09C_x0D0F_2102_TxPreP_WIDTH                       6
#define D18F2x09C_x0D0F_2102_TxPreP_MASK                        0xfc0
#define D18F2x09C_x0D0F_2102_Reserved_14_12_OFFSET              12
#define D18F2x09C_x0D0F_2102_Reserved_14_12_WIDTH               3
#define D18F2x09C_x0D0F_2102_Reserved_14_12_MASK                0x7000
#define D18F2x09C_x0D0F_2102_ValidTxAndPre_OFFSET               15
#define D18F2x09C_x0D0F_2102_ValidTxAndPre_WIDTH                1
#define D18F2x09C_x0D0F_2102_ValidTxAndPre_MASK                 0x8000
#define D18F2x09C_x0D0F_2102_Reserved_31_16_OFFSET              16
#define D18F2x09C_x0D0F_2102_Reserved_31_16_WIDTH               16
#define D18F2x09C_x0D0F_2102_Reserved_31_16_MASK                0xffff0000

/// D18F2x09C_x0D0F_2102
typedef union {
  struct {                                                              ///<
    UINT32                                                   TxPreN:6 ; ///<
    UINT32                                                   TxPreP:6 ; ///<
    UINT32                                           Reserved_14_12:3 ; ///<
    UINT32                                            ValidTxAndPre:1 ; ///<
    UINT32                                           Reserved_31_16:16; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} D18F2x09C_x0D0F_2102_STRUCT;

// **** D18F2x09C_x0D0F_211F Register Definition ****
// Address
#define D18F2x09C_x0D0F_211F_ADDRESS                            0xd0f211f

// Type
#define D18F2x09C_x0D0F_211F_TYPE                               TYPE_D18F2x09C
// Field Data
#define D18F2x09C_x0D0F_211F_Reserved_2_0_OFFSET                0
#define D18F2x09C_x0D0F_211F_Reserved_2_0_WIDTH                 3
#define D18F2x09C_x0D0F_211F_Reserved_2_0_MASK                  0x7
#define D18F2x09C_x0D0F_211F_RxVioLvl_OFFSET                    3
#define D18F2x09C_x0D0F_211F_RxVioLvl_WIDTH                     2
#define D18F2x09C_x0D0F_211F_RxVioLvl_MASK                      0x18
#define D18F2x09C_x0D0F_211F_Reserved_31_5_OFFSET               5
#define D18F2x09C_x0D0F_211F_Reserved_31_5_WIDTH                27
#define D18F2x09C_x0D0F_211F_Reserved_31_5_MASK                 0xffffffe0

/// D18F2x09C_x0D0F_211F
typedef union {
  struct {                                                              ///<
    UINT32                                             Reserved_2_0:3 ; ///<
    UINT32                                                 RxVioLvl:2 ; ///<
    UINT32                                            Reserved_31_5:27; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} D18F2x09C_x0D0F_211F_STRUCT;

// **** D18F2x09C_x0D0F_2120 Register Definition ****
// Address
#define D18F2x09C_x0D0F_2120_ADDRESS                            0xd0f2120

// Type
#define D18F2x09C_x0D0F_2120_TYPE                               TYPE_D18F2x09C
// Field Data
#define D18F2x09C_x0D0F_2120_ClkFineDly_OFFSET                  0
#define D18F2x09C_x0D0F_2120_ClkFineDly_WIDTH                   5
#define D18F2x09C_x0D0F_2120_ClkFineDly_MASK                    0x1f
#define D18F2x09C_x0D0F_2120_Reserved_6_5_OFFSET                5
#define D18F2x09C_x0D0F_2120_Reserved_6_5_WIDTH                 2
#define D18F2x09C_x0D0F_2120_Reserved_6_5_MASK                  0x60
#define D18F2x09C_x0D0F_2120_FenceBit_OFFSET                    7
#define D18F2x09C_x0D0F_2120_FenceBit_WIDTH                     1
#define D18F2x09C_x0D0F_2120_FenceBit_MASK                      0x80
#define D18F2x09C_x0D0F_2120_Reserved_13_8_OFFSET               8
#define D18F2x09C_x0D0F_2120_Reserved_13_8_WIDTH                6
#define D18F2x09C_x0D0F_2120_Reserved_13_8_MASK                 0x3f00
#define D18F2x09C_x0D0F_2120_DllNukeLoad_OFFSET                 14
#define D18F2x09C_x0D0F_2120_DllNukeLoad_WIDTH                  1
#define D18F2x09C_x0D0F_2120_DllNukeLoad_MASK                   0x4000
#define D18F2x09C_x0D0F_2120_Reserved_31_15_OFFSET              15
#define D18F2x09C_x0D0F_2120_Reserved_31_15_WIDTH               17
#define D18F2x09C_x0D0F_2120_Reserved_31_15_MASK                0xffff8000

/// D18F2x09C_x0D0F_2120
typedef union {
  struct {                                                              ///<
    UINT32                                               ClkFineDly:5 ; ///<
    UINT32                                             Reserved_6_5:2 ; ///<
    UINT32                                                 FenceBit:1 ; ///<
    UINT32                                            Reserved_13_8:6 ; ///<
    UINT32                                              DllNukeLoad:1 ; ///<
    UINT32                                           Reserved_31_15:17; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} D18F2x09C_x0D0F_2120_STRUCT;

// **** D18F2x09C_x0D0F_2130 Register Definition ****
// Address
#define D18F2x09C_x0D0F_2130_ADDRESS                            0xd0f2130

// Type
#define D18F2x09C_x0D0F_2130_TYPE                               TYPE_D18F2x09C
// Field Data
#define D18F2x09C_x0D0F_2130_Reserved_3_0_OFFSET                0
#define D18F2x09C_x0D0F_2130_Reserved_3_0_WIDTH                 4
#define D18F2x09C_x0D0F_2130_Reserved_3_0_MASK                  0xf
#define D18F2x09C_x0D0F_2130_PwrDn_OFFSET                       4
#define D18F2x09C_x0D0F_2130_PwrDn_WIDTH                        1
#define D18F2x09C_x0D0F_2130_PwrDn_MASK                         0x10
#define D18F2x09C_x0D0F_2130_Reserved_31_5_OFFSET               5
#define D18F2x09C_x0D0F_2130_Reserved_31_5_WIDTH                27
#define D18F2x09C_x0D0F_2130_Reserved_31_5_MASK                 0xffffffe0

/// D18F2x09C_x0D0F_2130
typedef union {
  struct {                                                              ///<
    UINT32                                             Reserved_3_0:4 ; ///<
    UINT32                                                    PwrDn:1 ; ///<
    UINT32                                            Reserved_31_5:27; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} D18F2x09C_x0D0F_2130_STRUCT;

// **** D18F2x09C_x0D0F_2131 Register Definition ****
// Address
#define D18F2x09C_x0D0F_2131_ADDRESS                            0xd0f2131

// Type
#define D18F2x09C_x0D0F_2131_TYPE                               TYPE_D18F2x09C
// Field Data
#define D18F2x09C_x0D0F_2131_Fence2ThresholdTxPad_OFFSET        0
#define D18F2x09C_x0D0F_2131_Fence2ThresholdTxPad_WIDTH         4
#define D18F2x09C_x0D0F_2131_Fence2ThresholdTxPad_MASK          0xf
#define D18F2x09C_x0D0F_2131_Fence2EnableTxPad_OFFSET           4
#define D18F2x09C_x0D0F_2131_Fence2EnableTxPad_WIDTH            1
#define D18F2x09C_x0D0F_2131_Fence2EnableTxPad_MASK             0x10
#define D18F2x09C_x0D0F_2131_Reserved_31_5_OFFSET               5
#define D18F2x09C_x0D0F_2131_Reserved_31_5_WIDTH                27
#define D18F2x09C_x0D0F_2131_Reserved_31_5_MASK                 0xffffffe0

/// D18F2x09C_x0D0F_2131
typedef union {
  struct {                                                              ///<
    UINT32                                     Fence2ThresholdTxPad:4 ; ///<
    UINT32                                        Fence2EnableTxPad:1 ; ///<
    UINT32                                            Reserved_31_5:27; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} D18F2x09C_x0D0F_2131_STRUCT;

// **** D18F2x09C_x0D0F_4009 Register Definition ****
// Address
#define D18F2x09C_x0D0F_4009_ADDRESS                            0xd0f4009

// Type
#define D18F2x09C_x0D0F_4009_TYPE                               TYPE_D18F2x09C
// Field Data
#define D18F2x09C_x0D0F_4009_Reserved_1_0_OFFSET                0
#define D18F2x09C_x0D0F_4009_Reserved_1_0_WIDTH                 2
#define D18F2x09C_x0D0F_4009_Reserved_1_0_MASK                  0x3
#define D18F2x09C_x0D0F_4009_ComparatorAdjust_OFFSET            2
#define D18F2x09C_x0D0F_4009_ComparatorAdjust_WIDTH             2
#define D18F2x09C_x0D0F_4009_ComparatorAdjust_MASK              0xc
#define D18F2x09C_x0D0F_4009_Reserved_13_4_OFFSET               4
#define D18F2x09C_x0D0F_4009_Reserved_13_4_WIDTH                10
#define D18F2x09C_x0D0F_4009_Reserved_13_4_MASK                 0x3ff0
#define D18F2x09C_x0D0F_4009_CmpVioLvl_OFFSET                   14
#define D18F2x09C_x0D0F_4009_CmpVioLvl_WIDTH                    2
#define D18F2x09C_x0D0F_4009_CmpVioLvl_MASK                     0xc000
#define D18F2x09C_x0D0F_4009_Reserved_31_16_OFFSET              16
#define D18F2x09C_x0D0F_4009_Reserved_31_16_WIDTH               16
#define D18F2x09C_x0D0F_4009_Reserved_31_16_MASK                0xffff0000

/// D18F2x09C_x0D0F_4009
typedef union {
  struct {                                                              ///<
    UINT32                                             Reserved_1_0:2 ; ///<
    UINT32                                         ComparatorAdjust:2 ; ///<
    UINT32                                            Reserved_13_4:10; ///<
    UINT32                                                CmpVioLvl:2 ; ///<
    UINT32                                           Reserved_31_16:16; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} D18F2x09C_x0D0F_4009_STRUCT;

// **** D18F2x09C_x0D0F_8002 Register Definition ****
// Address
#define D18F2x09C_x0D0F_8002_ADDRESS                            0xd0f8002

// Type
#define D18F2x09C_x0D0F_8002_TYPE                               TYPE_D18F2x09C
// Field Data
#define D18F2x09C_x0D0F_8002_TxPreN_OFFSET                      0
#define D18F2x09C_x0D0F_8002_TxPreN_WIDTH                       6
#define D18F2x09C_x0D0F_8002_TxPreN_MASK                        0x3f
#define D18F2x09C_x0D0F_8002_TxPreP_OFFSET                      6
#define D18F2x09C_x0D0F_8002_TxPreP_WIDTH                       6
#define D18F2x09C_x0D0F_8002_TxPreP_MASK                        0xfc0
#define D18F2x09C_x0D0F_8002_Reserved_14_12_OFFSET              12
#define D18F2x09C_x0D0F_8002_Reserved_14_12_WIDTH               3
#define D18F2x09C_x0D0F_8002_Reserved_14_12_MASK                0x7000
#define D18F2x09C_x0D0F_8002_ValidTxAndPre_OFFSET               15
#define D18F2x09C_x0D0F_8002_ValidTxAndPre_WIDTH                1
#define D18F2x09C_x0D0F_8002_ValidTxAndPre_MASK                 0x8000
#define D18F2x09C_x0D0F_8002_Reserved_31_16_OFFSET              16
#define D18F2x09C_x0D0F_8002_Reserved_31_16_WIDTH               16
#define D18F2x09C_x0D0F_8002_Reserved_31_16_MASK                0xffff0000

/// D18F2x09C_x0D0F_8002
typedef union {
  struct {                                                              ///<
    UINT32                                                   TxPreN:6 ; ///<
    UINT32                                                   TxPreP:6 ; ///<
    UINT32                                           Reserved_14_12:3 ; ///<
    UINT32                                            ValidTxAndPre:1 ; ///<
    UINT32                                           Reserved_31_16:16; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} D18F2x09C_x0D0F_8002_STRUCT;

// **** D18F2x09C_x0D0F_8006 Register Definition ****
// Address
#define D18F2x09C_x0D0F_8006_ADDRESS                            0xd0f8006

// Type
#define D18F2x09C_x0D0F_8006_TYPE                               TYPE_D18F2x09C
// Field Data
#define D18F2x09C_x0D0F_8006_TxPreN_OFFSET                      0
#define D18F2x09C_x0D0F_8006_TxPreN_WIDTH                       6
#define D18F2x09C_x0D0F_8006_TxPreN_MASK                        0x3f
#define D18F2x09C_x0D0F_8006_TxPreP_OFFSET                      6
#define D18F2x09C_x0D0F_8006_TxPreP_WIDTH                       6
#define D18F2x09C_x0D0F_8006_TxPreP_MASK                        0xfc0
#define D18F2x09C_x0D0F_8006_Reserved_31_12_OFFSET              12
#define D18F2x09C_x0D0F_8006_Reserved_31_12_WIDTH               20
#define D18F2x09C_x0D0F_8006_Reserved_31_12_MASK                0xfffff000

/// D18F2x09C_x0D0F_8006
typedef union {
  struct {                                                              ///<
    UINT32                                                   TxPreN:6 ; ///<
    UINT32                                                   TxPreP:6 ; ///<
    UINT32                                           Reserved_31_12:20; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} D18F2x09C_x0D0F_8006_STRUCT;

// **** D18F2x09C_x0D0F_800A Register Definition ****
// Address
#define D18F2x09C_x0D0F_800A_ADDRESS                            0xd0f800a

// Type
#define D18F2x09C_x0D0F_800A_TYPE                               TYPE_D18F2x09C
// Field Data
#define D18F2x09C_x0D0F_800A_TxPreN_OFFSET                      0
#define D18F2x09C_x0D0F_800A_TxPreN_WIDTH                       6
#define D18F2x09C_x0D0F_800A_TxPreN_MASK                        0x3f
#define D18F2x09C_x0D0F_800A_TxPreP_OFFSET                      6
#define D18F2x09C_x0D0F_800A_TxPreP_WIDTH                       6
#define D18F2x09C_x0D0F_800A_TxPreP_MASK                        0xfc0
#define D18F2x09C_x0D0F_800A_Reserved_31_12_OFFSET              12
#define D18F2x09C_x0D0F_800A_Reserved_31_12_WIDTH               20
#define D18F2x09C_x0D0F_800A_Reserved_31_12_MASK                0xfffff000

/// D18F2x09C_x0D0F_800A
typedef union {
  struct {                                                              ///<
    UINT32                                                   TxPreN:6 ; ///<
    UINT32                                                   TxPreP:6 ; ///<
    UINT32                                           Reserved_31_12:20; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} D18F2x09C_x0D0F_800A_STRUCT;

// **** D18F2x09C_x0D0F_801F Register Definition ****
// Address
#define D18F2x09C_x0D0F_801F_ADDRESS                            0xd0f801f

// Type
#define D18F2x09C_x0D0F_801F_TYPE                               TYPE_D18F2x09C
// Field Data
#define D18F2x09C_x0D0F_801F_Reserved_2_0_OFFSET                0
#define D18F2x09C_x0D0F_801F_Reserved_2_0_WIDTH                 3
#define D18F2x09C_x0D0F_801F_Reserved_2_0_MASK                  0x7
#define D18F2x09C_x0D0F_801F_RxVioLvl_OFFSET                    3
#define D18F2x09C_x0D0F_801F_RxVioLvl_WIDTH                     2
#define D18F2x09C_x0D0F_801F_RxVioLvl_MASK                      0x18
#define D18F2x09C_x0D0F_801F_Reserved_31_5_OFFSET               5
#define D18F2x09C_x0D0F_801F_Reserved_31_5_WIDTH                27
#define D18F2x09C_x0D0F_801F_Reserved_31_5_MASK                 0xffffffe0

/// D18F2x09C_x0D0F_801F
typedef union {
  struct {                                                              ///<
    UINT32                                             Reserved_2_0:3 ; ///<
    UINT32                                                 RxVioLvl:2 ; ///<
    UINT32                                            Reserved_31_5:27; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} D18F2x09C_x0D0F_801F_STRUCT;

// **** D18F2x09C_x0D0F_8031 Register Definition ****
// Address
#define D18F2x09C_x0D0F_8031_ADDRESS                            0xd0f8031

// Type
#define D18F2x09C_x0D0F_8031_TYPE                               TYPE_D18F2x09C
// Field Data
#define D18F2x09C_x0D0F_8031_Fence2ThresholdTxPad_OFFSET        0
#define D18F2x09C_x0D0F_8031_Fence2ThresholdTxPad_WIDTH         4
#define D18F2x09C_x0D0F_8031_Fence2ThresholdTxPad_MASK          0xf
#define D18F2x09C_x0D0F_8031_Fence2EnableTxPad_OFFSET           4
#define D18F2x09C_x0D0F_8031_Fence2EnableTxPad_WIDTH            1
#define D18F2x09C_x0D0F_8031_Fence2EnableTxPad_MASK             0x10
#define D18F2x09C_x0D0F_8031_Reserved_31_5_OFFSET               5
#define D18F2x09C_x0D0F_8031_Reserved_31_5_WIDTH                27
#define D18F2x09C_x0D0F_8031_Reserved_31_5_MASK                 0xffffffe0

/// D18F2x09C_x0D0F_8031
typedef union {
  struct {                                                              ///<
    UINT32                                     Fence2ThresholdTxPad:4 ; ///<
    UINT32                                        Fence2EnableTxPad:1 ; ///<
    UINT32                                            Reserved_31_5:27; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} D18F2x09C_x0D0F_8031_STRUCT;

// **** D18F2x09C_x0D0F_8102 Register Definition ****
// Address
#define D18F2x09C_x0D0F_8102_ADDRESS                            0xd0f8102

// Type
#define D18F2x09C_x0D0F_8102_TYPE                               TYPE_D18F2x09C
// Field Data
#define D18F2x09C_x0D0F_8102_TxPreN_OFFSET                      0
#define D18F2x09C_x0D0F_8102_TxPreN_WIDTH                       6
#define D18F2x09C_x0D0F_8102_TxPreN_MASK                        0x3f
#define D18F2x09C_x0D0F_8102_TxPreP_OFFSET                      6
#define D18F2x09C_x0D0F_8102_TxPreP_WIDTH                       6
#define D18F2x09C_x0D0F_8102_TxPreP_MASK                        0xfc0
#define D18F2x09C_x0D0F_8102_Reserved_14_12_OFFSET              12
#define D18F2x09C_x0D0F_8102_Reserved_14_12_WIDTH               3
#define D18F2x09C_x0D0F_8102_Reserved_14_12_MASK                0x7000
#define D18F2x09C_x0D0F_8102_ValidTxAndPre_OFFSET               15
#define D18F2x09C_x0D0F_8102_ValidTxAndPre_WIDTH                1
#define D18F2x09C_x0D0F_8102_ValidTxAndPre_MASK                 0x8000
#define D18F2x09C_x0D0F_8102_Reserved_31_16_OFFSET              16
#define D18F2x09C_x0D0F_8102_Reserved_31_16_WIDTH               16
#define D18F2x09C_x0D0F_8102_Reserved_31_16_MASK                0xffff0000

/// D18F2x09C_x0D0F_8102
typedef union {
  struct {                                                              ///<
    UINT32                                                   TxPreN:6 ; ///<
    UINT32                                                   TxPreP:6 ; ///<
    UINT32                                           Reserved_14_12:3 ; ///<
    UINT32                                            ValidTxAndPre:1 ; ///<
    UINT32                                           Reserved_31_16:16; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} D18F2x09C_x0D0F_8102_STRUCT;

// **** D18F2x09C_x0D0F_8106 Register Definition ****
// Address
#define D18F2x09C_x0D0F_8106_ADDRESS                            0xd0f8106

// Type
#define D18F2x09C_x0D0F_8106_TYPE                               TYPE_D18F2x09C
// Field Data
#define D18F2x09C_x0D0F_8106_TxPreN_OFFSET                      0
#define D18F2x09C_x0D0F_8106_TxPreN_WIDTH                       6
#define D18F2x09C_x0D0F_8106_TxPreN_MASK                        0x3f
#define D18F2x09C_x0D0F_8106_TxPreP_OFFSET                      6
#define D18F2x09C_x0D0F_8106_TxPreP_WIDTH                       6
#define D18F2x09C_x0D0F_8106_TxPreP_MASK                        0xfc0
#define D18F2x09C_x0D0F_8106_Reserved_31_12_OFFSET              12
#define D18F2x09C_x0D0F_8106_Reserved_31_12_WIDTH               20
#define D18F2x09C_x0D0F_8106_Reserved_31_12_MASK                0xfffff000

/// D18F2x09C_x0D0F_8106
typedef union {
  struct {                                                              ///<
    UINT32                                                   TxPreN:6 ; ///<
    UINT32                                                   TxPreP:6 ; ///<
    UINT32                                           Reserved_31_12:20; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} D18F2x09C_x0D0F_8106_STRUCT;

// **** D18F2x09C_x0D0F_810A Register Definition ****
// Address
#define D18F2x09C_x0D0F_810A_ADDRESS                            0xd0f810a

// Type
#define D18F2x09C_x0D0F_810A_TYPE                               TYPE_D18F2x09C
// Field Data
#define D18F2x09C_x0D0F_810A_TxPreN_OFFSET                      0
#define D18F2x09C_x0D0F_810A_TxPreN_WIDTH                       6
#define D18F2x09C_x0D0F_810A_TxPreN_MASK                        0x3f
#define D18F2x09C_x0D0F_810A_TxPreP_OFFSET                      6
#define D18F2x09C_x0D0F_810A_TxPreP_WIDTH                       6
#define D18F2x09C_x0D0F_810A_TxPreP_MASK                        0xfc0
#define D18F2x09C_x0D0F_810A_Reserved_31_12_OFFSET              12
#define D18F2x09C_x0D0F_810A_Reserved_31_12_WIDTH               20
#define D18F2x09C_x0D0F_810A_Reserved_31_12_MASK                0xfffff000

/// D18F2x09C_x0D0F_810A
typedef union {
  struct {                                                              ///<
    UINT32                                                   TxPreN:6 ; ///<
    UINT32                                                   TxPreP:6 ; ///<
    UINT32                                           Reserved_31_12:20; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} D18F2x09C_x0D0F_810A_STRUCT;

// **** D18F2x09C_x0D0F_811F Register Definition ****
// Address
#define D18F2x09C_x0D0F_811F_ADDRESS                            0xd0f811f

// Type
#define D18F2x09C_x0D0F_811F_TYPE                               TYPE_D18F2x09C
// Field Data
#define D18F2x09C_x0D0F_811F_Reserved_2_0_OFFSET                0
#define D18F2x09C_x0D0F_811F_Reserved_2_0_WIDTH                 3
#define D18F2x09C_x0D0F_811F_Reserved_2_0_MASK                  0x7
#define D18F2x09C_x0D0F_811F_RxVioLvl_OFFSET                    3
#define D18F2x09C_x0D0F_811F_RxVioLvl_WIDTH                     2
#define D18F2x09C_x0D0F_811F_RxVioLvl_MASK                      0x18
#define D18F2x09C_x0D0F_811F_Reserved_31_5_OFFSET               5
#define D18F2x09C_x0D0F_811F_Reserved_31_5_WIDTH                27
#define D18F2x09C_x0D0F_811F_Reserved_31_5_MASK                 0xffffffe0

/// D18F2x09C_x0D0F_811F
typedef union {
  struct {                                                              ///<
    UINT32                                             Reserved_2_0:3 ; ///<
    UINT32                                                 RxVioLvl:2 ; ///<
    UINT32                                            Reserved_31_5:27; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} D18F2x09C_x0D0F_811F_STRUCT;

// **** D18F2x09C_x0D0F_812F Register Definition ****
// Address
#define D18F2x09C_x0D0F_812F_ADDRESS                            0xd0f812f

// Type
#define D18F2x09C_x0D0F_812F_TYPE                               TYPE_D18F2x09C
// Field Data
#define D18F2x09C_x0D0F_812F_PARTri_OFFSET                      0
#define D18F2x09C_x0D0F_812F_PARTri_WIDTH                       1
#define D18F2x09C_x0D0F_812F_PARTri_MASK                        0x1
#define D18F2x09C_x0D0F_812F_Reserved_4_1_OFFSET                1
#define D18F2x09C_x0D0F_812F_Reserved_4_1_WIDTH                 4
#define D18F2x09C_x0D0F_812F_Reserved_4_1_MASK                  0x1e
#define D18F2x09C_x0D0F_812F_Add17Tri_OFFSET                    5
#define D18F2x09C_x0D0F_812F_Add17Tri_WIDTH                     1
#define D18F2x09C_x0D0F_812F_Add17Tri_MASK                      0x20
#define D18F2x09C_x0D0F_812F_Reserved_6_6_OFFSET                6
#define D18F2x09C_x0D0F_812F_Reserved_6_6_WIDTH                 1
#define D18F2x09C_x0D0F_812F_Reserved_6_6_MASK                  0x40
#define D18F2x09C_x0D0F_812F_Add16Tri_OFFSET                    7
#define D18F2x09C_x0D0F_812F_Add16Tri_WIDTH                     1
#define D18F2x09C_x0D0F_812F_Add16Tri_MASK                      0x80
#define D18F2x09C_x0D0F_812F_Reserved_31_8_OFFSET               8
#define D18F2x09C_x0D0F_812F_Reserved_31_8_WIDTH                24
#define D18F2x09C_x0D0F_812F_Reserved_31_8_MASK                 0xffffff00

/// D18F2x09C_x0D0F_812F
typedef union {
  struct {                                                              ///<
    UINT32                                                   PARTri:1 ; ///<
    UINT32                                             Reserved_4_1:4 ; ///<
    UINT32                                                 Add17Tri:1 ; ///<
    UINT32                                             Reserved_6_6:1 ; ///<
    UINT32                                                 Add16Tri:1 ; ///<
    UINT32                                            Reserved_31_8:24; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} D18F2x09C_x0D0F_812F_STRUCT;

// **** D18F2x09C_x0D0F_8131 Register Definition ****
// Address
#define D18F2x09C_x0D0F_8131_ADDRESS                            0xd0f8131

// Type
#define D18F2x09C_x0D0F_8131_TYPE                               TYPE_D18F2x09C
// Field Data
#define D18F2x09C_x0D0F_8131_Fence2ThresholdTxPad_OFFSET        0
#define D18F2x09C_x0D0F_8131_Fence2ThresholdTxPad_WIDTH         4
#define D18F2x09C_x0D0F_8131_Fence2ThresholdTxPad_MASK          0xf
#define D18F2x09C_x0D0F_8131_Fence2EnableTxPad_OFFSET           4
#define D18F2x09C_x0D0F_8131_Fence2EnableTxPad_WIDTH            1
#define D18F2x09C_x0D0F_8131_Fence2EnableTxPad_MASK             0x10
#define D18F2x09C_x0D0F_8131_Reserved_31_5_OFFSET               5
#define D18F2x09C_x0D0F_8131_Reserved_31_5_WIDTH                27
#define D18F2x09C_x0D0F_8131_Reserved_31_5_MASK                 0xffffffe0

/// D18F2x09C_x0D0F_8131
typedef union {
  struct {                                                              ///<
    UINT32                                     Fence2ThresholdTxPad:4 ; ///<
    UINT32                                        Fence2EnableTxPad:1 ; ///<
    UINT32                                            Reserved_31_5:27; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} D18F2x09C_x0D0F_8131_STRUCT;

// **** D18F2x09C_x0D0F_C000 Register Definition ****
// Address
#define D18F2x09C_x0D0F_C000_ADDRESS                            0xd0fc000

// Type
#define D18F2x09C_x0D0F_C000_TYPE                               TYPE_D18F2x09C
// Field Data
#define D18F2x09C_x0D0F_C000_Reserved_7_0_OFFSET                0
#define D18F2x09C_x0D0F_C000_Reserved_7_0_WIDTH                 8
#define D18F2x09C_x0D0F_C000_Reserved_7_0_MASK                  0xff
#define D18F2x09C_x0D0F_C000_LowPowerDrvStrengthEn_OFFSET       8
#define D18F2x09C_x0D0F_C000_LowPowerDrvStrengthEn_WIDTH        1
#define D18F2x09C_x0D0F_C000_LowPowerDrvStrengthEn_MASK         0x100
#define D18F2x09C_x0D0F_C000_Reserved_31_9_OFFSET               9
#define D18F2x09C_x0D0F_C000_Reserved_31_9_WIDTH                23
#define D18F2x09C_x0D0F_C000_Reserved_31_9_MASK                 0xfffffe00

/// D18F2x09C_x0D0F_C000
typedef union {
  struct {                                                              ///<
    UINT32                                             Reserved_7_0:8 ; ///<
    UINT32                                    LowPowerDrvStrengthEn:1 ; ///<
    UINT32                                            Reserved_31_9:23; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} D18F2x09C_x0D0F_C000_STRUCT;

// **** D18F2x09C_x0D0F_C002 Register Definition ****
// Address
#define D18F2x09C_x0D0F_C002_ADDRESS                            0xd0fc002

// Type
#define D18F2x09C_x0D0F_C002_TYPE                               TYPE_D18F2x09C
// Field Data
#define D18F2x09C_x0D0F_C002_TxPreN_OFFSET                      0
#define D18F2x09C_x0D0F_C002_TxPreN_WIDTH                       6
#define D18F2x09C_x0D0F_C002_TxPreN_MASK                        0x3f
#define D18F2x09C_x0D0F_C002_TxPreP_OFFSET                      6
#define D18F2x09C_x0D0F_C002_TxPreP_WIDTH                       6
#define D18F2x09C_x0D0F_C002_TxPreP_MASK                        0xfc0
#define D18F2x09C_x0D0F_C002_Reserved_14_12_OFFSET              12
#define D18F2x09C_x0D0F_C002_Reserved_14_12_WIDTH               3
#define D18F2x09C_x0D0F_C002_Reserved_14_12_MASK                0x7000
#define D18F2x09C_x0D0F_C002_ValidTxAndPre_OFFSET               15
#define D18F2x09C_x0D0F_C002_ValidTxAndPre_WIDTH                1
#define D18F2x09C_x0D0F_C002_ValidTxAndPre_MASK                 0x8000
#define D18F2x09C_x0D0F_C002_Reserved_31_16_OFFSET              16
#define D18F2x09C_x0D0F_C002_Reserved_31_16_WIDTH               16
#define D18F2x09C_x0D0F_C002_Reserved_31_16_MASK                0xffff0000

/// D18F2x09C_x0D0F_C002
typedef union {
  struct {                                                              ///<
    UINT32                                                   TxPreN:6 ; ///<
    UINT32                                                   TxPreP:6 ; ///<
    UINT32                                           Reserved_14_12:3 ; ///<
    UINT32                                            ValidTxAndPre:1 ; ///<
    UINT32                                           Reserved_31_16:16; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} D18F2x09C_x0D0F_C002_STRUCT;

// **** D18F2x09C_x0D0F_C006 Register Definition ****
// Address
#define D18F2x09C_x0D0F_C006_ADDRESS                            0xd0fc006

// Type
#define D18F2x09C_x0D0F_C006_TYPE                               TYPE_D18F2x09C
// Field Data
#define D18F2x09C_x0D0F_C006_TxPreN_OFFSET                      0
#define D18F2x09C_x0D0F_C006_TxPreN_WIDTH                       6
#define D18F2x09C_x0D0F_C006_TxPreN_MASK                        0x3f
#define D18F2x09C_x0D0F_C006_TxPreP_OFFSET                      6
#define D18F2x09C_x0D0F_C006_TxPreP_WIDTH                       6
#define D18F2x09C_x0D0F_C006_TxPreP_MASK                        0xfc0
#define D18F2x09C_x0D0F_C006_Reserved_31_12_OFFSET              12
#define D18F2x09C_x0D0F_C006_Reserved_31_12_WIDTH               20
#define D18F2x09C_x0D0F_C006_Reserved_31_12_MASK                0xfffff000

/// D18F2x09C_x0D0F_C006
typedef union {
  struct {                                                              ///<
    UINT32                                                   TxPreN:6 ; ///<
    UINT32                                                   TxPreP:6 ; ///<
    UINT32                                           Reserved_31_12:20; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} D18F2x09C_x0D0F_C006_STRUCT;

// **** D18F2x09C_x0D0F_C00A Register Definition ****
// Address
#define D18F2x09C_x0D0F_C00A_ADDRESS                            0xd0fc00a

// Type
#define D18F2x09C_x0D0F_C00A_TYPE                               TYPE_D18F2x09C
// Field Data
#define D18F2x09C_x0D0F_C00A_TxPreN_OFFSET                      0
#define D18F2x09C_x0D0F_C00A_TxPreN_WIDTH                       6
#define D18F2x09C_x0D0F_C00A_TxPreN_MASK                        0x3f
#define D18F2x09C_x0D0F_C00A_TxPreP_OFFSET                      6
#define D18F2x09C_x0D0F_C00A_TxPreP_WIDTH                       6
#define D18F2x09C_x0D0F_C00A_TxPreP_MASK                        0xfc0
#define D18F2x09C_x0D0F_C00A_Reserved_31_12_OFFSET              12
#define D18F2x09C_x0D0F_C00A_Reserved_31_12_WIDTH               20
#define D18F2x09C_x0D0F_C00A_Reserved_31_12_MASK                0xfffff000

/// D18F2x09C_x0D0F_C00A
typedef union {
  struct {                                                              ///<
    UINT32                                                   TxPreN:6 ; ///<
    UINT32                                                   TxPreP:6 ; ///<
    UINT32                                           Reserved_31_12:20; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} D18F2x09C_x0D0F_C00A_STRUCT;

// **** D18F2x09C_x0D0F_C00E Register Definition ****
// Address
#define D18F2x09C_x0D0F_C00E_ADDRESS                            0xd0fc00e

// Type
#define D18F2x09C_x0D0F_C00E_TYPE                               TYPE_D18F2x09C
// Field Data
#define D18F2x09C_x0D0F_C00E_TxPreN_OFFSET                      0
#define D18F2x09C_x0D0F_C00E_TxPreN_WIDTH                       6
#define D18F2x09C_x0D0F_C00E_TxPreN_MASK                        0x3f
#define D18F2x09C_x0D0F_C00E_TxPreP_OFFSET                      6
#define D18F2x09C_x0D0F_C00E_TxPreP_WIDTH                       6
#define D18F2x09C_x0D0F_C00E_TxPreP_MASK                        0xfc0
#define D18F2x09C_x0D0F_C00E_Reserved_31_12_OFFSET              12
#define D18F2x09C_x0D0F_C00E_Reserved_31_12_WIDTH               20
#define D18F2x09C_x0D0F_C00E_Reserved_31_12_MASK                0xfffff000

/// D18F2x09C_x0D0F_C00E
typedef union {
  struct {                                                              ///<
    UINT32                                                   TxPreN:6 ; ///<
    UINT32                                                   TxPreP:6 ; ///<
    UINT32                                           Reserved_31_12:20; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} D18F2x09C_x0D0F_C00E_STRUCT;

// **** D18F2x09C_x0D0F_C012 Register Definition ****
// Address
#define D18F2x09C_x0D0F_C012_ADDRESS                            0xd0fc012

// Type
#define D18F2x09C_x0D0F_C012_TYPE                               TYPE_D18F2x09C
// Field Data
#define D18F2x09C_x0D0F_C012_TxPreN_OFFSET                      0
#define D18F2x09C_x0D0F_C012_TxPreN_WIDTH                       6
#define D18F2x09C_x0D0F_C012_TxPreN_MASK                        0x3f
#define D18F2x09C_x0D0F_C012_TxPreP_OFFSET                      6
#define D18F2x09C_x0D0F_C012_TxPreP_WIDTH                       6
#define D18F2x09C_x0D0F_C012_TxPreP_MASK                        0xfc0
#define D18F2x09C_x0D0F_C012_Reserved_31_12_OFFSET              12
#define D18F2x09C_x0D0F_C012_Reserved_31_12_WIDTH               20
#define D18F2x09C_x0D0F_C012_Reserved_31_12_MASK                0xfffff000

/// D18F2x09C_x0D0F_C012
typedef union {
  struct {                                                              ///<
    UINT32                                                   TxPreN:6 ; ///<
    UINT32                                                   TxPreP:6 ; ///<
    UINT32                                           Reserved_31_12:20; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} D18F2x09C_x0D0F_C012_STRUCT;

// **** D18F2x09C_x0D0F_C01F Register Definition ****
// Address
#define D18F2x09C_x0D0F_C01F_ADDRESS                            0xd0fc01f

// Type
#define D18F2x09C_x0D0F_C01F_TYPE                               TYPE_D18F2x09C
// Field Data
#define D18F2x09C_x0D0F_C01F_Reserved_2_0_OFFSET                0
#define D18F2x09C_x0D0F_C01F_Reserved_2_0_WIDTH                 3
#define D18F2x09C_x0D0F_C01F_Reserved_2_0_MASK                  0x7
#define D18F2x09C_x0D0F_C01F_RxVioLvl_OFFSET                    3
#define D18F2x09C_x0D0F_C01F_RxVioLvl_WIDTH                     2
#define D18F2x09C_x0D0F_C01F_RxVioLvl_MASK                      0x18
#define D18F2x09C_x0D0F_C01F_Reserved_31_5_OFFSET               5
#define D18F2x09C_x0D0F_C01F_Reserved_31_5_WIDTH                27
#define D18F2x09C_x0D0F_C01F_Reserved_31_5_MASK                 0xffffffe0

/// D18F2x09C_x0D0F_C01F
typedef union {
  struct {                                                              ///<
    UINT32                                             Reserved_2_0:3 ; ///<
    UINT32                                                 RxVioLvl:2 ; ///<
    UINT32                                            Reserved_31_5:27; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} D18F2x09C_x0D0F_C01F_STRUCT;

// **** D18F2x09C_x0D0F_C031 Register Definition ****
// Address
#define D18F2x09C_x0D0F_C031_ADDRESS                            0xd0fc031

// Type
#define D18F2x09C_x0D0F_C031_TYPE                               TYPE_D18F2x09C
// Field Data
#define D18F2x09C_x0D0F_C031_Fence2ThresholdTxPad_OFFSET        0
#define D18F2x09C_x0D0F_C031_Fence2ThresholdTxPad_WIDTH         4
#define D18F2x09C_x0D0F_C031_Fence2ThresholdTxPad_MASK          0xf
#define D18F2x09C_x0D0F_C031_Fence2EnableTxPad_OFFSET           4
#define D18F2x09C_x0D0F_C031_Fence2EnableTxPad_WIDTH            1
#define D18F2x09C_x0D0F_C031_Fence2EnableTxPad_MASK             0x10
#define D18F2x09C_x0D0F_C031_Reserved_31_5_OFFSET               5
#define D18F2x09C_x0D0F_C031_Reserved_31_5_WIDTH                27
#define D18F2x09C_x0D0F_C031_Reserved_31_5_MASK                 0xffffffe0

/// D18F2x09C_x0D0F_C031
typedef union {
  struct {                                                              ///<
    UINT32                                     Fence2ThresholdTxPad:4 ; ///<
    UINT32                                        Fence2EnableTxPad:1 ; ///<
    UINT32                                            Reserved_31_5:27; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} D18F2x09C_x0D0F_C031_STRUCT;

// **** D18F2x09C_x0D0F_E003 Register Definition ****
// Address
#define D18F2x09C_x0D0F_E003_ADDRESS                            0xd0fe003

// Type
#define D18F2x09C_x0D0F_E003_TYPE                               TYPE_D18F2x09C
// Field Data
#define D18F2x09C_x0D0F_E003_Reserved_12_0_OFFSET               0
#define D18F2x09C_x0D0F_E003_Reserved_12_0_WIDTH                13
#define D18F2x09C_x0D0F_E003_Reserved_12_0_MASK                 0x1fff
#define D18F2x09C_x0D0F_E003_DisablePredriverCal_OFFSET         13
#define D18F2x09C_x0D0F_E003_DisablePredriverCal_WIDTH          1
#define D18F2x09C_x0D0F_E003_DisablePredriverCal_MASK           0x2000
#define D18F2x09C_x0D0F_E003_DisAutoComp_OFFSET                 14
#define D18F2x09C_x0D0F_E003_DisAutoComp_WIDTH                  1
#define D18F2x09C_x0D0F_E003_DisAutoComp_MASK                   0x4000
#define D18F2x09C_x0D0F_E003_Reserved_31_15_OFFSET              15
#define D18F2x09C_x0D0F_E003_Reserved_31_15_WIDTH               17
#define D18F2x09C_x0D0F_E003_Reserved_31_15_MASK                0xffff8000

/// D18F2x09C_x0D0F_E003
typedef union {
  struct {                                                              ///<
    UINT32                                            Reserved_12_0:13; ///<
    UINT32                                      DisablePredriverCal:1 ; ///<
    UINT32                                              DisAutoComp:1 ; ///<
    UINT32                                           Reserved_31_15:17; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} D18F2x09C_x0D0F_E003_STRUCT;

// **** D18F2x09C_x0D0F_E006 Register Definition ****
// Address
#define D18F2x09C_x0D0F_E006_ADDRESS                            0xd0fe006

// Type
#define D18F2x09C_x0D0F_E006_TYPE                               TYPE_D18F2x09C
// Field Data
#define D18F2x09C_x0D0F_E006_PllLockTime_OFFSET                 0
#define D18F2x09C_x0D0F_E006_PllLockTime_WIDTH                  16
#define D18F2x09C_x0D0F_E006_PllLockTime_MASK                   0xffff
#define D18F2x09C_x0D0F_E006_Reserved_31_16_OFFSET              16
#define D18F2x09C_x0D0F_E006_Reserved_31_16_WIDTH               16
#define D18F2x09C_x0D0F_E006_Reserved_31_16_MASK                0xffff0000

/// D18F2x09C_x0D0F_E006
typedef union {
  struct {                                                              ///<
    UINT32                                              PllLockTime:16; ///<
    UINT32                                           Reserved_31_16:16; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} D18F2x09C_x0D0F_E006_STRUCT;

// **** D18F2x09C_x0D0F_E00A Register Definition ****
// Address
#define D18F2x09C_x0D0F_E00A_ADDRESS                            0xd0fe00a

// Type
#define D18F2x09C_x0D0F_E00A_TYPE                               TYPE_D18F2x09C
// Field Data
#define D18F2x09C_x0D0F_E00A_Reserved_3_0_OFFSET                0
#define D18F2x09C_x0D0F_E00A_Reserved_3_0_WIDTH                 4
#define D18F2x09C_x0D0F_E00A_Reserved_3_0_MASK                  0xf
#define D18F2x09C_x0D0F_E00A_SkewMemClk_OFFSET                  4
#define D18F2x09C_x0D0F_E00A_SkewMemClk_WIDTH                   1
#define D18F2x09C_x0D0F_E00A_SkewMemClk_MASK                    0x10
#define D18F2x09C_x0D0F_E00A_Reserved_11_5_OFFSET               5
#define D18F2x09C_x0D0F_E00A_Reserved_11_5_WIDTH                7
#define D18F2x09C_x0D0F_E00A_Reserved_11_5_MASK                 0xfe0
#define D18F2x09C_x0D0F_E00A_CsrPhySrPllPdMode_OFFSET           12
#define D18F2x09C_x0D0F_E00A_CsrPhySrPllPdMode_WIDTH            2
#define D18F2x09C_x0D0F_E00A_CsrPhySrPllPdMode_MASK             0x3000
#define D18F2x09C_x0D0F_E00A_SelCsrPllPdMode_OFFSET             14
#define D18F2x09C_x0D0F_E00A_SelCsrPllPdMode_WIDTH              1
#define D18F2x09C_x0D0F_E00A_SelCsrPllPdMode_MASK               0x4000
#define D18F2x09C_x0D0F_E00A_Reserved_31_15_OFFSET              15
#define D18F2x09C_x0D0F_E00A_Reserved_31_15_WIDTH               17
#define D18F2x09C_x0D0F_E00A_Reserved_31_15_MASK                0xffff8000

/// D18F2x09C_x0D0F_E00A
typedef union {
  struct {                                                              ///<
    UINT32                                             Reserved_3_0:4 ; ///<
    UINT32                                               SkewMemClk:1 ; ///<
    UINT32                                            Reserved_11_5:7 ; ///<
    UINT32                                        CsrPhySrPllPdMode:2 ; ///<
    UINT32                                          SelCsrPllPdMode:1 ; ///<
    UINT32                                           Reserved_31_15:17; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} D18F2x09C_x0D0F_E00A_STRUCT;

// **** D18F2x09C_x0D0F_E013 Register Definition ****
// Address
#define D18F2x09C_x0D0F_E013_ADDRESS                            0xd0fe013

// Type
#define D18F2x09C_x0D0F_E013_TYPE                               TYPE_D18F2x09C
// Field Data
#define D18F2x09C_x0D0F_E013_PllRegWaitTime_OFFSET              0
#define D18F2x09C_x0D0F_E013_PllRegWaitTime_WIDTH               16
#define D18F2x09C_x0D0F_E013_PllRegWaitTime_MASK                0xffff
#define D18F2x09C_x0D0F_E013_Reserved_31_16_OFFSET              16
#define D18F2x09C_x0D0F_E013_Reserved_31_16_WIDTH               16
#define D18F2x09C_x0D0F_E013_Reserved_31_16_MASK                0xffff0000

/// D18F2x09C_x0D0F_E013
typedef union {
  struct {                                                              ///<
    UINT32                                           PllRegWaitTime:16; ///<
    UINT32                                           Reserved_31_16:16; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} D18F2x09C_x0D0F_E013_STRUCT;

// **** D18F2x0F4_x06 Register Definition ****
// Address
#define D18F2x0F4_x06_ADDRESS                                   0x6

// Type
#define D18F2x0F4_x06_TYPE                                      TYPE_D18F2x0F4
// Field Data
#define D18F2x0F4_x06_TrdrdSD_OFFSET                            0
#define D18F2x0F4_x06_TrdrdSD_WIDTH                             4
#define D18F2x0F4_x06_TrdrdSD_MASK                              0xf
#define D18F2x0F4_x06_Reserved_6_4_OFFSET                       4
#define D18F2x0F4_x06_Reserved_6_4_WIDTH                        3
#define D18F2x0F4_x06_Reserved_6_4_MASK                         0x70
#define D18F2x0F4_x06_TrdrdScEn_OFFSET                          7
#define D18F2x0F4_x06_TrdrdScEn_WIDTH                           1
#define D18F2x0F4_x06_TrdrdScEn_MASK                            0x80
#define D18F2x0F4_x06_TwrrdSD_OFFSET                            8
#define D18F2x0F4_x06_TwrrdSD_WIDTH                             4
#define D18F2x0F4_x06_TwrrdSD_MASK                              0xf00
#define D18F2x0F4_x06_Reserved_31_12_OFFSET                     12
#define D18F2x0F4_x06_Reserved_31_12_WIDTH                      20
#define D18F2x0F4_x06_Reserved_31_12_MASK                       0xfffff000

/// D18F2x0F4_x06
typedef union {
  struct {                                                              ///<
    UINT32                                                  TrdrdSD:4 ; ///<
    UINT32                                             Reserved_6_4:3 ; ///<
    UINT32                                                TrdrdScEn:1 ; ///<
    UINT32                                                  TwrrdSD:4 ; ///<
    UINT32                                           Reserved_31_12:20; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} D18F2x0F4_x06_STRUCT;

// **** D18F2x0F4_x16 Register Definition ****
// Address
#define D18F2x0F4_x16_ADDRESS                                   0x16

// Type
#define D18F2x0F4_x16_TYPE                                      TYPE_D18F2x0F4
// Field Data
#define D18F2x0F4_x16_TwrwrSD_OFFSET                            0
#define D18F2x0F4_x16_TwrwrSD_WIDTH                             4
#define D18F2x0F4_x16_TwrwrSD_MASK                              0xf
#define D18F2x0F4_x16_Reserved_31_4_OFFSET                      4
#define D18F2x0F4_x16_Reserved_31_4_WIDTH                       28
#define D18F2x0F4_x16_Reserved_31_4_MASK                        0xfffffff0

/// D18F2x0F4_x16
typedef union {
  struct {                                                              ///<
    UINT32                                                  TwrwrSD:4 ; ///<
    UINT32                                            Reserved_31_4:28; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} D18F2x0F4_x16_STRUCT;

// **** D18F2x0F4_x30 Register Definition ****
// Address
#define D18F2x0F4_x30_ADDRESS                                   0x30

// Type
#define D18F2x0F4_x30_TYPE                                      TYPE_D18F2x0F4
// Field Data
#define D18F2x0F4_x30_DbeGskFifoNumerator_OFFSET                0
#define D18F2x0F4_x30_DbeGskFifoNumerator_WIDTH                 13
#define D18F2x0F4_x30_DbeGskFifoNumerator_MASK                  0x1fff
#define D18F2x0F4_x30_Reserved_31_13_OFFSET                     13
#define D18F2x0F4_x30_Reserved_31_13_WIDTH                      19
#define D18F2x0F4_x30_Reserved_31_13_MASK                       0xffffe000

/// D18F2x0F4_x30
typedef union {
  struct {                                                              ///<
    UINT32                                      DbeGskFifoNumerator:13; ///<
    UINT32                                           Reserved_31_13:19; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} D18F2x0F4_x30_STRUCT;

// **** D18F2x0F4_x31 Register Definition ****
// Address
#define D18F2x0F4_x31_ADDRESS                                   0x31

// Type
#define D18F2x0F4_x31_TYPE                                      TYPE_D18F2x0F4
// Field Data
#define D18F2x0F4_x31_DbeGskFifoDenominator_OFFSET              0
#define D18F2x0F4_x31_DbeGskFifoDenominator_WIDTH               13
#define D18F2x0F4_x31_DbeGskFifoDenominator_MASK                0x1fff
#define D18F2x0F4_x31_Reserved_31_13_OFFSET                     13
#define D18F2x0F4_x31_Reserved_31_13_WIDTH                      19
#define D18F2x0F4_x31_Reserved_31_13_MASK                       0xffffe000

/// D18F2x0F4_x31
typedef union {
  struct {                                                              ///<
    UINT32                                    DbeGskFifoDenominator:13; ///<
    UINT32                                           Reserved_31_13:19; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} D18F2x0F4_x31_STRUCT;

// **** D18F2x0F4_x32 Register Definition ****
// Address
#define D18F2x0F4_x32_ADDRESS                                   0x32

// Type
#define D18F2x0F4_x32_TYPE                                      TYPE_D18F2x0F4
// Field Data
#define D18F2x0F4_x32_DataTxFifoSchedDlySlot0_OFFSET            0
#define D18F2x0F4_x32_DataTxFifoSchedDlySlot0_WIDTH             5
#define D18F2x0F4_x32_DataTxFifoSchedDlySlot0_MASK              0x1f
#define D18F2x0F4_x32_Reserved_6_5_OFFSET                       5
#define D18F2x0F4_x32_Reserved_6_5_WIDTH                        2
#define D18F2x0F4_x32_Reserved_6_5_MASK                         0x60
#define D18F2x0F4_x32_DataTxFifoSchedDlyNegSlot0_OFFSET         7
#define D18F2x0F4_x32_DataTxFifoSchedDlyNegSlot0_WIDTH          1
#define D18F2x0F4_x32_DataTxFifoSchedDlyNegSlot0_MASK           0x80
#define D18F2x0F4_x32_DataTxFifoSchedDlySlot1_OFFSET            8
#define D18F2x0F4_x32_DataTxFifoSchedDlySlot1_WIDTH             5
#define D18F2x0F4_x32_DataTxFifoSchedDlySlot1_MASK              0x1f00
#define D18F2x0F4_x32_Reserved_14_13_OFFSET                     13
#define D18F2x0F4_x32_Reserved_14_13_WIDTH                      2
#define D18F2x0F4_x32_Reserved_14_13_MASK                       0x6000
#define D18F2x0F4_x32_DataTxFifoSchedDlyNegSlot1_OFFSET         15
#define D18F2x0F4_x32_DataTxFifoSchedDlyNegSlot1_WIDTH          1
#define D18F2x0F4_x32_DataTxFifoSchedDlyNegSlot1_MASK           0x8000
#define D18F2x0F4_x32_Reserved_31_16_OFFSET                     16
#define D18F2x0F4_x32_Reserved_31_16_WIDTH                      16
#define D18F2x0F4_x32_Reserved_31_16_MASK                       0xffff0000

/// D18F2x0F4_x32
typedef union {
  struct {                                                              ///<
    UINT32                                  DataTxFifoSchedDlySlot0:5 ; ///<
    UINT32                                             Reserved_6_5:2 ; ///<
    UINT32                               DataTxFifoSchedDlyNegSlot0:1 ; ///<
    UINT32                                  DataTxFifoSchedDlySlot1:5 ; ///<
    UINT32                                           Reserved_14_13:2 ; ///<
    UINT32                               DataTxFifoSchedDlyNegSlot1:1 ; ///<
    UINT32                                           Reserved_31_16:16; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} D18F2x0F4_x32_STRUCT;

// **** D18F2x0F4_x40 Register Definition ****
// Address
#define D18F2x0F4_x40_ADDRESS                                   0x40

// Type
#define D18F2x0F4_x40_TYPE                                      TYPE_D18F2x0F4
// Field Data
#define D18F2x0F4_x40_Trcd_OFFSET                               0
#define D18F2x0F4_x40_Trcd_WIDTH                                4
#define D18F2x0F4_x40_Trcd_MASK                                 0xf
#define D18F2x0F4_x40_Reserved_7_4_OFFSET                       4
#define D18F2x0F4_x40_Reserved_7_4_WIDTH                        4
#define D18F2x0F4_x40_Reserved_7_4_MASK                         0xf0
#define D18F2x0F4_x40_Trp_OFFSET                                8
#define D18F2x0F4_x40_Trp_WIDTH                                 4
#define D18F2x0F4_x40_Trp_MASK                                  0xf00
#define D18F2x0F4_x40_Reserved_15_12_OFFSET                     12
#define D18F2x0F4_x40_Reserved_15_12_WIDTH                      4
#define D18F2x0F4_x40_Reserved_15_12_MASK                       0xf000
#define D18F2x0F4_x40_Tras_OFFSET                               16
#define D18F2x0F4_x40_Tras_WIDTH                                5
#define D18F2x0F4_x40_Tras_MASK                                 0x1f0000
#define D18F2x0F4_x40_Reserved_23_21_OFFSET                     21
#define D18F2x0F4_x40_Reserved_23_21_WIDTH                      3
#define D18F2x0F4_x40_Reserved_23_21_MASK                       0xe00000
#define D18F2x0F4_x40_Trc_OFFSET                                24
#define D18F2x0F4_x40_Trc_WIDTH                                 6
#define D18F2x0F4_x40_Trc_MASK                                  0x3f000000
#define D18F2x0F4_x40_Reserved_31_30_OFFSET                     30
#define D18F2x0F4_x40_Reserved_31_30_WIDTH                      2
#define D18F2x0F4_x40_Reserved_31_30_MASK                       0xc0000000

/// D18F2x0F4_x40
typedef union {
  struct {                                                              ///<
    UINT32                                                     Trcd:4 ; ///<
    UINT32                                             Reserved_7_4:4 ; ///<
    UINT32                                                      Trp:4 ; ///<
    UINT32                                           Reserved_15_12:4 ; ///<
    UINT32                                                     Tras:5 ; ///<
    UINT32                                           Reserved_23_21:3 ; ///<
    UINT32                                                      Trc:6 ; ///<
    UINT32                                           Reserved_31_30:2 ; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} D18F2x0F4_x40_STRUCT;

// **** D18F2x0F4_x41 Register Definition ****
// Address
#define D18F2x0F4_x41_ADDRESS                                   0x41

// Type
#define D18F2x0F4_x41_TYPE                                      TYPE_D18F2x0F4
// Field Data
#define D18F2x0F4_x41_Trtp_OFFSET                               0
#define D18F2x0F4_x41_Trtp_WIDTH                                3
#define D18F2x0F4_x41_Trtp_MASK                                 0x7
#define D18F2x0F4_x41_Reserved_7_3_OFFSET                       3
#define D18F2x0F4_x41_Reserved_7_3_WIDTH                        5
#define D18F2x0F4_x41_Reserved_7_3_MASK                         0xf8
#define D18F2x0F4_x41_Trrd_OFFSET                               8
#define D18F2x0F4_x41_Trrd_WIDTH                                3
#define D18F2x0F4_x41_Trrd_MASK                                 0x700
#define D18F2x0F4_x41_Reserved_15_11_OFFSET                     11
#define D18F2x0F4_x41_Reserved_15_11_WIDTH                      5
#define D18F2x0F4_x41_Reserved_15_11_MASK                       0xf800
#define D18F2x0F4_x41_Twtr_OFFSET                               16
#define D18F2x0F4_x41_Twtr_WIDTH                                3
#define D18F2x0F4_x41_Twtr_MASK                                 0x70000
#define D18F2x0F4_x41_Reserved_31_19_OFFSET                     19
#define D18F2x0F4_x41_Reserved_31_19_WIDTH                      13
#define D18F2x0F4_x41_Reserved_31_19_MASK                       0xfff80000

/// D18F2x0F4_x41
typedef union {
  struct {                                                              ///<
    UINT32                                                     Trtp:3 ; ///<
    UINT32                                             Reserved_7_3:5 ; ///<
    UINT32                                                     Trrd:3 ; ///<
    UINT32                                           Reserved_15_11:5 ; ///<
    UINT32                                                     Twtr:3 ; ///<
    UINT32                                           Reserved_31_19:13; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} D18F2x0F4_x41_STRUCT;

// **** D18F2x0F4_x83 Register Definition ****
// Address
#define D18F2x0F4_x83_ADDRESS                                   0x83

// Type
#define D18F2x0F4_x83_TYPE                                      TYPE_D18F2x0F4
// Field Data
#define D18F2x0F4_x83_RdOdtTrnOnDly_OFFSET                      0
#define D18F2x0F4_x83_RdOdtTrnOnDly_WIDTH                       3
#define D18F2x0F4_x83_RdOdtTrnOnDly_MASK                        0x7
#define D18F2x0F4_x83_Reserved_3_3_OFFSET                       3
#define D18F2x0F4_x83_Reserved_3_3_WIDTH                        1
#define D18F2x0F4_x83_Reserved_3_3_MASK                         0x8
#define D18F2x0F4_x83_RdOdtOnDuration_OFFSET                    4
#define D18F2x0F4_x83_RdOdtOnDuration_WIDTH                     3
#define D18F2x0F4_x83_RdOdtOnDuration_MASK                      0x70
#define D18F2x0F4_x83_Reserved_7_7_OFFSET                       7
#define D18F2x0F4_x83_Reserved_7_7_WIDTH                        1
#define D18F2x0F4_x83_Reserved_7_7_MASK                         0x80
#define D18F2x0F4_x83_WrOdtTrnOnDly_OFFSET                      8
#define D18F2x0F4_x83_WrOdtTrnOnDly_WIDTH                       1
#define D18F2x0F4_x83_WrOdtTrnOnDly_MASK                        0x100
#define D18F2x0F4_x83_Reserved_11_9_OFFSET                      9
#define D18F2x0F4_x83_Reserved_11_9_WIDTH                       3
#define D18F2x0F4_x83_Reserved_11_9_MASK                        0xe00
#define D18F2x0F4_x83_WrOdtOnDuration_OFFSET                    12
#define D18F2x0F4_x83_WrOdtOnDuration_WIDTH                     3
#define D18F2x0F4_x83_WrOdtOnDuration_MASK                      0x7000
#define D18F2x0F4_x83_Reserved_31_15_OFFSET                     15
#define D18F2x0F4_x83_Reserved_31_15_WIDTH                      17
#define D18F2x0F4_x83_Reserved_31_15_MASK                       0xffff8000

/// D18F2x0F4_x83
typedef union {
  struct {                                                              ///<
    UINT32                                            RdOdtTrnOnDly:3 ; ///<
    UINT32                                             Reserved_3_3:1 ; ///<
    UINT32                                          RdOdtOnDuration:3 ; ///<
    UINT32                                             Reserved_7_7:1 ; ///<
    UINT32                                            WrOdtTrnOnDly:1 ; ///<
    UINT32                                            Reserved_11_9:3 ; ///<
    UINT32                                          WrOdtOnDuration:3 ; ///<
    UINT32                                           Reserved_31_15:17; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} D18F2x0F4_x83_STRUCT;

// **** D18F2x0F4_x180 Register Definition ****
// Address
#define D18F2x0F4_x180_ADDRESS                                  0x180

// Type
#define D18F2x0F4_x180_TYPE                                     TYPE_D18F2x0F4
// Field Data
#define D18F2x0F4_x180_RdOdtPatCs0_OFFSET                       0
#define D18F2x0F4_x180_RdOdtPatCs0_WIDTH                        4
#define D18F2x0F4_x180_RdOdtPatCs0_MASK                         0xf
#define D18F2x0F4_x180_Reserved_7_4_OFFSET                      4
#define D18F2x0F4_x180_Reserved_7_4_WIDTH                       4
#define D18F2x0F4_x180_Reserved_7_4_MASK                        0xf0
#define D18F2x0F4_x180_RdOdtPatCs1_OFFSET                       8
#define D18F2x0F4_x180_RdOdtPatCs1_WIDTH                        4
#define D18F2x0F4_x180_RdOdtPatCs1_MASK                         0xf00
#define D18F2x0F4_x180_Reserved_15_12_OFFSET                    12
#define D18F2x0F4_x180_Reserved_15_12_WIDTH                     4
#define D18F2x0F4_x180_Reserved_15_12_MASK                      0xf000
#define D18F2x0F4_x180_RdOdtPatCs2_OFFSET                       16
#define D18F2x0F4_x180_RdOdtPatCs2_WIDTH                        4
#define D18F2x0F4_x180_RdOdtPatCs2_MASK                         0xf0000
#define D18F2x0F4_x180_Reserved_23_20_OFFSET                    20
#define D18F2x0F4_x180_Reserved_23_20_WIDTH                     4
#define D18F2x0F4_x180_Reserved_23_20_MASK                      0xf00000
#define D18F2x0F4_x180_RdOdtPatCs3_OFFSET                       24
#define D18F2x0F4_x180_RdOdtPatCs3_WIDTH                        4
#define D18F2x0F4_x180_RdOdtPatCs3_MASK                         0xf000000
#define D18F2x0F4_x180_Reserved_31_28_OFFSET                    28
#define D18F2x0F4_x180_Reserved_31_28_WIDTH                     4
#define D18F2x0F4_x180_Reserved_31_28_MASK                      0xf0000000

/// D18F2x0F4_x180
typedef union {
  struct {                                                              ///<
    UINT32                                              RdOdtPatCs0:4 ; ///<
    UINT32                                             Reserved_7_4:4 ; ///<
    UINT32                                              RdOdtPatCs1:4 ; ///<
    UINT32                                           Reserved_15_12:4 ; ///<
    UINT32                                              RdOdtPatCs2:4 ; ///<
    UINT32                                           Reserved_23_20:4 ; ///<
    UINT32                                              RdOdtPatCs3:4 ; ///<
    UINT32                                           Reserved_31_28:4 ; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} D18F2x0F4_x180_STRUCT;

// **** D18F2x0F4_x182 Register Definition ****
// Address
#define D18F2x0F4_x182_ADDRESS                                  0x182

// Type
#define D18F2x0F4_x182_TYPE                                     TYPE_D18F2x0F4
// Field Data
#define D18F2x0F4_x182_WrOdtPatCs0_OFFSET                       0
#define D18F2x0F4_x182_WrOdtPatCs0_WIDTH                        4
#define D18F2x0F4_x182_WrOdtPatCs0_MASK                         0xf
#define D18F2x0F4_x182_Reserved_7_4_OFFSET                      4
#define D18F2x0F4_x182_Reserved_7_4_WIDTH                       4
#define D18F2x0F4_x182_Reserved_7_4_MASK                        0xf0
#define D18F2x0F4_x182_WrOdtPatCs1_OFFSET                       8
#define D18F2x0F4_x182_WrOdtPatCs1_WIDTH                        4
#define D18F2x0F4_x182_WrOdtPatCs1_MASK                         0xf00
#define D18F2x0F4_x182_Reserved_15_12_OFFSET                    12
#define D18F2x0F4_x182_Reserved_15_12_WIDTH                     4
#define D18F2x0F4_x182_Reserved_15_12_MASK                      0xf000
#define D18F2x0F4_x182_WrOdtPatCs2_OFFSET                       16
#define D18F2x0F4_x182_WrOdtPatCs2_WIDTH                        4
#define D18F2x0F4_x182_WrOdtPatCs2_MASK                         0xf0000
#define D18F2x0F4_x182_Reserved_23_20_OFFSET                    20
#define D18F2x0F4_x182_Reserved_23_20_WIDTH                     4
#define D18F2x0F4_x182_Reserved_23_20_MASK                      0xf00000
#define D18F2x0F4_x182_WrOdtPatCs3_OFFSET                       24
#define D18F2x0F4_x182_WrOdtPatCs3_WIDTH                        4
#define D18F2x0F4_x182_WrOdtPatCs3_MASK                         0xf000000
#define D18F2x0F4_x182_Reserved_31_28_OFFSET                    28
#define D18F2x0F4_x182_Reserved_31_28_WIDTH                     4
#define D18F2x0F4_x182_Reserved_31_28_MASK                      0xf0000000

/// D18F2x0F4_x182
typedef union {
  struct {                                                              ///<
    UINT32                                              WrOdtPatCs0:4 ; ///<
    UINT32                                             Reserved_7_4:4 ; ///<
    UINT32                                              WrOdtPatCs1:4 ; ///<
    UINT32                                           Reserved_15_12:4 ; ///<
    UINT32                                              WrOdtPatCs2:4 ; ///<
    UINT32                                           Reserved_23_20:4 ; ///<
    UINT32                                              WrOdtPatCs3:4 ; ///<
    UINT32                                           Reserved_31_28:4 ; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} D18F2x0F4_x182_STRUCT;

// **** D18F2x0F4_x200 Register Definition ****
// Address
#define D18F2x0F4_x200_ADDRESS                                  0x200

// Type
#define D18F2x0F4_x200_TYPE                                     TYPE_D18F2x0F4
// Field Data
#define D18F2x0F4_x200_Txp_OFFSET                               0
#define D18F2x0F4_x200_Txp_WIDTH                                4
#define D18F2x0F4_x200_Txp_MASK                                 0xf
#define D18F2x0F4_x200_Reserved_7_4_OFFSET                      4
#define D18F2x0F4_x200_Reserved_7_4_WIDTH                       4
#define D18F2x0F4_x200_Reserved_7_4_MASK                        0xf0
#define D18F2x0F4_x200_Txpdll_OFFSET                            8
#define D18F2x0F4_x200_Txpdll_WIDTH                             5
#define D18F2x0F4_x200_Txpdll_MASK                              0x1f00
#define D18F2x0F4_x200_Reserved_31_13_OFFSET                    13
#define D18F2x0F4_x200_Reserved_31_13_WIDTH                     19
#define D18F2x0F4_x200_Reserved_31_13_MASK                      0xffffe000

/// D18F2x0F4_x200
typedef union {
  struct {                                                              ///<
    UINT32                                                      Txp:4 ; ///<
    UINT32                                             Reserved_7_4:4 ; ///<
    UINT32                                                   Txpdll:5 ; ///<
    UINT32                                           Reserved_31_13:19; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} D18F2x0F4_x200_STRUCT;

// **** DxF0xE4_x02 Register Definition ****
// Address
#define DxF0xE4_x02_ADDRESS                                     0x2

// Type
#define DxF0xE4_x02_TYPE                                        TYPE_D4F0xE4
// Field Data
#define DxF0xE4_x02_Reserved_14_0_OFFSET                        0
#define DxF0xE4_x02_Reserved_14_0_WIDTH                         15
#define DxF0xE4_x02_Reserved_14_0_MASK                          0x7fff
#define DxF0xE4_x02_RegsLcAllowTxL1Control_OFFSET               15
#define DxF0xE4_x02_RegsLcAllowTxL1Control_WIDTH                1
#define DxF0xE4_x02_RegsLcAllowTxL1Control_MASK                 0x8000
#define DxF0xE4_x02_Reserved_31_16_OFFSET                       16
#define DxF0xE4_x02_Reserved_31_16_WIDTH                        16
#define DxF0xE4_x02_Reserved_31_16_MASK                         0xffff0000

/// DxF0xE4_x02
typedef union {
  struct {                                                              ///<
    UINT32                                            Reserved_14_0:15; ///<
    UINT32                                   RegsLcAllowTxL1Control:1 ; ///<
    UINT32                                           Reserved_31_16:16; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} DxF0xE4_x02_STRUCT;

// **** DxF0xE4_x20 Register Definition ****
// Address
#define DxF0xE4_x20_ADDRESS                                     0x20

// Type
#define DxF0xE4_x20_TYPE                                        TYPE_D4F0xE4
// Field Data
#define DxF0xE4_x20_Reserved_14_0_OFFSET                        0
#define DxF0xE4_x20_Reserved_14_0_WIDTH                         15
#define DxF0xE4_x20_Reserved_14_0_MASK                          0x7fff
#define DxF0xE4_x20_TxFlushTlpDis_OFFSET                        15
#define DxF0xE4_x20_TxFlushTlpDis_WIDTH                         1
#define DxF0xE4_x20_TxFlushTlpDis_MASK                          0x8000
#define DxF0xE4_x20_Reserved_31_16_OFFSET                       16
#define DxF0xE4_x20_Reserved_31_16_WIDTH                        16
#define DxF0xE4_x20_Reserved_31_16_MASK                         0xffff0000

/// DxF0xE4_x20
typedef union {
  struct {                                                              ///<
    UINT32                                            Reserved_14_0:15; ///<
    UINT32                                            TxFlushTlpDis:1 ; ///<
    UINT32                                           Reserved_31_16:16; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} DxF0xE4_x20_STRUCT;

// **** DxF0xE4_x50 Register Definition ****
// Address
#define DxF0xE4_x50_ADDRESS                                     0x50

// Type
#define DxF0xE4_x50_TYPE                                        TYPE_D4F0xE4
// Field Data
#define DxF0xE4_x50_PortLaneReversal_OFFSET                     0
#define DxF0xE4_x50_PortLaneReversal_WIDTH                      1
#define DxF0xE4_x50_PortLaneReversal_MASK                       0x1
#define DxF0xE4_x50_PhyLinkWidth_OFFSET                         1
#define DxF0xE4_x50_PhyLinkWidth_WIDTH                          6
#define DxF0xE4_x50_PhyLinkWidth_MASK                           0x7e
#define DxF0xE4_x50_Reserved_31_7_OFFSET                        7
#define DxF0xE4_x50_Reserved_31_7_WIDTH                         25
#define DxF0xE4_x50_Reserved_31_7_MASK                          0xffffff80

/// DxF0xE4_x50
typedef union {
  struct {                                                              ///<
    UINT32                                         PortLaneReversal:1 ; ///<
    UINT32                                             PhyLinkWidth:6 ; ///<
    UINT32                                            Reserved_31_7:25; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} DxF0xE4_x50_STRUCT;

// **** DxF0xE4_x70 Register Definition ****
// Address
#define DxF0xE4_x70_ADDRESS                                     0x70

// Type
#define DxF0xE4_x70_TYPE                                        TYPE_D4F0xE4
// Field Data
#define DxF0xE4_x70_Reserved_15_0_OFFSET                        0
#define DxF0xE4_x70_Reserved_15_0_WIDTH                         16
#define DxF0xE4_x70_Reserved_15_0_MASK                          0xffff
#define DxF0xE4_x70_RxRcbCplTimeout_OFFSET                      16
#define DxF0xE4_x70_RxRcbCplTimeout_WIDTH                       3
#define DxF0xE4_x70_RxRcbCplTimeout_MASK                        0x70000
#define DxF0xE4_x70_RxRcbCplTimeoutMode_OFFSET                  19
#define DxF0xE4_x70_RxRcbCplTimeoutMode_WIDTH                   1
#define DxF0xE4_x70_RxRcbCplTimeoutMode_MASK                    0x80000
#define DxF0xE4_x70_Reserved_31_20_OFFSET                       20
#define DxF0xE4_x70_Reserved_31_20_WIDTH                        12
#define DxF0xE4_x70_Reserved_31_20_MASK                         0xfff00000

/// DxF0xE4_x70
typedef union {
  struct {                                                              ///<
    UINT32                                            Reserved_15_0:16; ///<
    UINT32                                          RxRcbCplTimeout:3 ; ///<
    UINT32                                      RxRcbCplTimeoutMode:1 ; ///<
    UINT32                                           Reserved_31_20:12; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} DxF0xE4_x70_STRUCT;

// **** DxF0xE4_xA0 Register Definition ****
// Address
#define DxF0xE4_xA0_ADDRESS                                     0xa0

// Type
#define DxF0xE4_xA0_TYPE                                        TYPE_D4F0xE4
// Field Data
#define DxF0xE4_xA0_Reserved_3_0_OFFSET                         0
#define DxF0xE4_xA0_Reserved_3_0_WIDTH                          4
#define DxF0xE4_xA0_Reserved_3_0_MASK                           0xf
#define DxF0xE4_xA0_Lc16xClearTxPipe_OFFSET                     4
#define DxF0xE4_xA0_Lc16xClearTxPipe_WIDTH                      4
#define DxF0xE4_xA0_Lc16xClearTxPipe_MASK                       0xf0
#define DxF0xE4_xA0_LcL0sInactivity_OFFSET                      8
#define DxF0xE4_xA0_LcL0sInactivity_WIDTH                       4
#define DxF0xE4_xA0_LcL0sInactivity_MASK                        0xf00
#define DxF0xE4_xA0_LcL1Inactivity_OFFSET                       12
#define DxF0xE4_xA0_LcL1Inactivity_WIDTH                        4
#define DxF0xE4_xA0_LcL1Inactivity_MASK                         0xf000
#define DxF0xE4_xA0_Reserved_22_16_OFFSET                       16
#define DxF0xE4_xA0_Reserved_22_16_WIDTH                        7
#define DxF0xE4_xA0_Reserved_22_16_MASK                         0x7f0000
#define DxF0xE4_xA0_LcL1ImmediateAck_OFFSET                     23
#define DxF0xE4_xA0_LcL1ImmediateAck_WIDTH                      1
#define DxF0xE4_xA0_LcL1ImmediateAck_MASK                       0x800000
#define DxF0xE4_xA0_Reserved_31_24_OFFSET                       24
#define DxF0xE4_xA0_Reserved_31_24_WIDTH                        8
#define DxF0xE4_xA0_Reserved_31_24_MASK                         0xff000000

/// DxF0xE4_xA0
typedef union {
  struct {                                                              ///<
    UINT32                                             Reserved_3_0:4 ; ///<
    UINT32                                         Lc16xClearTxPipe:4 ; ///<
    UINT32                                          LcL0sInactivity:4 ; ///<
    UINT32                                           LcL1Inactivity:4 ; ///<
    UINT32                                           Reserved_22_16:7 ; ///<
    UINT32                                         LcL1ImmediateAck:1 ; ///<
    UINT32                                           Reserved_31_24:8 ; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} DxF0xE4_xA0_STRUCT;

// **** DxF0xE4_xA1 Register Definition ****
// Address
#define DxF0xE4_xA1_ADDRESS                                     0xa1

// Type
#define DxF0xE4_xA1_TYPE                                        TYPE_D4F0xE4
// Field Data
#define DxF0xE4_xA1_Reserved_10_0_OFFSET                        0
#define DxF0xE4_xA1_Reserved_10_0_WIDTH                         11
#define DxF0xE4_xA1_Reserved_10_0_MASK                          0x7ff
#define DxF0xE4_xA1_LcDontGotoL0sifL1Armed_OFFSET               11
#define DxF0xE4_xA1_LcDontGotoL0sifL1Armed_WIDTH                1
#define DxF0xE4_xA1_LcDontGotoL0sifL1Armed_MASK                 0x800
#define DxF0xE4_xA1_LcInitSpdChgWithCsrEn_OFFSET                12
#define DxF0xE4_xA1_LcInitSpdChgWithCsrEn_WIDTH                 1
#define DxF0xE4_xA1_LcInitSpdChgWithCsrEn_MASK                  0x1000
#define DxF0xE4_xA1_Reserved_31_13_OFFSET                       13
#define DxF0xE4_xA1_Reserved_31_13_WIDTH                        19
#define DxF0xE4_xA1_Reserved_31_13_MASK                         0xffffe000

/// DxF0xE4_xA1
typedef union {
  struct {                                                              ///<
    UINT32                                            Reserved_10_0:11; ///<
    UINT32                                   LcDontGotoL0sifL1Armed:1 ; ///<
    UINT32                                    LcInitSpdChgWithCsrEn:1 ; ///<
    UINT32                                           Reserved_31_13:19; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} DxF0xE4_xA1_STRUCT;

// **** DxF0xE4_xA2 Register Definition ****
// Address
#define DxF0xE4_xA2_ADDRESS                                     0xa2

// Type
#define DxF0xE4_xA2_TYPE                                        TYPE_D4F0xE4
// Field Data
#define DxF0xE4_xA2_LcLinkWidth_OFFSET                          0
#define DxF0xE4_xA2_LcLinkWidth_WIDTH                           3
#define DxF0xE4_xA2_LcLinkWidth_MASK                            0x7
#define DxF0xE4_xA2_Reserved_3_3_OFFSET                         3
#define DxF0xE4_xA2_Reserved_3_3_WIDTH                          1
#define DxF0xE4_xA2_Reserved_3_3_MASK                           0x8
#define DxF0xE4_xA2_LcLinkWidthRd_OFFSET                        4
#define DxF0xE4_xA2_LcLinkWidthRd_WIDTH                         3
#define DxF0xE4_xA2_LcLinkWidthRd_MASK                          0x70
#define DxF0xE4_xA2_LcReconfigArcMissingEscape_OFFSET           7
#define DxF0xE4_xA2_LcReconfigArcMissingEscape_WIDTH            1
#define DxF0xE4_xA2_LcReconfigArcMissingEscape_MASK             0x80
#define DxF0xE4_xA2_LcReconfigNow_OFFSET                        8
#define DxF0xE4_xA2_LcReconfigNow_WIDTH                         1
#define DxF0xE4_xA2_LcReconfigNow_MASK                          0x100
#define DxF0xE4_xA2_LcRenegotiationSupport_OFFSET               9
#define DxF0xE4_xA2_LcRenegotiationSupport_WIDTH                1
#define DxF0xE4_xA2_LcRenegotiationSupport_MASK                 0x200
#define DxF0xE4_xA2_LcRenegotiateEn_OFFSET                      10
#define DxF0xE4_xA2_LcRenegotiateEn_WIDTH                       1
#define DxF0xE4_xA2_LcRenegotiateEn_MASK                        0x400
#define DxF0xE4_xA2_LcShortReconfigEn_OFFSET                    11
#define DxF0xE4_xA2_LcShortReconfigEn_WIDTH                     1
#define DxF0xE4_xA2_LcShortReconfigEn_MASK                      0x800
#define DxF0xE4_xA2_LcUpconfigureSupport_OFFSET                 12
#define DxF0xE4_xA2_LcUpconfigureSupport_WIDTH                  1
#define DxF0xE4_xA2_LcUpconfigureSupport_MASK                   0x1000
#define DxF0xE4_xA2_LcUpconfigureDis_OFFSET                     13
#define DxF0xE4_xA2_LcUpconfigureDis_WIDTH                      1
#define DxF0xE4_xA2_LcUpconfigureDis_MASK                       0x2000
#define DxF0xE4_xA2_Reserved_19_14_OFFSET                       14
#define DxF0xE4_xA2_Reserved_19_14_WIDTH                        6
#define DxF0xE4_xA2_Reserved_19_14_MASK                         0xfc000
#define DxF0xE4_xA2_LcUpconfigCapable_OFFSET                    20
#define DxF0xE4_xA2_LcUpconfigCapable_WIDTH                     1
#define DxF0xE4_xA2_LcUpconfigCapable_MASK                      0x100000
#define DxF0xE4_xA2_LcDynLanesPwrState_OFFSET                   21
#define DxF0xE4_xA2_LcDynLanesPwrState_WIDTH                    2
#define DxF0xE4_xA2_LcDynLanesPwrState_MASK                     0x600000
#define DxF0xE4_xA2_Reserved_31_23_OFFSET                       23
#define DxF0xE4_xA2_Reserved_31_23_WIDTH                        9
#define DxF0xE4_xA2_Reserved_31_23_MASK                         0xff800000

/// DxF0xE4_xA2
typedef union {
  struct {                                                              ///<
    UINT32                                              LcLinkWidth:3 ; ///<
    UINT32                                             Reserved_3_3:1 ; ///<
    UINT32                                            LcLinkWidthRd:3 ; ///<
    UINT32                               LcReconfigArcMissingEscape:1 ; ///<
    UINT32                                            LcReconfigNow:1 ; ///<
    UINT32                                   LcRenegotiationSupport:1 ; ///<
    UINT32                                          LcRenegotiateEn:1 ; ///<
    UINT32                                        LcShortReconfigEn:1 ; ///<
    UINT32                                     LcUpconfigureSupport:1 ; ///<
    UINT32                                         LcUpconfigureDis:1 ; ///<
    UINT32                                           Reserved_19_14:6 ; ///<
    UINT32                                        LcUpconfigCapable:1 ; ///<
    UINT32                                       LcDynLanesPwrState:2 ; ///<
    UINT32                                           Reserved_31_23:9 ; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} DxF0xE4_xA2_STRUCT;

// **** DxF0xE4_xA3 Register Definition ****
// Address
#define DxF0xE4_xA3_ADDRESS                                     0xa3

// Type
#define DxF0xE4_xA3_TYPE                                        TYPE_D4F0xE4
// Field Data
#define DxF0xE4_xA3_Reserved_8_0_OFFSET                         0
#define DxF0xE4_xA3_Reserved_8_0_WIDTH                          9
#define DxF0xE4_xA3_Reserved_8_0_MASK                           0x1ff
#define DxF0xE4_xA3_LcXmitFtsBeforeRecovery_OFFSET              9
#define DxF0xE4_xA3_LcXmitFtsBeforeRecovery_WIDTH               1
#define DxF0xE4_xA3_LcXmitFtsBeforeRecovery_MASK                0x200
#define DxF0xE4_xA3_Reserved_31_10_OFFSET                       10
#define DxF0xE4_xA3_Reserved_31_10_WIDTH                        22
#define DxF0xE4_xA3_Reserved_31_10_MASK                         0xfffffc00

/// DxF0xE4_xA3
typedef union {
  struct {                                                              ///<
    UINT32                                             Reserved_8_0:9 ; ///<
    UINT32                                  LcXmitFtsBeforeRecovery:1 ; ///<
    UINT32                                           Reserved_31_10:22; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} DxF0xE4_xA3_STRUCT;

// **** DxF0xE4_xA4 Register Definition ****
// Address
#define DxF0xE4_xA4_ADDRESS                                     0xa4

// Type
#define DxF0xE4_xA4_TYPE                                        TYPE_D4F0xE4
// Field Data
#define DxF0xE4_xA4_LcGen2EnStrap_OFFSET                        0
#define DxF0xE4_xA4_LcGen2EnStrap_WIDTH                         1
#define DxF0xE4_xA4_LcGen2EnStrap_MASK                          0x1
#define DxF0xE4_xA4_Reserved_3_1_OFFSET                         1
#define DxF0xE4_xA4_Reserved_3_1_WIDTH                          3
#define DxF0xE4_xA4_Reserved_3_1_MASK                           0xe
#define DxF0xE4_xA4_LcForceDisSwSpeedChange_OFFSET              4
#define DxF0xE4_xA4_LcForceDisSwSpeedChange_WIDTH               1
#define DxF0xE4_xA4_LcForceDisSwSpeedChange_MASK                0x10
#define DxF0xE4_xA4_Reserved_6_5_OFFSET                         5
#define DxF0xE4_xA4_Reserved_6_5_WIDTH                          2
#define DxF0xE4_xA4_Reserved_6_5_MASK                           0x60
#define DxF0xE4_xA4_LcInitiateLinkSpeedChange_OFFSET            7
#define DxF0xE4_xA4_LcInitiateLinkSpeedChange_WIDTH             1
#define DxF0xE4_xA4_LcInitiateLinkSpeedChange_MASK              0x80
#define DxF0xE4_xA4_Reserved_9_8_OFFSET                         8
#define DxF0xE4_xA4_Reserved_9_8_WIDTH                          2
#define DxF0xE4_xA4_Reserved_9_8_MASK                           0x300
#define DxF0xE4_xA4_LcSpeedChangeAttemptFailed_OFFSET           10
#define DxF0xE4_xA4_LcSpeedChangeAttemptFailed_WIDTH            1
#define DxF0xE4_xA4_LcSpeedChangeAttemptFailed_MASK             0x400
#define DxF0xE4_xA4_Reserved_17_11_OFFSET                       11
#define DxF0xE4_xA4_Reserved_17_11_WIDTH                        7
#define DxF0xE4_xA4_Reserved_17_11_MASK                         0x3f800
#define DxF0xE4_xA4_LcGoToRecovery_OFFSET                       18
#define DxF0xE4_xA4_LcGoToRecovery_WIDTH                        1
#define DxF0xE4_xA4_LcGoToRecovery_MASK                         0x40000
#define DxF0xE4_xA4_Reserved_23_19_OFFSET                       19
#define DxF0xE4_xA4_Reserved_23_19_WIDTH                        5
#define DxF0xE4_xA4_Reserved_23_19_MASK                         0xf80000
#define DxF0xE4_xA4_LcOtherSideSupportsGen2_OFFSET              24
#define DxF0xE4_xA4_LcOtherSideSupportsGen2_WIDTH               1
#define DxF0xE4_xA4_LcOtherSideSupportsGen2_MASK                0x1000000
#define DxF0xE4_xA4_Reserved_28_25_OFFSET                       25
#define DxF0xE4_xA4_Reserved_28_25_WIDTH                        4
#define DxF0xE4_xA4_Reserved_28_25_MASK                         0x1e000000
#define DxF0xE4_xA4_LcMultUpstreamAutoSpdChngEn_OFFSET          29
#define DxF0xE4_xA4_LcMultUpstreamAutoSpdChngEn_WIDTH           1
#define DxF0xE4_xA4_LcMultUpstreamAutoSpdChngEn_MASK            0x20000000
#define DxF0xE4_xA4_Reserved_31_30_OFFSET                       30
#define DxF0xE4_xA4_Reserved_31_30_WIDTH                        2
#define DxF0xE4_xA4_Reserved_31_30_MASK                         0xc0000000

/// DxF0xE4_xA4
typedef union {
  struct {                                                              ///<
    UINT32                                            LcGen2EnStrap:1 ; ///<
    UINT32                                             Reserved_3_1:3 ; ///<
    UINT32                                  LcForceDisSwSpeedChange:1 ; ///<
    UINT32                                             Reserved_6_5:2 ; ///<
    UINT32                                LcInitiateLinkSpeedChange:1 ; ///<
    UINT32                                             Reserved_9_8:2 ; ///<
    UINT32                               LcSpeedChangeAttemptFailed:1 ; ///<
    UINT32                                           Reserved_17_11:7 ; ///<
    UINT32                                           LcGoToRecovery:1 ; ///<
    UINT32                                           Reserved_23_19:5 ; ///<
    UINT32                                  LcOtherSideSupportsGen2:1 ; ///<
    UINT32                                           Reserved_28_25:4 ; ///<
    UINT32                              LcMultUpstreamAutoSpdChngEn:1 ; ///<
    UINT32                                           Reserved_31_30:2 ; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} DxF0xE4_xA4_STRUCT;

// **** DxF0xE4_xA5 Register Definition ****
// Address
#define DxF0xE4_xA5_ADDRESS                                     0xa5

// Type
#define DxF0xE4_xA5_TYPE                                        TYPE_D4F0xE4
// Field Data
#define DxF0xE4_xA5_LcCurrentState_OFFSET                       0
#define DxF0xE4_xA5_LcCurrentState_WIDTH                        6
#define DxF0xE4_xA5_LcCurrentState_MASK                         0x3f
#define DxF0xE4_xA5_Reserved_7_6_OFFSET                         6
#define DxF0xE4_xA5_Reserved_7_6_WIDTH                          2
#define DxF0xE4_xA5_Reserved_7_6_MASK                           0xc0
#define DxF0xE4_xA5_LcPrevState1_OFFSET                         8
#define DxF0xE4_xA5_LcPrevState1_WIDTH                          6
#define DxF0xE4_xA5_LcPrevState1_MASK                           0x3f00
#define DxF0xE4_xA5_Reserved_15_14_OFFSET                       14
#define DxF0xE4_xA5_Reserved_15_14_WIDTH                        2
#define DxF0xE4_xA5_Reserved_15_14_MASK                         0xc000
#define DxF0xE4_xA5_LcPrevState2_OFFSET                         16
#define DxF0xE4_xA5_LcPrevState2_WIDTH                          6
#define DxF0xE4_xA5_LcPrevState2_MASK                           0x3f0000
#define DxF0xE4_xA5_Reserved_23_22_OFFSET                       22
#define DxF0xE4_xA5_Reserved_23_22_WIDTH                        2
#define DxF0xE4_xA5_Reserved_23_22_MASK                         0xc00000
#define DxF0xE4_xA5_LcPrevState3_OFFSET                         24
#define DxF0xE4_xA5_LcPrevState3_WIDTH                          6
#define DxF0xE4_xA5_LcPrevState3_MASK                           0x3f000000
#define DxF0xE4_xA5_Reserved_31_30_OFFSET                       30
#define DxF0xE4_xA5_Reserved_31_30_WIDTH                        2
#define DxF0xE4_xA5_Reserved_31_30_MASK                         0xc0000000

/// DxF0xE4_xA5
typedef union {
  struct {                                                              ///<
    UINT32                                           LcCurrentState:6 ; ///<
    UINT32                                             Reserved_7_6:2 ; ///<
    UINT32                                             LcPrevState1:6 ; ///<
    UINT32                                           Reserved_15_14:2 ; ///<
    UINT32                                             LcPrevState2:6 ; ///<
    UINT32                                           Reserved_23_22:2 ; ///<
    UINT32                                             LcPrevState3:6 ; ///<
    UINT32                                           Reserved_31_30:2 ; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} DxF0xE4_xA5_STRUCT;

// **** DxF0xE4_xB1 Register Definition ****
// Address
#define DxF0xE4_xB1_ADDRESS                                     0xb1

// Type
#define DxF0xE4_xB1_TYPE                                        TYPE_D4F0xE4
// Field Data
#define DxF0xE4_xB1_Reserved_18_0_OFFSET                        0
#define DxF0xE4_xB1_Reserved_18_0_WIDTH                         19
#define DxF0xE4_xB1_Reserved_18_0_MASK                          0x7ffff
#define DxF0xE4_xB1_LcDeassertRxEnInL0s_OFFSET                  19
#define DxF0xE4_xB1_LcDeassertRxEnInL0s_WIDTH                   1
#define DxF0xE4_xB1_LcDeassertRxEnInL0s_MASK                    0x80000
#define DxF0xE4_xB1_LcBlockElIdleinL0_OFFSET                    20
#define DxF0xE4_xB1_LcBlockElIdleinL0_WIDTH                     1
#define DxF0xE4_xB1_LcBlockElIdleinL0_MASK                      0x100000
#define DxF0xE4_xB1_Reserved_31_21_OFFSET                       21
#define DxF0xE4_xB1_Reserved_31_21_WIDTH                        11
#define DxF0xE4_xB1_Reserved_31_21_MASK                         0xffe00000

/// DxF0xE4_xB1
typedef union {
  struct {                                                              ///<
    UINT32                                            Reserved_18_0:19; ///<
    UINT32                                      LcDeassertRxEnInL0s:1 ; ///<
    UINT32                                        LcBlockElIdleinL0:1 ; ///<
    UINT32                                           Reserved_31_21:11; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} DxF0xE4_xB1_STRUCT;

// **** DxF0xE4_xC0 Register Definition ****
// Address
#define DxF0xE4_xC0_ADDRESS                                     0xc0

// Type
#define DxF0xE4_xC0_TYPE                                        TYPE_D4F0xE4
// Field Data
#define DxF0xE4_xC0_Reserved_12_0_OFFSET                        0
#define DxF0xE4_xC0_Reserved_12_0_WIDTH                         13
#define DxF0xE4_xC0_Reserved_12_0_MASK                          0x1fff
#define DxF0xE4_xC0_StrapForceCompliance_OFFSET                 13
#define DxF0xE4_xC0_StrapForceCompliance_WIDTH                  1
#define DxF0xE4_xC0_StrapForceCompliance_MASK                   0x2000
#define DxF0xE4_xC0_Reserved_14_14_OFFSET                       14
#define DxF0xE4_xC0_Reserved_14_14_WIDTH                        1
#define DxF0xE4_xC0_Reserved_14_14_MASK                         0x4000
#define DxF0xE4_xC0_StrapAutoRcSpeedNegotiationDis_OFFSET       15
#define DxF0xE4_xC0_StrapAutoRcSpeedNegotiationDis_WIDTH        1
#define DxF0xE4_xC0_StrapAutoRcSpeedNegotiationDis_MASK         0x8000
#define DxF0xE4_xC0_Reserved_31_16_OFFSET                       16
#define DxF0xE4_xC0_Reserved_31_16_WIDTH                        16
#define DxF0xE4_xC0_Reserved_31_16_MASK                         0xffff0000

/// DxF0xE4_xC0
typedef union {
  struct {                                                              ///<
    UINT32                                            Reserved_12_0:13; ///<
    UINT32                                     StrapForceCompliance:1 ; ///<
    UINT32                                           Reserved_14_14:1 ; ///<
    UINT32                           StrapAutoRcSpeedNegotiationDis:1 ; ///<
    UINT32                                           Reserved_31_16:16; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} DxF0xE4_xC0_STRUCT;

// **** DxF0xE4_xC1 Register Definition ****
// Address
#define DxF0xE4_xC1_ADDRESS                                     0xc1

// Type
#define DxF0xE4_xC1_TYPE                                        TYPE_D4F0xE4
// Field Data
#define DxF0xE4_xC1_Reserved_3_0_OFFSET                         0
#define DxF0xE4_xC1_Reserved_3_0_WIDTH                          4
#define DxF0xE4_xC1_Reserved_3_0_MASK                           0xf
#define DxF0xE4_xC1_StrapReverseLanes_OFFSET                    4
#define DxF0xE4_xC1_StrapReverseLanes_WIDTH                     1
#define DxF0xE4_xC1_StrapReverseLanes_MASK                      0x10
#define DxF0xE4_xC1_Reserved_31_5_OFFSET                        5
#define DxF0xE4_xC1_Reserved_31_5_WIDTH                         27
#define DxF0xE4_xC1_Reserved_31_5_MASK                          0xffffffe0

/// DxF0xE4_xC1
typedef union {
  struct {                                                              ///<
    UINT32                                             Reserved_3_0:4 ; ///<
    UINT32                                        StrapReverseLanes:1 ; ///<
    UINT32                                            Reserved_31_5:27; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} DxF0xE4_xC1_STRUCT;

// **** SMUx0B_x830C Register Definition ****
// Address
#define SMUx0B_x830C_ADDRESS                                    0x830c

// Type
#define SMUx0B_x830C_TYPE                                       TYPE_SMUx0B
// Field Data
#define SMUx0B_x830C_MinorVersion_OFFSET                        0
#define SMUx0B_x830C_MinorVersion_WIDTH                         16
#define SMUx0B_x830C_MinorVersion_MASK                          0xffff
#define SMUx0B_x830C_MajorVersion_OFFSET                        16
#define SMUx0B_x830C_MajorVersion_WIDTH                         16
#define SMUx0B_x830C_MajorVersion_MASK                          0xffff0000

/// SMUx0B_x830C
typedef union {
  struct {                                                              ///<
    UINT32                                             MinorVersion:16; ///<
    UINT32                                             MajorVersion:16; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} SMUx0B_x830C_STRUCT;

// **** SMUx0B_x8408 Register Definition ****
// Address
#define SMUx0B_x8408_ADDRESS                                    0x8408

// Type
#define SMUx0B_x8408_TYPE                                       TYPE_SMUx0B
// Field Data
#define SMUx0B_x8408_PsoControlId0_OFFSET                       0
#define SMUx0B_x8408_PsoControlId0_WIDTH                        4
#define SMUx0B_x8408_PsoControlId0_MASK                         0xf
#define SMUx0B_x8408_PsoControlId1_OFFSET                       4
#define SMUx0B_x8408_PsoControlId1_WIDTH                        4
#define SMUx0B_x8408_PsoControlId1_MASK                         0xf0
#define SMUx0B_x8408_PsoControlId2_OFFSET                       8
#define SMUx0B_x8408_PsoControlId2_WIDTH                        4
#define SMUx0B_x8408_PsoControlId2_MASK                         0xf00
#define SMUx0B_x8408_PsoControlId3_OFFSET                       12
#define SMUx0B_x8408_PsoControlId3_WIDTH                        4
#define SMUx0B_x8408_PsoControlId3_MASK                         0xf000
#define SMUx0B_x8408_PsoControlId4_OFFSET                       16
#define SMUx0B_x8408_PsoControlId4_WIDTH                        4
#define SMUx0B_x8408_PsoControlId4_MASK                         0xf0000
#define SMUx0B_x8408_PsoControlId5_OFFSET                       20
#define SMUx0B_x8408_PsoControlId5_WIDTH                        4
#define SMUx0B_x8408_PsoControlId5_MASK                         0xf00000
#define SMUx0B_x8408_PsoControlId6_OFFSET                       24
#define SMUx0B_x8408_PsoControlId6_WIDTH                        4
#define SMUx0B_x8408_PsoControlId6_MASK                         0xf000000
#define SMUx0B_x8408_PsoControlId7_OFFSET                       28
#define SMUx0B_x8408_PsoControlId7_WIDTH                        4
#define SMUx0B_x8408_PsoControlId7_MASK                         0xf0000000

/// SMUx0B_x8408
typedef union {
  struct {                                                              ///<
    UINT32                                            PsoControlId0:4 ; ///<
    UINT32                                            PsoControlId1:4 ; ///<
    UINT32                                            PsoControlId2:4 ; ///<
    UINT32                                            PsoControlId3:4 ; ///<
    UINT32                                            PsoControlId4:4 ; ///<
    UINT32                                            PsoControlId5:4 ; ///<
    UINT32                                            PsoControlId6:4 ; ///<
    UINT32                                            PsoControlId7:4 ; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} SMUx0B_x8408_STRUCT;

// **** SMUx0B_x840C Register Definition ****
// Address
#define SMUx0B_x840C_ADDRESS                                    0x840c

// Type
#define SMUx0B_x840C_TYPE                                       TYPE_SMUx0B
// Field Data
#define SMUx0B_x840C_PsoControlId8_OFFSET                       0
#define SMUx0B_x840C_PsoControlId8_WIDTH                        4
#define SMUx0B_x840C_PsoControlId8_MASK                         0xf
#define SMUx0B_x840C_PsoControlId9_OFFSET                       4
#define SMUx0B_x840C_PsoControlId9_WIDTH                        4
#define SMUx0B_x840C_PsoControlId9_MASK                         0xf0
#define SMUx0B_x840C_PsoControlId10_OFFSET                      8
#define SMUx0B_x840C_PsoControlId10_WIDTH                       4
#define SMUx0B_x840C_PsoControlId10_MASK                        0xf00
#define SMUx0B_x840C_PsoControlId11_OFFSET                      12
#define SMUx0B_x840C_PsoControlId11_WIDTH                       4
#define SMUx0B_x840C_PsoControlId11_MASK                        0xf000
#define SMUx0B_x840C_PsoControlId12_OFFSET                      16
#define SMUx0B_x840C_PsoControlId12_WIDTH                       4
#define SMUx0B_x840C_PsoControlId12_MASK                        0xf0000
#define SMUx0B_x840C_PsoControlId13_OFFSET                      20
#define SMUx0B_x840C_PsoControlId13_WIDTH                       4
#define SMUx0B_x840C_PsoControlId13_MASK                        0xf00000
#define SMUx0B_x840C_PsoControlId14_OFFSET                      24
#define SMUx0B_x840C_PsoControlId14_WIDTH                       4
#define SMUx0B_x840C_PsoControlId14_MASK                        0xf000000
#define SMUx0B_x840C_PsoControlId15_OFFSET                      28
#define SMUx0B_x840C_PsoControlId15_WIDTH                       4
#define SMUx0B_x840C_PsoControlId15_MASK                        0xf0000000

/// SMUx0B_x840C
typedef union {
  struct {                                                              ///<
    UINT32                                            PsoControlId8:4 ; ///<
    UINT32                                            PsoControlId9:4 ; ///<
    UINT32                                           PsoControlId10:4 ; ///<
    UINT32                                           PsoControlId11:4 ; ///<
    UINT32                                           PsoControlId12:4 ; ///<
    UINT32                                           PsoControlId13:4 ; ///<
    UINT32                                           PsoControlId14:4 ; ///<
    UINT32                                           PsoControlId15:4 ; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} SMUx0B_x840C_STRUCT;

// **** SMUx0B_x8410 Register Definition ****
// Address
#define SMUx0B_x8410_ADDRESS                                    0x8410

// Type
#define SMUx0B_x8410_TYPE                                       TYPE_SMUx0B
// Field Data
#define SMUx0B_x8410_PwrGatingEn_OFFSET                         0
#define SMUx0B_x8410_PwrGatingEn_WIDTH                          1
#define SMUx0B_x8410_PwrGatingEn_MASK                           0x1
#define SMUx0B_x8410_Reserved_2_1_OFFSET                        1
#define SMUx0B_x8410_Reserved_2_1_WIDTH                         2
#define SMUx0B_x8410_Reserved_2_1_MASK                          0x6
#define SMUx0B_x8410_PsoControlValidNum_OFFSET                  3
#define SMUx0B_x8410_PsoControlValidNum_WIDTH                   5
#define SMUx0B_x8410_PsoControlValidNum_MASK                    0xf8
#define SMUx0B_x8410_PsoControlPeriod_OFFSET                    8
#define SMUx0B_x8410_PsoControlPeriod_WIDTH                     8
#define SMUx0B_x8410_PsoControlPeriod_MASK                      0xff00
#define SMUx0B_x8410_RstPulseWidth_OFFSET                       16
#define SMUx0B_x8410_RstPulseWidth_WIDTH                        8
#define SMUx0B_x8410_RstPulseWidth_MASK                         0xff0000
#define SMUx0B_x8410_IsoDelay_OFFSET                            24
#define SMUx0B_x8410_IsoDelay_WIDTH                             4
#define SMUx0B_x8410_IsoDelay_MASK                              0xf000000
#define SMUx0B_x8410_PwrGaterSel_OFFSET                         28
#define SMUx0B_x8410_PwrGaterSel_WIDTH                          4
#define SMUx0B_x8410_PwrGaterSel_MASK                           0xf0000000

/// SMUx0B_x8410
typedef union {
  struct {                                                              ///<
    UINT32                                              PwrGatingEn:1 ; ///<
    UINT32                                             Reserved_2_1:2 ; ///<
    UINT32                                       PsoControlValidNum:5 ; ///<
    UINT32                                         PsoControlPeriod:8 ; ///<
    UINT32                                            RstPulseWidth:8 ; ///<
    UINT32                                                 IsoDelay:4 ; ///<
    UINT32                                              PwrGaterSel:4 ; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} SMUx0B_x8410_STRUCT;

// **** SMUx0B_x8434 Register Definition ****
// Address
#define SMUx0B_x8434_ADDRESS                                    0x8434

// Type
#define SMUx0B_x8434_TYPE                                       TYPE_SMUx0B
// Field Data
#define SMUx0B_x8434_LclkDpmEn_OFFSET                           0
#define SMUx0B_x8434_LclkDpmEn_WIDTH                            1
#define SMUx0B_x8434_LclkDpmEn_MASK                             0x1
#define SMUx0B_x8434_LclkDpmType_OFFSET                         1
#define SMUx0B_x8434_LclkDpmType_WIDTH                          1
#define SMUx0B_x8434_LclkDpmType_MASK                           0x2
#define SMUx0B_x8434_Reserved_3_2_OFFSET                        2
#define SMUx0B_x8434_Reserved_3_2_WIDTH                         2
#define SMUx0B_x8434_Reserved_3_2_MASK                          0xc
#define SMUx0B_x8434_LclkTimerPrescalar_OFFSET                  4
#define SMUx0B_x8434_LclkTimerPrescalar_WIDTH                   4
#define SMUx0B_x8434_LclkTimerPrescalar_MASK                    0xf0
#define SMUx0B_x8434_Reserved_15_8_OFFSET                       8
#define SMUx0B_x8434_Reserved_15_8_WIDTH                        8
#define SMUx0B_x8434_Reserved_15_8_MASK                         0xff00
#define SMUx0B_x8434_LclkTimerPeriod_OFFSET                     16
#define SMUx0B_x8434_LclkTimerPeriod_WIDTH                      16
#define SMUx0B_x8434_LclkTimerPeriod_MASK                       0xffff0000

/// SMUx0B_x8434
typedef union {
  struct {                                                              ///<
    UINT32                                                LclkDpmEn:1 ; ///<
    UINT32                                              LclkDpmType:1 ; ///<
    UINT32                                             Reserved_3_2:2 ; ///<
    UINT32                                       LclkTimerPrescalar:4 ; ///<
    UINT32                                            Reserved_15_8:8 ; ///<
    UINT32                                          LclkTimerPeriod:16; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} SMUx0B_x8434_STRUCT;

// **** SMUx0B_x8438 Register Definition ****
// Address
#define SMUx0B_x8438_ADDRESS                                    0x8438

// Type
#define SMUx0B_x8438_TYPE                                       TYPE_SMUx0B
// Field Data
#define SMUx0B_x8438_FstatePeriod_1_OFFSET                      0
#define SMUx0B_x8438_FstatePeriod_1_WIDTH                       16
#define SMUx0B_x8438_FstatePeriod_1_MASK                        0xffff
#define SMUx0B_x8438_FstatePeriod_0_OFFSET                      16
#define SMUx0B_x8438_FstatePeriod_0_WIDTH                       16
#define SMUx0B_x8438_FstatePeriod_0_MASK                        0xffff0000

/// SMUx0B_x8438
typedef union {
  struct {                                                              ///<
    UINT32                                           FstatePeriod_1:16; ///<
    UINT32                                           FstatePeriod_0:16; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} SMUx0B_x8438_STRUCT;

// **** SMUx0B_x843C Register Definition ****
// Address
#define SMUx0B_x843C_ADDRESS                                    0x843c

// Type
#define SMUx0B_x843C_TYPE                                       TYPE_SMUx0B
// Field Data
#define SMUx0B_x843C_FstatePeriod_3_OFFSET                      0
#define SMUx0B_x843C_FstatePeriod_3_WIDTH                       16
#define SMUx0B_x843C_FstatePeriod_3_MASK                        0xffff
#define SMUx0B_x843C_FstatePeriod_2_OFFSET                      16
#define SMUx0B_x843C_FstatePeriod_2_WIDTH                       16
#define SMUx0B_x843C_FstatePeriod_2_MASK                        0xffff0000

/// SMUx0B_x843C
typedef union {
  struct {                                                              ///<
    UINT32                                           FstatePeriod_3:16; ///<
    UINT32                                           FstatePeriod_2:16; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} SMUx0B_x843C_STRUCT;

// **** SMUx0B_x8440 Register Definition ****
// Address
#define SMUx0B_x8440_ADDRESS                                    0x8440

// Type
#define SMUx0B_x8440_TYPE                                       TYPE_SMUx0B
// Field Data
#define SMUx0B_x8440_FstatePeriod_5_OFFSET                      0
#define SMUx0B_x8440_FstatePeriod_5_WIDTH                       16
#define SMUx0B_x8440_FstatePeriod_5_MASK                        0xffff
#define SMUx0B_x8440_FstatePeriod_4_OFFSET                      16
#define SMUx0B_x8440_FstatePeriod_4_WIDTH                       16
#define SMUx0B_x8440_FstatePeriod_4_MASK                        0xffff0000

/// SMUx0B_x8440
typedef union {
  struct {                                                              ///<
    UINT32                                           FstatePeriod_5:16; ///<
    UINT32                                           FstatePeriod_4:16; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} SMUx0B_x8440_STRUCT;

// **** SMUx0B_x8444 Register Definition ****
// Address
#define SMUx0B_x8444_ADDRESS                                    0x8444

// Type
#define SMUx0B_x8444_TYPE                                       TYPE_SMUx0B
// Field Data
#define SMUx0B_x8444_FstatePeriod_7_OFFSET                      0
#define SMUx0B_x8444_FstatePeriod_7_WIDTH                       16
#define SMUx0B_x8444_FstatePeriod_7_MASK                        0xffff
#define SMUx0B_x8444_FstatePeriod_6_OFFSET                      16
#define SMUx0B_x8444_FstatePeriod_6_WIDTH                       16
#define SMUx0B_x8444_FstatePeriod_6_MASK                        0xffff0000

/// SMUx0B_x8444
typedef union {
  struct {                                                              ///<
    UINT32                                           FstatePeriod_7:16; ///<
    UINT32                                           FstatePeriod_6:16; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} SMUx0B_x8444_STRUCT;

// **** SMUx0B_x8448 Register Definition ****
// Address
#define SMUx0B_x8448_ADDRESS                                    0x8448

// Type
#define SMUx0B_x8448_TYPE                                       TYPE_SMUx0B
// Field Data
#define SMUx0B_x8448_FstatePeriod_9_OFFSET                      0
#define SMUx0B_x8448_FstatePeriod_9_WIDTH                       16
#define SMUx0B_x8448_FstatePeriod_9_MASK                        0xffff
#define SMUx0B_x8448_FstatePeriod_8_OFFSET                      16
#define SMUx0B_x8448_FstatePeriod_8_WIDTH                       16
#define SMUx0B_x8448_FstatePeriod_8_MASK                        0xffff0000

/// SMUx0B_x8448
typedef union {
  struct {                                                              ///<
    UINT32                                           FstatePeriod_9:16; ///<
    UINT32                                           FstatePeriod_8:16; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} SMUx0B_x8448_STRUCT;

// **** SMUx0B_x8454 Register Definition ****
// Address
#define SMUx0B_x8454_ADDRESS                                    0x8454

// Type
#define SMUx0B_x8454_TYPE                                       TYPE_SMUx0B
// Field Data
#define SMUx0B_x8454_Reserved_7_0_OFFSET                        0
#define SMUx0B_x8454_Reserved_7_0_WIDTH                         8
#define SMUx0B_x8454_Reserved_7_0_MASK                          0xff
#define SMUx0B_x8454_Reserved_15_8_OFFSET                       8
#define SMUx0B_x8454_Reserved_15_8_WIDTH                        8
#define SMUx0B_x8454_Reserved_15_8_MASK                         0xff00
#define SMUx0B_x8454_FstateUpHyst_9_OFFSET                      16
#define SMUx0B_x8454_FstateUpHyst_9_WIDTH                       8
#define SMUx0B_x8454_FstateUpHyst_9_MASK                        0xff0000
#define SMUx0B_x8454_FstateUpHyst_8_OFFSET                      24
#define SMUx0B_x8454_FstateUpHyst_8_WIDTH                       8
#define SMUx0B_x8454_FstateUpHyst_8_MASK                        0xff000000

/// SMUx0B_x8454
typedef union {
  struct {                                                              ///<
    UINT32                                             Reserved_7_0:8 ; ///<
    UINT32                                            Reserved_15_8:8 ; ///<
    UINT32                                           FstateUpHyst_9:8 ; ///<
    UINT32                                           FstateUpHyst_8:8 ; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} SMUx0B_x8454_STRUCT;

// **** SMUx0B_x8460 Register Definition ****
// Address
#define SMUx0B_x8460_ADDRESS                                    0x8460

// Type
#define SMUx0B_x8460_TYPE                                       TYPE_SMUx0B
// Field Data
#define SMUx0B_x8460_Raising_OFFSET                             0
#define SMUx0B_x8460_Raising_WIDTH                              16
#define SMUx0B_x8460_Raising_MASK                               0xffff
#define SMUx0B_x8460_Lowering_OFFSET                            16
#define SMUx0B_x8460_Lowering_WIDTH                             16
#define SMUx0B_x8460_Lowering_MASK                              0xffff0000

/// SMUx0B_x8460
typedef union {
  struct {                                                              ///<
    UINT32                                                  Raising:16; ///<
    UINT32                                                 Lowering:16; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} SMUx0B_x8460_STRUCT;

// **** SMUx0B_x8461 Register Definition ****
// Address
#define SMUx0B_x8461_ADDRESS                                    0x8461

// Type
#define SMUx0B_x8461_TYPE                                       TYPE_SMUx0B
// Field Data
#define SMUx0B_x8461_Raising_OFFSET                             0
#define SMUx0B_x8461_Raising_WIDTH                              16
#define SMUx0B_x8461_Raising_MASK                               0xffff
#define SMUx0B_x8461_Lowering_OFFSET                            16
#define SMUx0B_x8461_Lowering_WIDTH                             16
#define SMUx0B_x8461_Lowering_MASK                              0xffff0000

/// SMUx0B_x8461
typedef union {
  struct {                                                              ///<
    UINT32                                                  Raising:16; ///<
    UINT32                                                 Lowering:16; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} SMUx0B_x8461_STRUCT;

// **** SMUx0B_x8462 Register Definition ****
// Address
#define SMUx0B_x8462_ADDRESS                                    0x8462

// Type
#define SMUx0B_x8462_TYPE                                       TYPE_SMUx0B
// Field Data
#define SMUx0B_x8462_Raising_OFFSET                             0
#define SMUx0B_x8462_Raising_WIDTH                              16
#define SMUx0B_x8462_Raising_MASK                               0xffff
#define SMUx0B_x8462_Lowering_OFFSET                            16
#define SMUx0B_x8462_Lowering_WIDTH                             16
#define SMUx0B_x8462_Lowering_MASK                              0xffff0000

/// SMUx0B_x8462
typedef union {
  struct {                                                              ///<
    UINT32                                                  Raising:16; ///<
    UINT32                                                 Lowering:16; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} SMUx0B_x8462_STRUCT;

// **** SMUx0B_x8463 Register Definition ****
// Address
#define SMUx0B_x8463_ADDRESS                                    0x8463

// Type
#define SMUx0B_x8463_TYPE                                       TYPE_SMUx0B
// Field Data
#define SMUx0B_x8463_Raising_OFFSET                             0
#define SMUx0B_x8463_Raising_WIDTH                              16
#define SMUx0B_x8463_Raising_MASK                               0xffff
#define SMUx0B_x8463_Lowering_OFFSET                            16
#define SMUx0B_x8463_Lowering_WIDTH                             16
#define SMUx0B_x8463_Lowering_MASK                              0xffff0000

/// SMUx0B_x8463
typedef union {
  struct {                                                              ///<
    UINT32                                                  Raising:16; ///<
    UINT32                                                 Lowering:16; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} SMUx0B_x8463_STRUCT;

// **** SMUx0B_x8464 Register Definition ****
// Address
#define SMUx0B_x8464_ADDRESS                                    0x8464

// Type
#define SMUx0B_x8464_TYPE                                       TYPE_SMUx0B
// Field Data
#define SMUx0B_x8464_Raising_OFFSET                             0
#define SMUx0B_x8464_Raising_WIDTH                              16
#define SMUx0B_x8464_Raising_MASK                               0xffff
#define SMUx0B_x8464_Lowering_OFFSET                            16
#define SMUx0B_x8464_Lowering_WIDTH                             16
#define SMUx0B_x8464_Lowering_MASK                              0xffff0000

/// SMUx0B_x8464
typedef union {
  struct {                                                              ///<
    UINT32                                                  Raising:16; ///<
    UINT32                                                 Lowering:16; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} SMUx0B_x8464_STRUCT;

// **** SMUx0B_x8465 Register Definition ****
// Address
#define SMUx0B_x8465_ADDRESS                                    0x8465

// Type
#define SMUx0B_x8465_TYPE                                       TYPE_SMUx0B
// Field Data
#define SMUx0B_x8465_Raising_OFFSET                             0
#define SMUx0B_x8465_Raising_WIDTH                              16
#define SMUx0B_x8465_Raising_MASK                               0xffff
#define SMUx0B_x8465_Lowering_OFFSET                            16
#define SMUx0B_x8465_Lowering_WIDTH                             16
#define SMUx0B_x8465_Lowering_MASK                              0xffff0000

/// SMUx0B_x8465
typedef union {
  struct {                                                              ///<
    UINT32                                                  Raising:16; ///<
    UINT32                                                 Lowering:16; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} SMUx0B_x8465_STRUCT;

// **** SMUx0B_x8466 Register Definition ****
// Address
#define SMUx0B_x8466_ADDRESS                                    0x8466

// Type
#define SMUx0B_x8466_TYPE                                       TYPE_SMUx0B
// Field Data
#define SMUx0B_x8466_Raising_OFFSET                             0
#define SMUx0B_x8466_Raising_WIDTH                              16
#define SMUx0B_x8466_Raising_MASK                               0xffff
#define SMUx0B_x8466_Lowering_OFFSET                            16
#define SMUx0B_x8466_Lowering_WIDTH                             16
#define SMUx0B_x8466_Lowering_MASK                              0xffff0000

/// SMUx0B_x8466
typedef union {
  struct {                                                              ///<
    UINT32                                                  Raising:16; ///<
    UINT32                                                 Lowering:16; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} SMUx0B_x8466_STRUCT;

// **** SMUx0B_x8467 Register Definition ****
// Address
#define SMUx0B_x8467_ADDRESS                                    0x8467

// Type
#define SMUx0B_x8467_TYPE                                       TYPE_SMUx0B
// Field Data
#define SMUx0B_x8467_Raising_OFFSET                             0
#define SMUx0B_x8467_Raising_WIDTH                              16
#define SMUx0B_x8467_Raising_MASK                               0xffff
#define SMUx0B_x8467_Lowering_OFFSET                            16
#define SMUx0B_x8467_Lowering_WIDTH                             16
#define SMUx0B_x8467_Lowering_MASK                              0xffff0000

/// SMUx0B_x8467
typedef union {
  struct {                                                              ///<
    UINT32                                                  Raising:16; ///<
    UINT32                                                 Lowering:16; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} SMUx0B_x8467_STRUCT;

// **** SMUx0B_x8468 Register Definition ****
// Address
#define SMUx0B_x8468_ADDRESS                                    0x8468

// Type
#define SMUx0B_x8468_TYPE                                       TYPE_SMUx0B
// Field Data
#define SMUx0B_x8468_Raising_OFFSET                             0
#define SMUx0B_x8468_Raising_WIDTH                              16
#define SMUx0B_x8468_Raising_MASK                               0xffff
#define SMUx0B_x8468_Lowering_OFFSET                            16
#define SMUx0B_x8468_Lowering_WIDTH                             16
#define SMUx0B_x8468_Lowering_MASK                              0xffff0000

/// SMUx0B_x8468
typedef union {
  struct {                                                              ///<
    UINT32                                                  Raising:16; ///<
    UINT32                                                 Lowering:16; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} SMUx0B_x8468_STRUCT;

// **** SMUx0B_x8469 Register Definition ****
// Address
#define SMUx0B_x8469_ADDRESS                                    0x8469

// Type
#define SMUx0B_x8469_TYPE                                       TYPE_SMUx0B
// Field Data
#define SMUx0B_x8469_Raising_OFFSET                             0
#define SMUx0B_x8469_Raising_WIDTH                              16
#define SMUx0B_x8469_Raising_MASK                               0xffff
#define SMUx0B_x8469_Lowering_OFFSET                            16
#define SMUx0B_x8469_Lowering_WIDTH                             16
#define SMUx0B_x8469_Lowering_MASK                              0xffff0000

/// SMUx0B_x8469
typedef union {
  struct {                                                              ///<
    UINT32                                                  Raising:16; ///<
    UINT32                                                 Lowering:16; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} SMUx0B_x8469_STRUCT;

// **** SMUx0B_x846A Register Definition ****
// Address
#define SMUx0B_x846A_ADDRESS                                    0x846a

// Type
#define SMUx0B_x846A_TYPE                                       TYPE_SMUx0B
// Field Data
#define SMUx0B_x846A_Raising_OFFSET                             0
#define SMUx0B_x846A_Raising_WIDTH                              16
#define SMUx0B_x846A_Raising_MASK                               0xffff
#define SMUx0B_x846A_Lowering_OFFSET                            16
#define SMUx0B_x846A_Lowering_WIDTH                             16
#define SMUx0B_x846A_Lowering_MASK                              0xffff0000

/// SMUx0B_x846A
typedef union {
  struct {                                                              ///<
    UINT32                                                  Raising:16; ///<
    UINT32                                                 Lowering:16; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} SMUx0B_x846A_STRUCT;

// **** SMUx0B_x846B Register Definition ****
// Address
#define SMUx0B_x846B_ADDRESS                                    0x846b

// Type
#define SMUx0B_x846B_TYPE                                       TYPE_SMUx0B
// Field Data
#define SMUx0B_x846B_Raising_OFFSET                             0
#define SMUx0B_x846B_Raising_WIDTH                              16
#define SMUx0B_x846B_Raising_MASK                               0xffff
#define SMUx0B_x846B_Lowering_OFFSET                            16
#define SMUx0B_x846B_Lowering_WIDTH                             16
#define SMUx0B_x846B_Lowering_MASK                              0xffff0000

/// SMUx0B_x846B
typedef union {
  struct {                                                              ///<
    UINT32                                                  Raising:16; ///<
    UINT32                                                 Lowering:16; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} SMUx0B_x846B_STRUCT;

// **** SMUx0B_x846C Register Definition ****
// Address
#define SMUx0B_x846C_ADDRESS                                    0x846c

// Type
#define SMUx0B_x846C_TYPE                                       TYPE_SMUx0B
// Field Data
#define SMUx0B_x846C_Raising_OFFSET                             0
#define SMUx0B_x846C_Raising_WIDTH                              16
#define SMUx0B_x846C_Raising_MASK                               0xffff
#define SMUx0B_x846C_Lowering_OFFSET                            16
#define SMUx0B_x846C_Lowering_WIDTH                             16
#define SMUx0B_x846C_Lowering_MASK                              0xffff0000

/// SMUx0B_x846C
typedef union {
  struct {                                                              ///<
    UINT32                                                  Raising:16; ///<
    UINT32                                                 Lowering:16; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} SMUx0B_x846C_STRUCT;

// **** SMUx0B_x846D Register Definition ****
// Address
#define SMUx0B_x846D_ADDRESS                                    0x846d

// Type
#define SMUx0B_x846D_TYPE                                       TYPE_SMUx0B
// Field Data
#define SMUx0B_x846D_Raising_OFFSET                             0
#define SMUx0B_x846D_Raising_WIDTH                              16
#define SMUx0B_x846D_Raising_MASK                               0xffff
#define SMUx0B_x846D_Lowering_OFFSET                            16
#define SMUx0B_x846D_Lowering_WIDTH                             16
#define SMUx0B_x846D_Lowering_MASK                              0xffff0000

/// SMUx0B_x846D
typedef union {
  struct {                                                              ///<
    UINT32                                                  Raising:16; ///<
    UINT32                                                 Lowering:16; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} SMUx0B_x846D_STRUCT;

// **** SMUx0B_x846E Register Definition ****
// Address
#define SMUx0B_x846E_ADDRESS                                    0x846e

// Type
#define SMUx0B_x846E_TYPE                                       TYPE_SMUx0B
// Field Data
#define SMUx0B_x846E_Raising_OFFSET                             0
#define SMUx0B_x846E_Raising_WIDTH                              16
#define SMUx0B_x846E_Raising_MASK                               0xffff
#define SMUx0B_x846E_Lowering_OFFSET                            16
#define SMUx0B_x846E_Lowering_WIDTH                             16
#define SMUx0B_x846E_Lowering_MASK                              0xffff0000

/// SMUx0B_x846E
typedef union {
  struct {                                                              ///<
    UINT32                                                  Raising:16; ///<
    UINT32                                                 Lowering:16; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} SMUx0B_x846E_STRUCT;

// **** SMUx0B_x846F Register Definition ****
// Address
#define SMUx0B_x846F_ADDRESS                                    0x846f

// Type
#define SMUx0B_x846F_TYPE                                       TYPE_SMUx0B
// Field Data
#define SMUx0B_x846F_Raising_OFFSET                             0
#define SMUx0B_x846F_Raising_WIDTH                              16
#define SMUx0B_x846F_Raising_MASK                               0xffff
#define SMUx0B_x846F_Lowering_OFFSET                            16
#define SMUx0B_x846F_Lowering_WIDTH                             16
#define SMUx0B_x846F_Lowering_MASK                              0xffff0000

/// SMUx0B_x846F
typedef union {
  struct {                                                              ///<
    UINT32                                                  Raising:16; ///<
    UINT32                                                 Lowering:16; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} SMUx0B_x846F_STRUCT;

// **** SMUx0B_x8470 Register Definition ****
// Address
#define SMUx0B_x8470_ADDRESS                                    0x8470

// Type
#define SMUx0B_x8470_TYPE                                       TYPE_SMUx0B
// Field Data
#define SMUx0B_x8470_Raising_OFFSET                             0
#define SMUx0B_x8470_Raising_WIDTH                              16
#define SMUx0B_x8470_Raising_MASK                               0xffff
#define SMUx0B_x8470_Lowering_OFFSET                            16
#define SMUx0B_x8470_Lowering_WIDTH                             16
#define SMUx0B_x8470_Lowering_MASK                              0xffff0000

/// SMUx0B_x8470
typedef union {
  struct {                                                              ///<
    UINT32                                                  Raising:16; ///<
    UINT32                                                 Lowering:16; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} SMUx0B_x8470_STRUCT;

// **** SMUx0B_x8471 Register Definition ****
// Address
#define SMUx0B_x8471_ADDRESS                                    0x8471

// Type
#define SMUx0B_x8471_TYPE                                       TYPE_SMUx0B
// Field Data
#define SMUx0B_x8471_Raising_OFFSET                             0
#define SMUx0B_x8471_Raising_WIDTH                              16
#define SMUx0B_x8471_Raising_MASK                               0xffff
#define SMUx0B_x8471_Lowering_OFFSET                            16
#define SMUx0B_x8471_Lowering_WIDTH                             16
#define SMUx0B_x8471_Lowering_MASK                              0xffff0000

/// SMUx0B_x8471
typedef union {
  struct {                                                              ///<
    UINT32                                                  Raising:16; ///<
    UINT32                                                 Lowering:16; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} SMUx0B_x8471_STRUCT;

// **** SMUx0B_x8472 Register Definition ****
// Address
#define SMUx0B_x8472_ADDRESS                                    0x8472

// Type
#define SMUx0B_x8472_TYPE                                       TYPE_SMUx0B
// Field Data
#define SMUx0B_x8472_Raising_OFFSET                             0
#define SMUx0B_x8472_Raising_WIDTH                              16
#define SMUx0B_x8472_Raising_MASK                               0xffff
#define SMUx0B_x8472_Lowering_OFFSET                            16
#define SMUx0B_x8472_Lowering_WIDTH                             16
#define SMUx0B_x8472_Lowering_MASK                              0xffff0000

/// SMUx0B_x8472
typedef union {
  struct {                                                              ///<
    UINT32                                                  Raising:16; ///<
    UINT32                                                 Lowering:16; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} SMUx0B_x8472_STRUCT;

// **** SMUx0B_x8473 Register Definition ****
// Address
#define SMUx0B_x8473_ADDRESS                                    0x8473

// Type
#define SMUx0B_x8473_TYPE                                       TYPE_SMUx0B
// Field Data
#define SMUx0B_x8473_Raising_OFFSET                             0
#define SMUx0B_x8473_Raising_WIDTH                              16
#define SMUx0B_x8473_Raising_MASK                               0xffff
#define SMUx0B_x8473_Lowering_OFFSET                            16
#define SMUx0B_x8473_Lowering_WIDTH                             16
#define SMUx0B_x8473_Lowering_MASK                              0xffff0000

/// SMUx0B_x8473
typedef union {
  struct {                                                              ///<
    UINT32                                                  Raising:16; ///<
    UINT32                                                 Lowering:16; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} SMUx0B_x8473_STRUCT;

// **** SMUx0B_x8474 Register Definition ****
// Address
#define SMUx0B_x8474_ADDRESS                                    0x8474

// Type
#define SMUx0B_x8474_TYPE                                       TYPE_SMUx0B
// Field Data
#define SMUx0B_x8474_Raising_OFFSET                             0
#define SMUx0B_x8474_Raising_WIDTH                              16
#define SMUx0B_x8474_Raising_MASK                               0xffff
#define SMUx0B_x8474_Lowering_OFFSET                            16
#define SMUx0B_x8474_Lowering_WIDTH                             16
#define SMUx0B_x8474_Lowering_MASK                              0xffff0000

/// SMUx0B_x8474
typedef union {
  struct {                                                              ///<
    UINT32                                                  Raising:16; ///<
    UINT32                                                 Lowering:16; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} SMUx0B_x8474_STRUCT;

// **** SMUx0B_x8475 Register Definition ****
// Address
#define SMUx0B_x8475_ADDRESS                                    0x8475

// Type
#define SMUx0B_x8475_TYPE                                       TYPE_SMUx0B
// Field Data
#define SMUx0B_x8475_Raising_OFFSET                             0
#define SMUx0B_x8475_Raising_WIDTH                              16
#define SMUx0B_x8475_Raising_MASK                               0xffff
#define SMUx0B_x8475_Lowering_OFFSET                            16
#define SMUx0B_x8475_Lowering_WIDTH                             16
#define SMUx0B_x8475_Lowering_MASK                              0xffff0000

/// SMUx0B_x8475
typedef union {
  struct {                                                              ///<
    UINT32                                                  Raising:16; ///<
    UINT32                                                 Lowering:16; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} SMUx0B_x8475_STRUCT;

// **** SMUx0B_x8476 Register Definition ****
// Address
#define SMUx0B_x8476_ADDRESS                                    0x8476

// Type
#define SMUx0B_x8476_TYPE                                       TYPE_SMUx0B
// Field Data
#define SMUx0B_x8476_Raising_OFFSET                             0
#define SMUx0B_x8476_Raising_WIDTH                              16
#define SMUx0B_x8476_Raising_MASK                               0xffff
#define SMUx0B_x8476_Lowering_OFFSET                            16
#define SMUx0B_x8476_Lowering_WIDTH                             16
#define SMUx0B_x8476_Lowering_MASK                              0xffff0000

/// SMUx0B_x8476
typedef union {
  struct {                                                              ///<
    UINT32                                                  Raising:16; ///<
    UINT32                                                 Lowering:16; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} SMUx0B_x8476_STRUCT;

// **** SMUx0B_x8477 Register Definition ****
// Address
#define SMUx0B_x8477_ADDRESS                                    0x8477

// Type
#define SMUx0B_x8477_TYPE                                       TYPE_SMUx0B
// Field Data
#define SMUx0B_x8477_Raising_OFFSET                             0
#define SMUx0B_x8477_Raising_WIDTH                              16
#define SMUx0B_x8477_Raising_MASK                               0xffff
#define SMUx0B_x8477_Lowering_OFFSET                            16
#define SMUx0B_x8477_Lowering_WIDTH                             16
#define SMUx0B_x8477_Lowering_MASK                              0xffff0000

/// SMUx0B_x8477
typedef union {
  struct {                                                              ///<
    UINT32                                                  Raising:16; ///<
    UINT32                                                 Lowering:16; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} SMUx0B_x8477_STRUCT;

// **** SMUx0B_x8478 Register Definition ****
// Address
#define SMUx0B_x8478_ADDRESS                                    0x8478

// Type
#define SMUx0B_x8478_TYPE                                       TYPE_SMUx0B
// Field Data
#define SMUx0B_x8478_Raising_OFFSET                             0
#define SMUx0B_x8478_Raising_WIDTH                              16
#define SMUx0B_x8478_Raising_MASK                               0xffff
#define SMUx0B_x8478_Lowering_OFFSET                            16
#define SMUx0B_x8478_Lowering_WIDTH                             16
#define SMUx0B_x8478_Lowering_MASK                              0xffff0000

/// SMUx0B_x8478
typedef union {
  struct {                                                              ///<
    UINT32                                                  Raising:16; ///<
    UINT32                                                 Lowering:16; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} SMUx0B_x8478_STRUCT;

// **** SMUx0B_x8479 Register Definition ****
// Address
#define SMUx0B_x8479_ADDRESS                                    0x8479

// Type
#define SMUx0B_x8479_TYPE                                       TYPE_SMUx0B
// Field Data
#define SMUx0B_x8479_Raising_OFFSET                             0
#define SMUx0B_x8479_Raising_WIDTH                              16
#define SMUx0B_x8479_Raising_MASK                               0xffff
#define SMUx0B_x8479_Lowering_OFFSET                            16
#define SMUx0B_x8479_Lowering_WIDTH                             16
#define SMUx0B_x8479_Lowering_MASK                              0xffff0000

/// SMUx0B_x8479
typedef union {
  struct {                                                              ///<
    UINT32                                                  Raising:16; ///<
    UINT32                                                 Lowering:16; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} SMUx0B_x8479_STRUCT;

// **** SMUx0B_x847A Register Definition ****
// Address
#define SMUx0B_x847A_ADDRESS                                    0x847a

// Type
#define SMUx0B_x847A_TYPE                                       TYPE_SMUx0B
// Field Data
#define SMUx0B_x847A_Raising_OFFSET                             0
#define SMUx0B_x847A_Raising_WIDTH                              16
#define SMUx0B_x847A_Raising_MASK                               0xffff
#define SMUx0B_x847A_Lowering_OFFSET                            16
#define SMUx0B_x847A_Lowering_WIDTH                             16
#define SMUx0B_x847A_Lowering_MASK                              0xffff0000

/// SMUx0B_x847A
typedef union {
  struct {                                                              ///<
    UINT32                                                  Raising:16; ///<
    UINT32                                                 Lowering:16; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} SMUx0B_x847A_STRUCT;

// **** SMUx0B_x847B Register Definition ****
// Address
#define SMUx0B_x847B_ADDRESS                                    0x847b

// Type
#define SMUx0B_x847B_TYPE                                       TYPE_SMUx0B
// Field Data
#define SMUx0B_x847B_Raising_OFFSET                             0
#define SMUx0B_x847B_Raising_WIDTH                              16
#define SMUx0B_x847B_Raising_MASK                               0xffff
#define SMUx0B_x847B_Lowering_OFFSET                            16
#define SMUx0B_x847B_Lowering_WIDTH                             16
#define SMUx0B_x847B_Lowering_MASK                              0xffff0000

/// SMUx0B_x847B
typedef union {
  struct {                                                              ///<
    UINT32                                                  Raising:16; ///<
    UINT32                                                 Lowering:16; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} SMUx0B_x847B_STRUCT;

// **** SMUx0B_x847C Register Definition ****
// Address
#define SMUx0B_x847C_ADDRESS                                    0x847c

// Type
#define SMUx0B_x847C_TYPE                                       TYPE_SMUx0B
// Field Data
#define SMUx0B_x847C_Raising_OFFSET                             0
#define SMUx0B_x847C_Raising_WIDTH                              16
#define SMUx0B_x847C_Raising_MASK                               0xffff
#define SMUx0B_x847C_Lowering_OFFSET                            16
#define SMUx0B_x847C_Lowering_WIDTH                             16
#define SMUx0B_x847C_Lowering_MASK                              0xffff0000

/// SMUx0B_x847C
typedef union {
  struct {                                                              ///<
    UINT32                                                  Raising:16; ///<
    UINT32                                                 Lowering:16; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} SMUx0B_x847C_STRUCT;

// **** SMUx0B_x8488 Register Definition ****
// Address
#define SMUx0B_x8488_ADDRESS                                    0x8488

// Type
#define SMUx0B_x8488_TYPE                                       TYPE_SMUx0B
// Field Data
#define SMUx0B_x8488_FstateDiv_3_OFFSET                         0
#define SMUx0B_x8488_FstateDiv_3_WIDTH                          7
#define SMUx0B_x8488_FstateDiv_3_MASK                           0x7f
#define SMUx0B_x8488_Reserved_7_7_OFFSET                        7
#define SMUx0B_x8488_Reserved_7_7_WIDTH                         1
#define SMUx0B_x8488_Reserved_7_7_MASK                          0x80
#define SMUx0B_x8488_FstateDiv_2_OFFSET                         8
#define SMUx0B_x8488_FstateDiv_2_WIDTH                          7
#define SMUx0B_x8488_FstateDiv_2_MASK                           0x7f00
#define SMUx0B_x8488_Reserved_15_15_OFFSET                      15
#define SMUx0B_x8488_Reserved_15_15_WIDTH                       1
#define SMUx0B_x8488_Reserved_15_15_MASK                        0x8000
#define SMUx0B_x8488_FstateDiv_1_OFFSET                         16
#define SMUx0B_x8488_FstateDiv_1_WIDTH                          7
#define SMUx0B_x8488_FstateDiv_1_MASK                           0x7f0000
#define SMUx0B_x8488_Reserved_23_23_OFFSET                      23
#define SMUx0B_x8488_Reserved_23_23_WIDTH                       1
#define SMUx0B_x8488_Reserved_23_23_MASK                        0x800000
#define SMUx0B_x8488_FstateDiv_0_OFFSET                         24
#define SMUx0B_x8488_FstateDiv_0_WIDTH                          7
#define SMUx0B_x8488_FstateDiv_0_MASK                           0x7f000000
#define SMUx0B_x8488_Reserved_31_31_OFFSET                      31
#define SMUx0B_x8488_Reserved_31_31_WIDTH                       1
#define SMUx0B_x8488_Reserved_31_31_MASK                        0x80000000

/// SMUx0B_x8488
typedef union {
  struct {                                                              ///<
    UINT32                                              FstateDiv_3:7 ; ///<
    UINT32                                             Reserved_7_7:1 ; ///<
    UINT32                                              FstateDiv_2:7 ; ///<
    UINT32                                           Reserved_15_15:1 ; ///<
    UINT32                                              FstateDiv_1:7 ; ///<
    UINT32                                           Reserved_23_23:1 ; ///<
    UINT32                                              FstateDiv_0:7 ; ///<
    UINT32                                           Reserved_31_31:1 ; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} SMUx0B_x8488_STRUCT;

// **** SMUx0B_x848C Register Definition ****
// Address
#define SMUx0B_x848C_ADDRESS                                    0x848c

// Type
#define SMUx0B_x848C_TYPE                                       TYPE_SMUx0B
// Field Data
#define SMUx0B_x848C_FstateDiv_7_OFFSET                         0
#define SMUx0B_x848C_FstateDiv_7_WIDTH                          7
#define SMUx0B_x848C_FstateDiv_7_MASK                           0x7f
#define SMUx0B_x848C_Reserved_7_7_OFFSET                        7
#define SMUx0B_x848C_Reserved_7_7_WIDTH                         1
#define SMUx0B_x848C_Reserved_7_7_MASK                          0x80
#define SMUx0B_x848C_FstateDiv_6_OFFSET                         8
#define SMUx0B_x848C_FstateDiv_6_WIDTH                          7
#define SMUx0B_x848C_FstateDiv_6_MASK                           0x7f00
#define SMUx0B_x848C_Reserved_15_15_OFFSET                      15
#define SMUx0B_x848C_Reserved_15_15_WIDTH                       1
#define SMUx0B_x848C_Reserved_15_15_MASK                        0x8000
#define SMUx0B_x848C_FstateDiv_5_OFFSET                         16
#define SMUx0B_x848C_FstateDiv_5_WIDTH                          7
#define SMUx0B_x848C_FstateDiv_5_MASK                           0x7f0000
#define SMUx0B_x848C_Reserved_23_23_OFFSET                      23
#define SMUx0B_x848C_Reserved_23_23_WIDTH                       1
#define SMUx0B_x848C_Reserved_23_23_MASK                        0x800000
#define SMUx0B_x848C_FstateDiv_4_OFFSET                         24
#define SMUx0B_x848C_FstateDiv_4_WIDTH                          7
#define SMUx0B_x848C_FstateDiv_4_MASK                           0x7f000000
#define SMUx0B_x848C_Reserved_31_31_OFFSET                      31
#define SMUx0B_x848C_Reserved_31_31_WIDTH                       1
#define SMUx0B_x848C_Reserved_31_31_MASK                        0x80000000

/// SMUx0B_x848C
typedef union {
  struct {                                                              ///<
    UINT32                                              FstateDiv_7:7 ; ///<
    UINT32                                             Reserved_7_7:1 ; ///<
    UINT32                                              FstateDiv_6:7 ; ///<
    UINT32                                           Reserved_15_15:1 ; ///<
    UINT32                                              FstateDiv_5:7 ; ///<
    UINT32                                           Reserved_23_23:1 ; ///<
    UINT32                                              FstateDiv_4:7 ; ///<
    UINT32                                           Reserved_31_31:1 ; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} SMUx0B_x848C_STRUCT;

// **** SMUx0B_x8490 Register Definition ****
// Address
#define SMUx0B_x8490_ADDRESS                                    0x8490

// Type
#define SMUx0B_x8490_TYPE                                       TYPE_SMUx0B
// Field Data
#define SMUx0B_x8490_LclkState0Valid_OFFSET                     0
#define SMUx0B_x8490_LclkState0Valid_WIDTH                      1
#define SMUx0B_x8490_LclkState0Valid_MASK                       0x1
#define SMUx0B_x8490_LclkState1Valid_OFFSET                     1
#define SMUx0B_x8490_LclkState1Valid_WIDTH                      1
#define SMUx0B_x8490_LclkState1Valid_MASK                       0x2
#define SMUx0B_x8490_LclkState2Valid_OFFSET                     2
#define SMUx0B_x8490_LclkState2Valid_WIDTH                      1
#define SMUx0B_x8490_LclkState2Valid_MASK                       0x4
#define SMUx0B_x8490_LclkState3Valid_OFFSET                     3
#define SMUx0B_x8490_LclkState3Valid_WIDTH                      1
#define SMUx0B_x8490_LclkState3Valid_MASK                       0x8
#define SMUx0B_x8490_LclkState4Valid_OFFSET                     4
#define SMUx0B_x8490_LclkState4Valid_WIDTH                      1
#define SMUx0B_x8490_LclkState4Valid_MASK                       0x10
#define SMUx0B_x8490_LclkState5Valid_OFFSET                     5
#define SMUx0B_x8490_LclkState5Valid_WIDTH                      1
#define SMUx0B_x8490_LclkState5Valid_MASK                       0x20
#define SMUx0B_x8490_LclkState6Valid_OFFSET                     6
#define SMUx0B_x8490_LclkState6Valid_WIDTH                      1
#define SMUx0B_x8490_LclkState6Valid_MASK                       0x40
#define SMUx0B_x8490_LclkState7Valid_OFFSET                     7
#define SMUx0B_x8490_LclkState7Valid_WIDTH                      1
#define SMUx0B_x8490_LclkState7Valid_MASK                       0x80
#define SMUx0B_x8490_LclkDivTtExit_OFFSET                       8
#define SMUx0B_x8490_LclkDivTtExit_WIDTH                        8
#define SMUx0B_x8490_LclkDivTtExit_MASK                         0xff00
#define SMUx0B_x8490_MinDivAllowed_OFFSET                       16
#define SMUx0B_x8490_MinDivAllowed_WIDTH                        8
#define SMUx0B_x8490_MinDivAllowed_MASK                         0xff0000
#define SMUx0B_x8490_Reserved_31_24_OFFSET                      24
#define SMUx0B_x8490_Reserved_31_24_WIDTH                       8
#define SMUx0B_x8490_Reserved_31_24_MASK                        0xff000000

/// SMUx0B_x8490
typedef union {
  struct {                                                              ///<
    UINT32                                          LclkState0Valid:1 ; ///<
    UINT32                                          LclkState1Valid:1 ; ///<
    UINT32                                          LclkState2Valid:1 ; ///<
    UINT32                                          LclkState3Valid:1 ; ///<
    UINT32                                          LclkState4Valid:1 ; ///<
    UINT32                                          LclkState5Valid:1 ; ///<
    UINT32                                          LclkState6Valid:1 ; ///<
    UINT32                                          LclkState7Valid:1 ; ///<
    UINT32                                            LclkDivTtExit:8 ; ///<
    UINT32                                            MinDivAllowed:8 ; ///<
    UINT32                                           Reserved_31_24:8 ; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} SMUx0B_x8490_STRUCT;

// **** SMUx0B_x849C Register Definition ****
// Address
#define SMUx0B_x849C_ADDRESS                                    0x849c

// Type
#define SMUx0B_x849C_TYPE                                       TYPE_SMUx0B
// Field Data
#define SMUx0B_x849C_Reserved_1_0_OFFSET                        0
#define SMUx0B_x849C_Reserved_1_0_WIDTH                         2
#define SMUx0B_x849C_Reserved_1_0_MASK                          0x3
#define SMUx0B_x849C_Reserved_3_2_OFFSET                        2
#define SMUx0B_x849C_Reserved_3_2_WIDTH                         2
#define SMUx0B_x849C_Reserved_3_2_MASK                          0xc
#define SMUx0B_x849C_Reserved_7_4_OFFSET                        4
#define SMUx0B_x849C_Reserved_7_4_WIDTH                         4
#define SMUx0B_x849C_Reserved_7_4_MASK                          0xf0
#define SMUx0B_x849C_Reserved_9_8_OFFSET                        8
#define SMUx0B_x849C_Reserved_9_8_WIDTH                         2
#define SMUx0B_x849C_Reserved_9_8_MASK                          0x300
#define SMUx0B_x849C_Reserved_11_10_OFFSET                      10
#define SMUx0B_x849C_Reserved_11_10_WIDTH                       2
#define SMUx0B_x849C_Reserved_11_10_MASK                        0xc00
#define SMUx0B_x849C_Reserved_15_12_OFFSET                      12
#define SMUx0B_x849C_Reserved_15_12_WIDTH                       4
#define SMUx0B_x849C_Reserved_15_12_MASK                        0xf000
#define SMUx0B_x849C_BaseVid_9_OFFSET                           16
#define SMUx0B_x849C_BaseVid_9_WIDTH                            2
#define SMUx0B_x849C_BaseVid_9_MASK                             0x30000
#define SMUx0B_x849C_TolExcdVid_9_OFFSET                        18
#define SMUx0B_x849C_TolExcdVid_9_WIDTH                         2
#define SMUx0B_x849C_TolExcdVid_9_MASK                          0xc0000
#define SMUx0B_x849C_Reserved_23_20_OFFSET                      20
#define SMUx0B_x849C_Reserved_23_20_WIDTH                       4
#define SMUx0B_x849C_Reserved_23_20_MASK                        0xf00000
#define SMUx0B_x849C_BaseVid_8_OFFSET                           24
#define SMUx0B_x849C_BaseVid_8_WIDTH                            2
#define SMUx0B_x849C_BaseVid_8_MASK                             0x3000000
#define SMUx0B_x849C_TolExcdVid_8_OFFSET                        26
#define SMUx0B_x849C_TolExcdVid_8_WIDTH                         2
#define SMUx0B_x849C_TolExcdVid_8_MASK                          0xc000000
#define SMUx0B_x849C_Reserved_31_28_OFFSET                      28
#define SMUx0B_x849C_Reserved_31_28_WIDTH                       4
#define SMUx0B_x849C_Reserved_31_28_MASK                        0xf0000000

/// SMUx0B_x849C
typedef union {
  struct {                                                              ///<
    UINT32                                             Reserved_1_0:2 ; ///<
    UINT32                                             Reserved_3_2:2 ; ///<
    UINT32                                             Reserved_7_4:4 ; ///<
    UINT32                                             Reserved_9_8:2 ; ///<
    UINT32                                           Reserved_11_10:2 ; ///<
    UINT32                                           Reserved_15_12:4 ; ///<
    UINT32                                                BaseVid_9:2 ; ///<
    UINT32                                             TolExcdVid_9:2 ; ///<
    UINT32                                           Reserved_23_20:4 ; ///<
    UINT32                                                BaseVid_8:2 ; ///<
    UINT32                                             TolExcdVid_8:2 ; ///<
    UINT32                                           Reserved_31_28:4 ; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} SMUx0B_x849C_STRUCT;

// **** SMUx0B_x84A0 Register Definition ****
// Address
#define SMUx0B_x84A0_ADDRESS                                    0x84a0

// Type
#define SMUx0B_x84A0_TYPE                                       TYPE_SMUx0B
// Field Data
#define SMUx0B_x84A0_MothPsoPwrup_OFFSET                        0
#define SMUx0B_x84A0_MothPsoPwrup_WIDTH                         16
#define SMUx0B_x84A0_MothPsoPwrup_MASK                          0xffff
#define SMUx0B_x84A0_MothPsoPwrdn_OFFSET                        16
#define SMUx0B_x84A0_MothPsoPwrdn_WIDTH                         16
#define SMUx0B_x84A0_MothPsoPwrdn_MASK                          0xffff0000

/// SMUx0B_x84A0
typedef union {
  struct {                                                              ///<
    UINT32                                             MothPsoPwrup:16; ///<
    UINT32                                             MothPsoPwrdn:16; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} SMUx0B_x84A0_STRUCT;

// **** SMUx0B_x84A4 Register Definition ****
// Address
#define SMUx0B_x84A4_ADDRESS                                    0x84a4

// Type
#define SMUx0B_x84A4_TYPE                                       TYPE_SMUx0B
// Field Data
#define SMUx0B_x84A4_DaugPsoPwrup_OFFSET                        0
#define SMUx0B_x84A4_DaugPsoPwrup_WIDTH                         16
#define SMUx0B_x84A4_DaugPsoPwrup_MASK                          0xffff
#define SMUx0B_x84A4_DaugPsoPwrdn_OFFSET                        16
#define SMUx0B_x84A4_DaugPsoPwrdn_WIDTH                         16
#define SMUx0B_x84A4_DaugPsoPwrdn_MASK                          0xffff0000

/// SMUx0B_x84A4
typedef union {
  struct {                                                              ///<
    UINT32                                             DaugPsoPwrup:16; ///<
    UINT32                                             DaugPsoPwrdn:16; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} SMUx0B_x84A4_STRUCT;

// **** SMUx0B_x84A8 Register Definition ****
// Address
#define SMUx0B_x84A8_ADDRESS                                    0x84a8

// Type
#define SMUx0B_x84A8_TYPE                                       TYPE_SMUx0B
// Field Data
#define SMUx0B_x84A8_ResetTimer_OFFSET                          0
#define SMUx0B_x84A8_ResetTimer_WIDTH                           16
#define SMUx0B_x84A8_ResetTimer_MASK                            0xffff
#define SMUx0B_x84A8_IsoTimer_OFFSET                            16
#define SMUx0B_x84A8_IsoTimer_WIDTH                             16
#define SMUx0B_x84A8_IsoTimer_MASK                              0xffff0000

/// SMUx0B_x84A8
typedef union {
  struct {                                                              ///<
    UINT32                                               ResetTimer:16; ///<
    UINT32                                                 IsoTimer:16; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} SMUx0B_x84A8_STRUCT;

// **** SMUx0B_x84C4 Register Definition ****
// Address
#define SMUx0B_x84C4_ADDRESS                                    0x84c4

// Type
#define SMUx0B_x84C4_TYPE                                       TYPE_SMUx0B
// Field Data
#define SMUx0B_x84C4_FstateDnHyst_3_OFFSET                      0
#define SMUx0B_x84C4_FstateDnHyst_3_WIDTH                       8
#define SMUx0B_x84C4_FstateDnHyst_3_MASK                        0xff
#define SMUx0B_x84C4_FstateDnHyst_2_OFFSET                      8
#define SMUx0B_x84C4_FstateDnHyst_2_WIDTH                       8
#define SMUx0B_x84C4_FstateDnHyst_2_MASK                        0xff00
#define SMUx0B_x84C4_FstateDnHyst_1_OFFSET                      16
#define SMUx0B_x84C4_FstateDnHyst_1_WIDTH                       8
#define SMUx0B_x84C4_FstateDnHyst_1_MASK                        0xff0000
#define SMUx0B_x84C4_FstateDnHyst_0_OFFSET                      24
#define SMUx0B_x84C4_FstateDnHyst_0_WIDTH                       8
#define SMUx0B_x84C4_FstateDnHyst_0_MASK                        0xff000000

/// SMUx0B_x84C4
typedef union {
  struct {                                                              ///<
    UINT32                                           FstateDnHyst_3:8 ; ///<
    UINT32                                           FstateDnHyst_2:8 ; ///<
    UINT32                                           FstateDnHyst_1:8 ; ///<
    UINT32                                           FstateDnHyst_0:8 ; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} SMUx0B_x84C4_STRUCT;

// **** SMUx0B_x84C8 Register Definition ****
// Address
#define SMUx0B_x84C8_ADDRESS                                    0x84c8

// Type
#define SMUx0B_x84C8_TYPE                                       TYPE_SMUx0B
// Field Data
#define SMUx0B_x84C8_FstateDnHyst_7_OFFSET                      0
#define SMUx0B_x84C8_FstateDnHyst_7_WIDTH                       8
#define SMUx0B_x84C8_FstateDnHyst_7_MASK                        0xff
#define SMUx0B_x84C8_FstateDnHyst_6_OFFSET                      8
#define SMUx0B_x84C8_FstateDnHyst_6_WIDTH                       8
#define SMUx0B_x84C8_FstateDnHyst_6_MASK                        0xff00
#define SMUx0B_x84C8_FstateDnHyst_5_OFFSET                      16
#define SMUx0B_x84C8_FstateDnHyst_5_WIDTH                       8
#define SMUx0B_x84C8_FstateDnHyst_5_MASK                        0xff0000
#define SMUx0B_x84C8_FstateDnHyst_4_OFFSET                      24
#define SMUx0B_x84C8_FstateDnHyst_4_WIDTH                       8
#define SMUx0B_x84C8_FstateDnHyst_4_MASK                        0xff000000

/// SMUx0B_x84C8
typedef union {
  struct {                                                              ///<
    UINT32                                           FstateDnHyst_7:8 ; ///<
    UINT32                                           FstateDnHyst_6:8 ; ///<
    UINT32                                           FstateDnHyst_5:8 ; ///<
    UINT32                                           FstateDnHyst_4:8 ; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} SMUx0B_x84C8_STRUCT;

// **** SMUx0B_x84D0 Register Definition ****
// Address
#define SMUx0B_x84D0_ADDRESS                                    0x84d0

// Type
#define SMUx0B_x84D0_TYPE                                       TYPE_SMUx0B
// Field Data
#define SMUx0B_x84D0_FstateDivTol_5_OFFSET                      0
#define SMUx0B_x84D0_FstateDivTol_5_WIDTH                       7
#define SMUx0B_x84D0_FstateDivTol_5_MASK                        0x7f
#define SMUx0B_x84D0_Reserved_7_7_OFFSET                        7
#define SMUx0B_x84D0_Reserved_7_7_WIDTH                         1
#define SMUx0B_x84D0_Reserved_7_7_MASK                          0x80
#define SMUx0B_x84D0_FstateDivTol_4_OFFSET                      8
#define SMUx0B_x84D0_FstateDivTol_4_WIDTH                       7
#define SMUx0B_x84D0_FstateDivTol_4_MASK                        0x7f00
#define SMUx0B_x84D0_Reserved_15_15_OFFSET                      15
#define SMUx0B_x84D0_Reserved_15_15_WIDTH                       1
#define SMUx0B_x84D0_Reserved_15_15_MASK                        0x8000
#define SMUx0B_x84D0_FstateDivTol_3_OFFSET                      16
#define SMUx0B_x84D0_FstateDivTol_3_WIDTH                       7
#define SMUx0B_x84D0_FstateDivTol_3_MASK                        0x7f0000
#define SMUx0B_x84D0_Reserved_23_23_OFFSET                      23
#define SMUx0B_x84D0_Reserved_23_23_WIDTH                       1
#define SMUx0B_x84D0_Reserved_23_23_MASK                        0x800000
#define SMUx0B_x84D0_FstateDivTol_2_OFFSET                      24
#define SMUx0B_x84D0_FstateDivTol_2_WIDTH                       7
#define SMUx0B_x84D0_FstateDivTol_2_MASK                        0x7f000000
#define SMUx0B_x84D0_Reserved_31_31_OFFSET                      31
#define SMUx0B_x84D0_Reserved_31_31_WIDTH                       1
#define SMUx0B_x84D0_Reserved_31_31_MASK                        0x80000000

/// SMUx0B_x84D0
typedef union {
  struct {                                                              ///<
    UINT32                                           FstateDivTol_5:7 ; ///<
    UINT32                                             Reserved_7_7:1 ; ///<
    UINT32                                           FstateDivTol_4:7 ; ///<
    UINT32                                           Reserved_15_15:1 ; ///<
    UINT32                                           FstateDivTol_3:7 ; ///<
    UINT32                                           Reserved_23_23:1 ; ///<
    UINT32                                           FstateDivTol_2:7 ; ///<
    UINT32                                           Reserved_31_31:1 ; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} SMUx0B_x84D0_STRUCT;

// **** SMUx0B_x84D4 Register Definition ****
// Address
#define SMUx0B_x84D4_ADDRESS                                    0x84d4

// Type
#define SMUx0B_x84D4_TYPE                                       TYPE_SMUx0B
// Field Data
#define SMUx0B_x84D4_FstateDivTol_9_OFFSET                      0
#define SMUx0B_x84D4_FstateDivTol_9_WIDTH                       7
#define SMUx0B_x84D4_FstateDivTol_9_MASK                        0x7f
#define SMUx0B_x84D4_Reserved_7_7_OFFSET                        7
#define SMUx0B_x84D4_Reserved_7_7_WIDTH                         1
#define SMUx0B_x84D4_Reserved_7_7_MASK                          0x80
#define SMUx0B_x84D4_FstateDivTol_8_OFFSET                      8
#define SMUx0B_x84D4_FstateDivTol_8_WIDTH                       7
#define SMUx0B_x84D4_FstateDivTol_8_MASK                        0x7f00
#define SMUx0B_x84D4_Reserved_15_15_OFFSET                      15
#define SMUx0B_x84D4_Reserved_15_15_WIDTH                       1
#define SMUx0B_x84D4_Reserved_15_15_MASK                        0x8000
#define SMUx0B_x84D4_FstateDivTol_7_OFFSET                      16
#define SMUx0B_x84D4_FstateDivTol_7_WIDTH                       7
#define SMUx0B_x84D4_FstateDivTol_7_MASK                        0x7f0000
#define SMUx0B_x84D4_Reserved_23_23_OFFSET                      23
#define SMUx0B_x84D4_Reserved_23_23_WIDTH                       1
#define SMUx0B_x84D4_Reserved_23_23_MASK                        0x800000
#define SMUx0B_x84D4_FstateDivTol_6_OFFSET                      24
#define SMUx0B_x84D4_FstateDivTol_6_WIDTH                       7
#define SMUx0B_x84D4_FstateDivTol_6_MASK                        0x7f000000
#define SMUx0B_x84D4_Reserved_31_31_OFFSET                      31
#define SMUx0B_x84D4_Reserved_31_31_WIDTH                       1
#define SMUx0B_x84D4_Reserved_31_31_MASK                        0x80000000

/// SMUx0B_x84D4
typedef union {
  struct {                                                              ///<
    UINT32                                           FstateDivTol_9:7 ; ///<
    UINT32                                             Reserved_7_7:1 ; ///<
    UINT32                                           FstateDivTol_8:7 ; ///<
    UINT32                                           Reserved_15_15:1 ; ///<
    UINT32                                           FstateDivTol_7:7 ; ///<
    UINT32                                           Reserved_23_23:1 ; ///<
    UINT32                                           FstateDivTol_6:7 ; ///<
    UINT32                                           Reserved_31_31:1 ; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} SMUx0B_x84D4_STRUCT;

// **** SMUx0B_x84E0 Register Definition ****
// Address
#define SMUx0B_x84E0_ADDRESS                                    0x84e0

// Type
#define SMUx0B_x84E0_TYPE                                       TYPE_SMUx0B
// Field Data
#define SMUx0B_x84E0_Reserved_6_0_OFFSET                        0
#define SMUx0B_x84E0_Reserved_6_0_WIDTH                         7
#define SMUx0B_x84E0_Reserved_6_0_MASK                          0x7f
#define SMUx0B_x84E0_Reserved_7_7_OFFSET                        7
#define SMUx0B_x84E0_Reserved_7_7_WIDTH                         1
#define SMUx0B_x84E0_Reserved_7_7_MASK                          0x80
#define SMUx0B_x84E0_Reserved_14_8_OFFSET                       8
#define SMUx0B_x84E0_Reserved_14_8_WIDTH                        7
#define SMUx0B_x84E0_Reserved_14_8_MASK                         0x7f00
#define SMUx0B_x84E0_Reserved_15_15_OFFSET                      15
#define SMUx0B_x84E0_Reserved_15_15_WIDTH                       1
#define SMUx0B_x84E0_Reserved_15_15_MASK                        0x8000
#define SMUx0B_x84E0_BaseDiv_9_OFFSET                           16
#define SMUx0B_x84E0_BaseDiv_9_WIDTH                            7
#define SMUx0B_x84E0_BaseDiv_9_MASK                             0x7f0000
#define SMUx0B_x84E0_Reserved_23_23_OFFSET                      23
#define SMUx0B_x84E0_Reserved_23_23_WIDTH                       1
#define SMUx0B_x84E0_Reserved_23_23_MASK                        0x800000
#define SMUx0B_x84E0_BaseDiv_8_OFFSET                           24
#define SMUx0B_x84E0_BaseDiv_8_WIDTH                            7
#define SMUx0B_x84E0_BaseDiv_8_MASK                             0x7f000000
#define SMUx0B_x84E0_Reserved_31_31_OFFSET                      31
#define SMUx0B_x84E0_Reserved_31_31_WIDTH                       1
#define SMUx0B_x84E0_Reserved_31_31_MASK                        0x80000000

/// SMUx0B_x84E0
typedef union {
  struct {                                                              ///<
    UINT32                                             Reserved_6_0:7 ; ///<
    UINT32                                             Reserved_7_7:1 ; ///<
    UINT32                                            Reserved_14_8:7 ; ///<
    UINT32                                           Reserved_15_15:1 ; ///<
    UINT32                                                BaseDiv_9:7 ; ///<
    UINT32                                           Reserved_23_23:1 ; ///<
    UINT32                                                BaseDiv_8:7 ; ///<
    UINT32                                           Reserved_31_31:1 ; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} SMUx0B_x84E0_STRUCT;

// **** SMUx0B_x84EC Register Definition ****
// Address
#define SMUx0B_x84EC_ADDRESS                                    0x84ec

// Type
#define SMUx0B_x84EC_TYPE                                       TYPE_SMUx0B
// Field Data
#define SMUx0B_x84EC_SaveStateDone_OFFSET                       0
#define SMUx0B_x84EC_SaveStateDone_WIDTH                        1
#define SMUx0B_x84EC_SaveStateDone_MASK                         0x1
#define SMUx0B_x84EC_Reserved_31_1_OFFSET                       1
#define SMUx0B_x84EC_Reserved_31_1_WIDTH                        31
#define SMUx0B_x84EC_Reserved_31_1_MASK                         0xfffffffe

/// SMUx0B_x84EC
typedef union {
  struct {                                                              ///<
    UINT32                                            SaveStateDone:1 ; ///<
    UINT32                                            Reserved_31_1:31; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} SMUx0B_x84EC_STRUCT;

// **** SMUx0B_x8580 Register Definition ****
// Address
#define SMUx0B_x8580_ADDRESS                                    0x8580

// Type
#define SMUx0B_x8580_TYPE                                       TYPE_SMUx0B
// Field Data
#define SMUx0B_x8580_PdmEn_OFFSET                               0
#define SMUx0B_x8580_PdmEn_WIDTH                                1
#define SMUx0B_x8580_PdmEn_MASK                                 0x1
#define SMUx0B_x8580_Reserved_9_1_OFFSET                        1
#define SMUx0B_x8580_Reserved_9_1_WIDTH                         9
#define SMUx0B_x8580_Reserved_9_1_MASK                          0x3fe
#define SMUx0B_x8580_PdmCacEn_OFFSET                            10
#define SMUx0B_x8580_PdmCacEn_WIDTH                             1
#define SMUx0B_x8580_PdmCacEn_MASK                              0x400
#define SMUx0B_x8580_Reserved_11_11_OFFSET                      11
#define SMUx0B_x8580_Reserved_11_11_WIDTH                       1
#define SMUx0B_x8580_Reserved_11_11_MASK                        0x800
#define SMUx0B_x8580_PdmUnit_OFFSET                             12
#define SMUx0B_x8580_PdmUnit_WIDTH                              4
#define SMUx0B_x8580_PdmUnit_MASK                               0xf000
#define SMUx0B_x8580_PdmPeriod_OFFSET                           16
#define SMUx0B_x8580_PdmPeriod_WIDTH                            16
#define SMUx0B_x8580_PdmPeriod_MASK                             0xffff0000

/// SMUx0B_x8580
typedef union {
  struct {                                                              ///<
    UINT32                                                    PdmEn:1 ; ///<
    UINT32                                             Reserved_9_1:9 ; ///<
    UINT32                                                 PdmCacEn:1 ; ///<
    UINT32                                           Reserved_11_11:1 ; ///<
    UINT32                                                  PdmUnit:4 ; ///<
    UINT32                                                PdmPeriod:16; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} SMUx0B_x8580_STRUCT;

// **** SMUx0B_x858C Register Definition ****
// Address
#define SMUx0B_x858C_ADDRESS                                    0x858c

// Type
#define SMUx0B_x858C_TYPE                                       TYPE_SMUx0B
// Field Data
#define SMUx0B_x858C_Rx_OFFSET                                  0
#define SMUx0B_x858C_Rx_WIDTH                                   1
#define SMUx0B_x858C_Rx_MASK                                    0x1
#define SMUx0B_x858C_Tx_OFFSET                                  1
#define SMUx0B_x858C_Tx_WIDTH                                   1
#define SMUx0B_x858C_Tx_MASK                                    0x2
#define SMUx0B_x858C_Core_OFFSET                                2
#define SMUx0B_x858C_Core_WIDTH                                 1
#define SMUx0B_x858C_Core_MASK                                  0x4
#define SMUx0B_x858C_Reserved_15_3_OFFSET                       3
#define SMUx0B_x858C_Reserved_15_3_WIDTH                        13
#define SMUx0B_x858C_Reserved_15_3_MASK                         0xfff8
#define SMUx0B_x858C_LowerLaneId_OFFSET                         16
#define SMUx0B_x858C_LowerLaneId_WIDTH                          8
#define SMUx0B_x858C_LowerLaneId_MASK                           0xff0000
#define SMUx0B_x858C_UpperLaneId_OFFSET                         24
#define SMUx0B_x858C_UpperLaneId_WIDTH                          8
#define SMUx0B_x858C_UpperLaneId_MASK                           0xff000000

/// SMUx0B_x858C
typedef union {
  struct {                                                              ///<
    UINT32                                                       Rx:1 ; ///<
    UINT32                                                       Tx:1 ; ///<
    UINT32                                                     Core:1 ; ///<
    UINT32                                            Reserved_15_3:13; ///<
    UINT32                                              LowerLaneId:8 ; ///<
    UINT32                                              UpperLaneId:8 ; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} SMUx0B_x858C_STRUCT;

// **** SMUx0B_x859C Register Definition ****
// Address
#define SMUx0B_x859C_ADDRESS                                    0x859c

// Type
#define SMUx0B_x859C_TYPE                                       TYPE_SMUx0B
// Field Data
#define SMUx0B_x859C_PllId_OFFSET                               0
#define SMUx0B_x859C_PllId_WIDTH                                1
#define SMUx0B_x859C_PllId_MASK                                 0x1
#define SMUx0B_x859C_Reserved_31_1_OFFSET                       1
#define SMUx0B_x859C_Reserved_31_1_WIDTH                        31
#define SMUx0B_x859C_Reserved_31_1_MASK                         0xfffffffe

/// SMUx0B_x859C
typedef union {
  struct {                                                              ///<
    UINT32                                                    PllId:1 ; ///<
    UINT32                                            Reserved_31_1:31; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} SMUx0B_x859C_STRUCT;

// **** SMUx0B_x8600 Register Definition ****
// Address
#define SMUx0B_x8600_ADDRESS                                    0x8600

// Type
#define SMUx0B_x8600_TYPE                                       TYPE_SMUx0B
// Field Data
#define SMUx0B_x8600_Txn1MBusAddr_7_0__OFFSET                   0
#define SMUx0B_x8600_Txn1MBusAddr_7_0__WIDTH                    8
#define SMUx0B_x8600_Txn1MBusAddr_7_0__MASK                     0xff
#define SMUx0B_x8600_MemAddr_7_0__OFFSET                        8
#define SMUx0B_x8600_MemAddr_7_0__WIDTH                         8
#define SMUx0B_x8600_MemAddr_7_0__MASK                          0xff00
#define SMUx0B_x8600_MemAddr_15_8__OFFSET                       16
#define SMUx0B_x8600_MemAddr_15_8__WIDTH                        8
#define SMUx0B_x8600_MemAddr_15_8__MASK                         0xff0000
#define SMUx0B_x8600_TransactionCount_OFFSET                    24
#define SMUx0B_x8600_TransactionCount_WIDTH                     8
#define SMUx0B_x8600_TransactionCount_MASK                      0xff000000

/// SMUx0B_x8600
typedef union {
  struct {                                                              ///<
    UINT32                                        Txn1MBusAddr_7_0_:8 ; ///<
    UINT32                                             MemAddr_7_0_:8 ; ///<
    UINT32                                            MemAddr_15_8_:8 ; ///<
    UINT32                                         TransactionCount:8 ; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} SMUx0B_x8600_STRUCT;

// **** SMUx0B_x8604 Register Definition ****
// Address
#define SMUx0B_x8604_ADDRESS                                    0x8604

// Type
#define SMUx0B_x8604_TYPE                                       TYPE_SMUx0B
// Field Data
#define SMUx0B_x8604_Txn1TransferLength_7_0__OFFSET             0
#define SMUx0B_x8604_Txn1TransferLength_7_0__WIDTH              8
#define SMUx0B_x8604_Txn1TransferLength_7_0__MASK               0xff
#define SMUx0B_x8604_Txn1MBusAddr_31_24__OFFSET                 8
#define SMUx0B_x8604_Txn1MBusAddr_31_24__WIDTH                  8
#define SMUx0B_x8604_Txn1MBusAddr_31_24__MASK                   0xff00
#define SMUx0B_x8604_Txn1MBusAddr_23_16__OFFSET                 16
#define SMUx0B_x8604_Txn1MBusAddr_23_16__WIDTH                  8
#define SMUx0B_x8604_Txn1MBusAddr_23_16__MASK                   0xff0000
#define SMUx0B_x8604_Txn1MBusAddr_15_8__OFFSET                  24
#define SMUx0B_x8604_Txn1MBusAddr_15_8__WIDTH                   8
#define SMUx0B_x8604_Txn1MBusAddr_15_8__MASK                    0xff000000

/// SMUx0B_x8604
typedef union {
  struct {                                                              ///<
    UINT32                                  Txn1TransferLength_7_0_:8 ; ///<
    UINT32                                      Txn1MBusAddr_31_24_:8 ; ///<
    UINT32                                      Txn1MBusAddr_23_16_:8 ; ///<
    UINT32                                       Txn1MBusAddr_15_8_:8 ; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} SMUx0B_x8604_STRUCT;

// **** SMUx0B_x8608 Register Definition ****
// Address
#define SMUx0B_x8608_ADDRESS                                    0x8608

// Type
#define SMUx0B_x8608_TYPE                                       TYPE_SMUx0B
// Field Data
#define SMUx0B_x8608_Txn2Mbusaddr158_OFFSET                     0
#define SMUx0B_x8608_Txn2Mbusaddr158_WIDTH                      8
#define SMUx0B_x8608_Txn2Mbusaddr158_MASK                       0xff
#define SMUx0B_x8608_Txn2Mbusaddr70_OFFSET                      8
#define SMUx0B_x8608_Txn2Mbusaddr70_WIDTH                       8
#define SMUx0B_x8608_Txn2Mbusaddr70_MASK                        0xff00
#define SMUx0B_x8608_Txn1Mode_OFFSET                            16
#define SMUx0B_x8608_Txn1Mode_WIDTH                             2
#define SMUx0B_x8608_Txn1Mode_MASK                              0x30000
#define SMUx0B_x8608_Txn1Static_OFFSET                          18
#define SMUx0B_x8608_Txn1Static_WIDTH                           1
#define SMUx0B_x8608_Txn1Static_MASK                            0x40000
#define SMUx0B_x8608_Txn1Overlap_OFFSET                         19
#define SMUx0B_x8608_Txn1Overlap_WIDTH                          1
#define SMUx0B_x8608_Txn1Overlap_MASK                           0x80000
#define SMUx0B_x8608_Txn1Spare_OFFSET                           20
#define SMUx0B_x8608_Txn1Spare_WIDTH                            4
#define SMUx0B_x8608_Txn1Spare_MASK                             0xf00000
#define SMUx0B_x8608_Txn1TransferLength_13_8__OFFSET            24
#define SMUx0B_x8608_Txn1TransferLength_13_8__WIDTH             6
#define SMUx0B_x8608_Txn1TransferLength_13_8__MASK              0x3f000000
#define SMUx0B_x8608_Txn1Tsize_OFFSET                           30
#define SMUx0B_x8608_Txn1Tsize_WIDTH                            2
#define SMUx0B_x8608_Txn1Tsize_MASK                             0xc0000000

/// SMUx0B_x8608
typedef union {
  struct {                                                              ///<
    UINT32                                          Txn2Mbusaddr158:8 ; ///<
    UINT32                                           Txn2Mbusaddr70:8 ; ///<
    UINT32                                                 Txn1Mode:2 ; ///<
    UINT32                                               Txn1Static:1 ; ///<
    UINT32                                              Txn1Overlap:1 ; ///<
    UINT32                                                Txn1Spare:4 ; ///<
    UINT32                                 Txn1TransferLength_13_8_:6 ; ///<
    UINT32                                                Txn1Tsize:2 ; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} SMUx0B_x8608_STRUCT;

// **** SMUx0B_x860C Register Definition ****
// Address
#define SMUx0B_x860C_ADDRESS                                    0x860c

// Type
#define SMUx0B_x860C_TYPE                                       TYPE_SMUx0B
// Field Data
#define SMUx0B_x860C_Txn2TransferLength138_OFFSET               0
#define SMUx0B_x860C_Txn2TransferLength138_WIDTH                6
#define SMUx0B_x860C_Txn2TransferLength138_MASK                 0x3f
#define SMUx0B_x860C_Txn2Tsize_OFFSET                           6
#define SMUx0B_x860C_Txn2Tsize_WIDTH                            2
#define SMUx0B_x860C_Txn2Tsize_MASK                             0xc0
#define SMUx0B_x860C_Txn2TransferLength70_OFFSET                8
#define SMUx0B_x860C_Txn2TransferLength70_WIDTH                 8
#define SMUx0B_x860C_Txn2TransferLength70_MASK                  0xff00
#define SMUx0B_x860C_Txn2MBusAddr3124_OFFSET                    16
#define SMUx0B_x860C_Txn2MBusAddr3124_WIDTH                     8
#define SMUx0B_x860C_Txn2MBusAddr3124_MASK                      0xff0000
#define SMUx0B_x860C_Txn2MBusAddr2316_OFFSET                    24
#define SMUx0B_x860C_Txn2MBusAddr2316_WIDTH                     8
#define SMUx0B_x860C_Txn2MBusAddr2316_MASK                      0xff000000

/// SMUx0B_x860C
typedef union {
  struct {                                                              ///<
    UINT32                                    Txn2TransferLength138:6 ; ///<
    UINT32                                                Txn2Tsize:2 ; ///<
    UINT32                                     Txn2TransferLength70:8 ; ///<
    UINT32                                         Txn2MBusAddr3124:8 ; ///<
    UINT32                                         Txn2MBusAddr2316:8 ; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} SMUx0B_x860C_STRUCT;

// **** SMUx0B_x8610 Register Definition ****
// Address
#define SMUx0B_x8610_ADDRESS                                    0x8610

// Type
#define SMUx0B_x8610_TYPE                                       TYPE_SMUx0B
// Field Data
#define SMUx0B_x8610_Txn3MBusAddr2316_OFFSET                    0
#define SMUx0B_x8610_Txn3MBusAddr2316_WIDTH                     8
#define SMUx0B_x8610_Txn3MBusAddr2316_MASK                      0xff
#define SMUx0B_x8610_Txn3MBusAddr158_OFFSET                     8
#define SMUx0B_x8610_Txn3MBusAddr158_WIDTH                      8
#define SMUx0B_x8610_Txn3MBusAddr158_MASK                       0xff00
#define SMUx0B_x8610_Txn3MBusAddr70_OFFSET                      16
#define SMUx0B_x8610_Txn3MBusAddr70_WIDTH                       8
#define SMUx0B_x8610_Txn3MBusAddr70_MASK                        0xff0000
#define SMUx0B_x8610_Txn2Mode_OFFSET                            24
#define SMUx0B_x8610_Txn2Mode_WIDTH                             2
#define SMUx0B_x8610_Txn2Mode_MASK                              0x3000000
#define SMUx0B_x8610_Txn2Static_OFFSET                          26
#define SMUx0B_x8610_Txn2Static_WIDTH                           1
#define SMUx0B_x8610_Txn2Static_MASK                            0x4000000
#define SMUx0B_x8610_Txn2Overlap_OFFSET                         27
#define SMUx0B_x8610_Txn2Overlap_WIDTH                          1
#define SMUx0B_x8610_Txn2Overlap_MASK                           0x8000000
#define SMUx0B_x8610_Txn2Spare_OFFSET                           28
#define SMUx0B_x8610_Txn2Spare_WIDTH                            4
#define SMUx0B_x8610_Txn2Spare_MASK                             0xf0000000

/// SMUx0B_x8610
typedef union {
  struct {                                                              ///<
    UINT32                                         Txn3MBusAddr2316:8 ; ///<
    UINT32                                          Txn3MBusAddr158:8 ; ///<
    UINT32                                           Txn3MBusAddr70:8 ; ///<
    UINT32                                                 Txn2Mode:2 ; ///<
    UINT32                                               Txn2Static:1 ; ///<
    UINT32                                              Txn2Overlap:1 ; ///<
    UINT32                                                Txn2Spare:4 ; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} SMUx0B_x8610_STRUCT;

// **** SMUx0B_x8614 Register Definition ****
// Address
#define SMUx0B_x8614_ADDRESS                                    0x8614

// Type
#define SMUx0B_x8614_TYPE                                       TYPE_SMUx0B
// Field Data
#define SMUx0B_x8614_Txn3Mode_OFFSET                            0
#define SMUx0B_x8614_Txn3Mode_WIDTH                             2
#define SMUx0B_x8614_Txn3Mode_MASK                              0x3
#define SMUx0B_x8614_Txn3Static_OFFSET                          2
#define SMUx0B_x8614_Txn3Static_WIDTH                           1
#define SMUx0B_x8614_Txn3Static_MASK                            0x4
#define SMUx0B_x8614_Txn3Overlap_OFFSET                         3
#define SMUx0B_x8614_Txn3Overlap_WIDTH                          1
#define SMUx0B_x8614_Txn3Overlap_MASK                           0x8
#define SMUx0B_x8614_Txn3Spare_OFFSET                           4
#define SMUx0B_x8614_Txn3Spare_WIDTH                            4
#define SMUx0B_x8614_Txn3Spare_MASK                             0xf0
#define SMUx0B_x8614_Txn3TransferLength138_OFFSET               8
#define SMUx0B_x8614_Txn3TransferLength138_WIDTH                6
#define SMUx0B_x8614_Txn3TransferLength138_MASK                 0x3f00
#define SMUx0B_x8614_Txn3Tsize_OFFSET                           14
#define SMUx0B_x8614_Txn3Tsize_WIDTH                            2
#define SMUx0B_x8614_Txn3Tsize_MASK                             0xc000
#define SMUx0B_x8614_Txn3TransferLength70_OFFSET                16
#define SMUx0B_x8614_Txn3TransferLength70_WIDTH                 8
#define SMUx0B_x8614_Txn3TransferLength70_MASK                  0xff0000
#define SMUx0B_x8614_Txn3MBusAddr3124_OFFSET                    24
#define SMUx0B_x8614_Txn3MBusAddr3124_WIDTH                     8
#define SMUx0B_x8614_Txn3MBusAddr3124_MASK                      0xff000000

/// SMUx0B_x8614
typedef union {
  struct {                                                              ///<
    UINT32                                                 Txn3Mode:2 ; ///<
    UINT32                                               Txn3Static:1 ; ///<
    UINT32                                              Txn3Overlap:1 ; ///<
    UINT32                                                Txn3Spare:4 ; ///<
    UINT32                                    Txn3TransferLength138:6 ; ///<
    UINT32                                                Txn3Tsize:2 ; ///<
    UINT32                                     Txn3TransferLength70:8 ; ///<
    UINT32                                         Txn3MBusAddr3124:8 ; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} SMUx0B_x8614_STRUCT;

// **** SMUx0B_x8618 Register Definition ****
// Address
#define SMUx0B_x8618_ADDRESS                                    0x8618

// Type
#define SMUx0B_x8618_TYPE                                       TYPE_SMUx0B
// Field Data
#define SMUx0B_x8618_Txn4MBusAddr3124_OFFSET                    0
#define SMUx0B_x8618_Txn4MBusAddr3124_WIDTH                     8
#define SMUx0B_x8618_Txn4MBusAddr3124_MASK                      0xff
#define SMUx0B_x8618_Txn4MBusAddr2316_OFFSET                    8
#define SMUx0B_x8618_Txn4MBusAddr2316_WIDTH                     8
#define SMUx0B_x8618_Txn4MBusAddr2316_MASK                      0xff00
#define SMUx0B_x8618_Txn4MBusAddr158_OFFSET                     16
#define SMUx0B_x8618_Txn4MBusAddr158_WIDTH                      8
#define SMUx0B_x8618_Txn4MBusAddr158_MASK                       0xff0000
#define SMUx0B_x8618_Txn4MBusAddr70_OFFSET                      24
#define SMUx0B_x8618_Txn4MBusAddr70_WIDTH                       8
#define SMUx0B_x8618_Txn4MBusAddr70_MASK                        0xff000000

/// SMUx0B_x8618
typedef union {
  struct {                                                              ///<
    UINT32                                         Txn4MBusAddr3124:8 ; ///<
    UINT32                                         Txn4MBusAddr2316:8 ; ///<
    UINT32                                          Txn4MBusAddr158:8 ; ///<
    UINT32                                           Txn4MBusAddr70:8 ; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} SMUx0B_x8618_STRUCT;

// **** SMUx0B_x861C Register Definition ****
// Address
#define SMUx0B_x861C_ADDRESS                                    0x861c

// Type
#define SMUx0B_x861C_TYPE                                       TYPE_SMUx0B
// Field Data
#define SMUx0B_x861C_Txn5Mbusaddr70_OFFSET                      0
#define SMUx0B_x861C_Txn5Mbusaddr70_WIDTH                       8
#define SMUx0B_x861C_Txn5Mbusaddr70_MASK                        0xff
#define SMUx0B_x861C_Txn4Mode_OFFSET                            8
#define SMUx0B_x861C_Txn4Mode_WIDTH                             2
#define SMUx0B_x861C_Txn4Mode_MASK                              0x300
#define SMUx0B_x861C_Txn4Static_OFFSET                          10
#define SMUx0B_x861C_Txn4Static_WIDTH                           1
#define SMUx0B_x861C_Txn4Static_MASK                            0x400
#define SMUx0B_x861C_Txn4Overlap_OFFSET                         11
#define SMUx0B_x861C_Txn4Overlap_WIDTH                          1
#define SMUx0B_x861C_Txn4Overlap_MASK                           0x800
#define SMUx0B_x861C_Txn4Spare_OFFSET                           12
#define SMUx0B_x861C_Txn4Spare_WIDTH                            4
#define SMUx0B_x861C_Txn4Spare_MASK                             0xf000
#define SMUx0B_x861C_Txn4TransferLength138_OFFSET               16
#define SMUx0B_x861C_Txn4TransferLength138_WIDTH                6
#define SMUx0B_x861C_Txn4TransferLength138_MASK                 0x3f0000
#define SMUx0B_x861C_Txn4Tsize_OFFSET                           22
#define SMUx0B_x861C_Txn4Tsize_WIDTH                            2
#define SMUx0B_x861C_Txn4Tsize_MASK                             0xc00000
#define SMUx0B_x861C_Txn4TransferLength70_OFFSET                24
#define SMUx0B_x861C_Txn4TransferLength70_WIDTH                 8
#define SMUx0B_x861C_Txn4TransferLength70_MASK                  0xff000000

/// SMUx0B_x861C
typedef union {
  struct {                                                              ///<
    UINT32                                           Txn5Mbusaddr70:8 ; ///<
    UINT32                                                 Txn4Mode:2 ; ///<
    UINT32                                               Txn4Static:1 ; ///<
    UINT32                                              Txn4Overlap:1 ; ///<
    UINT32                                                Txn4Spare:4 ; ///<
    UINT32                                    Txn4TransferLength138:6 ; ///<
    UINT32                                                Txn4Tsize:2 ; ///<
    UINT32                                     Txn4TransferLength70:8 ; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} SMUx0B_x861C_STRUCT;

// **** SMUx0B_x8620 Register Definition ****
// Address
#define SMUx0B_x8620_ADDRESS                                    0x8620

// Type
#define SMUx0B_x8620_TYPE                                       TYPE_SMUx0B
// Field Data
#define SMUx0B_x8620_Txn5TransferLength70_OFFSET                0
#define SMUx0B_x8620_Txn5TransferLength70_WIDTH                 8
#define SMUx0B_x8620_Txn5TransferLength70_MASK                  0xff
#define SMUx0B_x8620_Txn5MBusAddr3124_OFFSET                    8
#define SMUx0B_x8620_Txn5MBusAddr3124_WIDTH                     8
#define SMUx0B_x8620_Txn5MBusAddr3124_MASK                      0xff00
#define SMUx0B_x8620_Txn5MBusAddr2316_OFFSET                    16
#define SMUx0B_x8620_Txn5MBusAddr2316_WIDTH                     8
#define SMUx0B_x8620_Txn5MBusAddr2316_MASK                      0xff0000
#define SMUx0B_x8620_Txn5MBusAddr158_OFFSET                     24
#define SMUx0B_x8620_Txn5MBusAddr158_WIDTH                      8
#define SMUx0B_x8620_Txn5MBusAddr158_MASK                       0xff000000

/// SMUx0B_x8620
typedef union {
  struct {                                                              ///<
    UINT32                                     Txn5TransferLength70:8 ; ///<
    UINT32                                         Txn5MBusAddr3124:8 ; ///<
    UINT32                                         Txn5MBusAddr2316:8 ; ///<
    UINT32                                          Txn5MBusAddr158:8 ; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} SMUx0B_x8620_STRUCT;

// **** SMUx0B_x8624 Register Definition ****
// Address
#define SMUx0B_x8624_ADDRESS                                    0x8624

// Type
#define SMUx0B_x8624_TYPE                                       TYPE_SMUx0B
// Field Data
#define SMUx0B_x8624_Txn6MBusAddr158_OFFSET                     0
#define SMUx0B_x8624_Txn6MBusAddr158_WIDTH                      8
#define SMUx0B_x8624_Txn6MBusAddr158_MASK                       0xff
#define SMUx0B_x8624_Txn6MBusAddr70_OFFSET                      8
#define SMUx0B_x8624_Txn6MBusAddr70_WIDTH                       8
#define SMUx0B_x8624_Txn6MBusAddr70_MASK                        0xff00
#define SMUx0B_x8624_Txn5Mode_OFFSET                            16
#define SMUx0B_x8624_Txn5Mode_WIDTH                             2
#define SMUx0B_x8624_Txn5Mode_MASK                              0x30000
#define SMUx0B_x8624_Txn5Static_OFFSET                          18
#define SMUx0B_x8624_Txn5Static_WIDTH                           1
#define SMUx0B_x8624_Txn5Static_MASK                            0x40000
#define SMUx0B_x8624_Txn5Overlap_OFFSET                         19
#define SMUx0B_x8624_Txn5Overlap_WIDTH                          1
#define SMUx0B_x8624_Txn5Overlap_MASK                           0x80000
#define SMUx0B_x8624_Txn5Spare_OFFSET                           20
#define SMUx0B_x8624_Txn5Spare_WIDTH                            4
#define SMUx0B_x8624_Txn5Spare_MASK                             0xf00000
#define SMUx0B_x8624_Txn5TransferLength138_OFFSET               24
#define SMUx0B_x8624_Txn5TransferLength138_WIDTH                6
#define SMUx0B_x8624_Txn5TransferLength138_MASK                 0x3f000000
#define SMUx0B_x8624_Txn5Tsize_OFFSET                           30
#define SMUx0B_x8624_Txn5Tsize_WIDTH                            2
#define SMUx0B_x8624_Txn5Tsize_MASK                             0xc0000000

/// SMUx0B_x8624
typedef union {
  struct {                                                              ///<
    UINT32                                          Txn6MBusAddr158:8 ; ///<
    UINT32                                           Txn6MBusAddr70:8 ; ///<
    UINT32                                                 Txn5Mode:2 ; ///<
    UINT32                                               Txn5Static:1 ; ///<
    UINT32                                              Txn5Overlap:1 ; ///<
    UINT32                                                Txn5Spare:4 ; ///<
    UINT32                                    Txn5TransferLength138:6 ; ///<
    UINT32                                                Txn5Tsize:2 ; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} SMUx0B_x8624_STRUCT;

// **** SMUx0B_x8628 Register Definition ****
// Address
#define SMUx0B_x8628_ADDRESS                                    0x8628

// Type
#define SMUx0B_x8628_TYPE                                       TYPE_SMUx0B
// Field Data
#define SMUx0B_x8628_Txn6TransferLength138_OFFSET               0
#define SMUx0B_x8628_Txn6TransferLength138_WIDTH                6
#define SMUx0B_x8628_Txn6TransferLength138_MASK                 0x3f
#define SMUx0B_x8628_Txn6Tsize_OFFSET                           6
#define SMUx0B_x8628_Txn6Tsize_WIDTH                            2
#define SMUx0B_x8628_Txn6Tsize_MASK                             0xc0
#define SMUx0B_x8628_Txn6TransferLength70_OFFSET                8
#define SMUx0B_x8628_Txn6TransferLength70_WIDTH                 8
#define SMUx0B_x8628_Txn6TransferLength70_MASK                  0xff00
#define SMUx0B_x8628_Txn6MBusAddr3124_OFFSET                    16
#define SMUx0B_x8628_Txn6MBusAddr3124_WIDTH                     8
#define SMUx0B_x8628_Txn6MBusAddr3124_MASK                      0xff0000
#define SMUx0B_x8628_Txn6MBusAddr2316_OFFSET                    24
#define SMUx0B_x8628_Txn6MBusAddr2316_WIDTH                     8
#define SMUx0B_x8628_Txn6MBusAddr2316_MASK                      0xff000000

/// SMUx0B_x8628
typedef union {
  struct {                                                              ///<
    UINT32                                    Txn6TransferLength138:6 ; ///<
    UINT32                                                Txn6Tsize:2 ; ///<
    UINT32                                     Txn6TransferLength70:8 ; ///<
    UINT32                                         Txn6MBusAddr3124:8 ; ///<
    UINT32                                         Txn6MBusAddr2316:8 ; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} SMUx0B_x8628_STRUCT;

// **** SMUx0B_x862C Register Definition ****
// Address
#define SMUx0B_x862C_ADDRESS                                    0x862c

// Type
#define SMUx0B_x862C_TYPE                                       TYPE_SMUx0B
// Field Data
#define SMUx0B_x862C_Txn7MBusAddr2316_OFFSET                    0
#define SMUx0B_x862C_Txn7MBusAddr2316_WIDTH                     8
#define SMUx0B_x862C_Txn7MBusAddr2316_MASK                      0xff
#define SMUx0B_x862C_Txn7MBusAddr158_OFFSET                     8
#define SMUx0B_x862C_Txn7MBusAddr158_WIDTH                      8
#define SMUx0B_x862C_Txn7MBusAddr158_MASK                       0xff00
#define SMUx0B_x862C_Txn7MBusAddr70_OFFSET                      16
#define SMUx0B_x862C_Txn7MBusAddr70_WIDTH                       8
#define SMUx0B_x862C_Txn7MBusAddr70_MASK                        0xff0000
#define SMUx0B_x862C_Txn6Mode_OFFSET                            24
#define SMUx0B_x862C_Txn6Mode_WIDTH                             2
#define SMUx0B_x862C_Txn6Mode_MASK                              0x3000000
#define SMUx0B_x862C_Txn6Static_OFFSET                          26
#define SMUx0B_x862C_Txn6Static_WIDTH                           1
#define SMUx0B_x862C_Txn6Static_MASK                            0x4000000
#define SMUx0B_x862C_Txn6Overlap_OFFSET                         27
#define SMUx0B_x862C_Txn6Overlap_WIDTH                          1
#define SMUx0B_x862C_Txn6Overlap_MASK                           0x8000000
#define SMUx0B_x862C_Txn6Spare_OFFSET                           28
#define SMUx0B_x862C_Txn6Spare_WIDTH                            4
#define SMUx0B_x862C_Txn6Spare_MASK                             0xf0000000

/// SMUx0B_x862C
typedef union {
  struct {                                                              ///<
    UINT32                                         Txn7MBusAddr2316:8 ; ///<
    UINT32                                          Txn7MBusAddr158:8 ; ///<
    UINT32                                           Txn7MBusAddr70:8 ; ///<
    UINT32                                                 Txn6Mode:2 ; ///<
    UINT32                                               Txn6Static:1 ; ///<
    UINT32                                              Txn6Overlap:1 ; ///<
    UINT32                                                Txn6Spare:4 ; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} SMUx0B_x862C_STRUCT;

// **** SMUx0B_x8630 Register Definition ****
// Address
#define SMUx0B_x8630_ADDRESS                                    0x8630

// Type
#define SMUx0B_x8630_TYPE                                       TYPE_SMUx0B
// Field Data
#define SMUx0B_x8630_Txn7Mode_OFFSET                            0
#define SMUx0B_x8630_Txn7Mode_WIDTH                             2
#define SMUx0B_x8630_Txn7Mode_MASK                              0x3
#define SMUx0B_x8630_Txn7Static_OFFSET                          2
#define SMUx0B_x8630_Txn7Static_WIDTH                           1
#define SMUx0B_x8630_Txn7Static_MASK                            0x4
#define SMUx0B_x8630_Txn7Overlap_OFFSET                         3
#define SMUx0B_x8630_Txn7Overlap_WIDTH                          1
#define SMUx0B_x8630_Txn7Overlap_MASK                           0x8
#define SMUx0B_x8630_Txn7Spare_OFFSET                           4
#define SMUx0B_x8630_Txn7Spare_WIDTH                            4
#define SMUx0B_x8630_Txn7Spare_MASK                             0xf0
#define SMUx0B_x8630_Txn7TransferLength138_OFFSET               8
#define SMUx0B_x8630_Txn7TransferLength138_WIDTH                6
#define SMUx0B_x8630_Txn7TransferLength138_MASK                 0x3f00
#define SMUx0B_x8630_Txn7Tsize_OFFSET                           14
#define SMUx0B_x8630_Txn7Tsize_WIDTH                            2
#define SMUx0B_x8630_Txn7Tsize_MASK                             0xc000
#define SMUx0B_x8630_Txn7TransferLength70_OFFSET                16
#define SMUx0B_x8630_Txn7TransferLength70_WIDTH                 8
#define SMUx0B_x8630_Txn7TransferLength70_MASK                  0xff0000
#define SMUx0B_x8630_Txn7MBusAddr3124_OFFSET                    24
#define SMUx0B_x8630_Txn7MBusAddr3124_WIDTH                     8
#define SMUx0B_x8630_Txn7MBusAddr3124_MASK                      0xff000000

/// SMUx0B_x8630
typedef union {
  struct {                                                              ///<
    UINT32                                                 Txn7Mode:2 ; ///<
    UINT32                                               Txn7Static:1 ; ///<
    UINT32                                              Txn7Overlap:1 ; ///<
    UINT32                                                Txn7Spare:4 ; ///<
    UINT32                                    Txn7TransferLength138:6 ; ///<
    UINT32                                                Txn7Tsize:2 ; ///<
    UINT32                                     Txn7TransferLength70:8 ; ///<
    UINT32                                         Txn7MBusAddr3124:8 ; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} SMUx0B_x8630_STRUCT;

// **** SMUx0B_x8634 Register Definition ****
// Address
#define SMUx0B_x8634_ADDRESS                                    0x8634

// Type
#define SMUx0B_x8634_TYPE                                       TYPE_SMUx0B
// Field Data
#define SMUx0B_x8634_Txn8MBusAddr3124_OFFSET                    0
#define SMUx0B_x8634_Txn8MBusAddr3124_WIDTH                     8
#define SMUx0B_x8634_Txn8MBusAddr3124_MASK                      0xff
#define SMUx0B_x8634_Txn8MBusAddr2316_OFFSET                    8
#define SMUx0B_x8634_Txn8MBusAddr2316_WIDTH                     8
#define SMUx0B_x8634_Txn8MBusAddr2316_MASK                      0xff00
#define SMUx0B_x8634_Txn8MBusAddr158_OFFSET                     16
#define SMUx0B_x8634_Txn8MBusAddr158_WIDTH                      8
#define SMUx0B_x8634_Txn8MBusAddr158_MASK                       0xff0000
#define SMUx0B_x8634_Txn8MBusAddr70_OFFSET                      24
#define SMUx0B_x8634_Txn8MBusAddr70_WIDTH                       8
#define SMUx0B_x8634_Txn8MBusAddr70_MASK                        0xff000000

/// SMUx0B_x8634
typedef union {
  struct {                                                              ///<
    UINT32                                         Txn8MBusAddr3124:8 ; ///<
    UINT32                                         Txn8MBusAddr2316:8 ; ///<
    UINT32                                          Txn8MBusAddr158:8 ; ///<
    UINT32                                           Txn8MBusAddr70:8 ; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} SMUx0B_x8634_STRUCT;

// **** SMUx0B_x8638 Register Definition ****
// Address
#define SMUx0B_x8638_ADDRESS                                    0x8638

// Type
#define SMUx0B_x8638_TYPE                                       TYPE_SMUx0B
// Field Data
#define SMUx0B_x8638_Txn9MBusAddr70_OFFSET                      0
#define SMUx0B_x8638_Txn9MBusAddr70_WIDTH                       8
#define SMUx0B_x8638_Txn9MBusAddr70_MASK                        0xff
#define SMUx0B_x8638_Txn8Mode_OFFSET                            8
#define SMUx0B_x8638_Txn8Mode_WIDTH                             2
#define SMUx0B_x8638_Txn8Mode_MASK                              0x300
#define SMUx0B_x8638_Txn8Static_OFFSET                          10
#define SMUx0B_x8638_Txn8Static_WIDTH                           1
#define SMUx0B_x8638_Txn8Static_MASK                            0x400
#define SMUx0B_x8638_Txn8Overlap_OFFSET                         11
#define SMUx0B_x8638_Txn8Overlap_WIDTH                          1
#define SMUx0B_x8638_Txn8Overlap_MASK                           0x800
#define SMUx0B_x8638_Txn8Spare_OFFSET                           12
#define SMUx0B_x8638_Txn8Spare_WIDTH                            4
#define SMUx0B_x8638_Txn8Spare_MASK                             0xf000
#define SMUx0B_x8638_Txn8TransferLength138_OFFSET               16
#define SMUx0B_x8638_Txn8TransferLength138_WIDTH                6
#define SMUx0B_x8638_Txn8TransferLength138_MASK                 0x3f0000
#define SMUx0B_x8638_Txn8Tsize_OFFSET                           22
#define SMUx0B_x8638_Txn8Tsize_WIDTH                            2
#define SMUx0B_x8638_Txn8Tsize_MASK                             0xc00000
#define SMUx0B_x8638_Txn8TransferLength70_OFFSET                24
#define SMUx0B_x8638_Txn8TransferLength70_WIDTH                 8
#define SMUx0B_x8638_Txn8TransferLength70_MASK                  0xff000000

/// SMUx0B_x8638
typedef union {
  struct {                                                              ///<
    UINT32                                           Txn9MBusAddr70:8 ; ///<
    UINT32                                                 Txn8Mode:2 ; ///<
    UINT32                                               Txn8Static:1 ; ///<
    UINT32                                              Txn8Overlap:1 ; ///<
    UINT32                                                Txn8Spare:4 ; ///<
    UINT32                                    Txn8TransferLength138:6 ; ///<
    UINT32                                                Txn8Tsize:2 ; ///<
    UINT32                                     Txn8TransferLength70:8 ; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} SMUx0B_x8638_STRUCT;

// **** SMUx0B_x863C Register Definition ****
// Address
#define SMUx0B_x863C_ADDRESS                                    0x863c

// Type
#define SMUx0B_x863C_TYPE                                       TYPE_SMUx0B
// Field Data
#define SMUx0B_x863C_Txn9TransferLength70_OFFSET                0
#define SMUx0B_x863C_Txn9TransferLength70_WIDTH                 8
#define SMUx0B_x863C_Txn9TransferLength70_MASK                  0xff
#define SMUx0B_x863C_Txn9MBusAddr3124_OFFSET                    8
#define SMUx0B_x863C_Txn9MBusAddr3124_WIDTH                     8
#define SMUx0B_x863C_Txn9MBusAddr3124_MASK                      0xff00
#define SMUx0B_x863C_Txn9MBuAaddr2316_OFFSET                    16
#define SMUx0B_x863C_Txn9MBuAaddr2316_WIDTH                     8
#define SMUx0B_x863C_Txn9MBuAaddr2316_MASK                      0xff0000
#define SMUx0B_x863C_Txn9MBusAddr158_OFFSET                     24
#define SMUx0B_x863C_Txn9MBusAddr158_WIDTH                      8
#define SMUx0B_x863C_Txn9MBusAddr158_MASK                       0xff000000

/// SMUx0B_x863C
typedef union {
  struct {                                                              ///<
    UINT32                                     Txn9TransferLength70:8 ; ///<
    UINT32                                         Txn9MBusAddr3124:8 ; ///<
    UINT32                                         Txn9MBuAaddr2316:8 ; ///<
    UINT32                                          Txn9MBusAddr158:8 ; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} SMUx0B_x863C_STRUCT;

// **** SMUx0B_x8640 Register Definition ****
// Address
#define SMUx0B_x8640_ADDRESS                                    0x8640

// Type
#define SMUx0B_x8640_TYPE                                       TYPE_SMUx0B
// Field Data
#define SMUx0B_x8640_Txn10MBusAddr158_OFFSET                    0
#define SMUx0B_x8640_Txn10MBusAddr158_WIDTH                     8
#define SMUx0B_x8640_Txn10MBusAddr158_MASK                      0xff
#define SMUx0B_x8640_Txn10MBusAddr70_OFFSET                     8
#define SMUx0B_x8640_Txn10MBusAddr70_WIDTH                      8
#define SMUx0B_x8640_Txn10MBusAddr70_MASK                       0xff00
#define SMUx0B_x8640_Txn9Mode_OFFSET                            16
#define SMUx0B_x8640_Txn9Mode_WIDTH                             2
#define SMUx0B_x8640_Txn9Mode_MASK                              0x30000
#define SMUx0B_x8640_Txn9Static_OFFSET                          18
#define SMUx0B_x8640_Txn9Static_WIDTH                           1
#define SMUx0B_x8640_Txn9Static_MASK                            0x40000
#define SMUx0B_x8640_Txn9Overlap_OFFSET                         19
#define SMUx0B_x8640_Txn9Overlap_WIDTH                          1
#define SMUx0B_x8640_Txn9Overlap_MASK                           0x80000
#define SMUx0B_x8640_Txn9Spare_OFFSET                           20
#define SMUx0B_x8640_Txn9Spare_WIDTH                            4
#define SMUx0B_x8640_Txn9Spare_MASK                             0xf00000
#define SMUx0B_x8640_Txn9TransferLength138_OFFSET               24
#define SMUx0B_x8640_Txn9TransferLength138_WIDTH                6
#define SMUx0B_x8640_Txn9TransferLength138_MASK                 0x3f000000
#define SMUx0B_x8640_Txn9Tsize_OFFSET                           30
#define SMUx0B_x8640_Txn9Tsize_WIDTH                            2
#define SMUx0B_x8640_Txn9Tsize_MASK                             0xc0000000

/// SMUx0B_x8640
typedef union {
  struct {                                                              ///<
    UINT32                                         Txn10MBusAddr158:8 ; ///<
    UINT32                                          Txn10MBusAddr70:8 ; ///<
    UINT32                                                 Txn9Mode:2 ; ///<
    UINT32                                               Txn9Static:1 ; ///<
    UINT32                                              Txn9Overlap:1 ; ///<
    UINT32                                                Txn9Spare:4 ; ///<
    UINT32                                    Txn9TransferLength138:6 ; ///<
    UINT32                                                Txn9Tsize:2 ; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} SMUx0B_x8640_STRUCT;

// **** SMUx0B_x8650 Register Definition ****
// Address
#define SMUx0B_x8650_ADDRESS                                    0x8650

// Type
#define SMUx0B_x8650_TYPE                                       TYPE_SMUx0B
// Field Data
#define SMUx0B_x8650_Data_OFFSET                                0
#define SMUx0B_x8650_Data_WIDTH                                 32
#define SMUx0B_x8650_Data_MASK                                  0xffffffff

/// SMUx0B_x8650
typedef union {
  struct {                                                              ///<
    UINT32                                                     Data:32; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} SMUx0B_x8650_STRUCT;

// **** SMUx0B_x8654 Register Definition ****
// Address
#define SMUx0B_x8654_ADDRESS                                    0x8654

// Type
#define SMUx0B_x8654_TYPE                                       TYPE_SMUx0B
// Field Data
#define SMUx0B_x8654_Data_OFFSET                                0
#define SMUx0B_x8654_Data_WIDTH                                 32
#define SMUx0B_x8654_Data_MASK                                  0xffffffff

/// SMUx0B_x8654
typedef union {
  struct {                                                              ///<
    UINT32                                                     Data:32; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} SMUx0B_x8654_STRUCT;

// **** SMUx0B_x8658 Register Definition ****
// Address
#define SMUx0B_x8658_ADDRESS                                    0x8658

// Type
#define SMUx0B_x8658_TYPE                                       TYPE_SMUx0B
// Field Data
#define SMUx0B_x8658_Data_OFFSET                                0
#define SMUx0B_x8658_Data_WIDTH                                 32
#define SMUx0B_x8658_Data_MASK                                  0xffffffff

/// SMUx0B_x8658
typedef union {
  struct {                                                              ///<
    UINT32                                                     Data:32; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} SMUx0B_x8658_STRUCT;

// **** SMUx0B_x865C Register Definition ****
// Address
#define SMUx0B_x865C_ADDRESS                                    0x865c

// Type
#define SMUx0B_x865C_TYPE                                       TYPE_SMUx0B
// Field Data
#define SMUx0B_x865C_Data_OFFSET                                0
#define SMUx0B_x865C_Data_WIDTH                                 32
#define SMUx0B_x865C_Data_MASK                                  0xffffffff

/// SMUx0B_x865C
typedef union {
  struct {                                                              ///<
    UINT32                                                     Data:32; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} SMUx0B_x865C_STRUCT;

// **** SMUx0B_x8660 Register Definition ****
// Address
#define SMUx0B_x8660_ADDRESS                                    0x8660

// Type
#define SMUx0B_x8660_TYPE                                       TYPE_SMUx0B
// Field Data
#define SMUx0B_x8660_Data_OFFSET                                0
#define SMUx0B_x8660_Data_WIDTH                                 32
#define SMUx0B_x8660_Data_MASK                                  0xffffffff

/// SMUx0B_x8660
typedef union {
  struct {                                                              ///<
    UINT32                                                     Data:32; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} SMUx0B_x8660_STRUCT;

// **** SMUx0B_x8664 Register Definition ****
// Address
#define SMUx0B_x8664_ADDRESS                                    0x8664

// Type
#define SMUx0B_x8664_TYPE                                       TYPE_SMUx0B
// Field Data
#define SMUx0B_x8664_Data_OFFSET                                0
#define SMUx0B_x8664_Data_WIDTH                                 32
#define SMUx0B_x8664_Data_MASK                                  0xffffffff

/// SMUx0B_x8664
typedef union {
  struct {                                                              ///<
    UINT32                                                     Data:32; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} SMUx0B_x8664_STRUCT;

// **** SMUx0B_x8668 Register Definition ****
// Address
#define SMUx0B_x8668_ADDRESS                                    0x8668

// Type
#define SMUx0B_x8668_TYPE                                       TYPE_SMUx0B
// Field Data
#define SMUx0B_x8668_Data_OFFSET                                0
#define SMUx0B_x8668_Data_WIDTH                                 32
#define SMUx0B_x8668_Data_MASK                                  0xffffffff

/// SMUx0B_x8668
typedef union {
  struct {                                                              ///<
    UINT32                                                     Data:32; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} SMUx0B_x8668_STRUCT;

// **** SMUx0B_x866C Register Definition ****
// Address
#define SMUx0B_x866C_ADDRESS                                    0x866c

// Type
#define SMUx0B_x866C_TYPE                                       TYPE_SMUx0B
// Field Data
#define SMUx0B_x866C_Data_OFFSET                                0
#define SMUx0B_x866C_Data_WIDTH                                 32
#define SMUx0B_x866C_Data_MASK                                  0xffffffff

/// SMUx0B_x866C
typedef union {
  struct {                                                              ///<
    UINT32                                                     Data:32; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} SMUx0B_x866C_STRUCT;

// **** SMUx0B_x8670 Register Definition ****
// Address
#define SMUx0B_x8670_ADDRESS                                    0x8670

// Type
#define SMUx0B_x8670_TYPE                                       TYPE_SMUx0B
// Field Data
#define SMUx0B_x8670_Data_OFFSET                                0
#define SMUx0B_x8670_Data_WIDTH                                 32
#define SMUx0B_x8670_Data_MASK                                  0xffffffff

/// SMUx0B_x8670
typedef union {
  struct {                                                              ///<
    UINT32                                                     Data:32; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} SMUx0B_x8670_STRUCT;

// **** SMUx0B_x8674 Register Definition ****
// Address
#define SMUx0B_x8674_ADDRESS                                    0x8674

// Type
#define SMUx0B_x8674_TYPE                                       TYPE_SMUx0B
// Field Data
#define SMUx0B_x8674_Data_OFFSET                                0
#define SMUx0B_x8674_Data_WIDTH                                 32
#define SMUx0B_x8674_Data_MASK                                  0xffffffff

/// SMUx0B_x8674
typedef union {
  struct {                                                              ///<
    UINT32                                                     Data:32; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} SMUx0B_x8674_STRUCT;

// **** SMUx0B_x8678 Register Definition ****
// Address
#define SMUx0B_x8678_ADDRESS                                    0x8678

// Type
#define SMUx0B_x8678_TYPE                                       TYPE_SMUx0B
// Field Data
#define SMUx0B_x8678_Data_OFFSET                                0
#define SMUx0B_x8678_Data_WIDTH                                 32
#define SMUx0B_x8678_Data_MASK                                  0xffffffff

/// SMUx0B_x8678
typedef union {
  struct {                                                              ///<
    UINT32                                                     Data:32; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} SMUx0B_x8678_STRUCT;

// **** SMUx0B_x867C Register Definition ****
// Address
#define SMUx0B_x867C_ADDRESS                                    0x867c

// Type
#define SMUx0B_x867C_TYPE                                       TYPE_SMUx0B
// Field Data
#define SMUx0B_x867C_Data_OFFSET                                0
#define SMUx0B_x867C_Data_WIDTH                                 32
#define SMUx0B_x867C_Data_MASK                                  0xffffffff

/// SMUx0B_x867C
typedef union {
  struct {                                                              ///<
    UINT32                                                     Data:32; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} SMUx0B_x867C_STRUCT;

// **** SMUx0B_x8680 Register Definition ****
// Address
#define SMUx0B_x8680_ADDRESS                                    0x8680

// Type
#define SMUx0B_x8680_TYPE                                       TYPE_SMUx0B
// Field Data
#define SMUx0B_x8680_Data_OFFSET                                0
#define SMUx0B_x8680_Data_WIDTH                                 32
#define SMUx0B_x8680_Data_MASK                                  0xffffffff

/// SMUx0B_x8680
typedef union {
  struct {                                                              ///<
    UINT32                                                     Data:32; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} SMUx0B_x8680_STRUCT;

// **** SMUx0B_x8684 Register Definition ****
// Address
#define SMUx0B_x8684_ADDRESS                                    0x8684

// Type
#define SMUx0B_x8684_TYPE                                       TYPE_SMUx0B
// Field Data
#define SMUx0B_x8684_Data_OFFSET                                0
#define SMUx0B_x8684_Data_WIDTH                                 32
#define SMUx0B_x8684_Data_MASK                                  0xffffffff

/// SMUx0B_x8684
typedef union {
  struct {                                                              ///<
    UINT32                                                     Data:32; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} SMUx0B_x8684_STRUCT;

// **** SMUx0B_x8688 Register Definition ****
// Address
#define SMUx0B_x8688_ADDRESS                                    0x8688

// Type
#define SMUx0B_x8688_TYPE                                       TYPE_SMUx0B
// Field Data
#define SMUx0B_x8688_Data_OFFSET                                0
#define SMUx0B_x8688_Data_WIDTH                                 32
#define SMUx0B_x8688_Data_MASK                                  0xffffffff

/// SMUx0B_x8688
typedef union {
  struct {                                                              ///<
    UINT32                                                     Data:32; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} SMUx0B_x8688_STRUCT;

// **** SMUx0B_x868C Register Definition ****
// Address
#define SMUx0B_x868C_ADDRESS                                    0x868c

// Type
#define SMUx0B_x868C_TYPE                                       TYPE_SMUx0B
// Field Data
#define SMUx0B_x868C_Data_OFFSET                                0
#define SMUx0B_x868C_Data_WIDTH                                 32
#define SMUx0B_x868C_Data_MASK                                  0xffffffff

/// SMUx0B_x868C
typedef union {
  struct {                                                              ///<
    UINT32                                                     Data:32; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} SMUx0B_x868C_STRUCT;

// **** SMUx0B_x8690 Register Definition ****
// Address
#define SMUx0B_x8690_ADDRESS                                    0x8690

// Type
#define SMUx0B_x8690_TYPE                                       TYPE_SMUx0B
// Field Data
#define SMUx0B_x8690_Data_OFFSET                                0
#define SMUx0B_x8690_Data_WIDTH                                 32
#define SMUx0B_x8690_Data_MASK                                  0xffffffff

/// SMUx0B_x8690
typedef union {
  struct {                                                              ///<
    UINT32                                                     Data:32; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} SMUx0B_x8690_STRUCT;

// **** SMUx0B_x8694 Register Definition ****
// Address
#define SMUx0B_x8694_ADDRESS                                    0x8694

// Type
#define SMUx0B_x8694_TYPE                                       TYPE_SMUx0B
// Field Data
#define SMUx0B_x8694_Data_OFFSET                                0
#define SMUx0B_x8694_Data_WIDTH                                 32
#define SMUx0B_x8694_Data_MASK                                  0xffffffff

/// SMUx0B_x8694
typedef union {
  struct {                                                              ///<
    UINT32                                                     Data:32; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} SMUx0B_x8694_STRUCT;

// **** SMUx0B_x8698 Register Definition ****
// Address
#define SMUx0B_x8698_ADDRESS                                    0x8698

// Type
#define SMUx0B_x8698_TYPE                                       TYPE_SMUx0B
// Field Data
#define SMUx0B_x8698_Data_OFFSET                                0
#define SMUx0B_x8698_Data_WIDTH                                 32
#define SMUx0B_x8698_Data_MASK                                  0xffffffff

/// SMUx0B_x8698
typedef union {
  struct {                                                              ///<
    UINT32                                                     Data:32; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} SMUx0B_x8698_STRUCT;

// **** SMUx0B_x869C Register Definition ****
// Address
#define SMUx0B_x869C_ADDRESS                                    0x869c

// Type
#define SMUx0B_x869C_TYPE                                       TYPE_SMUx0B
// Field Data
#define SMUx0B_x869C_Data_OFFSET                                0
#define SMUx0B_x869C_Data_WIDTH                                 32
#define SMUx0B_x869C_Data_MASK                                  0xffffffff

/// SMUx0B_x869C
typedef union {
  struct {                                                              ///<
    UINT32                                                     Data:32; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} SMUx0B_x869C_STRUCT;

// **** SMUx0B_x86A0 Register Definition ****
// Address
#define SMUx0B_x86A0_ADDRESS                                    0x86a0

// Type
#define SMUx0B_x86A0_TYPE                                       TYPE_SMUx0B
// Field Data
#define SMUx0B_x86A0_Data_OFFSET                                0
#define SMUx0B_x86A0_Data_WIDTH                                 32
#define SMUx0B_x86A0_Data_MASK                                  0xffffffff

/// SMUx0B_x86A0
typedef union {
  struct {                                                              ///<
    UINT32                                                     Data:32; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} SMUx0B_x86A0_STRUCT;

// **** GMMx4D0 Register Definition ****
// Address
#define GMMx4D0_ADDRESS                                         0x4d0

// Type
#define GMMx4D0_TYPE                                            TYPE_GMM
// Field Data
#define GMMx4D0_DispclkDccgGateDisable_OFFSET                   0
#define GMMx4D0_DispclkDccgGateDisable_WIDTH                    1
#define GMMx4D0_DispclkDccgGateDisable_MASK                     0x1
#define GMMx4D0_DispclkRDccgGateDisable_OFFSET                  1
#define GMMx4D0_DispclkRDccgGateDisable_WIDTH                   1
#define GMMx4D0_DispclkRDccgGateDisable_MASK                    0x2
#define GMMx4D0_SclkGateDisable_OFFSET                          2
#define GMMx4D0_SclkGateDisable_WIDTH                           1
#define GMMx4D0_SclkGateDisable_MASK                            0x4
#define GMMx4D0_Reserved_7_3_OFFSET                             3
#define GMMx4D0_Reserved_7_3_WIDTH                              5
#define GMMx4D0_Reserved_7_3_MASK                               0xf8
#define GMMx4D0_SymclkaGateDisable_OFFSET                       8
#define GMMx4D0_SymclkaGateDisable_WIDTH                        1
#define GMMx4D0_SymclkaGateDisable_MASK                         0x100
#define GMMx4D0_SymclkbGateDisable_OFFSET                       9
#define GMMx4D0_SymclkbGateDisable_WIDTH                        1
#define GMMx4D0_SymclkbGateDisable_MASK                         0x200
#define GMMx4D0_Reserved_31_10_OFFSET                           10
#define GMMx4D0_Reserved_31_10_WIDTH                            22
#define GMMx4D0_Reserved_31_10_MASK                             0xfffffc00

/// GMMx4D0
typedef union {
  struct {                                                              ///<
    UINT32                                   DispclkDccgGateDisable:1 ; ///<
    UINT32                                  DispclkRDccgGateDisable:1 ; ///<
    UINT32                                          SclkGateDisable:1 ; ///<
    UINT32                                             Reserved_7_3:5 ; ///<
    UINT32                                       SymclkaGateDisable:1 ; ///<
    UINT32                                       SymclkbGateDisable:1 ; ///<
    UINT32                                           Reserved_31_10:22; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} GMMx4D0_STRUCT;

// **** GMMx770 Register Definition ****
// Address
#define GMMx770_ADDRESS                                         0x770

// Type
#define GMMx770_TYPE                                            TYPE_GMM
// Field Data
#define GMMx770_VoltageChangeReq_OFFSET                         0
#define GMMx770_VoltageChangeReq_WIDTH                          1
#define GMMx770_VoltageChangeReq_MASK                           0x1
#define GMMx770_VoltageLevel_OFFSET                             1
#define GMMx770_VoltageLevel_WIDTH                              2
#define GMMx770_VoltageLevel_MASK                               0x6
#define GMMx770_VoltageChangeEn_OFFSET                          3
#define GMMx770_VoltageChangeEn_WIDTH                           1
#define GMMx770_VoltageChangeEn_MASK                            0x8
#define GMMx770_VoltageForceEn_OFFSET                           4
#define GMMx770_VoltageForceEn_WIDTH                            1
#define GMMx770_VoltageForceEn_MASK                             0x10
#define GMMx770_Reserved_31_5_OFFSET                            5
#define GMMx770_Reserved_31_5_WIDTH                             27
#define GMMx770_Reserved_31_5_MASK                              0xffffffe0

/// GMMx770
typedef union {
  struct {                                                              ///<
    UINT32                                         VoltageChangeReq:1 ; ///<
    UINT32                                             VoltageLevel:2 ; ///<
    UINT32                                          VoltageChangeEn:1 ; ///<
    UINT32                                           VoltageForceEn:1 ; ///<
    UINT32                                            Reserved_31_5:27; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} GMMx770_STRUCT;

// **** GMMx774 Register Definition ****
// Address
#define GMMx774_ADDRESS                                         0x774

// Type
#define GMMx774_TYPE                                            TYPE_GMM
// Field Data
#define GMMx774_VoltageChangeAck_OFFSET                         0
#define GMMx774_VoltageChangeAck_WIDTH                          1
#define GMMx774_VoltageChangeAck_MASK                           0x1
#define GMMx774_CurrentVoltageLevel_OFFSET                      1
#define GMMx774_CurrentVoltageLevel_WIDTH                       2
#define GMMx774_CurrentVoltageLevel_MASK                        0x6
#define GMMx774_Reserved_31_3_OFFSET                            3
#define GMMx774_Reserved_31_3_WIDTH                             29
#define GMMx774_Reserved_31_3_MASK                              0xfffffff8

/// GMMx774
typedef union {
  struct {                                                              ///<
    UINT32                                         VoltageChangeAck:1 ; ///<
    UINT32                                      CurrentVoltageLevel:2 ; ///<
    UINT32                                            Reserved_31_3:29; ///<
  } Field;                                                              ///<
  UINT32 Value;                                                         ///<
} GMMx774_STRUCT;

// **** GMMx15C0 Register Definition ****
// Address
#define GMMx15C0_ADDRESS                                        0x15c0

// Type
#define GMMx15C0_TYPE                                           TYPE_GMM
// Field Data
#define GMMx15C0_OnDly_OFFSET                                   0
#define GMMx15C0_OnDly_WIDTH                                    6
#define GMMx15C0_OnDly_MASK                                     0x3f
#define GMMx15C0_OffDly_OFFSET                                  6
#define GMMx15C0_OffD