/** @file
  Character classification and case conversion tables, and functions,
  for the C Standard Library as required to implement ctype.h.

  These are the default, C locale, tables.

  Copyright (c) 2010 - 2011, Intel Corporation. All rights reserved.<BR>
  This program and the accompanying materials are licensed and made available under
  the terms and conditions of the BSD License that accompanies this distribution.
  The full text of the license may be found at
  http://opensource.org/licenses/bsd-license.

  THE PROGRAM IS DISTRIBUTED UNDER THE BSD LICENSE ON AN "AS IS" BASIS,
  WITHOUT WARRANTIES OR REPRESENTATIONS OF ANY KIND, EITHER EXPRESS OR IMPLIED.
**/
#include  <LibConfig.h>
#include  <ctype.h>

/// ASCII-7 Character Classification Table
const UINT16  _C_CharClassTable[128] = {
  /* 00 NUL */    ( _CC ),
  /* 01 SOH */    ( _CC ),
  /* 02 STX */    ( _CC ),
  /* 03 ETX */    ( _CC ),
  /* 04 EOT */    ( _CC ),
  /* 05 ENQ */    ( _CC ),
  /* 06 ACK */    ( _CC ),
  /* 07 BEL */    ( _CC ),
  /* 08 BS  */    ( _CC ),
  /* 09 TAB */    ( _CC | _CW | _CB  ),
  /* 0A LF  */    ( _CC | _CW  ),
  /* 0B VT  */    ( _CC | _CW  ),
  /* 0C FF  */    ( _CC | _CW  ),
  /* 0D CR  */    ( _CC | _CW  ),
  /* 0E SO  */    ( _CC ),
  /* 0F SI  */    ( _CC ),
  /* 10 DLE */    ( _CC ),
  /* 11 DC1 */    ( _CC ),
  /* 12 DC2 */    ( _CC ),
  /* 13 DC3 */    ( _CC ),
  /* 14 DC4 */    ( _CC ),
  /* 15 NAK */    ( _CC ),
  /* 16 SYN */    ( _CC ),
  /* 17 ETB */    ( _CC ),
  /* 18 CAN */    ( _CC ),
  /* 19 EM  */    ( _CC ),
  /* 1A SUB */    ( _CC ),
  /* 1B ESC */    ( _CC ),
  /* 1C FS  */    ( _CC ),
  /* 1D GS  */    ( _CC ),
  /* 1E RS  */    ( _CC ),
  /* 1F US  */    ( _CC ),
  /* 20 ' ' */    ( _CW | _CS | _CB  ),
  /* 21 '!' */    ( _CP | _CG  ),
  /* 22 '"' */    ( _CP | _CG  ),
  /* 23 '#' */    ( _CP | _CG  ),
  /* 24 '$' */    ( _CP | _CG  ),
  /* 25 '%' */    ( _CP | _CG  ),
  /* 26 '&' */    ( _CP | _CG  ),
  /* 27 '\''*/    ( _CP | _CG | _C0  ),
  /* 28 '(' */    ( _CP | _CG  ),
  /* 29 ')' */    ( _CP | _CG  ),
  /* 2A '*' */    ( _CP | _CG  ),
  /* 2B '+' */    ( _CP | _CG  ),
  /* 2C ',' */    ( _CP | _CG  ),
  /* 2D '-' */    ( _CP | _CG  ),
  /* 2E '.' */    ( _CP | _CG  ),
  /* 2F '/' */    ( _CP | _CG | _C0  ),
  /* 30 '0' */    ( _CD | _CG  ),
  /* 31 '1' */    ( _CD | _CG  ),
  /* 32 '2' */    ( _CD | _CG  ),
  /* 33 '3' */    ( _CD | _CG  ),
  /* 34 '4' */    ( _CD | _CG  ),
  /* 35 '5' */    ( _CD | _CG  ),
  /* 36 '6' */    ( _CD | _CG  ),
  /* 37 '7' */    ( _CD | _CG  ),
  /* 38 '8' */    ( _CD | _CG  ),
  /* 39 '9' */    ( _CD | _CG  ),
  /* 3A ':' */    ( _CP | _CG  ),
  /* 3B ';' */    ( _CP | _CG  ),
  /* 3C '<' */    ( _CP | _CG  ),
  /* 3D '=' */    ( _CP | _CG  ),
  /* 3E '>' */    ( _CP | _CG  ),
  /* 3F '?' */    ( _CP | _CG  ),
  /* 40 '@' */    ( _CP | _CG  ),
  /* 41 'A' */    ( _CU | _CX | _CG  ),
  /* 42 'B' */    ( _CU | _CX | _CG  ),
  /* 43 'C' */    ( _CU | _CX | _CG  ),
  /* 44 'D' */    ( _CU | _CX | _CG  ),
  /* 45 'E' */    ( _CU | _CX | _CG  ),
  /* 46 'F' */    ( _CU | _CX | _CG  ),
  /* 47 'G' */    ( _CU | _CG  ),
  /* 48 'H' */    ( _CU | _CG  ),
  /* 49 'I' */    ( _CU | _CG  ),
  /* 4A 'J' */    ( _CU | _CG  ),
  /* 4B 'K' */    ( _CU | _CG  ),
  /* 4C 'L' */    ( _CU | _CG  ),
  /* 4D 'M' */    ( _CU | _CG  ),
  /* 4E 'N' */    ( _CU | _CG  ),
  /* 4F 'O' */    ( _CU | _CG  ),
  /* 50 'P' */    ( _CU | _CG  ),
  /* 51 'Q' */    ( _CU | _CG  ),
  /* 52 'R' */    ( _CU | _CG  ),
  /* 53 'S' */    ( _CU | _CG  ),
  /* 54 'T' */    ( _CU | _CG  ),
  /* 55 'U' */    ( _CU | _CG  ),
  /* 56 'V' */    ( _CU | _CG  ),
  /* 57 'W' */    ( _CU | _CG  ),
  /* 58 'X' */    ( _CU | _CG  ),
  /* 59 'Y' */    ( _CU | _CG  ),
  /* 5A 'Z' */    ( _CU | _CG  ),
  /* 5B '[' */    ( _CP | _CG  ),
  /* 5C '\' */    ( _CP | _CG  ),
  /* 5D ']' */    ( _CP | _CG  ),
  /* 5E '^' */    ( _CP | _CG  ),
  /* 5F '_' */    ( _CP | _CG  ),
  /* 60 '`' */    ( _CP | _CG  ),
  /* 61 'a' */    ( _CL | _CX | _CG  ),
  /* 62 'b' */    ( _CL | _CX | _CG  ),
  /* 63 'c' */    ( _CL | _CX | _CG  ),
  /* 64 'd' */    ( _CL | _CX | _CG  ),
  /* 65 'e' */    ( _CL | _CX | _CG  ),
  /* 66 'f' */    ( _CL | _CX | _CG  ),
  /* 67 'g' */    ( _CL | _CG  ),
  /* 68 'h' */    ( _CL | _CG  ),
  /* 69 'i' */    ( _CL | _CG  ),
  /* 6A 'j' */    ( _CL | _CG  ),
  /* 6B 'k' */    ( _CL | _CG  ),
  /* 6C 'l' */    ( _CL | _CG  ),
  /* 6D 'm' */    ( _CL | _CG  ),
  /* 6E 'n' */    ( _CL | _CG  ),
  /* 6F 'o' */    ( _CL | _CG  ),
  /* 70 'p' */    ( _CL | _CG  ),
  /* 71 'q' */    ( _CL | _CG  ),
  /* 72 'r' */    ( _CL | _CG  ),
  /* 73 's' */    ( _CL | _CG  ),
  /* 74 't' */    ( _CL | _CG  ),
  /* 75 'u' */    ( _CL | _CG  ),
  /* 76 'v' */    ( _CL | _CG  ),
  /* 77 'w' */    ( _CL | _CG  ),
  /* 78 'x' */    ( _CL | _CG  ),
  /* 79 'y' */    ( _CL | _CG  ),
  /* 7A 'z' */    ( _CL | _CG  ),
  /* 7B '{' */    ( _CP | _CG  ),
  /* 7C '|' */    ( _CP | _CG  ),
  /* 7D '}' */    ( _CP | _CG  ),
  /* 7E '~' */    ( _CP | _CG  ),
  /* 7F DEL */    ( _CC )
};

/// ASCII-7 Upper case to Lower case character conversion table
const UINT8  _C_ToLowerTable[128] = {
  /* 00 NUL */    0x00,           /* 01 SOH */    0x01,
  /* 02 STX */    0x02,           /* 03 ETX */    0x03,
  /* 04 EOT */    0x04,           /* 05 ENQ */    0x05,
  /* 06 ACK */    0x06,           /* 07 BEL */    0x07,
  /* 08 BS  */    0x08,           /* 09 TAB */    0x09,
  /* 0A LF  */    0x0A,           /* 0B VT  */    0x0B,
  /* 0C FF  */    0x0C,           /* 0D CR  */    0x0D,
  /* 0E SO  */    0x0E,           /* 0F SI  */    0x0F,
  /* 10 DLE */    0x10,           /* 11 DC1 */    0x11,
  /* 12 DC2 */    0x12,           /* 13 DC3 */    0x13,
  /* 14 DC4 */    0x14,           /* 15 NAK */    0x15,
  /* 16 SYN */    0x16,           /* 17 ETB */    0x17,
  /* 18 CAN */    0x18,           /* 19 EM  */    0x19,
  /* 1A SUB */    0x1A,           /* 1B ESC */    0x1B,
  /* 1C FS  */    0x1C,           /* 1D GS  */    0x1D,
  /* 1E RS  */    0x1E,           /* 1F US  */    0x1F,
  /* 20 ' ' */    0x20,           /* 21 '!' */    0x21,
  /* 22 '"' */    0x22,           /* 23 '#' */    0x23,
  /* 24 '$' */    0x24,           /* 25 '%' */    0x25,
  /* 26 '&' */    0x26,           /* 27 '\''*/    0x27,
  /* 28 '(' */    0x28,           /* 29 ')' */    0x29,
  /* 2A '*' */    0x2A,           /* 2B '+' */    0x2B,
  /* 2C ',' */    0x2C,           /* 2D '-' */    0x2D,
  /* 2E '.' */    0x2E,           /* 2F '/' */    0x2F,
  /* 30 '0' */    0x30,           /* 31 '1' */    0x31,
  /* 32 '2' */    0x32,           /* 33 '3' */    0x33,
  /* 34 '4' */    0x34,           /* 35 '5' */    0x35,
  /* 36 '6' */    0x36,           /* 37 '7' */    0x37,
  /* 38 '8' */    0x38,           /* 39 '9' */    0x39,
  /* 3A ':' */    0x3A,           /* 3B ';' */    0x3B,
  /* 3C '<' */    0x3C,           /* 3D '=' */    0x3D,
  /* 3E '>' */    0x3E,           /* 3F '?' */    0x3F,
  /* 40 '@' */    0x40,           /* 41 'A' */    0x61,
  /* 42 'B' */    0x62,           /* 43 'C' */    0x63,
  /* 44 'D' */    0x64,           /* 45 'E' */    0x65,
  /* 46 'F' */    0x66,           /* 47 'G' */    0x67,
  /* 48 'H' */    0x68,           /* 49 'I' */    0x69,
  /* 4A 'J' */    0x6A,           /* 4B 'K' */    0x6B,
  /* 4C 'L' */    0x6C,           /* 4D 'M' */    0x6D,
  /* 4E 'N' */    0x6E,           /* 4F 'O' */    0x6F,
  /* 50 'P' */    0x70,           /* 51 'Q' */    0x71,
  /* 52 'R' */    0x72,           /* 53 'S' */    0x73,
  /* 54 'T' */    0x74,           /* 55 'U' */    0x75,
  /* 56 'V' */    0x76,           /* 57 'W' */    0x77,
  /* 58 'X' */    0x78,           /* 59 'Y' */    0x79,
  /* 5A 'Z' */    0x7A,           /* 5B '[' */    0x5B,
  /* 5C '\' */    0x5C,           /* 5D ']' */    0x5D,
  /* 5E '^' */    0x5E,           /* 5F '_' */    0x5F,
  /* 60 '`' */    0x60,           /* 61 'a' */    0x61,
  /* 62 'b' */    0x62,           /* 63 'c' */    0x63,
  /* 64 'd' */    0x64,           /* 65 'e' */    0x65,
  /* 66 'f' */    0x66,           /* 67 'g' */    0x67,
  /* 68 'h' */    0x68,           /* 69 'i' */    0x69,
  /* 6A 'j' */    0x6A,           /* 6B 'k' */    0x6B,
  /* 6C 'l' */    0x6C,           /* 6D 'm' */    0x6D,
  /* 6E 'n' */    0x6E,           /* 6F 'o' */    0x6F,
  /* 70 'p' */    0x70,           /* 71 'q' */    0x71,
  /* 72 'r' */    0x72,           /* 73 's' */    0x73,
  /* 74 't' */    0x74,           /* 75 'u' */    0x75,
  /* 76 'v' */    0x76,           /* 77 'w' */    0x77,
  /* 78 'x' */    0x78,           /* 79 'y' */    0x79,
  /* 7A 'z' */    0x7A,           /* 7B '{' */    0x7B,
  /* 7C '|' */    0x7C,           /* 7D '}' */    0x7D,
  /* 7E '~' */    0x7E,           /* 7F DEL */    0x7F
};

/// ASCII-7 Lower case to Upper case character conversion table
const UINT8  _C_ToUpperTable[128] = {
  /* 00 NUL */    0x00,           /* 01 SOH */    0x01,
  /* 02 STX */    0x02,           /* 03 ETX */    0x03,
  /* 04 EOT */    0x04,           /* 05 ENQ */    0x05,
  /* 06 ACK */    0x06,           /* 07 BEL */    0x07,
  /* 08 BS  */    0x08,           /* 09 TAB */    0x09,
  /* 0A LF  */    0x0A,           /* 0B VT  */    0x0B,
  /* 0C FF  */    0x0C,           /* 0D CR  */    0x0D,
  /* 0E SO  */    0x0E,           /* 0F SI  */    0x0F,
  /* 10 DLE */    0x10,           /* 11 DC1 */    0x11,
  /* 12 DC2 */    0x12,           /* 13 DC3 */    0x13,
  /* 14 DC4 */    0x14,           /* 15 NAK */    0x15,
  /* 16 SYN */    0x16,           /* 17 ETB */    0x17,
  /* 18 CAN */    0x18,           /* 19 EM  */    0x19,
  /* 1A SUB */    0x1A,           /* 1B ESC */    0x1B,
  /* 1C FS  */    0x1C,           /* 1D GS  */    0x1D,
  /* 1E RS  */    0x1E,           /* 1F US  */    0x1F,
  /* 20 ' ' */    0x20,           /* 21 '!' */    0x21,
  /* 22 '"' */    0x22,           /* 23 '#' */    0x23,
  /* 24 '$' */    0x24,           /* 25 '%' */    0x25,
  /* 26 '&' */    0x26,           /* 27 '\''*/    0x27,
  /* 28 '(' */    0x28,           /* 29 ')' */    0x29,
  /* 2A '*' */    0x2A,           /* 2B '+' */    0x2B,
  /* 2C ',' */    0x2C,           /* 2D '-' */    0x2D,
  /* 2E '.' */    0x2E,           /* 2F '/' */    0x2F,
  /* 30 '0' */    0x30,           /* 31 '1' */    0x31,
  /* 32 '2' */    0x32,           /* 33 '3' */    0x33,
  /* 34 '4' */    0x34,           /* 35 '5' */    0x35,
  /* 36 '6' */    0x36,           /* 37 '7' */    0x37,
  /* 38 '8' */    0x38,           /* 39 '9' */    0x39,
  /* 3A ':' */    0x3A,           /* 3B ';' */    0x3B,
  /* 3C '<' */    0x3C,           /* 3D '=' */    0x3D,
  /* 3E '>' */    0x3E,           /* 3F '?' */    0x3F,
  /* 40 '@' */    0x40,           /* 41 'A' */    0x41,
  /* 42 'B' */    0x42,           /* 43 'C' */    0x43,
  /* 44 'D' */    0x44,           /* 45 'E' */    0x45,
  /* 46 'F' */    0x46,           /* 47 'G' */    0x47,
  /* 48 'H' */    0x48,           /* 49 'I' */    0x49,
  /* 4A 'J' */    0x4A,           /* 4B 'K' */    0x4B,
  /* 4C 'L' */    0x4C,           /* 4D 'M' */    0x4D,
  /* 4E 'N' */    0x4E,           /* 4F 'O' */    0x4F,
  /* 50 'P' */    0x50,           /* 51 'Q' */    0x51,
  /* 52 'R' */    0x52,           /* 53 'S' */    0x53,
  /* 54 'T' */    0x54,           /* 55 'U' */    0x55,
  /* 56 'V' */    0x56,           /* 57 'W' */    0x57,
  /* 58 'X' */    0x58,           /* 59 'Y' */    0x59,
  /* 5A 'Z' */    0x5A,           /* 5B '[' */    0x5B,
  /* 5C '\' */    0x5C,           /* 5D ']' */    0x5D,
  /* 5E '^' */    0x5E,           /* 5F '_' */    0x5F,
  /* 60 '`' */    0x60,           /* 61 'a' */    0x41,
  /* 62 'b' */    0x42,           /* 63 'c' */    0x43,
  /* 64 'd' */    0x44,           /* 65 'e' */    0x45,
  /* 66 'f' */    0x46,           /* 67 'g' */    0x47,
  /* 68 'h' */    0x48,           /* 69 'i' */    0x49,
  /* 6A 'j' */    0x4A,           /* 6B 'k' */    0x4B,
  /* 6C 'l' */    0x4C,           /* 6D 'm' */    0x4D,
  /* 6E 'n' */    0x4E,           /* 6F 'o' */    0x4F,
  /* 70 'p' */    0x50,           /* 71 'q' */    0x51,
  /* 72 'r' */    0x52,           /* 73 's' */    0x53,
  /* 74 't' */    0x54,           /* 75 'u' */    0x55,
  /* 76 'v' */    0x56,           /* 77 'w' */    0x57,
  /* 78 'x' */    0x58,           /* 79 'y' */    0x59,
  /* 7A 'z' */    0x5A,           /* 7B '{' */    0x7B,
  /* 7C '|' */    0x7C,           /* 7D '}' */    0x7D,
  /* 7E '~' */    0x7E,           /* 7F DEL */    0x7F
};

/// Default character classification table is 7-bit ASCII
const UINT16  *_cClass = _C_CharClassTable;

/// Default upper to lower conversion table is 7-bit ASCII
const UINT8  *_lConvT = _C_ToLowerTable;

/// Default lower to upper conversion table is 7-bit ASCII
const UINT8  *_uConvT = _C_ToUpperTable;

/** Sets the character classification and case conversion tables for the 'C' locale.

    A set of locale-independent pointers are used to point to the classification and
    conversion tables for the currently specified locale.  This function is used to
    establish the tables for the 'C' locale.
**/
void
__set_C_locale( void )
{
  _cClass = _C_CharClassTable;
  _lConvT = _C_ToLowerTable;
  _uConvT = _C_ToUpperTable;
}
