/*
 * Decompiled with CFR 0.152.
 */
package net.orfjackal.retrolambda.lambdas;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.SeekableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.nio.file.FileSystem;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.spi.FileSystemProvider;
import java.util.Set;
import net.orfjackal.retrolambda.fs.FakeFileSystem;
import net.orfjackal.retrolambda.fs.FakeFileSystemProvider;
import net.orfjackal.retrolambda.fs.FakePath;
import net.orfjackal.retrolambda.fs.FakeSeekableByteChannel;
import net.orfjackal.retrolambda.lambdas.LambdaClassSaver;

public class LambdaClassDumper
implements AutoCloseable {
    private final LambdaClassSaver lambdaClassSaver;
    private Field dumperField;

    public LambdaClassDumper(LambdaClassSaver lambdaClassSaver) {
        this.lambdaClassSaver = lambdaClassSaver;
    }

    public void install() {
        try {
            Class<?> mf = Class.forName("java.lang.invoke.InnerClassLambdaMetafactory");
            this.dumperField = mf.getDeclaredField("dumper");
            LambdaClassDumper.makeNonFinal(this.dumperField);
            this.dumperField.setAccessible(true);
            VirtualPath p = new VirtualPath("");
            this.dumperField.set(null, LambdaClassDumper.newProxyClassesDumper(p));
        }
        catch (Exception e) {
            throw new IllegalStateException("Cannot initialize dumper; unexpected JDK implementation. Please run Retrolambda using the Java agent (enable forking in the Maven plugin).", e);
        }
    }

    public void uninstall() {
        if (this.dumperField != null) {
            try {
                this.dumperField.set(null, null);
            }
            catch (IllegalAccessException | IllegalArgumentException e) {
                throw new RuntimeException(e);
            }
        }
    }

    @Override
    public void close() {
        this.uninstall();
    }

    private static void makeNonFinal(Field field) throws Exception {
        Field modifiers = field.getClass().getDeclaredField("modifiers");
        modifiers.setAccessible(true);
        int mod = modifiers.getInt(field);
        modifiers.setInt(field, mod & 0xFFFFFFEF);
    }

    private static Object newProxyClassesDumper(Path dumpDir) throws Exception {
        Class<?> dumper = Class.forName("java.lang.invoke.ProxyClassesDumper");
        Constructor<?> c = dumper.getDeclaredConstructor(Path.class);
        c.setAccessible(true);
        return c.newInstance(dumpDir);
    }

    private final class ClassChannel
    extends FakeSeekableByteChannel {
        private final Path path;
        private final ByteArrayOutputStream os;
        private final WritableByteChannel ch;

        public ClassChannel(Path path) {
            this.path = path;
            this.os = new ByteArrayOutputStream();
            this.ch = Channels.newChannel(this.os);
        }

        @Override
        public int write(ByteBuffer src) throws IOException {
            return this.ch.write(src);
        }

        @Override
        public void close() {
            String className = this.path.toString();
            className = className.substring(0, className.lastIndexOf(".class"));
            LambdaClassDumper.this.lambdaClassSaver.saveIfLambda(className, this.os.toByteArray());
        }
    }

    private final class VirtualPath
    extends FakePath {
        private final String path;

        public VirtualPath(String path) {
            this.path = path;
        }

        @Override
        public FileSystem getFileSystem() {
            return new VirtualFS();
        }

        @Override
        public Path getParent() {
            return this;
        }

        @Override
        public Path resolve(String other) {
            if (!this.path.isEmpty()) {
                throw new IllegalStateException();
            }
            return new VirtualPath(other);
        }

        @Override
        public String toString() {
            return this.path;
        }
    }

    private final class VirtualFS
    extends FakeFileSystem {
        private VirtualFS() {
        }

        @Override
        public FileSystemProvider provider() {
            return new VirtualFSProvider();
        }
    }

    private final class VirtualFSProvider
    extends FakeFileSystemProvider {
        private VirtualFSProvider() {
        }

        @Override
        public SeekableByteChannel newByteChannel(Path path, Set<? extends OpenOption> options, FileAttribute<?> ... attrs) {
            return new ClassChannel(path);
        }

        @Override
        public void createDirectory(Path dir, FileAttribute<?> ... attrs) {
        }
    }
}

