/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.ivyservice.projectmodule;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.gradle.api.artifacts.ModuleVersionIdentifier;
import org.gradle.api.artifacts.component.BuildIdentifier;
import org.gradle.api.artifacts.component.ComponentIdentifier;
import org.gradle.api.artifacts.component.ProjectComponentIdentifier;
import org.gradle.api.internal.artifacts.ImmutableModuleIdentifierFactory;
import org.gradle.api.internal.artifacts.Module;
import org.gradle.api.internal.artifacts.configurations.ConfigurationInternal;
import org.gradle.api.internal.artifacts.ivyservice.moduleconverter.LocalComponentMetadataBuilder;
import org.gradle.api.internal.artifacts.ivyservice.projectmodule.LocalComponentProvider;
import org.gradle.api.internal.attributes.AttributesSchemaInternal;
import org.gradle.api.internal.project.ProjectInternal;
import org.gradle.api.internal.project.ProjectState;
import org.gradle.api.internal.project.ProjectStateRegistry;
import org.gradle.api.internal.tasks.NodeExecutionContext;
import org.gradle.api.internal.tasks.TaskDependencyResolveContext;
import org.gradle.internal.Describables;
import org.gradle.internal.component.local.model.DefaultLocalComponentMetadata;
import org.gradle.internal.component.local.model.LocalComponentMetadata;
import org.gradle.internal.model.CalculatedValueContainer;
import org.gradle.internal.model.CalculatedValueContainerFactory;
import org.gradle.internal.model.ValueCalculator;

public class DefaultProjectLocalComponentProvider
implements LocalComponentProvider {
    private final ProjectStateRegistry projectStateRegistry;
    private final LocalComponentMetadataBuilder metadataBuilder;
    private final ImmutableModuleIdentifierFactory moduleIdentifierFactory;
    private final BuildIdentifier thisBuild;
    private final CalculatedValueContainerFactory calculatedValueContainerFactory;
    private final Map<ProjectComponentIdentifier, CalculatedValueContainer<LocalComponentMetadata, ?>> projects = new ConcurrentHashMap();

    public DefaultProjectLocalComponentProvider(ProjectStateRegistry projectStateRegistry, LocalComponentMetadataBuilder metadataBuilder, ImmutableModuleIdentifierFactory moduleIdentifierFactory, BuildIdentifier thisBuild, CalculatedValueContainerFactory calculatedValueContainerFactory) {
        this.projectStateRegistry = projectStateRegistry;
        this.metadataBuilder = metadataBuilder;
        this.moduleIdentifierFactory = moduleIdentifierFactory;
        this.thisBuild = thisBuild;
        this.calculatedValueContainerFactory = calculatedValueContainerFactory;
    }

    @Override
    public LocalComponentMetadata getComponent(ProjectComponentIdentifier projectIdentifier) {
        if (!this.isLocalProject(projectIdentifier)) {
            return null;
        }
        CalculatedValueContainer valueContainer = this.projects.computeIfAbsent(projectIdentifier, projectComponentIdentifier -> {
            ProjectState projectState = this.projectStateRegistry.stateFor(projectIdentifier);
            return this.calculatedValueContainerFactory.create(Describables.of((Object)"metadata of", (Object)projectIdentifier), (ValueCalculator)new MetadataSupplier(projectState));
        });
        valueContainer.finalizeIfNotAlready();
        return (LocalComponentMetadata)valueContainer.get();
    }

    private boolean isLocalProject(ProjectComponentIdentifier projectIdentifier) {
        return projectIdentifier.getBuild().equals(this.thisBuild);
    }

    private class MetadataSupplier
    implements ValueCalculator<LocalComponentMetadata> {
        private final ProjectState projectState;

        public MetadataSupplier(ProjectState projectState) {
            this.projectState = projectState;
        }

        public void visitDependencies(TaskDependencyResolveContext context) {
        }

        public boolean usesMutableProjectState() {
            return true;
        }

        public ProjectInternal getOwningProject() {
            return this.projectState.getMutableModel();
        }

        public LocalComponentMetadata calculateValue(NodeExecutionContext context) {
            return (LocalComponentMetadata)this.projectState.fromMutableState(p -> this.getLocalComponentMetadata(this.projectState, (ProjectInternal)p));
        }

        private LocalComponentMetadata getLocalComponentMetadata(ProjectState projectState, ProjectInternal project) {
            Module module = project.getDependencyMetaDataProvider().getModule();
            ModuleVersionIdentifier moduleVersionIdentifier = DefaultProjectLocalComponentProvider.this.moduleIdentifierFactory.moduleWithVersion(module.getGroup(), module.getName(), module.getVersion());
            ProjectComponentIdentifier componentIdentifier = projectState.getComponentIdentifier();
            DefaultLocalComponentMetadata metaData = new DefaultLocalComponentMetadata(moduleVersionIdentifier, (ComponentIdentifier)componentIdentifier, module.getStatus(), (AttributesSchemaInternal)project.getDependencies().getAttributesSchema());
            for (ConfigurationInternal configuration : project.getConfigurations().withType(ConfigurationInternal.class)) {
                DefaultProjectLocalComponentProvider.this.metadataBuilder.addConfiguration(metaData, configuration);
            }
            return metaData;
        }
    }
}

