/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.checkers.expression;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.fir.FirRealSourceElementKind;
import org.jetbrains.kotlin.fir.FirRendererKt;
import org.jetbrains.kotlin.fir.FirSourceElement;
import org.jetbrains.kotlin.fir.analysis.checkers.ConeTypeCompatibilityChecker;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.checkers.expression.FirExpressionChecker;
import org.jetbrains.kotlin.fir.analysis.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.fir.analysis.diagnostics.DiagnosticReporterKt;
import org.jetbrains.kotlin.fir.analysis.diagnostics.FirErrors;
import org.jetbrains.kotlin.fir.declarations.FirClass;
import org.jetbrains.kotlin.fir.declarations.FirFile;
import org.jetbrains.kotlin.fir.declarations.FirRegularClass;
import org.jetbrains.kotlin.fir.expressions.FirEqualityOperatorCall;
import org.jetbrains.kotlin.fir.expressions.FirExpression;
import org.jetbrains.kotlin.fir.resolve.LookupTagUtilsKt;
import org.jetbrains.kotlin.fir.resolve.inference.InferenceComponentsKt;
import org.jetbrains.kotlin.fir.symbols.ConeClassLikeLookupTag;
import org.jetbrains.kotlin.fir.types.ConeClassLikeType;
import org.jetbrains.kotlin.fir.types.ConeInferenceContext;
import org.jetbrains.kotlin.fir.types.ConeIntersectionType;
import org.jetbrains.kotlin.fir.types.ConeKotlinType;
import org.jetbrains.kotlin.fir.types.ConeTypeUtilsKt;
import org.jetbrains.kotlin.fir.types.FirTypeUtilsKt;
import org.jetbrains.kotlin.fir.types.TypeRendererKt;
import org.jetbrains.kotlin.fir.types.TypeUtilsKt;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u0003B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0004J \u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0014\u0010\f\u001a\u00020\r*\u00020\u000e2\u0006\u0010\b\u001a\u00020\tH\u0002\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirEqualityCompatibilityChecker;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirExpressionChecker;", "Lorg/jetbrains/kotlin/fir/expressions/FirEqualityOperatorCall;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirEqualityOperatorCallChecker;", "()V", "check", "", "expression", "context", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "reporter", "Lorg/jetbrains/kotlin/fir/analysis/diagnostics/DiagnosticReporter;", "isEnumType", "", "Lorg/jetbrains/kotlin/fir/types/ConeKotlinType;", "checkers"})
public final class FirEqualityCompatibilityChecker
extends FirExpressionChecker<FirEqualityOperatorCall> {
    @NotNull
    public static final FirEqualityCompatibilityChecker INSTANCE = new FirEqualityCompatibilityChecker();

    private FirEqualityCompatibilityChecker() {
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void check(@NotNull FirEqualityOperatorCall expression2, @NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter) {
        ConeIntersectionType coneIntersectionType;
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
        List<FirExpression> arguments2 = expression2.getArgumentList().getArguments();
        if (arguments2.size() != 2) {
            return;
        }
        ConeKotlinType lType = FirTypeUtilsKt.getConeType(arguments2.get(0).getTypeRef());
        ConeKotlinType rType = FirTypeUtilsKt.getConeType(arguments2.get(1).getTypeRef());
        if (ConeTypeUtilsKt.isNullableNothing(lType) || ConeTypeUtilsKt.isNullableNothing(rType)) {
            return;
        }
        ConeInferenceContext inferenceContext = InferenceComponentsKt.getInferenceComponents(context2.getSession()).getCtx();
        Object object = new ConeKotlinType[]{lType, rType};
        Object object2 = TypeUtilsKt.intersectTypesOrNull(inferenceContext, CollectionsKt.listOf((Object[])object));
        ConeIntersectionType coneIntersectionType2 = coneIntersectionType = object2 instanceof ConeIntersectionType ? (ConeIntersectionType)object2 : null;
        if (coneIntersectionType == null) {
            return;
        }
        ConeIntersectionType intersectionType2 = coneIntersectionType;
        try {
            object2 = ConeTypeCompatibilityChecker.INSTANCE.areCompatible(intersectionType2.getIntersectedTypes(), inferenceContext);
        }
        catch (Throwable e) {
            void $this$filterIsInstanceTo$iv$iv;
            void $this$filterIsInstance$iv;
            Iterable iterable = context2.getContainingDeclarations();
            StringBuilder stringBuilder2 = new StringBuilder().append("Exception while determining type compatibility: type ").append(TypeRendererKt.render(intersectionType2)).append(", equality ").append(FirRendererKt.render$default(expression2, null, 1, null)).append(", file ");
            boolean $i$f$filterIsInstance = false;
            void var15_16 = $this$filterIsInstance$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterIsInstanceTo = false;
            for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
                if (!(element$iv$iv instanceof FirFile)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            List list2 = (List)destination$iv$iv;
            FirFile firFile = (FirFile)CollectionsKt.firstOrNull((List)list2);
            String string2 = firFile == null ? null : firFile.getName();
            Throwable throwable = e;
            String string3 = stringBuilder2.append((Object)string2).toString();
            throw new IllegalStateException(string3, throwable);
        }
        Object compatibility = object2;
        if (compatibility != ConeTypeCompatibilityChecker.Compatibility.COMPATIBLE) {
            object = expression2.getSource();
            Object object3 = object2 = object == null ? null : ((FirSourceElement)object).getKind();
            if (Intrinsics.areEqual((Object)object2, (Object)FirRealSourceElementKind.INSTANCE)) {
                if (compatibility == ConeTypeCompatibilityChecker.Compatibility.HARD_INCOMPATIBLE && (this.isEnumType(lType, context2) || this.isEnumType(rType, context2))) {
                    DiagnosticReporterKt.reportOn$default(reporter, expression2.getSource(), FirErrors.INSTANCE.getINCOMPATIBLE_ENUM_COMPARISON_ERROR(), lType, rType, context2, null, 32, null);
                } else {
                    DiagnosticReporterKt.reportOn$default(reporter, expression2.getSource(), compatibility == ConeTypeCompatibilityChecker.Compatibility.HARD_INCOMPATIBLE ? FirErrors.INSTANCE.getEQUALITY_NOT_APPLICABLE() : FirErrors.INSTANCE.getEQUALITY_NOT_APPLICABLE_WARNING(), expression2.getOperation().getOperator(), lType, rType, context2, null, 64, null);
                }
            } else {
                DiagnosticReporterKt.reportOn$default(reporter, expression2.getSource(), compatibility == ConeTypeCompatibilityChecker.Compatibility.HARD_INCOMPATIBLE ? FirErrors.INSTANCE.getINCOMPATIBLE_TYPES() : FirErrors.INSTANCE.getINCOMPATIBLE_TYPES_WARNING(), lType, rType, context2, null, 32, null);
            }
        }
    }

    private final boolean isEnumType(ConeKotlinType $this$isEnumType, CheckerContext context2) {
        ConeClassLikeLookupTag coneClassLikeLookupTag;
        FirRegularClass firRegularClass;
        ConeClassLikeType coneClassLikeType;
        if (ConeTypeUtilsKt.isEnum($this$isEnumType)) {
            return true;
        }
        ConeClassLikeType coneClassLikeType2 = coneClassLikeType = $this$isEnumType instanceof ConeClassLikeType ? (ConeClassLikeType)$this$isEnumType : null;
        FirRegularClass firRegularClass2 = coneClassLikeType == null ? null : (firRegularClass = (coneClassLikeLookupTag = coneClassLikeType.getLookupTag()) == null ? null : LookupTagUtilsKt.toFirRegularClass(coneClassLikeLookupTag, context2.getSession()));
        if (firRegularClass == null) {
            return false;
        }
        FirRegularClass firRegularClass3 = firRegularClass;
        FirClass $this$isEnumClass$iv = firRegularClass3;
        boolean $i$f$isEnumClass = false;
        return $this$isEnumClass$iv.getClassKind() == ClassKind.ENUM_CLASS;
    }
}

