/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.execution.fingerprint.impl;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableSortedMap;
import java.util.function.Consumer;
import org.gradle.internal.execution.fingerprint.FileCollectionFingerprinter;
import org.gradle.internal.execution.fingerprint.FileCollectionFingerprinterRegistry;
import org.gradle.internal.execution.fingerprint.FileNormalizationSpec;
import org.gradle.internal.execution.fingerprint.InputFingerprinter;
import org.gradle.internal.execution.fingerprint.impl.DefaultFileNormalizationSpec;
import org.gradle.internal.fingerprint.CurrentFileCollectionFingerprint;
import org.gradle.internal.fingerprint.FileCollectionFingerprint;
import org.gradle.internal.snapshot.ValueSnapshot;
import org.gradle.internal.snapshot.ValueSnapshotter;

public class DefaultInputFingerprinter
implements InputFingerprinter {
    private final FileCollectionFingerprinterRegistry fingerprinterRegistry;
    private final ValueSnapshotter valueSnapshotter;

    public DefaultInputFingerprinter(FileCollectionFingerprinterRegistry fingerprinterRegistry, ValueSnapshotter valueSnapshotter) {
        this.fingerprinterRegistry = fingerprinterRegistry;
        this.valueSnapshotter = valueSnapshotter;
    }

    @Override
    public InputFingerprinter.Result fingerprintInputProperties(ImmutableSortedMap<String, ValueSnapshot> previousValueSnapshots, ImmutableSortedMap<String, ? extends FileCollectionFingerprint> previousFingerprints, ImmutableSortedMap<String, ValueSnapshot> knownCurrentValueSnapshots, ImmutableSortedMap<String, CurrentFileCollectionFingerprint> knownCurrentFingerprints, Consumer<InputFingerprinter.InputVisitor> inputs) {
        InputCollectingVisitor visitor = new InputCollectingVisitor(previousValueSnapshots, previousFingerprints, this.fingerprinterRegistry, this.valueSnapshotter, knownCurrentValueSnapshots, knownCurrentFingerprints);
        inputs.accept(visitor);
        return visitor.complete();
    }

    @Override
    public FileCollectionFingerprinterRegistry getFingerprinterRegistry() {
        return this.fingerprinterRegistry;
    }

    @VisibleForTesting
    public static class InputFingerprints
    implements InputFingerprinter.Result {
        private final ImmutableSortedMap<String, ValueSnapshot> valueSnapshots;
        private final ImmutableSortedMap<String, CurrentFileCollectionFingerprint> fileFingerprints;

        public InputFingerprints(ImmutableSortedMap<String, ValueSnapshot> valueSnapshots, ImmutableSortedMap<String, CurrentFileCollectionFingerprint> fileFingerprints) {
            this.valueSnapshots = valueSnapshots;
            this.fileFingerprints = fileFingerprints;
        }

        @Override
        public ImmutableSortedMap<String, ValueSnapshot> getValueSnapshots() {
            return this.valueSnapshots;
        }

        @Override
        public ImmutableSortedMap<String, CurrentFileCollectionFingerprint> getFileFingerprints() {
            return this.fileFingerprints;
        }
    }

    private static class InputCollectingVisitor
    implements InputFingerprinter.InputVisitor {
        private final ImmutableSortedMap<String, ValueSnapshot> previousValueSnapshots;
        private final ImmutableSortedMap<String, ? extends FileCollectionFingerprint> previousFingerprints;
        private final FileCollectionFingerprinterRegistry fingerprinterRegistry;
        private final ValueSnapshotter valueSnapshotter;
        private final ImmutableSortedMap<String, ValueSnapshot> knownCurrentValueSnapshots;
        private final ImmutableSortedMap<String, CurrentFileCollectionFingerprint> knownCurrentFingerprints;
        private final ImmutableSortedMap.Builder<String, ValueSnapshot> valueSnapshotsBuilder = ImmutableSortedMap.naturalOrder();
        private final ImmutableSortedMap.Builder<String, CurrentFileCollectionFingerprint> fingerprintsBuilder = ImmutableSortedMap.naturalOrder();

        public InputCollectingVisitor(ImmutableSortedMap<String, ValueSnapshot> previousValueSnapshots, ImmutableSortedMap<String, ? extends FileCollectionFingerprint> previousFingerprints, FileCollectionFingerprinterRegistry fingerprinterRegistry, ValueSnapshotter valueSnapshotter, ImmutableSortedMap<String, ValueSnapshot> knownCurrentValueSnapshots, ImmutableSortedMap<String, CurrentFileCollectionFingerprint> knownCurrentFingerprints) {
            this.previousValueSnapshots = previousValueSnapshots;
            this.previousFingerprints = previousFingerprints;
            this.fingerprinterRegistry = fingerprinterRegistry;
            this.valueSnapshotter = valueSnapshotter;
            this.knownCurrentValueSnapshots = knownCurrentValueSnapshots;
            this.knownCurrentFingerprints = knownCurrentFingerprints;
        }

        @Override
        public void visitInputProperty(String propertyName, InputFingerprinter.ValueSupplier value) {
            if (this.knownCurrentValueSnapshots.containsKey((Object)propertyName)) {
                return;
            }
            Object actualValue = value.getValue();
            try {
                ValueSnapshot previousSnapshot = (ValueSnapshot)this.previousValueSnapshots.get((Object)propertyName);
                if (previousSnapshot == null) {
                    this.valueSnapshotsBuilder.put((Object)propertyName, (Object)this.valueSnapshotter.snapshot(actualValue));
                } else {
                    this.valueSnapshotsBuilder.put((Object)propertyName, (Object)this.valueSnapshotter.snapshot(actualValue, previousSnapshot));
                }
            }
            catch (Exception e) {
                throw new InputFingerprinter.InputFingerprintingException(propertyName, String.format("value '%s' cannot be serialized", value.getValue()), e);
            }
        }

        @Override
        public void visitInputFileProperty(String propertyName, InputFingerprinter.InputPropertyType type, InputFingerprinter.FileValueSupplier value) {
            CurrentFileCollectionFingerprint fingerprint;
            if (this.knownCurrentFingerprints.containsKey((Object)propertyName)) {
                return;
            }
            FileCollectionFingerprint previousFingerprint = (FileCollectionFingerprint)this.previousFingerprints.get((Object)propertyName);
            FileNormalizationSpec normalizationSpec = DefaultFileNormalizationSpec.from(value.getNormalizer(), value.getDirectorySensitivity(), value.getLineEndingNormalization());
            FileCollectionFingerprinter fingerprinter = this.fingerprinterRegistry.getFingerprinter(normalizationSpec);
            try {
                fingerprint = fingerprinter.fingerprint(value.getFiles(), previousFingerprint);
            }
            catch (Exception e) {
                throw new InputFingerprinter.InputFileFingerprintingException(propertyName, e);
            }
            this.fingerprintsBuilder.put((Object)propertyName, (Object)fingerprint);
        }

        public InputFingerprinter.Result complete() {
            return new InputFingerprints((ImmutableSortedMap<String, ValueSnapshot>)this.valueSnapshotsBuilder.build(), (ImmutableSortedMap<String, CurrentFileCollectionFingerprint>)this.fingerprintsBuilder.build());
        }
    }
}

