/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.execution;

import com.google.common.collect.Lists;
import java.util.List;
import org.gradle.api.internal.GradleInternal;
import org.gradle.api.internal.project.ProjectStateRegistry;
import org.gradle.execution.BuildConfigurationAction;
import org.gradle.execution.BuildConfigurationActionExecuter;
import org.gradle.execution.BuildExecutionContext;

public class DefaultBuildConfigurationActionExecuter
implements BuildConfigurationActionExecuter {
    private List<? extends BuildConfigurationAction> taskSelectors;
    private final ProjectStateRegistry projectStateRegistry;

    public DefaultBuildConfigurationActionExecuter(Iterable<? extends BuildConfigurationAction> defaultTaskSelectors, ProjectStateRegistry projectStateRegistry) {
        this.taskSelectors = Lists.newArrayList(defaultTaskSelectors);
        this.projectStateRegistry = projectStateRegistry;
    }

    @Override
    public void select(GradleInternal gradle) {
        this.projectStateRegistry.withMutableStateOfAllProjects(() -> this.configure(this.taskSelectors, gradle, 0));
    }

    @Override
    public void setTaskSelectors(List<? extends BuildConfigurationAction> taskSelectors) {
        this.taskSelectors = taskSelectors;
    }

    private void configure(final List<? extends BuildConfigurationAction> processingConfigurationActions, final GradleInternal gradle, final int index) {
        if (index >= processingConfigurationActions.size()) {
            return;
        }
        processingConfigurationActions.get(index).configure(new BuildExecutionContext(){

            @Override
            public GradleInternal getGradle() {
                return gradle;
            }

            @Override
            public void proceed() {
                DefaultBuildConfigurationActionExecuter.this.configure(processingConfigurationActions, gradle, index + 1);
            }
        });
    }
}

