/*
 * Decompiled with CFR 0.152.
 */
package org.fest.swing.driver;

import javax.swing.JTable;
import javax.swing.table.TableCellEditor;
import org.fest.swing.annotation.RunsInCurrentThread;
import org.fest.swing.annotation.RunsInEDT;
import org.fest.swing.driver.JTableCellValidator;
import org.fest.swing.edt.GuiActionRunner;
import org.fest.swing.edt.GuiTask;

final class JTableStopCellEditingTask {
    @RunsInEDT
    static void stopEditing(final TableCellEditor cellEditor) {
        GuiActionRunner.execute(new GuiTask(){

            protected void executeInEDT() {
                JTableStopCellEditingTask.doStopCellEditing(cellEditor);
            }
        });
    }

    @RunsInEDT
    static void stopEditing(final JTable table, final int row, final int column) {
        GuiActionRunner.execute(new GuiTask(){

            protected void executeInEDT() {
                JTableStopCellEditingTask.doStopCellEditing(table, row, column);
            }
        });
    }

    @RunsInEDT
    static void validateAndStopEditing(final JTable table, final int row, final int column) {
        GuiActionRunner.execute(new GuiTask(){

            protected void executeInEDT() {
                JTableCellValidator.validateIndices(table, row, column);
                JTableCellValidator.validateCellIsEditable(table, row, column);
                JTableStopCellEditingTask.doStopCellEditing(table, row, column);
            }
        });
    }

    @RunsInCurrentThread
    private static void doStopCellEditing(JTable table, int row, int column) {
        JTableStopCellEditingTask.doStopCellEditing(table.getCellEditor(row, column));
    }

    @RunsInCurrentThread
    private static void doStopCellEditing(TableCellEditor cellEditor) {
        if (cellEditor == null) {
            return;
        }
        cellEditor.stopCellEditing();
    }

    private JTableStopCellEditingTask() {
    }
}

