/*
 * Decompiled with CFR 0.152.
 */
package org.fest.swing.annotation;

import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import org.fest.swing.annotation.GUITest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class GUITestFinder {
    public static boolean isGUITest(Class<?> type, Method method) {
        return GUITestFinder.isGUITest(type) || GUITestFinder.isGUITest(method) || GUITestFinder.isSuperClassGUITest(type, method);
    }

    private static boolean isSuperClassGUITest(Class<?> type, Method method) {
        for (Class<?> superclass = type.getSuperclass(); superclass != null; superclass = superclass.getSuperclass()) {
            if (GUITestFinder.isGUITest(superclass)) {
                return true;
            }
            Method overriden = GUITestFinder.method(superclass, method.getName(), method.getParameterTypes());
            if (overriden == null || !GUITestFinder.isGUITest(overriden)) continue;
            return true;
        }
        return false;
    }

    private static Method method(Class<?> type, String methodName, Class<?>[] parameterTypes) {
        try {
            return type.getDeclaredMethod(methodName, parameterTypes);
        }
        catch (SecurityException e) {
            return null;
        }
        catch (NoSuchMethodException e) {
            return null;
        }
        catch (RuntimeException e) {
            return null;
        }
    }

    private static boolean isGUITest(AnnotatedElement annotatedElement) {
        return annotatedElement.isAnnotationPresent(GUITest.class);
    }

    private GUITestFinder() {
    }
}

