/*
 * Decompiled with CFR 0.152.
 */
package org.fest.swing.fixture;

import java.awt.Point;
import java.util.regex.Pattern;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.fest.swing.core.KeyPressInfo;
import org.fest.swing.core.MouseButton;
import org.fest.swing.core.MouseClickInfo;
import org.fest.swing.core.Robot;
import org.fest.swing.driver.JComponentDriver;
import org.fest.swing.fixture.CommonComponentFixture;
import org.fest.swing.fixture.ContainerFixture;
import org.fest.swing.fixture.JComponentFixture;
import org.fest.swing.fixture.JPopupMenuFixture;
import org.fest.swing.fixture.JPopupMenuInvokerFixture;
import org.fest.swing.timing.Timeout;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JPanelFixture
extends ContainerFixture<JPanel>
implements CommonComponentFixture,
JComponentFixture,
JPopupMenuInvokerFixture {
    private JComponentDriver driver;

    public JPanelFixture(Robot robot, String panelName) {
        super(robot, panelName, JPanel.class);
        this.createDriver();
    }

    public JPanelFixture(Robot robot, JPanel target) {
        super(robot, target);
        this.createDriver();
    }

    private void createDriver() {
        this.driver(new JComponentDriver(this.robot));
    }

    protected final void driver(JComponentDriver newDriver) {
        JPanelFixture.validateNotNull(newDriver);
        this.driver = newDriver;
    }

    @Override
    public JPanelFixture click() {
        this.driver.click(this.target);
        return this;
    }

    @Override
    public JPanelFixture click(MouseButton button) {
        this.driver.click(this.target, button);
        return this;
    }

    @Override
    public JPanelFixture click(MouseClickInfo mouseClickInfo) {
        this.driver.click(this.target, mouseClickInfo);
        return this;
    }

    @Override
    public JPanelFixture rightClick() {
        this.driver.rightClick(this.target);
        return this;
    }

    @Override
    public JPanelFixture doubleClick() {
        this.driver.doubleClick(this.target);
        return this;
    }

    @Override
    public JPanelFixture focus() {
        this.driver.focus(this.target);
        return this;
    }

    @Override
    public JPanelFixture pressAndReleaseKey(KeyPressInfo keyPressInfo) {
        this.driver.pressAndReleaseKey(this.target, keyPressInfo);
        return this;
    }

    @Override
    public JPanelFixture pressAndReleaseKeys(int ... keyCodes) {
        this.driver.pressAndReleaseKeys(this.target, keyCodes);
        return this;
    }

    @Override
    public JPanelFixture pressKey(int keyCode) {
        this.driver.pressKey(this.target, keyCode);
        return this;
    }

    @Override
    public JPanelFixture releaseKey(int keyCode) {
        this.driver.releaseKey(this.target, keyCode);
        return this;
    }

    @Override
    public JPanelFixture requireFocused() {
        this.driver.requireFocused(this.target);
        return this;
    }

    @Override
    public JPanelFixture requireEnabled() {
        this.driver.requireEnabled(this.target);
        return this;
    }

    @Override
    public JPanelFixture requireEnabled(Timeout timeout) {
        this.driver.requireEnabled(this.target, timeout);
        return this;
    }

    @Override
    public JPanelFixture requireDisabled() {
        this.driver.requireDisabled(this.target);
        return this;
    }

    @Override
    public JPanelFixture requireVisible() {
        this.driver.requireVisible(this.target);
        return this;
    }

    @Override
    public JPanelFixture requireNotVisible() {
        this.driver.requireNotVisible(this.target);
        return this;
    }

    @Override
    public JPanelFixture requireToolTip(String expected) {
        this.driver.requireToolTip((JComponent)this.target, expected);
        return this;
    }

    @Override
    public JPanelFixture requireToolTip(Pattern pattern) {
        this.driver.requireToolTip((JComponent)this.target, pattern);
        return this;
    }

    @Override
    public Object clientProperty(Object key) {
        return this.driver.clientProperty((JComponent)this.target, key);
    }

    @Override
    public JPopupMenuFixture showPopupMenu() {
        return new JPopupMenuFixture(this.robot, this.driver.invokePopupMenu(this.target));
    }

    @Override
    public JPopupMenuFixture showPopupMenuAt(Point p) {
        return new JPopupMenuFixture(this.robot, this.driver.invokePopupMenu(this.target, p));
    }
}

