/* AppController */

#import <Cocoa/Cocoa.h>
#import <libpq-fe.h>

@interface AppController : NSObject
{
    PGconn *connection;
    PGresult *lastResult;
    PGresult *typeResult;
    IBOutlet NSWindow *mainWindow;
    IBOutlet NSTextView *inputTextView;
    IBOutlet NSTextView *outputTextView;
    
    IBOutlet NSTextField *userTextField;
    IBOutlet NSTextField *passwordTextField;
    IBOutlet NSTextField *hostTextField;
    IBOutlet NSTextField *dbTextField;
    IBOutlet NSWindow *loginSheet;
    id progressIndicator;
    
    IBOutlet NSTableView *tableView;
    NSMutableArray *executedStatements;
    int currentIndex;
}
- (void)appendToLog:(NSString *)s color:(NSColor *)c;
- (IBAction)reconnect:(id)sender;
- (IBAction)execute:(id)sender;
- (IBAction)connect:(id)sender;
- (IBAction)previous:(id)sender;
- (IBAction)next:(id)sender;
- (IBAction)open:(id)sender;
- (NSString *)typeNameForOID:(Oid)typeOID;
- (IBAction)quit:(id)sender;
- (void)registerToolTipHandler;


@end
