/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.io;

import org.openstreetmap.josm.io.OsmApi;
import org.openstreetmap.josm.spi.preferences.Config;
import org.openstreetmap.josm.tools.I18n;

public enum OnlineResource {
    OSM_API(I18n.tr("OSM API", new Object[0])),
    JOSM_WEBSITE(I18n.tr("JOSM website", new Object[0])),
    CACHE_UPDATES(I18n.tr("Cache updates", new Object[0])),
    CERTIFICATES(I18n.tr("Certificates", new Object[0])),
    ALL(I18n.tr("All", new Object[0]));

    private final String locName;

    private OnlineResource(String locName) {
        this.locName = locName;
    }

    public String getLocName() {
        return this.locName;
    }

    public String getOfflineIcon() {
        switch (this.ordinal()) {
            case 0: {
                return "offline_osm_api";
            }
            case 1: {
                return "offline_josm_website";
            }
            case 2: {
                return "offline_cache_updates";
            }
            case 3: {
                return "offline_certificates";
            }
            case 4: {
                return "offline_all";
            }
        }
        return null;
    }

    public boolean matches(String url) {
        String baseUrl;
        switch (this.ordinal()) {
            case 4: {
                return true;
            }
            case 0: {
                baseUrl = OsmApi.getOsmApi().getServerUrl();
                break;
            }
            case 1: {
                baseUrl = Config.getUrls().getJOSMWebsite();
                break;
            }
            default: {
                return false;
            }
        }
        return url.startsWith(baseUrl.substring(baseUrl.indexOf("://")), url.indexOf("://"));
    }
}

