/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.io;

import java.awt.Component;
import java.awt.GridBagLayout;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import org.openstreetmap.josm.actions.downloadtasks.DownloadReferrersTask;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.PrimitiveId;
import org.openstreetmap.josm.gui.ExtendedDialog;
import org.openstreetmap.josm.gui.MainApplication;
import org.openstreetmap.josm.gui.PleaseWaitRunnable;
import org.openstreetmap.josm.gui.io.DownloadFromOverpassTask;
import org.openstreetmap.josm.gui.io.DownloadPrimitivesTask;
import org.openstreetmap.josm.gui.layer.OsmDataLayer;
import org.openstreetmap.josm.gui.progress.ProgressMonitor;
import org.openstreetmap.josm.gui.util.GuiHelper;
import org.openstreetmap.josm.gui.widgets.HtmlPanel;
import org.openstreetmap.josm.gui.widgets.JosmTextArea;
import org.openstreetmap.josm.io.MultiFetchOverpassObjectReader;
import org.openstreetmap.josm.io.OsmTransferException;
import org.openstreetmap.josm.io.OverpassDownloadReader;
import org.openstreetmap.josm.tools.GBC;
import org.openstreetmap.josm.tools.I18n;
import org.xml.sax.SAXException;

public class DownloadPrimitivesWithReferrersTask
extends PleaseWaitRunnable {
    private final boolean newLayer;
    private final List<PrimitiveId> ids;
    private final boolean full;
    private final boolean downloadReferrers;
    private final OsmDataLayer tmpLayer;
    private boolean canceled;
    private PleaseWaitRunnable currentTask;
    private Set<PrimitiveId> missingPrimitives;

    public DownloadPrimitivesWithReferrersTask(boolean newLayer, List<PrimitiveId> ids, boolean downloadReferrers, boolean full, String newLayerName, ProgressMonitor monitor) {
        super(I18n.tr("Download objects", new Object[0]), monitor, false);
        this.ids = ids;
        this.downloadReferrers = downloadReferrers;
        this.full = full;
        this.newLayer = newLayer;
        for (PrimitiveId primitiveId : ids) {
            if (!primitiveId.isNew()) continue;
            throw new IllegalArgumentException(MessageFormat.format("Cannot download new primitives (ID {0})", primitiveId.getUniqueId()));
        }
        this.tmpLayer = new OsmDataLayer(new DataSet(), newLayerName != null ? newLayerName : OsmDataLayer.createNewName(), null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void cancel() {
        DownloadPrimitivesWithReferrersTask downloadPrimitivesWithReferrersTask = this;
        synchronized (downloadPrimitivesWithReferrersTask) {
            this.canceled = true;
            if (this.currentTask != null) {
                this.currentTask.operationCanceled();
            }
        }
    }

    @Override
    protected void realRun() throws SAXException, IOException, OsmTransferException {
        if (Boolean.TRUE.equals(OverpassDownloadReader.FOR_MULTI_FETCH.get())) {
            this.useOverpassApi();
        } else {
            this.useOSMApi();
        }
    }

    private void useOverpassApi() {
        String request = MultiFetchOverpassObjectReader.genOverpassQuery(this.ids, true, this.downloadReferrers, this.full);
        this.currentTask = new DownloadFromOverpassTask(request, this.tmpLayer.data, this.getProgressMonitor().createSubTaskMonitor(1, false));
        this.currentTask.run();
        this.missingPrimitives = this.ids.stream().filter(id -> this.tmpLayer.data.getPrimitiveById((PrimitiveId)id) == null).collect(Collectors.toSet());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void useOSMApi() {
        this.getProgressMonitor().setTicksCount(this.ids.size() + 1);
        DownloadPrimitivesTask mainTask = new DownloadPrimitivesTask(this.tmpLayer, this.ids, this.full, this.getProgressMonitor().createSubTaskMonitor(1, false));
        DownloadPrimitivesWithReferrersTask downloadPrimitivesWithReferrersTask = this;
        synchronized (downloadPrimitivesWithReferrersTask) {
            this.currentTask = mainTask;
            if (this.canceled) {
                this.currentTask = null;
                return;
            }
        }
        this.currentTask.run();
        this.missingPrimitives = mainTask.getMissingPrimitives();
        if (this.downloadReferrers && this.tmpLayer.data != null) {
            List visible = this.ids.stream().map(this.tmpLayer.data::getPrimitiveById).filter(p -> p != null && p.isVisible()).collect(Collectors.toList());
            if (!visible.isEmpty()) {
                this.currentTask = new DownloadReferrersTask(this.tmpLayer, visible);
                this.currentTask.run();
                DownloadPrimitivesWithReferrersTask downloadPrimitivesWithReferrersTask2 = this;
                synchronized (downloadPrimitivesWithReferrersTask2) {
                    if (this.currentTask.getProgressMonitor().isCanceled()) {
                        this.cancel();
                    }
                }
            }
        }
        this.currentTask = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void finish() {
        DownloadPrimitivesWithReferrersTask downloadPrimitivesWithReferrersTask = this;
        synchronized (downloadPrimitivesWithReferrersTask) {
            if (this.canceled) {
                return;
            }
        }
        OsmDataLayer layer = MainApplication.getLayerManager().getEditLayer();
        if (layer == null || this.newLayer || !layer.isDownloadable()) {
            MainApplication.getLayerManager().addLayer(this.tmpLayer);
        } else {
            layer.mergeFrom(this.tmpLayer);
        }
        HashSet<PrimitiveId> del = new HashSet<PrimitiveId>();
        DataSet ds = MainApplication.getLayerManager().getEditDataSet();
        for (PrimitiveId id2 : this.ids) {
            OsmPrimitive osm = ds.getPrimitiveById(id2);
            if (osm == null || !osm.isDeleted()) continue;
            del.add(id2);
        }
        Set errs = this.missingPrimitives != null ? (Set)this.missingPrimitives.stream().filter(id -> !del.contains(id)).collect(Collectors.toCollection(LinkedHashSet::new)) : Collections.emptySet();
        if (!errs.isEmpty()) {
            String assumedApiRC = Boolean.TRUE.equals(OverpassDownloadReader.FOR_MULTI_FETCH.get()) ? I18n.trn("The server did not return data for the requested object, it was either deleted or does not exist.", "The server did not return data for the requested objects, they were either deleted or do not exist.", errs.size(), new Object[0]) : I18n.tr("The server replied with response code 404.<br>This usually means, the server does not know an object with the requested id.", new Object[0]);
            GuiHelper.runInEDTAndWait(() -> DownloadPrimitivesWithReferrersTask.reportProblemDialog(errs, I18n.trn("Object could not be downloaded", "Some objects could not be downloaded", errs.size(), new Object[0]), I18n.trn("One object could not be downloaded.<br>", "{0} objects could not be downloaded.<br>", errs.size(), errs.size()) + assumedApiRC, I18n.tr("missing objects:", new Object[0]), 0).showDialog());
        }
        if (!del.isEmpty()) {
            GuiHelper.runInEDTAndWait(() -> DownloadPrimitivesWithReferrersTask.reportProblemDialog(del, I18n.trn("Object deleted", "Objects deleted", del.size(), new Object[0]), I18n.trn("One downloaded object is deleted.", "{0} downloaded objects are deleted.", del.size(), del.size()), null, 2).showDialog());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<PrimitiveId> getDownloadedId() {
        DownloadPrimitivesWithReferrersTask downloadPrimitivesWithReferrersTask = this;
        synchronized (downloadPrimitivesWithReferrersTask) {
            if (this.canceled) {
                return null;
            }
        }
        ArrayList<PrimitiveId> downloaded = new ArrayList<PrimitiveId>(this.ids);
        downloaded.removeAll(this.missingPrimitives);
        return downloaded;
    }

    public static ExtendedDialog reportProblemDialog(Set<PrimitiveId> errs, String title, String text, String listLabel, int msgType) {
        JPanel p = new JPanel(new GridBagLayout());
        p.add((Component)new HtmlPanel(text), GBC.eop());
        JosmTextArea txt = new JosmTextArea();
        if (listLabel != null) {
            JLabel missing = new JLabel(listLabel);
            missing.setFont(missing.getFont().deriveFont(0));
            missing.setLabelFor(txt);
            p.add((Component)missing, GBC.eol());
        }
        txt.setFont(GuiHelper.getMonospacedFont(txt));
        txt.setEditable(false);
        txt.setBackground(p.getBackground());
        txt.setColumns(40);
        txt.setRows(1);
        txt.setText(errs.stream().map(pid -> pid.getType().getAPIName().substring(0, 1) + pid.getUniqueId()).collect(Collectors.joining(", ")));
        JScrollPane scroll = new JScrollPane(txt);
        p.add((Component)scroll, GBC.eop().weight(1.0, 0.0).fill(2));
        return new ExtendedDialog((Component)MainApplication.getMainFrame(), title, I18n.tr("Ok", new Object[0])).setButtonIcons("ok").setIcon(msgType).setContent(p, false);
    }
}

