/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.preferences.advanced;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.nio.file.InvalidPathException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.regex.Pattern;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuListener;
import javax.swing.filechooser.FileFilter;
import org.openstreetmap.josm.actions.DiskAccessAction;
import org.openstreetmap.josm.data.Preferences;
import org.openstreetmap.josm.data.PreferencesUtils;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.gui.MainApplication;
import org.openstreetmap.josm.gui.dialogs.LogShowDialog;
import org.openstreetmap.josm.gui.help.HelpUtil;
import org.openstreetmap.josm.gui.io.CustomConfigurator;
import org.openstreetmap.josm.gui.layer.MainLayerManager;
import org.openstreetmap.josm.gui.layer.OsmDataLayer;
import org.openstreetmap.josm.gui.preferences.DefaultTabPreferenceSetting;
import org.openstreetmap.josm.gui.preferences.PreferenceSetting;
import org.openstreetmap.josm.gui.preferences.PreferenceSettingFactory;
import org.openstreetmap.josm.gui.preferences.PreferenceTabbedPane;
import org.openstreetmap.josm.gui.preferences.advanced.ExportProfileAction;
import org.openstreetmap.josm.gui.preferences.advanced.PrefEntry;
import org.openstreetmap.josm.gui.preferences.advanced.PreferencesTable;
import org.openstreetmap.josm.gui.util.GuiHelper;
import org.openstreetmap.josm.gui.widgets.AbstractFileChooser;
import org.openstreetmap.josm.gui.widgets.JosmTextField;
import org.openstreetmap.josm.spi.preferences.Config;
import org.openstreetmap.josm.spi.preferences.Setting;
import org.openstreetmap.josm.spi.preferences.StringSetting;
import org.openstreetmap.josm.tools.GBC;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;
import org.openstreetmap.josm.tools.Logging;
import org.openstreetmap.josm.tools.Territories;
import org.openstreetmap.josm.tools.Utils;

public final class AdvancedPreference
extends DefaultTabPreferenceSetting {
    private List<PrefEntry> allData;
    private final List<PrefEntry> displayData = new ArrayList<PrefEntry>();
    private JosmTextField txtFilter;
    private PreferencesTable table;
    private final Map<String, String> profileTypes = new LinkedHashMap<String, String>();
    private final Comparator<PrefEntry> customComparator = (o1, o2) -> {
        if (o1.isChanged() && !o2.isChanged()) {
            return -1;
        }
        if (o2.isChanged() && !o1.isChanged()) {
            return 1;
        }
        if (!o1.isDefault() && o2.isDefault()) {
            return -1;
        }
        if (!o2.isDefault() && o1.isDefault()) {
            return 1;
        }
        return o1.compareTo((PrefEntry)o2);
    };

    private AdvancedPreference() {
        super("advanced", I18n.tr("Advanced Preferences", new Object[0]), I18n.tr("Setting Preference entries directly. Use with caution!", new Object[0]));
    }

    @Override
    public boolean isExpert() {
        return true;
    }

    @Override
    public void addGui(PreferenceTabbedPane gui) {
        PreferenceTabbedPane.PreferencePanel p = gui.createPreferenceTab(this);
        JPanel txtFilterPanel = new JPanel(new GridBagLayout());
        p.add((Component)txtFilterPanel, GBC.eol().fill(2));
        this.txtFilter = new JosmTextField();
        JLabel lbFilter = new JLabel(I18n.tr("Search:", new Object[0]));
        lbFilter.setLabelFor(this.txtFilter);
        txtFilterPanel.add((Component)lbFilter, GBC.std().insets(0, 0, 5, 0));
        txtFilterPanel.add((Component)this.txtFilter, GBC.eol().fill(2));
        this.txtFilter.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent e) {
                this.action();
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                this.action();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                this.action();
            }

            private void action() {
                AdvancedPreference.this.applyFilter();
            }
        });
        this.readPreferences(Preferences.main());
        this.applyFilter();
        this.table = new PreferencesTable(this.displayData);
        JScrollPane scroll = new JScrollPane(this.table);
        p.add((Component)scroll, GBC.eol().fill(1));
        scroll.setPreferredSize(new Dimension(400, 200));
        JPanel buttonPanel = new JPanel(new GridLayout(1, 6));
        JButton add = new JButton(I18n.tr("Add", new Object[0]), ImageProvider.get("dialogs/add", ImageProvider.ImageSizes.SMALLICON));
        buttonPanel.add(add);
        add.setToolTipText(add.getText());
        add.addActionListener(e -> {
            PrefEntry pe = this.table.addPreference(gui);
            if (pe != null) {
                this.allData.add(pe);
                Collections.sort(this.allData);
                this.applyFilter();
            }
        });
        JButton edit = new JButton(I18n.tr("Edit", new Object[0]), ImageProvider.get("dialogs/edit", ImageProvider.ImageSizes.SMALLICON));
        buttonPanel.add(edit);
        edit.setToolTipText(edit.getText());
        edit.addActionListener(e -> {
            if (this.table.editPreference(gui)) {
                this.applyFilter();
            }
        });
        this.table.getSelectionModel().addListSelectionListener(event -> edit.setEnabled(this.table.getSelectedRowCount() == 1));
        JButton reset = new JButton(I18n.tr("Reset", new Object[0]), ImageProvider.get("undo", ImageProvider.ImageSizes.SMALLICON));
        buttonPanel.add(reset);
        reset.setToolTipText(reset.getText());
        reset.addActionListener(e -> this.table.resetPreferences(gui));
        this.table.getSelectionModel().addListSelectionListener(event -> reset.setEnabled(this.table.getSelectedRowCount() > 0));
        JButton read = new JButton(I18n.tr("Read from file", new Object[0]), ImageProvider.get("open", ImageProvider.ImageSizes.SMALLICON));
        buttonPanel.add(read);
        read.setToolTipText(read.getText());
        read.addActionListener(e -> this.readPreferencesFromXML());
        JButton export = new JButton(I18n.tr("Export selected items", new Object[0]), ImageProvider.get("save", ImageProvider.ImageSizes.SMALLICON));
        buttonPanel.add(export);
        export.setToolTipText(export.getText());
        export.addActionListener(e -> this.exportSelectedToXML());
        final JButton more = new JButton(I18n.tr("More...", new Object[0]));
        buttonPanel.add(more);
        more.setToolTipText(more.getText());
        more.addActionListener(new ActionListener(){
            private final JPopupMenu menu;
            {
                this.menu = AdvancedPreference.this.buildPopupMenu();
            }

            @Override
            public void actionPerformed(ActionEvent ev) {
                if (more.isShowing()) {
                    this.menu.show(more, 0, 0);
                }
            }
        });
        p.add((Component)buttonPanel, GBC.eol());
    }

    private void readPreferences(Preferences tmpPrefs) {
        Map<String, Setting<?>> loaded;
        Map<String, Setting<?>> orig = Preferences.main().getAllSettings();
        Map<String, Setting<?>> defaults = tmpPrefs.getAllDefaults();
        orig.remove("osm-server.password");
        defaults.remove("osm-server.password");
        if (tmpPrefs != Preferences.main()) {
            loaded = tmpPrefs.getAllSettings();
            Setting<?> pluginSetting = orig.get("plugins");
            if (pluginSetting != null) {
                loaded.put("plugins", pluginSetting);
            }
        } else {
            loaded = orig;
        }
        this.allData = this.prepareData(loaded, orig, defaults);
    }

    private static File[] askUserForCustomSettingsFiles(boolean saveFileFlag, String title) {
        FileFilter filter;
        AbstractFileChooser fc = DiskAccessAction.createAndOpenFileChooser(!saveFileFlag, !saveFileFlag, title, filter = new FileFilter(){

            @Override
            public boolean accept(File f) {
                return f.isDirectory() || Utils.hasExtension(f, "xml");
            }

            @Override
            public String getDescription() {
                return I18n.tr("JOSM custom settings files (*.xml)", new Object[0]);
            }
        }, 0, "customsettings.lastDirectory");
        if (fc != null) {
            File[] fileArray;
            if (fc.isMultiSelectionEnabled()) {
                fileArray = fc.getSelectedFiles();
            } else {
                File[] fileArray2 = new File[1];
                fileArray = fileArray2;
                fileArray2[0] = fc.getSelectedFile();
            }
            File[] sel = fileArray;
            if (sel.length == 1 && !sel[0].getName().contains(".")) {
                sel[0] = new File(sel[0].getAbsolutePath() + ".xml");
            }
            return sel;
        }
        return new File[0];
    }

    private void exportSelectedToXML() {
        ArrayList<String> keys = new ArrayList<String>();
        boolean hasLists = false;
        for (PrefEntry p : this.table.getSelectedItems()) {
            if (!(p.getValue() instanceof StringSetting)) {
                hasLists = true;
            }
            if (p.isDefault()) continue;
            keys.add(p.getKey());
        }
        if (keys.isEmpty()) {
            JOptionPane.showMessageDialog(MainApplication.getMainFrame(), I18n.tr("Please select some preference keys not marked as default", new Object[0]), I18n.tr("Warning", new Object[0]), 2);
            return;
        }
        File[] files = AdvancedPreference.askUserForCustomSettingsFiles(true, I18n.tr("Export preferences keys to JOSM customization file", new Object[0]));
        if (files.length == 0) {
            return;
        }
        int answer = 0;
        if (hasLists) {
            answer = JOptionPane.showOptionDialog(MainApplication.getMainFrame(), I18n.tr("What to do with preference lists when this file is to be imported?", new Object[0]), I18n.tr("Question", new Object[0]), 1, 3, null, new String[]{I18n.tr("Append preferences from file to existing values", new Object[0]), I18n.tr("Replace existing values", new Object[0])}, 0);
        }
        CustomConfigurator.exportPreferencesKeysToFile(files[0].getAbsolutePath(), answer == 0, keys);
    }

    private void readPreferencesFromXML() {
        File[] files = AdvancedPreference.askUserForCustomSettingsFiles(false, I18n.tr("Open JOSM customization file", new Object[0]));
        if (files.length == 0) {
            return;
        }
        Preferences tmpPrefs = new Preferences(Preferences.main());
        StringBuilder log = new StringBuilder();
        log.append("<html>");
        for (File f : files) {
            CustomConfigurator.readXML(f, tmpPrefs);
            log.append(PreferencesUtils.getLog());
        }
        log.append("</html>");
        String msg = log.toString().replace("\n", "<br/>");
        new LogShowDialog(I18n.tr("Import log", new Object[0]), I18n.tr("<html>Here is file import summary. <br/>You can reject preferences changes by pressing \"Cancel\" in preferences dialog <br/>To activate some changes JOSM restart may be needed.</html>", new Object[0]), msg).showDialog();
        this.readPreferences(tmpPrefs);
        this.allData.sort(this.customComparator);
        this.applyFilter();
    }

    private List<PrefEntry> prepareData(Map<String, Setting<?>> loaded, Map<String, Setting<?>> orig, Map<String, Setting<?>> defaults) {
        Setting<?> old;
        ArrayList<PrefEntry> data = new ArrayList<PrefEntry>();
        for (Map.Entry<String, Setting<?>> e : loaded.entrySet()) {
            Setting<?> value = e.getValue();
            old = orig.get(e.getKey());
            Setting<?> def = defaults.get(e.getKey());
            if (def == null) {
                def = value.getNullInstance();
            }
            PrefEntry en = new PrefEntry(e.getKey(), value, def, false);
            if (!Objects.equals(old, value)) {
                en.markAsChanged();
            }
            data.add(en);
        }
        for (Map.Entry<String, Setting<?>> e : defaults.entrySet()) {
            if (loaded.containsKey(e.getKey())) continue;
            PrefEntry en = new PrefEntry(e.getKey(), e.getValue(), e.getValue(), true);
            old = orig.get(e.getKey());
            if (old != null) {
                en.markAsChanged();
            }
            data.add(en);
        }
        Collections.sort(data);
        this.displayData.clear();
        this.displayData.addAll(data);
        return data;
    }

    private JPopupMenu buildPopupMenu() {
        JPopupMenu menu = new JPopupMenu();
        this.profileTypes.put(I18n.marktr("shortcut"), "shortcut\\..*");
        this.profileTypes.put(I18n.marktr("color"), "color\\..*");
        this.profileTypes.put(I18n.marktr("toolbar"), "toolbar.*");
        this.profileTypes.put(I18n.marktr("imagery"), "imagery.*");
        for (Map.Entry<String, String> e : this.profileTypes.entrySet()) {
            menu.add(new ExportProfileAction(Preferences.main(), e.getKey(), e.getValue()));
        }
        menu.addSeparator();
        menu.add(this.getProfileMenu());
        if (Logging.isDebugEnabled()) {
            menu.addSeparator();
            menu.add(new EditBoundariesAction());
        }
        menu.addSeparator();
        menu.add(new ResetPreferencesAction());
        return menu;
    }

    private JMenu getProfileMenu() {
        final JMenu p = new JMenu(I18n.tr("Load profile", new Object[0]));
        p.setIcon(ImageProvider.get("open", ImageProvider.ImageSizes.MENU));
        p.addMenuListener(new MenuListener(){

            @Override
            public void menuSelected(MenuEvent me) {
                p.removeAll();
                this.load(p, new File(".").listFiles());
                this.load(p, Config.getDirs().getPreferencesDirectory(false).listFiles());
            }

            private void load(JMenu p2, File[] files) {
                if (files != null) {
                    for (File f : files) {
                        String s = f.getName();
                        int idx = s.indexOf(95);
                        if (idx < 0) continue;
                        String t = s.substring(0, idx);
                        if (!AdvancedPreference.this.profileTypes.containsKey(t)) continue;
                        p2.add(new ImportProfileAction(s, f, t));
                    }
                }
            }

            @Override
            public void menuDeselected(MenuEvent me) {
            }

            @Override
            public void menuCanceled(MenuEvent me) {
            }
        });
        return p;
    }

    private void applyFilter() {
        this.displayData.clear();
        for (PrefEntry e : this.allData) {
            String prefKey = e.getKey();
            Setting<?> valueSetting = e.getValue();
            String prefValue = valueSetting.getValue() == null ? "" : valueSetting.getValue().toString();
            String prefKeyLower = prefKey.toLowerCase(Locale.ENGLISH);
            String prefValueLower = prefValue.toLowerCase(Locale.ENGLISH);
            boolean canHas = Pattern.compile("\\s+").splitAsStream(this.txtFilter.getText()).map(bit -> bit.toLowerCase(Locale.ENGLISH)).anyMatch(bit -> {
                switch (bit) {
                    case "changed": {
                        return e.isChanged();
                    }
                    case "modified": 
                    case "-default": {
                        return !e.isDefault();
                    }
                    case "-modified": 
                    case "default": {
                        return e.isDefault();
                    }
                }
                return prefKeyLower.contains((CharSequence)bit) || prefValueLower.contains((CharSequence)bit);
            });
            if (!canHas) continue;
            this.displayData.add(e);
        }
        if (this.table != null) {
            this.table.fireDataChanged();
        }
    }

    @Override
    public boolean ok() {
        for (PrefEntry e : this.allData) {
            if (!e.isChanged()) continue;
            Preferences.main().putSetting(e.getKey(), e.getValue().getValue() == null ? null : e.getValue());
        }
        return false;
    }

    @Override
    public String getHelpContext() {
        return HelpUtil.ht("/Preferences/Advanced");
    }

    private class ImportProfileAction
    extends AbstractAction {
        private final File file;
        private final String type;

        ImportProfileAction(String name, File file, String type) {
            super(name);
            this.file = file;
            this.type = type;
        }

        @Override
        public void actionPerformed(ActionEvent ae) {
            Preferences tmpPrefs = new Preferences(Preferences.main());
            CustomConfigurator.readXML(this.file, tmpPrefs);
            AdvancedPreference.this.readPreferences(tmpPrefs);
            String prefRegex = (String)AdvancedPreference.this.profileTypes.get(this.type);
            for (PrefEntry p : AdvancedPreference.this.allData) {
                if (!p.getKey().matches(prefRegex) || p.isDefault()) continue;
                p.reset();
            }
            AdvancedPreference.this.allData.sort(AdvancedPreference.this.customComparator);
            AdvancedPreference.this.applyFilter();
        }
    }

    private final class ResetPreferencesAction
    extends AbstractAction {
        ResetPreferencesAction() {
            super(I18n.tr("Reset preferences", new Object[0]), ImageProvider.get("undo", ImageProvider.ImageSizes.MENU));
        }

        @Override
        public void actionPerformed(ActionEvent ae) {
            if (!GuiHelper.warnUser(I18n.tr("Reset preferences", new Object[0]), "<html>" + I18n.tr("You are about to clear all preferences to their default values<br />All your settings will be deleted: plugins, imagery, filters, toolbar buttons, keyboard, etc. <br />Are you sure you want to continue?", new Object[0]) + "</html>", null, "")) {
                Preferences.main().resetToDefault();
                try {
                    Preferences.main().save();
                }
                catch (IOException | InvalidPathException e) {
                    Logging.log(Logging.LEVEL_WARN, "Exception while saving preferences:", e);
                }
                AdvancedPreference.this.readPreferences(Preferences.main());
                AdvancedPreference.this.applyFilter();
            }
        }
    }

    private static final class EditBoundariesAction
    extends AbstractAction {
        EditBoundariesAction() {
            super(I18n.tr("Edit boundaries", new Object[0]), ImageProvider.get("dialogs/edit", ImageProvider.ImageSizes.MENU));
        }

        @Override
        public void actionPerformed(ActionEvent ae) {
            DataSet dataSet = Territories.getOriginalDataSet();
            MainLayerManager layerManager = MainApplication.getLayerManager();
            if (layerManager.getLayersOfType(OsmDataLayer.class).stream().noneMatch(l -> dataSet.equals(l.getDataSet()))) {
                layerManager.addLayer(new UnclearableOsmDataLayer(dataSet, I18n.tr("Internal JOSM boundaries", new Object[0])));
            }
        }
    }

    private static class UnclearableOsmDataLayer
    extends OsmDataLayer {
        UnclearableOsmDataLayer(DataSet data, String name) {
            super(data, name, null);
        }

        @Override
        public void clear() {
        }
    }

    public static class Factory
    implements PreferenceSettingFactory {
        @Override
        public PreferenceSetting createPreferenceSetting() {
            return new AdvancedPreference();
        }
    }
}

