% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BranchGLMTable.R
\name{Table}
\alias{Table}
\alias{Table.numeric}
\alias{Table.BranchGLM}
\title{Confusion Matrix}
\usage{
Table(object, ...)

\method{Table}{numeric}(object, y, cutoff = 0.5, ...)

\method{Table}{BranchGLM}(object, cutoff = 0.5, ...)
}
\arguments{
\item{object}{a \code{BranchGLM} object or a numeric vector.}

\item{...}{further arguments passed to other methods.}

\item{y}{observed values, can be a numeric vector of 0s and 1s, a two-level factor vector, or 
a logical vector.}

\item{cutoff}{cutoff for predicted values, the default is 0.5.}
}
\value{
A \code{BranchGLMTable} object which is a list with the following components
\item{\code{table}}{ a matrix corresponding to the confusion matrix}
\item{\code{accuracy}}{ a number corresponding to the accuracy}
\item{\code{sensitivity}}{ a number corresponding to the sensitivity}
\item{\code{specificity}}{ a number corresponding to the specificity}
\item{\code{PPV}}{ a number corresponding to the positive predictive value}
\item{\code{levels}}{ a vector corresponding to the levels of the response variable}
}
\description{
Creates confusion matrix and calculates related measures.
}
\examples{
Data <- ToothGrowth
Fit <- BranchGLM(supp ~ ., data = Data, family = "binomial", link = "logit")
Table(Fit)
}
