% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BranchGLMTable.R
\name{plot.BranchGLMROC}
\alias{plot.BranchGLMROC}
\title{Plot Method for BranchGLMROC Objects}
\usage{
\method{plot}{BranchGLMROC}(x, xlab = "1 - Specificity", ylab = "Sensitivity", type = "l", ...)
}
\arguments{
\item{x}{a \code{BranchGLMROC} object.}

\item{xlab}{label for the x-axis.}

\item{ylab}{label for the y-axis.}

\item{type}{what type of plot to draw, see more details at \link{plot.default}.}

\item{...}{further arguments passed to \link{plot.default}.}
}
\value{
This only produces a plot, nothing is returned.
}
\description{
This plots a ROC curve.
}
\examples{
Data <- ToothGrowth
Fit <- BranchGLM(supp ~ ., data = Data, family = "binomial", link = "logit")
MyROC <- ROC(Fit)
plot(MyROC)
}
