% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/exports.R
\docType{methods}
\name{quad_over_lin}
\alias{quad_over_lin}
\title{Quadratic over Linear}
\usage{
quad_over_lin(x, y)
}
\arguments{
\item{x}{An \linkS4class{Expression}, vector, or matrix.}

\item{y}{A scalar \linkS4class{Expression} or numeric constant.}
}
\value{
An \linkS4class{Expression} representing the quadratic over linear function value evaluated at the input.
}
\description{
\eqn{\sum_{i,j} X_{i,j}^2/y}.
}
\examples{
x <- Variable(3,2)
y <- Variable()
val <- cbind(c(-1,2,-2), c(-1,2,-2))
prob <- Problem(Minimize(quad_over_lin(x,y)), list(x == val, y <= 2))
result <- solve(prob)
result$value
result$getValue(x)
result$getValue(y)
}
