% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DPtree.R
\name{DPTreePosterior}
\alias{DPTreePosterior}
\title{D-P tree posterior updating from a single copula observation.}
\usage{
DPTreePosterior(x, prior, w = 1)
}
\arguments{
\item{x}{An array of length 2. Single copula data observation.
Each element should be between 0 and 1.}

\item{prior}{A list. Should be in same format as returned from  \code{DPTreePrior}.}

\item{w}{A positive number. Weight of data for posterior updating. Default 1.}
}
\value{
A list.
\item{a}{An array containing the hyperparameters of D-P trees.}
}
\description{
\code{DPTreePosterior} returns
the D-P tree posterior given input copula data.
}
\examples{
nsim = 1
rho = 0.9
data1 <- MASS::mvrnorm(n=nsim, mu=rep(0, 2), Sigma=matrix(c(1, rho, rho, 1), 2, 2))
data2 <- stats::pnorm(data1)
DPTreePosterior(x=data2, prior=DPTreePrior(m=4, z=1))
}
\references{
\insertRef{DPtree}{DPtree}
}
