% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/results.R
\name{summary.gmjmcmc_merged}
\alias{summary.gmjmcmc_merged}
\title{Function to print a quick summary of the results}
\usage{
\method{summary}{gmjmcmc_merged}(object, tol = 1e-04, labels = FALSE, effects = NULL, ...)
}
\arguments{
\item{object}{The results to use}

\item{tol}{The tolerance to use as a threshold when reporting the results.}

\item{labels}{Should the covariates be named, or just referred to as their place in the data.frame.}

\item{effects}{Quantiles for posterior modes of the effects across models to be reported, if either effects are NULL or if labels are NULL, no effects are reported.}

\item{...}{Not used.}
}
\value{
A data frame containing the following columns:
\item{feats.strings}{Character representation of the features ordered by marginal probabilities.}
\item{marg.probs}{Marginal probabilities corresponding to the ordered feature strings.}
}
\description{
Function to print a quick summary of the results
}
\examples{
result <- gmjmcmc.parallel(
 runs = 1,
 cores = 1,
 list(populations = "best", complex.measure = 2, tol = 0.0000001),
 matrix(rnorm(600), 100),
 P = 2,
 gaussian.loglik,
 loglik.alpha = gaussian.loglik.alpha,
 c("p0", "exp_dbl")
)
summary(result)

}
