% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/glm.summary.R
\name{glm.summary}
\alias{glm.summary}
\title{Summarize regression output from generalized linear models.}
\usage{
glm.summary(in.object, alpha = 0.05)
}
\arguments{
\item{in.object}{The regression output from glm().}

\item{alpha}{A parameter defaulted to 0.05.}
}
\value{
The output is a matrix.
}
\description{
An alternative to the summary() function.
}
\examples{
data(campaign)
attach(campaign)
cmpgn.out <- glm(TOTCONTR ~ CANDGENDER + PARTY + INCUMCHALL + HISPPCT,
              family=Gamma(link = 'log'), data=campaign)
glm.summary(cmpgn.out)

}
