% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/glm.vc.R
\name{glm.vc}
\alias{glm.vc}
\title{Compute variance-covariance matrix.}
\usage{
glm.vc(obj)
}
\arguments{
\item{obj}{The regression output from glm().}
}
\value{
The output is a matrix.
}
\description{
Calculate the (unscaled) variance-covariance matrix from a generalized linear model regression output. Used in `GLMpack` within the function `glm.summary()`.
}
\examples{
data(campaign)
attach(campaign)
cmpgn.out <- glm(TOTCONTR ~ CANDGENDER + PARTY + INCUMCHALL + HISPPCT,
              family=Gamma(link = 'log'), data=campaign)
glm.vc(cmpgn.out)

}
