% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MassSpecWavelet-package.R
\docType{package}
\name{MassSpecWavelet-package}
\alias{MassSpecWavelet}
\alias{MassSpecWavelet-package}
\title{Peak detection of mass spectrum by Wavelet transform based methods}
\description{
MassSpecWavelet R package is aimed to detect peaks on Mass Spectrometry (MS)
data using Continuous Wavelet Transform (CWT).
}
\examples{

data(exampleMS)
SNR.Th <- 3
peakInfo <- peakDetectionCWT(exampleMS, SNR.Th = SNR.Th)
majorPeakInfo <- peakInfo$majorPeakInfo
peakIndex <- majorPeakInfo$peakIndex
plotPeak(exampleMS, peakIndex, main = paste("Identified peaks with SNR >", SNR.Th))

}
\references{
Du, P., Kibbe, W.A. and Lin, S.M. (2006) Improved peak detection
in mass spectrum by incorporating continuous wavelet transform-based pattern
matching, Bioinformatics, 22, 2059-2065.
}
\seealso{
Useful links:
\itemize{
  \item \url{https://github.com/zeehio/MassSpecWavelet}
  \item Report bugs at \url{http://github.com/zeehio/MassSpecWavelet/issues}
}

}
\author{
Pan Du, Simon Lin
}
\keyword{package}
