% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/localMaximum.R
\name{localMaximum}
\alias{localMaximum}
\title{Identify local maximum within a slide window.}
\usage{
localMaximum(x, winSize = 5)
}
\arguments{
\item{x}{a vector represents a signal profile}

\item{winSize}{the slide window size, 5 by default.}
}
\value{
Return a vector with the same length of the input x. The position of
local maximum is set as \code{1L}, \code{0L} else where.
}
\description{
The simplest local maximum detection using a sliding window searches for
maxima in a window of a given size, and slides that window across the signal,
shifting it one position at a time.
}
\details{
The default implementation found here shifts the window by half of its size
instead of by one position at a time. This makes the implementation faster,
at the expense of not being able to detect peaks that are too close to each other,
if they appear in some positions with respect to the windows.

Additionally, this implementation removes all instances of peaks found at
a distance less than the window size

Experimentally, we are exploring other algorithms for local maxima detection.
These algorithms can be chosen setting the \code{"MassSpecWavelet.localMaximum.algorithm"}
option. See the \code{"Finding local maxima"} vignette for further details.
}
\examples{

x <- rnorm(200)
lmax <- localMaximum(x, 5)
maxInd <- which(lmax > 0)
plot(x, type = "l")
points(maxInd, x[maxInd], col = "red")

}
\seealso{
\code{\link[=getLocalMaximumCWT]{getLocalMaximumCWT()}}
}
\author{
Pan Du and Sergio Oller
}
\keyword{methods}
