% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cwt.R
\name{prepareWavelets}
\alias{prepareWavelets}
\title{Prepare daughter wavelets for faster CWT}
\usage{
prepareWavelets(
  mslength,
  scales = c(1, seq(2, 30, 2), seq(32, 64, 4)),
  wavelet = "mexh",
  wavelet_xlimit = 8,
  wavelet_length = 1024L,
  extendLengthScales = TRUE
)
}
\arguments{
\item{mslength}{Length of the signal to transform}

\item{scales}{a vector represents the scales at which to perform CWT. See
the Details section. Additionally, a \code{prepared_wavelets} object
is also accepted (see \code{\link[=prepareWavelets]{prepareWavelets()}}).}

\item{wavelet}{The wavelet base, Mexican Hat by default. User can provide
wavelet \code{Psi(x)} as a form of two row matrix. The first row is the \code{x} value,
and the second row is \code{Psi(x)} corresponding to \code{x}.}

\item{wavelet_xlimit}{The mother wavelet will be evaluated between these limits. Ignored if \code{wavelet} is a matrix.}

\item{wavelet_length}{The number of points of the mother wavelet. Ignored if \code{wavelet} is a matrix}

\item{extendLengthScales}{A logical value. If the signal is too short, we may
need to pad it to convolve it with larger daughter wavelets. Set this to \code{TRUE} to let
scales be used to determine the padding length. It's set to \code{FALSE} by default
to preserve backwards compatibility.}
}
\value{
A \code{prepared_wavelets} object.
}
\description{
Prepare daughter wavelets for faster CWT
}
\examples{
x <- runif(2000)
scales <- c(1, 2, 4, 8)
prep_wavelets <- prepareWavelets(length(x), scales = scales)
wCoefs <- cwt(x, prep_wavelets)
}
\seealso{
cwt
}
