% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/chac.R
\name{select}
\alias{select}
\alias{select.chac}
\title{Clustering selection}
\usage{
select(
  x,
  type = c("capushe", "bstick"),
  k.max = NULL,
  graph = FALSE,
  pct = 0.15
)
}
\arguments{
\item{x}{an object of class 'chac'}

\item{type}{model selection approach between slope heuristic 
(\code{"capushe"}) and broken stick approach (\code{"bstick"})}

\item{k.max}{maximum number of clusters that can be selected. Default to 
\code{NULL}, in which case it is set to 
\eqn{\min(\max(100, \frac{n}{\log(n)}), \frac{n}{2})} where \eqn{n} is the
number of objects to be clustered for capushe and to \eqn{n} for the broken
stick model}

\item{graph}{logical. Whether the diagnostic plot for the capushe selection
is displayed or not. Default to \code{FALSE}}

\item{pct}{minimum percentage of points for the plateau selection in 
capushe selection. See \code{\link[capushe]{DDSE}} for further details}
}
\value{
The function returns the clustering selected by the slope heuristic,
as implemented in the R package \code{capushe}.
}
\description{
Clustering selection from a chac object with the slope heuristic
or the broken stick heuristic
}
\examples{
\dontrun{if (require("HiTC", quietly = TRUE)) {
  load(system.file("extdata", "hic_imr90_40_XX.rda", package = "adjclust"))
  res <- hicClust(hic_imr90_40_XX, log = TRUE)
  selected.capushe <- select(res)
  table(selected.capushe)
  selected.bs <- select(res, type = "bstick")
  table(selected.bs)
}}

res <- adjClust(dist(iris[, 1:4]))
select.clust <- select(res, "bs")
table(select.clust)

}
\references{
Baudry J.P., Maugis C., and Michel B. (2012). Slope heuristics: 
overview and implementation. \emph{Statistics and Computing}, \strong{22}(2),
355-470.
MacArthur, R.H. (1957) On the relative abundance of bird species. 
\emph{Proceedings of the National Academy of Sciences}, \strong{43}, 293-295.
}
