% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GRanges_tidiers.R
\name{tidy.GRanges}
\alias{tidy.GRanges}
\alias{tidy.GRangesList}
\alias{glance.GRanges}
\alias{glance.GRangesList}
\title{Tidying methods for GRanges and GRangesList objects.}
\usage{
\method{tidy}{GRanges}(x, ...)

\method{tidy}{GRangesList}(x, ...)

\method{glance}{GRanges}(x, ...)

\method{glance}{GRangesList}(x, ...)
}
\arguments{
\item{x}{GRanges or GRangesList object}

\item{...}{Not used.}
}
\value{
All tidying methods return a \code{data.frame} without rownames. \code{tidy} returns one row for each range, which contains
\itemize{
\item{start} of the range
\item{end} of the range
\item{width} (or length) of the range
\item{names} of the range
\item{strand}
\item{seqname} Name of the sequence from which the range comes (usually the chromosome)
\item{metadata} Any included metadata, (ie, score, GC content)
}
For \code{GRangesList}, there will also be a column representing which group the ranges comes from.
\code{glance} returns a \code{data.frame} with the number of ranges, the number of sequences, and the number of groups (if applicable).
}
\description{
Tidying methods for GRanges and GRangesList objects.
}
\examples{
if (require("GenomicRanges", "airway")) {
data(airway)

# GRangesList object
air_gr <- rowRanges(airway)

tidy(air_gr)
glance(air_gr)

# GRanges object
air_gr <- rowRanges(airway)@unlistData

tidy(air_gr)
glance(air_gr)


}
}
