#' ChatGPT: Document Code (in roxygen2 format)
#'
#' @param code The code to be documented by ChatGPT. If not provided, it will use what's copied on
#'   the clipboard.
#'
#' @examples
#' \dontrun{
#' cat(document_code("square_numbers <- function(numbers) numbers ** 2"))
#' }
#'
#' @importFrom clipr read_clip
#'
#' @return A character value with the response generated by ChatGPT.
#'
#' @export
#'
document_code <- function(code = clipr::read_clip(allow_non_interactive = TRUE)) {
  code <- paste(gsub('"', "'", code), collapse = "\n")
  prompt <- paste0('Document, in roxygen2 format, this R function: "', code, '"')
  parse_response(gpt_get_completions(prompt))
}
