% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/common.R
\name{cloud_prep_ls}
\alias{cloud_prep_ls}
\title{Prepare ls output}
\usage{
cloud_prep_ls(data, path, recursive, full_names)
}
\arguments{
\item{data}{ls dataframe assembled internally by a cloud_ls_* function}

\item{path}{path that was used in a cloud_ls_* function}

\item{recursive}{(logical) If \code{TRUE}, lists contents recursively in all
nested subfolders. Default is \code{FALSE}.}

\item{full_names}{(logical) If \code{TRUE}, folder path is appended to object
names to give a relative file path.}
}
\value{
Transformed \code{data}.
}
\description{
Under the hood all ls functions (s3, drive, local) obtain
information about folder content recursively regardless of \code{recursive}
parameter. This is needed to be able to calculate last modified time and
size for folders in case if \code{recursive} is set to \code{FALSE}. The content is
presented in a form of a dataframe similar to what you'd see if you run an
ls function with \code{recursive = TRUE} and \code{full_names = FALSE}.

This function takes such a dataframe from this point and:
\enumerate{
\item Summarizes it to non-recursive output if \code{recursive} is \code{FALSE}.
\item Appends \code{path} to names if \code{full_names} is \code{TRUE}.
\item Writes full names to names of the \code{name} column regardless of the
\code{full_names} parameter.
\item Evaluates the \code{type} column.
}
}
\keyword{internal}
