% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fit.R
\name{fit-method-grad_log_prob}
\alias{fit-method-grad_log_prob}
\alias{grad_log_prob}
\title{Calculate the log-probability and the gradient w.r.t. each input for a
given vector of unconstrained parameters}
\usage{
grad_log_prob(unconstrained_variables, jacobian_adjustment = TRUE)
}
\arguments{
\item{unconstrained_variables}{(numeric) A vector of unconstrained parameters
to be passed to \code{grad_log_prob}.}

\item{jacobian_adjustment}{(logical) Whether to include the log-density
adjustments from un/constraining variables.}
}
\description{
The \verb{$grad_log_prob()} method provides access to the Stan
model's \code{log_prob} function and its derivative.
}
\examples{
\dontrun{
fit_mcmc <- cmdstanr_example("logistic", method = "sample", force_recompile = TRUE)
fit_mcmc$init_model_methods()
fit_mcmc$grad_log_prob(unconstrained_variables = c(0.5, 1.2, 1.1, 2.2))
}

}
\seealso{
\code{\link[=log_prob]{log_prob()}}, \code{\link[=grad_log_prob]{grad_log_prob()}}, \code{\link[=constrain_variables]{constrain_variables()}},
\code{\link[=unconstrain_variables]{unconstrain_variables()}}, \code{\link[=unconstrain_draws]{unconstrain_draws()}}, \code{\link[=variable_skeleton]{variable_skeleton()}},
\code{\link[=hessian]{hessian()}}
}
