% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fit.R
\name{fit-method-output}
\alias{fit-method-output}
\alias{output}
\title{Access console output}
\usage{
output(id = NULL)
}
\arguments{
\item{id}{(integer) The chain id. Ignored if the model was not fit using
MCMC.}
}
\description{
For MCMC, the \verb{$output()} method returns the stdout and stderr
of all chains as a list of character vectors if \code{id=NULL}. If the \code{id}
argument is specified it instead pretty prints the console output for a
single chain.

For optimization and variational inference \verb{$output()} just pretty prints
the console output.
}
\examples{
\dontrun{
fit_mcmc <- cmdstanr_example("logistic", method = "sample")
fit_mcmc$output(1)
out <- fit_mcmc$output()
str(out)

fit_mle <- cmdstanr_example("logistic", method = "optimize")
fit_mle$output()

fit_vb <- cmdstanr_example("logistic", method = "variational")
fit_vb$output()
}

}
\seealso{
\code{\link{CmdStanMCMC}}, \code{\link{CmdStanMLE}}, \code{\link{CmdStanVB}}, \code{\link{CmdStanGQ}}
}
