% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/install.R
\name{install_cmdstan}
\alias{install_cmdstan}
\alias{rebuild_cmdstan}
\alias{cmdstan_make_local}
\alias{check_cmdstan_toolchain}
\title{Install CmdStan or clean and rebuild an existing installation}
\usage{
install_cmdstan(
  dir = NULL,
  cores = getOption("mc.cores", 2),
  quiet = FALSE,
  overwrite = FALSE,
  timeout = 1200,
  version = NULL,
  release_url = NULL,
  cpp_options = list(),
  check_toolchain = TRUE,
  wsl = FALSE
)

rebuild_cmdstan(
  dir = cmdstan_path(),
  cores = getOption("mc.cores", 2),
  quiet = FALSE,
  timeout = 600
)

cmdstan_make_local(dir = cmdstan_path(), cpp_options = NULL, append = TRUE)

check_cmdstan_toolchain(fix = FALSE, quiet = FALSE)
}
\arguments{
\item{dir}{(string) The path to the directory in which to install CmdStan.
The default is to install it in a directory called \code{.cmdstan} within the
user's home directory (i.e, \code{file.path(Sys.getenv("HOME"), ".cmdstan")}).}

\item{cores}{(integer) The number of CPU cores to use to parallelize building
CmdStan and speed up installation. If \code{cores} is not specified then the
default is to look for the option \code{"mc.cores"}, which can be set for an
entire \R session by \code{options(mc.cores=value)}. If the \code{"mc.cores"} option
has not been set then the default is \code{2}.}

\item{quiet}{(logical) For \code{install_cmdstan()}, should the verbose output
from the system processes be suppressed when building the CmdStan binaries?
The default is \code{FALSE}. For \code{check_cmdstan_toolchain()}, should the
function suppress printing informational messages? The default is \code{FALSE}.
If \code{TRUE} only errors will be printed.}

\item{overwrite}{(logical) Should CmdStan still be downloaded and installed
even if an installation of the same version is found in \code{dir}? The default
is \code{FALSE}, in which case an informative error is thrown instead of
overwriting the user's installation.}

\item{timeout}{(positive real) Timeout (in seconds) for the build stage of
the installation.}

\item{version}{(string) The CmdStan release version to install. The default
is \code{NULL}, which downloads the latest stable release from
\url{https://github.com/stan-dev/cmdstan/releases}.}

\item{release_url}{(string) The URL for the specific CmdStan release or
release candidate to install. See \url{https://github.com/stan-dev/cmdstan/releases}.
The URL should point to the tarball (\code{.tar.gz.} file) itself, e.g.,
\code{release_url="https://github.com/stan-dev/cmdstan/releases/download/v2.25.0/cmdstan-2.25.0.tar.gz"}.
If both \code{version} and \code{release_url} are specified then \code{version} will be used.}

\item{cpp_options}{(list) Any makefile flags/variables to be written to
the \code{make/local} file. For example, \code{list("CXX" = "clang++")} will force
the use of clang for compilation.}

\item{check_toolchain}{(logical) Should \code{install_cmdstan()} attempt to check
that the required toolchain is installed and properly configured. The
default is \code{TRUE}.}

\item{wsl}{(logical) Should CmdStan be installed and run through the Windows
Subsystem for Linux (WSL). The default is \code{FALSE}.}

\item{append}{(logical) For \code{cmdstan_make_local()}, should the listed
makefile flags be appended to the end of the existing \code{make/local} file?
The default is \code{TRUE}. If \code{FALSE} the file is overwritten.}

\item{fix}{For \code{check_cmdstan_toolchain()}, should CmdStanR attempt to fix
any detected toolchain problems? Currently this option is only available on
Windows. The default is \code{FALSE}, in which case problems are only reported
along with suggested fixes.}
}
\value{
For \code{cmdstan_make_local()}, if \code{cpp_options=NULL} then the existing
contents of \code{make/local} are returned without writing anything, otherwise
the updated contents are returned.
}
\description{
The \code{install_cmdstan()} function attempts to download and
install the latest release of \href{https://github.com/stan-dev/cmdstan/releases/latest}{CmdStan}.
Installing a previous release or a new release candidate is also possible
by specifying the \code{version} or \code{release_url} argument.
See the first few sections of the CmdStan
\href{https://mc-stan.org/docs/cmdstan-guide/cmdstan-installation.html}{installation guide}
for details on the C++ toolchain required for installing CmdStan.

The \code{rebuild_cmdstan()} function cleans and rebuilds the CmdStan
installation. Use this function in case of any issues when compiling models.

The \code{cmdstan_make_local()} function is used to read/write makefile flags
and variables from/to the \code{make/local} file of a CmdStan installation.
Writing to the \code{make/local} file can be used to permanently add makefile
flags/variables to an installation. For example adding specific compiler
switches, changing the C++ compiler, etc. A change to the \code{make/local} file
should typically be followed by calling \code{rebuild_cmdstan()}.

The \code{check_cmdstan_toolchain()} function attempts to check for the required
C++ toolchain. It is called internally by \code{install_cmdstan()} but can also
be called directly by the user.
}
\examples{
\dontrun{
check_cmdstan_toolchain()

# install_cmdstan(cores = 4)

cpp_options <- list(
  "CXX" = "clang++",
  "CXXFLAGS+= -march=native",
  PRECOMPILED_HEADERS = TRUE
)
# cmdstan_make_local(cpp_options = cpp_options)
# rebuild_cmdstan()
}

}
