% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/distributions.R
\name{TRUNCATED}
\alias{TRUNCATED}
\alias{new_TRUNCATED}
\title{Factory for a TRUNCATED distribution object}
\usage{
new_TRUNCATED(p_distribution, p_min = -Inf, p_max = Inf)
}
\arguments{
\item{p_distribution}{An object of class DISTRIBUTION to truncate}

\item{p_min}{A numeric that set the lower limit of the distribution}

\item{p_max}{A numeric that set the upper limit of the distribution}
}
\value{
An object of class \code{DISTRIBUTION},
 \code{p_distribution$distribution}, \code{TRUNCATED}
}
\description{
Returns an TRUNCATED distribution object that limits the values that are
generated by the distribution to be in the limits \code{p_min, p_max}
}
\note{
The expected value of a truncated distribution could be very
different from the expected value of the unrestricted distribution. Be
careful as the \code{oval} field is not changed and may not represent
any more the expected value of the distribution.

If the distribution is multidimensional, the limits will apply to all dimensions.
}
\examples{
myDistr <- new_TRUNCATED(p_distribution = new_NORMAL(0,1), p_min = -1, p_max = 1)
myDistr$rfunc(10)
}
\author{
John J. Aponte
}
