% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/face-spatial-temporal.R
\name{face_temporal}
\alias{face_temporal}
\alias{face_temporal.temporal_cubble_df}
\alias{face_temporal.spatial_cubble_df}
\alias{face_spatial}
\alias{face_spatial.spatial_cubble_df}
\alias{face_spatial.temporal_cubble_df}
\title{Pivot a cubble object between the nested/long (spatial/temporal) form}
\usage{
face_temporal(data, col)

\method{face_temporal}{temporal_cubble_df}(data, col)

\method{face_temporal}{spatial_cubble_df}(data, col)

face_spatial(data)

\method{face_spatial}{spatial_cubble_df}(data)

\method{face_spatial}{temporal_cubble_df}(data)
}
\arguments{
\item{data}{a cubble object}

\item{col}{a character (or a symbol), the list column to be expanded,
\code{col} is required to be specified if there are more than one list column
and the list column name is not \code{ts}.}
}
\value{
a cubble object
}
\description{
While \code{face_temporal()} switches a cubble object into a long cubble,
suitable for temporal operations, \code{face_spatial()} turns a long cubble back
into a nest cubble for spatial operations. The two operations are exact
inverse.
}
\examples{
cb_long <- climate_mel |> face_temporal()
cb_back <- cb_long |> face_spatial()
identical(climate_mel, cb_back)
}
\references{
\href{doi:10.18637/jss.v110.i07}{cubble: An R Package for Organizing and Wrangling Multivariate Spatio-Temporal Data}
}
