% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/model.R
\name{model.frame.dfidx}
\alias{model.frame.dfidx}
\alias{model.matrix.dfidx}
\alias{print.dfidx_matrix}
\title{model.frame/matrix for dfidx objects}
\usage{
\method{model.frame}{dfidx}(
  formula,
  data = NULL,
  ...,
  lhs = NULL,
  rhs = NULL,
  dot = "previous",
  alt.subset = NULL,
  reflevel = NULL,
  balanced = FALSE
)

\method{model.matrix}{dfidx}(object, ..., lhs = NULL, rhs = 1, dot = "separate")

\method{print}{dfidx_matrix}(x, ..., n = 10L)
}
\arguments{
\item{formula}{a \code{dfidx}}

\item{data}{a \code{formula}}

\item{..., lhs, rhs, dot}{see the \code{Formula} method}

\item{alt.subset}{a subset of levels for the second index}

\item{reflevel}{a user-defined first level for the second index}

\item{balanced}{a boolean indicating if the resulting data.frame
has to be balanced or not}

\item{object}{a dfidx object}

\item{x}{a model matrix}

\item{n}{the number of lines to print}
}
\value{
a \code{dfidx} object for the \code{model.frame} method and a matrix
for the \code{model.matrix} method.
}
\description{
Specific model.frame/matrix are provided for dfidx objects. This
leads to an unusual order of arguments compared to the
usage. Actually, the first two arguments of the model.frame method
are a dfidx and a formula and the only main argument of the
model.matrix is a dfidx which should be the result of a call to the
model.frame method, i.e. it should have a term attribute.
}
\examples{
mn <- dfidx(munnell)
mf <- model.frame(mn, gsp ~ privatecap | publiccap + utilities | unemp + labor)
model.matrix(mf, rhs = 1)
model.matrix(mf, rhs = 2)
model.matrix(mf, rhs = 1:3)
}
\author{
Yves Croissant
}
