% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dpseg.R
\name{predict.dpseg}
\alias{predict.dpseg}
\title{Predict method for `dpseg` segmentations}
\usage{
\method{predict}{dpseg}(object, xout, ...)
}
\arguments{
\item{object}{result object returned by function
\code{\link{dpseg}}}

\item{xout}{new x-values at which to predict \eqn{\hat{y}}}

\item{...}{not used}
}
\value{
Returns predicted linear segments as x,y coordinates
    (\code{grDevices::xy.coords}) at \code{xout}.
}
\description{
Predicted values based on a data segmentation model from
\code{\link{dpseg}}.
}
\examples{
x <- oddata$Time
y <- log(oddata$A5)
segs <- dpseg(x=x, y=y, P=0.0001)

## predict method
plot(x=x, y=y, pch=19, cex=0.5)
lines(predict(segs), col=2, lwd=2)
}
