% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spectra.R
\name{get_en}
\alias{get_en}
\title{get energy from the dualtree transform}
\usage{
get_en(dt, correct = "none", N = ncol(dt))
}
\arguments{
\item{dt}{array of \code{ J x nx x ny x 6 } complex wavelet coefficients, output of \code{dtcwt(..., dec=FALSE)}}

\item{correct}{type of correction, either \code{"b"} or \code{"b_bp"}, any other value results in no correction at all.}

\item{N}{the smallest whole power of two larger than or equal to the dimensions of the input image, usually just \code{ncol(dt)}}
}
\value{
an array of the same dimensions as \code{dt}
}
\description{
square the wavelet coefficients and apply the bias correction
}
\details{
The bias correction matrix should correspond to the filter bank used in the transform, for details on the matrices see \code{\link{A}}.
}
\references{
Nelson, J. D. B., A. J. Gibberd, C. Nafornita, and N. Kingsbury (2018) <doi:10.1007/s11222-017-9784-0>
}
\seealso{
\code{\link{A}}
}
