% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/echoice2.R
\name{ec_dem_eval}
\alias{ec_dem_eval}
\title{Evaluate (hold-out) demand predictions}
\usage{
ec_dem_eval(de)
}
\arguments{
\item{de}{demand draws (output from vd_dem_x function)}
}
\value{
Predictive fit statistics (MAE, MSE, RAE, bias, hit-probability)

data(icecream)
#run MCMC sampler (use way more than 50 draws for actual use)
icecream_est <- icecream \%>\% dplyr::filter(id<100) \%>\% vd_est_vdm(R=20, keep=1, cores=2)
#Generate demand predictions
icecream_predicted_demand=
icecream \%>\% dplyr::filter(id<100) \%>\%
vd_dem_vdm(icecream_est)
#evaluate in-sample fit (note: too few draws for good results)
ec_dem_eval(icecream_predicted_demand)
}
\description{
This function obtains proper posterior fit statistics.
It computes the difference between true demand and each draw from the demand posterior.
Then, fit statistics are obtained.
}
