% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ets.R
\name{ETS}
\alias{ETS}
\alias{report.ETS}
\title{Exponential smoothing state space model}
\usage{
ETS(
  formula,
  opt_crit = c("lik", "amse", "mse", "sigma", "mae"),
  nmse = 3,
  bounds = c("both", "usual", "admissible"),
  ic = c("aicc", "aic", "bic"),
  restrict = TRUE,
  ...
)
}
\arguments{
\item{formula}{Model specification (see "Specials" section).}

\item{opt_crit}{The optimization criterion. Defaults to the log-likelihood
\code{"lik"}, but can also be set to \code{"mse"} (Mean Square Error), \code{"amse"}
(Average MSE over first \code{nmse} forecast horizons), \code{"sigma"} (Standard
deviation of residuals), or \code{"mae"} (Mean Absolute Error).}

\item{nmse}{If \code{opt_crit == "amse"}, \code{nmse} provides the number of steps for
average multistep MSE (\verb{1<=nmse<=30}).}

\item{bounds}{Type of parameter space to impose: \code{"usual"} indicates
all parameters must lie between specified lower and upper bounds;
\code{"admissible"} indicates parameters must lie in the admissible space;
\code{"both"} (default) takes the intersection of these regions.}

\item{ic}{The information criterion used in selecting the model.}

\item{restrict}{If TRUE (default), the models with infinite variance will not
be allowed. These restricted model components are AMM, AAM, AMA, and MMA.}

\item{...}{Other arguments}
}
\value{
A model specification.
}
\description{
Returns ETS model specified by the formula.
}
\details{
Based on the classification of methods as described in Hyndman et al (2008).

The methodology is fully automatic. The model is chosen automatically if not
specified. This methodology performed extremely well on the M3-competition
data. (See Hyndman, et al, 2002, below.)
}
\section{Specials}{


The \emph{specials} define the methods and parameters for the components (error, trend, and seasonality) of an ETS model. If more than one method is specified, \code{ETS} will consider all combinations of the specified models and select the model which best fits the data (minimising \code{ic}). The method argument for each specials have reasonable defaults, so if a component is not specified an appropriate method will be chosen automatically.

There are a couple of limitations to note about ETS models:
\itemize{
\item It does not support exogenous regressors.
\item It does not support missing values. You can complete missing values in the data with imputed values (e.g. with \code{\link[tidyr:fill]{tidyr::fill()}}, or by fitting a different model type and then calling \code{\link[fabletools:reexports]{fabletools::interpolate()}}) before fitting the model.
}

\subsection{error}{
The \code{error} special is used to specify the form of the error term.
\preformatted{
error(method = c("A", "M"))
}

\tabular{ll}{
\code{method}     \tab The form of the error term: either additive ("A") or multiplicative ("M"). If the error is multiplicative, the data must be non-negative. All specified methods are tested on the data, and the one that gives the best fit (lowest \code{ic}) will be kept.
}
}

\subsection{trend}{
The \code{trend} special is used to specify the form of the trend term and associated parameters.
\preformatted{
trend(method = c("N", "A", "Ad"),
      alpha = NULL, alpha_range = c(1e-04, 0.9999),
      beta = NULL, beta_range = c(1e-04, 0.9999),
      phi = NULL, phi_range = c(0.8, 0.98))
}

\tabular{ll}{
\code{method}     \tab The form of the trend term: either none ("N"), additive ("A"), multiplicative ("M") or damped variants ("Ad", "Md"). All specified methods are tested on the data, and the one that gives the best fit (lowest \code{ic}) will be kept.\cr
\code{alpha}      \tab The value of the smoothing parameter for the level. If \code{alpha = 0}, the level will not change over time. Conversely, if \code{alpha = 1} the level will update similarly to a random walk process. \cr
\code{alpha_range} \tab If \code{alpha=NULL}, \code{alpha_range} provides bounds for the optimised value of \code{alpha}.\cr
\code{beta}       \tab The value of the smoothing parameter for the slope. If \code{beta = 0}, the slope will not change over time. Conversely, if \code{beta = 1} the slope will have no memory of past slopes. \cr
\code{beta_range}  \tab If \code{beta=NULL}, \code{beta_range} provides bounds for the optimised value of \code{beta}.\cr
\code{phi}        \tab The value of the dampening parameter for the slope. If \code{phi = 0}, the slope will be dampened immediately (no slope). Conversely, if \code{phi = 1} the slope will not be dampened. \cr
\code{phi_range}   \tab If \code{phi=NULL}, \code{phi_range} provides bounds for the optimised value of \code{phi}.
}
}

\subsection{season}{
The \code{season} special is used to specify the form of the seasonal term and associated parameters. To specify a nonseasonal model you would include \code{season(method = "N")}.
\preformatted{
season(method = c("N", "A", "M"), period = NULL,
       gamma = NULL, gamma_range = c(1e-04, 0.9999))
}

\tabular{ll}{
\code{method}     \tab The form of the seasonal term: either none ("N"), additive ("A") or multiplicative ("M"). All specified methods are tested on the data, and the one that gives the best fit (lowest \code{ic}) will be kept.\cr
\code{period}     \tab The periodic nature of the seasonality. This can be either a number indicating the number of observations in each seasonal period, or text to indicate the duration of the seasonal window (for example, annual seasonality would be "1 year").  \cr
\code{gamma}      \tab The value of the smoothing parameter for the seasonal pattern. If \code{gamma = 0}, the seasonal pattern will not change over time. Conversely, if \code{gamma = 1} the seasonality will have no memory of past seasonal periods. \cr
\code{gamma_range} \tab If \code{gamma=NULL}, \code{gamma_range} provides bounds for the optimised value of \code{gamma}.
}
}
}

\examples{
as_tsibble(USAccDeaths) \%>\%
  model(ETS(log(value) ~ season("A")))
}
\references{
Hyndman, R.J., Koehler, A.B., Snyder, R.D., and Grose, S. (2002)
"A state space framework for automatic forecasting using exponential
smoothing methods", \emph{International J. Forecasting}, \bold{18}(3),
439--454.

Hyndman, R.J., Akram, Md., and Archibald, B. (2008) "The admissible
parameter space for exponential smoothing models". \emph{Annals of
Statistical Mathematics}, \bold{60}(2), 407--426.

Hyndman, R.J., Koehler, A.B., Ord, J.K., and Snyder, R.D. (2008)
\emph{Forecasting with exponential smoothing: the state space approach},
Springer-Verlag. \url{http://www.exponentialsmoothing.net}.
}
\seealso{
\href{https://otexts.com/fpp3/expsmooth.html}{Forecasting: Principles and Practices, Exponential smoothing (chapter 8)}
}
