% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fmmcSemiParam.R
\name{fmmcSemiParam}
\alias{fmmcSemiParam}
\title{Semi-parametric factor model Monte Carlo}
\usage{
fmmcSemiParam(
  B = 1000,
  factor.ret,
  beta,
  alpha,
  resid.par,
  resid.dist = c("normal", "Cornish-Fisher", "skew-t", "empirical"),
  boot.method = c("random", "block"),
  seed = 123
)
}
\arguments{
\item{B}{number of bootstrap samples. Default is 1000.}

\item{factor.ret}{\code{T x K} matrix or data.frame of factor returns having
a complete history of data.}

\item{beta}{\code{N x K} matrix of factor betas.}

\item{alpha}{\code{N x 1} matrix of factor alphas (intercepts). If missing, 
these are assumed to be 0 for all funds.}

\item{resid.par}{matrix of parameters for the residual 
distribution. See \code{Details}.}

\item{resid.dist}{the residual distribution; one of "normal", 
"Cornish-Fisher" or "skew-t". Default is "normal".}

\item{boot.method}{the resampling method for factor returns; one of "random"
or "block".}

\item{seed}{integer to set random number generator state before resampling 
factor returns.}
}
\value{
A list containing the following components:
\item{sim.fund.ret}{\code{B x N} matrix of simulated fund returns.}
\item{boot.factor.ret}{\code{B x K} matrix of resampled factor returns.}
\item{sim.residuals}{\code{B x N} matrix of simulated residuals.}
}
\description{
Simulate asset returns using semi-parametric Monte Carlo, by 
making use of a fitted factor model. Residuals are randomly generated from a 
chosen parametric distribution (Normal, Cornish-Fisher or Skew-t). Factor 
returns are resampled through non-parametric or stationary bootstrap.
}
\details{
Refer to Yindeng Jiang's PhD thesis referenced below for motivation
and empirical results. An abstract can be found at 
<http://gradworks.umi.com/33/77/3377280.html>.

\code{T} is the no. of observations, \code{K} is the no. of factors, \code{N} 
is the no. of assets or funds, \code{P} is the no. of parameters for the 
residual distribution and \code{B} is the no. of bootstrap samples.

The columns in \code{resid.par} depend on the choice of \code{resid.dist}. 
If \code{resid.dist = "normal"}, \code{resid.par} has one column for 
standard deviation. If \code{resid.dist = "Cornish-Fisher"}, \code{resid.par} 
has three columns for sigma=standard deviation, skew=skewness and ekurt=
excess kurtosis. If \code{resid.dist = "skew-t"}, \code{resid.par} has four 
columns for xi=location, omega=scale, alpha=shape, and nu=degrees of freedom. 
Cornish-Fisher distribution is based on the Cornish-Fisher expansion of the 
Normal quantile. If \code{resid.dist = "empirical"}, \code{resid.par} should be the TxN residuals
retunred by the ffm object. Skew-t is the skewed Student's t-distribution-- Azzalini and 
Captiano. The parameters can differ across funds, though the type of 
distribution is the same. 

Bootstrap method: "random" corresponds to random sampling with replacement, 
and "block" corresponds to stationary block bootstrap-- Politis and Romano 
(1994).
}
\examples{
\dontrun{
#Empirical deistribution 
data("factorDataSetDjia5Yrs")
exposure.vars <- 
fit.ffm <- fitFfm(data = factorDataSetDjia5Yrs, 
                  asset.var = "TICKER",
                   ret.var = "RETURN", 
                   date.var = "DATE", 
                   exposure.vars = c("P2B", "MKTCAP", "SECTOR"), 
                   addIntercept = FALSE)
                   
resid.par <- fit.ffm$residuals
fmmc.returns.ffm <- fmmcSemiParam(factor.ret = fit.ffm$factor.returns,
                                   beta = fit.ffm$beta, 
                                   resid.par = resid.par,
                                   resid.dist = "empirical", 
                                   boot.method = "block")
}
}
\references{
Jiang, Y. (2009). Factor model Monte Carlo methods for general 
fund-of-funds portfolio management. University of Washington.
}
\seealso{
http://gradworks.umi.com/33/77/3377280.html
}
\author{
Eric Zivot, Yi-An Chen, Sangeetha Srinivasan.
}
