% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predict.ffm.R
\name{predict.ffm}
\alias{predict.ffm}
\title{Predicts asset returns based on a fitted fundamental factor model}
\usage{
\method{predict}{ffm}(object, newdata = NULL, pred.date = NULL, ...)
}
\arguments{
\item{object}{an object of class \code{ffm} produced by \code{fitFfm}.}

\item{newdata}{data.frame containing the variables \code{asset.var}, 
\code{date.var} and the same exact \code{exposure.vars} used in the fitted
\code{ffm} object. If omitted, the predictions are based on the data used 
for the fit.}

\item{pred.date}{character; unique date used to base the predictions. Should 
be coercible to class \code{Date} and match one of the dates in the data used
in the fiited \code{object}.}

\item{...}{optional arguments passed to \code{predict.lm} or 
\code{\link[robustbase]{predict.lmrob}}.}
}
\value{
\code{predict.ffm} produces a N x T matrix of predicted asset returns, where 
T is the number of time periods and N is the number of assets. T=1 if 
\code{pred.date} is specified.
}
\description{
S3 \code{predict} method for object of class \code{ffm}.
}
\details{
The estimated factor returns and potentially new factor exposures 
are used to predict the asset returns during all dates from the fitted 
\code{ffm} object. For predictions based on estimated factor returns from a 
specific period use the \code{pred.date} argument.
}
\seealso{
\code{\link{fitFfm}}, \code{\link{summary.ffm}}, 
\code{\link[stats]{predict.lm}}, \code{\link[robustbase]{predict.lmrob}}
}
\author{
Sangeetha Srinivasan
}
